/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/PassphraseDialog.ui")]
class PassphraseDialog : Adw.AlertDialog
{
  public string label {get; set;}
  public bool first_time {get; set;}
  public bool nag_mode {get; set;}
  public string passphrase {get; protected set;}
  public bool remember {get; protected set;}

  [GtkChild]
  unowned SwitchRow use_password;
  [GtkChild]
  unowned Adw.PasswordEntryRow entry;
  [GtkChild]
  unowned Adw.PasswordEntryRow confirm;
  [GtkChild]
  unowned SwitchRow nag_switch;

  construct {
    use_password.notify["active"].connect(update_responses);
    nag_switch.notify["active"].connect(update_nag);
  }

  ~PassphraseDialog()
  {
    debug("Finalizing PassphraseDialog\n");
  }

  [GtkCallback]
  void update_responses()
  {
    var confirm_valid = !confirm.visible || entry.text == confirm.text;
    if (confirm_valid) {
      confirm.remove_css_class("error");
    } else {
      confirm.add_css_class("error");
    }

    var can_continue = (
      !use_password.active || (entry.text != "" && confirm_valid)
    );
    set_response_enabled("continue", can_continue);
  }

  void update_nag()
  {
    DejaDup.update_nag_time(!nag_switch.active);
  }
}
