// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception


// Copyright 2018 Ulf Adams
// Copyright (c) Microsoft Corporation. All rights reserved.

// Boost Software License - Version 1.0 - August 17th, 2003

// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:

// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.


// This file contains test cases derived from:
// https://github.com/ulfjack/ryu
// See xcharconv_ryu.h for the exact commit.
// (Keep the cgmanifest.json commitHash in sync.)


#ifndef DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_3_HPP
#define DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_3_HPP

#include <charconv>

#include "test.hpp"
using namespace std;

inline constexpr DoublePrecisionToCharsTestCase double_scientific_precision_to_chars_test_cases_3[] = {
    // Ryu Printf d2fixed_test.cc D2expTest AllBinaryExponents
    // These values test every binary exponent.
    // The mantissas were randomly generated.
    {0x0.63b831e8bd9d7p-1022, chars_format::scientific, 765,
        "8."
        "6673155601518373204745615934992065170006880827787289636461039456117181014435225731420739682086431846196084"
        "0559717761976781401452617612090003075542930260777812518669659241729724010681746641686623499848468215594968"
        "2021079153402945471922988971873909012440740220527800911244244822910902773084448896950002963160859062629660"
        "9882885374947604962348974323036144310657614326754120115556509383797380330234783520222245524583876671362471"
        "8494080431858617260899963028423305531253945552260335123939000593240656910669298632181747412649714974019858"
        "8356285761402581880926947783051518340651609793980053160313425027619711896255545853478748493923212623215309"
        "2624291889535798750202922731324119623206905408779063259071595105183391812893811664489504206776437911230459"
        "57647264003753662109375e-309"},
    {0x1.8777195166b0cp-1022, chars_format::scientific, 764,
        "3."
        "4024962888548891870780380223721963415936057267215768489022880931036340709664117046765987977180526441192766"
        "7980233377849338161398396361988635343561859686478002041658296279167269633549887180398681467085048366045915"
        "6676370951509663121515851044197786647785688189698831775149285429703757400159268959324595109001459740108998"
        "7064349011889817819942001416735892399032878298656443356501797788246594163297203747575928614864543561706962"
        "7150190560661004463760153276800654567748203691908193307868018274961903878508519765463087823925880361092267"
        "9880731846129559561006152326978128322135743176002677808113397223361200222360522182681889723507749332427973"
        "2240457324020870731250050608330505053074385990942209557473057293561320028309889744618215584592846312261826"
        "8243968486785888671875e-308"},
    {0x1.4668b84fe57a0p-1021, chars_format::scientific, 760,
        "5."
        "6740958740641631511384384536776561146340227260577357930980504423887626489617571637837441488031383754955785"
        "4086594144651757106826827082053224819137614951757164822186954713633389739294124192094600295957101411513892"
        "2292227756567557970015697918331549646091513808709325026828267412677470869412642816923726953169932993282696"
        "1970700281786004455171108499583392239457705199245309170122601944018148603634684132173289075939231416021795"
        "6773831481083699810908312929539145137356475139290129992626736771448814573026906644585538148884867233811394"
        "2395343914793125973137539097252903908512233824086968776157212299338375466427657302566612718734454791559738"
        "4296829871117558203187275819525974756928809649794138442664770396059164903717939140888326665645990942721255"
        "123615264892578125e-308"},
    {0x1.befe59a615135p-1020, chars_format::scientific, 765,
        "1."
        "5540526173622352375993445245662683293464994107818202403773732113997242921188175334393284236610673877760032"
        "1140045136930880932847198094667333515588636758849652193589488647628623014759199260062387648516658758902202"
        "4414313323949909142159529537456605070198347779192598243095403947592025125119457352938379814319820278343589"
        "7747302961203036640889656009214261792160762451937044526624584298357832777585944388632200805521152515342330"
        "8561170623085034646351360745189671642589380586080254484943279473962393703949926697788378603146358212695781"
        "2370158648390166491038532530966495890940486561351377873613480311323741789526145720019072115667475187757369"
        "0752588227109741861829975787681759234538817712508305395458670019301186211951459779169503264140139719984290"
        "42287170886993408203125e-307"},
    {0x1.1e3d1ff2f0c7dp-1019, chars_format::scientific, 764,
        "1."
        "9903200051351428805615989243193127044770722692702459361378399559534652305451954151277557670839014475339478"
        "2867837696288408273532724825127341865493665067774242606965035835847639336549731232556074151242689053806547"
        "2696077887804553644884150043878406627507745699995507099147377175105877153481526330603572499358626260756240"
        "8161745031548857838580407488540228220931314580542710929232921821435828527112974792024775296802861545460264"
        "3826566011906669643593108259028344252667022294947897471948646741545397199053445447059963324528762468428056"
        "1552964343633309851882307590384491177630806444328543647075668536514853052975155234251635207407297067719395"
        "3884058314203115240012536217140219386138413382468962035052024511938122187739312695493269084190401940759329"
        "5909464359283447265625e-307"},
    {0x1.6f434a1f8b19bp-1018, chars_format::scientific, 763,
        "5."
        "1074185390468469270473736828301327180750062564436661993518732867820414412582796763617494622074841605120794"
        "6280001513512476415260093780274458550261745884171770589710369360980007788208880420310179065543732589777800"
        "1026322540349851343686142888941809812697130982668148593939074359425039990092398040350897342987033684062247"
        "8891910045787038724069756928395277953670595630959968898874335051527496681463133794176157145807591872109216"
        "6144382506150797267436509897049656206429012398091894503972795298016547064662347920285527872288390895517604"
        "4191810941642460040564082188712438936906291867000270523960550332664002210898302673308442754015967789648657"
        "7199640058529357006968235192644651239960321968186374102417320609944271040560945042782563241257065556055749"
        "766528606414794921875e-307"},
    {0x1.587345c18153ep-1017, chars_format::scientific, 761,
        "9."
        "5803415071347647865082718369266434040574270026977809712667208404792036119580302875847883246591206937429220"
        "0765720124757014325334439209209434046539893719315938780007431549634993916215217605362262858269407426842334"
        "2012580732514751221293610595763003495795061946838666946253209134456556726989193259291618902375718355472162"
        "4042439056845036040587911004852089800421901874454407994337108163738052947210061561024263715054967969591411"
        "0270363560682828986102429968210287319178363269091390190666341835673642784686119809160641359798630514658952"
        "9621994975436450348729144771801748911075356977674248196373371459254492612305520113008095746852968491757589"
        "4312232673600164454503147125519469744188854742689367713126583601172208920773079707158131901323372403567191"
        "2133693695068359375e-307"},
    {0x1.f1b6b87277fdep-1016, chars_format::scientific, 761,
        "2."
        "7686246461533842708986290401534510677245449052480438452772935563477911887903937433332521175778793903095384"
        "0412239557231923283555660292437990927601776574893980601557250737329754310915661825472040213756951830291482"
        "6971556169842700521540676609741125857389706633023242364855348478771230295850829291438723530923932923590702"
        "4151611338319751130631733719608246390666274473865694983392385750305737090058291815147877218349104719543513"
        "7063089136683774947602824936693432977762482651171413713941775960038695919756102724251419600380177635071493"
        "6245861443988258956704733318591666199586331239518529031729048520377213164363192327716960117074516227535950"
        "9369132897727641328747183370449707056957130139385301002356826323260325258247061322707666120024327938153874"
        "1290569305419921875e-306"},
    {0x1.72a498409980ap-1015, chars_format::scientific, 760,
        "4."
        "1235396742477088973208679969440262899254505285796142223814175822702981218018251380021070120502969772416262"
        "0356011168621659532952906006748436531426296108744371485218418489239052308056360753777114430810169989395269"
        "5946140077164320660032095927443769046869340226546265147500705839457828617891438915581029354085740892509908"
        "6126202065003470601897807688053820010379771148507245760602767529755342564783534772481563133530608872155816"
        "3170273217810752940595356441071317848377916852111771962558733789348917288503698641911641096452799678633118"
        "3241428470038337938910339876846473513908343996450852057201827354601830122948746860487681564435359569830201"
        "2244034576878689343471222581935495027065359114155162611459186679259780987690986908851542569465209453483112"
        "156391143798828125e-306"},
    {0x1.ce91e910d066ap-1014, chars_format::scientific, 760,
        "1."
        "0292523314007669232638574122959890467082535280831773462781705248559642874893726342757936877737789465732731"
        "2479354581078416852016211748037289062294153412444887077225201260286873016177402040776581672627422105268655"
        "7419196324208471582119260101560948486357037365510139379540004408308132593738795998437771752956709763675038"
        "3014741316553229608555779896363377365729952793542626535019308363767322768135329791753783704045210472287174"
        "3258998969100598727128250967239986818240346849429624604806528929509814942265446828862812886192478721784982"
        "9763922746869649849450345544760606574327399799533824584266016235963525049495453939501167672500218822286450"
        "3213932415104343443746664957043752138584117730581730514644229269575090721314998575865173879861913519562222"
        "063541412353515625e-305"},
    {0x1.a41cd0fb8478fp-1013, chars_format::scientific, 760,
        "1."
        "8695629667714589591675011459069349152361779084993905567488662819408615881583054005738477193311059902345076"
        "1887740398618582452621943937695612634176016332254849337060923845633060080657730525723232050132901795302428"
        "7747627232037457266368651155516174545033578105816636548996204160600146117412245796293507856944957146706304"
        "0254113362718627037659792095227781184269228376974078923485650054103229807045611097285162062152946597899434"
        "3606420788243552352751894800076450567507229035568346316425077269088928498850264418366552561657569635100768"
        "6952407174842753490576669187086405946186033731473973426151694416850707500076337061041599563960687925311368"
        "5553781567772169884961236205927091959675967933403932478188107975984517174399812395983733193105535974609665"
        "572643280029296875e-305"},
    {0x1.3e41d54eded4ap-1012, chars_format::scientific, 758,
        "2."
        "8325827575460101051539146153659554542949953849899101704093223118334282451264669960468445814674273734277278"
        "4980027834494082685766178127629247208184380986441039452161190285373582999883474215846885769779038605962665"
        "7678189248144526566294279581606276306288020536846141644176497881789932815661474116675442020743817107419678"
        "6033403238981156288307360202517295738237238234044693827210253447256461636044859195631301675170218334495437"
        "1143800460586565184398113067165957481092210378398497900972951098730107411912334069394868562044554181578968"
        "9681881384571986389866669746565242803754572930194362570076270849264642814287648059465115948199864438616530"
        "2340702226649342072166051234769942192131532561249089789855476072421163114219198973092739279877605440560728"
        "3115386962890625e-305"},
    {0x1.59221b87422dcp-1011, chars_format::scientific, 756,
        "6."
        "1435754675809883764607389644039122653481643689751494279548380407226734715556912511959558049135199048091303"
        "4570147895374919927596970561282274649091727304992573536378826177765491606914330790712251813627403807741060"
        "3228952574550189497787908659493137234313533520312295234438706051770280882165612147632789337287128790236358"
        "3684228396504255283710239792217487466451145359639305211018532224666776225360631707573627254298962575843632"
        "6997585642760239301816630363203045431540296803267094601248551668127076407345103299971987320334913146074020"
        "6557039826594483610259885518699987425238236440286961754514953182564652960551764735240281677725263789812661"
        "3360122856215329758437263182035107129113790998892977867473178270734270283430110068390028743579023284837603"
        "56903076171875e-305"},
    {0x1.922a6e54c4bcbp-1010, chars_format::scientific, 758,
        "1."
        "4317575812076783279096962507607344781067968670789399357106075957085731026073398561781473029430115436014229"
        "5042738269957197194482263497390666912499621452236468720067330567331779529652769510718792075605208255229780"
        "4453598386016350631514998361352765835015287841808273033244090798155636616618100736973069441228252750043602"
        "0203687243042317304969036116006867635224978070867606390602657909489556516702811707764895990014055554819168"
        "2970313452199620495617335159702746235323083593453065072144972997529670760566203914519278435423331980290138"
        "3227718965593270032595543344712007425459523297691036565265412105198702522141620817697556902837198527180570"
        "9506606910343882865250484528903431183126572403711830756908976441373889806932772055664271348973670683335512"
        "8765106201171875e-304"},
    {0x1.072696ae9ff91p-1009, chars_format::scientific, 757,
        "1."
        "8736954404407842914371682565703603275065764259885958103791820006438214075779341036606769350112633220313924"
        "4013286873373278194295713473289353980269648254008823511740795625917107257638613508520649307128393978192620"
        "0705468314546127800658230827802488328422886555037223958144179314615586216250084158766674880816820412018646"
        "3506557142633404052761483488369917577746023162650582898107046603525443910985220071389009387344317203213496"
        "8788006389079497093133715393761312169804834914967830608316141061423753171621552752239867268985731345293183"
        "6000009671729651430504379359358929467240989725060006847711032116813580555184077897939000848084702416809622"
        "5624812892285306182628743961866717634410103283855733573331697661905063280118823205999678549460440990515053"
        "272247314453125e-304"},
    {0x1.0f9b544278c4bp-1008, chars_format::scientific, 756,
        "3."
        "8678085703767115679707960176797382475896222472846518711203204581057046445044323572045619149527021471033513"
        "1037742529492665225855291158606504096304763954369359355075134749682657763340277193897585554908876427528122"
        "3404237262544370036021050362028274509177214367131685009066980529198965345188509320693984189852122869096724"
        "0307762668804484986822336109648123529928998213973332360935499253090321992465599641371421976527675643722147"
        "4818553028447896343622184778775789582470210526709724599576515721933721910757383142738726001358720616381592"
        "4229271802232530916741889867942756272048490315195062592530929515848282749067855559474139733793821353946484"
        "8445188615771182360486800621802327201033747158405727472729308966998705733027858963413159187894052593037486"
        "07635498046875e-304"},
    {0x1.0c159c101694ep-1007, chars_format::scientific, 754,
        "7."
        "6352975143049522614438211587901154588102399522679308870720966934866278134299233303209132483254882406877024"
        "3032314978411326683785882828449889576731085199036357093879916119191477548962018450810436368437123537879171"
        "5398901706373669321385471295753589758753964662654457905715120673904659565201490447825557005135025380834617"
        "0283527824311975829475393389338044032315549305419642372717127492349123269421393795189501093425583277951613"
        "7482472996690706456618658477990379299062555451161914006646917062753813072403148854358191467247380141960317"
        "4369718591349917430634535930397154004116848462943127209818005654101392783570316361193216938245623206104415"
        "4092104891133848306373809820626535624355866825082456994424052303706479922855952791049816141821793280541896"
        "820068359375e-304"},
    {0x1.5dea4ce8e9d1cp-1006, chars_format::scientific, 753,
        "1."
        "9931833457401843380206268213719062063350814301599018679933261580130337290316898735876549592164313534803701"
        "0367716961871843460238736763173540738894631496044341513014086769607675313389734660544429847137223449237368"
        "1854732828188990763143676913549798050111000449048160356662711177445920457729101143615093098470889673928997"
        "8721590778489898585846173250830089770352087321756188087231770443888379781496362819885950130996391895508049"
        "5967945265553649325413439043352821440085193375901604390558169700922107887759422298045475048448298435182127"
        "1529249898671025481762571674803699881589864389977475085144039107611461508367830308205819849065857072705384"
        "2544909780275364598179935132913048405234257751121414962140712577875960000639218860918333575682481750845909"
        "11865234375e-303"},
    {0x1.f54052ccfbd85p-1005, chars_format::scientific, 754,
        "5."
        "7104439440441903852943648577406503088003161021002627368323935629069966209695533414405887372311247087423593"
        "9781943349661969952724399972643565145643565596680341154191365245563840621127630622979641166875699011127504"
        "8568462104925391744823983638657336393276468809438060554239207107070390674319071138242241936104300064142641"
        "4253161862928768191727964756739054251002351820210559683067678277426478312879053806872980671807735494036931"
        "5976069688037470882986462600191569302988629020903776604825882710768551646760758983546554323851915180357433"
        "1464966657766198572115325587926099638392334145329333710974022615959231083135651027696907010536501610597578"
        "0684355323209040588603358187555694328693197982659012778489710933784939697285300275186870067045674659311771"
        "392822265625e-303"},
    {0x1.0090aa3ec4669p-1004, chars_format::scientific, 753,
        "5."
        "8457732298371823574823131482226670449533326157358746716791953135062569212292668611641801097780408195948596"
        "5888373447402064062727322207217975101640660738989340741657280509189289276615212047497934355406431806641278"
        "8478834023123098163293513531622437049966284424578880391547670271754853142196587321184864022163506030620064"
        "2833463853585974609101781931276219629563822287439933439020777086511705876102130660051067922171320065746506"
        "2465994749375713082577376195362056859759924579898568161899707504166498745404902069366067260964218815046333"
        "9524113776506291985183641972212962838327237136002597053343023166906014203406467918165849951752439662675714"
        "8515684537136969992272393011690298548643680023668422526561162499435912606954648951251840571785578504204750"
        "06103515625e-303"},
    {0x1.68e98ac55ee26p-1003, chars_format::scientific, 752,
        "1."
        "6446596413123795549652277705330359127501949597887884484643611330088026618345889007411448311200165299004153"
        "2139330705876914793120460121891845777978753428196824338319708537694880490448415548357571084171954782371013"
        "9827936080983236731056925429888897928508247060002591227377665559607280147694385759161472019199431022048753"
        "9252764806264502002388852086321464182435389525557563807453640035300562682385718848951290103132751234367433"
        "2673547866665016504944648849864967346476782260339605421755639569644367437952386484883839418341180039062684"
        "1460528189649358085660200495553016137618232436443335627143917562089955116648923161635472084978246578377486"
        "6022112969364460310239797566964913160076166500253272495540657636319430742310315762821915086533408612012863"
        "1591796875e-302"},
    {0x1.87db0e29f0009p-1002, chars_format::scientific, 752,
        "3."
        "5713345155797761761079287822950557022675635846989691191937710506813782658682864940472796826062016923286770"
        "8166475001047504811177502998554808270085595314612727547047624036293060053880752125848194352774957680860559"
        "0290184599616254184674980579084610532650542277059343477381901087349157002708882523813589860191819919463864"
        "5572473742585546004235957997477845885941869654346021359209516817462476983259862602002508582493398382630013"
        "1126260391727473707770159740877054653682600781506186186387821934514680593847124459886451259056737591228212"
        "7533791281642861022630716480368525884787242037112467446408232606412304327122490841829569553119141625758702"
        "4691172442399017515655247762428343915640594942453182541456052819062032841011117278995357082749251276254653"
        "9306640625e-302"},
    {0x1.1ebac54ed6e41p-1001, chars_format::scientific, 751,
        "5."
        "2264507616884437569805809040739207336366694095277810554730657091293085596388058781521598800524476996130637"
        "4980627154903920257708024997792739202136400792180949605152479609662491266228594913712258572249852752399855"
        "1285095014756776289555458879942755967386577111803668209714736832027600164037534380000658070281110020332651"
        "9987841007167969298905049974104357743571558147007766635477857992855064039069143805060571043111052222533607"
        "6906939348214560580910775118826868200509986914895110839876152537097330539855968230909381107897375007290398"
        "8378385138191514671010111525187054811597159710392200991099127775914461518114073763353708106827024513399075"
        "6049414344541691511157350304779944771415413564368359181745069897590897094359629893034480119240470230579376"
        "220703125e-302"},
    {0x1.26d300e06c7a2p-1000, chars_format::scientific, 750,
        "1."
        "0747997253788843490025917088317140149354267531941831543005317538947117106260486277259597702417316344843162"
        "7823155594400408640689601791632312318793792452277700217881375008551777955008479104306751684583798640011117"
        "7331237195678228062266622507530803180421764933136874457770345473896308774311676909174769953465658733136531"
        "1730646743826073699550122831792121293574779463809583658915629548187457141074175132979644912781434112119879"
        "6449732242461849927674893802726574013367315709379237708819341288775841440380509951443158447860262711021202"
        "4512841842169839736663696096780505831114559890703110871001542936248745358663880699070477580187175555004706"
        "0426293407222477239023776188348421566739034336984800207756080926084740452888799389086216251598671078681945"
        "80078125e-301"},
    {0x1.05d0c9256bd0dp-999, chars_format::scientific, 750,
        "1."
        "9089292620000501462461091846419476055370811043243200914242752398813586917946117117276706450408017538758722"
        "5660390310015790741172721365183864329136645491654476508380946870544854973961644577246381082657250286554378"
        "6724684318613551976033658170744074959929074525489851922078469090207322060182315897761166701384940345796648"
        "2390692682550639168953244522694274039612474765568989798173496674976754209790799304541250614878586316185908"
        "1832434850661741938378087947299281921587249685730116526155067127702638040935609007598196903511226053833394"
        "6368989549925329930627669708876781138383078123518967695199641472080864590952079516774516291036652778177765"
        "9754149721554139538144541534629568996232451758594381806119602658917928450846290822084938554326072335243225"
        "09765625e-301"},
    {0x1.d161118863a28p-998, chars_format::scientific, 746,
        "6."
        "7862726827637822308383819837405744625386270069383303690107600052832104729374686176902718298036439556876536"
        "7007835766438473158503573341233420991356741827641046279183540631203113336246661546736423349686499782037093"
        "0641229855313759587426623336318947131414886263684536725151767642125347109002448147389830994122526274370789"
        "7617018358553974800233291485285224355118796255276967020647450176078219330437486876008901717954573383579099"
        "1047714288626185265103482007250812237430446740002717533482314627054425459382273947022327354496010149857916"
        "6998179831269447169218862728847291808670566291805820903410461158893419653332870539994687457679135320191821"
        "8210212370421266288662389144108768187401712413790015232870218865309040051636557677738892380148172378540039"
        "0625e-301"},
    {0x1.a15ea25a19660p-997, chars_format::scientific, 744,
        "1."
        "2172372613102280993179252931186926982692345919033968631102111765103315033304380176933385417160002408427950"
        "0295470238003737903138964229170029641147550066555294617444125756680352014437431112856968897249350959816759"
        "2236046524827959672222373231938825328608517533711548379199837592813292143627291147239524233411932374697495"
        "0076147620325900633348562563414895932402962713954954623414922689851738589686706046155327824502166704335474"
        "0483802830489519355136211942835589461562419698678550112002073553337267646181096609192841991425028505763676"
        "5310643658630077974934313260104372537119221193415761606516937805300536262521389430432123931165919988196641"
        "7445153541195275166274485974787587695265918859779451904129303848765483730964831465826136991381645202636718"
        "75e-300"},
    {0x1.3405ef09605c0p-996, chars_format::scientific, 742,
        "1."
        "7966676643662128335665392247768118683231502978059871166650153469309831612890500966882039821861868400342764"
        "6561658712020662099545587837211036370546812947350494432238004683763664567568973440673650283854843511596346"
        "3698442719535496115538726433986266863862950537061969082882291651460484133576667255869437876496100220690327"
        "1627540775195602113421651211440307831129924696845524348946549788527717960851496934136922932274256932207250"
        "2504730017520700249939263105447824182001422269657481368614500917398558972900508936492536325012033905462034"
        "2733517067914324213319731475850729738988853204799698138245429919661266017564480782965092181767914524772807"
        "0114038343552765434718432890065190765206137218078347442517180856079439532635433351970277726650238037109375"
        "e-300"},
    {0x1.d446d39179d61p-995, chars_format::scientific, 747,
        "5."
        "4628196945287030878864501228515552805464723717056197760606756889643903510249553048439017711133773671440354"
        "6393863354679463635258948740705694069667341257396888036371466715243466156053378293733554928216028872449926"
        "6270281940200034766664065924797146527366094882988718989577228548661057271640470276933597886851166967309922"
        "0490286146185662487877704337685653857174654805590027514341847429667755625338708736633025559983835650906911"
        "7082144597398445022686629737262804848201604027875209019963234888348727732753557137541010501446542044860603"
        "3076124889789498045902945493217533531235155103049453504888178998390271594265142786559200789840036462465329"
        "0699411376938730047962082755849242672666320969811738379369429636779305695104547169194120215252041816711425"
        "78125e-300"},
    {0x1.2a6191841a2f8p-994, chars_format::scientific, 743,
        "6."
        "9617062487220514621989094015930584333539423148144476551620642624680348776495275585358068724521997148409410"
        "6383911454657957927017181245452872915474622111096382221071681697520914214818303865707205751044498351025044"
        "4536884198365605166521031955111219642419220298954347889214534531094837790091823656984057353139300007125800"
        "3293035204706020167948760755422183994450699458391794656901738793039684960506013257067218773020004462578765"
        "1439009842232692428211132570873279618568830654102695286917053708082753966210260483718165254879075265420369"
        "8658797634666096444025144902359009191385276894101485935046230814418030394044362489237345080002513507196221"
        "2292725330139318787534438587025433685744672341079724930282999161273299604246744820557069033384323120117187"
        "5e-300"},
    {0x1.43dd16d8c3d1dp-993, chars_format::scientific, 746,
        "1."
        "5112507155402444702013530602239356519676208975557545662433849515130820968525645380967790058631717581998946"
        "2383489016678007812825705103181297543850063798852533579279995518512249438119478194724227415435927609478553"
        "0478989334370229123257813332123709533239479541328383215098833929934144690721346831873831758199105011512667"
        "0141483262312008742676060289776355889496425001520922157519067534910344942859758756256865735756093457144432"
        "9997703898734942358076870125601377536544377173388533764111459177194183621681873341290551265610317343464385"
        "3672019620647251124865042369790323166084999111485707852379027804775884480582808977213872674467521399597635"
        "5584951293948756727528587090551401340178932148867448233676410270702548249710517325183900538831949234008789"
        "0625e-299"},
    {0x1.1e84f4437de27p-992, chars_format::scientific, 745,
        "2."
        "6739808737490122536400919026942802234689576692371479366784405643483990062433008551497319332426200403535689"
        "5030064921783009805791888470580796419933084847761281293880427379962271237851947800328657537013648988481294"
        "9516962024244211760960748336098090994846015649655386170552493311162069257719900379903030507008588526031419"
        "9767588940990499498807868924298521846143186141665068730082632329712887735907185105610033092499947885537087"
        "2777021779956743000754547833513581633478384242279856707134228104860925927074204711269107333714275775531468"
        "3776136264937390122187354227141214309429715495082890329538893471744410403270954316441211712985000610177269"
        "8944311067042059526539301195418948431941957516625083848704359299592279997082044928902178071439266204833984"
        "375e-299"},
    {0x1.c7925872b0513p-991, chars_format::scientific, 744,
        "8."
        "5033691573552436743032359501867675425844556882485721384874628070407223682326838306017437077936494642893855"
        "9999659947344275015058137995788308286051472366936034180700376051612641241581279358969439631011755807941264"
        "0180009205258501662816829998856768170023903650537160919301714607898859451205817572487894938437883022633598"
        "3376290822291404418924863244602723542510196397911516919435936905242919732102909562672293761027406048075865"
        "7835985167284620389463467848900582426969335519962264577071777190480699878841459712168172042966775236944743"
        "1326712331419045036441427176290319828551714549495813962256861277779164177883181431486896646293602751921197"
        "3383768944719374984215587270106299004243931703144739402048268194422506183194343520881375297904014587402343"
        "75e-299"},
    {0x1.627c15354010bp-990, chars_format::scientific, 744,
        "1."
        "3233106901096892065379397808572390395445480166333342374132370300121192775365256676551830867982461560404647"
        "3777896550467847979014748844578467275598314335113075595369097593300537485855884838260655662363690589028654"
        "6498407090340200266273232047853174074580694696818844330785856152531370577370227513485232394640688728493031"
        "1135847573135818241585024900463197122494596403199246606733219005485941416655806006702981687133567159445266"
        "5264784897912598384678392200864189243829386425598374397938130908968237282949373565710105887439242496421421"
        "3457126729435160471794471801982845652213879420707161040622898225638702937020553616740975943614118011210770"
        "2980056185861897975475259225613788646834383911028404539765069186955590008203387242247117683291435241699218"
        "75e-298"},
    {0x1.1d2de00ed154dp-989, chars_format::scientific, 743,
        "2."
        "1291789776720231974744171840452344550382511057197936020876953529640730687265974572615745465067992041620069"
        "8777501121683256345606354913401960704423029842081367774831586751504524522776674423749062780692170748646712"
        "7042943546561615399294326604589514550653819458352282966533750051174678662358361943789708146595937329877498"
        "9140003486840484348673799695074315983476709436945484939187203715033177550788146372453950458146622857219661"
        "7273106008632520237983276624844623210830411434978194668918585129565128333659485382511336320510797758394849"
        "7066534832654912056496337016989948283722604021746733182517415331234370695363197261511199956180205135316943"
        "0561914971324547624168015418679749304199862313667091306116297604131976095587219788285437971353530883789062"
        "5e-298"},
    {0x1.17d753cb61bd0p-988, chars_format::scientific, 738,
        "4."
        "1786486152355461374776858263541260614950495378611306967856664376317856708608093736614315389654405332780988"
        "0689426945941220120153421904054106863117496760957640139892128130420227762590755039729804157834222703199862"
        "8589539320999048052554586101710114818979133947966212532305905925289774542948861040799079637308077821570870"
        "3072502377172962357928714199868899047024282661076090342274212069139243739604752292552932633409518449469092"
        "3515593099815763625746247415708072838144287073191379829134836259189096560570733143915925546748005565580401"
        "8976745664144920158206659169946960403857699609960069561793275867483380048607554657047054862232324598082497"
        "358302008075588962346666145156130842715967918196794561008886211006529975975354318507015705108642578125e-"
        "298"},
    {0x1.3499cf58eac56p-987, chars_format::scientific, 740,
        "9."
        "2161893778403732513862252343445239008981140568922643687663896941163644334084345821330989953720210499840621"
        "9160441214807915624700581299217694372147060099730582608651734963216528832267933134373355153359342883308274"
        "1031301445760468599085716685646380991547104769050790451044679611799053816971826590912754216056544099398818"
        "2528853848068150300509122056753832693713094307177084179547175302766171211400043481645401436905858815277797"
        "1778893603240997534730307040753686951999518274826840134999719889934188564885663380751476200671715491306522"
        "5875510502534842446581576198070129986491767883536217287215961728669453640209658291317958839138963689034141"
        "88789632715887110086986492180657573226368342685188914874974230699578026104745731572620570659637451171875e-"
        "298"},
    {0x1.51a27e8a8fd04p-986, chars_format::scientific, 739,
        "2."
        "0166542228894893663309521343065653027086245497896068869059180976583615938098889986991041485859172655850284"
        "9231212781790493656064318876082158442840914388695516071513871282541627904960007529256925655758366238004656"
        "0935056627139456537528211198364194749602836764902987565025944221130708673443828163387359505375370290009445"
        "2745724436276139585419606556712353250612586551744106137528572254128169189469681750106767803119244277794048"
        "3750210471579159462599857421379948439622868937356578266959909594120741362514869852677384097257555841840521"
        "5236796758338972388174626883880522031537078122191460297407274783067835677391633127317778686117811785197733"
        "8577887683038299362987414194915000779858380976854620285433129268926055743804681696929037570953369140625e-"
        "297"},
    {0x1.28c16b4ed7098p-985, chars_format::scientific, 737,
        "3."
        "5449747515908893859520264700887688271107416558032715906653570211101157114219987495688096790234026558681710"
        "6753141856950390441673389046891140333791267175538211915142881836447148902272897131242054424760323762734875"
        "4141190178165059795776451057876420487228094750780831495237996530558044233292884300493086993773653449202457"
        "8818090715338972401729596065603472996108834056777416770233084403727965152368376850711830195137130645640590"
        "7046607319098707053806529570935342883620442701491795272567870361575635905003352499512824154974326187486698"
        "9060265662902975470835003190344156534010770165498653170496875412652458097421921303135343195297833828784423"
        "96301612754526570175306033284095638792306713346530524716480707592136667472004774026572704315185546875e-"
        "297"},
    {0x1.519084374060bp-984, chars_format::scientific, 739,
        "8."
        "0649390857434579193115655390618626369629653008353154439327413620740314818119036634456720430925246670592130"
        "2576840115065505875190702262346443580413571712749788204695695123012277087263105239201891820479284533969818"
        "5186455177319075030110798057602091473932084908015034567525286047273421566565922229061651406247462013601709"
        "9678838136927214185461292825117230319532485842557112068939568153450865993280216546928857042166319106957693"
        "5849602489732653894260268826761621079492065154996852043006813295420056272714448441938250959284349518278972"
        "8109873701528734475851958983525486767921479203821534881357550897232367303129611065194955396175464225609057"
        "0653475980420477041519013852253561174979884533208594899267372506368456441805392387323081493377685546875e-"
        "297"},
    {0x1.bb4c1e678fe69p-983, chars_format::scientific, 739,
        "2."
        "1182119864764602130642094783087206583734941656216310675491273631944013364753704741751950662508914029324838"
        "5386753482217342594034540534307701346332311222871574796733810364341680474829175453754906619121554670765885"
        "5503073696569114420021537616341893639125948726900059561203121631918388786858610891472826691304489021041592"
        "8204921425043137414284707993217579365651624846035324808539913069705011705983388530603140990470370905914366"
        "2429130360743269466709195978765360244654637182808686838641860759085152084357532663577478471344174751577529"
        "0972240748548223967022722809144914777444077303014654296707516764326758858020731632035706253909022691553299"
        "0280045685258559475635362835015005020199131435664704208816162996076304381176669267006218433380126953125e-"
        "296"},
    {0x1.8fc48720ae1b7p-982, chars_format::scientific, 738,
        "3."
        "8204276533494359839532778695795003743446747435092568229275870270753905396609753758094766310024169594340308"
        "2531804530234533427497205555769804527722891005758348613020336577997700742420034577833321799026159177505203"
        "8674621644837883321860447905574589203789932596264453065004201158075133646977415286488731152080905405203288"
        "6266679457055618321561423956395086302343657062006032766471353302180451828901269627826024873174709466366952"
        "2603971081606399156333469955622929484291725938608707418721047578358097887363479034370662134536373850191404"
        "1367247728531590692172129197246521625036149275003013119095905494187761857146715048378242133953612536023019"
        "323048284861285524529772302016446491866534790783641858391019539842314856059601879678666591644287109375e-"
        "296"},
    {0x1.df9d17014fcc7p-981, chars_format::scientific, 737,
        "9."
        "1669699368021086682830030909381357128562123247466233909897185256173290436869196843837665941337171529679475"
        "3554027780942902843142861485494708552404216026343714053469828571423620780701853124085458958213035274017523"
        "3562430379023280135911193419908156405083538884612994163219093960837540940184158271766902246238563881542840"
        "6251457874360114711958891056340399560828449448045550476994666752321648418727132667488079133200123889863209"
        "9770597084200640414102147020755519357329067231460009340640433675296982654429366131186868621479458580681292"
        "8077014517560803574745671039698546093195029449723264978711517158326702241626826015082812354952033962735634"
        "40918968053523398319267275737964394466129772993407912666757701714015382776779006235301494598388671875e-"
        "296"},
    {0x1.14f46f3c4a3e6p-980, chars_format::scientific, 736,
        "1."
        "0587007370833376930716458861240726931462968747989541788325161898554411576600043532117576307710243415965780"
        "3371982184680260925510856439625563819378279886442352941227379220220640407362537154862374128710810114674567"
        "7514478491771437336532301602490071369439129589842422269461377654471657420744038482489238158431343585984336"
        "4112273523714497764911231356847826305616843916838285794259969923537096357742706370960263518594403395298085"
        "7182155015332054436960602985037397127457131249088164023687141746534813653668115686827607828769158632621634"
        "8211661922776018594564117076133002365617217752004182146230232982446412088873912163365353558350257031136436"
        "6418258839009664698934453704098273993991469348626790718931843515715485182226984761655330657958984375e-"
        "295"},
    {0x1.4f1412250492ap-979, chars_format::scientific, 735,
        "2."
        "5617734189585967686818299768257372568423106543272584457448193134718128599177000553291346980043202473956121"
        "2180367126021412392244741193093745572031930603983359883904384447106760541450042234370555490923410636519399"
        "5271125408960594257515760719605036779487548177007694984011771817662329599641936649037337848258202676646918"
        "0324868409975856119135278174695452389974070452340956443806736535092875052779083369995045277193094102198751"
        "7882529396548606924708322774133458177969737673112380202006832077418450022973957900587161535254837673962218"
        "9939870489332022672990844324757213970295295844625265990020341139334420341388520264993199887535744618476933"
        "977079195980768174754058802045425915342354542418540247245180296875588510374655015766620635986328125e-295"},
    {0x1.9017f415ef785p-978, chars_format::scientific, 735,
        "6."
        "1176671633415973759609001711717395696866869599742022471777599404256210233902902155237520408258615349882123"
        "2345052721336844845647017772470586010537618628661882879046216714785572845072040142162072217724152815520427"
        "7434678258158119268340086515696034960671064545207292832947525798713291829364263480267044200323637785949438"
        "8102548829612274498076763793880960706749651498038909594010336103449964450053626521644029697954744301714206"
        "2487861183843172080607954096705021991049257049493594690141603262357639301600484671778732997391911525141831"
        "4656160745439460383763946147928236577727544572145499722938153200720552176047316890086301362717234566541647"
        "151923209709182593285429056144712640551237160829125782371580577478908935518120415508747100830078125e-295"},
    {0x1.96e1ac8ff079ep-977, chars_format::scientific, 734,
        "1."
        "2442918509206014012028953502157484899302248375526922745314229166692585546772990892217496229641056244180835"
        "5613151956891377577895885020022496772410413988317059045245377611213388418239106676765461468848383746280664"
        "0929738154742991672225168441354650138195822558318864938044614007032745608778442983632656067307717276665535"
        "8175666838652658690245143514862764213610885902701104197953459657922797754442670964483945940232205602535173"
        "3747561716472202211817409708258360725922875465550779760937086007766054677009929064967760576046514113812222"
        "3636084341489934911882403581096088174673455142188302497447440448899021951800042462326739293158886225459160"
        "08495285196154157875508821587667877847598940277661829097687051781662148641771636903285980224609375e-294"},
    {0x1.fadb23cfc26e6p-976, chars_format::scientific, 733,
        "3."
        "1000512351261170557348686264751638282347697441603952716948646046693942464502542196818852403552824031750041"
        "4947458847906837349261846175883025166164806498599908783951915826113591552191892899938026717712946307353394"
        "8255638002534280965595353092919104693493427497172744505685162739090774795106876820569693546699239184707928"
        "5679683543224431856784444083274091500700420703555836987399712520363953870514465047148032607184325622329241"
        "4232090453376616525296057392478727384385760735974124403991028933509493200214488404622950198348128729879347"
        "2514307330004432461763750012676803885387452378858427867468188188241476144860361211975943760433595129660724"
        "0419261927649158173573533413935670423949606511027942182777417112760076634003780782222747802734375e-294"},
    {0x1.c2d100e9fa8aap-975, chars_format::scientific, 732,
        "5."
        "5145996431260139100993467191842543303968665047751359175490329248140080201690655843472208689617281422163505"
        "9465153760311444328611419690134650231524119310940944686897401473972303914830917415065953443301454685388122"
        "8415224134154043819888549152070816439653378310887032225499836821436715596770866662350547108554679082936746"
        "4674575770464713312264697289274394842495745574537422516867037314585991641886069493735438794004631014086781"
        "4902330463154994955086532232557782440079216740709862709191364247832437561527741320374664494632591901127302"
        "6587248425665118907646056283387444873731418111750757745277659752247589518641113946873407135807482894539278"
        "142676044746795852491585953284333927743046282564834512270046662507638757233507931232452392578125e-294"},
    {0x1.47cbd89edc28ap-974, chars_format::scientific, 731,
        "8."
        "0195180800119955218580043524324296264728715452014332332170246674538871845805219648492909707144892198471904"
        "0400825346030529599798793600046834482647444437487683767751220097572919791242799892524698422822978446221165"
        "7237982567495904839900279146786398360818656186570954245843716698894420854352456620438185242918109562666605"
        "3625235057734407156147486304856183344925087301696163775028804963431540984237380150218682479654930440154361"
        "4208533335453633897462326737963649687648265020685474228502202597648554842420403440696183134806821821458476"
        "7854658453964553739423544076630981269681312843563475213302475499714965733582391790622273205357040908868407"
        "87322202915150173415505785588461369367258646472150182028804099587659948156215250492095947265625e-294"},
    {0x1.c4a8aba89bdd8p-973, chars_format::scientific, 729,
        "2."
        "2148549407571021803058758089237874818004404516229096026612875823708185387519711434118448231175696552473972"
        "5514269341594904066527742443470740785459170633244811385112780556696588157177143608961573643126150562761915"
        "6849281750933181906556668480299887622009529190391532401176424108617948387268885330819182146283103769726065"
        "0618579771433274264469131477484276258449987868177936134280895329165600889520845336168357333217832316495642"
        "0441319644683365839431195202310742805276534309836915086270614032968345195613629397653273340702900233535205"
        "3483609729854816729883780272599181867846846521014410520170084903621204572180935977607232534510932678463816"
        "822029867718281826574420236100747585318545294634398450106527178604665095917880535125732421875e-293"},
    {0x1.ae1dec42dca09p-972, chars_format::scientific, 731,
        "4."
        "2091145246438698296464197678858462022320601841030835843206149990791488671059123306883776612699424108754647"
        "6736165489660708158188897653252826134814761213834692117553854271187898625371210169220451412074088885812485"
        "5710541461898075840990354146023487795168820924822425403426146314849307917765992062977805313760286080036912"
        "5671659281747652562037736469615487893495477714687409716479264021912064773034682227763646081732196052572030"
        "7042509474279237735500174408103971978728587499232657269969095263398622200501943268247798636403094152328953"
        "2031147634770203769239297303467977711453401539253419892970190835849736701525053640119980542501565476014438"
        "53999776062961816363960978393038157465241961259638119909054498890554896206595003604888916015625e-293"},
    {0x1.54ff221954c16p-971, chars_format::scientific, 729,
        "6."
        "6739709449862607565675687782920119483875632502307667185780159162168993863980184050971107230906704288464015"
        "6496699439994300838785152866487131226692050111421937130047388309431505994270060996058822819880128635044711"
        "4884254092561109053574594536003321082373236228343853763690520906814230225860764906029592314130816213101024"
        "2194197916325697362693742596076819693587167915078095246529186795090291998404360439137726334573248196108267"
        "0822286777585677288460873248318553492874197977095601357714718256395148609413826610224397173111647233642602"
        "8926215761392757848297473482615711761267249168799474035866969371240333263088855516815397668226530197493884"
        "525983129937954791936115506649432796777077774136549374872640072453577886335551738739013671875e-293"},
    {0x1.be2f99979a8cep-970, chars_format::scientific, 729,
        "1."
        "7465463640233769100638197360771104302050851103989186606102081931650026488304599327327558753282729200068332"
        "9804678627668050378425568460067787042712273854355127306999057546471422220437915342161900314891762709292057"
        "3721527715623421389755093972134547171078825977573421206869147881140899358764839567176481371382813534485115"
        "9835678704427518919036015896266154533044169369007760086516985334355446363476266907650310724315327746390025"
        "4578075093931194270369530646516335045309634453905095844888951319898980495309981925213072753792773010838101"
        "8242065386226332023454226886482050639863587133447070386576679785063884990939398460469896517681871811495270"
        "565050105345772489759853919318571093384770703357713843295595523841257090680301189422607421875e-292"},
    {0x1.462457ae27e71p-969, chars_format::scientific, 729,
        "2."
        "5532945426002904780507157538181669248527607853073242744554647032768966856497503985566702814500794761713015"
        "1141601224844822200746378164407163008645601989012874056444092985231929202649672787574039697242924779836829"
        "0103900949007393832538886143168315948223660409479333004620541843867294642578845204520026497108979679013560"
        "9295231175581237890039211997494098462608140330553092569686196215361473140966026675727675473684805370218685"
        "8212126583546909956560076422277384338487963183774513252266281901186798524198419702068981637862802969769450"
        "2793001789351434068617111543379937626164684311069822291752668796387656882250217177699698369291172140147851"
        "454964940605010325751218296624302065265450254613545551241049480495348689146339893341064453125e-292"},
    {0x1.c9bf289091a57p-968, chars_format::scientific, 728,
        "7."
        "1671990510048377614019126542833310289999616144912903876805253277584351602647703123458355536528192167364440"
        "1662353287232239949764532980184843582562259507270415311588513053208283288743801563778406068749572307800194"
        "6125568827170156775233327361851224388982041403917785806215783044313688219646403826782962055511360668264737"
        "6897088961002236150471094097641106960350616121428369305065826571573273641647725775688943703343567101225478"
        "9953333312287057640008514453879865778655393259160740174367773735675048949532421715134949497702708361285237"
        "7322542673884527343694192326023200301290131404052076274549091612163177499275646656982709711584001572445734"
        "84733167635547219613675510582898110780193501917110197874105637083630426786839962005615234375e-292"},
    {0x1.c9a6c21c0e44ap-967, chars_format::scientific, 727,
        "1."
        "4331413352279302128149191072605813876697528611345885441115000029609556842920386965482577284207290323742533"
        "2199509594307830151946681984866655822228339143835403194270253223913061678439860917065041842332387051370077"
        "9500944288148698788627957916496725038596154564027501474646179397442030182754135054292301436144243035179137"
        "1270610282715417684609169626900527234807117188403332704905395975649634750649953559577652559528484291031633"
        "4676186094662346061090628337052908713177247664619683224737543046454127747542696798955644966121171604862571"
        "3175695589578575525883542807316083301746126724381306477578494291843709874477007787068278367148644618010713"
        "1875144882846097603267302176234293033266604144621188254848931364904274232685565948486328125e-291"},
    {0x1.080ca19dc76cfp-966, chars_format::scientific, 727,
        "1."
        "6537479214140957496644432073018089012144452120603766472454112579144784777132047524978251678680652305622500"
        "0499253635866315767976997523004602180573355978400757182575064036053958408210190339447230879379051417089690"
        "2600640674876720995879922414089510417178382171731253321930144431314913298710310772875402641130578414655191"
        "1643305304636464367182427851593250624197965599005919337369891600964947788560805510699332326217569801868088"
        "2270353417276939433992552778680098874211345639068458050074871457491113617241586311735177325328666991945594"
        "9361607389174582641520633304112836941762385362003194298015982774531160072879490045018610848272352089449297"
        "1559993956728196016916768467473936479509527842902093242027916630831896327435970306396484375e-291"},
    {0x1.568db6b9c2a6bp-965, chars_format::scientific, 726,
        "4."
        "2908439090205467290104179871798651941226153898698783477673232932487248769134773470874791558624108005131697"
        "3536088629026557536545749155269194293346060062071094839619735992744602682720872020489985764651605227123683"
        "4449315338589395858711154446384822881445654088301480606833643769669528121156913759180085536698487352616174"
        "9640088098036503504388607252321301774363944935742492341884553608844792004824932319261176330222096044026500"
        "1756051164867224989944424575770385717357779091208619818711665610895151705642793452624142140189626570619779"
        "0385808753024813077649775797625712909337310437672688236559439684574369461412897368191004528045867884390464"
        "739907179528687280026756613807116577015152709246269269183216010787873528897762298583984375e-291"},
    {0x1.8094bbafe93acp-964, chars_format::scientific, 723,
        "9."
        "6345631221449255842528627098837665212135824138580247641095033482922043986659116736534146977997184184550644"
        "4601994755561347497711188804648235220805765618575601316863143054761832211432259334276682908110694267973267"
        "9363364525747904721132014099792189719325293711235087718438176498772644269414827594417119678477271996103962"
        "4464068850461484304306996962247952090789771393359568041684499232396514214051736756405489381778675872598742"
        "8157370116667389407454794188886316922944939839391299995745043273460133146343884929041994919904676232308848"
        "7621676588987291499515095008487221366327604330469301849090855522740604347010078082126314423497545739632197"
        "917648583593472744787066092183286022494344519144504612739865478943102061748504638671875e-291"},
    {0x1.a4d81255160e0p-963, chars_format::scientific, 720,
        "2."
        "1086057222075156140699923441456450084308897252727905713437086108596166987468409078397587971487533636066512"
        "5559425961800525159988473481938995387145032563193842335341149252710258276907339069644310335615204766793420"
        "5046245456558650038735730800871978103887994564534273473274917826583210324132525399524175049381515195829365"
        "7369564370243965168645236220245406226889139007890757799017450226883309511109663784656864385739561274426355"
        "7657149281665440973055056669372106589677993963623493823619251634129655150817988363340633174195752548807091"
        "7823271593105149749384800080661837689037203940523891442460358685629634666925659895161508889612895551671788"
        "573863480573115671110693838776867128142144224012266562340300879441201686859130859375e-290"},
    {0x1.555b4760590b2p-962, chars_format::scientific, 723,
        "3."
        "4206800637910766975986348248756809245585722617245253884913765467082902655863539744793091912901291965590203"
        "5289765511658279266066746655823602750349947919758040236162078686374492458909606117047221706343896128942681"
        "5347747096631346945775370008450257597462683149099332669442286046338578340101553491642092478945964573763265"
        "5303976057606048773717878928602898047324228476912795333101577534185800126676720392565056992132832438154329"
        "9424787438555730075039358292293164678724048090901309369949159601150254447351579618707251348992673994468585"
        "9607150588631254483057331394140758973297520621645166366212282409238633290902812737463038899559245953449436"
        "212948563447937782437491106183531864268581560058202217788902999018318951129913330078125e-290"},
    {0x1.4ac2efcbe3305p-961, chars_format::scientific, 723,
        "6."
        "6290167589677367951375617422929271680606864220946847505992857434808143549267256285863593676807534571811650"
        "7990734126024664323017252510560123157213222771972932719343366101285834110047644303294398466421171333829299"
        "4338219373247383273584684158361076342788872926422826115587259635077003684919003684823669045395557799403510"
        "7919232269198025498868586627294909726179966695692030720962338197573754049554465371037256488197839056598921"
        "9877292992603247756361908752192553418763996358838205450960619495274938457068746433456118860927509511328976"
        "9257647430285377053075634126944778075167863283379686258333392834303348019917586267926480779517948478918927"
        "063607609213267237687171277444430229764849742991883463361091344268061220645904541015625e-290"},
    {0x1.5152151a900e2p-960, chars_format::scientific, 722,
        "1."
        "3520946857575770466924336009049788127880386587840573750855126370148211922936332843549880833329104097140562"
        "1291061084670927969996645981504375234327144377801924067740766068048371191442881668323888989913832196109695"
        "2897929141749716680995649364750852884940442785486690547343872512681947134948592736866712512591490524779325"
        "5090731673364236766649870776441267794337031914794723417664812216517460238008000903094550881000779334604095"
        "3306025721701601332578457998076339413637327928622239485921271826646340819118973796496053821335859717066618"
        "7905138168357733394815415483037124393427107254818942235087012334513591656298823628107449960996084615787537"
        "90281688211841686919921141420718345664751217256871473892942958627827465534210205078125e-289"},
    {0x1.7e58e6c112543p-959, chars_format::scientific, 722,
        "3."
        "0651532125319828043611403886497181631776301530986382422563220573322643168258847453877099886269667781939003"
        "7796781862197307930725514343043551254211702279911167296696208484262395929929119796791221572069220941246112"
        "6684609711196673612053116397582155620461783165845586140232413390195514862846452362791383900061129942543777"
        "9683856317930346474170707234461546445785222564966395233185078975823809338083628329613971259053735059038816"
        "9226823931122118444143013014003539703511505762260490564710070701542059395640989371263266941829283247158447"
        "0128679373107055110632193260404785063947141156633187195789592983001451297372755688720100822729534737038975"
        "00046421729618175608545958200349764878121067677996247624605530290864408016204833984375e-289"},
    {0x1.3c778445a2b30p-958, chars_format::scientific, 717,
        "5."
        "0740229754679630015597497635411251704782842388847706892559998222461039019858354788545899536364164695375615"
        "9004970663065251376452644444722367868679833631961456879821363325500296762139359140059831135664037636091103"
        "7851826795084045937024297722699696856108091789878307056427588017412016141242065429389459914673058410334447"
        "5029045630695628818864852040810568120665859876397220638806076762863741270024917808851144173068814023493123"
        "9465794949117932333473719195382807214003119528830022330600771410797617629186091757430776249487934472813481"
        "7295607280179935636124185858339459651464992994383411267201247553011716792219570153380458235643643535470204"
        "673305630435954878625940750273716264569061340505840007608640007674694061279296875e-289"},
    {0x1.d5d886a6af07fp-957, chars_format::scientific, 721,
        "1."
        "5066401531008765660209715620847113430721240845311467067488393060399424689768179013689935270456617217772626"
        "2449294236315192284938560348589795751273940538757255549062206419695642046911817014605594134791735095417547"
        "3496661062569118259538483356471500150312765170021570234313983189886563782145873240440323828891290807194213"
        "8146945071589392359015982750809131377045618332285170839599383602029439803065564549875367002305011744027345"
        "4791998767288977253280431451014572515866251973827561103685944590487910895898225162299074096391327451735400"
        "5702009089867354879711711819298254603418980386599420783790582966667612569549001195037944795412981296229040"
        "7978653640090229326186696355379052802457638497724001780397884431295096874237060546875e-288"},
    {0x1.b4d6ad2f813c3p-956, chars_format::scientific, 720,
        "2."
        "8015937941494582893752219699378451541676163091913910886367587801515223826775770979017901213581846339239008"
        "5972743564483406182138794082415708206777985372462737529604331783161052369852259640641682719407243347401272"
        "7456932011627695318546847116981997986538474037406413302814400876575334916367833693107072636011428947924771"
        "0431832859153979633857644425954502850284440493944167381091614718033977997952112454266036283567034492773027"
        "0297214072392515941181272044503439934946642157033684526504794793241794104430220950327217291773091671208313"
        "5200570135510136075668818444233387687590160584099397367567846354051160569747236486489617845200348490288202"
        "051349985773023756814947896164670199036189450481071361309659550897777080535888671875e-288"},
    {0x1.a3accfb847f5dp-955, chars_format::scientific, 719,
        "5."
        "3830364529866897070892653133613309687768553145998845020770002508286663820178028904357041106164871662930240"
        "4292326281883963909154096452472893947755538934242330914543826959031146221568246692512569359075149804195162"
        "2455286861325460251680876019901469233112170819584404180268970996038988942682994555869177877222572726704409"
        "6706370606363455491707358638817637507737802603692179707323013726519499078873069293802377310441059050095455"
        "8409431256576666225481896876642690857726316749420932215444605654341122928806547906002555368770089678159201"
        "8321956437180967622979120309900059276854565582725176763468818525035142169991443317320021522630614922936712"
        "84130552998907366615149384496898688035417847308483629831243888475000858306884765625e-288"},
    {0x1.490cc71c1b5a9p-954, chars_format::scientific, 718,
        "8."
        "4412342380502576546081430450113714547500629438411347771053360322063370388173904974678292331037009777086711"
        "2099414815476448744759263688277212497420153992338777818006934888909213572957511956634738036763365144586177"
        "5322858389270843029115166607895428831657856603626176699984273793880426192286194266443686243608836600001354"
        "4530110132454205033116021887062016086384595971121585437748216881228804338113019161359341335927611034275239"
        "4037940717746332315355023656647031482236645528004617260974202488109127266152579244998351781422253738236175"
        "4243701550773001844292452055370516538649507594510998476523084758454303188096588303409769684799427283670348"
        "9527961893337125050753747867908906204526854610836750225644209422171115875244140625e-288"},
    {0x1.4fd2a30c2f2bep-953, chars_format::scientific, 717,
        "1."
        "7229963037415353860036939274512602607703473934570316813755563202371450285352667556180727589154087041362056"
        "1283459465386257149814404426731073509224486647540553797898000159803219506010895542832878489629573788723953"
        "1749999981802001417396108156377958282976764626235599595602595041214194378359560862503860866807909172646002"
        "9975659200114921786030177059914763470055885610745129137128591706559908111228082064091725340897564033533397"
        "7713665527965071968852553983251712474158073574273322543402496753700449881082906684354028745885662376033485"
        "1322987488292975046799929539221349587261627100702755350754850783890370827469481884228645990808184748247674"
        "193083168557675793886784178115221749321393784892819667220464907586574554443359375e-287"},
    {0x1.e712b11ec1d63p-952, chars_format::scientific, 717,
        "4."
        "9980227888927947361544276876048945527052628694146361153893340602625907491058574989544577033169635434323920"
        "2363631494369169360431693425214763451868479262473007994553742587698599717845223124301708762653254310627635"
        "8615929213885810712355953882567405745554059674387476562405224374765909844276132250641182466570610855208408"
        "4218918059037991974479006158869305616984906845622665393220531272998910203769643038213835331473037608225072"
        "4904487349755042619016279363453628277094581074974439583045948813522912747444842573673747533613488115993276"
        "5382595260797681368667692815244795049862397821162429723072459989031430648448876485854621050523129541804361"
        "218208441699108218502865720166791044828773216135431312068249098956584930419921875e-287"},
    {0x1.a951cb6dfa80dp-951, chars_format::scientific, 716,
        "8."
        "7286979124915840031811171249768746744436889710675327400944811289743437499055150408336143447207699067554825"
        "7442958324490534088914416947203034596292953382062295275457233755524482929174694081985804881831251240710578"
        "8126951104999460919138178657731447361495992307164569451115113425119293927665641245442265523577467103975280"
        "7359164333796045189813934206387956229569099202670383997385959263031751034359811529335821735321526957957448"
        "2300932318121087160706915252100028942112875612578710323463601402080899019147011869735277375358119396699255"
        "5371084452440315677385870831672103657333622119478297079186131716864900307968338276669280687253563323393612"
        "14932314316194561659184333914511633536505164077112794984714128077030181884765625e-287"},
    {0x1.cfeea9a77e27bp-950, chars_format::scientific, 716,
        "1."
        "9042271010497776332001708801330615626361603928163568681486870742545599127089701284279280984207169692023217"
        "1320030282687303728445015162144559242089873660014349397431364036606843290349007956825150392182396077699610"
        "7081360034058760638306226987187123573951079730136436300311799651097396464377723858909261474710812858063665"
        "1516285060709599373476272758518992824461516136888329866236431665769165459746602035234128545216729573491347"
        "1603418758679870235818016847163544362617754381161439704896309338364473880342545334782765942594159926024292"
        "6776721855571408975646106864867688734105951682537834904812715247258315613008475070905740733513696526664356"
        "90680061075434980258140771483701977439921548818091423527221195399761199951171875e-286"},
    {0x1.61502417e8ce2p-949, chars_format::scientific, 714,
        "2."
        "9003728382951163001336386523617062381286133744090594743589414411368340653555137244271537591451655680687315"
        "9732505961309688819203604378162522072256819193225779837080532812628857860412608929343509699484705718495967"
        "8498590349546873362607386039910958079726915480506740564727937744213886081662414338883958167769615634834449"
        "5208205332455141483630438934437969676485027072711307631327019462760209568508259406390712220813594963156926"
        "1054788729428850637210162360658988869878013349259167463031826438489783029936508298061711618268376301932063"
        "6233705491974210920522838275477083252004563254028764269886961406388361787734609729556483215835413375983163"
        "021711842878443424060979670008305676166815434413592811324633657932281494140625e-286"},
    {0x1.6f4a6043ee7bep-948, chars_format::scientific, 713,
        "6."
        "0302300114805323360867140613666291548447107657508151641660095102893904089283521303828228226597660628182350"
        "6911153986869512195032232066813781715107387668300048677099943316832593032950727022533383996204830780873687"
        "0336786474106255162862393383020101537774908499396139970912718835720263245510686995538097893670858302693490"
        "7891508455961763342319381299089701452017976885541745003090606738691178664596292998458754512228941266385244"
        "8007064836689028083268810534974265755607698465042353718916652874807767108414470421851891490105544576545965"
        "9578607346221279870994992550342662655560173662144012241644703804158632807596075223431027561864483265724367"
        "88800100967001687104564561953359727412837809623624707455746829509735107421875e-286"},
    {0x1.82fd3aeac2fecp-947, chars_format::scientific, 712,
        "1."
        "2707290656410451972148714179141781588967973845926807547334471277675980850408554878248054803892782582018822"
        "2534182569028299426262570059445694988348700318777825258518784535605857425130299671300426071383629977858895"
        "5387337468219031494910244066256770720046737203696728672760192370711138924283768772475940785693724826698986"
        "0466008993894741453396502146202005519277127551424134439683925893021558019255827189881118691971239229665920"
        "6657060745898812201958149661378249840066133255936674274226197607897248507836438905238727384458811013417251"
        "3379082500885683858207793250918021016981595825486761813591464957247173777907417675517257352395503235491976"
        "5037037450328159638720514623892016668749160857032620697282254695892333984375e-285"},
    {0x1.fda8896e44ddfp-946, chars_format::scientific, 713,
        "3."
        "3470583063356332108498766757166506385353764031783485196998561866179457340599432256217213352642082359348776"
        "0065619379843121648679832554328338726173157671099841073635018988556349126405324929433103638921411010000406"
        "9970975541397062403299836691883872720101591275772567836499474144709269745164033553143381865980948114813450"
        "9563323398425378499328625730378201514987590090742627365532394510810911008494010157265556059636318908537716"
        "6588265752427397414769519174240481162648267831006229274985704703073458419860862001834681264408952610279695"
        "8120272042811100264333042992405966114086480503347740480307977037393767702327170428860861334438521055997639"
        "87519384051736961186649658053551804025305127510137026547454297542572021484375e-285"},
    {0x1.f63d0121b757bp-945, chars_format::scientific, 712,
        "6."
        "5966578537292035157422433162339949684328657517781425278937040263737397772577187341772038360860221866728139"
        "7401687446570117084677990224984289048367008807112058030080344286777952675512614595714878804489254477073655"
        "3631788209373029438911737396887226525344476794228878774806817015940622309814103147301158180909849015378481"
        "3123115801307697707920891837072640679333216386798989999483042211053745064747961945094371289546480468588624"
        "6554648581517370471456957394934735507329277236644627330631947684311599090344589073145189553679017707785009"
        "4743043339681131317035896807523747130636300631758866165476656409393301104737836983161194297942630550081578"
        "2254835380854001782230228668880262464513375419983276515267789363861083984375e-285"},
    {0x1.1abe55124f6a6p-944, chars_format::scientific, 710,
        "7."
        "4273986683209386002029183146497792358537735412418076229677375034053108781538417130596628794716377703048792"
        "0439447874391640830497329263769197669372654570210896760100817222039133059067468132996774053651076190226967"
        "3589441074259230065627957038293185520235291906031948115381397829092825319154312472026340183818944682611111"
        "1156145441474169706609373281586299060755244822009110650534665364827404192153653867280756103054142218360222"
        "0934581061734895574051354048724565591943722679704655789621606831198408689956651820414839333271464401183877"
        "8450966879494076305659347420726388904357845227958574995156936912713306237255628189778269960699349488082411"
        "06386418643030651008928724469602099256260174797716899774968624114990234375e-285"},
    {0x1.e1cc3addbf112p-943, chars_format::scientific, 710,
        "2."
        "5312725644714645962947927743805809804618884397617821437572318458550743118084862705289205943966038119003290"
        "9589290532205874362493462899587538183794311484367769029075747596682977338151350446246593552098587417080875"
        "7851469248740093376850022734253382347640497467551967268290362838553891696265966263369157173634431861777730"
        "2846800242763765681365778209538316436546166804404273332427861460075267064607964574701863428965562408362011"
        "0521953699389815696244858788510527465075072050708829210926602831437546879251441709037514462450585484637061"
        "3750986429422869415728090168020176752627553816027216600373170891796638653891754210465863152465601677758468"
        "90651442682066021379729291296127070831634142678012722171843051910400390625e-284"},
    {0x1.c37ea66e435a3p-942, chars_format::scientific, 710,
        "4."
        "7441324100905745554574287302084691280382079597193581631559111336633158232950997129792894980805894193066494"
        "7024126350169270196995072745313996409498284229154731375549048678636733572900612861491971019072075638834606"
        "0562319519438688203810434951289695484950243280779028505894245638965721460493474958616244676132192911374490"
        "9744685596656046149778452097128786811551965968423994803335170886805118220108585832414027702378690965054682"
        "1132637590793226042392427342459479251395153348234719604672659565852875863171207615153939055490446947865662"
        "7069451502833062779732643453355045985620373037341930171564015143867075156826922069841065014424129701542771"
        "86018963546023944039247179557390425574947556697225081734359264373779296875e-284"},
    {0x1.5de150d8571dap-941, chars_format::scientific, 708,
        "7."
        "3528110594538782482365773897168607965627670328398853743572294287489462941040004923609086852490422148378042"
        "3221265352794066364321977056316193229087193345799980407047318859371585571006327608060193056679922161895138"
        "9023450857711029880846747347949781266947671465791140498898018902300018409192427375203800129541619913353668"
        "7913336770565773056104716911264461178801127817029921714572406594873525451090759250061606175297688853642741"
        "5063374341194168250819599742158320993808193105179075468474640923879534600345563234330664743865595922943046"
        "9027013248365025737108296595578764740793659540153206839917157674241108599911219442200327046926386379632794"
        "706173770738386202136504580487326443449802582108532078564167022705078125e-284"},
    {0x1.2fe740d15c5e4p-940, chars_format::scientific, 707,
        "1."
        "2773195914029404839997121365019846678012360652350488064445378102080680878178292751812127902282256650732547"
        "6245703207416712594596348672625016459895425199193206223669274574590781615279792558252820397973515964842037"
        "0516008716769106316730250486845936703583635694598574992126846759388865096988008602912529868185336100299108"
        "0553719525657790562548044625513894808092631398771815402398278693165346783864034097203390263050764499973133"
        "1176557957400353328895833934462164126215289648841232814684151554950526609425364545645803014958449858388387"
        "8330615551788311376615569801461643158576202752253276793725354647037131210454236435093465752334159968626474"
        "04985643869421282773361209076680433671668879469507373869419097900390625e-283"},
    {0x1.74c88e0ca098dp-939, chars_format::scientific, 708,
        "3."
        "1336514683809335823642014056905165811057462424986100566379077646256522264565554151413406651253885848300977"
        "7428810212153271901858767685448835580809572557049468597099913066770055289698506664019615839038475534710535"
        "5795137683512491796292640286340784407826504261360116668998806692920326410697970081470553311956742163565291"
        "9488919030345834471449497634015773733880344369868510365310417368327167250001545295912972407904243385685009"
        "0568326188908814426299175347109946078168784813256752832581828231750592798891910497717653512598209256212615"
        "2163332546148270577877121959807562829701730894716563197686457689793871379392247928709120246303744498721385"
        "387058298586846638108429548307855283528766676681698299944400787353515625e-283"},
    {0x1.130f11f4ae551p-938, chars_format::scientific, 707,
        "4."
        "6243399480760986651758048859591898670257532481551975234236150685657300241821139657878022784585233874791240"
        "4963492241550289496212262096830935350508363684680527380586207161154519672283951737774939811483462728083444"
        "1777428783029826723607606656979273452995057139008359627554000935187030159957139984855268085241021567271742"
        "3431954876230363643507044623195289945422834721951642431654272869278279463263248928505373646536454486629285"
        "0388933272047691776851011626956714255714297331667761444662037758523239544520796498062658035671762514053396"
        "2546352624989961931110902588588758282909374019543277991567132082147774864908128579658562342391043382460857"
        "66373351339663978363866896439428322285181138795451261103153228759765625e-283"},
    {0x1.08835fa35800dp-937, chars_format::scientific, 706,
        "8."
        "8940877727403413478054422469551585361360602132146479276553748560572263855354900108174388413873810810570869"
        "4447652663318550897683068640027357513815073547307056520232708373475428951985938086920965381705362856293155"
        "2372597405794368429177559397287482636064879735202907026717819924195853075278831851189896959260779613681724"
        "9507141535585621250711601400414125889337957763942399330493823244145586671155604257863693476957809385848081"
        "5602432524204309644294980503300147419523958899518054102661427177982614986697817162798859038178707067029274"
        "3666765992474172041115451984467344953683138400045170040908790923436569293770430710009650254127241328424225"
        "1963700416095371587683104442657866517407683204510249197483062744140625e-283"},
    {0x1.6431e220a8c23p-936, chars_format::scientific, 706,
        "2."
        "3953652083727512388926071411736651094684359629139545046331701056101374156295569337074287726281108064839092"
        "0197220354257125643370788918721253430411000497833026470918438064748906303836803667779264399037996493294682"
        "7799070539590992054178881563195508842237166002254838778941432287913764333677699977715082668936870273420684"
        "1637889564941327849417969580798865985391354437385154150217050073066367310703953519083722746947699236233991"
        "0914485251702387166357531280402329580119848376247994125192476520054069021178244018175790204834170600687522"
        "0061280292199496428179636808244244925634931880191201392142822061160051761870987672004337971307673840421985"
        "8403977956304139210111692789677284576299598484183661639690399169921875e-282"},
    {0x1.17acfc1134894p-935, chars_format::scientific, 703,
        "3."
        "7615674663262681818855898106340652384824488135624420876733253077105060946198861732627493193519901047247753"
        "0851516450610526148310774617875503789522940191314377583805558176016959667319286171660282631959695917660262"
        "7948161600893585841102962267471970566960719972616815524052330290448761157948723719283892809603393480152922"
        "6963821818326771744159065697180266351038889725789977121282586495071803503310337622258942765229731736751373"
        "9802285453673323672402567322678297740121435959673931330218239056618465199032675986831449764985280751644590"
        "1051071633900768229571292193676658069223654709451072516761075679530496081880163478624608778936598616058103"
        "8975154763000147609318065712591394600394778535701334476470947265625e-282"},
    {0x1.e09c9bcb32e3ap-934, chars_format::scientific, 704,
        "1."
        "2928212167160485647289050725920773987486183606941436119505729854684825071061879741408404976987332542805202"
        "6475209722120894427905829017312531660824109185257625493974124746918871520377551204868603233138855433546350"
        "7137482116585173531717089284209974439757094815476313032633987246657466217424082287904980049799285173092360"
        "4321033958606419596582626473030678859231047068503703431925355566575260878258096148842990948930661388461594"
        "5556331126875486164601415077624257882874367569017493013432167566077044569124299536340949294173450937422124"
        "2410848684155513238368365796187170024735560371706926710527316014102463624584103054216799753888489426954230"
        "67389883463190992127388374323404551802241257973946630954742431640625e-281"},
    {0x1.a1dbb96340c68p-933, chars_format::scientific, 701,
        "2."
        "2480352182123752808136544940388978663414452868402807172164353048087159318240699108852308410935527799042372"
        "2607479167570828666405584023758943395449623547786265060474719000797492782936683920058858257998717582822367"
        "5779905454921856840712616925561352311554761780822321050704750714835793645031281809131734465005054259103162"
        "0770295421779702653225582120691078585469805486852420383602140963091660990507952839665684312488509192593627"
        "6146801902962301794667900084167998719481932390233466300406339130835304539931159145009172042189525782968134"
        "9889384996716260685606079478830353867971542977200900041965604299936591138903279189511225516719288109338314"
        "76652227485316062853136671872977814246041816659271717071533203125e-281"},
    {0x1.2535112b05fa2p-932, chars_format::scientific, 702,
        "3."
        "1548509399420712639272059276400333316882547293984026315247476639493255963348140121345690526759136674812168"
        "5127366607186078984663434814626878761946743591353198878185556202712852448632736187785808850221879652949417"
        "2466935302619475876494375304284254242084862440019357167612816636962625129579057766644896049407870955464974"
        "7335787221346083512058193881301726918508813388754032954001938768613080740109292797103362848370010728277700"
        "2447037363112380936616653230090833282091176580530259321841919447337344677998409580350026291730548714720245"
        "3464907595976076416622159108849254870594068881747711745858983412187878188897296623397306560923894227742617"
        "663131411366557437721031172117580609892684151418507099151611328125e-281"},
    {0x1.1a21c468e4a6ap-931, chars_format::scientific, 701,
        "6."
        "0713639849830441431950666885186177075226515153992662907626497301095398390732446604186943203382345914038884"
        "7323282265478315251107842926851637284944473721522256210665632511691427823143735225088177817782851258604105"
        "8802465427960568227820236551669931647579766385297520509184110046667024917465803528176712653827604854690676"
        "0539717394672162140625498504576723310423343077058148234412701000131002157689180704997981873225601677878672"
        "5558225608403941078353606559612621001943710817919983755745476941534320115237355705280174943756986505561652"
        "1642323629981253371080878813132722433052139744568133360474352311923115847036015008659884511808602933588905"
        "40549489846723710069942465950010301867223461158573627471923828125e-281"},
    {0x1.fd135d461e64ap-930, chars_format::scientific, 701,
        "2."
        "1910202165183367961031144734329017463226979382701869453713513013968249085356785932288012024393541953545552"
        "9886645511615889973880166664007518614802113825590802875492420305574416936839892706860731192309333765848970"
        "9908439585083718902707887189552668448593889249735204217996658815646772179955571823374833497551591956309240"
        "1541329154965837938438971554547587418225460815133461459523484200094358091531238453626872459122480596669953"
        "8348727335482836669569692921603283834722554959131362093164174528692609148104334930473885438918883552561594"
        "8363008632224664238662463784686332242084676173707932159699210038441526890720252029751413671687868241305111"
        "90159598977575695967511849870934526052224100567400455474853515625e-280"},
    {0x1.f7d9a435e9332p-929, chars_format::scientific, 700,
        "4."
        "3370603492213999246605109863562578922697904205023479088354225118411162637603179888703710226609475240843189"
        "7778308805673483166109113138700510733670800321786228644296296310480876601318227660027323174410959962952323"
        "1073474743346300893802816394194037660492099236546107192724017030062164767337377700574128707882663321060086"
        "3968698996521352740869816450919671756597948507794800031118955538243210878544952125774573985954020360906486"
        "2954843068964485740002357562419225222618117352360709939373196717678314283249625825294875669011304620563035"
        "5933690645526817739372794594388572468529067558242499477463165957541382915860867194951359610429773433468680"
        "7656652381430992566229733198301943275509984232485294342041015625e-280"},
    {0x1.94c659bdb66cbp-928, chars_format::scientific, 700,
        "6."
        "9684715728693185128958785274644908897459959339474683388991916442657376227644833807738962310289463011013541"
        "2100965211658967777232367812792866866542712076638289606844458587892947675905576979450985333650908225454235"
        "1258556803112976410432769807463403605097818593159599336715606881192650863075807426528516907258685085390493"
        "7589052995111653435060748089104567805432665743598861338717605076720671406807599807657542183118213510386647"
        "6758091298822363245367286109870252428162266516719305025469724969389301398868015871079726249945173149617262"
        "5833737082375357463190498230523012813555991495326869696530083748073407599377627499057902905597850692529203"
        "3909987407906166508790406222129121260877582244575023651123046875e-280"},
    {0x1.abe769fc688c7p-927, chars_format::scientific, 700,
        "1."
        "4733311152437789540227053092678323460332933852257475188822441222074344436589917689823247953665290710696624"
        "6909916118096358672315472282160539273894339479994193169330520625936397519235918130249340730882903493307621"
        "0895612852780366731538499350545049966975086920227034460151662663011478742176698549702779007271900180889286"
        "5490797177322439918350145063046375849294907349943601734582058091677850466600549179567598052592528981026904"
        "4947060856836578814899623194745365093095429477087602427196556222424895294076578456413124521507596172456938"
        "8251331129730062208483813193703538285744927685484325243111761550184614450373063948573745792548306864820340"
        "0069389217127511839951041483498528350537526421248912811279296875e-279"},
    {0x1.825701170d480p-926, chars_format::scientific, 692,
        "2."
        "6604406094948299284840023312889151895045655703225518408579970423545100011582978514470567087920738321442927"
        "5307285432371144591909800719245957781141729612931668439653482875327754820963954270428962349149199726835698"
        "1184592735245864921999727092722643583285720404162313925726900614240612356134419032262428558843961823391328"
        "7064205337047968262378349013995361823268143063235754023395627339613127590917817943514492812352700718204492"
        "6865908504249555492149730428374342137900767838918385014099377896161172321732594458974432078343771471436203"
        "7560194621358324729605336632503570581400682087260645108688451326585554293824380869245358022373059672081904"
        "52841033281990330838784331035640207119286060333251953125e-279"},
    {0x1.9cb40ebe2177ep-925, chars_format::scientific, 697,
        "5."
        "6839734362842070796608423358963762521942847688739811715193332262874402507007578228137833409228851937575142"
        "9881333886818972762441084651503135482841878157912998491023471197153193567938330820279182603747487685157804"
        "4499143359656487408812158088001014917344439759287983216092513910053323400256593370050435002396967994998634"
        "7831174253791387681379454495092330365305712925878132005668316354328176029389998813412358306819750991589464"
        "1588404401875403708454179807021556382772917776316285266398822892936165695523171539159535919943189320603911"
        "1057506511608802173147778806205368856349281475078098721211793053402011838737841041885975679740409233160578"
        "2924669070403089223518511285959675660706125199794769287109375e-279"},
    {0x1.ff8156df08505p-924, chars_format::scientific, 698,
        "1."
        "4089452631685326968433243074109517968005896956405243537738629556725543089192340456976745618392509456384421"
        "3295122043611679935471391755079980979501871944052554986009587710715393810226977108801992230611058211129108"
        "9485525691899073270714769067531770667572601957595368192889003105509212398388055993160239542503494835067228"
        "3245379563818248188577432178069785517522144713560421250029225560558108073716075633654170491660565462257320"
        "8077336936537681601495287937831361476225032018916859215383170855286140431926630333405822225809755086425841"
        "3403531304832809177251851959422421163575904569070712506755851911160818342317775969283615277190753064800086"
        "42654648867933132806891383115299731798586435616016387939453125e-278"},
    {0x1.9d0f772cf5efcp-923, chars_format::scientific, 695,
        "2."
        "2755564362864926940281773480518310790479861467637050696098191485132841536234255195968894202054768127594340"
        "5052471207178431622061755181896773453067772352444724262922219671446487226142118896359570378668235229095798"
        "1166316968715768476878377717323676558275913110625496417171332179028764068241742129287569330477989538640722"
        "3078981110638172143427694907604433837129087063112485314874144827336251086973085916732340036992251561259733"
        "9675515620741030786110317330091445693562528485582028687881785896904192513842055970675225542253236829083202"
        "3599170155833556378582588541054835832258928781218529554093314331968991940112828530328124430108304974376277"
        "30945405107483288202618876283622739720158278942108154296875e-278"},
    {0x1.5ae0a07bccfb6p-922, chars_format::scientific, 695,
        "3."
        "8219068582864352723967747931343616562165720978117376164184044778882819856109340136059651353300760019380045"
        "7963875686854151814858111036445511242704770934444137666535548776414562807926044830228719368181619572195896"
        "3465354214067102619271776398409728111334674729760537429642740220094300496716298519328903002429770328300604"
        "1946617762562693335543494641811348659320099800248426163155938515097474857985088679151812942108594818030328"
        "4306883294509926394689017938918992450263082868445216830695420503163246032988791848623232836381428857315417"
        "6463928935563277762910223655851384736110714238400238082211026707573695288948291896607771043645486689943174"
        "76597365746052831735057875306438290863297879695892333984375e-278"},
    {0x1.6fb881d919007p-921, chars_format::scientific, 695,
        "8."
        "1031176278644846070191626517872180531833113532613231879550018095229278369791466764376263012400841347446788"
        "4537069420798897444792340459678011732950473018974004142598230372463984780283182332380363238844680055174104"
        "4882685402671409590390401829607859501011832309453302992160500266190368039980817257528474182247691498330235"
        "4021964279286190987699675882237711813507510953617123368849494245241661812574268038787990734683012163703440"
        "3253494540299453377386417370013446614658571822640671013053242841183193770612060018133599299419386567835242"
        "2302987448586734996718282943690713535168181153513958291979209420682272276968832405387188696007394808815855"
        "34337397162967550449941267487474760855548083782196044921875e-278"},
    {0x1.9fca25adf211cp-920, chars_format::scientific, 693,
        "1."
        "8324734254279028869387784372851448047860823258323750611134821016907972862665862948679459543729058185314029"
        "4109234291012590537213580345220640336487442495620076073943474905128820570844254967289771491084820829982316"
        "9103036957205913876376666459893503223052173089296631419583528827717374000015474402335079386664374426327190"
        "1555348969754355893424268192757537688455844358838861788081285696553822294575029080340122592400621898485210"
        "0980586377051787274079525731758978655809619252450538245824044682934365444142441443713505465606942364261493"
        "3323336396499777095021957372015947166181084102535422709985885556677780495536599067966610216695720290798005"
        "524230155507763549704858263567075482569634914398193359375e-277"},
    {0x1.3567868a935e6p-919, chars_format::scientific, 693,
        "2."
        "7272220545317517868889157965337696025274508420889298588711181595213704043378248791909948540380616435611593"
        "3910336212536767318988081781070397664794560055943968584737578105345111712898159054166131527987411472217401"
        "7866347800567633763552707314540341731219481235621611130507775509864789785266383510150307545015561531035709"
        "6185185351422301629593018870035843562289123275825378701398430382047446661917309450697462735918474031918662"
        "2340850441148530538284790831967160290452968341473708720459139121500038263702725273690181380827057032060125"
        "9532974827496579814102373524204368860193693113227607483201472667063978336888662018926203111235696960255284"
        "736973595876500901791228415049772593192756175994873046875e-277"},
    {0x1.bf28dd0f45ec0p-918, chars_format::scientific, 687,
        "7."
        "8829105150282179084399238370911642114983690457028991880625181033648641884093153361369152425774473922157315"
        "7774153926247698010132275250508458101810012251517742409690624130795818557484012862321262235357269411599568"
        "5913932502489931128923562170444579956137349168575918204365789567048958596408790512900515843150356938508578"
        "8171741990769154846781061888409738831181893137943969463124620309874532188237550188168195998920556942302867"
        "4792427236737851009052228703362388910682325650020113635567569125549130164578253048806221058312058858233667"
        "9214533967590618353077697183881161890577696002739400403994708829285246662769338823361787863906471416520890"
        "065817296459005358855165468412451446056365966796875e-277"},
    {0x1.a393be0039498p-917, chars_format::scientific, 690,
        "1."
        "4793325264349519609224189087172778660628550715159699314589946835960775139104114196387124361744349388346423"
        "5262499975290638162865880048776094965106354069497400210979615410318388465977151507798144171315330304323435"
        "9885975630954582425728852297479422077814813539875382686759895441332139770602381357809077363620286647587905"
        "6725196621533667569514255202620311480396908342237186203988319154990018200960799763004452095958354279543752"
        "8262461095548407540224109002577690372446359884979680520216781761547575060963446756203043820334004229099108"
        "4802146480535794498835721701300992022479494296931692114542127887432405933594739009899021351204586356951492"
        "886187572435401083037476155368494801223278045654296875e-276"},
    {0x1.3a8c0984bac67p-916, chars_format::scientific, 692,
        "2."
        "2180410620430225517898657079973304666136981289307679736753455928805959725081462934224670303724159485938268"
        "8828714380229742386971411041934144824845530951396830281289648621278119877048709460244734297439979032457124"
        "4210910101722242920154336630006086991235669508210185826348819618229937866676364296126489105865139605828360"
        "2048459899956394727237587803958256596040689177850038369317144434041219912680004534927123313725716843926392"
        "9141846933227654282444232967074996992421239352155928725744678815679120998085146002248164874856671200987562"
        "5412875033658742338513264563614366747586845781134774124232829708849899521351684572920654027513944639970411"
        "74444432233190359349261910892892046831548213958740234375e-276"},
    {0x1.938106b73c776p-915, chars_format::scientific, 690,
        "5."
        "6906497436586979168324009384548588036589095543759130627636379562863411660649404239561145787562444857179638"
        "3242916879169401001373374357414748760162350056495718058588423534096485487067553165909715657381402971404442"
        "2468094756706901074082987816674625471919162817470744562403850861742638326686838831329543166906530868544059"
        "4898149718409995904694095670341472420644316999405402196876112361507834250398148271011353848871090482305740"
        "7709927312703785037310249086969034897324787955384440730093355487897020162730857189426818122829178924268502"
        "3478828131783734931249186206288600257156152529666027885484652021194383320420661247802440895124858403164728"
        "133943685880850871239289290315355174243450164794921875e-276"},
    {0x1.f4a40cb3650bbp-914, chars_format::scientific, 691,
        "1."
        "4121156100358157296664884403439661646302276365078485687132001035304070507720766854695035558157858304450576"
        "6940217400099355023661276743227694506565541149890385524583996128825300819463743839851012791085031812663780"
        "9078113983498722820987671412284313866751671649867202543815081237996571345329124002747352450708274021201033"
        "9249382671053582408053415675489886917683768256732181737438581253783555941794602878960721256857697391077076"
        "4877147702942096611971251748274003472604976609538520625018538574328879978037098590719449636953103849833441"
        "8749823932561430082471354799282769696040754873243807348200109701833759917789263818613074275506995243758898"
        "2806943523648328386865813399708713404834270477294921875e-275"},
    {0x1.d90c9ff0ea8b9p-913, chars_format::scientific, 690,
        "2."
        "6685811370633676469151456124462933808944608667956228777777669887667468102141343225224973573822627858520662"
        "8706394471551392518714620362982432694174419506683788723487695530093086709272946848081120027413065121574478"
        "6557772150087296243176647496252440476244799624976290239020794096466570190721144031552410062820989434121667"
        "8829969777457299984096586701156978531800501269895806288448209599476087051536904832327274865690798406014041"
        "9242923626411226561350556759451418729720362364708522318857675731726321139280873439306988245518166084854544"
        "4617167500172223520590496019958399406193343130729441401318451882177563396082993744332324550487662094880548"
        "934381955914103834448525276457075960934162139892578125e-275"},
    {0x1.9dda5bbec739ap-912, chars_format::scientific, 688,
        "4."
        "6692815012344966698882844875437366789005901188975934417131762702284328641862258488125658455485014617892258"
        "7849067391433971807460553436148881053030070580286108356418420118416969143514528711425882108264857440652948"
        "2949951797469318976010031015211593519685235614350499208005655246051120557587904621971388953661755198499957"
        "0757281730469581796681608340143307523472370915834088491490803052108454624701398786420702452110089930576895"
        "3323642622737252465685844839888300778476275250469032520933241067415921740697019684544854238709595905534560"
        "3004485318890117726846497855781173320368657200811902980978359247250167408579989059372735019254137725760123"
        "5072778330693898940495500937686301767826080322265625e-275"},
    {0x1.b3d55416fad60p-911, chars_format::scientific, 683,
        "9."
        "8345480986695514089618875926461208483325452018779020379963044696050432933349843715361682741761584908091249"
        "1003925803323420285422299200257544927820640319697426292214256590284651687321803691614450944195461737083147"
        "0053949450130019955123314130153815851209568829682254278667162756302344761919601995206987208217756224520301"
        "2490168186679900137224439591161763561631529346451548557236425884128203137861028096947942575417821017601760"
        "1378479729168995921054485337026942189492031327824997457509579952046482421043196522791788544424088239606919"
        "5834232249409883053072784499831730816048858974051601859926639595921288052515471787430631231700012801861588"
        "06417666411459066466704825870692729949951171875e-275"},
    {0x1.9c252fe78c1bbp-910, chars_format::scientific, 688,
        "1."
        "8600057734718371714825273518634978354358430652262526675402237331598535844295454808421652847968623955166229"
        "4650573866111151552786059604653573925266743396199432791559547670426194582452576205390410214677534836184397"
        "4555536608449663541605202919437531227398833959534590546980892951601368099412773750211386643708216564687986"
        "8614705595747648294239448551774117577448974310225433244569605702819713532045299071620588883760079184637819"
        "8288424060798361639111043395696475163888439664871728837230441754911577683195623724591428200525516519522384"
        "3673716690874231955397032122819347024452498018750025400425613047170373078212498439755828093049590198255103"
        "6706501029587002005172280405531637370586395263671875e-274"},
    {0x1.37854269a312fp-909, chars_format::scientific, 687,
        "2."
        "8117756756308431810045707418457549719710610000849801105585413392312211123265412907366996179793959773262310"
        "2528407504563563289183363949413319716188120462245043980380898047975666961940548527936494252165792282227270"
        "9751021750995630547875850829787122147998996258733220571087825557332332005588075878604400572352057444304256"
        "6115665804874692939210171450919961655577985423556158382103522613283595365382795523013526774289312455559646"
        "4851187246037583046031577328203772305918749846723310361418283969452255932829276064984353856245298419264081"
        "3659122168387059488839582188262378663355081166412581348801204378576235540860124864292440125940486330437256"
        "312075595780786141375529041397385299205780029296875e-274"},
    {0x1.5b68fa4ac2b42p-908, chars_format::scientific, 685,
        "6."
        "2714270295442504603435251110132409147534667975735926257860278262299612701213671612207350641905602947661894"
        "4494416416416353727267861835534249791206425657048892129789772365623874471751817192007152737100353458016022"
        "5562053419694214377441724668769025436402835091526788281492455721704077602519026610127870369118313142031480"
        "9897533450610949249311456682364212522217340674731787953847187007405298194868195503414511556939417484877318"
        "0287260778212420819630672451773814859942905927714008129810096642973740960075495296454058304959469149948991"
        "0019786761795794622366208715634510022620666391042308290790968346187058669856385832192052476042596874880069"
        "9115977970443669420319565688259899616241455078125e-274"},
    {0x1.1bee12d355aadp-907, chars_format::scientific, 686,
        "1."
        "0250975871333601410285213100183232774538473685218055938897189096735340237340018400725666682494033072536608"
        "4523344487902158562213073784305960609813824694625419037109496021095951526904178029433537609825161518260979"
        "4611783379551401163974146864458329467185443162645279912920460025736906612085102498298245991228083818940277"
        "5148363138806380170433459153981158132727283701179492276737893371060445823347383802426142678436476115955450"
        "1380582707481618618086710570120193173722547747612927374090450924298878319085773548224441762980740444341131"
        "8861570306917779317213969781190995485564962851095177735122684967750904878926948300062887536858489633614618"
        "24513759001631374445651090354658663272857666015625e-273"},
    {0x1.5dbb3bf725a55p-906, chars_format::scientific, 685,
        "2."
        "5253325080332935122289495566127846548934475987700357144674961351479357467092094630453535541284919659245903"
        "8003494070856329734901083535046760786533056388680476864446948292312458125217671960943795156782787115386651"
        "8489995612260332097305108374078181507603174632534081548073471396342504983710412240194257585234633491428220"
        "4317410475710039015821596102435733830265474911659400368786801131458888124352482480324532223906317300645196"
        "6507983841113564976333857639263147106429864722263664851030405649181367011150329531668521843720200537028123"
        "0974830602030567068197067362558553069481671246793360301294886083514645802904351128554253419272228806760314"
        "4347717143702869435628599603660404682159423828125e-273"},
    {0x1.deb564bfc9b39p-905, chars_format::scientific, 684,
        "6."
        "9132961251476578929222904530052273628363552443315557555004747661057069612999210997894255772698684551025199"
        "1243515225364882882698889624584628027249467492666941103078711591669709456393002977814548674714031442490579"
        "1873235024838423268345382820217574525587164194948220489599485554712874650998509771058740523491301689686432"
        "3179317665178723422213216184384022812397384381918414301497856335169286849906525371490446315447355139287718"
        "4968492224551797774340395828836008134619132640683002736269625867150029972744613412338525800662983389755954"
        "4074960661569254434844416849696643611136230480746804569554606627570565749735444390099046341993234153112576"
        "404723484124748011936389957554638385772705078125e-273"},
    {0x1.5179ff1b0d531p-904, chars_format::scientific, 683,
        "9."
        "7473722876297753859094243167038918335732475648235279596858447770771804886894929506661512363400799235132329"
        "9611094127822440521351999791476209022441638779626597351701245970013572675145669042456116850923505846902122"
        "1019543910350446840555896408640821843961400220187736393637951646466301575756491015220368431665646131851050"
        "9727736135505497758609491007485313307150194231963853639010109636728185073120919295228223264260018917015441"
        "5611027124442793742874753965529671066910351191453495845396281368093624689695699465834057840582376163654013"
        "3747927057892605277115304361791933151276527348358808702693259272579380945576312699683565750443374991247958"
        "91878615672343499909402453340590000152587890625e-273"},
    {0x1.5567a7e8b22acp-903, chars_format::scientific, 681,
        "1."
        "9721670909138485406708209875245988754855499584359380143538249663486318133335425048801360176933315465830102"
        "0938111316690961968819801684276456747470648078446092573136974003930909131364649434410677191755964374461168"
        "9449985149741847522870512655148231642390548825459654618135998463059314939845854863862378838430177919605456"
        "8577661945071167810995560010331333745976303201264359555104651738851008461460823371625460226785030567535616"
        "2650233030360899161133192808264578667329162878470873772247704774334161447668174066561587041726468755775880"
        "2755495463473945116677959704440051349739279053896878897062724521932452819827121021438059285702750231882048"
        "720898070737206353442161343991756439208984375e-272"},
    {0x1.82d26b4d40ec6p-902, chars_format::scientific, 681,
        "4."
        "4690483726796048912736648731122955257354188196024231986588312330742257238021456634908826654127234839916269"
        "4465100758770795918495191617148046111636565021984454301308771295767628366526457752766226774136157158677204"
        "9777232414728237847783800185819300150695494868265399989984303418186913936387103778295846707558587698898974"
        "4537743159905346990806740300898994948523687536782820980310082956562976516393428723186369254972697917639523"
        "7517451055069267609733839616408831778853430757895403549124610101368994821095535082159636545165567339743831"
        "1473563149126607326293087358055222847103895464442221682394762176220261504241500948369995664309148768991554"
        "272721200558038390227011404931545257568359375e-272"},
    {0x1.b9adb0b3a270ep-901, chars_format::scientific, 681,
        "1."
        "0205638445192074540686039149619492166036221303655622880582574223699718851191956040320709720157071445964723"
        "3428300334496957481984272637141040116652643064109299002000714912526722350009504846522887500937742299459777"
        "0942012244050224737963234632599223698388649382113915392050770236622145013987906289250667977440016565465777"
        "2786124745824565716876090891358069196313060797768032150978701298003352609463312591961660591133735686117058"
        "6913634840700315149168275684264190692289543505043910139097370899071681006640009246216690670515068530285759"
        "7044837404540088869708210335900301553691604441179068784764324781639073532912521042956144573308772953464440"
        "883496189282908517270698212087154388427734375e-271"},
    {0x1.51754b041523bp-900, chars_format::scientific, 681,
        "1."
        "5594946591458144416815819205468086167159843664426203644788299768110350898895635640473683177179787484935471"
        "0761890097077391170243907498359928566450028944900998781236203230936550568356138185326342260744947797959044"
        "8089980215073756826092589717035140761699187009768022799578563932926539959419689583937077771224903982883050"
        "6603754515352518370426730719503690418615989945023940422246487398920505321270052974773170110606272759183833"
        "5205417118146670159764645404909603278176701604829743198580484412492486663798834003281774366390347368165759"
        "5362339231688365149446598673054797852034665234088747269980370542955955889926977401007116018807400721172485"
        "495540083189069946456584148108959197998046875e-271"},
    {0x1.00a667d829ba4p-899, chars_format::scientific, 678,
        "2."
        "3721122629194563688992695961022591972700965769964962023979613518831273586889391072823312996245341552083908"
        "7786296830599233560970336654641563328353367827061193750339055849152076714473993684277978272782656779678651"
        "9248093278523380946182387181270224161693471305960716801796086350401820941530293610124339885099370122455633"
        "9213480773166503738453729836723477976233921432682499010565949348556862176229902488779233912691955710018077"
        "6162421733605519251254994399050521606947229834703901001343373353991955700195987881196711778257611305372877"
        "0778315767911073839509938476337268634020082539441903467893818834311806047336796227578822931941039658316800"
        "094184362279747801949270069599151611328125e-271"},
    {0x1.2c4d42a513cc0p-898, chars_format::scientific, 673,
        "5."
        "5511359192841546886271708253316622680838450085144175548410195027433013664293688195461190062847630043330013"
        "4827722505022186068415003251035061785241544879329174355829128492380420931948872833966395029320283239106512"
        "8400274603099891349456086079489507202429780609710291427660660349740546127638820776459982111416694789552131"
        "9811293298057424598688814891254105264492191523450049178395817421850597417689862288876716646753931200748381"
        "6862950901304269793360490536140388506490900700818282906806961856225837425294307204020811869910715963415241"
        "3919749269646896273238207930381447337881848530251103441328808489089045268485281854014309335709649584605224"
        "2040258306587929837405681610107421875e-271"},
    {0x1.225c4c3c8232cp-897, chars_format::scientific, 677,
        "1."
        "0734739674446298024207248229790974212690206929738748612035688298132431930940767808978781611808395357190463"
        "1495036629406095455507974294251384055596725229006339887006543979219474079905078476701423633851365003304096"
        "5533581637264699330161053700604940173012198029893482448464528100444472938931188041028209567758949481905183"
        "0490015311349228608723684009581342357121335471812569531901439452988004676219145306228626404952817818807907"
        "7542648436105191086071959808006028363021097640334464264306889872584610305498775551918545763871034864670939"
        "1697784898357237005514529545736458270109663587122574187506989374675610244730559373166968547248456823482850"
        "79432681499156387872062623500823974609375e-270"},
    {0x1.49f96e8fc3b39p-896, chars_format::scientific, 678,
        "2."
        "4398554262702667444398148018038098952470544215124227046286789042553768286136848758427981512172714445409930"
        "1156432338778458633994988719747981697534403350242401988431098023618401338421499127747850118979962781370625"
        "1582218414906726136931294160385412469197440440380909570572089389208878233063263470015565582345570048109359"
        "8639683646815093873774935940375258540408008971091122482936133784909715421457345554809011396322005411855059"
        "9162338229209184168112927326017394605260506607024809166145756193292992255504344399533818727388472020637202"
        "9841837099259731932443851592118412411307461059862509222808177157336752523381613241275274954877922857555982"
        "462385291142936694086529314517974853515625e-270"},
    {0x1.d02b819f5ea60p-895, chars_format::scientific, 672,
        "6."
        "8642158764630495478107887035397014093806406478739147400934802190758122966145509273130663656083449116193388"
        "8223685640572561914307745731515469808330697336384232242413969293063536569077723416762396892707530258707424"
        "4545467438925612214275881601335127633854291543549312798476681105264979340881027849188655526015371664367066"
        "3196129370831861216770934862924684216985743727871460443148241127262602309896093569590960002026708618897030"
        "7759109386838123883489097316625629036908204612253030886781498471111475701705130013263603331962648371224484"
        "2831818245768202447715876348197096113292312233505987050190351763242747076189226988458164602331524196780765"
        "390002443382400088012218475341796875e-270"},
    {0x1.9799ed1e92e60p-894, chars_format::scientific, 672,
        "1."
        "2055339469240307377403402594354358674407642465821440316185387366532834818376870794496751703591990320577027"
        "1070113114076479488114135898545635834909792131037998106545850994330544371266945740534776833488374278778857"
        "4210076011956356747276577674394094443595818534447499249115341998676084394486307876183969501905326447231792"
        "1674817757806138643290162179595339950043670422343416927403419489541542045362472536831804335763027721048931"
        "6956915292444618610846509129090912794604455025923507204700630210668066737375536920033779883548191818661184"
        "8963048722354732914235674141422188511695223505091651304612258808796215869856934551053015669443762235800432"
        "502941248458228074014186859130859375e-269"},
    {0x1.01910e9dcf23fp-893, chars_format::scientific, 676,
        "1."
        "5235738192618518189936618594353198373490038933641511179090306267605182024133053338385048719805469080900154"
        "5957303087100560223792006622980536966737234211755461011587426519659509365351506623505775740873732101274705"
        "9302244480684314824553717385232770551514728255582443659403778984013667349238036092179546944931299320331086"
        "1757505321077871877040854320771623366194214101040976735574958938663792105124704745406309365766329618014782"
        "4771690982829988866222038776007404704345799976200349382370719198260584387074295575308489654601314392380880"
        "6247650486965191635898381488272370659215232130706305838899655353946746170671987732614538924943360375947442"
        "4588216123765960219316184520721435546875e-269"},
    {0x1.55d13790babe3p-892, chars_format::scientific, 675,
        "4."
        "0438764974429647181083693278793666999589651788371231605969383877729524560726610847524939487893537632362689"
        "8846861862368755886367916636298143998039008428394610535517912002245989309306202382454578439356783495073513"
        "2918308903968711752955260187817332338525640497165750231938096458190808206428445911366884923501080893523954"
        "1206093029385768713858239491000151225959463531583588963736180340573010650508237574015975946010392644014468"
        "8165168171854738715370375794081116073467023962896828734809612148557370012497858203113645628993222560967395"
        "0336664355143451919771945115113191166252509180553149351063482548119983121858449386491438816394778188001261"
        "909345629419476608745753765106201171875e-269"},
    {0x1.7188a97a16f94p-891, chars_format::scientific, 672,
        "8."
        "7435562511428746407917858121214372902879051776678981737976322047613610624282685209507466698778142288224027"
        "5455082159625173427591657526511616774859950448070519505134802050234509915695099201889128074783085073031931"
        "4819188183029263829944697648815507866941818927878058242566543632327940530631337555099540355405781631178699"
        "2808924770387346666342826175687898745708869277309879509815729325382945015154228534140524374264126591488175"
        "8531162780816922738713821526003173659290088391480469742480863935095626092090116984973808179531069736545259"
        "3665854547305770395594226542202736076609270724296938582309549515791111533078749081279345889490509807252804"
        "908017651541740633547306060791015625e-269"},
    {0x1.3590ea1f17fdep-890, chars_format::scientific, 673,
        "1."
        "4649312749107112699249078612253466255139190610866048930207234799841567003889985307011573295308929480552062"
        "5046779174563218713759188180095944870657550678355333052939808456821890187651923588680269654593860121514434"
        "9181485500931165058227711343981064209269072796191838297693555979340057353274795768482966261660740325721905"
        "1699070179918086660167018142370691860419426843786474241321383571061970541818509874342719546432238383475256"
        "9862600241934899065233608023840660646981036704306246328305078273787020906287373283828550532772777376154504"
        "2382603061313562240235190280769184374891864894990808094527898696863693474382944773192204352614134786180616"
        "3432873972851666621863842010498046875e-268"},
    {0x1.a490bff22405bp-889, chars_format::scientific, 673,
        "3."
        "9804068003253801924882375719417812536118621472122388416843607937530335021800715604245101187667554747013995"
        "4999377434052851878178252101539359394319413669582928785161047412343231670883353111905217616764325459046667"
        "7828829988706129136467711963276762541096135592752188769472589597065685993694758879579630673912948899179398"
        "4628734396688639664301833802570854901924189530778964826733402354920570755968722831348583712843989489597142"
        "5614412988732348614862400377153642464721973372576680409450027908761770203176461069618154939055565879769143"
        "7413131078539175704147903187697872905257705223315772497825560770376041116692908571522268713665397078024094"
        "0907646063351421616971492767333984375e-268"},
    {0x1.c59bdc303397cp-888, chars_format::scientific, 670,
        "8."
        "5862866606155157862058221336345820574845880378878616534766461334711933967608601405237094305285212951224721"
        "8811224414549999834241924697168185098548362501537290019314014899176707940187530956780726325235279997326100"
        "9452705579499169901168981268202020899909243284637492060661433758304632176006814240421686409284667595109084"
        "8814780526424923767058416281780691829025801360594452925927646668861343662081573038042895131100883925664927"
        "3434566380169524829965025455207365527009316501409537452384812648683458666570530994016398472257935821870147"
        "5792921574606565186297310529472246116485610860468577453516637959521359804094235499407265480713324131561980"
        "9341797008528374135494232177734375e-268"},
    {0x1.b5cd6c8c1c28fp-887, chars_format::scientific, 672,
        "1."
        "6574180187301560277042993359422084230465392733787051007866897996899438544490745152444688834530645625295640"
        "1232710668621853008468276391128301097900292398003336274182420225374479310694714219204498291060859779351667"
        "9876740791517128544885924840330252161606481575353740949876187647749371234129360568830223801641060064222372"
        "3867362631145241282908960084578297501714717916105706062353536412253151235023622382582131429436080455694095"
        "5547690271019911428549317360851577278100317763948693937529484290614370922528247233871396511557553970893932"
        "4974793123602180721204916958184979393062444379753888516263944185940942548772357521469280603746275395797560"
        "303634554657037369906902313232421875e-267"},
    {0x1.dd323693a3332p-886, chars_format::scientific, 670,
        "3."
        "6131068345429969451130373310115607099294864130669813892800930118616243487082666684796081077226753480935212"
        "0688722595031185095810662074858300293333264091798976751709329421719319329249471449113212585104216180364902"
        "0903052455642472114216144930468732881689213430973791424810940744070365363417199107528165592848991563388371"
        "4239891254785518595031411885155607054339603011357809855510923231449073199376203490368131774971870870529128"
        "9254522590611068555644306549625893758075882651211411533144826878180312068875356012841418042267850727474063"
        "1152624795386765656842235212097365641842719519291963550795467751354357546090784488915890550681843124830594"
        "5047150089521892368793487548828125e-267"},
    {0x1.86d3c9131605ep-885, chars_format::scientific, 669,
        "5."
        "9183241751764955109389764976714155872620609643410243773660851543979583503245329654584813732786527982073834"
        "0521636420852725417997261615447417981415016882734448973389564189606166822481467349095902747600636497815870"
        "5655949314017730228570170646553719431745599699755559963097604629279063754642229864212114707279675331717816"
        "8440072594592218022370998643157234465370967008505124175029486015944278448019481201861981653551367410858983"
        "0359527730465346678452762668709266971955765590228540631576870240350592327118633813432163334893809956910105"
        "8186934058654616506900726068423578479775270344220112716254835138009906792965231941252390889503048020114928"
        "107204832485876977443695068359375e-267"},
    {0x1.85911e81c4b3ep-884, chars_format::scientific, 669,
        "1."
        "1798475245572565258836463208928683635416019155375711636848835775165384607837563334358573139483721738528709"
        "1120028390252414848147343275955457018828059343282834073062154638169876178683144127461935561949669627002417"
        "3685557443459253842752241847183852027161270157839527291020148506061113896949022943154133603759166570662569"
        "0345523867216992200844339835298032472528560480231572053267575814735819031230558839583597348451054026157224"
        "2255926498453096842484137847010445108819535016652319334499549429994953654304666027843239794666289393464823"
        "3129548468640073030619432252064931487614833495014858781346346117845149269477579183027503827919826688563897"
        "931771862204186618328094482421875e-266"},
    {0x1.fd3a7670dc2aep-883, chars_format::scientific, 668,
        "3."
        "0845119288706609241776127310550945770260699097294636090232555316906282397758975656802444965817572435648830"
        "9154179460646805809256909673683564407525994808351915660324637706817216948128696931536528727801890757276085"
        "7821998571184112154093996098113552610554410114972749654435078757144390250817251359366357240834609588333752"
        "4472602522735858303857046884402733676415512137932791990670019608401150097071887929689475019078052824432695"
        "8169030004334188899958031100736000503800060878357350714914804570705622357760565433666940637984589125351111"
        "7578209700869532329366449360905532226889918970109979920440676664073492291325343965342652658654645433933261"
        "24487430206499993801116943359375e-266"},
    {0x1.55795032e6bd0p-882, chars_format::scientific, 664,
        "4."
        "1367697432326765352340817035182743358257354812683967551470618307077529029943028853088076762554639432509154"
        "8046642335686562972830560848535832043202751676119898478727926728300673178723638882161179194197617980196622"
        "3908838232485454712767866954880107986586331614093671038168594790202349294527476303912376120107032564932286"
        "7198926794092379193979001160520283118740890457050606561528368852971588670160141873796334891005265000215879"
        "5052277642750755249858943871277223658376131404786971097472549039306650994514211262733568954010543397543745"
        "1964937117339719316717342057260783566644006824506803928857754052307315246529116200657496496984749656533608"
        "6860042996704578399658203125e-266"},
    {0x1.d4b623359ac05p-881, chars_format::scientific, 668,
        "1."
        "1356367562498619145310244385698473525427283564803902471480930973319788737231514592977108114965063815055345"
        "5830977379024144088680682202364780595772824626362655507626398656976630817003866602520718605455234378514735"
        "3087788741804559931776255025847515183240478076966312904995778458881231949209035981411121604045278278843061"
        "6977268547183960163850017321591993093447821248669240119333705313884423383580946619081395963426489952177610"
        "9997766439665027209396002034188443586122091652193792470005755939774105652393587570468729608467321990883421"
        "8208302180369362225717108121963705936493691882457994726492485413609210469134484467589008870790296193420410"
        "02028054208494722843170166015625e-265"},
    {0x1.3fc14119b6b30p-880, chars_format::scientific, 663,
        "1."
        "5494624584252723975906249583375352303256654343181075171301275908694037222380263592504310689836780104021758"
        "1758123367338251903106006965951338021603071523529116946521691907573658498425349392869295127718000433929885"
        "0163756715521637210713685129495086748985049799710299739775854204400714728515170031210558291615920547395211"
        "0992782609302602588568324649970167427445308975305630972919772035489011201841001127297023151195017709922837"
        "8421528368003116558663783106453961275883213934228645792733584503015487388799720683461887271416060866520401"
        "9257084947262289315617219879609164279766856157954598104804131015062387788537884648628367603544198072285098"
        "533029668033123016357421875e-265"},
    {0x1.387efea29f7d7p-879, chars_format::scientific, 666,
        "3."
        "0285755370951038681608683696905621033772278330728553552206929677317758937278752313911937150897127680137831"
        "7003552524566357980703032758133957564184151555886502238750580053267415635428852577548128543311783224172494"
        "8681614868585096210717704389551477048999401562959159801158673751335958285076385209833933722745096602678100"
        "3143061720934102794967836052054893105516224558881550411686422692703782419027059745570753240877996075484408"
        "8749613809519051548412628920654763685820783842694818471287892370778516701681078600125302612513778414895942"
        "8881521605742355054257217013573044606787074642577830411006902168840320052258179872988498243578485424887247"
        "745573404245078563690185546875e-265"},
    {0x1.e65f23fe2db0dp-878, chars_format::scientific, 665,
        "9."
        "4274033334811503748528404757289384726806770032674327402818133341840737332411750121426215821853365474391355"
        "7230387790285083933191457903289270345596270263672196354394182427315526000880649977141656105787327135299739"
        "9155480063881212524740495031457329664415784460015536413542144918144920982279053472736448128968434148254398"
        "7888277231002210993520750386501402122475620747774111346439482660309836582783279713410116736596619463882867"
        "3812504921615547034950622887983231873998865416652468144478421626318837183678578001787452762876752114351500"
        "8392129613740783506615926436788653883816643418293983827325355790595619401175112158521708318652601588105710"
        "56164917536079883575439453125e-265"},
    {0x1.be0d3381db145p-877, chars_format::scientific, 665,
        "1."
        "7291748366915169805535173361311690336060863250937536754419109791788940622928061477911081864929176484648733"
        "0392740026820608012717601990878326637047638718248681993991531006456103430748094806588017738041317168594778"
        "7021878692496904266200427795631638810860354316879657866121076029993751741729645917063224939510035511898570"
        "9999359928300674405002289342033156169213644776362614794679384856915080325537702909530580016470514923381118"
        "4731189167500553098889569815790695467489682656267030416780025246929633596118386225452442180730702839693663"
        "8818669944862651345233138879791333792498482753324138047601610356877377484188814783042194078233402820821140"
        "72181866504251956939697265625e-264"},
    {0x1.15b4bb463138fp-876, chars_format::scientific, 664,
        "2."
        "1531241335994102581545421543905718553261205634596225205065032112054906757350946064401973884364945201367158"
        "9193498889587342518389527340691619196698218268405950444924912994180329555785724990446715258463485821370710"
        "0297914720890097779169205883809457497940081169726676329974463181247441649888441390421006496972025799387444"
        "9869399622491655605240174565953844905584693276335440945576505682668112743945032654000227377822639620983203"
        "2424628169867278960066124057642301935079333533998374656641508551131984260262634639285697704413869791566604"
        "7058344555168615768293471860018877719927801421962570793677149082526170886197341877046699512490007810683323"
        "4414807520806789398193359375e-264"},
    {0x1.c9829623e255dp-875, chars_format::scientific, 663,
        "7."
        "0943811579209456674393546810681034475092272127137349769143575260247208850042176344557556673219122391550803"
        "2134627914531660834653724133266216664851984579431280354615254876343265450440084636894948463058853750279245"
        "4180594190614999429011156768877522268148802551983220139436429766464461164984165663141029854488048705467562"
        "3483604810872383651838979512701583025652350883872278828061474056265146942266842117494952581371563236372454"
        "4745480159434009300924698850473710854892506668277594645356984354898943282803740889954727605047952229451319"
        "9536623800733390878855344111359557724030382934857005734748620310003839032941834111259667519124028078891797"
        "122196294367313385009765625e-264"},
    {0x1.4e746257d7670p-874, chars_format::scientific, 659,
        "1."
        "0372442383613189969714086258459722252660210904892135354666456482486436513413329300096044197495219274963897"
        "8020863794678225957572854635073507252775535164961781534910344480358232648898270595208601349292946268441297"
        "5659811329213404719323722531070098963653390797863993492237598760842383012198699274324054996159547329459864"
        "0580924969673405756953920124756145504369343197985189208048577768929728892896888692456901412684203646115966"
        "4146976253775304747117052161568491733834101439034106718671249125299580172355437057762980472448608774453369"
        "9693661677914745564631876392042680021779683932888965662895943618616656316757734516189595405655232696062739"
        "70566689968109130859375e-263"},
    {0x1.0cf4bc9e57f3bp-873, chars_format::scientific, 662,
        "1."
        "6682266784627316054126786634947099848892653011771160846990224792777416965125633659363823166150708783511656"
        "8115883612889554220377387265788086029467082903772667492283129753284952803154692864161969436641653582454220"
        "2025731166907532844165700456927285153916176469595705886744314524895022139352304559343255941857888068865999"
        "0319914265277282424260166051913216749835283576431746611538506471427827307023604012634806795610432203420196"
        "3154877669659580960959116015504309990919735860857543724951224894412485861253372083552618782145415839816201"
        "6695152261152695946643426485073285270438041876766580343024065650025617255398049533262602511438088548345604"
        "06743548810482025146484375e-263"},
    {0x1.bca9d75009185p-872, chars_format::scientific, 661,
        "5."
        "5161395008185867433415357299266473202855702442652255015417473346516523059631823879137334341688412064252201"
        "6359703316218905950439100436732933226969082782786169311545430229194074907477275505071792114832480787270717"
        "8915637107070607758223870410283818480871009382801702917218018303290530391528205160937483613744722094375755"
        "6647797218095071645532979709602538130511390566521835079669946838247561601190008503934840995758658023290110"
        "6296333354593470671297966973754686923720279528690270848804834944868781772303189955069294165504271947347376"
        "7583033498736701881264169093594528605625061561557706388575048347185417471798563922342096155909674237705075"
        "9387202560901641845703125e-263"},
    {0x1.cdbe1ccc95d90p-871, chars_format::scientific, 657,
        "1."
        "1456020464232507675057122277543685119216460557168252748157621249520884155966158083731684691602468224843210"
        "0075159391224235566394108391370020174395111096729007531631823808928065243014130184606154497386524196017218"
        "1110143712808599775710021657762313485166911340457125405068169443597769672899512513065315032891834699262732"
        "1908035386645038986601439051667243567979139672430921599967702480280650531086256799068476585431284585388240"
        "4720314532219838347561762351544068566196357919731108439498951529832585320483185327879968362288867769633642"
        "3887444215207972301820659320054036430922363633794449770968981950183436840696718769035296336955553897496429"
        "271996021270751953125e-262"},
    {0x1.a08e347eebee8p-870, chars_format::scientific, 657,
        "2."
        "0669818736985631229211433609173300771521838259787418165128492129593346843199105889991555630546885520424873"
        "4500210012141010459200844730111260401895114952654803481888935046927199523015310712190548867351015143128831"
        "7341497991035832678659314223700819815496411587815428866045015831262423046888744843665130751642206640470596"
        "1913785805669387095600713483824728909600527076010029285289082448583244303100393919800739122262878737798465"
        "1267691566022679307642868763358002955970597599049178708475928028052269404319007521539151009465828335775167"
        "5552194266495084558603653401864419204157889257764915433524177885184490559892343474975885675437581312507973"
        "052561283111572265625e-262"},
    {0x1.12459afe073cdp-869, chars_format::scientific, 659,
        "2."
        "7219184652406805993113200069724571033116395794260022510965600900076256395056708441474373792056450106821277"
        "3411179024958530270817243162958424331800455670782255602327569922315956959137078323961271124142919678140836"
        "6427948378212113066025708694772668990832057641669827087574149746812408127966499041381146615522441977831117"
        "5038207495040561355208394644648970017561375493866454210039949616609826369918160587076346295322087365807525"
        "5752221508525467227047509182541235289800893474477444565810299484569003495443070616025087922865386504523121"
        "8586303252491596734499946262272599981000921593324190166840578960162765846077581071744836208048390346903033"
        "78738462924957275390625e-262"},
    {0x1.0001756acaa34p-868, chars_format::scientific, 656,
        "5."
        "0812835426747345075553611923477617398987820369648939551306803212741371571526499464855930630049097064592210"
        "1122379892382479717106538369694733235716438656264863128490731915205653554091870063362517275282717008654459"
        "3535922167621228929536166429804941621134212881365185181432564583359823929240075429731442028191437183310347"
        "4322206835097502207668064791097777030747293208431008738427234530056421963205800084404703834502602573206400"
        "4422225278499492883613711474972843024484702154518332563961230115989187179489623402654993380597009086900293"
        "4536386965363555076444252747751067112437620044942160741851891286975974928623936015302867130749575608206214"
        "38324451446533203125e-262"},
    {0x1.a923f6cf5a94cp-867, chars_format::scientific, 656,
        "1."
        "6876650530578207621570229952797785644682110844600730382828697983205295811627431458729119705328829243777096"
        "7196655799942541178490674643026183703121754253538937824062441208188206739880347984078224093935173556451996"
        "8428512418545184148127106046414566467839390422090352343007549697592858950809976923310636041815949880034513"
        "6248794879877104664837625430195393564841311745786113921932455203585099235154424807349383493024231486017916"
        "7453641477542234843453022929695045828962922773750009075946875267007574023695528840568813676232828754491306"
        "8646813805642245606261257736522932872947412755257832558074192370113465124289365328893661177822593799646710"
        "97695827484130859375e-261"},
    {0x1.1ec90c20f8a14p-866, chars_format::scientific, 655,
        "2."
        "2768831274043772176382445707214941137050004819857296684931317704292669869186330235385392974936135583425559"
        "9391396336854625037981166318159043959947117232845747306996155023939888756843144321245127560309680255408819"
        "8239536295503375270446676949521636344483280297142204797105650413943143524391493206834878212096730282097671"
        "6001570512136786783004641864845978867193614401580700868334274804209917513296587055016135300878023975459549"
        "2547459644523442197433522979067269453221697470469185215254072576985178910173696058780136578510752082477360"
        "1510406473818284898811639918943826900408540402073733604377575240372790188611135900765419792790567043994087"
        "7258777618408203125e-261"},
    {0x1.8c40010a69bddp-865, chars_format::scientific, 656,
        "6."
        "2919183472541600602721754928426186640791713919207735791429339647422629100785659522780692862200166897491701"
        "2555568019104071065737204485334987194383301234768696626240704934209115582338286117696015309238068919260879"
        "2858350306420316229909315039183892926423127496965408791803311714197177193889783060818926773096147698988342"
        "1151170779345326896958734602721257311763761737474562447460745166179129141239961621209497591323866150735669"
        "6648749093728161566479406697838649713830671083063257024116592611233964687353694158987479949427380270159845"
        "5838968120913239056997624353817810715748408942055331411763298560932984099783720632762321067765753923595184"
        "46028232574462890625e-261"},
    {0x1.1efdbfdcbcd2ap-864, chars_format::scientific, 654,
        "9."
        "1140703092024367155067044395221164452736675833151013263211220841163780409432338993660009501481842296218708"
        "3495412014520893619544114461468039750464209587202548042016950090674691007785016340938454849306345780627414"
        "9209340633047382140528725623452408559558958439548164560966946219116473549606304395767765048257811327042187"
        "9425006157651070495838384845023596106870545840216347820462109279705594517393524899645116315147968384649516"
        "6598556482074094825029100883563347947309602750682254364482901382848664076403072603858551382288376096255467"
        "3920959090444603889415032225272728877288017133034340098211825380764598208977109714858111377822069698595441"
        "877841949462890625e-261"},
    {0x1.906ddfd189240p-863, chars_format::scientific, 649,
        "2."
        "5433112499173347793194125621710163645079369331423202898876274087013265664417996337089113018887096628689528"
        "6909980735596949777809152245542352924571623599896408538766930694228602626651083775966167899682411094921866"
        "4528453283677257072323229605736418093485916168131207495359269594380116782753501753335290525716376820637813"
        "1651313649600349107789087387461150989691005378537949674398986598192233131311058346321863230434371277975115"
        "9601698778173244506374886663889558909304985006734120160002143650400648095280239164877277385388078424667808"
        "8998821393839777960585285786855049346501567034793016761392974678965713676407917748223397325091355014592409"
        "1339111328125e-260"},
    {0x1.7ce18a4c43eb1p-862, chars_format::scientific, 654,
        "4."
        "8383034142174994104272069838127782959216294890444624860488117740479459442612088085799847149791718592639569"
        "2514342169545748844407930478209370082097698966466303161266693588296916477694843719922217257850078663588627"
        "4299181215882835731412951066974921021211756829121808175859818791449336493487434400842599626556712001876150"
        "9667718055608502897452028494895946834053067261106309416912495083775349051010869220082426966767527218818197"
        "9310566617032157898763990519492387274070392056149682430213652686973136279413174816037833439958789749907392"
        "5267530473811700835332428644282412990851223505003816036845036704538201885036357457504918588853115579695440"
        "828800201416015625e-260"},
    {0x1.782df6ed4d7c1p-861, chars_format::scientific, 653,
        "9."
        "5571620410084553612231327876427113790261344273014651312134653137692369932119559217494148337440282302224113"
        "0263997567506024287148387776798461354301437476844010018790776658181862075147468952135479241966863723499456"
        "2671930616485340107247684107637321972451853389214118467182112388997076370539357788063452893376151729748408"
        "2915270789468943416839744708329469795749877089097746641157553737198869698139987185436460253491149445310810"
        "1743200834799840591710632180550687823669819744527982460287775503302538194712879042143801864025232229533473"
        "0678286714386718609825203493845270564103948780979172013971383228946576489832464467236161631547020078869536"
        "51905059814453125e-260"},
    {0x1.c8f1f802391b1p-860, chars_format::scientific, 653,
        "2."
        "3218163991190385364508984250447706848286720702433334282915779197051348928890111569809302423668131306768854"
        "9671606004297189773600697112362201312947071746547498935123129686311916312718213019473461585470236625342179"
        "0700948554276270180610568750669698346074396782598841969164523910845529402228142249335459416846310411634554"
        "3338728832295769239658657884743735612915332354292164849060945176872147230331318167350766692977206334410141"
        "9125790001753935727822079685994595251980575717534807762111364585832641492934382986141296078256014490691906"
        "8890930223248032001378178220026349482108995119241996449400126609003650787411201237078750558850970264757052"
        "06394195556640625e-259"},
    {0x1.b4262171cb3b7p-859, chars_format::scientific, 652,
        "4."
        "4322942901196376863360319680933694654308997921164922102745484052756965358320504133937620417038428351006134"
        "3936976933967608342074121415324210078587243517426577185350093924310156264119225838613696398659496989910420"
        "8353518232315947890478652282094992701578651352178291486176574508412703120463808237396444949047768512976373"
        "1251327511010233610480829310705679565613059064973397437654199701626566854193403167380367233618735049297794"
        "5056134852446758581372606649514849162314906568429829544233164063991054988715229534439385687585779318932257"
        "4286727246285838594808424556563360450020368516054773532563608037624243787652624903400377931461662228684872"
        "3888397216796875e-259"},
    {0x1.64a437deb4440p-858, chars_format::scientific, 645,
        "7."
        "2486245456651862023472574370876819260411370718249819818743335943776205307646101765920973802250296286459327"
        "2610893461273931317458322627631905835530944678673175436224034968381667303539572414025175474653846060626371"
        "7734775468528471925761988836228340907693385947639524028564463791929467246414768399226257697924451237021644"
        "3969480729800801902101353001138560925948801924917672399080489050286782872517574693040850996560237083997524"
        "4743120699197301488506127069616803558654617805738359241041246801384050437850303366990706136685985225470569"
        "6051810053431151300980240986285936866882956104322697194439226699982917385446656854952607318409718573093414"
        "306640625e-259"},
    {0x1.68d1c7ddfd3c9p-857, chars_format::scientific, 651,
        "1."
        "4667081257360905122219545067067544733163746805490966430488449206414100150968687775032402756052292826192310"
        "9033050351341337814114817123415079541930647873262150571704767679131224864582828071686888611188799409109024"
        "5011385394511550083590844403769171740415813831118767837488500000872271900044128369701757149831659567051913"
        "4569889281021321327141354177750096990863112151715710379567247962185037697773480199531512073678158854750890"
        "5840170569256617197434173544665833127001525561200203131031135463571741228836842304648117709300656826393728"
        "6667433592776261377970432715687365719647591411294638482443774640687500004641624813672695637478682328946888"
        "446807861328125e-258"},
    {0x1.d75f7e137fe61p-856, chars_format::scientific, 650,
        "3."
        "8322026353591041945549619532350115070542582231900572219630335353346952308164980213456390925558452250257609"
        "5232494591328629456449452280125255079148668498861800706754585208817826976126668888145120396190261611609172"
        "7621191237931458727896037788052038025879689611214479161439961002799972418744907169391423514023327463523140"
        "9141504165184730552533850275002320357839853008554356923544887943781694190440637960551088058658109244864183"
        "4918347642188228638308919041402117875214276091388203088789844277557265644615942295037352991745550805324976"
        "7938517447633564168025048025383225174523163173171511655810658287115429190399515727016854782505106413736939"
        "43023681640625e-258"},
    {0x1.ab03ba2215decp-855, chars_format::scientific, 647,
        "6."
        "9431480258533971970776226476780070833439447534419340955589877460326824250672274858385074795336068109179111"
        "5181741727644326382169942415232772611867462202344841982342436831859881780104169648940151652988950108209827"
        "5370546075553403132538586162373545653948610582831301940723300705685976603592449533077414627581849293233497"
        "7877716272934729294493458229693156484855489071519117809921208470019603290425328615499359681908998029766237"
        "2634261835803744746628765582402678876539119010835463553046443911243526573460491703172114040390276817289845"
        "8905787436203069668723750929115862888028737610673922200768669995165371277212260081590500249149044975638389"
        "58740234375e-258"},
    {0x1.1a8446c1becebp-854, chars_format::scientific, 648,
        "9."
        "1872993990256398393531416600457280450059068320796514631056090469764224373506303894785318601668954036095739"
        "7379178452096086476025584315867174672392450396115503992411623576333908756070286366449656119838691258523423"
        "4303304141441636209538276044437434287446030632450415026343274481569236323844213095362475894936453835494631"
        "5916381176504061003068786853124720741143508000759975764912058080348409246107484554164396410838347897285039"
        "5816761052341102619407499643636683374539552278851416563265692570816851024552511717992981218509470445404085"
        "1058592434129680720256177905954138754010038223227654713022183966981646315616387432623213271654094569385051"
        "727294921875e-258"},
    {0x1.d6414a4bf4907p-853, chars_format::scientific, 648,
        "3."
        "0584908958671776337833997728212552743197169604966979110845813040276451910012854307217756535365938877958672"
        "1422062480805494048637982077473308559243951566395413290867225547157080991564751569942298190170759723875656"
        "7053418426117941253353267909236696526460445120208280487438673462490361511956069037937150670663546570743734"
        "6296769657742269429934163903699889943903922695607261208044403504503321200370225042400066440906017069328778"
        "4261706490929305618215679483092331173245544667709092235091659004587744352478247058204575908244766418147686"
        "2773133919940629127853848611379955271758919464669049389518829342226751666594490586259524889101157896220684"
        "051513671875e-257"},
    {0x1.0035d29019008p-852, chars_format::scientific, 644,
        "3."
        "3327306790247037336907675034392568454272595369411738900867617488007913473551733534201323063199723807019393"
        "4483504697879606878598819097351469420895437630770473232697024322335525318888227840552509675600524255646902"
        "8619739611765019036536534035050301257528705215736828310189129109513417846670742657861223079682981086395798"
        "8927567766792373175362266064722463852642260216366005158732934562712954829503899973208430525614046950049994"
        "3939385349824496739105901495187144509403790073622444198594469799057201540623756926169050435684444872560782"
        "4856932216929044311840257291219286900776173012629452228655688472199201998272255487165693921269848942756652"
        "83203125e-257"},
    {0x1.20220d0117b02p-851, chars_format::scientific, 645,
        "7."
        "4959510555108538799335754813356701754792355065646873389377940176911239971986659490383240376007977904208311"
        "8660847570367526920460011559675059654679049732952640292043242998460981893007748067031656426282809466359894"
        "4693614670185383532442466218699267405223828138978645448763130009589274108419749908670440725967037481300206"
        "2851633748523492548210781300670887434058964089123011544222688423237087102135336306066767496744054282140733"
        "8711019067174933523839551077258961555519024174473109573715905891230366304042366550548239550909206406025216"
        "0684959021066679582680454839013311819960942494580582546135693497151510794086759492671490079374052584171295"
        "166015625e-257"},
    {0x1.3b95c8f65ccb4p-850, chars_format::scientific, 644,
        "1."
        "6420266726944825630454808088054330790688039184429766248449244744802510234416512167593735365107794611013870"
        "9782299643946831257931373691292450527147133474394368778328589464320389279444152929596129775091079169751014"
        "4519842247604265947164098444353337876295194407250912855850267351168187138849274287240408555196983493342848"
        "9933467342587973598710220715138598315391026469456477501218614918988364315987081858415903538046962891966892"
        "4800293313739934982286504732834842708929909888507762225095896368591204588939199683430514018879374199320842"
        "2307913615130573653829855907178088163064254606588826707581097183952044795199332050117391190724447369575500"
        "48828125e-256"},
    {0x1.79a370e99377ap-849, chars_format::scientific, 644,
        "3."
        "9297951542678784560085047330289181715367243624999440411535626335855349124270289750581378228979122629841836"
        "5716041276174947051226059321141415572441753775776361360750193106965033615162658101521745005109053033835175"
        "9584991103790007219099337019871347846863373747416772168678914168817718265590672635122732019115088840685528"
        "4308439255530425901592683130664478484169626574567424147948837034542847458593654965464404208798178515235674"
        "4909406359357588361014427767062561979917000205966828612337591322173531342449808068102635168063343642736189"
        "9279318539070692012686415588482858054953378973526677058505748782057145603377468212613621290074661374092102"
        "05078125e-256"},
    {0x1.9c56d66092450p-848, chars_format::scientific, 640,
        "8."
        "5817991246225452741092042091868243950477436438061983588714379408467689836034614775795371333619284889814662"
        "4881729754285305304028716295937305832118768504741589064001775240877211755650206045802793098231749200556033"
        "1959933582336136059033009322539085521752257781672307684288330420314630742326494970432677741777569981162003"
        "9490095521058458025954384848954814776478898052375202040873522632601594631876073317485237288376180074032624"
        "1165338903507414978168516140117648928081962307140674669659472269099418474948911293324974333980429566047863"
        "8146733257119542873384793509262530795138061221424111646611504484593192093599967051886778790503740310668945"
        "3125e-256"},
    {0x1.421d62e8a645dp-847, chars_format::scientific, 644,
        "1."
        "3408011506316038440876133546193212552863655819964643115232648414608851460824412779274915182857333649885355"
        "0576135355890044448144591074850288974977950713678686563287865201430204637815836053277231611431919085691074"
        "2176504263281383704688378934842635350107826626491841796750832996448091584065997738570818997931555021995406"
        "7467015447979030230032418560932618957121652453967921612902472152407298980304430344846944714451589948955752"
        "5437413743051434352342449627142280703374251033865227110536913247629525335673340273427147625680436359716961"
        "1438811713524636803197146424960795969018772423073980006145654577415796343889398123394585127243772149085998"
        "53515625e-255"},
    {0x1.715254a64adb9p-846, chars_format::scientific, 643,
        "3."
        "0745985371377658309028784463801492290964511331496359833560993895247133471183641249699681449552243237472526"
        "9431831755931005890372074394881882566245495978107635358098347060477106877104572904855819242902252133462944"
        "5267947457337839385094549901547440113445942355135938964379412466831551967266918677931538876399443000538108"
        "6549704757852670657762062506022796246089046295743650517804858349388973761791892305019059446288013874091013"
        "2382985115260402448385415743377226016102355004438263205348482304617941213627282753219081015230403317774960"
        "7573235824693271311509414701066402074719718754079572549356306768426427920154475614822331408504396677017211"
        "9140625e-255"},
    {0x1.f2cbd7490fd30p-845, chars_format::scientific, 638,
        "8."
        "3049473134495637562783372335308040826947988947911227489305609217047398914763715260955078525106138710236649"
        "8636130716831502004815770007428786901700220001409422949750681686209887083042942769382184521970832898856698"
        "1564429427030907959956250390354575017810396993435701154688399222312002352067564686299288641194649680412519"
        "2055831811634890274031010872847387842015145697773860849597339982312872612038388001018205969465761016324883"
        "6221890713622421785887916102589252792760578729135290979060008922160938551159483058864969866471513981057877"
        "1325541600104932329110315094541017055279256323295198054372855898377578376390317771438276395201683044433593"
        "75e-255"},
    {0x1.b2aae429d3338p-844, chars_format::scientific, 639,
        "1."
        "4474411243713316867208977352315208912748300186833139035453984167535475363914803045214345115839914983070346"
        "8107963464265324484638353285518964551567088265107554403873137980901895793359340168401743333116776228534381"
        "8411044885533746274434524620506219125995305723357527314776166432074669080741627207730696930953203477260024"
        "5308586568934283524523440596892702417372491246648480892544416253172082204519214951423032991733233973222191"
        "3704414744084396980182542537483986194053369028249533947601013624027010399377778605496838258484958724080102"
        "8509885320895297831483040255143194596899156238644941664600889849492774963390928633089060895144939422607421"
        "875e-254"},
    {0x1.2617611e9b255p-843, chars_format::scientific, 641,
        "1."
        "9586457971591684628123217698773108935833562264144584623143719864276904693871407795456172875015943670393176"
        "8778961167502825335230168197000394874158844610101174297566165868577953600731530124390559329841336668647646"
        "2468308974382408845446004492911085860270135950244988831730889623751367135007863460811455551400837050028746"
        "4166926141825676068445301167385514883698177546176927308109450223226867704952176417382444892612246343386496"
        "9518502089292929143453729778070058866366076873565593983608492151377810843966575548269321853362612694434735"
        "9338761906490029759018080945247530366860736467759639429490063485076465146783597504054341698065400123596191"
        "40625e-254"},
    {0x1.5fdb1f3504dedp-842, chars_format::scientific, 640,
        "4."
        "6867153674920416790873337244849971076484220776787110409945879501513043147393108951843513448728397762554022"
        "7879888252572412233135500143521775531145980390850992942943675033022307280642493210611912876680597019732548"
        "2421531656498659115150512846925176018749355178878646041710082824033332351824268692851830401035105154057711"
        "1375092493159921425872818144761750136660331176266578771858537248827685693005467675230328337994759363083192"
        "1961798272782320798169726042997383300927368593567279231201682441735999054882957709060176324055801659088172"
        "6724432954799549383358558234672790149531275862362895256284006733585745935188882071997795719653367996215820"
        "3125e-254"},
    {0x1.f6c7a277dca7dp-841, chars_format::scientific, 640,
        "1."
        "3394037849881334765215059992884678582059252311456778113974098621513971288241782735420610917120016976004897"
        "4101237183118229518455257182717275229827659782720693591974491238575838983952697201911225839142407518108571"
        "8387875308026359155400107105741151539207807846271470685787797198661393857298908016252366323393251433958973"
        "7460426086328194140128257808492826202220353818668408282284630672148896793138260476005062793728842134893731"
        "4037303402325371530047168074113847203340154903164323156507991141932470177139673422077096863737284741727886"
        "3808972654184165400453746952390769201581688574999827740403704881609701221600872145245375577360391616821289"
        "0625e-253"},
    {0x1.bb9f1504a1a57p-840, chars_format::scientific, 639,
        "2."
        "3636119615931954460250167869238911011154326491479430909872707793904843481361199550716724821767345510198869"
        "7933841684366181492076821446815839454724649689656529509127038316112414479726862331466461938824094976797737"
        "9143220992333278223132260837716239494499620700131088794260669791925469170854867933113640126889557448864829"
        "9498325434878096355990555941114674441441864914479110196859470066198102332189630543298418737541697203517800"
        "5724591334289072091451093449446509958846630135866773448711738522258235844477343690396553420497616058860223"
        "2307735599284641966598526646351415873074695035701931182197892727567777038100160780231817625463008880615234"
        "375e-253"},
    {0x1.140d6862ed66dp-839, chars_format::scientific, 638,
        "2."
        "9416104456955937221543776398156706685887661223033136149978144195414487069880048080968267584297336066506254"
        "3115356949437725212090915600835200704935405467625569119444005558649057853906959361320327321285798225893023"
        "5229317177289893607816570293832641314174027421888172164237619051576765081507797361682755327770880513040405"
        "7575826358204046303559225686729160901856986719048077867296931804843574430849104888948208416960160463531835"
        "2482831563717046642268932327206818661898710868016377802766481100753130432486192161299895341263446334301439"
        "9966471714416366962788461689772484722397543415502179310786106319420066257386281449726084247231483459472656"
        "25e-253"},
    {0x1.1556a20068f47p-838, chars_format::scientific, 637,
        "5."
        "9106288435436441832925321437439273066502477312033311246968237725276751639214797258968915217210458498406519"
        "1599955142680202342645938198876556661177979692713340361790875196351637828414851815092581530891522562889255"
        "1785526041987019154864916301964965994784344521781015097700885197871228199743117772247657733964373336298903"
        "3343024133323958002289706156266221722389423041489830227675743527604713272295232402604297526043610489011954"
        "4521874334868186828399600397263829823264455558567290365650686459810955354562951522008422782247078306179082"
        "4274297798382230073449857061911562247122871488645554553253686055815790956202704364841338247060775756835937"
        "5e-253"},
    {0x1.8a637844424c9p-837, chars_format::scientific, 637,
        "1."
        "6810396848558273510235799637525049545294830249948222214411090835531380563125319563203943253866909216175104"
        "3257048804487611404557035566261801859080485790221260947098571342313927613866021217690405138818610985006226"
        "6056665647550736011704735446153339487543803430367841295100167579486103332587829562856169336508741156116699"
        "3821573800278394690338640699834125530610486716022332187450360770206194564289972002012617700416236636708103"
        "8543888500074700833328077519662860658313152207041831981854465792023538138098947494890681839362176868398994"
        "9485522109183673226012048016787838896032817586439816560580009379994442797467968375713098794221878051757812"
        "5e-252"},
    {0x1.6c58b883c43eap-836, chars_format::scientific, 635,
        "3."
        "1059777449559429265900676399183362537453270079840668482441014488765656125936602920378930602673659646522508"
        "0750485088311931270354408819089265208117161050801207000067848396965880346198894113665199706590577342696924"
        "4262616672598390077967522675156490575620339033736544018575331426236187140125932174293413904931149686676806"
        "4298338564655493854637072357239725464925528075313439590693619626864606148281041428613600174497025784538263"
        "3459579611621591637238666391502205681590372801573488459837345671891293214092887485037314994884435306602798"
        "687276288545989827758369435248803257946775797031683187521866108295187647314605783321894705295562744140625e"
        "-252"},
    {0x1.36a7fcc1cfc46p-835, chars_format::scientific, 634,
        "5."
        "2965573801445690722158614076883511123532332685924214717774752426044438667279139986749437517515188177140269"
        "5485375202212937664379653938486718551271787640302576447258297441253734512519058771847953071990841730343795"
        "7327930452143347292118755771583009879983230855464894740311328415111572092561634509970907891424846710866942"
        "6864597398228408661760562863344203484553975704767864965698077298580010056954322574128346908080869265075775"
        "5739269716961846858456688528224803759035924554112211405402620391714747114614201404766504398808292555529737"
        "18941456131767751776122974578049807479540550113655955376254567783245175149886563303880393505096435546875e-"
        "252"},
    {0x1.aa3b9d0ec1349p-834, chars_format::scientific, 635,
        "1."
        "4534181673457758400949055236695221048664713095250053797426519767853237041835956791976580225636371098279321"
        "3214068181046129672798657879984495167728061963953124586161238507439156789985644488887055291390992087782055"
        "2701336906544502774398188591604781018114504110735607946242802648806954749263291520974122404938211127908934"
        "3575631285032666899798293647051957896468777447945107059181546956408240664336422516004145304588450388632522"
        "1070737739693194936546919810702692652603043565212622312212995327472532618638556231986680206742586143722403"
        "550783309924285289349297072101420663057753817823364411493644089180821143969524200656451284885406494140625e"
        "-251"},
    {0x1.5f0344953ec57p-833, chars_format::scientific, 634,
        "2."
        "3938479247234097018550458511544817367739361536200950902814825089891669710214106361799807545093859687694323"
        "4520222814663334325501959922339511022417169200258138866716240572516473903243780418299855591784687744221561"
        "4673730495274627840445980495455053691946265275961590944942894884161146186125918812095405141490376065791257"
        "2990007375277218500031379100913127364874315175834774396942682472145171601247554709419898298359216080654381"
        "5234719036377453626738864303434918589623115748337487232265520789623861131272396012356699775618072348868787"
        "76372878894847401207188983556061557308620341306536104552493931900414292357481826911680400371551513671875e-"
        "251"},
    {0x1.783fc5ed947a7p-832, chars_format::scientific, 633,
        "5."
        "1319111420103700499236206263878034212106202950930977551857998220289308747630115765877892885472362039275322"
        "0523269264416102554328703892784714509871799045575377396811614393505255988764201594860924728188446262020599"
        "5816224373606402176926540883831558717591219455218087384224255737945036264103454832864541982601681641504954"
        "1718987656545856396071620261775045714406002201539977040442012225019186665790253178924857163319970339024221"
        "5773002375760167632603757343376191928042229339921704578692579360050525881528852289207475083143721754146523"
        "1243409180954321670387197333315664529506371145190073701706340823791574479173505096696317195892333984375e-"
        "251"},
    {0x1.40710848cf107p-831, chars_format::scientific, 632,
        "8."
        "7414290750552295546310067304417538089998764617839404299068353704815397343149675509135958228378829386585016"
        "7188491498788205872086312288388767426146999394659547867198614986995481660971205928823308477880542196613894"
        "4275623574987168431568745304364621669241457008033758230714634333799159208383480168990161078479986731377274"
        "5020111854169849030780011055234667752217741062441145534653890585011154245157298808199839856876073524543679"
        "2821070637754721727631828680882026195550243758494821815186708842256768881464944978789741055024675233939100"
        "433403212219702473933537591600476985467616468889370663931655085210348232749311137013137340545654296875e-"
        "251"},
    {0x1.7d709da2908a6p-830, chars_format::scientific, 631,
        "2."
        "0810847152471556254401311232032188728447267117360175717891636755620348167659504840695434647539993442189667"
        "9066888555643495483464096384894027472978012957276210634072464269390297861825532386002160928480072354865994"
        "3879732460682150385691303824800896612452662280810299151162782505065316201313287687887744161894093458421161"
        "0513283413566516116159526022930867617376801255296549189477727203602595481316438645897519886431470703998215"
        "1377960435417890291154205919810773879383879482532629222150323363757619454356194585518671919581410963596163"
        "31249245416003787574812480465286687861085268674943439588960990282995311417835182510316371917724609375e-"
        "250"},
    {0x1.3e0695064ed8cp-829, chars_format::scientific, 629,
        "3."
        "4702108400000347766175063830843523770353778618261381349778046912840338008912123330979886734938140131953647"
        "3650404380879594113908738392579171180233191183812382724432641795305629872774983638622063672350876094571233"
        "6499953240251855646705291887761133361595958660743063765329731272882479029390612416402919177315324330478981"
        "7906314100021310207581009790350421328660994413130289544979421802072005157445008442147491610582962042054585"
        "1320886313933389161115405988770793923103408378052619011716334186056438214857870078005536727201067661995785"
        "790466451286588137374823625348339837864856184966498995800830706937034619841142557561397552490234375e-250"},
    {0x1.5db5937ba8bdap-828, chars_format::scientific, 629,
        "7."
        "6318668361521597024921032941163912195843047360807572633855844063123137453078655746202441700789564711179706"
        "9916923337389527280904671103326648100882322011480055143650535250537017261380037289381165619083602515263170"
        "6262769131163996536699740657297258151427870476072005518538156986453060386081899065708959573969700226946302"
        "9719928757736377066684783971457371284337556021383941621372989509463523373387393627423053871399621032962573"
        "6022033942155448268043514668101801250595923776575465783992676218557609418576221962370419170839207704238194"
        "605439691883635468306303649484833033050509910062272350022606615116416151067824102938175201416015625e-250"},
    {0x1.6ac6715436880p-827, chars_format::scientific, 623,
        "1."
        "5834019337617895673529802567022957766337379198918511085508103045110528907733717602402102884849998115672191"
        "1870061098205010006064994116341947870874025934708681989200668415753105577412001082854515786066821742485680"
        "1456062548357689341619587901384884023764854066935774035847090830187065881058547524256867923951849842211943"
        "2276079112931267920833853415931213541677648134703690053765744168086411452423513659991329474857843477918188"
        "2707143218003668264272483816403234724241995471642051516300929038491267945868500721886688596381791055070199"
        "667412232286926092094960561657785392136164166225682260746854268518291064538061618804931640625e-249"},
    {0x1.3c3b00b563094p-826, chars_format::scientific, 627,
        "2."
        "7604974029531470755379958955203393724195949942057591244473815246912413391595013067101010555177517397100426"
        "9851394280913110142349802027895864686659380331926581354881712999287134480758847780103851594645801982342979"
        "0641807148719767698251796504092725134760739333533889568923210722351490145615126375166980861819231195004556"
        "9505026974147140173697808659679428521673427481132186985576932729538148337201682004999096184931755553173054"
        "1128144851232381321744989354016415799229573544122021935326635841125869650200213049730204055454487099841334"
        "7544193726240738861198240363922061035190857842312351787435187322472529558581300079822540283203125e-249"},
    {0x1.0a0ff03dc7b93p-825, chars_format::scientific, 628,
        "4."
        "6451194553246022272173425910248807842189717398564905420998902159587754760551012912411892518528475138617823"
        "1276077149413751767111950364616545937565579226648034335148841326886078901110074148150025254392503526305529"
        "0370216558105709306255319467921884924334139388491595779690971062717608281675484211415461117818876639956161"
        "9813289346817198949598305014082475316385753923603720505835516199626324546859661234530477365388955308858864"
        "3275088066098893147926453981673835512772595499765753830966771751165528157351625613694857586869049470850208"
        "88284307723768352498369060642533108685449620935516154367726782137282270923606120049953460693359375e-249"},
    {0x1.1c1859cd75eacp-824, chars_format::scientific, 625,
        "9."
        "9199020006964591277293509665148114175738068218299722216171684761860715405043509729734134051835419456145780"
        "4061721782774131614986369921373038006621814451564434018015185478894418237919900549658925539440736238657233"
        "2689373586933180978659721914807011300151418921971642861345180133723088014278380959822191416998871835413481"
        "6229989291886742495498869896064739850070478724667412357597823910441887617574862626088827907557313143938169"
        "7371051031113861825221076651489337708984454153330070788022052771042484812220901567775296839230012789253525"
        "76743515243575159677709123598388542132205569638845363104884267357874705339781939983367919921875e-249"},
    {0x1.6a30b52edc7dap-823, chars_format::scientific, 626,
        "2."
        "5293584256227206734436690448860438863560423322197287673071289227707969220482106883975461366052769605665567"
        "3032934775744927789366034483299943037941202054718946505243272833507365629419200820002804983158179977271757"
        "1671721074991839534481385737708488066272572252571245350667982202726521017811552285767239087036275942444147"
        "3374843557581613823597887118702404883540266812295744444400774717845528291905742135010555522440223183088720"
        "6967806285670112170221507665071279926429611065289317694700042420246011589644121085837055088423442887441142"
        "392232124354630488844367280025213630868625148079983856914954021277708307025022804737091064453125e-248"},
    {0x1.ed57ca0b1796fp-822, chars_format::scientific, 626,
        "6."
        "8905280466167352632776620072267895607425419562720887072786636113143019987094343582792471662292866076472939"
        "7730215669170795196785528888685159578923864553514694529384313751243344600123412643351227172604529578659637"
        "2096141206042297685159845546380806896152212520111951628197619447822423235689063793472058111226067963673455"
        "0174591142037230254783839132641626802370354491366421432128406243347719909512208656554280798669191054910107"
        "9454291551252805162525706181057897779052882188595582910816002410243781113060844501237388400738713446722875"
        "308537861185231999546786141281236847796378186571867436281679797360766315250657498836517333984375e-248"},
    {0x1.64e9ee7dcbf58p-821, chars_format::scientific, 622,
        "9."
        "9700406511611006380450058410122703902067520359419945795899511825630118597958866580756336755422909335129934"
        "7926878163027036020163695376425344287053227483975642933460875671431629596491665913660803544069466490750869"
        "9970961003572985859670160028279294993823700602311639161464638127681204361896145848503624511004696881465583"
        "8036376921871076322233996810721470996621854701276918380162974677430101574359190896715256741796115091909122"
        "0856185361682832504647890500198973106127845308319244621499182967427340316386207631543160167022751161619375"
        "39201346108337384023359802355141440629266624923426713678065169688125024549663066864013671875e-248"},
    {0x1.7342806f62711p-820, chars_format::scientific, 625,
        "2."
        "0741563200652302519678516416917490637319537103668252987275223368145627331969006334067507115020665860903497"
        "3765141461912192994606787899859502313760751816479041023020811816052948008049981562060747467660282220009364"
        "7710183989389227941857128261486792713783713285962553612344064327011914894418682422167270443852098206799122"
        "7847782624679359595950024366056315181802777138084183269364044545618872783135809627169533047399996575516600"
        "9060687380227497970016437257881455779017980410088339024792475991575812183540342607164382360274099587700869"
        "33482837896691685792186827022522786412573603601400469044480079361392199643887579441070556640625e-247"},
    {0x1.a34800bb3cdccp-819, chars_format::scientific, 622,
        "4."
        "6848861238967825523919435523535138669568875591721693952497479446960968892754400320865877857137724925758637"
        "6466312176966101394984044901307208121700242179682309442063485879866325529597911633973911504800785909608004"
        "6421048235855444747600807137572005573286478427366497261165548010683612698376700103460067306048636372592132"
        "4059660642721400203275806867777947123755775768605772981974944361167157944352867406159553540359103081682108"
        "6636053116272544880672224430084688270810005976480858092339374406472583258511653370211245655171535530171348"
        "68475375552171532363258796791949094141543712314728307999356360369347385130822658538818359375e-247"},
    {0x1.5d9ceac385ab3p-818, chars_format::scientific, 623,
        "7."
        "8128790561179689261605470119862193017985069838967025530261087587933055171958709784048417131883969881289232"
        "8797406572135239307512241855106659665785341333808027529891639934853547347164191104084961308532479285784922"
        "4142225226040785724236443793549159284110455362352309285581855331258281918297212200744899407805498796041724"
        "0223606030354633376997447668412408687420142278688803934473416390666672371634334561300974538601862070328598"
        "4804418822456502710865535581459474356864773068661534540543910873665770745502929686614726428960140394322959"
        "359752172388948566070676292817051125806874533856884006144394305692912894301116466522216796875e-247"},
    {0x1.0397aff005f16p-817, chars_format::scientific, 622,
        "1."
        "1602344741507901062609933663400332688034477906059336896625075268185503321277861155577877309099200703570062"
        "8717598155228811133748159351247592155729939171162247951338314835092976771138161453964800725190495041903503"
        "0115998861373685927735467998774993942859232888651217060603538892135095615587837214035061210211423585850725"
        "4986658169040416093975183029957643060233052384979024889678988680203420436124343358353115842501466575805640"
        "3520972892965604183687346789132289312009394370877881599615814659100474082740931232740166655750873897827114"
        "15272427588336281066986388648508170505840000460355369849008155824776622466742992401123046875e-246"},
    {0x1.260e422cd6d4ap-816, chars_format::scientific, 621,
        "2."
        "6285314099653654176280875743233612539556461168217321507191666512583849543277500473619693088454262930856098"
        "0983039488026043122846937971785423871648148955714263876626708355772491994903748165606956838961840921237500"
        "7093350457729581755520989176424652492855243872462258991029991096716016371967122853936092377692113114869321"
        "6974910909635803632416076140521430405408494331098431557109315555609723028171644630679617395772994661804039"
        "5898962237787927702930458496474668440982602127355647894730320066735255098153627327592205560893738901018096"
        "0507882534877738471905760480320075691097888868409150620042424861821928061544895172119140625e-246"},
    {0x1.95518b86155dap-815, chars_format::scientific, 620,
        "7."
        "2461952671145799308682942273613242790942104994852816207973587954637784400200604552323859641436019959259805"
        "5416275243813683243530881530312826717587000377649636921271072048731825212743492857367125402295389748557776"
        "9009988607499516894855419967617891078215141053644838762332408552091459298218235738836401360617336568712397"
        "2838007379314935535311449332150300365272142072421910507865927246673247351952415023600273667576940226363301"
        "6530964920377056989684886628111989097851316155861987869187828267689030429662476215473756935600868637399013"
        "945524368611538824872280748159378906498225093109517847000944357205298729240894317626953125e-246"},
    {0x1.a74e934210e34p-814, chars_format::scientific, 619,
        "1."
        "5135575793727129243415548881706639972764602138477489832613301661125525653261291190457252646003879661546406"
        "4557235535184255428202266594734780713103215069500727504595579802054769661280199593841908822623154438852886"
        "5167219048211633614353037959605771745618174998999740314969772733593311483252794879934591349391924024139119"
        "6084831250696806847449720365426721059694382001837632545128601846310630150492094628787281763376199207812883"
        "0310281174844229789408905630908727536976405794432973052507474674698762818002597976646771449616515170649132"
        "35704712171841032071854384668013379767883698598547603797470628705923445522785186767578125e-245"},
    {0x1.33f5e315efac6p-813, chars_format::scientific, 619,
        "2."
        "2022598987138437754955088140950822414079425891031517825754706103180380894029334891007977048969785793187456"
        "3628273401003849229027947643460709548320874194553229940197985486063866961467079881830131956202351541355456"
        "7537809101283096834013388339700196877232995665517358526772416380714017470163654641203667347296739134840984"
        "5462268627991297391371820917998165639554697550184147146843309056835791578191595920503487299426257807906684"
        "5040859907941076591375398817610400020832219000691738654346851177693702055925078500930211965695729283618046"
        "81928981765720671382877489626197246411346537353463659325569778957287780940532684326171875e-245"},
    {0x1.218a6c088e0b7p-812, chars_format::scientific, 619,
        "4."
        "1410759136055035697554355612523273349805779575443516024484433325588504826173501106274906121179378322764594"
        "2484379691318093841368847098623863226362751057949455437358357281291709007819852095728818477728142143877797"
        "0618618828499284120946242604063906544270123754851472649535798272106982211037305830443951538621938405272895"
        "4163702265368813309267001173474115003096471620752013064126070402182426851829272536682605271459261120871427"
        "3261395627080752743556294388041183383938489151395241871318175793857142069803602514255759195099358106829389"
        "25941403961228692586646991088112498341686942122073789018799061523168347775936126708984375e-245"},
    {0x1.666ace219c563p-811, chars_format::scientific, 619,
        "1."
        "0252325908734784187898407846312169662933964451617206135619057870361506177183633250060030678288380992953815"
        "3910350720774420252564370061152467229984493300103561343350506499789324794467185732493962094862799214271322"
        "0434893279799034506854982649170149103444477505174541550420185719057992592872659016813377466213470076718167"
        "1587928184828928855320129149015094685111159435268814365435146233180280512075699541026462959427795332349621"
        "6849064667560874431015731716350235234093796641399858007197207265469483871962411812276890490973250357109437"
        "40918313124555298228499379304666253435895481214111535361865890081389807164669036865234375e-244"},
    {0x1.66ca7625d6faap-810, chars_format::scientific, 617,
        "2."
        "0526028348315092269326491491416671614717274844171552199771340287149629751710490353817825471600522327742276"
        "9848566747186724592570603262783159622679618375839605019976045985194702598494093298790453729629386984648069"
        "0036876519192087476613750641520994696959915507812672382558594635321159278065876914295340826056875441592600"
        "1413614588937378827408562300025096391492039454051283528928602590153392153556731943973383727082855350556933"
        "8189950869666550111368368477078616821706475136695480270170795820169174490625031489877623760618366454582967"
        "116336156971442918961856394686992446379464696305794380037923474446870386600494384765625e-244"},
    {0x1.56e3bc6c4d17bp-809, chars_format::scientific, 617,
        "3."
        "9232668413253934109576315523375410824827635006014532478566376795435761660713281112033855290558209088544095"
        "5118644308491937391706798210947879783273508829940864077425555029743665433796448026542881792523707845529392"
        "8888040646795226366213825411580640005811347292313508735062094848631128449978823754429190527768902694777788"
        "4900217247311196596714046442296568356579966479778682707394799024085491910187918573868394308146580143541149"
        "0916677352788480766516306849228406228050468116273820675030593448761271107798128039605500438662893943456546"
        "783890712558413724203498532897484191055958980230700117175501873134635388851165771484375e-244"},
    {0x1.4b39b2c87742ep-808, chars_format::scientific, 615,
        "7."
        "5796150735595968518238983107483839070003142955986974311581916680225791453486833700764162887478630207856704"
        "7822941859480260584365963321876199100372555439312474681875955134391985832190379567800238426220267234842361"
        "1239623046545996988440924432526210697817982616974975257322206843303081668533190742330428145605682185623573"
        "2670262122379369805524587294726325653350409831517894348004467928232650745530506560430564162969593601708820"
        "4593973141345297028237304870101790866929027772577561222369175133237449464221430999208311216033139713942561"
        "7718942914363891383632845680383464106053752022684744105163190397433936595916748046875e-244"},
    {0x1.be40d1e238ed5p-807, chars_format::scientific, 616,
        "2."
        "0423721499211961109568525534671443647740451225589577776776615350824924185902447511045534069936905640957606"
        "5372006706682415988169410761618104420823540344653655850495453161898116740909085283322163797816690426713928"
        "0588386591469775611793558909607779568837686913517898927696512373572016048102090271465196837631021566949809"
        "3458778713417135141374746058126296881347472422680267110011339066236275056110971927834750821976896185521894"
        "2603002734635679430244400522090001984828634799129531569049286075717103643972525011916090411511711638026757"
        "89249238420106837535506252866076169083468642463652376051186365657486021518707275390625e-243"},
    {0x1.40ae59ac6132dp-806, chars_format::scientific, 615,
        "2."
        "9353293314833333854985102733201521796250036157410578174458181974941681427901748305530776598182206753889861"
        "8636371016267800470669357640180721556010164004214645520298136353408719208286540502372077707795876864389123"
        "4530987039470184872750427478883560918646684350505130722837863014999727875555215685304086401604276801173120"
        "3139790194066844214273369426057653128075479513670720217838142259228046519573053627935149750677307039941356"
        "4828147132972855997122201965456703954022412625507350561624510655574143234052851884708200203074614546619619"
        "9361830208532545550931607060890187286750154134484791512704759952612221240997314453125e-243"},
    {0x1.5c161d88eecbcp-805, chars_format::scientific, 612,
        "6."
        "3723638585700451642795559570510679148094993613910324952290173092838588831267228266631303318254630028045739"
        "0407187178061510576300035754372233822499222282961203456720941314976636497138825053868512001918319562376117"
        "8503122166819829425566310708112327632839687765866542175513644077648632060395171310907363823836647106858223"
        "2777412680176689313447386866112250866307040221174507703114483598510540103447645068390784004440801839078883"
        "7194778885429238978252063987403236158204856335435926863891604588752783057832428086623507826775024249195807"
        "3955716265349471157901811121367537037413035505561964555454323999583721160888671875e-243"},
    {0x1.ae3b20e6233fcp-804, chars_format::scientific, 612,
        "1."
        "5752344142353219450694189702451991296910433408430789019004125131863629296511431154230659503890717620031590"
        "1038316721233788818826571623317203349289987417121376686501945841032567911901250552698960793265396245960534"
        "7373167055651820451912046546618888153412645242490087251350087576649187699383010638982269418082540884562832"
        "7750244082466163980074438483304220415007922943039390750698179386470176966033711270276708288351928574480634"
        "6620427578497508169144643312340209721649688496292864219377630628268116030388752066570843025641533813750666"
        "1505153630440989474460324611066529306552773392890998138682334683835506439208984375e-242"},
    {0x1.c895736ef62c5p-803, chars_format::scientific, 613,
        "3."
        "3434436478293493280593571271178008379632079500385975548283939163497852214879044844517670759497091492926604"
        "6301395881911376324184025424812370739165394698174516004668202850196235934904450092005834916657352885854495"
        "6797122849756889458856656030089637540017312018075458430375030356712402369619517176293964796597028107692733"
        "6877655770322576324057362054878847600831468525556287002358878533444200008041718236056969477827934772656677"
        "9815145097506338920779765572188303868670858298304546602128519970722727663497018972024558384033232006396023"
        "88217361333368030658835443253281029721128182752298840796356671489775180816650390625e-242"},
    {0x1.630761913b642p-802, chars_format::scientific, 611,
        "5."
        "1995664937001350863664258209506916125612045887421035495539968219921552001490404512666597057126511434752881"
        "3007435581863058379511824026420279450528771594711743194984119825629737962368975331651816862223263764907329"
        "8959845059152436168274836787886410245541432791484117122823236508634176085889592513409849869200565154766887"
        "2239050279254533707915364965481634484943025853564537256019007487191319787066437301873020171361092201939838"
        "6184775914931861779759491034394263205676462386582564671334894431929147821752438599108003402914657920461899"
        "226466173041809225803734159361765368727488489941634952629101462662220001220703125e-242"},
    {0x1.8907b557208b7p-801, chars_format::scientific, 612,
        "1."
        "1512226658355749483847981607903749186968456271470668422905514968048682862550587964588422845161815767196734"
        "7161381736286682330197784945747956438186532961339942750020185568887387914264273351910759945563214255066684"
        "6367743093899226009412278214746750427881209859743419090772304032977787125925338802665415242857226084498164"
        "3083102151843503613040369064236192185129466999497241256541067862601025573632294816706426141506628320469477"
        "4696736056927673474964247532394453617303703702170832899939996119301381165251917266354496116545457774453945"
        "0895523040343609292008370421060948365454650044181761359141091816127300262451171875e-241"},
    {0x1.0954ea214daecp-800, chars_format::scientific, 609,
        "1."
        "5543636774561636974984361218111011815787496115988125251761512745799203239114570231530311587628929592941376"
        "2585042010727044016847870464502675936376968118423019078639597656703801878013483722710291570262191347684833"
        "6805205669043926853377700998806089359780103711297258044030751523125011328665317845898485403235762350467927"
        "6134156787944549174068596540770894898876924542106646637655671038405664723034557454476207446791320248290714"
        "5008167400683897298836718888410810473704984083888533798729692197933748270991636472806299358418250481774109"
        "4771758489864324415337151128538238880998079149975410473416559398174285888671875e-241"},
    {0x1.5c2fe731927e6p-799, chars_format::scientific, 609,
        "4."
        "0794930994574949442525316075493436362455473092684438997934986135437654466941332739768956377877473397607134"
        "4064958156084532579410087539106327345372818664352247197277361471370030117784789618983207924927651450687711"
        "4770356574608290123358451973486669321692492332398543131893173963499548478234080992976620729264092514266793"
        "8419538195787260791452711556640767302269532128743048602157910479633566088244594787936712119482747027241365"
        "5907401119681985982507921557024707142597573048794208218331141095078100425607731851283402621691247039292834"
        "2115674805610333210644028408620173696379207495255059257033281028270721435546875e-241"},
    {0x1.6ae6c51c6cf43p-798, chars_format::scientific, 609,
        "8."
        "5037834545028439726511173970387065376495451801221358745541466022111055279447814368476465692501533897808052"
        "8414620606538201959175171073351443366751678402386951129508572093685812674971226575682201470239574972506910"
        "9128943544677360375146178941605556087049517009816921069940296076289616976017445345589202204019215772204351"
        "6311008757552625899436454298892097346319367204313955610412435512953237673867098391988751837296926369447076"
        "5727893031773910333948712489912482607284107894642961799688586136148985510389912656105970673902638925743472"
        "9720838400566841392990613565908529915098046370047768505173735320568084716796875e-241"},
    {0x1.ac4e86c315850p-797, chars_format::scientific, 605,
        "2."
        "0072820595479573216169126231394408838551922619989874786871658199647732697034762028792666015861804714982292"
        "2191591154955291378005015587839555531480612063235835347012810772327501856166588209464579572448604508899906"
        "1772187223684855162442424175711463772705279180982126416318031074372302865560128825632323317889694497843360"
        "7754085808572590924978633945247230403112787302032626015620605415136044530348825415809501368263327044824152"
        "4145945455699623696095441521069129226509344118102237809251029986795488661778437540002054621660753197441908"
        "343343400344601261991557764803617049109707437537508667446672916412353515625e-240"},
    {0x1.794bdcb1e5858p-796, chars_format::scientific, 605,
        "3."
        "5364382089011979980897109687165254886696841520981254446556125956556978294321082019870841710940758511838532"
        "4894179439057364357461159517137903474744654629717453375448208774398730333711862007633962738258032417741380"
        "0685321115393078264140362224325824070666437344191369939443217492221993668605716208990694526263949725175127"
        "2531533913011070118815751448623244063021481460622877756524201582813510487724558551743402584791531847833324"
        "3947677512125596726121471095288063842196951847839048568745797565605397830354659437463682786127174530399653"
        "052185980142212749148863110471344671503768353204577579163014888763427734375e-240"},
    {0x1.d14f7ef9a1bacp-795, chars_format::scientific, 605,
        "8."
        "7228090145957935347248318547742302587087102313285501442514035526226306674555848729098848343284853736028606"
        "4873831254928609967322217177874171796955578934465313147402878865039420827565176878567927435477084189200595"
        "7806847646599109442906678146695129581406643504246823239271381485582046753531471862258384352222573375498842"
        "6169068002044002105223868118456214469943463514242867324395558742911540780602189115030142752959592996857877"
        "2273040528807362627380272902106605717316557112560491693041298619232077978968586186803325882819783307168556"
        "881297598817001041704706994464233425767840657272245152853429317474365234375e-240"},
    {0x1.6eb9675837dcfp-794, chars_format::scientific, 607,
        "1."
        "3749379101340066083857337348176012879302998942040643891959413447462809923213710792385920913367060586620860"
        "5258647049621760492047179451844836572119347356991890024090747092362463756927276284737937087463531842640685"
        "8110822716901060321069319180330630095350071198454014017603381215347279543191075769849271941472232894509230"
        "4179731068530834521111061163476202640787726787899152301887532484498175670012280605395371745814997035811104"
        "7972034718728424120220308910285188823533296077514778262102253723563125528563041143324629454753231680542831"
        "91572629933059608724961728922265061757224113847541957511566579341888427734375e-239"},
    {0x1.96e8a42e0e289p-793, chars_format::scientific, 606,
        "3."
        "0511988184972799383071211924634487175460180935326054116102185981586408321039421266980709352417518315887404"
        "5050170880613243376562389933452426086185695180699312804245142060569472810956533457237033496816457196253387"
        "8125149465944408270649637103835598442140509946028942888834087818054913127959283097911123015576692191085606"
        "8568283496852317230749669582281777159547977023790389787193331339347536950378181463434129630396971207994134"
        "9950377993759212633121226292844763708145719324648259205908825462198868419797842376770017948515553052857064"
        "7693354807915784314898721093603267857929939310679401387460529804229736328125e-239"},
    {0x1.9df5b8438b263p-792, chars_format::scientific, 605,
        "6."
        "2081425746751335610146680295435101859461655681989036586327775217238749061303501735332371382900280575515719"
        "4020730148118435599036452088715313932099113134973129083783128920389682715075150575144731203122222001783294"
        "9424406905553795591369611573268431281518228057618249401975945890243492974663368994552896023782381782553916"
        "5337044719128567721394744671262149404471486748537392698331767276580429963086090235313827296241311355503851"
        "7755830887058852014800933522702452536975068231984788501210512796491195164930952739801311157528383120640408"
        "842401705946246458190149534645571431645816318223296548239886760711669921875e-239"},
    {0x1.fb32cf0b36aecp-791, chars_format::scientific, 603,
        "1."
        "5212878641555802724950846086516145032300326998691190900292301735619031405755263380867819445511072562572943"
        "3287593703388535027004430201878462180974444880722937680016604317123047097924707771861156618306166328988807"
        "4173424610772542026483506595446813945016920935740824692420808377728446284988055043397756717427418778466960"
        "4764984416510689582171300446811130954623811981865739826589607924848307316279607843133793365371483255657291"
        "0067339723232808270374427845927610682612753312034224066285259685752517765740312550171970032472135036986863"
        "8181213742553728087480359007130879811509061028118594549596309661865234375e-238"},
    {0x1.a45aba26ad06dp-790, chars_format::scientific, 604,
        "2."
        "5216166351846410904598804126503919975960206341421556680673122139430839618893068778953528650714452899719345"
        "5246108125158739482741680475817985898310280861272177832678069868601568095686217379876046803162010708112630"
        "8023604716065459630277834590133356599359591175082540998292572569927744367695512232618054512372669109059329"
        "2278734289697568086682228820112428175532506340283777063322011931055911875751981872871842214504360402471002"
        "8669711497076549528902364758613574081434795344422816278952670020566267027219316225416939365006958713799490"
        "66388752655501946377532357382246670784997633063539979048073291778564453125e-238"},
    {0x1.76eeea7b33d9bp-789, chars_format::scientific, 603,
        "4."
        "4982897883519312349700257852074285242839338405891623616075244867023942468017792455826328206218393099579788"
        "8538183326678388281543698838695901138016399892101462657564145324397174804795442702076264717572685786596699"
        "8309206594117460390492150507731013549139591322588458630372846181251298644962778269180438519777882585752366"
        "2061647833682308513660258531274218090943034841110993020477090849934919002278855577982822728887910520508057"
        "1309121300301230873906142310636922125841785801395507975381319776355298465790722044417775302439469856484395"
        "2193959423860928797599218080852621903797938784919097088277339935302734375e-238"},
    {0x1.2f72b0932e6c0p-788, chars_format::scientific, 596,
        "7."
        "2812801441645303966418732522860605234446781581701162951874702445421625014697873257721100247133280933337547"
        "4632822147569730372734556192651075193509364068638545045433634662479604972014032304625118712264784753862330"
        "4240701146998515213155895112699926325225487803168318982122886793550787654412114711135260065548158754163814"
        "6267792175300075972880320531815842324890334392814926595009128071211433776121950591682377947812052908478752"
        "3782045399878957499545795346063587985477731111479849521556134883351589450597232837336115964779975403775359"
        "793941134875836977710206014691163289853648166172206401824951171875e-238"},
    {0x1.a51a411cbcd83p-787, chars_format::scientific, 602,
        "2."
        "0208837171448895837318180903259214725922207568227959012108677599688049530743023941864936723736235817948008"
        "2611403427798946547661988139742169620596220391493753722071403821592772010242534186589497286966518076494362"
        "0678420736321907710661911556894381850108346506265630319767913919399030191431965110937831030511219504532874"
        "0586466146512917773158338656319118663906595686588537648936843031647093427657363683641219540298646042122056"
        "8317426577038520940327301670924988866127770057169548924829741512502567293851452818399420681877823748179849"
        "398737440333262050279769937353134545698907231781049631536006927490234375e-237"},
    {0x1.b808810bff5aep-786, chars_format::scientific, 600,
        "4."
        "2234650668214423350279081718143018052918828845233278512008791451987305685594591145976330970127359480860248"
        "8548917264315584433512455554684826100034965613524346519252961698792900476189960718557697298950778181410013"
        "9640228026095584871810289683508239794468996786987719366315242777184998255799306920272281717213927883238578"
        "8203065386664239152516789871769170789609239941892434305575451880664013613320226313501911783489649376683084"
        "8714814724615946149072474408582468575754684669730712413191753420272477919667200484972631788609536129952239"
        "2188637733793856554789030127543270065615388375590555369853973388671875e-237"},
    {0x1.a522225f95f46p-785, chars_format::scientific, 599,
        "8."
        "0841257435956645678547405463747941035254532491290665291476902755342035620999121915876359426286744536442548"
        "8791455796027552732952087071822418098846022103639505489312321900912629868532623475135095009363265921031875"
        "1871079021611411332741033775270408893701977185246154640873852536013091269615317189935301688316595497628363"
        "2052474049117604877290387290489379052271964810487511690636116959829601543260594988729338797802211604439634"
        "9881544511737095144068929116901090243016127270909040329117435763031291331734916897008832721886597106496144"
        "499841505379496532267678712661840290110148998792283236980438232421875e-237"},
    {0x1.b3dbd2256d4fap-784, chars_format::scientific, 599,
        "1."
        "6733590187416606942028788295822734147043087946233607968651016945006043063743409956982922605165150262493695"
        "2359551337435141043924366256262954714703084104196403532472922571050719624290744697858239688419404203520754"
        "7557916850717553492842057781744688693737608928952458431646709318550288396484391157776279484004370212297762"
        "2085741279270737213198962173572325958013463853117760877665013868039714619089151048393695975458000098063344"
        "6858750098421368476749851793586866701372231665192694279106769119933450898417201549643514656077765935283060"
        "136103656512062492185832101622422474207496634335257112979888916015625e-236"},
    {0x1.6578a562dfd81p-783, chars_format::scientific, 599,
        "2."
        "7448244739455369599852949492552923507948333818208197008468158129083810159695483256360269175415015466412031"
        "4225695400387005807802038517353586335988207343902959393348397621769684884913575361723052144412545323525101"
        "2843207362623477900893247213636680781392280455803632115282785593332780520340251878255628655632838690511799"
        "8586350085644107340826449520555370615285390114023939058381308345313892978294651712108011038387663767010617"
        "3438419253507596733224476414075014265345891995296496120856593048414341827141680276415523884377632032961134"
        "065066676791255166649173319499965817414022239972837269306182861328125e-236"},
    {0x1.c375b704d8354p-782, chars_format::scientific, 596,
        "6."
        "9330212812845955601973051705409859820189947914406991516234621867700438780635584678642245240229377264515669"
        "7338726349371873983367424350097381613788724747210201244748437625890393184241908098354893458187915104119341"
        "7684465460693231943222252870968475205589194276287015578056177004092191366508966567650334814489885848490942"
        "6122870870673228226689067501074893767746717599791972139895758896137999486120056433350900790851566486391753"
        "4010543666617786469916707237836024118874742072934775462928779342329475149180326686989774048800335725396492"
        "694612182396772755548224227706288758099617552943527698516845703125e-236"},
    {0x1.41ed65ec296ccp-781, chars_format::scientific, 595,
        "9."
        "8876088484049352922774021202980270628015087562012427292778038682091273168220811432033616289760109002310402"
        "3704996008069111083741196140661388861826358577996302406407082910484532702903501127304650131518239172470834"
        "2834373731353510858807009428849017497972201623850366494027130268394546556252337263922088889702844419759589"
        "9063387263573871573732612758260782869758009494263629328008981472261588690396371322017572369585846209902633"
        "9510542868187895386861625212297072254733429651534552220213138019454443987615077904499633483996281342741497"
        "11127064592991748928608140845053497969274758361279964447021484375e-236"},
    {0x1.2750c8cb09651p-780, chars_format::scientific, 597,
        "1."
        "8140520866375597592817140173198328456153471086515443891947301419067427016349814663252643281827753782214000"
        "4306072580093724492340899978941054679924199470836173279701306416204849855804566293231708048363754246665689"
        "7132773851376950137481730406496137930367940298307822959184929691157149248171962689707484240913709878645248"
        "7651516170928175691609460578402568818237797997967259089571151773860066324450511535569895183000043741984628"
        "5606114661392523948868455531855100625018508153569679961738521387114799227459274565213553967286187012847908"
        "5175141572936063038323285280528640583952437737025320529937744140625e-235"},
    {0x1.19ea333f13ef5p-779, chars_format::scientific, 596,
        "3."
        "4634694166405885699722665996156819190835305157939379082230431113198584814406142159489506709243038109913804"
        "8087091839156277339696816832118015570005868291208987392092241756886550999683176589757786184600708233295992"
        "9104748617248162737955257920342448513168770535182891455893675197708497078872366516469116334460618374815662"
        "6215995971472457141964876831499902261701806293373256835816802621390185355511566406092215783275965392566585"
        "8442737716827116543576353841785651389340117531460235593391101203276419598915973745824201798081334576050870"
        "430956021545159155021671205931799164545736857689917087554931640625e-235"},
    {0x1.a38c43ff3364dp-778, chars_format::scientific, 596,
        "1."
        "0308725436052673004078265535849362842941462603767068009055817328335165518994401933172454910493217867696432"
        "1845962716686314874470651933591385894469274918631064185075059486235684207315610254821040680581793107781394"
        "6746960625748974345607263573914820643627389442572446655908256314652737333336207566756390293322256348701247"
        "9314565117858212385111597451728156265292208695902500402336262572667655661806388175890193990786445710715532"
        "6444270656212874978801400697046881563390089872226946501545033080160837709416037693167240629952771552441667"
        "361465182176428352680002016594773550650643301196396350860595703125e-234"},
    {0x1.0b0ad1b956d83p-777, chars_format::scientific, 595,
        "1."
        "3123008280909585060094739769474378460538866107048392129824696126606516279205972547670492262550710764284363"
        "3234354641682526072825042161215500583864172196389183875957416010067398215922042534330073715044124724096640"
        "6740630337183260137195168587876580824443134710976924007017901504245366920570333649552524608892742277095894"
        "2579696379671576766979558709660405125643620837514272390698664170189566381311138897213106203693198480966230"
        "9746683046481084817065834830049684480464548077598539532315246634601937680515282851307846303670734268112421"
        "64361861337955626193876000618043775602927780710160732269287109375e-234"},
    {0x1.8a159b1e99b88p-776, chars_format::scientific, 591,
        "3."
        "8732242378153897318097485186350960300031186584656562863006373476206011523682262557811183503862971612833114"
        "6916417461255020728803411155740943257717511092693240971786080135296087495134091242375838374168505261130380"
        "0492598166723089782339674226277801628972688152897218578189493489170331295747560535252056117984854618682523"
        "9305131571924373146542287418567990354344016310437205184558983660529561615320898762527140916102609030211008"
        "2103832765594531080012430285923201547172290131441715644938740240491425394877727279661634375115396176587234"
        "0989930831780784230462810757700253816437907516956329345703125e-234"},
    {0x1.d415deff614c1p-775, chars_format::scientific, 593,
        "9."
        "2010739647813000085411005568727105998799066899037448965302675135776884816654819628173659937259171048554565"
        "9299792147126593896231306003331909077948383910755151878314000991105111186376426687047583016174605352766814"
        "8534331818246298245816068105997048536931836094343752160045427531551482079866068037732986220746545492963890"
        "1238271162895703777874458709089484490860087292013612010824285906041126662575922290223290517197672726442811"
        "0290759243860558664957215585129480394134876729038989456780357462903511930632723604504410411901707601194771"
        "524410246628913870770190286396683632119675166904926300048828125e-234"},
    {0x1.310bd967f9a00p-774, chars_format::scientific, 584,
        "1."
        "1992483584063613937396382002898619029819538686188191051376468587418398044923819788257981810312450970237429"
        "3152236901426529753933885926217522939375787436168025095420854421089105328643012783084193445775178532627019"
        "3002021288587642607408488965662669916337673223002264510994634236841840933737724623832016553236992028678401"
        "5079222380268705401143575325058869567756026714067386945351235295748404808174268116051793510048341986101843"
        "5189240188373810482122213082644041469933620211270257379648322982766563842384538563467443736569589192277871"
        "478824920734897185869982649819576181471347808837890625e-233"},
    {0x1.2a478a0b632c4p-773, chars_format::scientific, 590,
        "2."
        "3452909097606002102998388857387398320146582515932569159622941748507502071602816219003857791914292766210287"
        "1282920701702839101779318975472524788417303881315933266593759151136812057701602281728908118286422653068981"
        "2976721417530770069277611318604358776733743161458118453496278452601803441503553632201747451899227732879279"
        "3939383070761065446832297352683219271773789038387084150729566669981216349132935276369359294821930391936873"
        "0207897372104156558695370518639326240457297236641350456607151007096954463810541500796919853141331376838730"
        "027058339967416700395930195810478835483081638813018798828125e-233"},
    {0x1.a10d1c936f397p-772, chars_format::scientific, 591,
        "6."
        "5583225953784304043954834614176088194295405940341601198073153875988601237261704379055993336597678819170772"
        "5308732928182976190209935831121926799822295206356039751458151538698202210999800319499370069053119068921318"
        "6495513705997548419470722568105046316621424908719955943222521965922140810646651477916277542996197210024407"
        "8354448201804009172919086425145196331932267229375638726444077959998629259488107236621956571918999810323974"
        "8735717531246698300106404621320272068687120569178549223991517121489275313276613889947072468874020996202783"
        "3578890959869765026578336541973612838773988187313079833984375e-233"},
    {0x1.4135d56a1a3e2p-771, chars_format::scientific, 590,
        "1."
        "0102359616097600006944043696266304310402566123880381330525868678360586417700284313711997697393207834996490"
        "6412477557422038262981083901801238882772015066331526420346388047508965204935499624567755681398845856171526"
        "2242364880332481311367223365533330138935433511898794179657484124403659524277293102547115573188942514605904"
        "1262737288899085376795178896977519105000739053421097877918031437721663292284423338700565418149569030815098"
        "1976897643794990537239534181469858547742793045584048036497046009670011336379378447273760163550393934817516"
        "023051483276085451591674857496627737418748438358306884765625e-232"},
    {0x1.9ceaa4e0f9a65p-770, chars_format::scientific, 590,
        "2."
        "5973213970621353044824545188200592183419042385639727292053562666249675544942691912517025505947140109121201"
        "8691791676589598304859963199178052096220362044453690802401185643378067015831822620192178219791939757230914"
        "9709039667116952289847151837424216761341021681339723578337857881286638542378091891939886703814853841423404"
        "3498297625474216866415185214871267451369155514201746224365590408487372081525980706478638859040170095365664"
        "0645570094281836888650858982474863060907436892730671482497330980571409299449161530863472389822545360807847"
        "278223954502168854992227853273334403638727962970733642578125e-232"},
    {0x1.89f20e3a83371p-769, chars_format::scientific, 589,
        "4."
        "9559800065235153489796410194161390966488355617585666542707339136900558711218785557363856112303748107913099"
        "8680237278243350843537532200899336534061998689022480144868594550956871874227163881895319963658374522051904"
        "6712966152320510867618543585720024531194940872820672919233356870518352801434898546241842045716492357747647"
        "7957958540068442712132045749702481116171119884122838963976902383703248102452023124430340570652009799204816"
        "5249261523263392714849956402443956398232588164511714409814006544850650200925905726503033287699786574183111"
        "98129755525915792098434753398805696633644402027130126953125e-232"},
    {0x1.bee6d84bb634dp-768, chars_format::scientific, 589,
        "1."
        "1244377262803143878068016423688012596039718894748761522693123703181634130104650640135262083103846749672518"
        "8012492495381704764285966084753488065021470092208542183182084032595971810165044465057115424454465191892043"
        "3359242751160280842713632780774054505432019612624878172464734301273167678163431120242405621415824776126460"
        "8947838926595118197402289470545118797483097395936263215464251151336740856339180880724959346882809972866164"
        "2692633775304002961981768923100643096019801742272879022489813178847770417859840592829885544529002381973852"
        "04296812693280688440211623202458213199861347675323486328125e-231"},
    {0x1.deb403c7e96ebp-767, chars_format::scientific, 588,
        "2."
        "4089050126555282541403121147937146640322688813110950873494165256577427141764900209847715481143046869400508"
        "7142706729187182868489888726631219010556346470377235782761231255161283491871481571830171798317313191456617"
        "4309783228992987395309874214938085167780197703713450058388341555810443906059468275497970709180486706718587"
        "1313640308216356155999604435917605136780020449205792873192769293405985822537229012759146679613240165097560"
        "5210869334907295625604149011565843196894122999061870059481852780220056624802519719890268394327365072648952"
        "0827818495221097315484026779586201882921159267425537109375e-231"},
    {0x1.3d89cf65433a8p-766, chars_format::scientific, 584,
        "3."
        "1957993198054625725213645741173162786935684857677527438090979500370647810397958920480824463940923329563437"
        "3636851774003368423771672117121283918964674083790880004924598131903193790947820607391613617716363350605791"
        "5622232960627326392860115950940947029579098561357097854414116991950975007688070342833923998116760516870121"
        "5749176970374592880103567554395837929673462006697904438147786695003031463211995666528121763991142543575975"
        "5899718471093397427400766264709037449493655219279456023568676329258618536362702872759367963005063148812537"
        "726423102708329937460263181492337025701999664306640625e-231"},
    {0x1.3cfba273e39aap-765, chars_format::scientific, 585,
        "6."
        "3804197587403760326652898054200801828323214780442215032022007620478359597818401693284013081678136665027405"
        "6490197573287853590724100179977990824731156430940900293657954999782897120810644701128329076885474982261315"
        "2004534567980240484852566346849092151908799371287257255382445454735215000987503928361640304537884889342864"
        "3145781279385770628277566694325711581556041680649755580831709124446178875091795627785989583994623827758905"
        "8753937000671860615795959039778377116606289273494321908010815730672333507357816874258583488584279492533715"
        "5136765021905438655114295443127048201858997344970703125e-231"},
    {0x1.8fd3a095fbb3bp-764, chars_format::scientific, 586,
        "1."
        "6095894110621704153832201294055971532390391615911012418102173691565843809408450333609669585716893417322632"
        "1447397301047417148502624258582835574723816240415594393369665164751768647196218708742592134423663760259422"
        "5725582449224662605981402620585333275787021731573507809506478128418455212296523148679126266426699652401165"
        "5347686788983136076956554273893939557385379020373453645222044106667326598338033048058315587381156417693815"
        "9689442060769621685872330312916464823415664426762643483429352265211453025979662093409239736334483968002895"
        "34637228014489311600510035304978373460471630096435546875e-230"},
    {0x1.f4db39b3ecc94p-763, chars_format::scientific, 583,
        "4."
        "0326128219471308776340774632801968730422798127085717909547582642722780609987155279615390281066933947805844"
        "2834132325348297619070203917114895484113342497422436622422171014950377706618395303383927177010501146744877"
        "5538953564225445443359521685452770061497047825649312653532071752631734104992995726313037715144741959667621"
        "3378577557632829154543778635778400664844147650126586480978710722699215601770032193691389861493527186292410"
        "0599178352375439954606326097129388309765290899844628674147158970800023347955167381151032697590479982052777"
        "90672589771116263168693194529623724520206451416015625e-230"},
    {0x1.77036a5ea0238p-762, chars_format::scientific, 581,
        "6."
        "0387918131443855293985504488455915724451292685267014767829849073500412060744954585531063673030529339395152"
        "3888733562888957496230925242955930292779412423416985599139667873737076545274846108104562187768695151949854"
        "5128012141933364974487522376491162699773763210995107076549084989195346688616058796160233927611226734207770"
        "1687069702978155674956635793332657387620943979787993513510686776554055594710429194494938662706250339068265"
        "9995039549772250462149515137830868639868155808286646814645933763259664624485459438133730144593675207962419"
        "919759523671831669133780451375059783458709716796875e-230"},
    {0x1.16a7ee18d63d3p-761, chars_format::scientific, 583,
        "8."
        "9743230112456742542899279796268272934437787928293448086298107077647616276508988954791659580428804464479810"
        "3641898249421376652724137290600459136448447242365922273624432734917290803189814744215370570273183759401554"
        "4794593860976939114279110402292024483236793330618757059821482848520627476373652688290899567926159549042944"
        "6328543904775889245889306222564992234900589838102861964399884580694207148624055586974244583117165245055477"
        "2427198667133558451445735864240418102343992211275762410613327206706574095487836196314795231910512044608674"
        "78785766697922665624531646244577132165431976318359375e-230"},
    {0x1.23d8446ff655fp-760, chars_format::scientific, 583,
        "1."
        "8798157375327937836177365552311551722298566992689137495408401180064460810275669557368262486050476535706822"
        "2914315437284620215942901943604543564464950435141155358461881045086110693670535222743758425687312773016464"
        "8403232716340427184106949371967480783761089412133835752241924595873877701261614154333943909110324386106585"
        "7106392044433133552798988180692705602297018211749323498943970494194463977408110252138958916967143497719195"
        "2134646702290784545105260132872002148565751843028231690655926702860817601062025257596703145147603743783651"
        "26359435670864994616380272418609820306301116943359375e-229"},
    {0x1.d9ab918404aeap-759, chars_format::scientific, 581,
        "6."
        "1019603119906394823703359893419041043488928668777127321609779602295957755846206771587439667498191607870127"
        "3188407787323422531248450139973168123277344462820437889744367034040516526005744130783797920887934326880891"
        "0151822705828875469292565269036546147893915456863015857572909063802064779293512026308928862177518529874001"
        "7449142693550088732619227748522352368557175278481264314118546468989352818488963814913806525070024091423038"
        "4912650786353791658298950508324864755779932694843174445480821573854098041924252035624281216732196095488604"
        "104431604353842022447906856541521847248077392578125e-229"},
    {0x1.b79a4312f9cb4p-758, chars_format::scientific, 580,
        "1."
        "1326182622927227585026998401953453564387331526632995841434572566012270184131360172862035269820314552997461"
        "2413776329453373615156209188225602299611703931307655537572480430140533142776043280046186005695400263226405"
        "4098695658992751763639680664807306814276096257291132541721885536638354061211829923923336184608179768249661"
        "5655564150929904808543900488190715743181006200383902980812754628242850109644997858821492841688957682488157"
        "0801892773888859331879713604531979736514527913407419982887313114056184858415168691653101367251865741739853"
        "26892508292140337999853727524168789386749267578125e-228"},
    {0x1.0546601b642e2p-757, chars_format::scientific, 580,
        "1."
        "3463284210193605937745722937725857242949709999335060039840423204785367847390302267195263556416334323998196"
        "0737824736070186305672691183645646002343666546236439493821527304306900177800654130523476951053665910754980"
        "2006642369582270152401156269927147775627734652327692830564639498543071813945773867021650033486926053374860"
        "7064447801305583373185311623132192011604915251465977752968767098478902675252505947952937650369501082058516"
        "7696604253619444550313473087062527883887885241945951106616373139101667498193153482586796890932764432009382"
        "89032121165933464368436034419573843479156494140625e-228"},
    {0x1.e06b693958e4cp-756, chars_format::scientific, 578,
        "4."
        "9511263202511957641512399699829602641557623549736408253556822425590975395266427611114962041653194091053383"
        "3336879775284591319617332462680755701831085768322962567258389848441961989693426878116735587887408259374359"
        "2329287169456729011123175424958580526996189794057792610262538257537982706974488840316535755315962922121208"
        "2104534907468772395489064614074689875744296450508670594617851315848483996401206801717130288469826373770474"
        "1070405506427014217576152560575005033081034199467103000860613468937483063135363487535101835560640066559693"
        "432397641632558560331744956783950328826904296875e-228"},
    {0x1.9b121164ff8f2p-755, chars_format::scientific, 578,
        "8."
        "4728535909856012410200041906372414632296215272648004484427766845608477344705431493395232423944742460409199"
        "0778223620807142394934542575683530467976285196904925993313206910110734535883670650682654077675051720555490"
        "7153785753112902611247022137719954694936492237768465584405476424134983268359229541767595642143658069865886"
        "8311486350995177436653307794720582217765353864645824269735870431707954815959499644615997063996698543462258"
        "7493782430960216741916190622401646187797991212327006779815878528741174104469600086982166560311473505952658"
        "790405830624425931318910443224012851715087890625e-228"},
    {0x1.33c105a132a50p-754, chars_format::scientific, 575,
        "1."
        "2686651186489640418613729090000624883664125727826691528539824897946273278972673662123556913679663178920818"
        "9983431026863877108668219641584809556168837216776958126517591068005717065263272298248242603898184394956661"
        "2935545218642071817145322217521025560041269146239403948013671611970850556013445928964207740870533157257423"
        "5474192624851323842879640005145189256370467851069614167518680883900253222756097604564947196666302205472963"
        "5272862815877076419614503481104276280881883230397522547283862747567583163122464808826042178125167560452464"
        "976701592025420950449188239872455596923828125e-227"},
    {0x1.461881a63a0b1p-753, chars_format::scientific, 578,
        "2."
        "6885518067927030135600540861707655056802159939373748083541390174722386534014508552498653876610051009906744"
        "5588072524415445950949218647103736177038525626564873722274278821070632004195312288860329438863021795170526"
        "0348488305643570712966829103828184920483901645182663652301170189091428704104767787904483000287380436224672"
        "1781438144108851865293957093901180296561836196437647790186463949972800429878337528313848596170010590760822"
        "4914495063158132615052678462862682436495900588406487060191263024372546385805536617848116566363084955103460"
        "608268235720874628214005497284233570098876953125e-227"},
    {0x1.0c2407710943ep-752, chars_format::scientific, 576,
        "4."
        "4214640337505111554944922904823248343623564594516449176929291697505388608995390558125712875479191233524058"
        "6693816810894915724128757425416511778571176251130211532941252220691325000829704363646059477032385920079354"
        "4962681567393060012625739634735505971763236487302996987119743532149729213667588530593927826040852059927106"
        "1340719831810161934489555283359505257515360447477172801213945337256578391537827633397957645917471387846426"
        "1200380015132547253153164479656660812754868324751497403180618654707083628746868296897020739943514195984012"
        "2704954168408875148088554851710796356201171875e-227"},
    {0x1.f4741e5e15139p-751, chars_format::scientific, 577,
        "1."
        "6504299596692554662898438315568742680263082991056883014480508018205961615940064061679191491165679723425025"
        "2863380902661161947391420357522669511001475560313481087440258851257182689933724644529724655327662646988233"
        "6762161281034853480590013149229622340795138373021923715805777359887470617461808606384004424205619224951313"
        "3466820813188574640339167232416711196939091660364895317573753947157950137937372932611869784085126390992185"
        "6882812206410494132708440516194191677950453419818231956956927305302147631427349917441266753329544669595973"
        "13317938127585904339866829104721546173095703125e-226"},
    {0x1.5b320400f0d98p-750, chars_format::scientific, 573,
        "2."
        "2900091426989979358392530605461785016759482015004950433915892907133250152886447840948978235687269889320859"
        "8011555329351538993695790173998143655914545077937899287779003767388246713422999451873399075196857287901623"
        "2254708606129229326286431030847922256382404862982847219322903060522246908430848008821265886585966924413435"
        "6907554414094347760036636740432338875043535463497813544269468938114827178091505465716734212496341311036397"
        "3407460982512641208562604885921079704974941535175270523473393712114776663146839494306211123926383134927762"
        "3049276453315314938663505017757415771484375e-226"},
    {0x1.366f1ad138336p-749, chars_format::scientific, 574,
        "4."
        "0950816688862851715741981716510555491131806923753079625646873200101011841833105563713915712920089627877338"
        "6672732937467202519119479522480723407795353914204905417959638564763550732026709549946750372655366146768751"
        "8465985902038355614934756776928998890897769920782971767051608290557297810235286435333791164042348138624570"
        "9046496381294842944373805881307325210054336683711946102589264968227908777678781740079297949761856941279514"
        "4701597319058829218721200150253909999303678357294756834116509540473774653285708580012040678220305249095247"
        "55276801766257221970590762794017791748046875e-226"},
    {0x1.b68e4ea5cf6b2p-748, chars_format::scientific, 574,
        "1."
        "1570396019147199951614746811927139404489382923242367733464441788630888078074734225096038097286016984649018"
        "1257751514645035556156464040606586912645807541608011134962746741848405681341004188686066346084883838015448"
        "7709392372278436106894714725168488891402256613958895568185934523280803785025487945761033682602426807961772"
        "9904564830592280904276028380829012893805188297596888949701179576800381646868176872342258629059497492830636"
        "3044703711795299868868306207209032360457765193935610352982502060997012346564833664746548695777890303893988"
        "73717443638753366030869074165821075439453125e-225"},
    {0x1.5954dfa1e8cfbp-747, chars_format::scientific, 574,
        "1."
        "8221726162720878219391559104158395374959669147213245613503896745402028338069685891693215118247249574470577"
        "5773632834069059255893405040677506968723179290673586481906516623729639441266599175307316096622687835586709"
        "2618728864713924727177719872204601194021364444558707639237904893406100689615370860293434227131712148405798"
        "9380802416798615537137977507699992247403662018950839836603506336485592101596794523530482290152376909489707"
        "0300591877272350060504222949064487781676187937692524103140075795400513362329702290145224825379126327590939"
        "69035679716483855372644029557704925537109375e-225"},
    {0x1.63b19116eb98bp-746, chars_format::scientific, 573,
        "3."
        "7536981380660995920317409206965536403197907919708438483243207276046259780782636795750670960498823863331556"
        "4361973497515074649074065367912595029978418187255189561165849485222600093847343956329389558975557559433994"
        "5426797526359625422480751140301019400455902701141973071402070186685863946369415699476975609655342242607715"
        "4175594829868582239458210962130867456517266283551635612083202636192488879561782024006010046525100412652755"
        "5170158684805557278505285667702165065594214305077880047427292259582451470534124011087495426670029856086065"
        "4499549138307656903634779155254364013671875e-225"},
    {0x1.5ee917be76e59p-745, chars_format::scientific, 572,
        "7."
        "4064424298983799758409921962326965702801554143551704944707467008311784842257503029702562542519306298330314"
        "1981194326469369362196400053024258377938098669978555830397634582317243369415958205231282129633947664312153"
        "1976378191602362283805188798654196420950991548470132438346982289817929616927653810036882833861429456852197"
        "0713465987069320473011773610399506362043394265338556489274108520861453579183080406614208415614734431946343"
        "5152942179725876432292383499756386727340433786992675333060737024142305637908247415113277343120253686591211"
        "890466457390402865712530910968780517578125e-225"},
    {0x1.6a83518d3d07bp-744, chars_format::scientific, 572,
        "1."
        "5302655517853281865519088036641672349453364010152362760912937487442751067960308155681513204043060353114011"
        "9169719954301232130009138770629329047623431367136583488292739563960649306317491883315147232877811185355163"
        "8370183466073023350414179430653267818383940598863187341144619169938988058504946188990166111689037141174841"
        "9049310873563085132522363302203246396131818560894282203919762752828801213801660943168347443587721221760182"
        "4120899083102402432899611516052729144447370268452974713939382192826509551728150820699522893409931803161412"
        "415537068199000714230351150035858154296875e-224"},
    {0x1.82e119223c726p-743, chars_format::scientific, 570,
        "3."
        "2662448520856141582359969116197647314758219008736296797176525214401520867340405444019626396002597772252866"
        "3186968836682916017000501882086507974134707585824404879354484989379169992763394149298116714053649735117003"
        "4620473951673976632347333736927399827635100863212403303690831363747883357719095736646178466990610801108914"
        "5100688546861344607708883052424869986261801888046350637846415147864801751679914776550653014890427156042126"
        "5143357707928115720602473152213992952494569908513824173282587811025445448262815293110163847537687712297826"
        "2757424516848914208821952342987060546875e-224"},
    {0x1.9511005e0a3dfp-742, chars_format::scientific, 570,
        "6."
        "8395808072043960437946888615913144022818684597480409139416604854902806048015891947817642973494886224589391"
        "7947413915725902749084228620358340824715778220783690279558522472606442707272495233483210036215958136787138"
        "4747045125219246721474379386766703417334122219654531636577160208810229335271405672744950103125127528872400"
        "9435300708255534437191306099867781740609566530007646264293977991206060866325869748017718453607135207160818"
        "6568842594609317420574039197696219126111789580806886704377222403255162694449756479070580400807826281677544"
        "8607042875437400653026998043060302734375e-224"},
    {0x1.576318beef5dap-741, chars_format::scientific, 569,
        "1."
        "1596240640257126022580763758808333956544914575696812877152686057979427423806170124631043143735351202411969"
        "4363662457652244105630058142241979306591818240376577457661966478951484782536939435778999430258151174735559"
        "5089966426087501178358421511195473450370805053307045519754477962046904488712634815387123346504771003022944"
        "2722753411960100534791965680527445943153570370446261605271101412760296271908054669579741086604944255251851"
        "3374006349826604238537903375962608496582299588287827376733567575702244649391501104268570722067296520471808"
        "840557770281520788557827472686767578125e-223"},
    {0x1.3c835681df4d7p-740, chars_format::scientific, 569,
        "2."
        "1377398290102081642547105998237554930329666933658618760594961639445573510652955157391280972437083853672039"
        "8540998941814233984546474450984876341146695082690204736204153091292361713610538283246285375156970891488936"
        "4657721411115003246578851078377498053405000389321952672989234337447900215597922146055742073876247357396257"
        "9358521690424567183406689386488112127694739315104861479151904980569027263874934181377723991907538689472357"
        "1747205612378221487781918539268552325445912516413672019263037175191424832565863233869284296762895038863071"
        "250911929155336110852658748626708984375e-223"},
    {0x1.7d9de55918ba2p-739, chars_format::scientific, 567,
        "5."
        "1549054346354190045728099178612284242864048592546973638605764909752084453816898814444030014754736745717415"
        "3939513681086581225782028757920689989789619947673798544076608371701340543491069008762335362774759252282519"
        "9064650634747881447163611830016466349492795111878424263081300113733758864911137921755019812391457219469952"
        "2018826787081963786228915530507044987879833529533084057706702139312734830970335891638672616232082242460176"
        "6946182748458144665440232215693253443416551663932895618598752645643856647100005740868843057170269018277958"
        "2617200730965123511850833892822265625e-223"},
    {0x1.2414b43111a27p-738, chars_format::scientific, 567,
        "7."
        "8908966429612138761442053410825010841147511936821955177458713457438198805466271838051424678765828645719939"
        "8716167726634748358732992726254088667359542908405506833271333150314097274575986309942361703879329062363600"
        "8556508006663024226238472910535467867270836577618155340121918980941880199608993074855517174397941766797943"
        "3257699387199457655420176793846119930278466362457725082492520846136072700371070220886045238515771099913835"
        "3273919581839928751011974288119291623295782179106535018353071051530918600909349102146773770371535343306351"
        "7396561792338616214692592620849609375e-223"},
    {0x1.c124cfe4c459ep-737, chars_format::scientific, 566,
        "2."
        "4268259861629554096961607208386164396338924587886253098651453550140391339378844998393460288990930432820913"
        "5852605544145260297178418009195622867007636059040404647511674582759252082159463333924946122636209365307724"
        "0977873157795898832579503773541214993031434002947123764437546804261294178223949649858284233282072275776984"
        "8867766962872304329173251511142705953025211517869429174767445738885776946304025525607550282127555871896204"
        "6723786844906946927224287601746539109080079061293230280772642604110267497185547395959062910204359782805061"
        "396260271067149005830287933349609375e-222"},
    {0x1.db6ca39d80d3bp-736, chars_format::scientific, 566,
        "5."
        "1376518013281176581393767003881692452539216189638454082513861671056344330553488898982859915462604752562071"
        "3194858456483355295843937655229752763352932747821261035645606743918047613597052911193054514507809178873973"
        "8860992102826623263280195239978630705630377197171290709976656635856120178304492299111334031785584645526739"
        "6623011402146431073232036141359852328057576136808206313364418877233034792328694524368872457314118573580202"
        "7632133284215709838404948187667872353512508935047651023146817004887328668815745386660026858747409429610530"
        "917642563508707098662853240966796875e-222"},
    {0x1.2c644921df46cp-735, chars_format::scientific, 563,
        "6."
        "4923393123279893973798124975067957683661821055302531079268770502420049095140983455228370658848833305956119"
        "7328682798229063527454145383194037041466250579724775714844050640734797607497023266424826652646549956059872"
        "0122438324703282326440711764504014832126567471117309554888078096114310082094633910668580186775907732763117"
        "1603679876938544156082643007574401942740559623623544623788327531808322409634703611830824020277630688513162"
        "5921709679724265116094709949553901139341687598482559954476240751055168594273882198683993792029021073497485"
        "616599078639410436153411865234375e-222"},
    {0x1.6bd13122dbaecp-734, chars_format::scientific, 563,
        "1."
        "5726294053843144363681777730802477936874597299084010995107628966567384953622503257042435468958025681768951"
        "4556296506682508635691790408230988645053782874328147548076915865073026467921875301752650598198704321811945"
        "3256217150144733715978427901629387459284666143864869306007500181496611203249610419580016413429528044973803"
        "0498260886817981140598424248086555342030238604672222152498165969915199735649857611225997848420675936268197"
        "6604047511921835077849991651550299984928801347440824803576874096605998398187416862946416525739844020914670"
        "608135565998964011669158935546875e-221"},
    {0x1.287892a1444f4p-733, chars_format::scientific, 562,
        "2."
        "5630401696102993478539054633433987502198527063819861595789767934541667125215787275857810993033871291977652"
        "7357557274968367720569106246135522165132339121000037669478455657996670633099125384048964216917608128715393"
        "5906807676638979861995899482434722854021681551266558689523039027804336232103222151597704699482237992239166"
        "0359274271916002455343495552557398005709744430276564223663170930770139608062610354384149949188616132053843"
        "2032766932551477934507877337828248379260954800678355110576711200666093855448294052836140256287434172066674"
        "87562299356795847415924072265625e-221"},
    {0x1.b57a6911074d3p-732, chars_format::scientific, 563,
        "7."
        "5641405712977867210175274043088388783420867275149767322122351434047338374177936253438028204899302356962837"
        "0488523999137071089542042803849243123833082314485877867503612078844280060492941395300769301050477461083884"
        "4771708168843517945782166786778563721827463933958843025588740107399532386823702651549747742355276118694133"
        "6160543862549988839807751895579998772653688325470326107232963792745930375230680670041063232822687276267356"
        "9564881628548880660380868326841031190637588018517873017028771871603303484157541767382497748122591012254201"
        "103814921225421130657196044921875e-221"},
    {0x1.c6dd472003239p-731, chars_format::scientific, 563,
        "1."
        "5729507340845360691172961950552389472595381927177044158053486244001384093120472450655528827917252656828986"
        "4216611421173869718771305470695584254626336167914579072549868149824208386320969543895385031322917376889944"
        "7230105143157394883461683090195494454277831621323498297629020214235087735116688238005071860004717990435749"
        "0609359649320526641329699019669238016740369020731988890670133234059565100213750710244133154401228977080320"
        "5276992871702817661919812277763853056745348801031263010975075959504586828496545179759104529564690995446785"
        "137801271048374474048614501953125e-220"},
    {0x1.d8d511e371cedp-730, chars_format::scientific, 562,
        "3."
        "2701700758416348890173944451402027003733394142827984966197329168489787891030628871564620161154472920441976"
        "6307611657940026085950139753419063816685006534077373432881969780274053777402989565349198574634732026976514"
        "3503255254357620386504234408609488451270885440695994276651147053203891254558854795233618129556019768983064"
        "0184701664660375714893506854424496235149299558008859536198192378392345711490047852485737157747848891480215"
        "0630607439567831179019341191103700093381913366407539928796967549450157323322682232329438392219632739110757"
        "31348319095559418201446533203125e-220"},
    {0x1.124f0a5bff47fp-729, chars_format::scientific, 561,
        "3."
        "7943104300103846907465125718962807644452544067635609245252515780846857398156326074983345152492123344644782"
        "1885437295835467826221176433927630707683821690003074953611689959684984404544763811290392050828423812284286"
        "7366414367667191706792193414168278284604872591203010012649027975022160519975882018294860956880832296313536"
        "7584518805465684770614223278321761156339523325948618400016289310007069346377405273846598794682971919776451"
        "3811423318034585497341869887347777030479661972259914559435182043273955731705789607524360400575124535604842"
        "8902795421890914440155029296875e-220"},
    {0x1.04cfd796f792fp-728, chars_format::scientific, 560,
        "7."
        "2152364285788005379377524795979174964552660715900699704053929992547268233990189269000176177971746118345250"
        "6890531596087448200502671823360487351976610446845342947428207102346678631846396319052254600166448960949818"
        "6500465974675840014654365386862246582628238623047987966821810242214677090011418517167697893840061749072186"
        "3813117391739117779902599709017270299269508886378624385770036071380417341488142510535238002530826361679656"
        "4133325313357389734835576150072007476083226753697027000461059379961318619180529733097450138953020404297689"
        "083250588737428188323974609375e-220"},
    {0x1.dad5c3f1c8083p-727, chars_format::scientific, 560,
        "2."
        "6272169024527131679324702550410633379720544552442983857477309996825839785642672113952228338812997232757040"
        "3797174621153077818446075620602878393510121524818246548823801693833402030540125548686331399867214868694778"
        "4260560502252535561694789091997233504905922513669597935518961163028798881022064346029907879394780909043154"
        "6510688244717805991877047303956839696222139417136531025243815182537858993807034353276986207761918342522761"
        "4300384259833292804793092625070317127312066146987547947564826452153651186093453320258026285872153537948037"
        "183014093898236751556396484375e-219"},
    {0x1.c10f6676ee08fp-726, chars_format::scientific, 559,
        "4."
        "9692140757055039685842047867803507007965064813391203944533935860055513779002006825977512730737397856713792"
        "6521109400378936101134773568989454265111600307864836389445565543201080839068439167059749047437910051659606"
        "4625090341000441213521055191798235088826104555942477721851467019646047257372488602165144957533569983171669"
        "7266729296749078146706981079609212540351242271637174021478319280589008464239239745801817192984144557569294"
        "7272035641528057138305985529303378800935731596276356114916201308852708295081464082330730116848424571251996"
        "43996893428266048431396484375e-219"},
    {0x1.09d1c057f71b1p-725, chars_format::scientific, 558,
        "5."
        "8830122891423099384974225173148494713081864421101162087417346023157060407226954996657527710036574230300777"
        "8228849597449568302036718302194461244246668661412782472746574338449486220048071223852647745826445147658614"
        "4430653128313524882251162242029169684145131727237899353273750494174098311927424774952874365921338158977154"
        "6065750542832073408942424875590605836275787577900142528431793301587988020156120572901113235812687331457996"
        "1154642175089610096423965852398002114518436398455397841740576752460394155163561730458765986363084410371016"
        "0197806544601917266845703125e-219"},
    {0x1.4d15da31c76d7p-724, chars_format::scientific, 558,
        "1."
        "4743436359705466669425597004321834607160275202191708101647359884779278816000005465530348819209779595146819"
        "3274657326555527683528423165521075539607371822078683349867541347863453219805292318913772267021247819793992"
        "0891478945700675670578997649636833850295033438465261262013370652846731723982875478958167012077393670206969"
        "0600361602022159246479474998393004303980486125738995295279594477648650045806279857474029772106803426533603"
        "8275194781950606208085012372213473554552613880716866570935356126307329100842696616070606264233683324604839"
        "9814753793179988861083984375e-218"},
    {0x1.88eb0dbcf442ap-723, chars_format::scientific, 556,
        "3."
        "4783661139951836659834650869398120825446263038654374830389179725779207115608018307232395526906385987088082"
        "4300939458172670455150508058822235267367986041627005790042997377904752045570140208853566396039690367647975"
        "8706671069406990269746660238927428872711018746481991387760562749230806116297403149718889702098837849022025"
        "5913529791938285558143796317931984839907097658936340062828470837435597321113430649553015925929159557163989"
        "7200311940047402536426101840440670659097350647474752106036851970713051703441768301934192532745560022533481"
        "96973092854022979736328125e-218"},
    {0x1.4855037984a9fp-722, chars_format::scientific, 556,
        "5."
        "8132163840225073067103367504949528996314796226487824120028997327955421486231049647242313211271414237877849"
        "6575931983419043299641654638440132125481074183643823625939890917321998087428065303811935078982220060216703"
        "3080320155151816220164993979839757227461089845910506971715485581225714522454629832571060428488951781247009"
        "7151684577794782847430343609839366343499101500085822887900487908381027204874540283621144246564638885440392"
        "9804648678499580352812183946211325003975603679026913411470755820684245890767411404683725822603590493997671"
        "72872088849544525146484375e-218"},
    {0x1.9bdf4fb46cd50p-721, chars_format::scientific, 552,
        "1."
        "4584641434878504465497720362417662180955274726977105761716287781409371922551725296330598498660010627062041"
        "4109901686131526983419367027803870618372028238406674358525350147445594176436041882093323966634786798353743"
        "0948325547099905606010669434778234784583536242970120916339292852416310909963648082888736027543685653844861"
        "3952710301010589710537711722090325475348344984737385438871422926542463279581236916939059511106840811631424"
        "9538880185435710253794201340101487723780500252093742594419319926143493063899916744598998091797525944457447"
        "6219713687896728515625e-217"},
    {0x1.5226e4ee6e982p-720, chars_format::scientific, 554,
        "2."
        "3948318645722383698596132966002861356262867738431677803939697357779251148165688995352120160627222611575929"
        "9689826700992662030416378730689248077616852136705267786161545096222007215990088839119646235536279253476934"
        "9003551732144440707467704087139749385796202008451363169785499180779157968872915037551550990021449529891812"
        "5517183603560498907759526081213279162400316981058258462632041089918690774422656232572587897271295319785406"
        "4812435396373595099397773524674835098025684827649463758892584301435835947832788841887802396002360438842515"
        "577562153339385986328125e-217"},
    {0x1.b6eda5fbd10c5p-719, chars_format::scientific, 554,
        "6."
        "2170841982723338730702402774174581104079444355770645227799441152140990179937180891783242637499954374597087"
        "3008464662250243986006844228667869882594430102531078175913907335687966432831398569868860162052899262109384"
        "5883473398478959234838688550011663002757229956068858414758150089312638851089337799986122131137270728206083"
        "2893291385031591432573726834519044254175548566041758328320909158474462834862032394036782743365444459136656"
        "4824457589210171975436779113469419212320975164890670393225444447157944180323651986618178379162547031455687"
        "829293310642242431640625e-217"},
    {0x1.ab54a9970b491p-718, chars_format::scientific, 554,
        "1."
        "2105626076543997255531329501726923857588877013053286207541994102509381369451991729752658885355274540690355"
        "5024928460084443639809967630734347791425042367511569366398014451637268244225964319453806479955920246917322"
        "4725157361024728582311997914670812221434452861298531071639274681709795071912599059726607128925012726609172"
        "1796505804854529742126200406823478966258730629381222482927094750078171044839460480027612836177749536420318"
        "6481127306920043772287163277386036128721081549056499440748286378438450585143025905904301010862500476150671"
        "602226793766021728515625e-216"},
    {0x1.e52475ef13116p-717, chars_format::scientific, 552,
        "2."
        "7486687055906062577881540001431501496575123590678476529391262404690426983095262500085467262333027891722830"
        "9369613395301844882547555622556829703655868321121356990562366845714786526091127616873916492482916608026871"
        "7602849506400147401598589825990533520239405794744626858577327624634743462392529663276150233619312212816854"
        "9072964925682415315626227428381800235264458800518729103506057993613643332214275142683792589021523962328572"
        "9865420017710938892453157987835329199562430315689174276210015076968788768203356014704474147292145858045842"
        "0328795909881591796875e-216"},
    {0x1.351edff72489dp-716, chars_format::scientific, 552,
        "3."
        "5027657450499662471757545735089001918731485641097980290576178547757495509249093266284554696367026278492810"
        "0147173830738518713645420310526648989877752676392141828172888665979441700520145529662902345885785383753539"
        "1376370469690434685885587545230474222594249760620632271040847695338529030730762570328772853749408787613766"
        "8270604712743772537998893069321436302826336423836895233476630313955731119058149690419864151407171234861512"
        "8474122750522428045014018099803822512938181757888309118095505239530365123035368002575324491987274200255342"
        "2935307025909423828125e-216"},
    {0x1.9d894421705e4p-715, chars_format::scientific, 549,
        "9."
        "3718787940821138640143238528704947331582272378326109901966018120838594360065413663088557482229251218067569"
        "2371300339797039083262347018707985682314341168037040952899218264275877516637512478504333541208945387730294"
        "8788479526657955342331154879371913354353728215275083747527094608785656520445709279082581079933935684375053"
        "7970732376976367986120404826719685528839665031396276263448812459785233011630612074800352768861034195271243"
        "4605308321679121688893108324785422380802302551469557739581220727134268270817100629239276843307493436441291"
        "1236286163330078125e-216"},
    {0x1.e5b92a8e62631p-714, chars_format::scientific, 551,
        "2."
        "2015678401956501509913015563202673349273994830102214878621064509890592629710942073381394734079571892066071"
        "7487730292989115288528305280638727413962106934831869139267022072217246445392935266135588703131037280675127"
        "9330987296821526480487767504365898637613452426541908791360526539551414732583564950686053667485060220450589"
        "9377266646047617280040514279127012951123130564005585555626870345590497806540537552635681909822254316423847"
        "6156766516279219677862865539783026980640293512478470347104263432506258267583226624305482721499771514572785"
        "235941410064697265625e-215"},
    {0x1.5145b770bd17bp-713, chars_format::scientific, 550,
        "3."
        "0574111115052798755704223370355788580585808691529488807936764944992602196499942092750844854714155848637597"
        "6497130637186256919022738489601122933480405757980718915295656524814620284490229794811067698027804710242913"
        "0376602599274637302539181859471723845759904668345426627291624744410958365438947344354893144388403260841879"
        "1325650128517766244303228585118902873034286845844905346105029784310865178592908660838937112931288536138630"
        "6009764825661633654047990831795098362102506534239404342245751501345683352411639527096073876144544101407518"
        "61035823822021484375e-215"},
    {0x1.285ec117f96cdp-712, chars_format::scientific, 549,
        "5."
        "3732563210682168420160693837490128172921363352811330680377129309428579320206596965611505276898569179318064"
        "7093390822649793019079985569694858841420483773418054150208979227588072543018999060176454825188719716750266"
        "1464925503548223182782469269863121025084723548092520888452073422375220993719096473946649034335302943612161"
        "3096677012827332884190800037895188734464273611331722229788010640188364868864193380798439305695257683444830"
        "2578304119397235029009490306081909908983761213174092123799691360182549197602745922903305642037707912095356"
        "7326068878173828125e-215"},
    {0x1.1e8cb1b784211p-711, chars_format::scientific, 549,
        "1."
        "0390415242853728816041217572591158422222247006803021323666432451437875045999340376240492922325054882674552"
        "7408607706487609351627677616440371363336671781330254328137763364074729743139935129859512507832805869472312"
        "6339297623061284057853330414173406542547210083549372626832453025030820018846792813026550288561349826779134"
        "9277277621847116668163955578302733989002925493494555577398661411420940027588717214435232462267698247622369"
        "0888792643168096799257646791531616954197624569093221460530831327866723955961876871018773060839635036245454"
        "1027545928955078125e-214"},
    {0x1.614c26f94db72p-710, chars_format::scientific, 547,
        "2."
        "5621446229095083155702111829323711502594107915197651192397683293270975877689437093976421160394334140860514"
        "3508654306899631700199453849808488956890026352075766904074073805277078860674472639414882982434752290186285"
        "7504465252020208455116434356283038730965714616498666771546909185959002909855327970887019228977304196897290"
        "1944724658400811662637824393687273273295100029361142051970122838752977899584677183241852846360865547995966"
        "6687843860920406095408137347378557822727582591951003279152824322080606068595729331652255389428773924009874"
        "46308135986328125e-214"},
    {0x1.cb0371a5199dcp-709, chars_format::scientific, 545,
        "6."
        "6576126403697076608882696856128986307080116494217692992548764570798174913048894445931404315822786110091829"
        "6649348687901768437850106811170410660836029465125717942313828125061569507507709085499361748389979318407375"
        "7272184536689291808393520451326509862470686467487625232638447718595087340927786472243230843937796297226695"
        "3842878096505666768374797711233029598166668335444663888730788648119384576217082726860978665043128401209712"
        "9547423798181108350450372658894135422090442624951810200919587095679400509616314811356385661156309652142226"
        "696014404296875e-214"},
    {0x1.5c0c6be27bdbdp-708, chars_format::scientific, 547,
        "1."
        "0096315129023046456467927747886062404829941065542894028799876798238419315163636763041967115486534078158780"
        "3792746626275267505476475853627997814869597841933589181384945321349031280264494810636851886988579388341166"
        "1080080357956361471549802945541738879096317122362902737135301247488849687812997256313209104551730147943627"
        "9917883447751656421134845380154896344888378922177548945568579291932819057367458807794924092411351316038054"
        "7290591838918031503312280507777151643810289962815833121504010394331494282721910617575677981960780016379430"
        "89008331298828125e-213"},
    {0x1.9b18dabf10f4fp-707, chars_format::scientific, 546,
        "2."
        "3850500688279488736069088312896597807712501153938563573110116042391645632737275531425873467863538337130966"
        "7891010427975650224937133559719351401006461226265549956373571669015855704039359014374848412483435923712895"
        "4250186816972181807777308389417398269916805254701545926256463106859217585143569273237619388976344522803930"
        "4203567895064463853141388798875624607003998797915225340849743889366284235720427859685783218868506557926674"
        "1580214199554455933843367880842257560684391957709515003912459582292372011308966266857067850537532649468630"
        "5522918701171875e-213"},
    {0x1.a3e82b920dbbcp-706, chars_format::scientific, 543,
        "4."
        "8723235743335383007316942037138333939727876640397027548637587311727725444457866859726981985910149027071370"
        "6468340207283669307155333779520424052725448086908738353241626783050347648634151847564260366778472261414833"
        "2613564491961095108182457631457759132936579947589807479206304597712222245032642246469025898682295077537797"
        "9074763121811936361499537945776887634577317313987291053433221818981193498354026091626856226453756264612039"
        "3754530427037991319234814470049958889326819291611453036550148575437432122510385962277368321338144596666097"
        "6409912109375e-213"},
    {0x1.e55d4e34997edp-705, chars_format::scientific, 545,
        "1."
        "1263700063301883961637593345853650848173698173906203553947316800214949500052155115279306618384733383355823"
        "9012593269879463412835243497329655831225472435522686519182378700969305497526912686191024754645697306870198"
        "7762145427468664520014456587758418342960524150909771188685359678729708491944850185052337045874514571952057"
        "4137475072159689914997940459086273680774009478900069713199343055246913368028437896195004050375544491283694"
        "1746714816416655581946140115510899932593584992390168732897366379179420338335127806106417125420193769969046"
        "115875244140625e-212"},
    {0x1.82443127bdb92p-704, chars_format::scientific, 543,
        "1."
        "7927923533931952950586931510282749592790453715109808832297352620022802755310066252394361312560633056624429"
        "8444201320939750950080181045198894675756701860610234013571800216193558312750617204334599296344409701776745"
        "5629192373004068874618729305040214979501665418511156657769937991179760363455405882943393933388417275007027"
        "9238392034119581576347126335201240604873503387124270592794021386497103267133076944317349877812852252494116"
        "1179202904954465216073197261130107718452951168115991671745272658875064850016612522098924387137230951339006"
        "4239501953125e-212"},
    {0x1.c3ddc4e626843p-703, chars_format::scientific, 543,
        "4."
        "1945272696274143506064751591019143690519608938330793458941131430315420967011543669286107587304069881291831"
        "6032656187170995340885670400984520535211128358722668170887203873605927186042732064909372141468474051452393"
        "3678415858455418832312297913362303042355926367090313440035220453662023511344211217569805253299537764581623"
        "9298412580286410353907497125866517188536279462904565662754642482258294680343001078696867682334679872718368"
        "0479454352306477125153503393953171166192097258701941353102439406321508295406082916789713976868370082229375"
        "8392333984375e-212"},
    {0x1.85179680c1b94p-702, chars_format::scientific, 540,
        "7."
        "2236307258538304887715568455167838293359876919019126748017947977725350522616163447033071439365285720056989"
        "1830461200043803436029630915487962565111962873028113557121533529866936632303307488823207702072296748481648"
        "3207014721774399563123795598496459219700635915793195213974388269457089126242058992162724467598411268911353"
        "5041058088826843891771253918599206993317190354583185164130892272323989170581794237052458129973574375453130"
        "8094598405624524073068109367799283444890475986358854047759977156130022709224630661495325512078125029802322"
        "3876953125e-212"},
    {0x1.03abb48e8728dp-701, chars_format::scientific, 541,
        "9."
        "6417543570694105910088319847436003732314160404928095487625173156883373210396589866754925983282318468734151"
        "4860626102306640936393564625714042933596543888017233328739922582864914111709598516057698962957292905855399"
        "0934567441164734848774927916780969315595016517054297439820165043351563820924614514119398727275481604029996"
        "0756386042271669947379377208367499428338782010383566943029832407667528711616577681695535866646659071647091"
        "4123908388130256787445397850940448407274826997829338472227774193835039834169289840737349095434183254837989"
        "80712890625e-212"},
    {0x1.79d5b387ff6e1p-700, chars_format::scientific, 541,
        "2."
        "8058534999670358996633679682617510657197520464930955705056307782763303148434523913703200877980345442582067"
        "4486691061078409468449240314443515147593774451511192439041146470049754857277557200825953109839924060422472"
        "5351798824855369573419311576039958119981039707226303862508802136483934658223688603762220164216055731622818"
        "9010355568985916250984833862564859204793321703030409451231964242558722126734054399784848841245168962609624"
        "2173140130434703254320898457436036968768953024903954353705239159040468922704306131699070192553335800766944"
        "88525390625e-211"},
    {0x1.f9a36c542f98ap-699, chars_format::scientific, 539,
        "7."
        "5098815942701431264042911004176988103520194201365702934373413006724432292697433861353923851217255084766983"
        "6599886630527602489344121303782618389277881882670799795601764912090432524174366596031421997948061932162102"
        "3117734679986634642030304403759434983992681398802899425054501200452186621488202264269552010067268804359334"
        "1738127090236808055131909220403452002271755020123581692062574392122588359572183090485242498908330249497151"
        "1253704899077164433785232677029233050564661707197414749244240081859608324128807499420190652017481625080108"
        "642578125e-211"},
    {0x1.dcc43228552e1p-698, chars_format::scientific, 540,
        "1."
        "4162133808983744258886960127739256541973507395750856304999796672802119573692833361419165044069472916119768"
        "2626134172668197351710112526943632551376973400614773690079165656484698046811087576617553125730497832111644"
        "9781456794745739819723112960798249196264114657578024943397007196103135600134960687383208140764370034939725"
        "6333481638144816073339075261783865664048692839880337281432279537203733127391385250064522871588966853314004"
        "6779946169294976195251626252015124492655057417910144823152616491496420608135059504562036636343691498041152"
        "9541015625e-210"},
    {0x1.d0b8e4fa0662dp-697, chars_format::scientific, 539,
        "2."
        "7608735580016018810532251366986066427701731560219460946383276544412397502773716043763024013333758381762491"
        "2766591900986052852630094841182135458765270892661477506362963745598227260101624863784743478641335048748703"
        "8347358590002100584791242861223336881162576985051154343250452765979930861239511263072723698300020976430933"
        "4957108997036962159641594598842541302828078543085854370441114036051976116492434546275183049970630689903281"
        "9114395235094129047761582275001321029896541652183422416686914671450455067459872626756123281666077673435211"
        "181640625e-210"},
    {0x1.b8f44bdf82c3bp-696, chars_format::scientific, 538,
        "5."
        "2393404251407047567474899294317887937950423337622470825030283559680483919109740585087289336722256687375700"
        "0562612150372259732590220204200981462672070447082476439023788329111668015810993854242609354608168841001197"
        "5721911366783257993585749567931267566346598996672644920149221841635228584772963688239938336655237227386206"
        "8491342840831866257649196363752331752920763018118631801890578071444865477033486159660377821557266936722920"
        "3653830659767569868274491572483668536449410976001011211353130518765763802210844168882886151550337672233581"
        "54296875e-210"},
    {0x1.f859c249f388dp-695, chars_format::scientific, 538,
        "1."
        "1985208897227798591039255948760211295972666003794523598898895366020833219755267124170139715038638699952937"
        "4329645641469104729428750120637526367360593775039076317110708918658483802996513415675328247462305935532785"
        "3345693077234597796127995527491563794867569650848921446775522592734337766008213264400815397407021420615343"
        "1176922528484394185175495700629128401173269414579032286321428360062399315349631550183174906062438748159785"
        "8516867445804419504747204630742763446810820288164538437931161379214648832550182966372176451841369271278381"
        "34765625e-209"},
    {0x1.76c3cf6d25fe8p-694, chars_format::scientific, 534,
        "1."
        "7811558999586523701977647593653910305007237069848717168449377479088923371990969176642927894674055304613438"
        "5672757693904280120418869003651550514604809425577325849506851929562524269723511223669099656493330621079242"
        "8428532458822479610900457972964267869820261321558949972877826760738857749922382498268945857045773232228967"
        "8217862435840327482891491017196268320347469034697494415172295492230087479206891090890393696595327575030145"
        "6994053947741352652623430920429779814837285839361266979135427518008642083779946574395580682903528213500976"
        "5625e-209"},
    {0x1.b9755a541518dp-693, chars_format::scientific, 536,
        "4."
        "1962642963537321076602226972991351491104742192225758657473795663642271950965237649181687944784531856492724"
        "8565355071455733746569152196344022113027036138256316024271384693248884883018412271913955944148702408979980"
        "0598227265908537135628614882879304623430375054715224577326792297458415887012265235615755629258591793791972"
        "1642684984061588604707508785500264498166000046974354417486291970140109533598016391655783942366698854204024"
        "2341326597783970853680579332068366495230471063766360766930156215738360360456571385157076292671263217926025"
        "390625e-209"},
    {0x1.f9c57cc980773p-692, chars_format::scientific, 535,
        "9."
        "6151781021743031816511544979411331543689547428158611066559215048652158551199908498702146817365187884427510"
        "2350184914401779293504720175219084860292010793608864288357348223601530554819113162490280742714226103002168"
        "4787171977026814222128547887762200230029015250967853285838300682440492056232862759485418693647725985578269"
        "1550194921251369678834994115687793640049054121013242722791010216905285005198355969738557592934334727596160"
        "2106476021831384121674402994034324448547614929792406649935288203665277248499698714567784918472170829772949"
        "21875e-209"},
    {0x1.e4a6ad7e5cfc6p-691, chars_format::scientific, 534,
        "1."
        "8427321798270691931419529256184313716571973690089230501201213024968691169451064054203767633648839365337058"
        "9959392624389463429096165611132917690021295878986853446245457921782248607739873408176038083804939583706995"
        "0654397880772093066305522988989510818550541148687265521818289398962787230883040650157422886214071659687864"
        "3792754837833575353871758489957381015893355378481232127208667013672716372137306883068549817908551789512733"
        "9316502913213462282092457461996729259367925729225844679795995907374116934418495361569512169808149337768554"
        "6875e-208"},
    {0x1.7f07a911528afp-690, chars_format::scientific, 534,
        "2."
        "9126998289538513112480448166551114592654020719347039834038759867260996999416181764018441153984388750809778"
        "0175629271501825790485883418229175243037382302172755297279108088469220160306070492618960031004834039173709"
        "4843896631120823118503330457284170724809216045678379076340848600459520650305058603045381131112866260428467"
        "6407593658543022863820181235359501241223422387971893606331689220550564750593432841072650225389271369147403"
        "5512661765215882184128685885148232309762780083810333437476996260755753714866145287487597670406103134155273"
        "4375e-208"},
    {0x1.2f7677b3b90c2p-689, chars_format::scientific, 532,
        "4."
        "6152840107250803974346147876459468792499531906015218999353543308743048639273421787001944283505171919058319"
        "8144255365651071365678271599484595358357673877795342194463858767642709308320670009187206082826373037562838"
        "5820261005469798564184709286723729385073245071251176864233114190345074392110857638137153854209350977844546"
        "6239189605282520378949050856283020490336290298380676951122376139656287149424509011548673735977675085494428"
        "4169319003497073383951870387582031016960451123529784253738775685058440267916068933118367567658424377441406"
        "25e-208"},
    {0x1.c96e22e0f49e0p-688, chars_format::scientific, 528,
        "1."
        "3913867725663096448636565841594072797239179967141265670015911796658179232356371330082615064109491014185571"
        "7852548486936144847167954972821760976259988719708497654837756844368594047016474258346086098675771802638328"
        "1517450488570140127406126304896613526413806573826761435555192929139460417688891661002342541921558364334502"
        "6424879420586382525190545149881043545710069777649964342012328828582070171780832398513896867752356832570177"
        "38989819696745189651711690480619467448362029039063335112658375929128862225070406566374003887176513671875e-"
        "207"},
    {0x1.22d28ade59d78p-687, chars_format::scientific, 529,
        "1."
        "7692162295985285274613328500102516630943365500476087310567181746961135254937482576801750221428295918086536"
        "3285468548760863155815912570868365060156998843371602515772361967652878837326101707102753470819861557367288"
        "3481713892386335979436052605905323135549877546295135146022879990274278167641463897483651103068687816673451"
        "5907500780062167799434488187226465946666108588036946480456968207077669688736279858958332805166846949099791"
        "588247445999167063696700086089680623439003509639588506091337715385447548754882518551312386989593505859375e"
        "-207"},
    {0x1.11c6046b7b121p-686, chars_format::scientific, 531,
        "3."
        "3309984084439476052884870790017880296080055634528788265015815316869436089527404130952395838719945250131986"
        "9730320728842084196597888023818389616975983226758975382992530982514820717966583153778807531118235599662188"
        "9597602340856152965036165428696464896332879564853822887552698906231145653313756449773063821682323652058481"
        "9547805275196402678496748808344099487927760988789865833706607909581306479099658359625457565668934621834351"
        "3757747548413425604442641719595489739459706804383826827911176430511291934877249332203064113855361938476562"
        "5e-207"},
    {0x1.198b1ed81b492p-685, chars_format::scientific, 529,
        "6."
        "8510701846894067422582475523370404378011418963303009769966838302347841714706482962267873687455961537128859"
        "9906207574662056939466225701661938852045145443629892554749935483888325578119293711819310924456525734183163"
        "6915472912399010879835032970087392517046341912957239003522427587484984610921827305673994149628011173396226"
        "3780525714752427605029016226469261556860836160984332674984228909414266256047184662690199519534155528347876"
        "034022294815245715147598466779192478520189164084980440014264351823725096579664750606752932071685791015625e"
        "-207"},
    {0x1.da6addabbbd1fp-684, chars_format::scientific, 530,
        "2."
        "3088921688496223736447698070618132190331861821537468965751360953523467964117030458093659711888679953431325"
        "6791383016641616913805533295082590105365577700220213661827891554176114291090426996418755045595031272391436"
        "5056337843282569335669119776810340847055881483383938852947141165661430884677477472557582460844244118662091"
        "7179971616485032181643293539463714565118379358749880808820996661168372725964919205188069147711554587345138"
        "9108133001777714280339866642455389931961554995216357284980538007966577307428224230534397065639495849609375"
        "e-206"},
    {0x1.d56a8fd15797dp-683, chars_format::scientific, 529,
        "4."
        "5691048306445641604873487344582286150036188199466936663762245861254367951253078053084337328657486501850324"
        "4639933585428847066193727231878618202759175994292635769866898199587603013635816698477200737836786434113051"
        "0572218930930147956667737444440711664958909309074610966569304085097304218562735090854035050636703161868796"
        "8928801205899327226333183208398450978715639442169140673197444986361607235881156993779171410174755922663555"
        "574675719765400978001502127488303683860400844254815568243693565432528291836433709249831736087799072265625e"
        "-206"},
    {0x1.f3aa6275d60fep-682, chars_format::scientific, 527,
        "9."
        "7270783116371221191762939854842941752679733416007252745486261609859880583198730913356445623264907215190864"
        "8560349300936337143532788944063699216212541764989243921159202999554308982439677599213591449347542999436251"
        "4845075367400598016897410898113328837764425820423149230175473845973261109374719277837435612064676023199513"
        "2475233045514061072806455531384785125604686392921739119523946853964894459653941721178135905207621152684004"
        "9022573637782547046925665674774262349927107727157916980699199453741510268400816130451858043670654296875e-"
        "206"},
    {0x1.0771405e2a869p-681, chars_format::scientific, 528,
        "1."
        "0256959546160606488726805315356855337658063975579249432725148357253870081722014642762758518975160176683096"
        "4808276510052018475391378929787195203544548808862085870952275388594930486183074992699706535882260315165688"
        "0892231031191155150934789100065019417689392678461684332352523612060746529016035174062783183041957589223796"
        "2611722543461090395136869252370957694533919461366539737366218664440312378620580551773284635761441384637008"
        "17283527981808733394394904977790897574079405672970002302133341216816564411828949232585728168487548828125e-"
        "205"},
    {0x1.ee86c40e3a880p-680, chars_format::scientific, 520,
        "3."
        "8508135367330314292296381359837063529186758232718527682702510581759040588871922777381914733711030542054411"
        "6504406319838169445218070711077138616618166877563823794260052689199619964193690292172702945639700832394191"
        "5328700138150745001949277117267453139446838790491763636519220242854305248572010509495178581545932452964994"
        "9108075855219014019756123543254738453324470847942263428819845634073838218187937116566664828909343554431079"
        "815240877180188791702678289624792713938430940614004939666348281690488875028677284717559814453125e-205"},
    {0x1.585a84931d29bp-679, chars_format::scientific, 526,
        "5."
        "3628739344977650941399396994664062909446794105596352721943281729728627450572873114769800695622557543189087"
        "6170408118377833454298924787139421021372070641261228862807374926415125351691951403510273975967747017495700"
        "6029397110551891149991745218172557472670307074649319964465385236521148916045120642010778039075647952239021"
        "2432361954484400227604278580711506847746818030711390963728533887728476714567950565229014485423029218375353"
        "750732081888124338330413581757188688331103832532131348029085481099453858178094378672540187835693359375e-"
        "205"},
    {0x1.7a49530caf5a8p-678, chars_format::scientific, 523,
        "1."
        "1782670406981829321748342170270093032401355879831618957954947784523973296396796916865369743006762277930095"
        "0567702062680043666952893020944559270149791677273250353005779342633235074698481516601654762622366900001635"
        "2281219998184870480772600739120486824490248828894700930458720074575576880726612790401491826496007397517867"
        "0647685837737977220505846996881709361842165075378521510676934361503017940903085360306384528629882989519304"
        "090767877812950822319769876550077524994542753523582646391944239727678223061957396566867828369140625e-204"},
    {0x1.3b2a42806488cp-677, chars_format::scientific, 523,
        "1."
        "9633198540986483775799261383979870216240862506382911577912309546688800104365843575901826331397993154616681"
        "2471280347835772651872541523676383736038356840857212840087851443915105283550968900875649801137459350855386"
        "5821482142774480083157679864221799425963658261456298178545244297451518724341603830296153018149068454475650"
        "8028506847600398711903974966533330036220169201991967451668704148602041768160661383832744400783773461300798"
        "358098723210470279803874144148526265154314849414816574238971946808618440627469681203365325927734375e-204"},
    {0x1.c83826db2d099p-676, chars_format::scientific, 524,
        "5."
        "6840339139060946981762684285710865654814425966664609557362410206095193210907436592806745280940604984084917"
        "3638712394538581010752596199682994606441641293311620399555882268983726840264501484788914059102776623643905"
        "2122858877029711702866367625234785883294752383576438575622547825433771433309812245628796339307339366141624"
        "8327266687372571881603606669105061926117522601057432280607513852894404333029087097387483751980844478298920"
        "2235197876029202131802937817666288074953338254840490731769654664251589792911545373499393463134765625e-"
        "204"},
    {0x1.ab36df94f8e93p-675, chars_format::scientific, 524,
        "1."
        "0645321758200814413322079175861714925420398312598654352133555760997816258375072365309746623458451602566928"
        "8892955587817123557658132010249725751416542814066399908321499983973004793509504161485004080347135156251003"
        "5442658249039229363606436055076672347113866815163628981036236168445495284717579960502642475861507919904976"
        "0415239301735078975625527410821978439898777022303097916766691649207535368545176326930298026323109512486224"
        "3828406557136280207205919064795260099278785611381060600944513383492306957123219035565853118896484375e-"
        "203"},
    {0x1.50471d0714b77p-674, chars_format::scientific, 523,
        "1."
        "6758731287663245067929802646359253751876178073393718529381383029991245143140589642891986998226638001813841"
        "1884571540760722831242178043882468016912989619180020502706117428233351747395942121515884241840494596513741"
        "3168379056082846586489400073062815260306226775250614217297608945528700853686763895314550239200685720351426"
        "9290032819751222225759992649072668129215176147377509677947335109118716015043007331011463548126614761292320"
        "640235481244469082541147893929952413974668845082847184134976215030832236152491532266139984130859375e-203"},
    {0x1.af855fc3c3b42p-673, chars_format::scientific, 521,
        "4."
        "3010538577728233744816436369978549136976645950673498532952391599320329530671325173016013614684923269901956"
        "0268052180793702299742913140983893922344975035501831505450412114109672135334397735251037816337885684958047"
        "3992723015478174654344760932744538761509098314194729572674808143340483916485684814524519684382188211579232"
        "2879301647036270532651278165887797562530738322949801980031349707060037709951853600603902434774229050505469"
        "0763471466516501229666796891561067299047712433489573159196839302609305377700366079807281494140625e-203"},
    {0x1.ad47ff12ec668p-672, chars_format::scientific, 518,
        "8."
        "5574595335115486808557631060044950010564116057553208117505835698979224270605230907269762845091732308470041"
        "2661175089528304438909809546901546014735177540676134332138472881953762100352137042313700018497337879496165"
        "9189580288095025616031282691409656494757870534052617087201115566268802280358798705227412553213249254918373"
        "1480193588714200446263056192475952356968184570908882976764095565692431171738149734334933275867032274731426"
        "4652633278520834947286422890756022706803482172043515997794660421504886471666395664215087890625e-203"},
    {0x1.2cde48f104883p-671, chars_format::scientific, 521,
        "1."
        "1995252022699291430772090009162585049509756433689356686849255866758337996064757995487412332217041915275396"
        "4502645220981501885133249216447042172461355588080996605721879177162634972981475480497356065079367468236338"
        "3237004497147886219100337958851778353767446944517197980739705022950728600049945132461920818493416267256795"
        "7907818111439963640990460062983183893943301010505311294044136435378077390399185184359595876312531247040973"
        "9561953852017096495437565634136727399479205502966257918494308309931284384219907224178314208984375e-202"},
    {0x1.946b82be44de8p-670, chars_format::scientific, 517,
        "3."
        "2247460965180460029537786395406798165049710692182337402826426147217110915625857896714231641153250293652179"
        "8048216973815754542961726075194872454516155016492934790014344438607116755383594469734469708786475281532119"
        "8632661073619619247275295413044208923754797487662014202281803328562662568942790221177840910386833830029037"
        "5416632087550289611906245010468012912803588788333467800241460580247976347907750916579605580990918756438712"
        "680014884999019899375412526120418451580793367541540907217356703995392308570444583892822265625e-202"},
    {0x1.4e2c914eb1616p-669, chars_format::scientific, 518,
        "5."
        "3292453195387590853998556300829021590225189208980014515926856740122155957485101726194890227274448168718106"
        "5927924279053206776354571063402558326010932660840917790876541357680066598140056129283600893403415124104507"
        "0961228748867478240688904822297467593907518308374935005892642075637132415584498144496749609150067413936743"
        "9954339942007959039524337809360913993203485623878501836329594368309888038663244905138395997368272478763961"
        "3141872635547279188040318374333051363586680061786428168335572053138093906454741954803466796875e-202"},
    {0x1.031a309da2912p-668, chars_format::scientific, 517,
        "8."
        "2640741741205575704886671257776920898830696348304845258875783028559751437157907478574887586455610818958574"
        "0117180728435510741583686422632774929222632147511918567229325831684032651922903276735266790117843593501601"
        "2515772658634021392622635795100871872629560992833058770828358801605333052744848692059467100573291501861921"
        "2965168501531832990733805673234966033806861779304385144732204173637508580888072780122033030001124800084442"
        "798088493409434384997049557284279503347774175966576788721074109389519435353577136993408203125e-202"},
    {0x1.a060575f96216p-667, chars_format::scientific, 517,
        "2."
        "6560666151344702603270112657977499843280481963854547007415424282841408834245148563080751707062214127712174"
        "6575089241378645724002796193936213328030191138196663527134590072339814022756945163490059566462430178303277"
        "1228244858625675383094839366484676870834540231014217479000886731065845109947279954974574188657815117614123"
        "3386435630286269060704468642455055794196959719254965002131476394999432110093478415169008939749380189172464"
        "419028229169215643606811336644663330285421791733774070365381447800245950929820537567138671875e-201"},
    {0x1.54ecbde19e11fp-666, chars_format::scientific, 517,
        "4."
        "3495214972934750530933724968222678819054125647445515129232273277394298473692482090246833126125365966736388"
        "2354688517832178150409693045033840944581780922681152100231430786789827130799202367673361512373001296052937"
        "0144885754098436449140938587128444015910802676078333389890644004297198057112836294886007788657922515419803"
        "4578833295918606774209296834570437196389294791061023161018923830592981622192484695052880013934282074495956"
        "590306105321231640691595930251310123645268261612767922430489164753453223966062068939208984375e-201"},
    {0x1.9b65bb5e316dbp-665, chars_format::scientific, 517,
        "1."
        "0497223657147530461540305772931267585053715061256250505487087888061029408785894563215220970697678764383480"
        "0325939065916205702309557577375277159458987036426427633182733447713021968370263145361858036928289137615212"
        "7401495504331960559979975536391905723334450553852881134362068216711904999364434749875519041157852477294908"
        "2822453778469194141465743679238160144163995956438907303935779751926152780243481780495784919204856732854249"
        "500399151396209309650004291796200412761177808216423411324935699440175085328519344329833984375e-200"},
    {0x1.9d9f0bdc97dd1p-664, chars_format::scientific, 516,
        "2."
        "1107936672284170528945594825984539537267894560074842735445651564636232548380045553302817073544554452002495"
        "3381174620534078658991556593400119244710172233781404038272600835408871699423495545285788169382119890019819"
        "4201664584882960325446094595491519667713215219785422905110363553929458253876328347995783978350150958928634"
        "4404234645121978246820592353953489916252647358865343115582584946414230154135689901732367690272225496245117"
        "49407430127543500008710404569387590416050499587800361178668850925532751716673374176025390625e-200"},
    {0x1.93eb2c4f59fa4p-663, chars_format::scientific, 513,
        "4."
        "1225583388333102048516138791115797958837443685538615330228158010372085611196534261347478949518515573803887"
        "0427766833577772299895100679885999472136933656647575247856639421484005247092295404547283959255810537283939"
        "1536152805377136989128030010671552377676024122283837285170688576898765577337301783627428040617023286366646"
        "6304756840766048041588267560017035084467460711609718511878343601909600068154087444256240183857041447304877"
        "66761632079166770683820072204968831426390708208735980111470098563586361706256866455078125e-200"},
    {0x1.8700df2babc4fp-662, chars_format::scientific, 514,
        "7."
        "9814802786247251835728077164402394423392733891469600650972933646922261786684070011768202491345213497635405"
        "8363929473900800406081157910353783243643114657359608848833361253991272841241506805336597404984340460111575"
        "6660220570634633816720601395545604136254404189400125104060973148928687734799098012124540258682432908196877"
        "0832041763169112950312043616184359878531487269768561814660148368024122515583353773744932580874663344179382"
        "612758572700658879417422882008015735820127939371092240516958327134489081799983978271484375e-200"},
    {0x1.b201def031dfcp-661, chars_format::scientific, 512,
        "1."
        "7718621999986474927820511105591201858912597837406619766922788131515103038772434517005243859964561302258421"
        "9802754045709795325932881605994542308608831118420588061617714154977002180480859035445177618929493918433782"
        "2591600499156132639399865379537611196535055279648285165951017807905457511484142062562046872721511722442160"
        "1426553623832184397323279116431379887141296247183522062676919582794723562211028612905055854024015629021129"
        "8337387790447592797183168010955799288442025804339585715041494040633551776409149169921875e-199"},
    {0x1.eea8eae3e8e15p-660, chars_format::scientific, 513,
        "4."
        "0389599243158304571394333253525250389507631147978093452054769366480656241867872583554732831311043329402127"
        "3363893780503478092860643094562529070727567425705557388421503723273887240863523056769045564816791339544767"
        "4811798960347663619673711377735935298979851283703861602303938137477503201616025923026704439389500584641456"
        "9114236964868927498070315671368575179598358409648827561251869544093389097568519080961306269611881755257923"
        "57071395194827800525263513822042296462436685865367291814465033894521184265613555908203125e-199"},
    {0x1.390918e84e1b9p-659, chars_format::scientific, 512,
        "5."
        "1119492579282878449920089216681553851133879719260531373201034289194388628158048325602868518451980288065475"
        "3328687915381964890604155102827426856253986507040691348861285321350417983375890401837008594914469552729077"
        "4041634025375852486627406374778113240174679877779001695754357098999719528767000365619537633912001008295810"
        "4111194123452305704581476943981312220929979415555290962822172556120286736561042880277446914041656226018140"
        "0463623856109377838127752113794699265665949440735904563126723587629385292530059814453125e-199"},
    {0x1.349996396a2a7p-658, chars_format::scientific, 512,
        "1."
        "0079029980377603525237940067452489874385429612174195934573594706121935473916862429397131565712352453110768"
        "8142811950276179105213171370309953751158020788719826912383098267593711702326094595805498105681922999726532"
        "4909688432503132216386611947197870773295666668788871748938567859669346354132428937646632915596507684775523"
        "1852907339258584868938933224714470378079481955959311832805716821495059947675108015714103667421409304485555"
        "3792288834043863450758146748423007478214340356358069694664436610764823853969573974609375e-198"},
    {0x1.f935ab4c240e3p-657, chars_format::scientific, 511,
        "3."
        "3000803685506844689972816481749463828043574066484070851351960926134710393016865520510979359197005978741538"
        "5457598964481630013120758369194087749928754243965822423618640689642584934167891050733801943716663854770925"
        "8669749210069487078131864042347118088271846481163803328753828032361946128656564185923045562644481274673168"
        "2442894934517445593122976663972120711272481059100994734541198539955373713891254486701781695330533778123947"
        "552216106532507338730815426432497099038104195443954491651084026671014726161956787109375e-198"},
    {0x1.a6f53d0b3c96bp-656, chars_format::scientific, 510,
        "5."
        "5256081634540492912099873315946178218679701636409896216166339425112476137903833335081550464272182350571563"
        "1649173618325315650797318358082316818623716988646890803244474427212087305270872800356709989796858446518028"
        "0007153929447642907339740642327205632776395602540495277658534898752570556826974137137544575680121747318156"
        "8109294857884968121748814804138707666969927662354233378783086514773899604185508664921655337560966881995309"
        "90443024609879186497798459794215161380336108314093035431824318948201835155487060546875e-198"},
    {0x1.fd60024c9f6cep-655, chars_format::scientific, 509,
        "1."
        "3309156466126676327720798888520711121310973719016756617814609392099367961465512997004022190634798593712344"
        "8090126543369123336008687248835603759825341297324826585552662290670252876445576563127635381521847011482567"
        "7842445245383024757386520155419520590180607348277590132836378469352051761008545687687211422030370707996919"
        "4632854436567543001424200212283006776315002739251470698678414022677441491080589922168267970859024072320361"
        "5400917553291417625497725089895008484400045455087191470511243096552789211273193359375e-197"},
    {0x1.e59d51e4b3404p-654, chars_format::scientific, 507,
        "2."
        "5376664846351879796446894886180118923517375928916788468439012038559075591863943949905482322123331177881875"
        "1175818045667507501033007502798482889114822353165030685871064806380979997518713085247211620359113239321892"
        "0137447365082778750155424105285638558275846595641108095833746918637233220466393816326595449266228517373855"
        "3977212332931292826069615658590284856893342692154277412999385588950569011586612223617034264066429835291956"
        "64034560092739263995560422194101981991352402767692097995677613653242588043212890625e-197"},
    {0x1.8f3d063ff6ff8p-653, chars_format::scientific, 505,
        "4."
        "1725845639630823234884227494718580270580351053715713703971375362827503015835943180643599018229301247410673"
        "4531370235114440276681218585911086934300107994205504714104860990795054228564285081786387946659435399143288"
        "6039995130765713915101684430478057187716062578581352152485071389375497738696764199545096908565956533808131"
        "3066078143179085025594301665865165419361839755147261933143617447462954222697482489653056327589852788118074"
        "865087443355257133659824688533856429351574790498347056200145743787288665771484375e-197"},
    {0x1.8159ef44ecc50p-652, chars_format::scientific, 503,
        "8."
        "0548915652553614245327177394068343716266241601526344429862653871128012696092458059218804885886107480434857"
        "5996679239026442252671328552262873096601408628711791229287582758527981933915133142134968110008715888249271"
        "4360596305961404470471333694306867890527358826950270156557243671697176671195161373933098056018737049190157"
        "9062338058785059859208293885656813869546314004329986095442735468526295545526700031871588905460237269435492"
        "0045505660403734502280634268682688319158924361573781425249762833118438720703125e-197"},
    {0x1.72d55008d0c7cp-651, chars_format::scientific, 505,
        "1."
        "5502849382509784344046037079839787991991438980451926341439221279817304432312682866647314718184756317272284"
        "0418818164653948573900468129228650155998421452040946741052202506711300163335367314534852081645212273850483"
        "4936009445548134585828779634942569389313670043772850997818968097978274270563993945839657893655782681355924"
        "3399450305997531733663209449593963941246859189366865487597377476931307594702606413878721039121116753323533"
        "807929870963298864021730228539197981164725337333010202200966887176036834716796875e-196"},
    {0x1.9201b21128595p-650, chars_format::scientific, 506,
        "3."
        "3612132087463898062764140684189935461768684214886003230114344682573470604125696689595274182067484837098156"
        "7388239748345166372728200991082722447070470950976867382049849321900596490945089196119817194645074654642382"
        "2293731129894706387694427155598543964629550957151612379995382696796015118450028002145601154875875180150576"
        "2629218754188327338915245534983749038112110319832390876772625179935411466060958956629202109968362912633613"
        "2681375017182897009957109717175163086000551360132959644033689983189105987548828125e-196"},
    {0x1.bf95124bfe3cep-649, chars_format::scientific, 504,
        "7."
        "4845511815508472389273098151681950055020091161609473435727151103841950465792552422516369304948060633102603"
        "0748543057238889168858814345038221851332602680360589796942496976998706591507226986479450583156967310376947"
        "1550616591376104244996055290823711542442328688452990316118309517988468414880165494471060878616231312672161"
        "4660037498120830248157761796212768295676112842922578987382164266246048592784044581707325600021518482162211"
        "18106040902173381508385840983168502105714325889351812293170951306819915771484375e-196"},
    {0x1.05319129bc0eep-648, chars_format::scientific, 503,
        "8."
        "7354525906889357430513499319853860181982631924149000392085053971647451377290292578090547222488245265834970"
        "5414899403485023309716361193505231457636757444187175708777555726402719541396118635204985184043477505618747"
        "5847559854756176999196488474136708647066869380958111801978413140177547807244097772736963227119156935670681"
        "3323315849604381739911974325657778568932885367514619084065148363560917676654922798826780533306406883703832"
        "3167938402444969732430229950789418789762474926163804411771707236766815185546875e-196"},
    {0x1.45af476abc232p-647, chars_format::scientific, 503,
        "2."
        "1784629336342830433438401052550444396082133172046876130098970781925971096906924659862775926914085559598218"
        "9400663017394445060955050790938880349417984181161062059937297849164047537024227807102802573693182922323768"
        "4988835519769163005404421634184916315156946538119863486913379372954302859826455909344216690658954228864068"
        "6518489319695139936631205914340242708131038022972028056540459137983053554561488795642242191718171201322878"
        "6261160061353215424961010708322035390495374773678349811234511435031890869140625e-195"},
    {0x1.08742c45210fdp-646, chars_format::scientific, 503,
        "3."
        "5377948750753546389134876678525502149469329636100241627697547777540495032071588666485860794956076980685142"
        "1648973041035651788522826916676596088401130357999256151013354430964513824609480628150120736931652913772699"
        "9982913797176673718855319142272201371103880783459641259655175318625370923447186213384332996959675405576982"
        "1423466528711936764992224608103888079428547551703232208782450602977450285489861691938795324543533418630584"
        "0889333459077886488131187709654153499168327545731926875305362045764923095703125e-195"},
    {0x1.e06706f5cc1f8p-645, chars_format::scientific, 500,
        "1."
        "2853400648125002047663650303839837768770868178827228680425989408577299035277697772519128024365042269006137"
        "5219583393883196975265503479494447072597343928704527629935234980629701495621199539547037556144229442345470"
        "0796064280527920406982515008146955967451695398724643112299643103663775673910972184612760788176258685407613"
        "5642395098320769603757825318678910573482963656312687065092042077801896417210663056529091563705356552511784"
        "8744898314956824515887701286388062303644996831053504138253629207611083984375e-194"},
    {0x1.c3b440515c5ccp-644, chars_format::scientific, 500,
        "2."
        "4171125083478185854577296568973058488028696120773687858171527751677783966413609421158848849895950071414992"
        "7767427664623224802204953078177500746806460413182965492695822167375307505348079714337003905535333983330970"
        "7181502126431081191942010252850595523287033985789669321526444757608927731550951889320987373819142026991025"
        "1567538566070467758974459713102558552732954856343026723690055888710021350990995482922051405478223152042970"
        "3251711643812898068027460606431856653120160416392536717467010021209716796875e-194"},
    {0x1.ec1433b7cbaf0p-643, chars_format::scientific, 497,
        "5."
        "2663240453669009136451576689712462018780864628757726838532298564973456520124312425159168990966344080685284"
        "3720480382087984234515131775332141605827039252921143204800571618187675999431430968489137764119560673111591"
        "6759478685050363495734853368006928166562436836138049592492697802548236478358520529617766739001729760991012"
        "3862634939696554148089055580137656188780075461507170901101717759741393603409206482184290891472920793565653"
        "5253609046038903154631796610265874469813951463947887532413005828857421875e-194"},
    {0x1.8c19569a7d35cp-642, chars_format::scientific, 498,
        "8."
        "4782562742821825187637774072036156880782589649318925320904558902615305403899383502544659296812445003369004"
        "6922729704209086787736189120322426639864121576693397330358676265593198834037152235715817069429196893999010"
        "1011594016395775564940509800763785671916185917507549352955056824078478279323005977928175814655943739879529"
        "1538021924646821332904342665749434907103144778825208546062155400334839930506320175047419033723187526321855"
        "64516811751524813377187526721215880820547994289881899021565914154052734375e-194"},
    {0x1.173cac50c28d1p-641, chars_format::scientific, 500,
        "1."
        "1953794466200874950308910223847802663992105229667520001447180957079004440344103290919539635946785467448663"
        "5101108320842702261329824849337500079159383293237143393259388273511334641497706315723447326003299101241322"
        "1117379942112771102982874993847323660037994013482573676273472522789803757300898880108155726096998947940489"
        "0006031075166624593609122438130204229832717825013013180449460185827436065860119332649187858804645882720105"
        "3492998972995592881612034128274647988565693168538928148336708545684814453125e-193"},
    {0x1.08135c62a0056p-640, chars_format::scientific, 498,
        "2."
        "2609509033348430712795357140935977280309512733698287057990757911935349021821947685234330624308209739910346"
        "7772270922940612799108025398381661528666224493282545567170070803473785763542388437441950076122245663201438"
        "0804220304282042074737823775324236510491104141195362756591323881292372606025430047584104793476982829997116"
        "3833702491013210688436845620875268204319510942541720735041457845466698101522952622178680700662949823493228"
        "83116291501047308902301260328539765642741343754096305929124355316162109375e-193"},
    {0x1.72e01124a3b3ap-639, chars_format::scientific, 497,
        "6."
        "3506864504234787217892916858872910373177620746625376458668035645917888586328943349478973125084439934368395"
        "2454007404739476733674972532888856971140947480305553043580744964130001124409209147401842341895272817350358"
        "2967907318694311580157475110469517637645997431939894575492729066843808617131234673944976587290456837115006"
        "8097358639249101610267432497854886217853527900415351535406568855784166730515150549809118454920495773146011"
        "2041598585348160002997507320447907741556292648965609259903430938720703125e-193"},
    {0x1.e830eea3741c5p-638, chars_format::scientific, 498,
        "1."
        "6719092307496787724810559419625415421265345344982027451035214168134737544212060731999082598951652542812153"
        "0851622757957648957787354945239842973641168921883094179012153842080031968856243689294313054164220779419616"
        "3185205252988408837352595118420621916054112930407241813976472546961527155883577597985057849232945503946152"
        "9700917317130576683212396338930885138139608143780624593505064057096724037453800040558676726388410965108000"
        "85511376306229931840104611302550048634874002573269535787403583526611328125e-192"},
    {0x1.a55edfaa629d8p-637, chars_format::scientific, 494,
        "2."
        "8861375664964044259358368710583120953117948717615414732645978781844725959856063670973732226688698008775290"
        "8855286029832137603479464792748518405725776034634453198114500345112924366610049934881872894137471578343997"
        "2272095705181453677718281937893424772356043639946249738131015138508747363998350555539212469835793234130222"
        "5611134741196263127354006994422412740010583624493733640101270323986057803752221480551347236346238685334139"
        "3126740018852601983569028279257018265724354932899586856365203857421875e-192"},
    {0x1.e4fda41f3dc12p-636, chars_format::scientific, 495,
        "6."
        "6437958622447088767008821269554630170953468199463824514799297420575734289189965271614292158798703423278770"
        "0211670773747181252710225781433614349909082934153740628607832041425472458132448888355030553558474449140267"
        "7532352029048675127730409628858188469012202328932369306696111994192499642393175288938545581909362670265661"
        "4142505131384975210072259285428843744450254240067804540915295982013954480300602499657994651473650515508069"
        "48573291876921601661574797868976827164289034044486470520496368408203125e-192"},
    {0x1.b6c6d5b913315p-635, chars_format::scientific, 496,
        "1."
        "2021435877944512549874307758373463485567732529548696497108946777892373338498825233998851190169288250470729"
        "9837565510492003253409646038667103199192178730894714971640838750321839454360839834009539364164168776033623"
        "4187003338717194709455390020102928159467155523872584982511528028983638984992933752520154204626796100307564"
        "5349437387211946890857172860201104002606422391817193670983149333434914995143903809339065936913317470198921"
        "690228366842475023103730967012105212976535995039739646017551422119140625e-191"},
    {0x1.3d5cdb61d5eabp-634, chars_format::scientific, 495,
        "1."
        "7389964555399592703024922101071638710228058853010454955816287203412674019899135279944202376472905021337258"
        "6258962377260188928899086845828533503606946253121325963450366034526072666759964392438712742370869822534456"
        "3874894747840335256486925055706840475130878149016154785918583949575125805400818453276293215346026410674679"
        "8409452115405004337540444738954378827964445928741978867217483445923848187815353826331562166817109812355851"
        "91326326911503365880101742535317199678246424809913150966167449951171875e-191"},
    {0x1.f66ce3d3a114ep-633, chars_format::scientific, 493,
        "5."
        "5061029114396530055781180408544466257723099083034183419703118907194804421094663580781660676273528898210088"
        "0431574966784461117119754411304894464276186456426615997746028595767878242155456834626624868962582541328173"
        "2698743091955612694553222682503348082494541469600607497030280636718224508777918266791407040625019889179303"
        "6039432538320513687547095452177893522474675770324240828465783630281774188233607627719489884195763554935119"
        "805608804359250562788832806214445181325345402001403272151947021484375e-191"},
    {0x1.172470deb171cp-632, chars_format::scientific, 491,
        "6."
        "1182680642406057145274956363318000274544013834890966296936024088988282930612184978650264904063655374278708"
        "5820049824373260415590233856953389263574865715472704679815904138025683990166563353576868412611739320572220"
        "3061670363833037695225389013764717715215814805406610147515377607379775485559684197286852537353051075869007"
        "5622999002133683147106802833986208071593930453200187676542794020322742581458245280814157780849754554959666"
        "2062989989245184079000110764778863625679150572977960109710693359375e-191"},
    {0x1.cc8acbb3ce387p-631, chars_format::scientific, 493,
        "2."
        "0188412709311976353396884746311782549660027699626134416908249213603286354301183164885857133455556626170175"
        "2986650828364633304418446703878674495167794883307172379160008761496010293765369166879233431965874199769146"
        "1247264270712989910977467696385844786711157938997013783312673882579017433385308124601678176538989823901426"
        "8504426857552292598582757513121935280241619514931840030076728470889198521213809709086287440776710908200405"
        "735357811794408235582388012711863023440628239768557250499725341796875e-190"},
    {0x1.9d46d3757a126p-630, chars_format::scientific, 491,
        "3."
        "6232946244639112367859903422212363335346720737453523731673042531604023172777826136821456024225495282135527"
        "9147249851468071176677140162008005389158117032353189569393774872787748437635734676141743605239899596247807"
        "9173907474651509305526426663536509510071332191959766754013674972380722084744542075898159198263972544323990"
        "9862127078321763680723742293917247854494085650342015232239396059322574446979695006954270328936113654558116"
        "5109048996725791055641976122492220468984669423662126064300537109375e-190"},
    {0x1.5c67ae0e78895p-629, chars_format::scientific, 491,
        "6."
        "1090986836497964518361303425180367723651770315999856077892729499033830962250844499257483134844993286529957"
        "3396737151577326827495417291920603068403409539650431533658243587896155378299195574892619397055020676300748"
        "4081137435305555643552213889591461713709239993638313481580791776559826037819644583208179233694714627479712"
        "4038277978644551890909885049639824861857655631507863094307400842947454757116813778845481873427571851486232"
        "4305325582256049241387124183744194994005738408304750919342041015625e-190"},
    {0x1.2f87783b2188dp-628, chars_format::scientific, 491,
        "1."
        "0644449452139395541202935621152473437563772434876136314750186066160168868665485527429324719400873126529471"
        "1776208189233000924188079381994589329829074340081641242779083161698962978837918189289798934978657684522178"
        "7193869606025896830482212763406278603126524969759522714284262548258216685128420411064588664951016966673939"
        "0845242506290804466119517491841125808875606147358759849354078294511591903760561737780825280148148379041554"
        "6575626016714499472357838456837431095891588483937084674835205078125e-189"},
    {0x1.45f46f0331583p-627, chars_format::scientific, 490,
        "2."
        "2861786222533954646339338691509779541402264763066115611162751161332286389741951997410211952913065640508722"
        "6575869024011507037043987193802942274169970521619512563506532093525808423532637902062603827257377383924857"
        "8834042883646674050483274861201465476232289908450602259119542804457889706508812587002689534404145674260289"
        "8921599918546506922933261671353147226446502233455978523651976194012189261061433226344919763518640419647944"
        "054596842767851933093579096245573367696124478243291378021240234375e-189"},
    {0x1.6faea09dda3f7p-626, chars_format::scientific, 489,
        "5."
        "1576905486221095495936291261435152848936470928518784833293608233493425320242788522830160136503780002845701"
        "6048122210607633734845264378147025848275264231001539119629139628017208552752229789388978000511788179842606"
        "3317970612546358672835740360045451972628457734270690142631590928444025538183708917796524126513769584005208"
        "9566588457104934404172248545830966642830155623590373212577067124362619633973442089846035406156342718763126"
        "22767073101055486120613234601872676421407959423959255218505859375e-189"},
    {0x1.fd11ba94c244fp-625, chars_format::scientific, 489,
        "1."
        "4282019181687436415805061570582957797941162203963167425601499169707767566576137048543241444320531168598156"
        "5115836884276861958472129897937475431167531842729039094949094354884306009515806723673286503437496509105787"
        "3782638327303358403092014499545668583556513012056701640438893215817552078525004382652304169786365593370561"
        "5949165720580529687699459243337232320280125250787257153626075271940536628789995287096375595375273874864083"
        "00778929339319455162830678485175184277977677993476390838623046875e-188"},
    {0x1.c90c420cf0b65p-624, chars_format::scientific, 488,
        "2."
        "5645102658000638077662655089472362542882984305302201347516398173403533180585976534161315640938051666852184"
        "5162493546322932210500567375141201380918228455858352480628723115250797285514387548153230939412238584051887"
        "6678363214204154015141209497251639796833017773424919290240970816054977116200075111851757962310125684874866"
        "5271116317931001749649690210063583111446018923027887259222427377589680137555787871347433236980870707367622"
        "3030545509731425180281923215108719205090892501175403594970703125e-188"},
    {0x1.d391952e49017p-623, chars_format::scientific, 487,
        "5."
        "2470856179554396914220750697206729680930693393806189392472186972317553487714556786098233769482799791950847"
        "6936934598345790216268399728663746626185262113984143990716591357062201655858886386541140904956275446729344"
        "3451534230378626979844440459329023491130157174730485458049630374966675633574693062515331282157551074828734"
        "0588927778646025401932502132098401926185663426957522247203760063557453586246851349782431341310393754891747"
        "355941298035050636481939345667768748171511106193065643310546875e-188"},
    {0x1.e503a112289d7p-622, chars_format::scientific, 487,
        "1."
        "0885720130033327524143787276552924485207749474236947745950934265104724459837447523248118491135661241355555"
        "4232574757514637326804013587665252102597948137223374246525570157421645385185077366595494308247722426388075"
        "3119476116577310064807731317312781001077692695195412670562534730271894253873410722316538605384606174341590"
        "4126374880046187387430900137190727541241598691090538953096044591639726558323746143783829642440266358936970"
        "699956723022336843044975684957620387649512849748134613037109375e-187"},
    {0x1.e034bb81e6223p-621, chars_format::scientific, 486,
        "2."
        "1555608982793881032727700454096876448057956857157050502496261686574263161511608285224246722003343000927303"
        "7170918392497696227267889285573432933779319637407407790610774179847495887678439501670748288585196870929692"
        "2631032851601097932395854292976963625544033998797106811775949503368245505473163357535226402013752099869119"
        "1325549281307961732743070166406501415911305100704902729441738565684824332740737975732433035435605707383320"
        "56586222159526048335574655023805235032341443002223968505859375e-187"},
    {0x1.7b3f7b7659658p-620, chars_format::scientific, 482,
        "3."
        "4047560211390398233126309568152129229163573085233746529962515141769860702660931684182926361748771674041996"
        "7495013736445763182743473510953840736163870669821867413809602871013516774422732969041413817218575179638005"
        "0875945116419344891273141268326046666030950270526350859421486707701849832266291902224529676973277412963424"
        "2022391711546658347775048931980490466521054406862017429528749012178022403631956930652304619750657559521682"
        "3978488395241784846001475983712225570343434810638427734375e-187"},
    {0x1.c3de648e8e3c4p-619, chars_format::scientific, 482,
        "8."
        "1134394501696493643970170895844859050224211984805270797934948972160041994065592646160497525561847540423315"
        "0813807595154285254949233279422425559267946284083567427347887635007556376708519246514086205471778512341436"
        "3518932443771014783422046775533781186699620751308267263855491161152739861928620614332415977705700567596766"
        "4862641318690146376278630164143314536054904863747143635960925293922708102025814503615280997269393301674470"
        "3307415890333677450929616981056824442930519580841064453125e-187"},
    {0x1.5c1fb09f4e5a6p-618, chars_format::scientific, 483,
        "1."
        "2501335652550156692148201907563971897160094599357553635775710000794313839387986491396580421848511127121467"
        "2834212759262118551641268797951714831348473471191972599936690879566720474936486069169882451620075746975670"
        "6186070712175957038367674918959121878800275599658681630037550050069344073450148603507547516824435960857783"
        "8035657183539595621318513297001759908054939222484006322563328047101387846029777029392729213061137991735191"
        "96290497784021327441761339827053234330378472805023193359375e-186"},
    {0x1.96cb5454dbb84p-617, chars_format::scientific, 481,
        "2."
        "9216455145197990881697076029069682383862367622239909838970901266656416619071823783376826565064724501517459"
        "0701539592225503271024718266218547248626039047992425493790137556386884876463021059476422710406079165707647"
        "8035331425667060181110341423930489375804406916453089986931472266944633195682980465023708899952177106470268"
        "2690151782591846080679893335942503991582720417747237342953988826766205275785907263374548647122176495933127"
        "570825962591766385145763962327691842801868915557861328125e-186"},
    {0x1.17e326744eec7p-616, chars_format::scientific, 482,
        "4."
        "0203689191003500137032618357647146694952938707754104131177614885341123472548521527075537816698643711941179"
        "0099119606618891309209407696274360253203429336179171351133531689315057310507797931718347867905142878647295"
        "1295378015371889396345363159252325592648677983269855951990787798154248325992797181678229344332440102948264"
        "6293076484812638568001554150811635968863201084650719977028858419487757190406448299518015352159703896986728"
        "0321388645943753679945498191727892844937741756439208984375e-186"},
    {0x1.8d0730dff1c35p-615, chars_format::scientific, 482,
        "1."
        "1406014918543048611129579046078472017190434076827676333703184492562745517458722933909773128140863811860680"
        "4407235198747673113581675421832304460289731814158715726226721499893358385121455295036409753755696291856376"
        "8098784914446226027812795614298253285437604990024681376542185656441137513607157191982929093989227066316968"
        "3454585239942627682309380956856546873709262441718817170600788510391208708618239903357485935403444561300988"
        "9522537510867503975087178247349584125913679599761962890625e-185"},
    {0x1.84e464adc9bbbp-614, chars_format::scientific, 481,
        "2."
        "2344564074253929881602452952105121463033999896331509753060278603561383062671020092513964622839910827392979"
        "6120725053806395919718505867953302822071585340945473684155811269041734009391899894892884998655950936230307"
        "1669852431153178035825596725766172839564272885227331529420345731439115502642545507672856789487309544230679"
        "8912794588961931961324587403615865918507170866263260790615432342540019426259929855207218540356013049043725"
        "298895767697004814678063411292896489612758159637451171875e-185"},
    {0x1.0f78207ab56b3p-613, chars_format::scientific, 480,
        "3."
        "1195598970627892124787027828771258554467274331378106474180853903784890176470576278085246910031864176926682"
        "3810097575938279721843585234379937227458526717860732051290204395780473433869536107639158198822468448383115"
        "9850946360996498401289488125559457224226066168139585512180838489229070664388435003461492126740239264693377"
        "9324794218572275222475371415195959735820466509414273243741084753632448488495906132266682527804921511867261"
        "44134988124453043700778920310767716728150844573974609375e-185"},
    {0x1.5529ded69b52ep-612, chars_format::scientific, 478,
        "7."
        "8408892826173784349899140483375110468365507426372771215508168337980921036043285415746083661506063036302466"
        "0337267991264308099236262848998613132804398487495251763436683220632776620778652222684238885184627406388017"
        "3229920844992419303692750294188388326470646133479933189911245652940004567736087396799055775383956456338672"
        "3024800062465207795949876534463873259186889135949555497350644501301606934956057533627187656477601229539927"
        "078260013316828025420335279704886488616466522216796875e-185"},
    {0x1.a04e5d2b8832dp-611, chars_format::scientific, 479,
        "1."
        "9135749100368870646470019839026295232772871223966552993833368138787991754425940205303288817218434799653336"
        "0676967652656209466863703861565021219253899628393157406814397593941242505553200228515413826724835127232051"
        "9185851595688434551396579504904836374850383234197454697279713290430878565007147332017477402669464535867351"
        "5775192868362553696596252586924323504526235631150752451721765189140363973209619061479811966865121637316157"
        "9595099193750774857480934088016510941088199615478515625e-184"},
    {0x1.ebf813b0bce87p-610, chars_format::scientific, 478,
        "4."
        "5227279193825361739063351116581608889422003874799378804732418515554268862505634014557098902874036193318621"
        "6690467386983882756961652575255407524524231250012838933730250624835733642161557413446773017614154929610452"
        "4998635489828297481285095734401803451480336950909547116497526559046290615361439294561656735211425759983595"
        "8658796913640401549715379516221334359696133496301930305779915803185229950546802865949446986687845586568652"
        "642876913762791379891581300398684106767177581787109375e-184"},
    {0x1.c8dc05f944175p-609, chars_format::scientific, 477,
        "8."
        "3999229662967713528086187594173418172158294345371367977068288734445756810245726239154122121417804811678553"
        "9260638908340859917786703727950548339528508554698659192678302294445813989552010648988331687084249678986072"
        "5134086126172959651037933921293267583373144983517760442249968121280748656790906595397770655757785243584311"
        "7665011821890292937224415194440719059952578889148712792501100830129843689192652755309251105434679191014804"
        "94498409103999725378031371292308904230594635009765625e-184"},
    {0x1.b3209b1f6e28fp-608, chars_format::scientific, 477,
        "1."
        "6000703209667125522791462448559322479873062933223276333349152772387295549263802853627258955887541875044108"
        "2947080038083309540852416217060880963411880129141024234284664106285251262025261537496173726779635481066239"
        "1399956818327965395732286282182169589674025784504944090995218716248499475156431003783177219541707924492549"
        "8325814926158454470942474826570277646630983287446062760977259012870381602771233702771674396301817368407594"
        "07891672679545569391024173455662094056606292724609375e-183"},
    {0x1.5eb78be3e1518p-607, chars_format::scientific, 473,
        "2."
        "5793451325824551491141095667675624912529344342712005389262969789586908298595671025931892803478199322507986"
        "8523010849281646737274885718408262502576874120606976940116290679237340341259636981155466151665848618173232"
        "4032607948080657805132919680722936044837224175094957632003247401297641357721425657261766165473818699028835"
        "9825505903137699079686289257017072435439734264967279514362822953866073386940049227380450195986556441556177"
        "8167473687417565741952785174362361431121826171875e-183"},
    {0x1.8c46fec031da2p-606, chars_format::scientific, 474,
        "5."
        "8288366507307604041374269061151039091481400225143596125768084467228171073647588417776611518319759684136669"
        "5557291353852212593508193848018264294866764758668148761093094182833021715126098317988401041652929218002060"
        "2358184934865157857832670838256679385610036129043203830159719538870546915932165957386758340306712837687657"
        "4139690927957720219748627972540410054088613214587368073136947535541347600289632712236225552316903946201217"
        "43439748913939713048648627591319382190704345703125e-183"},
    {0x1.86231c6dfd804p-605, chars_format::scientific, 473,
        "1."
        "1477041919553151503755311242286463359086338700939173534433881149141551312845676541528433370751398526129520"
        "5360200123442369544861627337651189410728311021716825316418209072205209059768027017097741944446106051476144"
        "9260586341856618907842200283371765359783819221589931961870907795236477229042736793261103112697240517930987"
        "1772095882680155257799467917171661002569274579372573148249479204708825803923891308204782759202811211858909"
        "4147011638036293135201049153693020343780517578125e-182"},
    {0x1.6f91c9cea3db8p-604, chars_format::scientific, 471,
        "2."
        "1626294070138318712021828339014812165466875626132428688506066130661223800325245624218990344615529115525670"
        "7498826015032971421773458480080315944694557039046086653470574190248564560937128913048158665762605822060055"
        "4638663222463820196556288005293509078032902091923457112717105630806377089745970685933260769211709292606271"
        "3883265602154051291339880146519818852439242793594288516683321266294987653057491978352698407891148399388724"
        "79857372155276351577413151971995830535888671875e-182"},
    {0x1.2c556f28eff41p-603, chars_format::scientific, 473,
        "3."
        "5340830852507131965886973628844009684695670072958139623317371787746358871058121738979142765604242918427270"
        "6832415724931842814426120166478731717470396051187190782581219012149682498960891262131383887862540827723812"
        "7643023274199348054497036263959980391539791048593977360916969031572048106601825361653601806771067623066557"
        "4051011657281000462617858827996936464081367646380909919085410798272389504087757458521098222151497599140581"
        "7346111169208189295432021026499569416046142578125e-182"},
    {0x1.e2ce238120917p-602, chars_format::scientific, 473,
        "1."
        "1362518681203582246140939809705922332332975015608228604463964843232561988310452537437790568021290911866235"
        "0839847885927093395163376953078064940732037455207673242572744714448661683497842412332824043550192279636628"
        "0503312783365917365174312756198857236845666628455487179177649489943944605272828958999095810535518041549318"
        "9818268179755941618181564000540778433874330833462914620292376177100970824204171827936477371939329301106083"
        "3410329727610754702027406892739236354827880859375e-181"},
    {0x1.24196dd650362p-601, chars_format::scientific, 471,
        "1."
        "3748749674401770954459165335871081766876292885886953638318405208098300543963268873795361532633351527309260"
        "5183293467910096607640374531111183083050881483551578535590574862217605392658691254251016040206211732176264"
        "9513738716450171265643756029288065693302635054394259859478975337052256681676444287259784856070495950346420"
        "0147147833503265827822922002568340246087493652923517964388001136742818825550149740093584171030834883177820"
        "79866403999179880202063941396772861480712890625e-181"},
    {0x1.02bbba1fa294dp-600, chars_format::scientific, 471,
        "2."
        "4356505490995989137168281913610731830019560936055966573555888682095611638946741848058176225505118866181664"
        "6626267444282690413817201444989379537984347462429716702593341950876461070954522685954552542326714837267824"
        "5393625964579526328349325430932794835417522958299065595103892073242338952253770707833051812460982697751239"
        "1397642546757797290343067143148163681852061908086271106945153788678767070284176602262881688759899668002859"
        "52308775805352780707835336215794086456298828125e-181"},
    {0x1.7727a07c4162fp-599, chars_format::scientific, 470,
        "7."
        "0632264615999984553004824523934828389746815912663087276342193164535550939884152883670041383967458297749541"
        "1936486820912787231863213987513973227977769787492778564103481765224649564842940083968386889634962937410157"
        "3069328602934415866941417964147777899133182591019874029905970963950870131654961921749867946840387912428480"
        "4538594740895098332413481316117502058978520795751015258819941676721527211850355917929781785411532757190855"
        "2225891930742562863088096491992473602294921875e-181"},
    {0x1.8f0824209bbd1p-598, chars_format::scientific, 470,
        "1."
        "5025541635379650323807804926251313131836557909893686530962020768745327962627687341360811479854106994068553"
        "4263173419339530468602130784596336253828333239650646771645717369473848852911124115928811400443967809140245"
        "9813215515621469873636992676768817063884474168442971019069351420018247479917638346466764078010317901152627"
        "3081216374180988281024361584175357121212766604713032037039974454629576819451922761645310017488437158483350"
        "9687996466741566337077529169619083404541015625e-180"},
    {0x1.38fd6bcbd252ep-597, chars_format::scientific, 468,
        "2."
        "3571270014353365322336931950633836856113223159844998673765836415920035201232388224807330916269590271324890"
        "4334731033242228233263401451666324072513909789496747974372655367892497264045352322984236122954019123722538"
        "9295828403612962912512216580766983652588284187430913252738151214604768290342680303710604633254838264665098"
        "9962035785843582809055612178144212382821531464078007017087908041952151860790529094170570698810065899235103"
        "91969274646584153742878697812557220458984375e-180"},
    {0x1.c012c11b55edep-596, chars_format::scientific, 467,
        "6."
        "7488790504233201532404821012783315024399985087878933914326993678810118949573654609919916051799477574590605"
        "2555587820395782532203892095091092520933306954962049724050297871723120684162663655400693709284384679579844"
        "4229626121510547440413205330956979446376661290569033353380029097827152899554534893469580751628492269227510"
        "2307945654300221853112443217811972597390157707545064145290234402918947143290826226229722152773665129123377"
        "6865652327359157425235025584697723388671875e-180"},
    {0x1.1aba0d7a89944p-595, chars_format::scientific, 465,
        "8."
        "5168606875567321498727662037372810859520433921783123995459117425504744477611215726819499227583845539616812"
        "5239580447740616724353434082982514047154634288153751058253832016000933674669111863819139788156587916539153"
        "3715294248439635842170170518537437533149976925664023652905320015380511107595544259672890160470678028598596"
        "9007664706297339134454910441203849873467808766000671452678283228867172077673641166000719771578738611874552"
        "84682545908481188234873116016387939453125e-180"},
    {0x1.fb338c7268b50p-594, chars_format::scientific, 463,
        "3."
        "0557865935212958394376086957173324154082751196112498539965546191859384115363199888292606660746361125668283"
        "3404840375713838316990182046660217446344946472933812140353250354288117258476863349697332813418892391221042"
        "5909219328122261566214838211818211400416693170662727113985478183823335721980028025030361593055215041959837"
        "1905219233320642590550021466201626391931891093110222234205139677685160791537656843706503862113584384899329"
        "926543742885769461281597614288330078125e-179"},
    {0x1.51b04971b0adbp-593, chars_format::scientific, 466,
        "4."
        "0690125758357819313890653104659603597467313761268844991087784245249784829428847210475329294275518716491653"
        "4121363796664234945241951639537426384878238066930222719005716702736354770121804434103616468073547678393421"
        "3866666956214335399982637848595661597381697776886918409632666455919979846021303241798302378411367222817251"
        "8260900155291238599964614405125995189283239303437292544747420798857552235240907507102919238856499693549029"
        "737782429805292849778197705745697021484375e-179"},
    {0x1.a8ca233514955p-592, chars_format::scientific, 466,
        "1."
        "0237088948578388358098853060992576583367816569954351981673902681175827710357388491891184587825924676377634"
        "0849697422669866470721371511852998301084735245899689191518783967305093246868883270208809502585863440586583"
        "8719400606468608999474499247944762751706090711502562362059161157946679758864812671596322877059632473937360"
        "9857690212696944678148132075078524683281354026644263575846458787445324344890837847883377169654004993848352"
        "318697170204586655017919838428497314453125e-178"},
    {0x1.402ec07779db3p-591, chars_format::scientific, 465,
        "1."
        "5432289335652199429529596192176095228012899535553233590378023000243990210617168196490459969107617309775975"
        "9271595161852061445606846570553485751629922977685294026681803756969797432088015163086656410384375134034845"
        "6654787834477195943853030778904275812187520216131508463375328855191606753215808123343539126680637528150749"
        "5586400182624672163254831082909010625241829629378479391253695739321009052894816650751602501038193173413725"
        "84218017749435603036545217037200927734375e-178"},
    {0x1.f0aeec50d31b6p-590, chars_format::scientific, 463,
        "4."
        "7878677416379371549125789239926548827527615154124045791534979434488720324473118535175349175451116574955482"
        "9196846477560962493984753090692845809166165686038186185598545516804955486444807934972963947481576822992280"
        "1413673914161293747159398543359951739982313316116576662886014320825440802061395606568618051069946931111084"
        "3403784158309126949658184006386667169743740687424550046011927504256647287974642036460883111432322478315769"
        "254120226605664356611669063568115234375e-178"},
    {0x1.57d294d3c2f9cp-589, chars_format::scientific, 461,
        "6."
        "6286789908919767154439712855163324165485647125775879469082523552535784443231882065986199405578268409671614"
        "1775524355094157699459438893136009843313395926452650072279802208152136503116316085826330120645706047536069"
        "0707532743601948118549864883622173092720567735244279208420288624269214419901245909769732036473350606372685"
        "5287774209801534211907607596434562429271112638134066194967154756089303850511085273262727747824243635776236"
        "8270840624973061494529247283935546875e-178"},
    {0x1.ae73fe6587cecp-588, chars_format::scientific, 461,
        "1."
        "6597719647556534585125909210073988053664761497437503116043924519032075968467392138434096782371133771691041"
        "4692966359530302893843702342909948977224093225788840850241158526002495811490793284029994355447936207717953"
        "1701030202592523890664293391660227483252564706908710533792330581122217799978898141257599150318157143299562"
        "6438491757766678273670461681099223694022755564691644672587301285547650231438839095722621873493583105878962"
        "3693172643470461480319499969482421875e-177"},
    {0x1.fb67296e3acc2p-587, chars_format::scientific, 461,
        "3."
        "9129616361835474995816830113427371139394783748006906776846465564831734796400082279893725348246088077820873"
        "3724773721727647969237518001871833488349905404751288122720075258042368323832359271430311964401334649219933"
        "9519425305966013506257262632784489759265561057060941101640097783767987620799907927064604185859394447002994"
        "9081905073803555079273434996212221006831413351082560112476320410824712380110268981480781210164473159999337"
        "6480739470935077406466007232666015625e-177"},
    {0x1.3ed3dd4d0600ap-586, chars_format::scientific, 460,
        "4."
        "9174333185201845885701643304817719285286793119402385343997121743834215253289182597526179950619953400075056"
        "8215327569860654293571277325952168912585808066003526425979416007658121367350545330904392662818296290555095"
        "8363362875972718209741260985284999305425043970836369172025830193280142465849744222930368949184112590984937"
        "2570588281489240090240019398068143537541563361531771384907078697949056986176353435518052413541351141658408"
        "696599735776544548571109771728515625e-177"},
    {0x1.c7fc47e8e35d3p-585, chars_format::scientific, 461,
        "1."
        "4065772131663601624731605132771376030687013595023265826246899604517310916218342653982498273578257694903797"
        "8468638033545923123797757358334963538697635759700073763508738768671726201090282961141287767540599357579432"
        "6842542570723744576605062186938060430296209980469258502851293064721411956550060490555280947897869268535238"
        "6179746516768341436744109032500119725007587257232992073560146104583620982534044853267658149002760617409663"
        "0464731561005464754998683929443359375e-176"},
    {0x1.e55c37b92c6adp-584, chars_format::scientific, 460,
        "2."
        "9943788764426966743964594522375614351628056540175421741903002166035225397433156307925002196026795564333321"
        "8608007322600239902857674736096887285429346165120286356617612333602815378437074971902704269699125569824971"
        "8734965454790960376519785799921911505099839114997820088040932021308668960743662393965366462481244219250884"
        "9572198239276132947860029194547765807895534142629802891987129320208281337887778316462208527447689848828560"
        "332805182042648084461688995361328125e-176"},
    {0x1.d5f79f14558d4p-583, chars_format::scientific, 457,
        "5."
        "7988273284859469245975909244211226235064534468838026322900953010973310895710460351625303496060697525894981"
        "7548467994482334725806573119794681098598188149502821244093362724432709697646779140442854709952519834481575"
        "3552685473794970090692535724337831399571800371346050428402437303389817593443709839557440032105433568682862"
        "4757675607836065407289464361427118285829539423788560868340267151754097473537655899023331355796062082375019"
        "741675714612938463687896728515625e-176"},
    {0x1.02af8b4a8eee0p-582, chars_format::scientific, 453,
        "6."
        "3837373791831109164464429226879340089313583401475598285331493581326429673206288607877477935245231280837188"
        "5647870091324083042948466168427797571451303935851646140779239476004716342445942378983444119379324329844134"
        "6151467615682475506740110029481560213541664875596554901104780563157049593014023988690619684414077863454296"
        "7876711134989798226852771797948262135736554301036508910870959205653707241544181380479035784912197892815299"
        "83782093040645122528076171875e-176"},
    {0x1.590863ea685f4p-581, chars_format::scientific, 456,
        "1."
        "7029147394060241225903488954267271489892327386935164464069609449685702563324256490556157119037765012843166"
        "7310922276302573508422178617217778935442879125612302277325623482105142657441536641590746592972611280474769"
        "3325030138100672596616353372172516265836210204580350417097583162091337255177727535194710323672332335205952"
        "4514418255814217675702145734323793974251426625781831584646489266954982049226992568944037760889998259217215"
        "09303097263909876346588134765625e-175"},
    {0x1.88afc27ace629p-580, chars_format::scientific, 457,
        "3."
        "8762215209996964796089923759037167832249242753682372854337872650601972808271639583174726700107777427008492"
        "5501806670174866216009677450964270651295366445299067761270362555402692011724280700725138145693269599925464"
        "9548206525351444569181879737766662552654721137751514033505841091039998863734933754460921996873791362418981"
        "3877322683660487034814611363469602337211596081779924811843071508227249052874980749704115988758129120184126"
        "037429450661875307559967041015625e-175"},
    {0x1.5c7176f603643p-579, chars_format::scientific, 456,
        "6."
        "8789882161917508509670824126173614140304474268001492195639974058156288616291688554218622136287337053108089"
        "3419613781966113824431849672860148904218174388005163947601938431582715382608955397928680356858042289516561"
        "8106610762680714571764269279291838992388844607635676991533109853040114513708619359429236357658230665495532"
        "0578191159151869528057193739314193893582637371956923500775255998034385509158645247066496985387717630344717"
        "17901396914385259151458740234375e-175"},
    {0x1.790d4472e6dbap-578, chars_format::scientific, 455,
        "1."
        "4887562197711446908978121836254756656593526509585899499756689436794712354563618715575348874663612719205860"
        "8812204683915199610533975015269320265559281666130669232952306547433129957755583211217665345578272425010678"
        "2491820289781945266397473512670935662579443028260948228067153672789706239267967937964617523411091552992446"
        "9346136169054560512819064301157801030140723999008663632807032826898858941509657991405075602774164128527800"
        "6989756249822676181793212890625e-174"},
    {0x1.c378249bfd0e6p-577, chars_format::scientific, 454,
        "3."
        "5651743098904664145382811359911180260058861554103089185268982152317863809687513381561548742845716244486591"
        "3339519437222363016273356520765126496768749718777737323105845875880161315828096125505939574746537095716796"
        "8204318690266014998655565144550272896236561789845289241609388463168613747026527843760982680001585378259619"
        "8640242466945887021327694298597975835869968250249240285430911246574479070674348728464172280055825836608818"
        "235617945902049541473388671875e-174"},
    {0x1.012a9572308e5p-576, chars_format::scientific, 454,
        "4."
        "0615954239203778285980217159357064260763320100626199584318312723187831388742625072953964794756680641316452"
        "5187049730893926840073392280738696074481503657716473125301415875810091183435586269507991482810462712565678"
        "0885586781210885206452316190347498731570541051286629973013412217129841564336368659136736331103393064703397"
        "9450485811165942478075559148657607681083750037261710068110348985087259076445035649476524760030822502887559"
        "721784782595932483673095703125e-174"},
    {0x1.56195178ec146p-575, chars_format::scientific, 453,
        "1."
        "0805981132105149879888828194236853539061686084662780914854471675383228243117452879571122473537783026978971"
        "8424874479211805105139792453651861428584866033364818684675278744191346541679918674777914698058883725209587"
        "0918149265106456137485286704653323044943850364593356260109867034399495400691418744678903519925194377801076"
        "2381486731478479183022737197451235240098008967031811463223159118911278393762876998825339197552938830249047"
        "44161176495254039764404296875e-173"},
    {0x1.9d2601c0463a5p-574, chars_format::scientific, 453,
        "2."
        "6100490335909980979552265558355493219704695290513080366093465835681490016799462387973765729881171426828168"
        "2417332590133992921463694477503388807139807845292305705181442388256835168226672308962563672964438490805297"
        "3384732142938193798164642599720638713195222674660177386067424332816501896648413308447588486597263343965697"
        "5571046238161474247493645115957000348819974290112611670238924589617136104709839809219214750270546265831228"
        "53844542987644672393798828125e-173"},
    {0x1.b1a83e573f7bbp-573, chars_format::scientific, 452,
        "5."
        "4792243323914630975072406281613606832261951011145665036504979668985390735600110157767758785050009028843723"
        "3069196872688278263180607019226460569942714717248153474281746765628088520324003473535650431537768304962822"
        "6352434526342626991833896405159190457009628685312050850428276694131688178962296877209863921698707625891704"
        "8767076718398953420167969591438265381595345439024715691196807395095536129593152744587067381250994335672999"
        "1137399338185787200927734375e-173"},
    {0x1.9db5b347aea9fp-572, chars_format::scientific, 452,
        "1."
        "0454380162673489713965397325213210055216387987310910537716239241543349829428624537085690812460149858173021"
        "5858895362945461402133653079036345203985491835929817281954592025413065471497974913996205317355421037620462"
        "5461005863476843387305393280877162550277919224926407850550461402739010315434561658615507741623588071536234"
        "7189767875031969711231284078903547104466269425076082101727424913763945754500035848790708990687509105654839"
        "9137682281434535980224609375e-172"},
    {0x1.3df2e64e62b17p-571, chars_format::scientific, 451,
        "1."
        "6069032799845684304837025898602516055352533047665360898514249707918755589705310767056414015917650944256637"
        "2059407021909524012789333201080366212249374842632041801829250909350915204889376556367323396385595859359363"
        "2026744656404079205066647203536888565373193524222234484027163667384520159643669604080393032721274484448190"
        "1820454994441082559588679931543647630524022363479603462003303851739929994528409740117298461041517310121662"
        "376332096755504608154296875e-172"},
    {0x1.3fb9aff5a09b6p-570, chars_format::scientific, 449,
        "3."
        "2317634556278561328898229389131235973792702732562633280991403487915739132162432712906493266003295399869372"
        "9842545240820838063867420776343008017269498231628387206082119219270972996042897891079135898914037979639792"
        "2628678340369132274813716042402578734967764593771810395739266217871863837169342502454420046781060151049163"
        "8476195268941251133713791394315017124881357339068944310325585037652194459172678551852687153095322614149154"
        "1056893765926361083984375e-172"},
    {0x1.b756a80b08275p-569, chars_format::scientific, 449,
        "8."
        "8816113793007975094594031352311578123949416737178828130854708415442420035465070777620177348898079141507841"
        "7796406238021557467994937388956410627563305885106754023883545285183176270892863135364360578393441082982527"
        "6089987266954588114848541270166660775652880062869381533707804994144812325315805417332298566443583361231344"
        "6487476518149284318543738637159669254492391164491862892635863291851603301999049071455106466738138593086659"
        "9665023386478424072265625e-172"},
    {0x1.f7329a0afd825p-568, chars_format::scientific, 449,
        "2."
        "0345160158699940505892624292575175803854303259223972778922037104994094712540208045167546542096546399329092"
        "5568741352851754686883111360672231989108344218909911608003767338157437940100332128954412292965650257298986"
        "2399508197162346096661909599065879618173136942841150302867570196096215393226563365157688113883373826699019"
        "0133804036385605415722207224450777798150430412030970963249225767509927828485208128706060882323614080746665"
        "4223389923572540283203125e-171"},
    {0x1.0dbb0dd4c3dc6p-567, chars_format::scientific, 447,
        "2."
        "1811364732319512379299888562598205651832586862578556577373471722160887631668486562918227829168345226693356"
        "4477152396005065372978045785609586439600163180898405459353425875008497418764842761473430968015877893142753"
        "7144073637743030489800810787461796351034399996774268268113982329617709594542586517687546529900207424315352"
        "9571645636159086028928066553000090306544475559951765315539204235148847117034688163479628705831991908326017"
        "43750274181365966796875e-171"},
    {0x1.f37273553a82fp-566, chars_format::scientific, 447,
        "8."
        "0774068916080526911822864255084323152268934947928782821744873097715265550575551375438531877561394581122040"
        "9981387823919747733730008958851185059841992813660027980133828742374911473631504963198955136372118833915445"
        "9270356424436854717354034107500870354542325791569854174511255863352105517142777144763847882237666874762494"
        "6628127548310914850138612320071626178258920473997347412686438015422955451063231513707035488791596833380026"
        "50998532772064208984375e-171"},
    {0x1.948f132293c63p-565, chars_format::scientific, 447,
        "1."
        "3085617726519541939747154125479359905912083343808525334106458195989110396773558319983334774985646548651422"
        "4001778904513903298081176394305764399493112846351303350353239502484610555690434248628579595201736161689146"
        "6336607580363322588353007728783819901789415921638100352602461638880220153348552331791239223807821536185010"
        "2983913584124516775569012523471486144188013970774833418807493808520624064940293843848631225035283875968161"
        "73754632472991943359375e-170"},
    {0x1.1ce9174ee8dd1p-564, chars_format::scientific, 446,
        "1."
        "8431087174635782043252618133185158278565571369229321208308841340213027211857844123697256040862519901567725"
        "1326726395183648543716289037081590754301619279792859862700397570904034465465726650754241810398171714853256"
        "1992992808930081880678923005030883215333996109506247186677474230868515683431825040191371852399000466202113"
        "7975049434489578580438315462876494403387379133295692106882124354166769411650396731530785615627010542993957"
        "6424658298492431640625e-170"},
    {0x1.3f6d7ec03ac34p-563, chars_format::scientific, 443,
        "4."
        "1328064925321326743823603312867683387167979700016372758868184808065548286026722508349641027855711185659446"
        "2152961711974203123360596743084083781406915821893135130157239833260145924419520141522508884955957878888182"
        "0404459798243483214581582816502707353740530994471599110522744654340322094456670675212886409515158274968834"
        "8421670736899255799425452401539295289292709073381110625359305055039988110166265680798375337090533321315888"
        "3154392242431640625e-170"},
    {0x1.d271d5b8d56dap-562, chars_format::scientific, 444,
        "1."
        "2069870317233675409785921174121444821305867547484647026031802481804471906324306712077013729055445084455143"
        "3999115380573910887578371341979222946847987949711339523886024386272732747418877700383850969235187003203291"
        "0037612444082501641811469305197024541046308746885012559865055123703620520256489024970530609600773121721925"
        "2509953590142701977279265426554214972769816776184129905490996033298708068601791479909982052198813562426948"
        "91989231109619140625e-169"},
    {0x1.e5620509d2608p-561, chars_format::scientific, 441,
        "2."
        "5119843525307733558434594260816051677090309667396793035381864422174122683981429619725915214786050355950948"
        "6239204789313430961464462590490736435598083042927274138263378247661251164296052912696897186466478706288935"
        "2642748759037672326378535772807239429456532155654974325325269095690646913354309930487294342711006492165995"
        "5315549232098416962449358057714977677229240849969698671418318066142700050605778916770760567089837422827258"
        "70609283447265625e-169"},
    {0x1.daaeb48f4721dp-560, chars_format::scientific, 443,
        "4."
        "9132134419173275300225535204544729851911649970165869483463440887839418340380665622292163306488996250106549"
        "1350976425275433250304984863280428171634552315241314266603032484551607070114757965733712324125396174103372"
        "9226789364662827961018036133320427313617289178588424239333846712216532419601164460554698110560287829079138"
        "8448732419818004683184996584630381592680288467103992938091395362608822911344140526874318952721409914374817"
        "1627521514892578125e-169"},
    {0x1.79db46c531467p-559, chars_format::scientific, 442,
        "7."
        "8220288221977700063059894664378227368411242897337007442348771025734261062567460361432757911617862838819629"
        "3795797162626830091814571929935183642335516230967612876521043115431354642305807169176548620989324925775808"
        "7062177758498404099890663358857738381451506168661384596087031927979812839991222673925208238906810303540299"
        "2951541364381739672960888215163802051676603836709312773313559283595797003584392382939671772845713348942808"
        "806896209716796875e-169"},
    {0x1.5eec2ba1c3720p-558, chars_format::scientific, 437,
        "1."
        "4528932941845978123954041823161320670444209002673199194875936774636685005800572366209642420084980102688522"
        "2284771627441317362560849791307952496665289476714272091976068922300999847479343600358850073272097152220030"
        "2906669435860845485433716289821162240358438688669844790169613107356205858019787842075248471375056422020616"
        "5606463372742572760669498115895300190252052394461218022126572921109385011864418429938794474765018094331026"
        "0772705078125e-168"},
    {0x1.0484bafd678aap-557, chars_format::scientific, 440,
        "2."
        "1572028357831314739248769724465999741271766633293079884733473069385467128577256574275705244906939184117582"
        "9038386984094283473151970125795043177080588238644040574776169825974122573988755713447254935101455602327279"
        "7444385837941145779765796154296050920630528440861628624187628402654542146737760578131033795692117902664174"
        "7620343404617522327136474787371783786459139769882545368567133405075767410255971768401339616616496641654521"
        "2268829345703125e-168"},
    {0x1.6d5d28581864ep-556, chars_format::scientific, 439,
        "6."
        "0507342105712640753626842163097646809308860776311719574201719128177872342977742833188684816835118633113178"
        "7469902672162020402460054333735597377259788893050409419567542473760275232535702628013402757453555954460066"
        "7351435740725219890174284399124917029076743181228148661697596212430136719929459778243961595404978812094624"
        "5720008957977972786818679608200766196761709853673787110020335195594341069592956953993034829863972845487296"
        "581268310546875e-168"},
    {0x1.bb2a34ea37314p-555, chars_format::scientific, 438,
        "1."
        "4678367854256142298667827818101418425641171158235873201689619347389131481467218178604900546424188785128526"
        "8336878307696570650647319626714281180108177890970382493324330201954352563963102778896234442647145321597454"
        "4934864973158225723162874678222498197027137108636727761413525838697942842193364203301906166874401738418313"
        "2646072919751818499258993671664303007808184992375802139546683974996661430648331805870476785003120312467217"
        "44537353515625e-167"},
    {0x1.dda66275c3391p-554, chars_format::scientific, 439,
        "3."
        "1641143055571888721675810050989542109785465028434827969598434513594568939907735780944113164818353072371269"
        "1472274425932244055295948253650409847772105060655087817291808653621495733409941136183312201214290111148995"
        "8367027559058113415177240496976939184069245076394699362838845068654932477476209593443045636001585391168764"
        "0813772856068351759540302693121233132284473037020618452899137221945934076678210757072040593129713670350611"
        "209869384765625e-167"},
    {0x1.ae53c827abeabp-553, chars_format::scientific, 438,
        "5."
        "7012659962131172748331801135657757849545869452984033576198099915159574664118824194511400497947243457984780"
        "5462116330084017885988449660823105199629138988659606033366015659128259656868559311576294716708666983658509"
        "1151417828734600815851793300182954790630057074667385636416663954055631149802259850642458557110755505661731"
        "8968904489469062159847604242814589351698444276015868870497315679527347144186144242694602723986463388428092"
        "00286865234375e-167"},
    {0x1.8a5ef719cc23ep-552, chars_format::scientific, 437,
        "1."
        "0449784962477287548783251955237842370155156614682633486401981005538590595074075877132082832649026253806374"
        "5178776147247109081094734941639330363553681011985727972623039202822527299326384345045236499496566530651968"
        "8594839664257358745546726073837195205368734856443137664431116736502834299388928251796513021111914290343565"
        "8352635759488131161489780485873740697437859266638088959535098381735367626006998759136124022006697487086057"
        "6629638671875e-166"},
    {0x1.0a8013bce024dp-551, chars_format::scientific, 437,
        "1."
        "4123103050632778867079410198580307726871240292054106836891157576370049073328446726336757729842328297539268"
        "7130135769634683967418176373335886121724564479293530828467869228845230209513050262924753268824301017453219"
        "4011901728294090601781190078090265727142204298288503540121641833715510263559360460931322723029926320336771"
        "7097431398505056111687252861128855861691714189014884325150929764686547454902946358012982841501070652157068"
        "2525634765625e-166"},
    {0x1.1c9bc398428f5p-550, chars_format::scientific, 436,
        "3."
        "0165478216464074512212005380921449232249896009416388345909558008845922680766679989900406888605168527800772"
        "9156847515877911950031988284153897746333486898789272568844785705133463127705015634359057096161632900627980"
        "5162991598947429131105988549014486141475892089870149610321000309897505488330122362804139249717716232071224"
        "3561484642920486418632362138024921480131995555150640263619194765536340598175053806517809107390348799526691"
        "436767578125e-166"},
    {0x1.472b04c33821dp-549, chars_format::scientific, 435,
        "6."
        "9352686559745381219629204415882645570340784420147777997532775506263318841002038546151778930213422949524749"
        "7247338585103033841186687904998992673315180478385844272679998694228379216159690401411169743129037832534724"
        "3997549961343698246262935026970483997121083598418491471419947499240108314702249560972217943633149438923305"
        "3529333671768056532410769536588940137956502217616423212346252026017570923308377950355918528657639399170875"
        "54931640625e-166"},
    {0x1.6e2aadc8fb08ep-548, chars_format::scientific, 434,
        "1."
        "5523915631659218211654033359396501132440764681876474497751136639122155364971012804370210703738009265241858"
        "1215759342693384516281140289868088753255070953848917975089495962398728196671418875605246865007097905910819"
        "9194200320736265532747460554648315694463585924985028588151664651715814237876462229975810345451375987064856"
        "1867718950564534290667687163868632147450459471857685230728295838544660435309036072837329811591189354658126"
        "8310546875e-165"},
    {0x1.79e0dd8d6d77bp-547, chars_format::scientific, 434,
        "3."
        "2040881224406470104070105421447199363651981713125257613338523327774736749929132144470271088534670292970793"
        "9332666973487821118966580744192703719425525128891426882244292259084076067532193285611697408370057076213402"
        "0817519404294049135074882815764210025817010708368161243484161145536272444835580693740277441857916573303193"
        "6560847200506946165778530591600551545348474288707176758359411167341011404587763911067099797946866601705551"
        "1474609375e-165"},
    {0x1.50a1c6dcbee64p-546, chars_format::scientific, 431,
        "5."
        "7087065996614392467041253154630145625242817661293175265664196357354858848843609759764525139516246750819154"
        "6800113857365848905498771900411790329918307580100153169495954152713830350478046241412786653023542349115414"
        "6722690420836671854852719370789115313287766786109595137579201772327062305581861872141887474541157775863540"
        "8998524829801519942291352361441050850385032916477495024457844951280632243145740645218211284372955560684204"
        "1015625e-165"},
    {0x1.862c46595aae8p-545, chars_format::scientific, 430,
        "1."
        "3233342513427446533220846176980084180352307495935298772563684034576138699777035986613426588992064096929624"
        "4845573413990218913068901383100060791443228776423588462888697503055590150915018973328299846328628471661195"
        "1393315603019845988865964947204500622134618088187057959743436057427473338804629924458598854986541360321208"
        "3717503132967830519046643299291922805519127421662183480103792153741442023939800520793141913600265979766845"
        "703125e-164"},
    {0x1.abecaaaada1d4p-544, chars_format::scientific, 430,
        "2."
        "9027492682223769245463501295368700005473044084194294943260531463212751655391460399814755446587701909041474"
        "9357432786031241406072562727822572506649901334086394861768322314208033554135758133295052719658033386416436"
        "6820140576973418864131397514691999982985832569462960667909084778059718781902132556507382819564321302015716"
        "3424326728187578875387306118496551002665440241638148086882173459801728850060431597057686303742229938507080"
        "078125e-164"},
    {0x1.27363043a03aep-543, chars_format::scientific, 430,
        "4."
        "0050313185332246980379480793530275790838034216130234269239697945665097491937671792280674809190792923657176"
        "8852195478275993329637976842756444979578128393305680093053021087734539543173563658797050864465135277447744"
        "1606453018747691217753280777119448590588588328443857685929471452269672993927502101792232928640358924482952"
        "3991254114083701145132411140665518759135223474616940250607472942846200812672119440094320452772080898284912"
        "109375e-164"},
    {0x1.f9396910dcb42p-542, chars_format::scientific, 430,
        "1."
        "3708394080755749882353739878794548975711060319922576116897896423058078740860088250207940293013167382216341"
        "9006732222086034323894484084689341216849641479224140162706297861465282366851351586406974904598321862463844"
        "7467632641139961223891013812536479652440735884693444562940524558164549745388180146106893720295017931658690"
        "7829620444413074029684670336457955213142348285380185813403038234527882462121528561738159623928368091583251"
        "953125e-163"},
    {0x1.d5c5aea5e5776p-541, chars_format::scientific, 429,
        "2."
        "5492926252346403699480399559723131522475692333126746007271937061542803045775918073816174245595068744449375"
        "6897045095772044904146125927159052272308828398501309068340258447459074741175325962308804749526641331075081"
        "4215616392500626374978271647156167704249652658943675636494935189465329052215140979594908979807630334047669"
        "7056289062895628727450248207182214063557902486967781907977747553301723845708970372925250558182597160339355"
        "46875e-163"},
    {0x1.9eff9de8438cdp-540, chars_format::scientific, 429,
        "4."
        "5041091507036545799166835714074572890973281642718254791920274591194041492121447735125974303212253865292637"
        "9956781548301884168031234796205554552277059391393411410991884557672724397409012081748646328143893420883989"
        "3697531955943794618870985059845862267848439181439589090531245749517761564002445364628152426757015371501016"
        "3957628881209237239059125078916075999874661387134914030492787980695630969951714916987839387729763984680175"
        "78125e-163"},
    {0x1.35efd2c76fbddp-539, chars_format::scientific, 428,
        "6."
        "7276831657939996199173247920738175748428147489414967017255708514301722548148393714375353958474701042207610"
        "6789338814555349198970333778333109059056976956517846868239691306501960145686115152454044713905123500514611"
        "0075237349741554326342899856503196071852473843842388818767105974929475307629768643213482436875111072007913"
        "1704627264173704339529068829140553825452116336982891479634968447435475896734047296376957092434167861938476"
        "5625e-163"},
    {0x1.153e8699c8ec9p-538, chars_format::scientific, 428,
        "1."
        "2036075452964588496228569301122721156525464871926940161129067123147023586573727518394806164231402726198423"
        "7749837183196555799200371216024834938526447430132500567697920492429156919627160529487552376377185441574529"
        "4149576799984302279677976161507766568997846724405958600191220802794683903667424716117063509411388751879558"
        "6940287978563712681000947575682247836826937306646431995714552203610801101030247650669480208307504653930664"
        "0625e-162"},
    {0x1.a972fefbd352ap-537, chars_format::scientific, 426,
        "3."
        "6940271053456158204818523935502210337755894478159207791982138392485477834969511571329007609766637419171039"
        "2759126610360094205450884682246809737165114335090151986083381777065321763615316038483834946612248296528505"
        "2765157487090496645351674079514261542379781046580777315105509837747199023673206838144493261571740029835395"
        "3756296447509425775852372321989718301071508531673976172450162203846416031360888609924586489796638488769531"
        "25e-162"},
    {0x1.cedcd588064fdp-536, chars_format::scientific, 426,
        "8."
        "0377497486029463796907310997887231749986322040492207560557729723370806214523480524090767477875661565204951"
        "7694248285106989633954680376204841270502625916650274862984725526583670182750426489618103622160278962969969"
        "2859802003702012845796674268710432520262677389871132077322222514180605600807095690066984447887518374820105"
        "1435419316066722225251905327148732308104216510737234667068193476021156773647646787139819934964179992675781"
        "25e-162"},
    {0x1.cb43f5da906adp-535, chars_format::scientific, 426,
        "1."
        "5950567846572765244507927820377824901317858913529875732063943109841715337321381611732771703577489536903502"
        "3493796238094804046934236086714128000654855531067412929636750704890697323743904633485510251869076888268108"
        "4279306285811281206887100844614192075426548612302663962004264088177849786782954944307405424456628148596509"
        "4248487469731734128190901062790141762240880188100041952915632764231981810532090548804262652993202209472656"
        "25e-161"},
    {0x1.cf8a16d1be8a0p-534, chars_format::scientific, 420,
        "3."
        "2198008776677365715483088235590941078068129505484886301991581386389243298290941875520546912655676996881281"
        "0441917229942979342204911774403664097134020776067023160848590990575248460251418985831836138485385022657308"
        "6973362244606926901073831212122632895414679410788205226590464932818260131222656038901409342927690461162453"
        "656396066174341396517780764483920907682608083655719332828054092543457187503008753992617130279541015625e-"
        "161"},
    {0x1.27815078c4b63p-533, chars_format::scientific, 424,
        "4."
        "1052288903310634043960832987571931636234400160954032470064104477855048188571156057943012804319643271386198"
        "9257969872076510180980285118874101869727065976609233032449496732356088241557456578015929237728817932232804"
        "8388309232337303750030778612509711908501951809831162651603726739987027097299398843085135417047599817866157"
        "4272744294799819204667879819235963165001435696452328267353628992418490550875276312581263482570648193359375"
        "e-161"},
    {0x1.94cb793c06293p-532, chars_format::scientific, 424,
        "1."
        "1247015311011619164388570519415046282988509125973527974174792513587997406324036881610609032812580610918323"
        "9424576993216500730132779180552061858976096213910756516933563665760090369803621666784511143304283240882248"
        "5088788757268226486530324074227172828587904589966139213296169528291499631970170151695928941760193584329233"
        "2629190240565533263563800574591121957879184091543084291008630540113777396271643738145940005779266357421875"
        "e-160"},
    {0x1.fb79dd59284acp-531, chars_format::scientific, 421,
        "2."
        "8199919854660424181406498611767457424061948125885429858945745962442848819176197726683136969437028570888108"
        "2830040755467647076905556002995811053078143823884675889610939027344604289894269581058754232110640784754856"
        "3781536173906753112551553439539348939569353136479925510922455594220822191463137765761460800308028834455808"
        "4468684208204756019731248859110647696119656846453414657236217176483616952964439406059682369232177734375e-"
        "160"},
    {0x1.359571ef938a9p-530, chars_format::scientific, 422,
        "3."
        "4406501648078402345831943940992850675010433136247541593007126579014461564621507825989069421046377258353352"
        "5266279480436005810313967603484552689107264291271767543364013759019524730559490934549343018230659686062274"
        "2466309500895727273464880490026271211635573150397503406895568336637245126201262342174169526481361294262605"
        "21133278102774052246731966461848087618487349311800460637664395881218926120936885126866400241851806640625e-"
        "160"},
    {0x1.dc1506c0bf6c7p-529, chars_format::scientific, 422,
        "1."
        "0582157294697288713963195158371767274324188519857217198944098155515218457859889527082041394743997571994198"
        "0782617107314884480425902230968999173789160718211219459793393266039878135868700464888388541483290580441123"
        "4276364643529183272406529036702764173345831700785070362277638232538650696886272801586331584871705734800017"
        "93016274242856198979073331588237555754089321977604226135305401194919294738383541698567569255828857421875e-"
        "159"},
    {0x1.2d2b9e28a6a75p-528, chars_format::scientific, 421,
        "1."
        "3388582036266355541959404316699840795114375100648807498487442232547937540767560212253164334353383449534594"
        "6743958644332602294994034082624978656972696903905477947930595101845262918336444821387696088794686692195304"
        "0167045482466019883897788454591971526214814157238791252917209606217864777959421032096816467916409844038417"
        "2836004474854932106579809179603391993269887733998929837348564227117453384607870248146355152130126953125e-"
        "159"},
    {0x1.bfbb91d629252p-527, chars_format::scientific, 419,
        "3."
        "9808070524262983112904656865346504878132939372419465371210599523355680262235845071654587488829808528826255"
        "3211542596573645028294042617979689261030895068039674263323248377753554749934026854747850685855751439106084"
        "4862583279339947687017283592856642221530763984147033229022671292069654536582029312632080382570358728048793"
        "26080897160088621835645648574210621835117584474315503701422926108310917925336980260908603668212890625e-"
        "159"},
    {0x1.81261e2a2b58ep-526, chars_format::scientific, 418,
        "6."
        "8487446591097199941568879338773260958022232603308129404577395366943751087141371095291924550966687048416161"
        "6769294776395348321020638598156727873424656596843199381833408121608182144007626543586767966079553232265060"
        "0491832255616582246035074672018377924273775286911895790270086967708681272931741809331769970454006868479980"
        "1126128292639790394592107549831084067660125239545389747952523762375420801618020050227642059326171875e-"
        "159"},
    {0x1.baa3429377a6bp-525, chars_format::scientific, 419,
        "1."
        "5742030359655316135314019631790472127126364419477776829501394414493294958623139441874916754684678732509715"
        "8991033070315380568522405485975093110902491134901423225555834565328486328064118867427922601658085650759434"
        "7866705253552661370252961676208893318743217957734924116551774986936407789322905691142636861514631034901222"
        "50101193233407172333537545750830117935069349686134489453548900017576528398421942256391048431396484375e-"
        "158"},
    {0x1.9a907771fab1bp-524, chars_format::scientific, 418,
        "2."
        "9202734088397782914748976105327502984069864360599784056489683368011606263857076661142188306671405159781423"
        "1670256843555408784320151853777095713405165964263539211094938101679106092335341904570196983657111607404300"
        "3839001894312185913020143290160018732262249780193598708143728594996072940408519441822653019593776771607108"
        "4536867135236252471735572482767841378465604833111435732133191744974709536109003238379955291748046875e-"
        "158"},
    {0x1.5ce3039935233p-523, chars_format::scientific, 417,
        "4."
        "9631432238623663477546167552731124003328921514474820413997492211106129001776874436254409714844492300472015"
        "9111477138859528039163853994425999126996609683227170224030873388958268153423145767609226993844753478328382"
        "4259195277427492686885377724220076528946842969848256726439179741579269576223391510486187927658224539225843"
        "413775535462042906286635028827134767522968000184340037184670124670304858227609656751155853271484375e-158"},
    {0x1.b45bcf37c8d61p-522, chars_format::scientific, 417,
        "1."
        "2414975541479182662530661958882288430785834775491841525389411874824159995097885756544225128758410546645621"
        "7648773130036540949365023441814765140175590447946206316753149905087898914730214365332693362747497929964614"
        "0492013260693375349748541774845381848399320823459041716554134838029493474244785198203045687110985403998184"
        "411933091955954072991836879522317775602854761084515929797124356159798708176822401583194732666015625e-157"},
    {0x1.3a2690b025ac3p-521, chars_format::scientific, 416,
        "1."
        "7875996042719942144684408823686534589648628475912376125631821356837144462300068766162676042653370244492773"
        "8923771107674341441242397371908288063262833805963550278795611140294172228349290732312168702927741365063323"
        "5640923880607318621527226861884183570539435102743690701331486754067853858196036273816308192289028030388742"
        "38541139810169708202329862942424051508832654330268286681747402777631350545561872422695159912109375e-157"},
    {0x1.8664d335d8f63p-520, chars_format::scientific, 415,
        "4."
        "4428868657860281376359178678068678828865965144798881231178035166970602687133480970061156378529524002809523"
        "7462616854285876469189545810325410817406934099121471189600341416115425999540048866344895066961885974140878"
        "9048876099387012441921979951172011268855276022497405913799786381336671115842409863056361279540698104879752"
        "3362754888079179316205818081708016426963313589920827914418743898039565465296618640422821044921875e-157"},
    {0x1.a79164aa2fc1ep-519, chars_format::scientific, 413,
        "9."
        "6408509408080923610447309847908498668818477504064378536812604606911138032185873877406416092196184093377840"
        "8732022497546793318629212174366316259374071673186690940671105393994035996979527549102248122127114953365994"
        "2125679052983397494126651483669742329979687385596140269710005813496485982376814623846949071924371149153140"
        "14743723316819620786140512242325153138109329199514885809507713787525062798522412776947021484375e-157"},
    {0x1.2bc49fa39fb10p-518, chars_format::scientific, 410,
        "1."
        "3646071402129266218022608455308893034728544720923587430500970464976763025029439675540553811195474237663235"
        "9523834483010519315791469330342593252278915593622431617814522042082490158690280378293849484627353286026715"
        "5225175793585354441642493367039247804878240514821595105922697779865504810971833579265972782223673414429052"
        "93644749971602789648179855297617277419064627585012540456066432170700863935053348541259765625e-156"},
    {0x1.b2a37c764c384p-517, chars_format::scientific, 411,
        "3."
        "9571324550397298455952293967097384825358953198030980159505341889845628196675999913836798970468837187820324"
        "8478294128925979240194223968807640915113276532656464287084729513579896441131394373033593237548328064981059"
        "5159222317626828045607596436841049015855425001023090510787469983857446377619492592718840110454684657613648"
        "987645086834150321214164087322605627281014744584084104339627430135806207545101642608642578125e-156"},
    {0x1.843ae1ac69ebfp-516, chars_format::scientific, 412,
        "7."
        "0692179366582615531567675897574671091761437361338241149656756895396177633253683272883611099990399246500443"
        "7598258992764058950920726978683938929713281967633418748635447629975311846108340480127933613935207582106283"
        "1418275464323041900377706185784736448842459419508045556665132399047286015752324647790319023015284540485487"
        "1979543351655494158128079536161932019562760201123060264938313679294878966175019741058349609375e-156"},
    {0x1.4a7c9b0be349ep-515, chars_format::scientific, 411,
        "1."
        "2035560157157919813062745372089973915433204195518742166387275134267274407820877716584250745353852034461563"
        "9510290947540420847412015550237264275570830129622833566341709883458286591764701770519397372432417712594848"
        "2712272309929483096695073317289136760663753949010538916406220492776005908179269094318962119052575144800112"
        "517791981236689550651499999859263780522026324949400565011981001362073584459722042083740234375e-155"},
    {0x1.3e27452f4c3ebp-514, chars_format::scientific, 411,
        "2."
        "3172816969783969551891233777943526250416932539763293520394005777040356077947428725088477967218198192385517"
        "9173739379747918200529704692932728516243182940513018768265036831234199951980780926608738288565060565046999"
        "2621982723809517078775790931964018019003000211754865589982252409368493331309771709369251704091173604782777"
        "233093007760038948922133043358862285948249785523761316852198177684840629808604717254638671875e-155"},
    {0x1.b9268d67486d1p-513, chars_format::scientific, 410,
        "6."
        "4262723679026234613089358592151495114322567354938475729446594062899894550316581573372400318968212811428919"
        "6470319876282149819515198919937995775425705761798674673066995193119893788442638742100166477114130792519595"
        "0776140684380624064791666341285838548486494556094652195717677079876446559347047552594588771871315680949382"
        "32717074211917422314413953063196922767011329619070598984098552364230272360146045684814453125e-155"},
    {0x1.4df9e0d56e886p-512, chars_format::scientific, 408,
        "9."
        "7301072362246582992731617268110711029353064013073350453998818620182181804740211694728963191497913793567991"
        "1031034017939591604335701819972757665270952692642901948619176904535218754880890639319149166591492630199955"
        "1633152928738414986716903478505634319202980484473770916202240532708166933819170785587530689982280013134565"
        "017333638307204694287737428192204358891274416205018071845955773824243806302547454833984375e-155"},
    {0x1.7d69eb7260760p-511, chars_format::scientific, 404,
        "2."
        "2224325771347583865914578960158321557360842317854318621134693365709148731046280122802494349067538519750041"
        "3130917810364898093092551411950073674123927781422093946252603565097262860073949138157458136720220464476024"
        "9595881705742112157886504025211275233525917071227188614551772891195644263290147759646936048898544911099912"
        "53573791105880281676020497507543159037307514518111428714064459200017154216766357421875e-154"},
    {0x1.d15b6e4b731adp-510, chars_format::scientific, 408,
        "5."
        "4231128112241111883705509773089298055689258334481416666694017403320776689974726528298409316165705979593427"
        "2651133535944542041523246725633760821160380141790144506211196558566480102602131990816837498306875789723207"
        "6504585427720559612691028995704712640626772361153715821779073508058665270716186992631855993540730057277097"
        "798447449807118198421095187366823174718827741476630255323954088453319855034351348876953125e-154"},
    {0x1.3a5731ca0edd8p-509, chars_format::scientific, 404,
        "7."
        "3264353948817245453789075948016247651899446607642030711491920326112691995960046353812600332536813842352429"
        "1656290504702564770688838031055615174036884610469534126066936299706736185979551439500161693073301855346571"
        "2808422288445892090588535812980025454718642561058682378505086089914779359167555255668678072269653119910078"
        "85637914963465670003796036900151548500417677915741432315144265885464847087860107421875e-154"},
    {0x1.fe9875d1d94dfp-508, chars_format::scientific, 407,
        "2."
        "3801222320149624687970238838551821292683756958494975634914436808747089296715116646167927695091570422907292"
        "6369290928298137726435619308975066477116451778078282790249877308178993242493941303767119336504866436159369"
        "4314583580741034633830247502226974735196463810986401237476592299983502726826416248447495090355412974549206"
        "46488679466589507176571074090805100721695650319541248673971267635351978242397308349609375e-153"},
    {0x1.486c8e4f5125dp-507, chars_format::scientific, 406,
        "3."
        "0618730536691985545579000169222995038373293836922890489125504007146208609330137385438091876811492710859419"
        "4560986809112016677495317703714285414101823358342697061863929398148649681794221820608430077282387116500634"
        "0524333371725021719175453309110948816510168122988585283130771853920058975957661080754853677159756800437879"
        "7317284169074057937506011637447702247448555836796535434274346698657609522342681884765625e-153"},
    {0x1.bfab9b8aca208p-506, chars_format::scientific, 402,
        "8."
        "3471948672359081870252474793852930929195495939030283177039922550551126183653446755773285874366359596754283"
        "2502756933262416846096962919049560927597425906971808170555329109012049943787534763467415849596127066744913"
        "5137335706245812851751344457709710650666087089376367629961851390368065008093519365610537666124040492551911"
        "298472615483739376258107919132264624991379871332686235518849571235477924346923828125e-153"},
    {0x1.6e3eb2a2ebf2cp-505, chars_format::scientific, 403,
        "1."
        "3657896771381836370309182418161048341057689712493955806624448243905928334545004278697729898364093587345786"
        "8865313130892630862358886674091915514194799331994886115738707464006492635762748605607064664260305266934879"
        "0678316930885947176435659031006469277337966316027578384047346694343336071347790439049988766926425966011418"
        "1565996765839548397549385581670407344110642310075487415588213480077683925628662109375e-152"},
    {0x1.6acfd1805e7f2p-504, chars_format::scientific, 403,
        "2."
        "7059739547586404103734020958479760826890651200741852274550973101395207195449636437564463046700627498648696"
        "2573403237486822427240404441709874784114954462792607899085616545057563405007609306607813789573026667536278"
        "0471635363727993881117980818158418505372787172646299938963726825437220330053205315677811360493235151514227"
        "6147452978679714962653853072995287764931503400600565356626248103566467761993408203125e-152"},
    {0x1.fbfdc9be7c4d7p-503, chars_format::scientific, 403,
        "7."
        "5775452971095829834740720048137883659078221730037758958977500243027089042030315562065576850353242510972298"
        "8908820640414600991363246465113659524874333368518080485302807469768102470893345904366988820833134850152267"
        "9233594131683886635586807403560296348126596298935394558714901539292174038185034695148230653865497794789982"
        "7035012684127696551603799048515935761914023675867024820718143018893897533416748046875e-152"},
    {0x1.8b6638a74b1b2p-502, chars_format::scientific, 402,
        "1."
        "1796090875694487081840030359311463862270589279053705811580876107483727824962666775311728890626901753646893"
        "1733577855602836561907239918066053974196590031535933155795041615263196884064656501777212660485632917003723"
        "5553003815414569897105068661910842231236269130833379581876621381560616120996039580011757096732043000870625"
        "476753518672332659627018455181383888174151582106663482818476040847599506378173828125e-151"},
    {0x1.d46dbd2abc6b4p-501, chars_format::scientific, 400,
        "2."
        "7949604896251110474468435743440309945288120594039878056554427992195401617178448765891155578587354824245327"
        "2163051998044291731736689754999480979232786217446696064729498506880523647341315312637248430084916512736609"
        "2938786364110450759620750625707230523155311741574527176683116117371581754805189904683589112934565440671302"
        "7853111244031216018263685608830589461614758717278306221487582661211490631103515625e-151"},
    {0x1.12792046e3030p-500, chars_format::scientific, 397,
        "3."
        "2753828239853733863446369582437710222695184799823949849189206166844715031480630276984905665029410879633325"
        "2127316348030245611596414872858686019667951434279227319113223501530777253893140911875570729889382852881733"
        "7051954380499856181898096431741496302183450840154663766232702257784963092897043278167953142643939679211226"
        "3446829491223785021441382997151012842866613095083039297605864703655242919921875e-151"},
    {0x1.91f97f1e1b12cp-499, chars_format::scientific, 398,
        "9."
        "5938032050821536271229835447916874887997484567576901965829125696937852892456863299883609755835723653544210"
        "2841682756532772118758908073143284830054239179665994380300567905166497888249079872424626223422076411420239"
        "9847393492562247437513415173947998719357558940259847465774991079887176648133578620470314414244635744129631"
        "07645174158017020074996772789705377546508324737573047968908213078975677490234375e-151"},
    {0x1.4b9aea9518c4ep-498, chars_format::scientific, 399,
        "1."
        "5828634475728830814843440523506683765688254183130477711430434290240840477584699481675281765446827769126533"
        "6303593028015611137361963891710823183778865940042147787475049837402666312756010315158359598341391818527548"
        "2488775243582874001862476692842480950276260886343365712468475565010191030391942463146663252915623226414517"
        "974202343217299198758136604105901053848697024317715431607211939990520477294921875e-150"},
    {0x1.1106179212948p-497, chars_format::scientific, 396,
        "2."
        "6064697688781666463934826758520573747383519448492866680729950884307524602126143847451988424868593484060194"
        "1716682978957613938305513748932267449077368268937442295833820496383123332506277430625866887250915854592511"
        "1757800801345831269796185208403514964100000121598690191471297899173032180673797887355522464851068977489807"
        "267142354958247478671324520732786021205706905590204769396223127841949462890625e-150"},
    {0x1.f48d4b7371b3cp-496, chars_format::scientific, 396,
        "9."
        "5572143783563679212569396386714562244314668940940271083529053255203811492473894394483995163236935273856965"
        "1628260530221751772117369080803655866703068176768535686143790764735897463820055564420846715137456754533728"
        "3626211301932389420934134356722717872774848179655096293845502516384809908089594305714462025397850425772483"
        "581964588413924537744877269495840494371863282907497705309651792049407958984375e-150"},
    {0x1.38223e0cf2f9ap-495, chars_format::scientific, 397,
        "1."
        "1919359645157150762151885745871298169469988759647520275617530679373213681293098328176454498212756348418279"
        "1181505556016652016850967697539824481686335844121764077022166174838198246329265529449867422827831499533947"
        "7190052647484303927124340167358793615407569077242194702127961550080648296820459406354990529597216843845630"
        "5496010216053623887351146977264459915664407407831504315254278481006622314453125e-149"},
    {0x1.3e9fe67fedbf6p-494, chars_format::scientific, 396,
        "2."
        "4334447753350621478964908361125060043278078662466547499862131283708984042278535636275983077789926684370094"
        "7924178444565748309990660069844962338807872875732613196406804108645775952673011694052762137127630272887337"
        "9411794872081659295112882233786679511861407738863134690326265257013513191916123647888187047926526116330566"
        "078186068092790478450763659348438420169935536563343703164719045162200927734375e-149"},
    {0x1.bf4f6338b1c00p-493, chars_format::scientific, 386,
        "6."
        "8325195696222758262300152108424437528570430091504730873063246196160570278444533395376186268614032140532264"
        "4888404804519145048373433855904839511702044902178408277990112573516429336486994559408882196722920797431871"
        "2051202804979917404513606924385342451021231548098961032710267504632110823167822434654856228970383578198439"
        "78777235944402878039559477534037323920301787438802421092987060546875e-149"},
    {0x1.1cdba81ed92b1p-492, chars_format::scientific, 395,
        "8."
        "7022316670098795959727408762827482104361505903791877283921876903868602415596437465814520086552230400500984"
        "5672509117962584522015252416171153944623922048021811670715197632594303566335424562084952924302166284271162"
        "0992116548640972021637094804825070765198845261168362052582156148171394464612237005333734915500968164199971"
        "87621877146469562458463689321063101213271639977619997807778418064117431640625e-149"},
    {0x1.e8bded2bf3efbp-491, chars_format::scientific, 395,
        "2."
        "9861508065908777159451976047342515240826688859949110638489858234060840988973359424384553665819870965413447"
        "6256943272501564888338028997374032133260948786678076350777407867941949730285495110740536215009936451824351"
        "0024657283742270237945843651504136068975350045379052042474267029695327356093256084645810010718354716697542"
        "68192542916115180944707276419549670486153214454816406941972672939300537109375e-148"},
    {0x1.8a43b5f93a8bcp-490, chars_format::scientific, 392,
        "4."
        "8178117758993382415252081853649016760029538206499370204986995420250082323503440516020366472603862356528682"
        "2407474487671722791487229578768266569205598375311931512631402861579435514639874109138388148482164551601658"
        "9991338662690181015071509492664273040280948122893995104403874967577075668844761974265722111301155846657648"
        "10221611126794232827586086115464157619836527146617299877107143402099609375e-148"},
    {0x1.7c6fb9421797ap-489, chars_format::scientific, 392,
        "9."
        "2976724414783708703425137615132523255799443671421598073694843277985025047735238958873938469833101210668978"
        "7849419886842856325526502716934419983558360032835835080894125849892846465314091581834698079153876328993648"
        "4730102094049772932148827792590711460754459836901369343119647606860551192961236559861883261715726861152891"
        "43456512542275199984831499038060061146371282347899978049099445343017578125e-148"},
    {0x1.fc4d97b6db260p-488, chars_format::scientific, 388,
        "2."
        "4845337797454605412409621847810516244910538112904300134285148151719670450247219375039112563279547871450070"
        "8261201353671779025865604768841322168996196583909997616168972687643361674751144097063023465593797952596539"
        "3871719212044328488997810247788723400358607298489506003722550735501161314071797972142749009847789793383658"
        "4355771901909066274978117572734548357260564444004558026790618896484375e-147"},
    {0x1.27312209461f8p-487, chars_format::scientific, 389,
        "2."
        "8857361527417207852560816625809604310973138050037527355003547400669847002661975613103114130109031618794874"
        "7123850992698667099033685561487362675009968516001114183271998961003820072099355306942878689026849858227367"
        "0224442596264970542245334711246017142526341026122147120651448137089111639290660393218550072182078704511962"
        "93377558772035164374411778261640681986222034538513980805873870849609375e-147"},
    {0x1.77547904a2effp-486, chars_format::scientific, 391,
        "7."
        "3382987425347269650466241166435692135599525604305813942337856931534257940953624331547168348337623202811632"
        "7675134796928634170492220120827081521431892535790219564289416877103465440408362924506713267045825031797854"
        "8465353673947500213159621357227497454897214905553162925688998444394828308276455932000197241734550930846676"
        "6426135760102477320412501970623396496673507272134884260594844818115234375e-147"},
    {0x1.a21026147064fp-485, chars_format::scientific, 391,
        "1."
        "6347598189352821770450540544887874910462748993562374915104923632121430427394154917169330583508545076873765"
        "8921710993603107178696650209105813061398573309841803393393955858839364145480190924253344292068014980758090"
        "8718275496480021313751877719439275878875402393075928784943183580785470118572485534281639981340542519549125"
        "8920008304407477816080785984194194415675127629583585076034069061279296875e-146"},
    {0x1.e33ffe116dfffp-484, chars_format::scientific, 390,
        "3."
        "7793226434705113646355980315406843842730161819232106915137928260298076813313813372642658016571660158177452"
        "3380558558885463980900241817266548165024945160760116563363642163937498191689679806757915110601496243241433"
        "0499266088828954939790981701152596161360776773445374142941503398715913393644403242726936741616261493580695"
        "326300741215037921072531691842576184736657296525663696229457855224609375e-146"},
    {0x1.0d97cbfb3bcadp-483, chars_format::scientific, 389,
        "4."
        "2167773461430841096168944818744711307173047891677654476328304156506561188571555447146574496467644980277018"
        "9032079619071193887326614005453208506142767585099322327607003777151774727915336623087705415153818142529084"
        "2099630456044653627617275033231662411852557050306840891668696221622591255126538876387262079254791476225386"
        "08157385395783430387663692794943115504935349235893227159976959228515625e-146"},
    {0x1.fc7c669e372e1p-482, chars_format::scientific, 389,
        "1."
        "5906736035433478795666492032411048437699973656947142198913549771963049630784995328887755327128517799168066"
        "4449513987454305753588712869415089089334399246465373968206186757087206883763796426378897368432012105506716"
        "9326875666687873260448935727563546153270143949896632947326143345688646515033756768437592665073003021431039"
        "22720410241795394945083183557178740930027061040163971483707427978515625e-145"},
    {0x1.ca4a36bac00c0p-481, chars_format::scientific, 382,
        "2."
        "8672951771554432303752342207397704874686379593615168937776854662187877340530190070806874633750499494532240"
        "8818988088425644366771375033162476683944430496046660877697340757485633491943820158288520141534155518743581"
        "2767248875572624752948053776526726589546868961296725647676685932179510318584450981563941057488017848730749"
        "7168016508884042466468421161973623156882240436971187591552734375e-145"},
    {0x1.12bf051e55395p-480, chars_format::scientific, 387,
        "3."
        "4379041633188433781391796667234074028435987426722232347622158962219748268262338986398326998553663730733286"
        "9261263118140094455518050615101152124817967901873027097068416097734341519818353755672448406009788972230454"
        "9743586116310371815207363078165968507947562208219568651368309624970888523684513951862673701624317481637524"
        "015502112241292046885060497592168093916598081705160439014434814453125e-145"},
    {0x1.7af60d7aa5967p-479, chars_format::scientific, 386,
        "9."
        "4838962310135761344092396167333415391569688763220398309454881231605306514746244823307718893899616717980139"
        "9057332623091728034184656426130519076454149994764188014351734458633392258002552377150853127295195134676491"
        "6390419819472756495777678716502600107256209456679635005594684631820296766940686808383128006043474601256098"
        "97815494060316512924194566440394549289294445770792663097381591796875e-145"},
    {0x1.b73357a425a97p-478, chars_format::scientific, 386,
        "2."
        "1982900216496951912636237517321659702670798815780532692828188834087902755885019342613033041567821756664960"
        "2016365783841795080898673546344147158231616257438737990978384536904134112934509784794056796055102796462400"
        "1327053575991226081531574192187674082752085759776287241663068738388351272800591961971565145686989428887852"
        "50819213532101900745451840933630816010690978146158158779144287109375e-144"},
    {0x1.cba92c6e719eep-477, chars_format::scientific, 384,
        "4."
        "6013959285449562218784849796417406268924809275050240965117618538701248742081787894298428024850220631495394"
        "8843090919478937616929128000444092637251029405884356250538030864103321329060205766394419703651516351399195"
        "6339704480986356625598760310779666153618027622379329597990176509872185236937051592948849485535253991494778"
        "196501116690165993113720808993516442342297523282468318939208984375e-144"},
    {0x1.8be4634ff76b9p-476, chars_format::scientific, 384,
        "7."
        "9260896178364885712586863338954190885910769204002578873260609825376157123972452672117034283698349000727217"
        "8811914952940248175221547710878388778883291965540342485837401637947057005394455813653078713555099106601674"
        "0526456787922005976420018108523974718072488216371523207019836445781599000049045968896364821326508004681718"
        "328980102387774532495348135674451128807049826718866825103759765625e-144"},
    {0x1.195bb1128d351p-475, chars_format::scientific, 384,
        "1."
        "1266048743457620018132449750109616902012501552632301028746300222772300762831245282635755871042079935221433"
        "0397304252105202227560938436270619441940232384938913439609896370609801593025643499862217542244084349248920"
        "7365678039104096653395735733434216596882709167520981641503247868678058348447755344979159303793136769657451"
        "566731575139884695914882679901314332937545259483158588409423828125e-143"},
    {0x1.d9582810d5991p-474, chars_format::scientific, 383,
        "3."
        "7906989762760977010539296420204713197961323178556125566473600056453448874348023486668990302113409067507642"
        "5512666375287866720556532018498012991417750946868079816281685420092627374913565047968810228895304309081082"
        "7776483853652208363091961204475009565583127525351886644817961845159699988605135294441599824142042948767636"
        "76852096147815252970649825547955202864613966085016727447509765625e-143"},
    {0x1.91dc30400a639p-473, chars_format::scientific, 382,
        "6."
        "4364586827198767306358125396341809950796993470218142142343574880083891301701589050045580411828601056066543"
        "8578613541848555355275084443348178823538223876085347005568276012166754572940813489866481451272426938454005"
        "7688367320099074111805095744115674497205307649349993431268929194537492248042883602140585143587994761332590"
        "5648050990408162049774727642148519635156844742596149444580078125e-143"},
    {0x1.bb4959cd66718p-472, chars_format::scientific, 379,
        "1."
        "4199943377251187537949675350005079423187700022228758326221521640526029521346740953695783399936936600872287"
        "4407753705401513284671140970518928691753252515077837559669042688180179223137869737013695121637086330367906"
        "0473230296854766707360327968674338036515155027602470266905967351968056368459849948118636405588195957644242"
        "8067625960673098033625050273798251510015688836574554443359375e-142"},
    {0x1.cab1b98b3b707p-471, chars_format::scientific, 381,
        "2."
        "9387007315399001337843467140701947490646533646383646741168981933069251261075266021456186550679433594978996"
        "7239321904345156747275229367729995831822884324397633531132361947458460677520772536493144275246577960215862"
        "2313197512447305365216189939904546876264703794084991693455204003412709032881758809299262428136448855311663"
        "929317040733753824545242128163380357364076189696788787841796875e-142"},
    {0x1.513f97a6beae4p-470, chars_format::scientific, 378,
        "4."
        "3212757508195659485508065379853979844500716301246743150152785223009553880036241184640287335154013264357096"
        "0952043271132202966879024207483585271608519582168701354278018371563475097472078209541866054396550301840853"
        "5752782166921273364856333578679926605858330352242829232861196385760569862934221186030844482600416992243969"
        "322617877399178251164590935928799808607436716556549072265625e-142"},
    {0x1.23ddda4aa4f46p-469, chars_format::scientific, 378,
        "7."
        "4795674901009501599687387979276428028217065964050376989668893383691257823806867042515842078744474517031407"
        "1895485469191115831640711419412290132762704670408024637792177786766340048068468354031068962246601535160186"
        "2349167111369075434108876998189806009451657247710719467572422765836922739389375015650257781352180780599630"
        "217854761888887876568332568893993084202520549297332763671875e-142"},
    {0x1.37ee070b3fb77p-468, chars_format::scientific, 379,
        "1."
        "5987439857085749128543979468421347404798369339619842909758538091544906123513224004714621004604317341155476"
        "4830277704469716857696790698012386358199581778604043428049370268894875238346646052337439645510118935311304"
        "5871567381746415270150272493696335723627439701097622331692153552932290372744776405111128360907502878298528"
        "8180585511628949125194354419221554053365252912044525146484375e-141"},
    {0x1.7a3e814f7c455p-467, chars_format::scientific, 378,
        "3."
        "8772543479398745912495310674542245392251289103259487422362584185221005555927613777493177235835548528117811"
        "8302432240933992624204868787463842883298566251264050405797426114438754525206002596249474935519087677964390"
        "0013313472242863345433568164189149550863949526447244598726165343683113264168124346368742549505223090492057"
        "351838011423203673479209729890726521261967718601226806640625e-141"},
    {0x1.b008ef4139a7dp-466, chars_format::scientific, 377,
        "8."
        "8572904580841789614754232711686396959759290995923259860158443209002812929627074824889999094798269835513254"
        "0998845477274750334005664050117293551284426384679313859709553221587795313680157822564176364684723674516690"
        "2000693415871071595853995191227910934758948131752454927512504000367582800588546292331716557590430260551314"
        "49871016536323016683784903335663329926319420337677001953125e-141"},
    {0x1.6a3ceca142f25p-465, chars_format::scientific, 377,
        "1."
        "4852721614344735437292541639963060443263141102043656353372955189549517666043979043032187958942357980893037"
        "0840252848547401622923075567638582241455382956074528344237666272700101153478685493953250306368486765749182"
        "4332905746273268182840421417991838003237060783473024229840428934381790407194987886288409466183411626302457"
        "65429564945800410859233497973264093161560595035552978515625e-140"},
    {0x1.879c5a128f335p-464, chars_format::scientific, 376,
        "3."
        "2114166221217845174327447115992392374668964402329268800963712003830340521992537289583647041045528110284263"
        "5303499515391399834686408526191662512438001577893564043814181085298234246800586801045226636006748241313130"
        "7522786571652361908511927539092360053210712569816779695997967844462040278748911843877424273521146041902588"
        "5846797137206727786040705296954911318607628345489501953125e-140"},
    {0x1.a13b758752749p-463, chars_format::scientific, 375,
        "6."
        "8430533321006578298315622206827888634375564457496296600363690350980619762819624331006890836920053795052268"
        "8370402495113279403328072887329458087656201260342686767845714173996590984304971343366016453921898634106206"
        "7674396745885910406868827681945359154367703453121597743174729503689380057241534775569646829196396378247871"
        "130136170076470499001874969735581544227898120880126953125e-140"},
    {0x1.dd22c5548b2a9p-462, chars_format::scientific, 375,
        "1."
        "5651071039519719751268946730433209491685269599788420485953219030692473518449901649555366566818121803846373"
        "5680904417760697692262477792647738252648295215490091671889157286396107620561142080138411428231115221654909"
        "9455747381869282054756781298103540835711990016306871443323392685777042535287304513633281869348053796759051"
        "449311207979673589429925328886383795179426670074462890625e-139"},
    {0x1.3a466b3b9a35dp-461, chars_format::scientific, 374,
        "2."
        "0617783292012132110048484524577034708763801812806846889421937147593782421046544694512376644429350834218531"
        "4226530713713824082127126656554247991288683437918042715199973601623635055616074512412883505084857003066123"
        "3050190132621333636152617574413419624138051138995646737549047491952163495322980116587422304830212863807167"
        "57918646594494906099104269969757297076284885406494140625e-139"},
    {0x1.af63dcdd336f2p-460, chars_format::scientific, 372,
        "5."
        "6602054122048727921826190049712048498669146495554482077926052213769892391972155107823538731408874729899034"
        "6792194827829660599641240756981656489830070688868731818918413640802502222925430134747083688070474879030296"
        "9738046971386503460831112186107202194534175784137625129392628895158265668499896268624088807818901523078678"
        "889008399162559304063080389823880977928638458251953125e-139"},
    {0x1.6ec02ea745f7cp-459, chars_format::scientific, 370,
        "9."
        "6241634559974588550470031663368349943378831463927445452058900881064926118183848091052345386686684876344532"
        "6161315986809133600636497090313419475443507804928279463021903686529521982727237277282770740989981019500686"
        "5574824665465743137968830206089146401495465235722508613312222305895849308346944245441317410343774024309939"
        "3609930015773545886048623287933878600597381591796875e-139"},
    {0x1.9e78dd35e6f36p-458, chars_format::scientific, 371,
        "2."
        "1752909285251191697648113699053702637727489520541042360582333721279125948156690408463090424584646923549518"
        "0942992131659468643940147628854434370427060263285244175515322077650246922688324052450302930384427072839475"
        "7842492386837881192332322824075015094377235565634494864419445464055485911488407505261872310932269115328920"
        "21280816813831593403705255695967935025691986083984375e-138"},
    {0x1.9a585f80bab85p-457, chars_format::scientific, 371,
        "4."
        "3072629120188103249512398775746221992085610716624708892374467991779261742776439264109609536390646567234426"
        "7525349801934937730247292561608380009185242796805519587479768507806463318749894112461752099897976376679226"
        "5859716833133142309161784445679684796923222134468302918127430999767436216601957379453800307851317225326157"
        "33040986549275130901293096030713059008121490478515625e-138"},
    {0x1.a6e65ba502986p-456, chars_format::scientific, 369,
        "8."
        "8780896980845694512355699450135667167474608494983516478858968409659482574692196941169154704757494026767065"
        "0881004269664970292068439515226078190024902892002557556809749308704779003267551048192576495608146500136488"
        "5058786848795066433476360168510321692410412462444936724066019551372571776922263017000926269477966339109356"
        "079124769044186304967070100246928632259368896484375e-138"},
    {0x1.2041239e921cap-455, chars_format::scientific, 369,
        "1."
        "2102860505856427441863506911416438557648140836421513056577062373671144072180353513990930639340259058767237"
        "3257099356704235139962445699680300772732754695176822292468996066789589373242949311404414022027874115262780"
        "8785308312747064770780467959018293493486808663697190464543529527135601732353052334628323918972488583866538"
        "415926878032025104658941927482374012470245361328125e-137"},
    {0x1.e2c2206571f8bp-454, chars_format::scientific, 369,
        "4."
        "0538881189604874758994800103224482110424419984906922206717025596060356483137003469609681462381640957524317"
        "2911889262541296693730039817442824706217992206174740879595790963900654804304187742835595325686164988374589"
        "0322213024653290007771883621311168396610036064921521154842858228344839533773793548383142400170080167454900"
        "059158143070525692763794722850434482097625732421875e-137"},
    {0x1.264bf10d7be2cp-453, chars_format::scientific, 366,
        "4."
        "9426210322338252635572061070906968405888216870034632652951803647003944472039593835210475205592373220399127"
        "7018801884718299712534752193391140108918824839767655067751800656957226981466137842744520790572580634924148"
        "3459928010949501467461950221909399691687985514158948841431923008834959479285883564251332461521178735704628"
        "190938091092387907110605738125741481781005859375e-137"},
    {0x1.cad3f14cb1924p-452, chars_format::scientific, 366,
        "1."
        "5411744957634478558732875158007911309742643791263152383028800246394250010301841139543420118207407753920760"
        "3218589797015836084381494407933290832598692742653536345116174588473355663138399758752109216617072642962120"
        "7135842117636071464132112769695338048041137489524235515090494741996883492492346460319710822961304962419452"
        "460110382008284801713671186007559299468994140625e-136"},
    {0x1.4a043fb92141ep-451, chars_format::scientific, 366,
        "2."
        "2170106143596450609014218157804357964381470241171242549541903911649755928696395840283489106316089146427743"
        "5062966705933777580211869707929056934148231613404163981973357636235389342669699272984120998848954292369787"
        "2554428392780018075983672770091316945354715295754269008522521640290584844958554224663146563346799785217835"
        "259873951636588884639422758482396602630615234375e-136"},
    {0x1.d91f605f33ee8p-450, chars_format::scientific, 363,
        "6."
        "3567575408975392743526724403263859606835265005008746398722782311228825240165088104697549263316148656313234"
        "6426578332847489634158927173716225287463270003583594203279044269022582967257937898723790101285177867709597"
        "6655741399044978428732881345094886140578723570628664975737909788927071910708005133352031145300938446489913"
        "435412388853507081876159645617008209228515625e-136"},
    {0x1.653fd37ce380bp-449, chars_format::scientific, 365,
        "9."
        "5998267065455804136465170482547947366999684488969626917464974228247748059445435327953748521367236770367453"
        "1451560088375242660031278793518034857995227061963548088366069731985696736508405628059744476431105501074451"
        "7632659439131361488912251913663824732302366424969441750856521571686454336063947389316836480712814735548475"
        "72435787250721972441169782541692256927490234375e-136"},
    {0x1.ea583b86883d5p-448, chars_format::scientific, 365,
        "2."
        "6352597315051091964713257494843957096579268453980939881002664775610008832253360604307895378781817021575772"
        "2131262889797575381102714481443132987139497702786597756696037753098692013672145953687801073867566319294992"
        "8316534778995707013335990382676469114470866914005971164662199459123732837094223290390067459830854578717031"
        "59650651759893236203424748964607715606689453125e-135"},
    {0x1.9caa8f7dd9b8cp-447, chars_format::scientific, 362,
        "4."
        "4355852076232533703967017722389898945821857225058681977965240699080262887084660386234585786609389805397653"
        "6231928757581244511544360492016168686756363796237882797468921698797356010241314741136892145667049203620013"
        "8721847402285626290068242713216335744583762528489836802234047080678004035672934625936455690987526985520882"
        "90749606525054105077288113534450531005859375e-135"},
    {0x1.0b26a7ab62a03p-446, chars_format::scientific, 363,
        "5."
        "7429993366141817840812479753542746382814749094420490827347512947579020362059688082352895775572141852211758"
        "0909348864872030450848171956721649351848205979835186312573993891506062416099298516603424161994426165270037"
        "7907106153840215329576081676331897976487016666661306584555944953024603245394667724116557668613623517681616"
        "016498924448541174569982104003429412841796875e-135"},
    {0x1.694c9672ecb8dp-445, chars_format::scientific, 363,
        "1."
        "5533843624429323819438527942729951888826684224818085321658052959257745308554358873724455989172691764656869"
        "5293047034140544314292313264389433797659762881589730183326362518440901757090487907181989255445273967251973"
        "5593544269570691464381471936515939828758279599762414292837467494719157630828112902620254122175049117795947"
        "993016236754471037784242071211338043212890625e-134"},
    {0x1.15ca8f95f7163p-444, chars_format::scientific, 362,
        "2."
        "3886940472478101815516002304586010705250369950263278520937586735205575920300597436987445133566199723253520"
        "9056220889611772034033406268425620639481665338487162539900951615422228233639702916913751658371808451818416"
        "1750465910278224501683266661880297864234626506047662879560009369157585287147781138669192147467158593106463"
        "12523018774953698084573261439800262451171875e-134"},
    {0x1.1c2c03dc16238p-443, chars_format::scientific, 358,
        "4."
        "8871215235872988435170790037236813375378604405677194217241718090326866560500874834949274333014957336071556"
        "9022758867015207526151988895553482901234999063630370884845462854314493655716813545090738801982175971799897"
        "9421127360512136790705971320293037416921996157365427902453505027610932303474146785641141022275140400955070"
        "0580088999913641600869596004486083984375e-134"},
    {0x1.5e495a5a5b735p-442, chars_format::scientific, 361,
        "1."
        "2048289504187995891459061440516981076638732120771659218926621650385434481812842556576460656624351028821905"
        "8966625819337939917796520503670154154436651304901717368743143186394807699935909156584679015642358410947459"
        "3413689541976548679931460273314635130483027907981785192792081387152832558721199653564067984309737744271471"
        "8438765419961100633372552692890167236328125e-133"},
    {0x1.810f44c622e44p-441, chars_format::scientific, 358,
        "2."
        "6488657681982224362975086519642031326070653599531695491298942136575989842374130913957574220303933630452909"
        "4287691741966627719771032423495762254409444179311243835772567386195458292994705194115642989850139200494159"
        "0588928963306893800268427406521691881809325113789150170542748396344959084162370306735064676678771923231964"
        "9187434862369627808220684528350830078125e-133"},
    {0x1.97653902c35a8p-440, chars_format::scientific, 356,
        "5."
        "6050315915746605269229572281796709012860726683120704776540492198506714810181021008440854108255765850085384"
        "6529071987618814344910087704317888361861949507041571302535319807153374858734455612866387542618405871469146"
        "7962651372264615689058812238015769309640382466140672015426133338338772381569455413477985178391665863290374"
        "56071233691545785404741764068603515625e-133"},
    {0x1.d0b06982197c4p-439, chars_format::scientific, 357,
        "1."
        "2786580967537967393170156267226710383127074452677704468202081316753593149446278054272379462839378967644636"
        "6320800166067176943939047031161439109805642265774803971575385755561407104084377645079662000061709133084688"
        "8569611013370819364101411249570919954868002270900165871976213924414176953438451896858275740510024279521401"
        "890935550227368366904556751251220703125e-132"},
    {0x1.7ad59dce3307dp-438, chars_format::scientific, 358,
        "2."
        "0848335483911190942323580514455303482680343446709325008703159284449727956557371856834417264871825204784953"
        "9318713541842166242449663027334071210292408400120764346191285493915664731350155622020867542388811251124441"
        "8594782642109557636315727983442346610806562372007733240534067389665742275872183681831213869255187963209097"
        "8955449855902770650573074817657470703125e-132"},
    {0x1.22c47def048eap-437, chars_format::scientific, 356,
        "3."
        "2003528362030216678821821948371825837897558579366430203164885731689848020333537717135124881473922701620992"
        "2888692730907506242357242214089838597240338986102464283276271560347056644198372344751496698973482209898323"
        "6068759470619965482251995605014430152608968389315404259797294622728604564411967070087013194247143227410060"
        "11785458440499496646225452423095703125e-132"},
    {0x1.d3be4f543da5fp-436, chars_format::scientific, 357,
        "1."
        "0296499233307166051409990566706604558221380043891789602456125181542044296852211953765862019485098933960139"
        "4420734357402502486292275942333853238461193404309849063372198452914528639370611863498197972678354451284120"
        "4496073458814758724065894241925219977128262975118574813009362420632733150442614970604109796889529120935379"
        "002954590532681322656571865081787109375e-131"},
    {0x1.fd62fa30b36b6p-435, chars_format::scientific, 355,
        "2."
        "2426394767283500572344787579772127805358981710503513931978178996544410137352679575618851857302903865882730"
        "1751992291035654960112926310959345577460789432200950261826623585506549029505895986246328713415363125428407"
        "0821805771156523871968356216030311242150331649720790515554019625705236196928987062872353517240543707960548"
        "3585709180260892026126384735107421875e-131"},
    {0x1.170603dbe87b6p-434, chars_format::scientific, 354,
        "2."
        "4568729171490546923419108015884002973420344879350156891911357332634520808703214918225650257080313080960162"
        "1140390889672566806744097301945489507607449341174694978874620449423462236080322660186527317970438773249144"
        "3371566819375998762229137926757890994877314033084529060250209190344653250494453969941105882736470645243131"
        "993851193328737281262874603271484375e-131"},
    {0x1.77ea54b4399ecp-433, chars_format::scientific, 352,
        "6."
        "6200607960369036504168364221207739485773877228613560172975009101038528445698754193218898779976326154511917"
        "3363842872316641841962349364203859251798613207224032137413479473949030378760712878146559509391806548214262"
        "6133671636697690281002255506343628331447342616711548975819904164047980593449147058277505601860937669428386"
        "3429291159263812005519866943359375e-131"},
    {0x1.93170d7796999p-432, chars_format::scientific, 354,
        "1."
        "4197241995605936318075317043001757935035457049201291955866575822547697829794624951982915510254185587423055"
        "9487389305607751617582700679057839905945613876060209570099889526685608968859022154545165173060918859596578"
        "4720429445370267692111528854939925241769500649591614777352662374519950927507309951396734409084237509869608"
        "206969360253424383699893951416015625e-130"},
    {0x1.ff784c52bc952p-431, chars_format::scientific, 352,
        "3."
        "6028982430553334107374243676082305559955741670713515214432745189797018506318167441511937904497465065161068"
        "2213475903496748485769939459318413756361660218138899061663084963748999691972507933997769029036491031713027"
        "2509703637802374239144100499997431894236097897299940723946702573929557957332859418318120851204621000324346"
        "2693944820784963667392730712890625e-130"},
    {0x1.5af297257d112p-430, chars_format::scientific, 351,
        "4."
        "8879393706963279061651865580809295809985896396271068785213668870613554247017676426461356877587014324609933"
        "2229707765029557354523950224816865264246462861886095699349276602653803989153158999090858568594116436322403"
        "7664050403023168762797067327883280705896601134110886320862615955338992676555453042929182604106022776158102"
        "516319559072144329547882080078125e-130"},
    {0x1.03b2ee82074fbp-429, chars_format::scientific, 351,
        "7."
        "3174892255233898487807636785800529379525766260573968879990028870309082137226413786970703775409476682616810"
        "4680726241144403907247560017629565271829849434655181507428399984635472560338317561978206370575594884945710"
        "7129514927443108698035930496633435099731335354533972538276537731498433942868404311764137596868821065976273"
        "843034505262039601802825927734375e-130"},
    {0x1.9fc2b88614a46p-428, chars_format::scientific, 350,
        "2."
        "3429620296922070165437262528679235149465662294858826443217125037749387447136789889409314083302682771001468"
        "0222756477338010049488544385369435757883115124974928734552290063202520905298185016474992670850977943921244"
        "0228311467969508963451461485549943141147936657095208040273361231910217912547166432836108378900052615079196"
        "98260593577288091182708740234375e-129"},
    {0x1.1c19bcdca8429p-427, chars_format::scientific, 350,
        "3."
        "2020192787585524090907938204703897171601201083956022918880219758055616705464752170779213045668342297853927"
        "6218514141557210930831458346531846588992803118289362499502577922826432688268564989495048351325555007141628"
        "6759032612040821481599308776899597909970425095316884308438864676280665908537781294443748170602858163502624"
        "22247396898455917835235595703125e-129"},
    {0x1.1d050f4eefbe3p-426, chars_format::scientific, 349,
        "6."
        "4247592636344160339866493641672423120493138167713318610601027318726114587010038633956202506757668116896117"
        "7536260327713435210153350074908844036866886983227957128782764805685483552587503499283051807011191846971140"
        "8579142730695650817051390788544338188841755967937911393061842504818190481891870009980858467139430006964673"
        "2254113885574042797088623046875e-129"},
    {0x1.11c71a2da956ap-425, chars_format::scientific, 348,
        "1."
        "2342695551721854116452683863845499880701888817578316467000565057081031681549617905907560256885144592305226"
        "7240083781534046249220963683438736274553173251428809235268476409175105649982640214427984817459457410804145"
        "4897293931112550425507422822024993325841784631941211847062895362538601302639805927337145199863994993183524"
        "684354779310524463653564453125e-128"},
    {0x1.ee81e63a1dbb5p-424, chars_format::scientific, 348,
        "4."
        "4587660431030845738140444950938925800210778297935183932030487301692384916913432314579352529747020633396157"
        "6718982792226559730910116675387121867734619940500817757656699817860412688243739129436110739866715672133838"
        "5429894258111317173503504684713165635003661117654688712321287868251005918630130709379141148930754401380482"
        "931926962919533252716064453125e-128"},
    {0x1.dc836471938d0p-423, chars_format::scientific, 343,
        "8."
        "5930403540130827014185033574850155045437600585425997369866718416666609027827328902822137151134768600284621"
        "6279124762562562326885970331685674789827255964644127407691554650046050256430460386721430959519718823793955"
        "1008802980430695929352329472514508171419493761170181627352450560922451007920075807096848500427066497309169"
        "7902418673038482666015625e-128"},
    {0x1.55264a312e91bp-422, chars_format::scientific, 347,
        "1."
        "2304010474281754010997831364457453532363710534547555388355590377279653877735542614715890519378694731622300"
        "6782910963684928592070655580364056608821698264700123403236140552502228229389995505527297808002861636424769"
        "2131602981552825675357276743670326242029680867553906299343023194677184192076335608358703832152999946281113"
        "35259745828807353973388671875e-127"},
    {0x1.652956524c153p-421, chars_format::scientific, 346,
        "2."
        "5763001930484683121866989543781242187607596461670705046008890509721150477966409285424037614285381953347765"
        "4997259597310460635607291805673065230273042570734235752898997793752366928544966510763348120931402869337506"
        "0230754644492619570048227210977560174685317157897957914242825662416808322569345838414941963958465498407690"
        "5748224817216396331787109375e-127"},
    {0x1.0a2b6e525e678p-420, chars_format::scientific, 342,
        "3."
        "8399042293533291316095939321676303114799213077840440281919805704609059805275974287633226980837249931736591"
        "0044710145437381439295690008968031009068382843451057480056121258710576890301225315461825406976833128757025"
        "0854349786862226002299989130792880255411596025381026026745679225130052848864003625387812494718087208411816"
        "391162574291229248046875e-127"},
    {0x1.80f3cf53f1e56p-419, chars_format::scientific, 344,
        "1."
        "1107053483914006829775982286940992882599488872595391539303723414330261552652730527139790712226602314231212"
        "7419956658436525690382907755165110589877692458034515109141334121688675583164152180022072392038346677920997"
        "8618498763060489316670378435241139862270569941618445758195740528710132038842602464041533659108718090635647"
        "96815626323223114013671875e-126"},
    {0x1.c6389b5e53ad6p-418, chars_format::scientific, 343,
        "2."
        "6211336846809098773276314685119387768693234190106735856477190922246722065339865398519354564344593251621915"
        "8248983511966078734456230097679988912873164107313981697736934498486708329908151477908573290741613410601556"
        "0829130407628536830946616731021905982268502134836446565495063653291366241897645429462270546400182169577419"
        "6996353566646575927734375e-126"},
    {0x1.55b26db32be1ep-417, chars_format::scientific, 342,
        "3."
        "9436012113465104438175990673990938076352359286600886903149796902820550632115347356375237735627780655402675"
        "8184464885274554100597829193095879346435654863845212628185087858146802889576223211174464307298442034499394"
        "8110429433813295989818119876936942903021691744560733604484421618817074472770713269558092405053795204139532"
        "870613038539886474609375e-126"},
    {0x1.e8a41e7181c02p-416, chars_format::scientific, 342,
        "1."
        "1279031828486725368285162812517936169788860166634935888590711537150219574688036629032895212853463959440650"
        "3650154654466484722168943018596890328292712388739910978936869648015362134240447110651890664773510091035844"
        "5188415389113650373815757025479195624246867750482014684485575007572491946959890442186741528474147600036303"
        "629167377948760986328125e-125"},
    {0x1.2667eea0c2e95p-415, chars_format::scientific, 342,
        "1."
        "3591220818753578967877485753540957219846849806734534544651217267891770002384398001643363339942878637947316"
        "6328302358041252417529977510170575717126095134299788618696349062141833073414504245591187769088276321436054"
        "8305459034386167488920945628442896474526151212066690180059060509561977041122748851645894198336694813633584"
        "999479353427886962890625e-125"},
    {0x1.ff118baa5e05bp-414, chars_format::scientific, 341,
        "4."
        "7186848778189670994069605940876219782781216914711086309942798924493013128851790778946762990913058749981445"
        "4055147105208148185524779392795023211756732677794200342825699871430136909959253091552973875772042184950963"
        "8515139692290002872112044140465990852885558676453756553237897954025802506482414042289106823058197903719701"
        "57139003276824951171875e-125"},
    {0x1.fa00c13d0ddaap-413, chars_format::scientific, 339,
        "9."
        "3438288096510300708206359179854147909888509692470353687641927888677731435274230558789286142542238872497991"
        "9291642304056969254290225288534313592005499287342065072705040637147124194333306505257478080943345820147523"
        "3518790218936634917638256885277056259540461483126252396164441218119171308576411058848150414934963237101328"
        "559219837188720703125e-125"},
    {0x1.665b3a489008ep-412, chars_format::scientific, 339,
        "1."
        "3234786366979427240557035972871836642676524574733744100764337150714243649312395488035954592443876672160155"
        "2453328962421458549925648630711638265850295574292128380162020867890736183395718452916357821887276692711606"
        "0686026545609252412900499832587222722510252054321150497353766705080322145596004049998388463205145626488956"
        "622779369354248046875e-124"},
    {0x1.cf3a6f79862cbp-411, chars_format::scientific, 339,
        "3."
        "4215813214105460697767882447548971368626256994487285819832925973102312220381249502362412524582654137714631"
        "1911755533093525433960566479878897896249684215009582527023317672508250867310488454244976076546569023883629"
        "7191957544621034981392176942003185295012273726522451681136015314107273762726204980959797408157641029902151"
        "785790920257568359375e-124"},
    {0x1.f2a92a57319d6p-410, chars_format::scientific, 337,
        "7."
        "3665992405027932576502815813307644287807305675409422460506005018551902720267819605398541423809769647828049"
        "9866977319501776335044121496578337140066670655016184682180563483630646645866140852592448554624381952636290"
        "6038236009913051704692368907667120951434121614917932393108410626345799351846363141934487250850338568852748"
        "7218379974365234375e-124"},
    {0x1.b4782f812a1a6p-409, chars_format::scientific, 337,
        "1."
        "2895722651891137630425330384438299474095155094770258996582306778094406533114323313551750471068869202418567"
        "6514306684322130376192414829153873010105653873073220980942636936455031716866157608940595168933427613117398"
        "1279045829482843002519751437286808742894695158893832137633512513924892098960289256708716676413928325928281"
        "9926738739013671875e-123"},
    {0x1.ee7af34b365e0p-408, chars_format::scientific, 332,
        "2."
        "9219365150591819869806878286596392558866811418403158078032655046272755506560359880667466294148560229158569"
        "4781151191877485626592838708956568599966689642307979951883892138750321041592672907937811096196078953938914"
        "7880920600844784042147871987802138706797121319153428637095263913657634075401623927059624463709042174741625"
        "78582763671875e-123"},
    {0x1.14a9643bbe260p-407, chars_format::scientific, 331,
        "3."
        "2696466282687585616618735095593104865627521210668173946224068440449703487453341173667423751071123364783968"
        "4085354894924673886100417360021334173102821673101378406750581340715944228625674542170598795643367302528327"
        "5837865087998562936760655026168055781811414767475009002774837970555003650418701005575528029112319927662611"
        "0076904296875e-123"},
    {0x1.0ec395f04cef9p-406, chars_format::scientific, 335,
        "6."
        "3998932062842191571304885686437603344672159589284746987272459342086482985695887045504776020852483783906536"
        "2172506322079792471903631811738029238588537100394070287934331478185936935198191455534087534416095445119132"
        "7942135351924917315670514758298955554619991631363968830288155815152759638969869613114860307234721403801813"
        "72165679931640625e-123"},
    {0x1.3d46e281947e6p-405, chars_format::scientific, 334,
        "1."
        "4998583170769895145258239667197277367953253255810089766774812142211547445430103147393926520164148452565746"
        "8217264380338598104855388663677112214256453366606244072120286151220936656003436396679154181835015100676359"
        "0584348966466807600606971155966424574894203639782754137091303494195009152389539124755613030970380350481718"
        "7786102294921875e-122"},
    {0x1.5d50c95200fb7p-404, chars_format::scientific, 334,
        "3."
        "3026285632030961027430781526695104834652824763749934105342216592027767938527528216746021154719645500132460"
        "6616794372108054609285611564286855905212986858383047108185221762771718705161049816532541785396613413881621"
        "2217761748227152819627098792981544023621850913148052426306024200164421671955248312885222716772659623529762"
        "0296478271484375e-122"},
    {0x1.31ebbf8025802p-403, chars_format::scientific, 332,
        "5."
        "7847010173866356658135714751782132458915473391965410419281395217763813953559535968598835173728934249636260"
        "1391514459957848282287968614420455369316177721591679287181702700396345255239479649102860468456508414192128"
        "5765602981762140026015686251155088703174799414546865824038807089051963687735763777753028591632755706086754"
        "79888916015625e-122"},
    {0x1.45f7b06a1b161p-402, chars_format::scientific, 333,
        "1."
        "2327531669436545124898364942880066252999983643906149889220149845403378792647983133165166313028540606985070"
        "0818436949056057893055823679249585303051312488233045352968305435308456249734196737179082525750979594444667"
        "7228676476284721228550824045540658730028149589335013698528738527418574216139323697360996590077775181271135"
        "807037353515625e-121"},
    {0x1.df4f5a7e05b4cp-401, chars_format::scientific, 330,
        "3."
        "6253358049975739948158532959144013335613046749062970323972515958518272146127656397527061651233015893692867"
        "0103303942817509059905956200910147442693283287995230815845232814920748801039202484840625264268960547701839"
        "4461232562723775452393614394463284378370218080769149758857505694173512387676848456319333990904851816594600"
        "677490234375e-121"},
    {0x1.ae574f97a96fap-400, chars_format::scientific, 330,
        "6."
        "5099035263477567697676239505583198082407067935910598028302046053953016881173914627929885947779143472525852"
        "9119807135344605329826410498881079099916276669949098538219094433024528915815827831019768695616878227040110"
        "4253286553344639621446432482400791768130297624278687916140708336692433937814041000624598609647364355623722"
        "076416015625e-121"},
    {0x1.5682e2e154108p-399, chars_format::scientific, 328,
        "1."
        "0362549937904696495909186260047111788995618647637336817784404369937467772175933363337212662356207536735218"
        "8030101548183531660454669558507451081374831816640389350098116044525532899664635039328699336476198997181098"
        "1611054570213321448002855193018317174796322288015370915456149081441713079385774642915407639520708471536636"
        "3525390625e-120"},
    {0x1.d4e64d894ea04p-398, chars_format::scientific, 328,
        "2."
        "8372763744588855358195664212326247986525884317469934762680318091318529844306906832798118576979789563617608"
        "7880787247738178476250311898177500090645985936560651576500379515533764989527583633204112961828419907248472"
        "3993397281384249852781206296581626131873567108627993360107656068926314295395446629655111792089883238077163"
        "6962890625e-120"},
    {0x1.8405785281eebp-397, chars_format::scientific, 329,
        "4."
        "6957762796709737155545272375088190271165041022145719332035280937122606597820767289040881062663178655971790"
        "6800163258532738477839926886177406049478443972511824178578427468672843486576511058856103122000518325560094"
        "9669432592376902045278403406836799158321502945965980280664261537807858390208490262374141366308322176337242"
        "12646484375e-120"},
    {0x1.7eb41af181b1fp-396, chars_format::scientific, 328,
        "9."
        "2628413735990423976072574727831848085171853809438809598495177277610358137788162151768704610738207393586717"
        "6239925229724538135518882743778801921512445790917757600220464043852992967680900899632107966724376688268527"
        "6343517164257771308795820514969012334125522761495819641199962003503392009209210788966970540059264749288558"
        "9599609375e-120"},
    {0x1.812947dca7db4p-395, chars_format::scientific, 326,
        "1."
        "8644654417675819487878768291262887764232591738129708040196998864550979088967279045136490762476499773291512"
        "9620812439715211609748176949969393845599259659318287218077670995102127035337504860737911557372641561128410"
        "5183442729822976469520193988570188951048643143750502460453397587635942242792475020962683629477396607398986"
        "81640625e-119"},
    {0x1.9e33a8306e02cp-394, chars_format::scientific, 325,
        "4."
        "0100862103638260260327403702106109516070843800804666499770138974502808794721389200773475598343085572822186"
        "9050575652000849999783616094397321798140965240453403340309552058549632349997838495783548076103129101125761"
        "4639151880210011426990683848939531260460233147640120904706864264441669009481072905032306152861565351486206"
        "0546875e-119"},
    {0x1.fc59e1a319ca7p-393, chars_format::scientific, 326,
        "9."
        "8431817833160122601313212773122942893409910851546209354885728127108295688976875179174547748983566433413213"
        "2025798622516539150550515346244583769585261311971860204677532235067528321744733234706537880403917023842260"
        "7574806660943207182365054888572670670918103919236001613298781456569337992498769374094536033226177096366882"
        "32421875e-119"},
    {0x1.ea48053546540p-392, chars_format::scientific, 320,
        "1."
        "8986595125046416834783391206475835197011693029669966155263156671691418830838428529139208448680176162863118"
        "7695816852367151953603093414023513472452231891026909148753713286042719755834756149864024108431735261809022"
        "0909719089204136527578336674363112487531886729182570991963930462755397177154748078464763239026069641113281"
        "25e-118"},
    {0x1.c4f7cfd35c403p-391, chars_format::scientific, 325,
        "3."
        "5083205445088968495677101873388169021587210288068562220603066512276293052810916395438868133171298860873211"
        "5906573028050475979768658205494632257575125878903299547717299838346765905333055749041027617447665836622709"
        "1941304109695520879458424636283604303800109503244258137414372793865533547291724048022842907812446355819702"
        "1484375e-118"},
    {0x1.3f1b2c8eb7534p-390, chars_format::scientific, 322,
        "4."
        "9430715648584051844621127511504766932271831089032969572932369896232697013659331467295126281359728019366715"
        "0223703961334976370441319425264759617856817683619261680544917442005575369381757511402108712309881085300325"
        "0818301375453449086706715170921583482977020013786182723813883417931808877954225067696825135499238967895507"
        "8125e-118"},
    {0x1.d06093b0815cfp-389, chars_format::scientific, 324,
        "1."
        "4386748780689463441172008927045007293630513034969496905804592655018261534900625376938437377392865739866729"
        "6615558447456358810107305126537258821495219592310542410906686690234000177678885634217857624515847833430176"
        "1013692954086773103893646129885982191773115862652319223214584781092291281001660507854467141442000865936279"
        "296875e-117"},
    {0x1.5f088215f30e9p-388, chars_format::scientific, 323,
        "2."
        "1750535480226043651063968030552837701335419048796120873289665746737982864577869182423674166128902294355190"
        "2567578863327434873478216467219071537837824503113360190943651743419094244810729043431689094699067495426602"
        "4495878370083247028266065338479497333757962125955769283174403691587467726820115387909027049317955970764160"
        "15625e-117"},
    {0x1.1ee7b2b7ec4dfp-387, chars_format::scientific, 322,
        "3."
        "5554120237464134602694119759921381410530091439238523194592402342557057246628016063414378639043829736854188"
        "7370053506577563972296682322952558114285158990250458154246016563621912592790284052637737715198370177263940"
        "5405211316069492320708638950783578941509117218036792610026741347911943130766232457062869798392057418823242"
        "1875e-117"},
    {0x1.e5212858a9ac0p-386, chars_format::scientific, 316,
        "1."
        "2023735450313651421171538785871176726817036060881631127943497279521174527072830335195052010261740485366509"
        "7035885847417422710449856594985414474195173129388921911481901258066228860986222371389439608412512086611891"
        "34406624290828135248622000380630662078487158618897919413632808909031535193889794754795730113983154296875e-"
        "116"},
    {0x1.e5a64b660de0fp-385, chars_format::scientific, 321,
        "2."
        "4073250149223043677529942257093521551685293966172209099803476112751766606813967498557515485126803686976280"
        "2509846959709723111928491817829971430314205791200580751789038145211771394494147327366858698467104394248895"
        "4039058477399630531971831293463019719488441957560055472393256961109557490186006134536000899970531463623046"
        "875e-116"},
    {0x1.a4a35c112380cp-384, chars_format::scientific, 318,
        "4."
        "1701370789218155692754228746962316110046975782997471789899742477944413513185760207420533618377892337282650"
        "3369609111243586518876985010803989860785855249416361813452820232507673882731452960098324300662753351543989"
        "0605798534521182860496797973742972290515095803870329475781942164640259118613130340236239135265350341796875"
        "e-116"},
    {0x1.fd84aa058b587p-383, chars_format::scientific, 320,
        "1."
        "0102559419519475794201171450381673041089322627018053899889380695208263228396234959442210305668054031580026"
        "2617175361107992065273974530599080955152985761274225519088885807436325575834309377713847614939429333357521"
        "3736221842600597238671029059811607467346072347130676068618442925385256248027587844262598082423210144042968"
        "75e-115"},
    {0x1.8cdbd7659dbbep-382, chars_format::scientific, 318,
        "1."
        "5737569358633547811206080917170425167450411520103815909249604594369345874856545245212805027522831482869727"
        "9497837821986319825226191691030482601360852618520169586052322172410999244763978900894391063989290727442929"
        "3647733654219928166653100454479140789463860010824500467182821754168198236101261500152759253978729248046875"
        "e-115"},
    {0x1.c3fab70ff77d5p-381, chars_format::scientific, 318,
        "3."
        "5846791147293954395277110210507684652698239680639314917967800036918115365251759384633992808617776665470287"
        "8948196800507852844357586424000876576667554483947866806149903563073606011829317396890873012538987787373457"
        "9886342475181978767165737092606523456123743582322344239764951045502938686837524073780514299869537353515625"
        "e-115"},
    {0x1.92f9eb50ba810p-380, chars_format::scientific, 313,
        "6."
        "3920642274634331751536794408261143575334629993511050648872666338672571665986021735206183246506631631027507"
        "6674090520833858863401291192443279548090882698094889561395443424178066943634531052696735508613482077083274"
        "38532663382585063040866730643823561567323258792113871334440201865678687909166910685598850250244140625e-"
        "115"},
    {0x1.e5d12025f41a4p-379, chars_format::scientific, 315,
        "1."
        "5412187845587148647082679443541904930956627197223735714308064939313678370864379713857586412466743837378721"
        "4477045757622973435427658211214451056290469467722605684096423425588572056824523259270347609435702307410245"
        "0187989051299157133388192780303421949264106738071728509661029345167992943288481910713016986846923828125e-"
        "114"},
    {0x1.70cc20b16cbc5p-378, chars_format::scientific, 316,
        "2."
        "3399657115069453242799372427454858441916409637026741437784068092438045672968038993507346705421009607546622"
        "3270999126531558453930448337869948963043039837440559106704597253256508416121847397066754992986499963921290"
        "46637675265839770011966526475548357054437982946807154687712923708808876455123026971705257892608642578125e-"
        "114"},
    {0x1.f8f54258baa23p-377, chars_format::scientific, 315,
        "6."
        "4077707249453147734571294870181459497973836656567528268148064225575734467252266106733401529485664591286872"
        "5537475815263199419956592789659795423138900495943348557937327067031684374451512495466067674240016165733527"
        "8642566121441607503387428396992405649535766870058376239570482012231078527975114411674439907073974609375e-"
        "114"},
    {0x1.b425d7b5baa7ep-376, chars_format::scientific, 314,
        "1."
        "1069178065391464118041197835859986853981823370991214279644651068058195236576781864336459899685058699818985"
        "8389076952457334918508095427607000023790685113724227614589746900778059551210150285899771549942676809335780"
        "216735649319371255941752281553265395319094745377493328576212587577298762653299490921199321746826171875e-"
        "113"},
    {0x1.35f98a9945d86p-375, chars_format::scientific, 313,
        "1."
        "5733958801672790951911831966450540333286901510422187698245081061936132440082110172995513811552188806194750"
        "8483008380141477614143817728347389618471096913538493454947739839883504613082714342355282868320572300743114"
        "95047375197878671140995642548351193717183402608319281064104371015144323564527439884841442108154296875e-"
        "113"},
    {0x1.22b6deb90a23ap-374, chars_format::scientific, 312,
        "2."
        "9512643039682987271607130402882275984250978924222980866335903775679967461152359642908392339478572995711210"
        "6711158137101871047341964134538644022448223316135917805111115721985676440930948226211551129468067801597918"
        "4580368796271490374849056743260859362475989065448386808516480217523536566659458912909030914306640625e-"
        "113"},
    {0x1.af8b9b949bd33p-373, chars_format::scientific, 312,
        "8."
        "7618958399039475289411495157932994119285940106393630296173005536001515294054979103676044947610677490024580"
        "6433762089986893052332064562978271936803143494243928200924114342896992504891165235980509540813946170682297"
        "3867935359995281054682095411461508824847074251216971999141856775050740679944283328950405120849609375e-"
        "113"},
    {0x1.6717d5464b378p-372, chars_format::scientific, 309,
        "1."
        "4581718353001727202767958474568085509641315254096668946517258054929653338668760014668801958991413536588583"
        "2166422613380830543504451930921550793798367298723049105942703198978517102345816708317809381648497621791749"
        "0144653395402570757209661432587925807640507185377121211582174264975719779613427817821502685546875e-112"},
    {0x1.e82648ff239bbp-371, chars_format::scientific, 311,
        "3."
        "9644645414828138173162257943342753791936726404197770155908477143700013008038105686863030846404367750060424"
        "4814244967592799688033858650321919135290377962541541757670567069855566579894393167253937584463430211194847"
        "838410815447232136167099214308805859745088063782002314890638705602299296515411697328090667724609375e-112"},
    {0x1.e51cfb8657ce3p-370, chars_format::scientific, 310,
        "7."
        "8796103616943104296862864926637808976384305685460046349264971296098085718108590424082442044168977749480870"
        "2928472617532638674178490816260470459625717085681235305001720392192877266453685066566192314061292465692667"
        "01975452020742004266052294229064688879217955185466426624822655622182310253265313804149627685546875e-112"},
    {0x1.b14f77ac7c51dp-369, chars_format::scientific, 310,
        "1."
        "4076373030698913279542894696649495363335439496734696510065477536845414461119135429499341627348207442652927"
        "4935947857370618330448711125058799086304561047878820957561978470428392090947171839593614746022113900576819"
        "12459797630302957798856517266927440740025132710425346247752609318837357932352460920810699462890625e-111"},
    {0x1.e710d0676d8ecp-368, chars_format::scientific, 307,
        "3."
        "1645295789429928436647975840549801301515330036544211466830277436202701723604780666991621823155867912659398"
        "1980338448054215434328683248511272110006708490433287132241742891859869273554563583159617428780711727619231"
        "33899979676544387692632814983780063270773577183589647492112373328154717455618083477020263671875e-111"},
    {0x1.681e2130ddae1p-367, chars_format::scientific, 308,
        "4."
        "6794637406214600552685009184111994631046788070673294911846952958589294261135845244842000381052918421797166"
        "3686856630365424161431494428961656868717060092984824469137024087943584804835372179942601678375223467571832"
        "515625537071561402276458569226060997833551855877904268772582430102602302213199436664581298828125e-111"},
    {0x1.a823fd627c74ep-366, chars_format::scientific, 307,
        "1."
        "1022787950727771717610943243155103519105415962234389134639983375075983585745388621128252129251831360374758"
        "7200078501494916601004074837757884294948649378776832588867301852289741497219317204928696589057736588055220"
        "25872507231167222528685303920977870186585482457331214116436068906068612704984843730926513671875e-110"},
    {0x1.4154d3aa34c6ap-365, chars_format::scientific, 306,
        "1."
        "6701855515857908584747803132448487756483101832993797232975308804071919095972790016154322704905670927038588"
        "0494132185610153140585022535102018358801929938831640361250668541664980168293360212741724810288220079797390"
        "6720466201397769120663869839685513950245652908075809535415334750041438383050262928009033203125e-110"},
    {0x1.3a9ba6e00a75bp-364, chars_format::scientific, 306,
        "3."
        "2704792321346139269395198188310864980762772459780219667337880506418288619313658795189633157901844118202961"
        "7959899821736910033629581384546366449781130238868918794233156215017316457250215443260494499049530118568527"
        "2846413113018197664085143742641569449064726380745830695839782009670670959167182445526123046875e-110"},
    {0x1.a63e2539171bcp-363, chars_format::scientific, 303,
        "8."
        "7787729275384650464205839686581567124783107846404487702633668032504537138009690656495102209028217361135521"
        "8390388558973430219290482843591529548434600383846735395604846042341730293207372906214891355297527580963516"
        "0087896703692795742861281764048566296912514108556450931342141075219842605292797088623046875e-110"},
    {0x1.5945227d7951cp-362, chars_format::scientific, 303,
        "1."
        "4356894911231067898171923164012923523397719956349474652622401817264054835179242430812570726867562039556960"
        "9395820536576981686866835269785818676298857562755446418526260219235762960808818683579213832173570812722647"
        "1309299601555074913893102541253974308888834531656129855914372228653519414365291595458984375e-109"},
    {0x1.82217c782aac0p-361, chars_format::scientific, 298,
        "3."
        "2111903570682555570830432285106056350808268235667287036759585960084214919407425089581154098784074762322198"
        "4762123193423025747805649805390981226048331145080309572679467705818692956022292826723774128752395133008996"
        "84678865465498234764125959913015552026947590190386616626483373693190515041351318359375e-109"},
    {0x1.098f6dbee458dp-360, chars_format::scientific, 303,
        "4."
        "4169724909246743271783375837700448384399037383754852175667172815642110900066699080460389447141005868057730"
        "0512595879015513339295564000425906636050874382230874106442651414859196934264601320288039760451686440122377"
        "9211715551095402858460824838483699891256643499837415689501796123295207507908344268798828125e-109"},
    {0x1.fc1a3e0355565p-359, chars_format::scientific, 303,
        "1."
        "6902188100294218634935247637485270281651549319941796535330082790416249513368727689884420951594130215709004"
        "0184990306867018953130130856037669985663887665299573761002835240263686645156373136524713074576393774585196"
        "6064973879549502996367695229140698130020298981164052209980042107417830266058444976806640625e-108"},
    {0x1.9d22abb8a3e58p-358, chars_format::scientific, 299,
        "2."
        "7486157518272163198462750357234962521840564791749654630448944205121330934304735487728385237098477486960962"
        "5847974164498179204746922062216049657612246741906384781995063278488580462198784747628586625522717685501064"
        "683276474702628786475061222493509474216607179307414465796455260715447366237640380859375e-108"},
    {0x1.8fe6b364f92bap-357, chars_format::scientific, 300,
        "5."
        "3211348201503955918326994712215674983015794087547371314733947107537140792678543657825063978585635866620708"
        "4197313956182668385962971395188922621807236400003448458010002652773369381707765820726202495191307008424796"
        "4985873179224173871150940905947186618917750283892786899997418004204519093036651611328125e-108"},
    {0x1.3924fbdf3f4afp-356, chars_format::scientific, 300,
        "8."
        "3334785623935782116298108685266686643370574881636034800871153561094144663382514150166540391974744686871180"
        "6417987830668578413862355044420640648941380509579676293326802058743764083969551154493102801167674568470045"
        "4921274138664102521131689349566080338539705656651646048516113296500407159328460693359375e-108"},
    {0x1.59bba3abc92e5p-355, chars_format::scientific, 300,
        "1."
        "8401463566583057000467205063624781534185149195807291439532371443811570882259925022763641473815090371969689"
        "0884731353588984692080088307661553053498541608357827654845057209245110680041052095293937588746057055307668"
        "5104080099519938253964156154017020428131091156799536978638798245810903608798980712890625e-107"},
    {0x1.f91ab28f6d8d2p-354, chars_format::scientific, 298,
        "5."
        "3767844238622670481304274663876506600784579490273356231591616804154663121136971131851337071593432079006723"
        "0801406917418121743555085258692970299942364812832124045965349670231901635472698014492910758725217321403406"
        "44845226572809529157488064473891307432846836840412141356182473828084766864776611328125e-107"},
    {0x1.29815f4575ee9p-353, chars_format::scientific, 298,
        "6."
        "3338293748065631419556714682364874673867676285049644451673425924784138630592498292679137715512703719066539"
        "9099547436808253509249037923744258894826392480910340657908008256358036815594577611142878960404510461173969"
        "42666747803151643950824239942570360031580162414599488585054132272489368915557861328125e-107"},
    {0x1.9b5549ca69f66p-352, chars_format::scientific, 297,
        "1."
        "7514400642486577219423056529958168455121436480387689214857689064489248433753353045222356747974792138413681"
        "2907705310492578831489120381580810440200883241625934295912642633798054015146534242980319769381134505869389"
        "4271570763602292963970708357409197599381992481448744314320720150135457515716552734375e-106"},
    {0x1.124b975a88735p-351, chars_format::scientific, 297,
        "2."
        "3358765579576565334772675826735107157872544630083091706192581114916616667385249065695562210242645649633370"
        "6045442624764341660639114681090349749985529232191675913872702599912722915102318783709303584090894615368605"
        "3705913497996218739612629046751784994643955963022907695858521037735044956207275390625e-106"},
    {0x1.1562e3a0ec3f5p-350, chars_format::scientific, 296,
        "4."
        "7243986610495878878673984778734765597249236867292989667607298760616960219054966616029202455795780518195146"
        "5005795973444987034101304350852038218864051288571350765414212230181767935792865589673805453295871045943135"
        "218617322658165475074435295648383851079801960815007788596631144173443317413330078125e-106"},
    {0x1.7499ec4ac4fbap-349, chars_format::scientific, 295,
        "1."
        "2692169671992971794859529307417627065586882159206511522850272309303557550875672875281941705264110562532404"
        "3962157386294274558513375437279520372365842188678652778085743847538559542383103862214745631648353208671844"
        "45964579981005077479106468489233703280283545311579729286677320487797260284423828125e-105"},
    {0x1.2027f877e5c8cp-348, chars_format::scientific, 293,
        "1."
        "9631316012898760223014058906912067489377912540647879826283094146946912960752087047972415846827587026831640"
        "8529836716359055729125867701272323663315317923152316903512706305527763621084339310460970385816269376507207"
        "732386773493842387889323502724040878468329818229420880015823058784008026123046875e-105"},
    {0x1.3ebd90e3fdeb4p-347, chars_format::scientific, 292,
        "4."
        "3429894872560729418193397434044195297928892591241402688768517638740285594212782549821378697599010953184725"
        "0001479148556894299716929279968971252973761365088083456011722548856128988536198502330225503216761835636784"
        "70959217821493701938086947191985055989095487749551693923422135412693023681640625e-105"},
    {0x1.4363389eb80c6p-346, chars_format::scientific, 292,
        "8."
        "8126165753911829296073940994630312372578087100698810179318575514900600400132302692737889199062390479419949"
        "8337013660830380592269111943379641150657051580457441463012673490810863644239815703741098676074978193264928"
        "62699285514009118677994236229754579522131796576189799452549777925014495849609375e-105"},
    {0x1.36a0109bf8851p-345, chars_format::scientific, 293,
        "1."
        "6929662136678211488078955588025689249252946388568113517812621468398839813210730900263559495041405947214123"
        "3023424598961524341866409500482279716433603612382080707599516239910317980701008812896983399390264869857599"
        "436031413554009831686140961859092949411305373264013951484230346977710723876953125e-104"},
    {0x1.852936e8160a8p-344, chars_format::scientific, 289,
        "4."
        "2420016230315380894459699263590074580121107948381560051483582623204545213465113172292812816818464247780754"
        "9945914113013415578186602251423255710110678586170729782875957266034899743601335079915348892173656670268744"
        "05553342866483389551396854187976397966564068298112033517099916934967041015625e-104"},
    {0x1.149ec7bfca2e1p-343, chars_format::scientific, 291,
        "6."
        "0305298093927812974371236707006850466550484837899433998791788439447945090567504761728273446428158503828027"
        "3815680772046816887312242613127654618110699752592730180526202629349727603958501864226949792627071804458332"
        "9530560909162178292548227844095570554690255438146095912088640034198760986328125e-104"},
    {0x1.5b2dc6b83f4d5p-342, chars_format::scientific, 291,
        "1."
        "5137520077480203129736786547797218619270753778448891209064918076463125636944869989096240366834149603449714"
        "9622117214819752421125106211299219496197133556427938606464103348868389804966690375917611422685068708804532"
        "8321041443260516963902382193582509786917988936494339213822968304157257080078125e-103"},
    {0x1.da0f73386d67dp-341, chars_format::scientific, 290,
        "4."
        "1339493171608475510736380563699750629156862226280416325731522075378368999604060724669971773099651206101216"
        "1017546178458942728313191490202170666992385689982184609191280290273663347725787965403909863535334056723463"
        "899330281266936838654482799695804640972840449109071414568461477756500244140625e-103"},
    {0x1.638d3b1ba2bd5p-340, chars_format::scientific, 289,
        "6."
        "2010359315134640090731319437049206220696431274480364487068426341395584546604605252648624919716507113178716"
        "4770913020638743635294940380183735409118973050619962086116661476750520741067204022527272515483696214789128"
        "06267420333330775690907300282423840649681512360302804154343903064727783203125e-103"},
    {0x1.906c98f786defp-339, chars_format::scientific, 289,
        "1."
        "3967279728811321015556380205763949708026110141846978466576526561943061094238322509857317048680101516109209"
        "4059480169304313282251175137756521835472643562161874889067638864262324158569496198868632887339727876854190"
        "94620032800056105071229529844130628872533872453232106636278331279754638671875e-102"},
    {0x1.758b9ef75765dp-338, chars_format::scientific, 288,
        "2."
        "6059428457609154486911302444167565685187311533784113372214336570808417256412519024956191525183770555440174"
        "2351821205386265043059591636376635678882878599304488236849642358298092440065200725936048618574206149773742"
        "6327712363547867434874089592920722198432503802223436650820076465606689453125e-102"},
    {0x1.7b53efecb0cb7p-337, chars_format::scientific, 287,
        "5."
        "2925657186107486696662256436218499175870505461474569242666233854160474625850779906598158267271520849939229"
        "4202392215141578825785317356572899446095010353693470459520062697277725597854451377947127151669409262676817"
        "805963710919477975920904905105901332162954275872834841720759868621826171875e-102"},
    {0x1.c70cdb03862e1p-336, chars_format::scientific, 287,
        "1."
        "2698160651847152511134198109881258456142759956828081770588497598811394283191928496354871928599416248545921"
        "2624831316216668122250847400605418281738828454092443406664370924540263061336400427843941139863146710024305"
        "866123781960021918923744815065946835164201189627419807948172092437744140625e-101"},
    {0x1.c8620f3a56118p-335, chars_format::scientific, 283,
        "2."
        "5470706341249348902221902622568371957573968152993335291114182491469056877577567806133288792502362191377384"
        "1104198106509806681478945672264147381937969112303470510735230530092792306517987071863243310330652402455664"
        "18482483161473301224825995891891394773409729168633930385112762451171875e-101"},
    {0x1.6de527d45ec04p-334, chars_format::scientific, 283,
        "4."
        "0841165079066422503311958952355012554890105582329316527378510871501269657351408619401715479431010259110172"
        "7331888613681649927397941295691701840380977033084709459930029994062241909437403184233652851218799652841192"
        "43738253055377647337106095646631909179546937593840993940830230712890625e-101"},
    {0x1.32f4268de3560p-333, chars_format::scientific, 279,
        "6."
        "8524262499820672910465946411140257927338084441301598854658498719088905756918548930722944195040062465232121"
        "2741194099526199284333586848262300092485070516184133947332196308672745095179576985257273100178992879756211"
        "3861611774779207012072627762389043226676221820525825023651123046875e-101"},
    {0x1.9504d4e40f114p-332, chars_format::scientific, 282,
        "1."
        "8083260374699234761065257773418498730106022787616035325598600451327358187952165471790323439179847122950235"
        "8546322993371696334394192802862629454251406168400743329730917576310927470940241674403303605819271810565651"
        "3295101069735058671395240667729986672185304996673949062824249267578125e-100"},
    {0x1.cb9bf91a5cf2ep-331, chars_format::scientific, 282,
        "4."
        "1041218769683543865527782587708994321977282570253751835355176353868356467589133067113662048462713562786916"
        "3689797540950303302913366392376656159255697944455891223668807057168630685792060203335559517088803685034984"
        "6654097283173859379552553760216182521247674230835400521755218505859375e-100"},
    {0x1.534d1a72353b2p-330, chars_format::scientific, 281,
        "6."
        "0596402508961119571296495219413977960985088664161517023286865497038758610911606257218864532266059908463494"
        "3566866588930258825411622537414066336047894439146752568610278062157672883821538692535856116708042779936221"
        "736077402161935015293480030935946434311745179002173244953155517578125e-100"},
    {0x1.8a81f0ebdd183p-329, chars_format::scientific, 282,
        "1."
        "4091162264655094096918422902209131451813071235940686704267979933905629962370860646608701739601729195398426"
        "0348123961816264514026789687986440107830948993608087358064153065552612602602023499720117578184592448397117"
        "4376577529462311334822327015502130276303205391741357743740081787109375e-99"},
    {0x1.2d8d843b6d359p-328, chars_format::scientific, 281,
        "2."
        "1541940438019324865167028884178297080890453228868603437885007477923378991221330760569498464981192644981579"
        "9086766356008861141722682975426269705872292139055342559529362293475470513544579470179567050581508580483092"
        "766000531858470043399035620014514424980234252871014177799224853515625e-99"},
    {0x1.5ae523c56234fp-327, chars_format::scientific, 280,
        "4."
        "9562087398984028798002675205915029145934162551746287076478264141066334902604617021355261270418382502703079"
        "9012887618525302370636569884647253237361252245553836239316100690838738298913987463032565645940507442438449"
        "71395465018007039720702891320847083278522404725663363933563232421875e-99"},
    {0x1.2e2fba4d55710p-326, chars_format::scientific, 275,
        "8."
        "6348821682352886680448613345699107777997779283593013133209274283334866227298574857315844433891549697529806"
        "3967453807178597920834220273761421926245222790190624072541898839336096889584915861533631101787200214097731"
        "755254463696422798459940983750726672951714135706424713134765625e-99"},
    {0x1.a8866b54f8da1p-325, chars_format::scientific, 279,
        "2."
        "4261340414990349785900555645144753836486017984360325092686326468941813894749700948319279369699030354562016"
        "2128067628714222500858744515024250725224913377594619406969777600338582044025172737970786616230297899138581"
        "5415528011949603900100570948172862273395367083139717578887939453125e-98"},
    {0x1.f1a5726eaf292p-324, chars_format::scientific, 277,
        "5."
        "6880342032875110801140107811674257242681040973129201120356046066242525206668362776013267547666870081864709"
        "8697301511059933888881427408978800238200024191730958421845191572140573277862850372978086195948703239443239"
        "55228780749141742495715752536700193786600721068680286407470703125e-98"},
    {0x1.449fb8851eff0p-323, chars_format::scientific, 273,
        "7."
        "4208207048148695360887516750671585448954709948122751839360897930189242396581441749888939165021423228508336"
        "3595829634393473133215432271177697513478113798725154449792965648309451308710292572224103743993982360407449"
        "6105070814565044206960464645561614815960638225078582763671875e-98"},
    {0x1.46c05ddbb1318p-322, chars_format::scientific, 274,
        "1."
        "4938910681786228098433397618427083905000278780570950467448198038274216732657666002119768524178303625459142"
        "8113514269539148166937605854031616806544458143119642972251690661738492452061452603871892869715803063032290"
        "16720368895964772527028274762272985753952525556087493896484375e-97"},
    {0x1.6b11a7ad03ce8p-321, chars_format::scientific, 273,
        "3."
        "3198659912779944591755497965186522112578908724555826481398937929092451620495530950235419850252258210723507"
        "6103357799725303807187723552061327603203139944318751411700583753118403087341835633246108094769809451825572"
        "8458429841924240692903336213959164524567313492298126220703125e-97"},
    {0x1.35af01f0d426cp-320, chars_format::scientific, 273,
        "5."
        "6634316286537580410549627430526563174209683489552393365657133589081290878698891065102827260170613964063421"
        "7988490623562854632880516016770172038156097146354316708909596705851523980277831473118340477805634968266611"
        "0387736739752007997066030053900931306998245418071746826171875e-97"},
    {0x1.dcbfadb8b3393p-319, chars_format::scientific, 275,
        "1."
        "7437369721819611306370401524320874706796587550801634394374128782974215775486231933474204434212241812954672"
        "2253205431824225310790378426225749581112311746779383635732956570294552148059878128300037030766362232845415"
        "610269516394232537279639083660498499739333055913448333740234375e-96"},
    {0x1.e33f175f87825p-318, chars_format::scientific, 274,
        "3."
        "5350054379821040281789284265976009753915056027158289663573472460364318135080456532420187970414666391602000"
        "5749792748196365536928031655309360101630870384004441686023479759971468723814758726445507263978188305294501"
        "66237066652626089735718395434815874978085048496723175048828125e-96"},
    {0x1.754e6b5cce5f8p-317, chars_format::scientific, 270,
        "5."
        "4615606193444131862109204544103266030868122735855760371810669285382344869384517529242953427788269452822158"
        "6447733355524512940892011377262788258325539802499302096414943486531804678941620226371353010632838705878571"
        "6076215004574612686683021678391014575026929378509521484375e-96"},
    {0x1.8467156a708c0p-316, chars_format::scientific, 267,
        "1."
        "1364847491964381755809073325658806539668735063951189927636831017735890051798137008661548359628176249486567"
        "5638355075809542316572770260795609472341017048086809154108791537763758262439106114402680050430718549937605"
        "4984664105996887417671104003602522425353527069091796875e-95"},
    {0x1.895d0eb98e49ap-315, chars_format::scientific, 271,
        "2."
        "3020007806568932024585160896856794015905763244531581751345471550226462732325455222444774590029231192793210"
        "3526585809434548954819303101741588289887271759169385050668460900964752827696537189730053914236112530299498"
        "78718850332174066138091195199422145378775894641876220703125e-95"},
    {0x1.40a747961380fp-314, chars_format::scientific, 271,
        "3."
        "7529890242406666427809537541355673359784524729918599611738936303969683643463506435674045097086533000435903"
        "6833805751251437135871962069969241765350603702037415332674882077174238682833668617350553945267812311343474"
        "50183664810112785757689746191090307547710835933685302734375e-95"},
    {0x1.3b6a90b6dd82fp-313, chars_format::scientific, 270,
        "7."
        "3833844812933601001626040712223208545049894159172436674233731756578183832102588069235339862415563708591953"
        "3290144340614000151931192578763645062459485049299914120235431773959612511632269475578724910553760753162725"
        "9035773503789072506886537183845575782470405101776123046875e-95"},
    {0x1.29a514459ca70p-312, chars_format::scientific, 266,
        "1."
        "3934768122159904445853290075552856512674507704664699177572841136493178162330742824621681098250948372789843"
        "4729750251456654416423830571259374225337974011611156252922037258169533613173818100385793804677394622735141"
        "766994054388605073224738362114294432103633880615234375e-94"},
    {0x1.0b74c8584ad3ap-311, chars_format::scientific, 268,
        "2."
        "5042865665627230013905293764731537341817933131283917087004920122084647344228898478210371710543160857493563"
        "2236939001136948844407029210584627234019763143896970351150846985824258803274296439361886009001435481001665"
        "10812608939716590594759537680147332139313220977783203125e-94"},
    {0x1.1e03e68fcf7f4p-310, chars_format::scientific, 266,
        "5."
        "3561230856431216215705891197384170210658872854832333041087321234180910038318181672802850047733820007628560"
        "4182171685972328799651035840891788773709992554797907500387843891228116979454940850233766623349333385640802"
        "273842934100485380088940701170940883457660675048828125e-94"},
    {0x1.713e883d649b0p-309, chars_format::scientific, 264,
        "1."
        "3829457207184735000646794778614053460940210246011933848384018350432995141075648085203697000208221493806949"
        "6871105807765061634200805943647551922633019924217056463629491090846563741317220831180219308859755163461485"
        "5151721147207000139900401336490176618099212646484375e-93"},
    {0x1.86281c91677fcp-308, chars_format::scientific, 265,
        "2."
        "9225397297013291485340291504603700336599579795115816142467807020570283454539177669728489061469790947015462"
        "9997814087950868773198110436893831741279455750950609447941220401713815828135354829102946691124843423371622"
        "00459380729210268068385403239517472684383392333984375e-93"},
    {0x1.45504d79391d3p-307, chars_format::scientific, 266,
        "4."
        "8736427954876516111588556297323223735366132652170239201846287920067706228596656189402267426246839952413216"
        "0049764777409257875974799672905922600908337766650300092966930614776888318933855334348681166027395590583966"
        "769997135959867351484575692666112445294857025146484375e-93"},
    {0x1.8b65fbaa5facdp-306, chars_format::scientific, 266,
        "1."
        "1847214117665037958349200111689262962159366411777270344855697272453913854959328881800526601044047876095253"
        "9508884510689090450544760680794078282991730837875342801146971856602898038792043608811629235497645397056549"
        "789557803741175956435682792289298959076404571533203125e-92"},
    {0x1.15b31d81ca8eap-305, chars_format::scientific, 264,
        "1."
        "6641279667471598281077652098259945521671295549362078378109870769039305816240186759177203366513405424353633"
        "0530761980743920794284685177470701845646722007722289704781280982002937652274421398782929157293977334017839"
        "2330593955435180664181871179607696831226348876953125e-92"},
    {0x1.eac3901bbf6abp-304, chars_format::scientific, 264,
        "5."
        "8818504424690985169205536700281187606567042378602631203335310164716217466374569085773532485133568172286664"
        "4136317480410796037360933641727560690299399698464619034628147686482037707302630902387957209311928858323561"
        "0316787898670110035226343825343064963817596435546875e-92"},
    {0x1.54d51a8657184p-303, chars_format::scientific, 261,
        "8."
        "1698158411107261909593405947137163967522047624097756905903111770746755936496192101549234847884183779745242"
        "3170474746072782115324967751585643030135116010607593205418148559244337424314958917190348394072848060723705"
        "5238019525493786687775354948826134204864501953125e-92"},
    {0x1.4254ea10b5973p-302, chars_format::scientific, 263,
        "1."
        "5452699464889383084423290711151957352280795463335067223992351392751481442851664811520430139228875639213995"
        "7443372996563698494777793436879534495292022436992037556775109404800293598056714392374950920150650171867569"
        "806873131225966044866027004900388419628143310546875e-91"},
    {0x1.7da943773f203p-301, chars_format::scientific, 262,
        "3."
        "6593953762901490298980465769951165569165929629731813929605504263224870936440470834287500461898098845461917"
        "6300712475200183741800575688110181618613341186483104049336857735772610014290974319446787969336623844116806"
        "49009906106383649415647596470080316066741943359375e-91"},
    {0x1.ae4f00acf5c6cp-300, chars_format::scientific, 259,
        "8."
        "2516607665957782806495449548266610202563683706678154753337492221892598865851270347456671454474309415340154"
        "2947108353765710923663409929467862648030890496688726139045114262386812243844497274555150209350984257558006"
        "30762397396278373662426020018756389617919921875e-91"},
    {0x1.8295f42a5103dp-299, chars_format::scientific, 261,
        "1."
        "4826450102010817711210930923040416160476151525185906279856054958041241077876390807571824882338445071789251"
        "3774699575501451998966639677459705092394758161469439414273380135760573163439712286440819442904694661281541"
        "5837368683560359983175658271647989749908447265625e-90"},
    {0x1.abb6488a3abe1p-298, chars_format::scientific, 260,
        "3."
        "2807475032115240062100233478393094020251354181481746915075124012767501350915592204090764547211207441234158"
        "9250311944676967760616784054804356827548506333595288049246369690491136655894910770418537088388769788416740"
        "388219995649965454731500358320772647857666015625e-90"},
    {0x1.48abffc61d5a3p-297, chars_format::scientific, 259,
        "5."
        "0421279276628866771404917521343449655818410102699411247766865670698511764154971706103933661501555850943124"
        "6691132567436980119815055690200132903971131676335235354630998904758603124455624172088445296120063391046502"
        "32281999711059228275189525447785854339599609375e-90"},
    {0x1.68d80a54d6153p-296, chars_format::scientific, 259,
        "1."
        "1071352931313987677170263865765649059990762705126667526251537731419538691260092093877617025045125993875951"
        "8957282035594918033530304494227577752017748915004609937482099729275688967497784979892357979608435015250917"
        "52096634223345716918629477731883525848388671875e-89"},
    {0x1.2c6b77467b856p-295, chars_format::scientific, 257,
        "1."
        "8434860272299224398646710148202596071649163719074503710061903300320517800432749157104831068290668987721246"
        "8288905577843079932802656060133153397763658738705621885098366210921463101614640108441163625096848957520139"
        "530678882078262859067763201892375946044921875e-89"},
    {0x1.6ef654b64f428p-294, chars_format::scientific, 254,
        "4."
        "5036297145461490155658473901364871637444212817199245336544093047170635880998585764076422564090558606666255"
        "1938086353343001846340281510205158335022043844604870268243750850377280010291550976095751246698891426552117"
        "424331189710073886089958250522613525390625e-89"},
    {0x1.451173235af75p-293, chars_format::scientific, 256,
        "7."
        "9789499766966189057432041933294408174821133119234321595322590241361258550194960490787811861606827978987534"
        "0580669985289732544810391373789920254660051031541038369168888736649566723608062419701182989006022283778749"
        "24371282450152875753701664507389068603515625e-89"},
    {0x1.ffacd596082c9p-292, chars_format::scientific, 256,
        "2."
        "5118610569922106564460984688389187692141330531682768924103863645054219481499842629645126936078591972527872"
        "5114722222435312309709437730552329335737166622168597422045113087432814378216341861796310595179875161588614"
        "82397368636299006539047695696353912353515625e-88"},
    {0x1.063332099741ep-291, chars_format::scientific, 254,
        "2."
        "5743284390384121121339828370307253704732203904243798931630246226927879139516091842410667400769648561814006"
        "0967151854945291742251165941694548044712489711348582758259760078958923842987028079231637018004530552653017"
        "459741047190391327603720128536224365234375e-88"},
    {0x1.96f4c617754aap-290, chars_format::scientific, 253,
        "7."
        "9911430601386120440060711986378002682633187804808109392328090664875747637758557400825900344026788010313343"
        "2729113699362461043666923313670271869280829318221799503990742364295320472425956004990574429576668221347291"
        "24604834993306212709285318851470947265625e-88"},
    {0x1.935ccb527a6a7p-289, chars_format::scientific, 254,
        "1."
        "5841152817579089701888246464101800895048854300815732047427000213855511213199411158696917835920060194040385"
        "6832944195530241996774628793343986472070897672191257541684614583042669447587509362813108117841725100392066"
        "653831601996671452070586383342742919921875e-87"},
    {0x1.3b5e38a2262e5p-288, chars_format::scientific, 253,
        "2."
        "4770739864851201045215521130565488910183929199437325725631421672722396652413988843021963416616140085403298"
        "8566619651757547235989152653761825101443066623967176924256056621254930876323270126516930137333399219767881"
        "07482736478459628415293991565704345703125e-87"},
    {0x1.484a5328dfd67p-287, chars_format::scientific, 252,
        "5."
        "1571453461558414690975411195843410181665902370366403386781820716480868872616970347287285000078485643033558"
        "8701703489523571282053738369007553845016143803485386942297636126664238201721806757128415840988374615235911"
        "1636354072061294573359191417694091796875e-87"},
    {0x1.34089c222a3bfp-286, chars_format::scientific, 251,
        "9."
        "6778617084384446515856594489186391560274790969791576420550050955675959857565171616414306909257785259034695"
        "2362288345318732779856813605993054429873501524126201190913398770745075709628316629547843926599154360294018"
        "084598377527072443626821041107177734375e-87"},
    {0x1.e6fcdd939cf07p-285, chars_format::scientific, 251,
        "3."
        "0600555655865200534976772197248794399591456706189630865265707040418808227552314886557434562051285553829030"
        "0716886533358185718261901052219893727742299836868360224318883583437603674338252457160623503337061100215525"
        "655254822368078748695552349090576171875e-86"},
    {0x1.44926d40c76ebp-284, chars_format::scientific, 250,
        "4."
        "0789867108393157187752948756264703859264191233331053076042708075185293288917985839904448038455228974372772"
        "4796581245328847896234645778426859241054384479033713048023996115476263476953358964540485263635494439472470"
        "30717306870428728871047496795654296875e-86"},
    {0x1.4e29f7527bdc8p-283, chars_format::scientific, 246,
        "8."
        "3990628635128793878113999378017349458345655285229811951413205941895445655212208355669760623316311014944192"
        "4895587056060013769855374324172459834228975819398443536073706731699095978262061796216568521405087480863338"
        "4560607737512327730655670166015625e-86"},
    {0x1.8c68f2953a6ccp-282, chars_format::scientific, 247,
        "1."
        "9927178266561660444642125584749374937520778851582251840153437757893208705737778210140182563707851211680549"
        "6000088093483500136470476092352988612163262395625243307278830900372908744130530715872596772314013667190546"
        "46381437123636715114116668701171875e-85"},
    {0x1.daa11a32d930ap-281, chars_format::scientific, 247,
        "4."
        "7718392311175778496834201787015006522460756370577250546037300400638004617260362478357013608710612128385322"
        "1779947181639233169587356613212047538343034581376134935211933499518225742900654242594724446526025006878879"
        "43087162057054229080677032470703125e-85"},
    {0x1.c877431c64f8bp-280, chars_format::scientific, 247,
        "9."
        "1784544610577110087548536112667514918507241599449782305683393170457359980388202548163671022362647074555117"
        "2116019074929067384595406042749373380753064107605729164133086776553397098585026443014794176607191273850605"
        "56179041668656282126903533935546875e-85"},
    {0x1.5319d83c3ef66p-279, chars_format::scientific, 246,
        "1."
        "3637044518063170854462076009090508461307355230988207158833822119619060364687943744832686726236043170915496"
        "3514036585997359479452159849171388489220331093611734663524586436250473091482431300623345135401918559042711"
        "0099653873476199805736541748046875e-84"},
    {0x1.df184ae5a1660p-278, chars_format::scientific, 241,
        "3."
        "8533883620323423714136812889341534099647891816418950569082704468822715181673302421954378737049884964815594"
        "9225657910076871879456492908086055679238145888180249016876041212016385323048783306274907371194102245759438"
        "57416859827935695648193359375e-84"},
    {0x1.76fe5bdd1cd6ep-277, chars_format::scientific, 244,
        "6."
        "0321909257448322486188799696623295177021420540236469007302485328870820788061538273852486152111947182499602"
        "0430389313128435058945575768397789160853250945403152483495552579619178531893547143208613567133330110592304"
        "15185083984397351741790771484375e-84"},
    {0x1.e827f6053cb84p-276, chars_format::scientific, 243,
        "1."
        "5705072660535393121974894551856858865391970566370239367261961889364900750033565832132944807855682429973423"
        "1165743808838199193559492724914123351980041439654289592979913822692992177082452061483603995980466022652777"
        "2692861617542803287506103515625e-83"},
    {0x1.57fe4f2319e0ep-275, chars_format::scientific, 243,
        "2."
        "2134072641839148014616350155697182746271787657512992252495965052383531821160101822839509773517719903367658"
        "9885091166977969534942621043863491561694472421479566604474002796800759780876778117908416951915753084767501"
        "9458620226942002773284912109375e-83"},
    {0x1.47d634f051b6dp-274, chars_format::scientific, 243,
        "4."
        "2188963156964790091976855129879663206858758676041114580017440270985892530256344542758502021499043746143513"
        "2986767861064045946038194991469606398275313429723392840792584921040979778779308359876410281397596940822225"
        "5196960759349167346954345703125e-83"},
    {0x1.ab161f2c4f9a8p-273, chars_format::scientific, 240,
        "1."
        "0992259537194823078078492322005134697759069190880982299089476477421890699462556853397689401906770390979778"
        "6076941515468432802074130342767290219697959626185832487110501790388370592167474364612702816563355456835893"
        "1646798737347126007080078125e-82"},
    {0x1.e291ca105dbf4p-272, chars_format::scientific, 240,
        "2."
        "4840542381260295931026824878265850213738163806945569103735598853085085998454192004270399375665114378419793"
        "9339093426915978383823920259991198886269275880452442035925336260690735668115500978992897615927476495656378"
        "5744947381317615509033203125e-82"},
    {0x1.05497b2f09b2cp-271, chars_format::scientific, 239,
        "2."
        "6899801291961049649259897509032221460182990193199573687789715730498841548008680282752621494050089364971956"
        "1463605015707114076093509216799977300670476900145388353293690677054565291249211441112205284685587880488810"
        "696988366544246673583984375e-82"},
    {0x1.5c2e8d0a58e74p-270, chars_format::scientific, 238,
        "7."
        "1691442839152966800651789754421125674555953045807849165758253326495394357218725180436693959779826838539023"
        "5241811586085690413191170438571390570469553243783321439188124683995544413425828554208859124188824019086041"
        "51685722172260284423828125e-82"},
    {0x1.150c7af401be8p-269, chars_format::scientific, 237,
        "1."
        "1408995211686882396999673277161942905911769631008359348308702974525173207061901437452806284674796790066877"
        "9068752395048930939229325944194026364434225582687841188243409709254873786228664105033274878825411136062939"
        "4766874611377716064453125e-81"},
    {0x1.bb30e9d725359p-268, chars_format::scientific, 239,
        "3."
        "6501624740693435787870241089127783673137622073205114014170416150615960587516148133472666902880108394136902"
        "2414280357161153404157898726888077804987981004743248455675731222748902769395701614578618140506682809842686"
        "765477992594242095947265625e-81"},
    {0x1.8e26580dfb59fp-267, chars_format::scientific, 238,
        "6."
        "5583965679406291322543386377247490770669733923095682391871457649122662052805566842350436869479069566624479"
        "9577994068697065802161796337967353919150253326164238823498761305697129755079000741114120557814781697913986"
        "13597266376018524169921875e-81"},
    {0x1.2ebd25a1e5a0ap-266, chars_format::scientific, 236,
        "9."
        "9735404360143309836615940606941282378612316332479673006818986372431047284827499250652587489448273074521490"
        "7159098256425409638672402820464938454137381883658245598470175431363044393496375251856344602841009105986813"
        "665367662906646728515625e-81"},
    {0x1.430c70559fa8ap-265, chars_format::scientific, 236,
        "2."
        "1285263571540235575696332659335516392967259876634974541900328449762481882645550424221520486704326122874324"
        "5389964017346232785164042207656441873771873947372771748143644161220111890357661173789620596974447863658497"
        "226424515247344970703125e-80"},
    {0x1.b37b4c8d42152p-264, chars_format::scientific, 235,
        "5."
        "7386670202301382796372027888070564929201692176971669630590876089659777060558652704543784738546830046295004"
        "4603280725800304057600452205270691087995607476359238776203611756090465773659736699519777827771527256572881"
        "01501762866973876953125e-80"},
    {0x1.e7df267017ba9p-263, chars_format::scientific, 236,
        "1."
        "2858099560631301338481970648325266446537589188919690394573293863678630154936269933032378796467868286022293"
        "1313596145811383746152520746396771825426169624107483758544143530277325048406906936058276443024528390424165"
        "991134941577911376953125e-79"},
    {0x1.24edec18cb7ebp-262, chars_format::scientific, 235,
        "1."
        "5440597737151946460972322931613150367282007839535034780293980553235893087580481701735620945314590019229682"
        "9903029002040487140597712979475535950195881357446664740641123548932565198031098388959129683040139013883162"
        "98834979534149169921875e-79"},
    {0x1.e259e5060f8b2p-261, chars_format::scientific, 233,
        "5."
        "0850413106581489843264497391468834239896808424048302785732446399420840399817211944222782861236400064717650"
        "0292091292079844810287479922800960523182642683648046932685960291959579642015772043086609122131136473399237"
        "729609012603759765625e-79"},
    {0x1.74c84ba4bd4a4p-260, chars_format::scientific, 231,
        "7."
        "8598917902586301437063592700391486067845391377030263724566219385264035315415509521990392844610347274677649"
        "3187534013093110305784267349454320227788828198489207064733005870559642487953084957850308223115121109003666"
        "7883396148681640625e-79"},
    {0x1.63e925b45db68p-259, chars_format::scientific, 230,
        "1."
        "5008325529570412331623540869231822246729874856884866752807101484418958561722149716692008029675745594666613"
        "3503364128985836668117456388387335023474589528561716496306845300111545482800773821004114427779541074414737"
        "522602081298828125e-78"},
    {0x1.8cfb3f3c5fcb0p-258, chars_format::scientific, 228,
        "3."
        "3480454826799275168273424149426024516039420592697674339471485209977799621418170443904530724423345933811752"
        "6732740417275913568885136319985690578200693894309818221260736539715042738901337997931006995600000664126127"
        "9582977294921875e-78"},
    {0x1.f7c87448db5fbp-257, chars_format::scientific, 231,
        "8."
        "4975685812240518705712137865350408669165500059723872621242165482954565097487677179811044593228751800199178"
        "5436537587101247795788092235280018313908274894860537262681387520877021653599208068138176619399359879025723"
        "7851619720458984375e-78"},
    {0x1.e5fc8e5d48f9bp-256, chars_format::scientific, 231,
        "1."
        "6394772414307022630918211937753726342439186922700005937997030738726779071510104514297590583407610112272420"
        "1605153941665901729175616786406066510329221717620551523250096943414433377873453800532138613377242108981590"
        "7180309295654296875e-77"},
    {0x1.ae03e4daf2ee0p-255, chars_format::scientific, 225,
        "2."
        "9013155013751830433627264368121165637564844007563220302732139238380508640398659878415626116750234917257035"
        "4358021314491547644576387223565138757629841448907671848335714372372538869101956521268093069920723792165517"
        "8070068359375e-77"},
    {0x1.1b8ab942a6426p-254, chars_format::scientific, 228,
        "3."
        "8261180450693601910659987374822551200498589347100111087127385186891707357059664475499120073190271709835810"
        "2333262835696749317479762874812949441156340532185274119802689659385649761565455131279156475443414819892495"
        "8705902099609375e-77"},
    {0x1.0c1e462c5c1cep-253, chars_format::scientific, 227,
        "7."
        "2359827219547880037182260980171407807010957821836862935778233916886051101359252066396988945460218716415299"
        "8058217929659776342575854014888159205157469067456314240460661266281712378036264886327355583262033178471028"
        "804779052734375e-77"},
    {0x1.e7b34d78e6948p-252, chars_format::scientific, 225,
        "2."
        "6324142915079566794044585228208590792665767389780345214640856391021186677025555855415331925777643406404267"
        "4815827159675201972348758945269748619500474089457136522536683890735534662775902542408701378917612601071596"
        "1456298828125e-76"},
    {0x1.19f7b9144e56ep-251, chars_format::scientific, 226,
        "3."
        "0439003831515615676336056485285756533835399224529189344052214824595214456119324049792258875343600293464605"
        "0603560529499605598396432199482500999142131561233177111438702268476676808609806754168936038240644847974181"
        "17523193359375e-76"},
    {0x1.9243a3c6aa988p-250, chars_format::scientific, 223,
        "8."
        "6850539709499319555594997827933889454841898663613334205733556673628208790371074675294281427261965075820622"
        "1271882727206860063168834267557287655720959306207165641773755143610896424207282184859479912120150402188301"
        "08642578125e-76"},
    {0x1.1fcc03dda0a29p-249, chars_format::scientific, 226,
        "1."
        "2427314157729456479934367418834492113980183267925625403583281509539683257573896953625230295290581867933513"
        "9867126855919765889486660234790771255321938873431482613218900832291311030712967558575776649831823306158185"
        "00518798828125e-75"},
    {0x1.89816794283e0p-248, chars_format::scientific, 220,
        "3."
        "3983797108077041005965221970144927011138697559396869782925070589033970948834132451537407163528766580562328"
        "9119716016152060124454015265884051674568238114179095340987075753721931596282312959544924524379894137382507"
        "32421875e-75"},
    {0x1.c60043d326280p-247, chars_format::scientific, 217,
        "7."
        "8416589235876873864289188382541268098206197299049393893562552331589852548698913622637238112143222399360991"
        "5480134465272471761419124295424633425260765943378864906926742411121021916753370817332324804738163948059082"
        "03125e-75"},
    {0x1.80c28d4967c46p-246, chars_format::scientific, 223,
        "1."
        "3291407760196483165741511994194910753052570869084757495085032652859082885914003067026860815170496007105388"
        "2420687980563833583212875833639219887705559466700038838126004537916422394141710561221714215207612141966819"
        "76318359375e-74"},
    {0x1.a40c7ce612bbdp-245, chars_format::scientific, 223,
        "2."
        "9020896579031938453736117362122286671352965063235487145399744925912078407328282009772735936130948465580980"
        "3814778028095486508264623146907774784542240889474784632658103007257975695107679592332772244844818487763404"
        "84619140625e-74"},
    {0x1.efaf47443919ap-244, chars_format::scientific, 221,
        "6."
        "8493063311021444285262622630853901019739233598253225435361636963656204227414135855331310041156163827176413"
        "6297086180878976214390376525714424271780749287936058534182261326294307462493604621300846702069975435733795"
        "166015625e-74"},
    {0x1.7500215776f19p-243, chars_format::scientific, 222,
        "1."
        "0308144847135353771186145298171097410301970246782425463944124259742140545264889430363986396035589042598392"
        "9655776844273240873118061640991963182770593248030297396972216312970955988826543547887126806017477065324783"
        "3251953125e-73"},
    {0x1.4a99b1bcecb64p-242, chars_format::scientific, 219,
        "1."
        "8272771233005929132884988427301378153940847425631690632810979503758848344768354506461635004842080033192263"
        "3901401061824934045326281599520081408691385773308746157750681691937582554891017494469451776240020990371704"
        "1015625e-73"},
    {0x1.be72480668102p-241, chars_format::scientific, 219,
        "4."
        "9351506696419103240061669265502256149959617111583303561219685377261392905223787116563640644769825543047758"
        "9988217137215046802369061635078622989986340228461792966116610916308424326232051626561769808176904916763305"
        "6640625e-73"},
    {0x1.e7a659213dfb5p-240, chars_format::scientific, 220,
        "1."
        "0781250168794165933748349260234324391026463879289947053114193829482841759135318917268811758748161809004643"
        "2679611225514535349967383908198802533763640615597337848108680394109407845240622414451081567676737904548645"
        "01953125e-72"},
    {0x1.8490c51f45e0cp-239, chars_format::scientific, 217,
        "1."
        "7181272168700195560600399255994575019168872251009996740322328861948515810175299840150713970748225557399786"
        "7396379335700002769043874836031870998424017159999796374606522132792154819447283387034985935315489768981933"
        "59375e-72"},
    {0x1.e2624233f3ae1p-238, chars_format::scientific, 218,
        "4."
        "2659307529076216561467963956055319316897246968344236420579031063442725355740818771410564719833709091988943"
        "0309795900282398265726189862458374678051097719482165551080831781337690013222729845665526227094233036041259"
        "765625e-72"},
    {0x1.d34363be146f9p-237, chars_format::scientific, 217,
        "8."
        "2644256896671227468821316614503358331827205136754073205926088157584837967768526931310522556079545315620199"
        "9752392611005149405019628407058574516126059240841495119417818289946466372986044746085099177435040473937988"
        "28125e-72"},
    {0x1.cc0d98a80a987p-236, chars_format::scientific, 217,
        "1."
        "6273802065732597896113817387260276341030974100457666845629201763813055943005389152933610589184732283144369"
        "5959054192608060281009150208042269805343768362769324987082037382895216212630451479981275042518973350524902"
        "34375e-71"},
    {0x1.0361a6687dab5p-235, chars_format::scientific, 216,
        "1."
        "8350586944381437658146209039595796622558843610506614077602816551920309835339246680605412417590509836746350"
        "0907317990415345399158177353222862249035451776703642604718783418757486330941119945237005595117807388305664"
        "0625e-71"},
    {0x1.334f6d8947b79p-234, chars_format::scientific, 215,
        "4."
        "3482861542842136933757337627047159251109583384931118811727977153338308729167124422446490325358280576021385"
        "3128933592905108885143475829591672376873605604435264983395219417897960278995839189519756473600864410400390"
        "625e-71"},
    {0x1.305f84a10441bp-233, chars_format::scientific, 214,
        "8."
        "6134539761559003805548061531588022181123903542512485056622016306145283431381871224850727794432398272373581"
        "0512724266920229223820220601910535835876168753169487298805997950229204618288747496990254148840904235839843"
        "75e-71"},
    {0x1.c9b7f3905ce9bp-232, chars_format::scientific, 214,
        "2."
        "5905952437250455635059237293015822897473731806321263112212662836451190738319086758301231709882273911943529"
        "3270180444466210678654003519384812165597482919674043077699101118816990552140566705929813906550407409667968"
        "75e-70"},
    {0x1.2cf7988d814d0p-231, chars_format::scientific, 209,
        "3."
        "4068276481875121106288335315725238787330858093186688658099540644480044178549555509113134844354121258224253"
        "4525917021069896218436602993505532330186491208047744444804166320805993706244407803751528263092041015625e-"
        "70"},
    {0x1.2439294be562ap-230, chars_format::scientific, 211,
        "6."
        "6157007521363805395917512221628507674702476236714185773792545977038289879884140448995517698614722807482564"
        "316269955719701793397075413905783271318826294501086750761564164204087123977160445065237581729888916015625e"
        "-70"},
    {0x1.7d0e7e36e5257p-229, chars_format::scientific, 212,
        "1."
        "7253632008143088480986275464805616259466461047557408455579172771296622170925567796958477645145988934861094"
        "3280541592636736407336659321916801029023411688490517352222660438058887688583808994735591113567352294921875"
        "e-69"},
    {0x1.7644d51f65057p-228, chars_format::scientific, 211,
        "3."
        "3892588392445132904880849439603103583240865854698042092539617889110357535583974094512848897341060231911715"
        "668847206489491686550142284002714273859791254064651550505603955741606991836079032509587705135345458984375e"
        "-69"},
    {0x1.10bed5717b54ap-227, chars_format::scientific, 209,
        "4."
        "9397904291451873909412488950158690757659293412589473529426279864502529323852039218836670325495060439451386"
        "0826816969882247207957292424991122060599367981196290341226848470690402592708778684027493000030517578125e-"
        "69"},
    {0x1.97ed031bcbbe9p-226, chars_format::scientific, 210,
        "1."
        "4776181570075499135778399888179597296465432706936910908693639807173018504138725021329993525857491897140530"
        "58229777886958874081655166914945387334176236365795347469506899364122265438936665304936468601226806640625e-"
        "68"},
    {0x1.e87bc17774e5fp-225, chars_format::scientific, 209,
        "3."
        "5388392753930521569458603056975605427089057010706444537751899483971678103585409044068753689573306449520087"
        "3620048630042160735560641391063978204063233997161090636218434661575127364585569011978805065155029296875e-"
        "68"},
    {0x1.4ccad3c275ebbp-224, chars_format::scientific, 208,
        "4."
        "8218563385773112223108708692854480026506826778318969834120319390327162934136818773749592474331651671060117"
        "997507815882786838060737091655122402328021117440941168240798979371941612726004677824676036834716796875e-"
        "68"},
    {0x1.5a61517ffd9c3p-223, chars_format::scientific, 208,
        "1."
        "0037463923948035398952377686954725695708749868243331851405077722286769296317670730594311068901851751621982"
        "905208845752049158036704193593034774538757502752294448392761903876557738612973480485379695892333984375e-"
        "67"},
    {0x1.3760a2aa6c254p-222, chars_format::scientific, 205,
        "1."
        "8046301120677577831156523273751381553004340805312555968258097633741380875846144919225810181030729661426063"
        "465509289312072911372495984143831747178764135517056767525796712181573866473627276718616485595703125e-67"},
    {0x1.b29dcf95ce2bfp-221, chars_format::scientific, 206,
        "5."
        "0377562652737656740740431834806965092754376110615663711189065303770401719757724363364437831625604535900905"
        "0665914162340930680631398943831178102597624583278594631650763868702114223196986131370067596435546875e-67"},
    {0x1.3aa4a3e7fe35ep-220, chars_format::scientific, 204,
        "7."
        "2942263641848924709791974333318552392922497189413454562471159916381061755863392570840931492118884350692330"
        "28642932663345158882507360789118899600106765970543491284065751312226666414062492549419403076171875e-67"},
    {0x1.74467fb9beca1p-219, chars_format::scientific, 205,
        "1."
        "7260576914043516299667521604544099503136894225460607729102546218393499372203570873973193901356203104541651"
        "858702919756674718058411944198830741320724457610150486788942736371410546780680306255817413330078125e-66"},
    {0x1.04460adf3c909p-218, chars_format::scientific, 204,
        "2."
        "4135211264249107986888028696130084430233119968060816832629237084810043354459709587812751305641953795863448"
        "29510636863294535714465088337298135341399152847190355737107270162056238405057229101657867431640625e-66"},
    {0x1.4821325395af2p-217, chars_format::scientific, 202,
        "6."
        "0855030282997452019447514867331630657468044127645732990093511432831652591240656693499304388331948005719576"
        "291647734019028586433069197626384835517846818553661819052591486212122617871500551700592041015625e-66"},
    {0x1.6de490a48e2fep-216, chars_format::scientific, 202,
        "1."
        "3571719432209208961682291759079089652207854358802144505639464668566870317288686062650570379736789869557706"
        "865220772694797664743714525554547694672115452339483210146553471275865376810543239116668701171875e-65"},
    {0x1.9fae33750204dp-215, chars_format::scientific, 202,
        "3."
        "0836891319146542654621676435453427927985346471540079478265100941925579218917725745363008519792667726936509"
        "578521025584579103122413515433971308009849425461816976347384500201087575987912714481353759765625e-65"},
    {0x1.b89a1b615d668p-214, chars_format::scientific, 198,
        "6."
        "5371343011973150852898838767014285054009170245914920231983714940724080952210572962111819974100627028808120"
        "47091371176364709303433877377005013842865407407861123856296359235784620977938175201416015625e-65"},
    {0x1.1205bf14b82bdp-213, chars_format::scientific, 200,
        "8."
        "1312459641492482081166541589604817706874171006980185066355810432118883401318669273227828384881320643830327"
        "7572700842855620364346413336010642698923532080491406205668969420230496325530111789703369140625e-65"},
    {0x1.38bb74b2cee28p-212, chars_format::scientific, 197,
        "1."
        "8559814129506473866421804012367533608804583471137464959335795734206066943305396434753643633830322823523500"
        "5214453273509006641309435920997178527079040475538697363422357966555864550173282623291015625e-64"},
    {0x1.22a0215ce7d73p-211, chars_format::scientific, 199,
        "3."
        "4495677626158958674214395696919224233179649058963110430872447723008494208841922384319206038046498414808280"
        "237161710744628525006862200491884428522247284967078805040241462620542733930051326751708984375e-64"},
    {0x1.43e2f21e78901p-210, chars_format::scientific, 198,
        "7."
        "6887156715407682591023832286745406614960750239691936325646278514953457227545274838167326206011205999045631"
        "11087521684757125178339608488309602901621649250645841588980289316168637014925479888916015625e-64"},
    {0x1.a6c0fc50fb8dcp-209, chars_format::scientific, 196,
        "2."
        "0071439114262729837504870375731843208174931765110570173322624378508420496349832547945412094836606565794537"
        "382968664101699765520520611518293913512915851364397379352766392912599258124828338623046875e-63"},
    {0x1.a43598a7e7224p-208, chars_format::scientific, 195,
        "3."
        "9901264509201541515385647530544570777756931329657382905939255041595638020778163201073900580091263032608950"
        "62982775705487829263395483122897991853489149519963741230554887806647457182407379150390625e-63"},
    {0x1.4514380584fc6p-207, chars_format::scientific, 195,
        "6."
        "1736189512288787578528448418416349991749663700847809784694461643519721427376584527516757457805346764750442"
        "95637676288210916584739439369126886970047830556322654427248153297114185988903045654296875e-63"},
    {0x1.8641944ca7d95p-206, chars_format::scientific, 196,
        "1."
        "4822815568311571387774347113736553185061762803960083516201697860528424266401203404618141803921229407587221"
        "857702493025749782597434002635293362003405325086520527566591454160516150295734405517578125e-62"},
    {0x1.f6b995ecb51e2p-205, chars_format::scientific, 194,
        "3."
        "8189270099686453656944330386880851242990199456831493480657744929486472424859446314843153606613176940390537"
        "7110208626473460382988566967594883564850175212447569439433436855324544012546539306640625e-62"},
    {0x1.3d552fcd337bcp-204, chars_format::scientific, 192,
        "4."
        "8212075626309096460733573704691029512918454861204396148089296640492675485760690343627691702192822676968815"
        "63389639383199305786840112696187596685076424095350855481001417501829564571380615234375e-62"},
    {0x1.c5d7efd89b777p-203, chars_format::scientific, 194,
        "1."
        "3790405547409108597572348642030233030506653548234544771446962869832057530013194054847840729805753756239288"
        "5414951947851272710887256062334379377993422567498515984851792381959967315196990966796875e-61"},
    {0x1.bc2f329491015p-202, chars_format::scientific, 193,
        "2."
        "6993809501677146778769479910183262199839109507301803802721972810548917211929893732348630965943238348446579"
        "057907037793339112719528261592247795018823419872788793583140432019717991352081298828125e-61"},
    {0x1.ae773e40a5fc9p-201, chars_format::scientific, 192,
        "5."
        "2320218954487896785355755028514760124845743029055888558216867850774043141361941613159031705933056320069790"
        "15834175581246399137582629331561177468584472767532123071987371076829731464385986328125e-61"},
    {0x1.54177621d4f18p-200, chars_format::scientific, 188,
        "8."
        "2671699641426339340820628302131200394314879529639688939193883369957348095154029848956018262827562450461879"
        "9767543649932136066178729407262731386312436254737434637718251906335353851318359375e-61"},
    {0x1.8c7e3d8c73527p-199, chars_format::scientific, 191,
        "1."
        "9276428005917081988903274894497209583789235200873622102196547773359677427329917758697233946248094995833163"
        "9251543454284154774391128234192554058215314342905610800471549737267196178436279296875e-60"},
    {0x1.1d175cef3afb0p-198, chars_format::scientific, 186,
        "2."
        "7720738716829783366211423523072899760981646584179840305538218818577604522061421136502687349701011005022293"
        "19779605131760929109482801560084493683148998410814556336845271289348602294921875e-60"},
    {0x1.4475513c62602p-197, chars_format::scientific, 188,
        "6."
        "3097149258933373555396693520858956722428887774266681519521577936216995977632340581826830951793982217486997"
        "0049426645388404390460596730442919006912917689877673410592251457273960113525390625e-60"},
    {0x1.777b0397564a0p-196, chars_format::scientific, 184,
        "1."
        "4603881466067395019154406506648622335799728217146120546120015685836648701405196240311851355498324046529694"
        "693589869018846255688032266344721977514853339386036168434657156467437744140625e-59"},
    {0x1.335f347ccd407p-195, chars_format::scientific, 188,
        "2."
        "3909749954573929098486304712726443669214066244454384679654334105674731318682311463077318753893093869615216"
        "2587410648990459456387497476367966217701381548277339561536791734397411346435546875e-59"},
    {0x1.cb7fe420097c3p-194, chars_format::scientific, 187,
        "7."
        "1486821832535713452582704014218377603862581434335880398190116453503559511534348413760937020125432455684447"
        "563995618441814110812057986298391571637449171117140167552861385047435760498046875e-59"},
    {0x1.2b9e54a754171p-193, chars_format::scientific, 186,
        "9."
        "3226518683238715224399565661749611547006242370061528887320716195165308684845154101442598457938086015001409"
        "04741554326054101316920396718331088344207391305218379784491844475269317626953125e-59"},
    {0x1.61db13efbac84p-192, chars_format::scientific, 184,
        "2."
        "2020498812644948762033635142117124936558159878950024605332256666966723974999759217940229530756811212534736"
        "376207515633057521771033537451227692950672665261890870169736444950103759765625e-58"},
    {0x1.b0d988ed3cddap-191, chars_format::scientific, 184,
        "5."
        "3872611595972931554175099145771626677167753110603582724995579755815059161748788482588937205208507054423401"
        "377376127275846562117768446237202968791824009286983709898777306079864501953125e-58"},
    {0x1.5aae85fd3e364p-190, chars_format::scientific, 182,
        "8."
        "6296228594991325157229731878859944777554471925473343599866427363221069537701112240904539206861116322405729"
        "0877271989319006564197611655622440797464012263162658200599253177642822265625e-58"},
    {0x1.b03e8e5e29e8cp-189, chars_format::scientific, 182,
        "2."
        "1518906041456636649540146948591549576372380444424980691438719151181009657554823177254366549770014614706032"
        "8618439467737562606935278910241424697724621495353858335874974727630615234375e-57"},
    {0x1.4f61610cf1a2cp-188, chars_format::scientific, 181,
        "3."
        "3393236367487654889340514543993395885414094092298264710390768628882191685264273016078445381612177618356717"
        "142797177462480388287308407104197853498828152396527002565562725067138671875e-57"},
    {0x1.b36be913bc32ap-187, chars_format::scientific, 181,
        "8."
        "6708313720945146475351007645513441880275082684907503647662074215317905170752758954050433985625724643831520"
        "591378420182088554349024731181705578919594046283236821182072162628173828125e-57"},
    {0x1.c8e61b78565d0p-186, chars_format::scientific, 178,
        "1."
        "8197046818766602603686632095754096661651615753540376705159513693924449853347371957727126685333242730655442"
        "106873499937217143284318981587451002912558806201559491455554962158203125e-56"},
    {0x1.1775e38a634cbp-185, chars_format::scientific, 181,
        "2."
        "2260313359925404901383328255729970205956519425128348372731656993019288377550164061818329912332283919450786"
        "272972464419724461788385182721742260036901228659189655445516109466552734375e-56"},
    {0x1.0e15175ca8a3cp-184, chars_format::scientific, 178,
        "4."
        "3026606722410031733302677078662118124311005158053603782297542165579613935866431571476014496940810383434619"
        "138429936362412482276547319426894533389571506631909869611263275146484375e-56"},
    {0x1.4acfbe5469d34p-183, chars_format::scientific, 178,
        "1."
        "0540262429918153965846666776264916628183054605768575074287470826265255183716784817538128179345311968289342"
        "157486633140791923370468402402534702222425266882055439054965972900390625e-55"},
    {0x1.e17bb356e6d2cp-182, chars_format::scientific, 177,
        "3."
        "0681879985386225718752955391330904327341113602244606377562999866621196092449560501454295722110444234867058"
        "60565642117224838768142549934141161127598707025754265487194061279296875e-55"},
    {0x1.ae1fe199896b9p-181, chars_format::scientific, 178,
        "5."
        "4818233542942428453861995676140864431915789921130840684049211074743678696081616378159770391924796871267297"
        "084151393359730921440980329112542535074936722594429738819599151611328125e-55"},
    {0x1.a3e5b17d50316p-180, chars_format::scientific, 177,
        "1."
        "0702958332703832567616253901818145919920308310633570412149764544456728717958501944115424465582180828240141"
        "48718865247007996674714476958122089111924424287280999124050140380859375e-54"},
    {0x1.96b34187d54c0p-179, chars_format::scientific, 171,
        "2."
        "0733146515683786499609111229893863241245076553478564325616037441745856391159383548352298797077518654354117"
        "66550177248096035898124699092814893219838268123567104339599609375e-54"},
    {0x1.675af8398ba55p-178, chars_format::scientific, 176,
        "3."
        "6639110494840281694548174991298603448018526659230862490333249247127707514516761738926902815833573835511573"
        "0033554552298718973314046770846375000729722160031087696552276611328125e-54"},
    {0x1.5dd2845405124p-177, chars_format::scientific, 173,
        "7."
        "1334288244990372312224907648096701095619611996252745460578769413617469873020204065524906820710806990110295"
        "5125093074988767111613914735646080345077280071564018726348876953125e-54"},
    {0x1.1b379a2950eacp-176, chars_format::scientific, 173,
        "1."
        "1550490218152729646319151841501684609404232393195007305328016237754776338400569798686076059288528676396276"
        "3889248411112118081783719895916373587851921911351382732391357421875e-53"},
    {0x1.050c080bc80d1p-175, chars_format::scientific, 174,
        "2."
        "1292639261534582404213908408502234742842056862369668785710500233303706301115784477889068818329602152581373"
        "76334762627097723751361355200295566447721284930594265460968017578125e-53"},
    {0x1.b43a3871c2fbap-174, chars_format::scientific, 172,
        "7."
        "1162918935221443051517621235069819357956135232874696046768179379869415044499101446193354791112976594195410"
        "557422635999734494396452323672352946459795930422842502593994140625e-53"},
    {0x1.df22454bc74f6p-173, chars_format::scientific, 172,
        "1."
        "5632471909265050611068051615951617519978312479534271514571791116510630486516616104887110827559419704430548"
        "593022161692046697459355757142684950622424366883933544158935546875e-52"},
    {0x1.b833d723fe25ap-172, chars_format::scientific, 171,
        "2."
        "8724553500903598028572546383001781149110271282722642567137230852108467397456216094989216899040621575989169"
        "04794959450945984543606716299368741829312057234346866607666015625e-52"},
    {0x1.f684b3c7cc0acp-171, chars_format::scientific, 169,
        "6."
        "5581707069521569877856870724319603779730281282161256613335172096317790203054916032047180861903076571475476"
        "949770983954945174541038832582984241525991819798946380615234375e-52"},
    {0x1.a5b141082f7b4p-170, chars_format::scientific, 169,
        "1."
        "1006685169756962680050220555041590876254318428865998856904568826933953891310864740495265959403191562163377"
        "069746200609492539396368215864896455968846566975116729736328125e-51"},
    {0x1.4fff666a560aep-169, chars_format::scientific, 169,
        "1."
        "7539896072768474874561864155705114932844071436878901874932631783846705575216123230523996677805058270426469"
        "440568499952626504620988023841476888264878652989864349365234375e-51"},
    {0x1.668bb57ef8bccp-168, chars_format::scientific, 167,
        "3."
        "7433921715043594589736460314331405184962182591207676516772049221533184130039279221624312002874994124075876"
        "8607887085263453345700124241801631796988658607006072998046875e-51"},
    {0x1.dcd176deeeae3p-167, chars_format::scientific, 168,
        "9."
        "9564289980093796889603154154145876739448114195979055992690259022457312971712705761139632367260793438914366"
        "37755164485333344410143696645576483206241391599178314208984375e-51"},
    {0x1.16a3865422377p-166, chars_format::scientific, 168,
        "1."
        "1636497924322522189729705224278622993088292323624873159489348884349299835648653258490495496200575681563301"
        "93520858451476789898436370318535182377672754228115081787109375e-50"},
    {0x1.bce21dad63749p-165, chars_format::scientific, 167,
        "3."
        "7158384115949350614737820871904816925077956940869230941314885111502890909776030181321957172434491271547923"
        "1680692485678623002316733892058664423529990017414093017578125e-50"},
    {0x1.89eeefab48d10p-164, chars_format::scientific, 162,
        "6."
        "5805696341773827568201073427914990313810882433786527452734017775108553768567645871412871223414498597936013"
        "24190138180379207322179269112893962301313877105712890625e-50"},
    {0x1.8fee5ccadb200p-163, chars_format::scientific, 157,
        "1."
        "3361521745438592840663955655631716549469431650538517476774582035584703495979290821050139073573949863898319"
        "932246070741721499786081039928831160068511962890625e-49"},
    {0x1.07380dad14bcap-162, chars_format::scientific, 164,
        "1."
        "7588058594724069068378151340006562382389089937477477155953047822519153788093489690886862546961352922261512"
        "7616072031613314065323638857307742000557482242584228515625e-49"},
    {0x1.0b59bf6c21943p-161, chars_format::scientific, 164,
        "3."
        "5728259387967835757810502314748228560336702191385482390899073723989786692440757890127298326923356779924206"
        "4063605352086812859402353836912880069576203823089599609375e-49"},
    {0x1.fa531504c2a95p-160, chars_format::scientific, 164,
        "1."
        "3532863609445874625424619828095184220811044476992203391714726909818173064528541715965734117428727450051983"
        "0798601500848545205191175710979223367758095264434814453125e-48"},
    {0x1.bcfee137bb727p-159, chars_format::scientific, 163,
        "2."
        "3787372002095833385126791878777862375484338276605231718277360413206612063565553320217163353776596974116930"
        "802973502625109573915818117484377580694854259490966796875e-48"},
    {0x1.151cd5ef2d805p-158, chars_format::scientific, 162,
        "2."
        "9626275330019588245631947287909396699745270360057415499881998525739843605313927572634283409800720682223941"
        "17076967551033424286277551118473638780415058135986328125e-48"},
    {0x1.a50d5e23e121ep-157, chars_format::scientific, 160,
        "9."
        "0029880689123645099794460485807721339684096115950637844009362876227390039831564636627226957537724402162583"
        "602570082390824379725557946585468016564846038818359375e-48"},
    {0x1.82802e4264badp-156, chars_format::scientific, 161,
        "1."
        "6528407152844144785500614973455273336999912777463385056299104335915202959708996003513567290694805135376868"
        "9247248694610022134998672527217422612011432647705078125e-47"},
    {0x1.2177668084382p-155, chars_format::scientific, 159,
        "2."
        "4757619185369808203021240003521593381209663272308204986803350240581317601172411555122448494060667114028109"
        "01342339011156623573839397067786194384098052978515625e-47"},
    {0x1.03b3d0af74440p-154, chars_format::scientific, 153,
        "4."
        "4423898749490084399433969599509826144329330591332567939146106957870737458728262016757657867649861507909368"
        "67056336867509713783874758519232273101806640625e-47"},
    {0x1.d2d07d1f0f329p-153, chars_format::scientific, 159,
        "1."
        "5970369012122509593184775144635604659721100528580203484536611149954537884269829964378340152297825770815400"
        "55113898402168459700334324224968440830707550048828125e-46"},
    {0x1.8fa32bc4d85bap-152, chars_format::scientific, 157,
        "2."
        "7344299616431543522432421912792718134436427057605665499943091928202467144496467783172463158734772458732489"
        "503583523195173743403074695379473268985748291015625e-46"},
    {0x1.67c2abce8df9dp-151, chars_format::scientific, 157,
        "4."
        "9231615603464207242007921876013588518601290251044916876629241339050523954671848627932540076411043836705992"
        "149190718766560426189471399993635714054107666015625e-46"},
    {0x1.73f3b6e413e35p-150, chars_format::scientific, 157,
        "1."
        "0179995696026282273811276434771842619116554426387226609081999306437938716096066552645975664851424917170160"
        "429284839383179406269164246623404324054718017578125e-45"},
    {0x1.7a95dc8122d45p-149, chars_format::scientific, 156,
        "2."
        "0723091166540273850593168126191139912345243921985305222697460100039055010978950792132675510399982633713397"
        "43302659321122494162636940018273890018463134765625e-45"},
    {0x1.af1bf9e405f36p-148, chars_format::scientific, 154,
        "4."
        "7196310508913904671194894358782925911776121787765422306796132134761227959946314353602058140317633579755078"
        "227792840228627113674519932828843593597412109375e-45"},
    {0x1.93bd4a776ff22p-147, chars_format::scientific, 153,
        "8."
        "8399910274584726229868620813946972911876446658509805639346664857566354389109651130454527996512493390832109"
        "06594691158577603573576197959482669830322265625e-45"},
    {0x1.998a4f77b7f72p-146, chars_format::scientific, 153,
        "1."
        "7934004954654291024566203990087592056831316726175324954536665777161166202131665464671804424276289424204482"
        "57652650092541790627365116961300373077392578125e-44"},
    {0x1.e2ee6bf0a5651p-145, chars_format::scientific, 153,
        "4."
        "2295683591056470906800337028618844741657141766568221367835581227246587308429206335630344989589287675262730"
        "91660778125078223865784821100533008575439453125e-44"},
    {0x1.80940300d356fp-144, chars_format::scientific, 152,
        "6."
        "7363600023840417999542393041775431286862924968647585475108908864653553304615525710316981002244346312871708"
        "8829987280629296719780541025102138519287109375e-44"},
    {0x1.fb7e121e4f09ep-143, chars_format::scientific, 151,
        "1."
        "7778710260255370823068118815744034545239196175044810566452485059711823829134148938595203744881815979364219"
        "466006546976899471701472066342830657958984375e-43"},
    {0x1.db7f5ce10385bp-142, chars_format::scientific, 151,
        "3."
        "3315696595658846047469585592309601760666312357714637907805304801690666734362639697081633088940864280810672"
        "903680724754593711622874252498149871826171875e-43"},
    {0x1.1d9d22c7f3534p-141, chars_format::scientific, 148,
        "4."
        "0023019609904230460306129375468853345556873060242695191434355850628634523560076237997206470162408844618039"
        "983898061251466060639359056949615478515625e-43"},
    {0x1.8e16e3aa24c6fp-140, chars_format::scientific, 150,
        "1."
        "1156841616796604932136274348484852039247641538297458130288766038216630495392051161520698228292050021146544"
        "20551642655112800639471970498561859130859375e-42"},
    {0x1.87e3f754c260dp-139, chars_format::scientific, 149,
        "2."
        "1966221825446393623879986362588124795901767213242488227182002426802973438517357803464949551156413886798953"
        "6864355759604450213373638689517974853515625e-42"},
    {0x1.fa5d32abaa11cp-138, chars_format::scientific, 146,
        "5."
        "6765373748004688332440652788786161538895277758131917477071063157004169835839984069461934543412473811103188"
        "1204748827940420596860349178314208984375e-42"},
    {0x1.f67503a2182bbp-137, chars_format::scientific, 148,
        "1."
        "1265477503439072834143778179138023300408281899179844848603578440471818264924572994395463590144925447532309"
        "702169950327288461267016828060150146484375e-41"},
    {0x1.db3ed18fbe233p-136, chars_format::scientific, 147,
        "2."
        "1310740108629266741825276640768152345702055957167240124922338099906733105461315720740092281151001145210075"
        "94603485557627209345810115337371826171875e-41"},
    {0x1.8335b0765d557p-135, chars_format::scientific, 146,
        "3."
        "4726169049944299879453329939481586991700522073634174410762170911503198790930241004432988390365801374063802"
        "6145557404333885642699897289276123046875e-41"},
    {0x1.4dbf09123267bp-134, chars_format::scientific, 145,
        "5."
        "9862794573467662440074595060500155028664274136233854601575667668611139098768423815169512058364388094422285"
        "646611925358229200355708599090576171875e-41"},
    {0x1.5e56a8ce3c277p-133, chars_format::scientific, 145,
        "1."
        "2567777808329330013217753137114716276021058025597090076586824197836408715656044366011499934739896008786645"
        "686949867695147986523807048797607421875e-40"},
    {0x1.bb079ee8f4d5cp-132, chars_format::scientific, 142,
        "3."
        "1785827035279190121784119339542902927547255686713026008937054510447409625558295054802900095791530292975435"
        "312285981126478873193264007568359375e-40"},
    {0x1.4f6e275cf1a76p-131, chars_format::scientific, 142,
        "4."
        "8131885839189464342630285810238985752699527646604098580088304609518450064927286820639649469111945897896454"
        "038544789000297896564006805419921875e-40"},
    {0x1.6e0c8ad2bb37cp-130, chars_format::scientific, 141,
        "1."
        "0505090911062820335561411705941054623172870846458893207124770055231061069218704308882579307096982170963150"
        "87104585472843609750270843505859375e-39"},
    {0x1.98e433996597fp-129, chars_format::scientific, 142,
        "2."
        "3469216079446797138739112899579158124687027232331769891232554936238609927331878316423045145059373263289603"
        "794845561424153856933116912841796875e-39"},
    {0x1.42726d8c4369ap-128, chars_format::scientific, 140,
        "3."
        "7015098458206448453351979822608106339451489448555898068736741171041629697322955547340351680885679134386245"
        "7921431996510364115238189697265625e-39"},
    {0x1.486454058df80p-127, chars_format::scientific, 133,
        "7."
        "5395084299958847860449433646301178540543942807329687696496446852570945235346855720548050138439533096601508"
        "077583275735378265380859375e-39"},
    {0x1.6661274c7f05cp-126, chars_format::scientific, 138,
        "1."
        "6455979868696783534082063751133429136529036015164918660712006211854998013425847958975152867999508163321387"
        "14415123104117810726165771484375e-38"},
    {0x1.3aa7b44b0a502p-125, chars_format::scientific, 138,
        "2."
        "8896506750036806475577971922835255312815452296746498235731599185088314959519438221419769631184574013027521"
        "74387933337129652500152587890625e-38"},
    {0x1.9fd27c3ae95f7p-124, chars_format::scientific, 138,
        "7."
        "6374477588979438591229722951487526821041612993472034040866978911302507182089909043356325487765306689325051"
        "08159602968953549861907958984375e-38"},
    {0x1.da78946cc5490p-123, chars_format::scientific, 134,
        "1."
        "7429312422110310718977979413748775963737044267099005799918778562901268253551041976159609585717708002405856"
        "8596956320106983184814453125e-37"},
    {0x1.f203ac3519f18p-122, chars_format::scientific, 134,
        "3."
        "6588315678322708272314019672027802295093711627258677622098624893717512039023793281375763542569851116681434"
        "1777353547513484954833984375e-37"},
    {0x1.b49aae7f5cad1p-121, chars_format::scientific, 136,
        "6."
        "4153225021810435302055377998130934309169404574711166917674284394429969174601750224385013791146732675674257"
        "961873081512749195098876953125e-37"},
    {0x1.b661988bbdc4bp-120, chars_format::scientific, 136,
        "1."
        "2882866599344565053618788391492597985347367160360079978812335056300495851823386955130707091986101697766997"
        "631333651952445507049560546875e-36"},
    {0x1.7dc73059f4d49p-119, chars_format::scientific, 135,
        "2."
        "2438898905531304113205534342267833215945294680111818683410060358815191180269281387787392467074790158854113"
        "99722215719521045684814453125e-36"},
    {0x1.cdb2f9141b525p-118, chars_format::scientific, 134,
        "5."
        "4272469927212228398680026288174857747043423993740677691930900376873032761152811202056904353336480584246714"
        "8977448232471942901611328125e-36"},
    {0x1.ca41b4813a41ep-117, chars_format::scientific, 133,
        "1."
        "0773562313702051217542870690540839915318470195130197080844837846839614171734258592932298947107694342406603"
        "027484379708766937255859375e-35"},
    {0x1.81c487a032056p-116, chars_format::scientific, 132,
        "1."
        "8138709823870134963339439770612428318675600824578467344813375616044665156285156623700098024384863570901416"
        "09660349786281585693359375e-35"},
    {0x1.72bcb5fff535bp-115, chars_format::scientific, 132,
        "3."
        "4863954234406462550691749145030310991616513432575743908019034815279292363755361258808440757736568649249875"
        "30685029923915863037109375e-35"},
    {0x1.8bd7918860dbbp-114, chars_format::scientific, 131,
        "7."
        "4449617683806484935384150283945931186617540420755360525592411297979559594039747096401091457779086724144690"
        "3790347278118133544921875e-35"},
    {0x1.a7f69dcd72222p-113, chars_format::scientific, 130,
        "1."
        "5947728558224362995607999419897654924356426479146237070985315256260841154700059297961143613131529406246045"
        "255102217197418212890625e-34"},
    {0x1.eb4294b46da96p-112, chars_format::scientific, 129,
        "3."
        "6958300841764796394552603076512147534499147838425848046122473845261325916666391709798763706706914433652855"
        "22304475307464599609375e-34"},
    {0x1.45d8b318ecb26p-111, chars_format::scientific, 128,
        "4."
        "9027929571472789278384447568697681490197245669783486622993745123202427301521908282403838102991855407708499"
        "1149604320526123046875e-34"},
    {0x1.c95d0b441f711p-110, chars_format::scientific, 129,
        "1."
        "3763280779744355993441768388857348578041188915187008104911491475416457823921091900787544784479088377793232"
        "21184313297271728515625e-33"},
    {0x1.98333d0f2d03dp-109, chars_format::scientific, 128,
        "2."
        "4567652907408954862171758719761037178820726837148989034299592147290607067172199302776489787669689235372061"
        "3755285739898681640625e-33"},
    {0x1.dfd8b02992707p-108, chars_format::scientific, 127,
        "5."
        "7759413981215069525017042272423165722552378432976327150239566602665492393820853640382627369742607470470829"
        "866826534271240234375e-33"},
    {0x1.18e3e3b1a223ep-107, chars_format::scientific, 125,
        "6."
        "7621854242881406431627770947480800315291558269137007328403548746185753195763627266309109264952326157072093"
        "3377742767333984375e-33"},
    {0x1.9658328cb8114p-106, chars_format::scientific, 124,
        "1."
        "9564777034032247331266106351051660587948852300059958121203145251012029185530780310726950421695846671354956"
        "924915313720703125e-32"},
    {0x1.86c79844889d0p-105, chars_format::scientific, 121,
        "3."
        "7630713133101953008740171427121495587283910326243938739987716991334361642764145573780698583732373663224279"
        "880523681640625e-32"},
    {0x1.27dcf92066d8bp-104, chars_format::scientific, 124,
        "5."
        "6981175081206400922391655083797863384815261135600412746592359796806200489991016465245177169407497785869054"
        "496288299560546875e-32"},
    {0x1.b6c8ffb6a90c2p-103, chars_format::scientific, 123,
        "1."
        "6901389263110543181102365648652894274606301487002452251574237197576175408299383818092054276860380923608317"
        "97122955322265625e-31"},
    {0x1.39b18e81b6f59p-102, chars_format::scientific, 123,
        "2."
        "4166074419571089575889751347120191547305858469115993073742053892915281348533368963385492556028566468739882"
        "11154937744140625e-31"},
    {0x1.58ad465068c9ap-101, chars_format::scientific, 121,
        "5."
        "3105877964807320710292501984853581657899622371005556307571107853309782196652680426318671180752062355168163"
        "776397705078125e-31"},
    {0x1.9d0ed395b4c84p-100, chars_format::scientific, 120,
        "1."
        "2728329747902230165316181540568536882833839113574207013715404328367409245034930567741504603418434271588921"
        "54693603515625e-30"},
    {0x1.bf9c0e64057fbp-99, chars_format::scientific, 121,
        "2."
        "7586071091388190196112205187915629121694961798162398502469066619619835167200191071434911549431490129791200"
        "160980224609375e-30"},
    {0x1.f3a0cebf107f8p-98, chars_format::scientific, 117,
        "6."
        "1583924748384136682512359017261255450407522093971748312640088161632302368340627363174633046583039686083793"
        "64013671875e-30"},
    {0x1.8d2ccae7cd365p-97, chars_format::scientific, 119,
        "9."
        "7911189758325206052557743537635646483728105421101526676208264656982528338082742008774417286076641175895929"
        "3365478515625e-30"},
    {0x1.aa0b3a331c5bcp-96, chars_format::scientific, 117,
        "2."
        "1005583908999635980523814595285630437648644793626080509594614990803394929735556373451288436626782640814781"
        "18896484375e-29"},
    {0x1.4b814b3a1cb61p-95, chars_format::scientific, 118,
        "3."
        "2688922135094771214795507178565946598481426142285005760621407779950612653330384305139233447334845550358295"
        "440673828125e-29"},
    {0x1.f4068960578d7p-94, chars_format::scientific, 117,
        "9."
        "8612648786366515414854961643790399130167377288239167225981380011826524576009841971391267634317046031355857"
        "84912109375e-29"},
    {0x1.f62c0cec38831p-93, chars_format::scientific, 117,
        "1."
        "9807195772041244841383550163089449103868726897978856906267460422507129962120878130527046323550166562199592"
        "59033203125e-28"},
    {0x1.37c69791af80ep-92, chars_format::scientific, 115,
        "2."
        "4594770057660368495756651818864062387955645568161205513648519067289568355676177002777649249765090644359588"
        "623046875e-28"},
    {0x1.c42f82f902ae4p-91, chars_format::scientific, 113,
        "7."
        "1342307123642233045958095225167156992008276425321789727449239863317162219785716459341529116500169038772583"
        "0078125e-28"},
    {0x1.ab5c60a4631b5p-90, chars_format::scientific, 115,
        "1."
        "3485130668183937590444128052855465890028802588861696634054925499593654875281345528748033757437951862812042"
        "236328125e-27"},
    {0x1.163adde1f573ep-89, chars_format::scientific, 113,
        "1."
        "7558778301243823121155271808116835370371045792990942242404584251962271126273895660574453359004110097885131"
        "8359375e-27"},
    {0x1.6cc1d8ecb558ap-88, chars_format::scientific, 112,
        "4."
        "6038833248427952809663776964936140725404629123882134521116254371057353346474716460079434909857809543609619"
        "140625e-27"},
    {0x1.0cdf536fb5eefp-87, chars_format::scientific, 112,
        "6."
        "7872927594290552636925886720441058685794883580176619836663438543506473958621949549296914483420550823211669"
        "921875e-27"},
    {0x1.cf43fecae092dp-86, chars_format::scientific, 112,
        "2."
        "3388936048665310851316745468303563301324829126576636843972225326095050641772576938137717661447823047637939"
        "453125e-26"},
    {0x1.f45a241c9839ap-85, chars_format::scientific, 110,
        "5."
        "0522652313759764410835719385889967890520096634286257939712790137828674758013747236873314250260591506958007"
        "8125e-26"},
    {0x1.0e0770a686d83p-84, chars_format::scientific, 110,
        "5."
        "4531934926351591660177398201938298068678042808590523162341841824872750582597902280213020276278257369995117"
        "1875e-26"},
    {0x1.0248f281384bap-83, chars_format::scientific, 109,
        "1."
        "0432046065743156487678104545227567829109732926698293352119589937000883328455103082887944765388965606689453"
        "125e-25"},
    {0x1.ac4e19937ae27p-82, chars_format::scientific, 109,
        "3."
        "4598208650514789897486706324846604978683020740045778389727925607329515889087900859522051177918910980224609"
        "375e-25"},
    {0x1.3087a7746f421p-81, chars_format::scientific, 108,
        "4."
        "9199458656109230376671766694383649258995953059687000036237194733378455535621753824671031907200813293457031"
        "25e-25"},
    {0x1.70783708f772ap-80, chars_format::scientific, 107,
        "1."
        "1905894569192662776098050199813402280754741687796493203055674863031360155574134296330157667398452758789062"
        "5e-24"},
    {0x1.e065c19de1dc4p-79, chars_format::scientific, 105,
        "3."
        "104495987602903687782546492307846204182230640542680505726853422594768705522483287495560944080352783203125e"
        "-24"},
    {0x1.c685d70ae0fe0p-78, chars_format::scientific, 101,
        "5.87456966397771796422682549439311465967828126938704643526518826834870168340785312466323375701904296875e-"
        "24"},
    {0x1.a0780c9dec656p-77, chars_format::scientific, 105,
        "1."
        "076546984317854350454897139142567232421318914071250535456926162962421056334960667300038039684295654296875e"
        "-23"},
    {0x1.3cb9bbf0aea75p-76, chars_format::scientific, 105,
        "1."
        "637432580904225448218479784931625372923561979340250699162731128251391243821899479371495544910430908203125e"
        "-23"},
    {0x1.f0a2b8fd92f2fp-75, chars_format::scientific, 104,
        "5."
        "13509211207940396346808840622328108640224488399038307803406533218193441570065260748378932476043701171875e-"
        "23"},
    {0x1.bb04bcebdd6ffp-74, chars_format::scientific, 103,
        "9."
        "1614080145176778862206576960425700831949207923387370233170279819334691495669176219962537288665771484375e-"
        "23"},
    {0x1.0b62fe692a947p-73, chars_format::scientific, 103,
        "1."
        "1058854487286021576603725304903163539918366413893061214895083103904038779319307650439441204071044921875e-"
        "22"},
    {0x1.272fe8508d433p-72, chars_format::scientific, 102,
        "2.441730781169199364855750861362078623225251480968477216777312403805932916611709515564143657684326171875e-"
        "22"},
    {0x1.a4da532053764p-71, chars_format::scientific, 99,
        "6.962426049274538699439196410633694865008161302307608512174481874001941150709171779453754425048828125e-"
        "22"},
    {0x1.93f477225bbbep-70, chars_format::scientific, 100,
        "1.3365747882614801032463352914308130925659506904834814518322032295127854695238056592643260955810546875e-"
        "21"},
    {0x1.dac01e869bf58p-69, chars_format::scientific, 97,
        "3.1416350487962486701379607843901811256471115918449956111273280168205701556871645152568817138671875e-21"},
    {0x1.d259d75a5b1c3p-68, chars_format::scientific, 99,
        "6.172103329535160089255730652790336729118966059186200003960735827046590884492616169154644012451171875e-"
        "21"},
    {0x1.21e65c14b2260p-67, chars_format::scientific, 93,
        "7.673584938657739735290448393622396219109761654559513470441611815431315335445106029510498046875e-21"},
    {0x1.247adaeef533dp-66, chars_format::scientific, 98,
        "1.54837571490893774333213229345009640160216876301445875570468591053696627568569965660572052001953125e-20"},
    {0x1.8590b3c7299d1p-65, chars_format::scientific, 97,
        "4.1246824511333552476207424120489015258619773211916720236265565535660471141454763710498809814453125e-20"},
    {0x1.c16c9cb03d8aap-64, chars_format::scientific, 95,
        "9.51692901231032540579231072092779398477634354654546553799188135513986708247102797031402587890625e-20"},
    {0x1.afab9cd6fe545p-63, chars_format::scientific, 96,
        "1.828195094563646962244514682444059838175275831433078317124485412392687067040242254734039306640625e-19"},
    {0x1.f3fa50d429d7dp-62, chars_format::scientific, 95,
        "4.23497665979731430374210700758894838217662945466715084148756620407993978005833923816680908203125e-19"},
    {0x1.28c638f71d180p-61, chars_format::scientific, 87,
        "5.027552313830036048120204027398570440831332829627331459931838253396563231945037841796875e-19"},
    {0x1.9f197cec56a5bp-60, chars_format::scientific, 94,
        "1.4064120230650801115977574752674439808505632504024500210870751715219739708118140697479248046875e-18"},
    {0x1.23514676b2275p-59, chars_format::scientific, 93,
        "1.974044039127005690154809950489990254937712867841699028448321229234352358616888523101806640625e-18"},
    {0x1.742a3899f4ebfp-58, chars_format::scientific, 92,
        "5.04377526843796603941025189601750138415420441259629479036075139219974516890943050384521484375e-18"},
    {0x1.a24fa5ce867fbp-57, chars_format::scientific, 92,
        "1.13383457288879493881896180602251467830667152418533914770559789531034766696393489837646484375e-17"},
    {0x1.cd8bd478c4055p-56, chars_format::scientific, 91,
        "2.5020470223212867241998736287413513640192596398166731408441165740441647358238697052001953125e-17"},
    {0x1.5586beb808bb7p-55, chars_format::scientific, 90,
        "3.702836080714707117409232632738353992936433317704862655528330606102827005088329315185546875e-17"},
    {0x1.1782f85ff73e4p-54, chars_format::scientific, 87,
        "6.060941731133067066111993215447123683291462078494282739171694629476405680179595947265625e-17"},
    {0x1.5241f4d37d585p-53, chars_format::scientific, 89,
        "1.46695868126617733676316434964942825427625379777242520251689938959316350519657135009765625e-16"},
    {0x1.a9145af5d709dp-52, chars_format::scientific, 88,
        "3.6869770513056370258874447534099887412925645774515459596187838542391546070575714111328125e-16"},
    {0x1.14e3531aa8734p-51, chars_format::scientific, 85,
        "4.8032409094989299117442762699440752432309049459180361196786179789341986179351806640625e-16"},
    {0x1.8d306ae29c760p-50, chars_format::scientific, 82,
        "1.3780266196844444434001720951926995236184146642610670596695854328572750091552734375e-15"},
    {0x1.34141b1c6e739p-49, chars_format::scientific, 86,
        "2.13772429398483853817359285620068290943482478168313765110042368178255856037139892578125e-15"},
    {0x1.bfaa985695d46p-48, chars_format::scientific, 84,
        "6.212619127432842815535315316465814989023408974888607048114863573573529720306396484375e-15"},
    {0x1.a1bbef9dd867ep-47, chars_format::scientific, 84,
        "1.159445109391313455470569692597092094861802556715613121696151210926473140716552734375e-14"},
    {0x1.d4c0489e284adp-46, chars_format::scientific, 84,
        "2.602091364932322080817661116014788518557084191773487447107982006855309009552001953125e-14"},
    {0x1.5256e07f25dcdp-45, chars_format::scientific, 83,
        "3.75632150992183886471662319623894115764293523407335584352040314115583896636962890625e-14"},
    {0x1.71a8a2ed2b45fp-44, chars_format::scientific, 82,
        "8.2080728005574479728778617018482662413977023196931526172193116508424282073974609375e-14"},
    {0x1.b0e4af6682317p-43, chars_format::scientific, 82,
        "1.9224324416725509019750615142710900007101508524254285248389351181685924530029296875e-13"},
    {0x1.7b8de5bf78fd4p-42, chars_format::scientific, 79,
        "3.3711192675176746235914191322624765202904673078165842525777406990528106689453125e-13"},
    {0x1.ae59a0cb674f4p-41, chars_format::scientific, 78,
        "7.644553608444342585595182827876899211462513594739220934570766985416412353515625e-13"},
    {0x1.5dd5fa7afbee1p-40, chars_format::scientific, 80,
        "1.24286662127449181887050977687219485896298609706178694978007115423679351806640625e-12"},
    {0x1.384536c7c656fp-39, chars_format::scientific, 79,
        "2.2188144095886259914737759791032178121987505914347593716229312121868133544921875e-12"},
    {0x1.a1194c27935c7p-38, chars_format::scientific, 78,
        "5.927330708414900645292509942453463927213019868389665134600363671779632568359375e-12"},
    {0x1.a02b0d1c1f1a8p-37, chars_format::scientific, 75,
        "1.182821076754492303774112659466477733005707051461286027915775775909423828125e-11"},
    {0x1.651f948c8f895p-36, chars_format::scientific, 77,
        "2.03001127618364981565507635049392808242185726186335159582085907459259033203125e-11"},
    {0x1.0658d9ac47254p-35, chars_format::scientific, 74,
        "2.98254089359250336024448739896349803990549531818032846786081790924072265625e-11"},
    {0x1.463f50c6fb1bfp-34, chars_format::scientific, 75,
        "7.418005368738489917011425132798547142642942020529517321847379207611083984375e-11"},
    {0x1.fff128a1f6814p-33, chars_format::scientific, 73,
        "2.3280428024704824536772626046771984820171752517126151360571384429931640625e-10"},
    {0x1.514274eb0bbe6p-32, chars_format::scientific, 73,
        "3.0673581616552569753443045750033145446789006882681860588490962982177734375e-10"},
    {0x1.c66e7acce03a0p-31, chars_format::scientific, 68,
        "8.26606194612068018706590240458897955733164053526706993579864501953125e-10"},
    {0x1.3f09f0d9f8a0fp-30, chars_format::scientific, 73,
        "1.1606565070959597058008216612762751596132915210546343587338924407958984375e-09"},
    {0x1.364bffd2bc2acp-29, chars_format::scientific, 70,
        "2.2577068906830200447981735699908012460213058147928677499294281005859375e-09"},
    {0x1.21d26e23a4c2cp-28, chars_format::scientific, 69,
        "4.217465074781223546467325241464407792335578051279298961162567138671875e-09"},
    {0x1.ff8816230e3aep-27, chars_format::scientific, 70,
        "1.4887528604095426785363609988553645901987465549609623849391937255859375e-08"},
    {0x1.81d69783dda8fp-26, chars_format::scientific, 70,
        "2.2458741990672780846062688334639767528955189845873974263668060302734375e-08"},
    {0x1.4c5ef6a88833bp-25, chars_format::scientific, 69,
        "3.869307125073411435703155092889760080510086481808684766292572021484375e-08"},
    {0x1.a7cdc3dfbe9a7p-24, chars_format::scientific, 68,
        "9.86745045636969746077316024100711810973507454036734998226165771484375e-08"},
    {0x1.1241321139c78p-23, chars_format::scientific, 65,
        "1.27709782783028146746994412052966794135500094853341579437255859375e-07"},
    {0x1.a5b4169e66c20p-22, chars_format::scientific, 62,
        "3.92741961530240641102713905485899203995359130203723907470703125e-07"},
    {0x1.79889fa31ee9cp-21, chars_format::scientific, 64,
        "7.0321128865744089630400275037214186113487812690436840057373046875e-07"},
    {0x1.6659647864b09p-20, chars_format::scientific, 66,
        "1.334954758379262946808873659121363886015387834049761295318603515625e-06"},
    {0x1.d26dfc62429ebp-19, chars_format::scientific, 65,
        "3.47517156840570335023048696709846439034663490019738674163818359375e-06"},
    {0x1.793d2e00a8300p-18, chars_format::scientific, 56,
        "5.62129889716887591599725482183202984742820262908935546875e-06"},
    {0x1.39585d365fddfp-17, chars_format::scientific, 63,
        "9.338413843761515393811049878802776902375626377761363983154296875e-06"},
    {0x1.db9dd5363f2bbp-16, chars_format::scientific, 63,
        "2.834895459445888963169284113785550971442717127501964569091796875e-05"},
    {0x1.996aa70581c70p-15, chars_format::scientific, 58,
        "4.8806263333083725435013189297706048819236457347869873046875e-05"},
    {0x1.24d414212635cp-14, chars_format::scientific, 59,
        "6.98157387141301578013796724775374968885444104671478271484375e-05"},
    {0x1.49743faae0bcep-13, chars_format::scientific, 60,
        "1.570959551281101199658729594688111319555900990962982177734375e-04"},
    {0x1.fd541909e34d0p-12, chars_format::scientific, 56,
        "4.85733515795794441871624513851202209480106830596923828125e-04"},
    {0x1.fc05fd5826c21p-11, chars_format::scientific, 59,
        "9.68977731662493927018708905762878202949650585651397705078125e-04"},
    {0x1.b8d7be1e07ac5p-10, chars_format::scientific, 59,
        "1.68168161281527614621389421500907701556570827960968017578125e-03"},
    {0x1.58ae5b82bc128p-9, chars_format::scientific, 55,
        "2.6297079760909843060279200699369539506733417510986328125e-03"},
    {0x1.da353b89e30a0p-8, chars_format::scientific, 52, "7.2358389242134502072900659186416305601596832275390625e-03"},
    {0x1.523aa52ed6443p-7, chars_format::scientific, 57,
        "1.032193246435231769042584204498780309222638607025146484375e-02"},
    {0x1.b12c63dc720bbp-6, chars_format::scientific, 56,
        "2.64388060766413794666629399898738483898341655731201171875e-02"},
    {0x1.8284dd65c8bc7p-5, chars_format::scientific, 55,
        "4.7182495515037774225231004265879164449870586395263671875e-02"},
    {0x1.e78254ba42944p-4, chars_format::scientific, 53, "1.19020777670958699534509150907979346811771392822265625e-01"},
    {0x1.a2ea8656520bap-3, chars_format::scientific, 53, "2.04548882970135015302304282158729620277881622314453125e-01"},
    {0x1.c9baa87f5bfbbp-2, chars_format::scientific, 53, "4.47001106999774300287953110455418936908245086669921875e-01"},
    {0x1.71b66707cac81p-1, chars_format::scientific, 52, "7.2209474535101503267497946580988354980945587158203125e-01"},
    {0x1.61447ddf5fb3ep+0, chars_format::scientific, 51, "1.379951350245121499682454668800346553325653076171875e+00"},
    {0x1.b56d58bd7ad8fp+1, chars_format::scientific, 51, "3.417399494666546910792703783954493701457977294921875e+00"},
    {0x1.5201909da2346p+2, chars_format::scientific, 49, "5.2813455142393816998946931562386453151702880859375e+00"},
    {0x1.b29512bde933ep+3, chars_format::scientific, 49, "1.3580697413368053361182319349609315395355224609375e+01"},
    {0x1.28ba36cdc60a7p+4, chars_format::scientific, 49, "1.8545462421229469640593379153870046138763427734375e+01"},
    {0x1.4a0f954ec75bap+5, chars_format::scientific, 47, "4.12576090006436544399548438377678394317626953125e+01"},
    {0x1.df376fa0e3183p+6, chars_format::scientific, 48, "1.198041367663009140187568846158683300018310546875e+02"},
    {0x1.d777fba5be5b1p+7, chars_format::scientific, 47, "2.35734341792570859297484275884926319122314453125e+02"},
    {0x1.c36ecdbaad102p+8, chars_format::scientific, 45, "4.514328266785161076768417842686176300048828125e+02"},
    {0x1.92271b9835605p+9, chars_format::scientific, 45, "8.043055296192766263629891909658908843994140625e+02"},
    {0x1.3825bbeddf401p+10, chars_format::scientific, 45, "1.248589595287339989226893521845340728759765625e+03"},
    {0x1.bb88c3b81cd97p+11, chars_format::scientific, 44, "3.54827389150271073958720080554485321044921875e+03"},
    {0x1.0d8d78fa727c1p+12, chars_format::scientific, 43, "4.3128420357200675425701774656772613525390625e+03"},
    {0x1.f22ae1035f4c6p+13, chars_format::scientific, 42, "1.594135986971332386019639670848846435546875e+04"},
    {0x1.86358ae5236dep+14, chars_format::scientific, 41, "2.49733856397186100366525352001190185546875e+04"},
    {0x1.60fac84cf570cp+15, chars_format::scientific, 39, "4.518139121214867918752133846282958984375e+04"},
    {0x1.27022f6d4c231p+16, chars_format::scientific, 40, "7.5522185261496124439872801303863525390625e+04"},
    {0x1.4e3d42df12170p+17, chars_format::scientific, 36, "1.711305224325763992965221405029296875e+05"},
    {0x1.198a850ca77d0p+18, chars_format::scientific, 35, "2.88298078897354193031787872314453125e+05"},
    {0x1.b9ed4a147a3d3p+19, chars_format::scientific, 38, "9.05066314999694353900849819183349609375e+05"},
    {0x1.f24810bc3163fp+20, chars_format::scientific, 38, "2.04096104594553983770310878753662109375e+06"},
    {0x1.48f2de574af19p+21, chars_format::scientific, 37, "2.6947477926234123297035694122314453125e+06"},
    {0x1.7b69f67382652p+22, chars_format::scientific, 35, "6.21631761280210502445697784423828125e+06"},
    {0x1.80957cacc5b6dp+23, chars_format::scientific, 36, "1.260204633744593895971775054931640625e+07"},
    {0x1.581bf08ec083bp+24, chars_format::scientific, 35, "2.25515365576250366866588592529296875e+07"},
    {0x1.10483fa5a32e9p+25, chars_format::scientific, 34, "3.5688575294042415916919708251953125e+07"},
    {0x1.0ed9715f279f7p+26, chars_format::scientific, 33, "7.100154148679338395595550537109375e+07"},
    {0x1.b72203719cba3p+27, chars_format::scientific, 33, "2.302320915503817498683929443359375e+08"},
    {0x1.fd9abcf52a4a5p+28, chars_format::scientific, 32, "5.34358991322824776172637939453125e+08"},
    {0x1.2fcaa4b911fc2p+29, chars_format::scientific, 30, "6.370971111337816715240478515625e+08"},
    {0x1.15bbc0a9a86a6p+30, chars_format::scientific, 30, "1.164898346414468288421630859375e+09"},
    {0x1.b00ca87636445p+31, chars_format::scientific, 30, "3.624293435105989933013916015625e+09"},
    {0x1.d840bff2e1059p+32, chars_format::scientific, 29, "7.92308939487899112701416015625e+09"},
    {0x1.6573fbd897a95p+33, chars_format::scientific, 29, "1.19941344491848545074462890625e+10"},
    {0x1.884fb41a62589p+34, chars_format::scientific, 28, "2.6327568489536655426025390625e+10"},
    {0x1.ac014e40dd0dap+35, chars_format::scientific, 26, "5.74458721349079132080078125e+10"},
    {0x1.43fc6c60c1eefp+36, chars_format::scientific, 26, "8.69693373561208343505859375e+10"},
    {0x1.2dbd32a11ddb3p+37, chars_format::scientific, 26, "1.61994920995732025146484375e+11"},
    {0x1.b0bd32c9becf1p+38, chars_format::scientific, 25, "4.6465002353570220947265625e+11"},
    {0x1.a4dd93186c42dp+39, chars_format::scientific, 24, "9.038018345501304931640625e+11"},
    {0x1.e32a7f9fa538ap+40, chars_format::scientific, 23, "2.07518221098122119140625e+12"},
    {0x1.2084411c53fa7p+41, chars_format::scientific, 23, "2.47833888170395654296875e+12"},
    {0x1.0d5a138c14d99p+42, chars_format::scientific, 22, "4.6274297324353994140625e+12"},
    {0x1.0ead5f7d79f3bp+43, chars_format::scientific, 21, "9.300399090639615234375e+12"},
    {0x1.d9bdd70990201p+44, chars_format::scientific, 21, "3.255527228032200390625e+13"},
    {0x1.b1ba144c3c6d7p+45, chars_format::scientific, 20, "5.96109674105736796875e+13"},
    {0x1.56ef390e1980dp+46, chars_format::scientific, 19, "9.4265107777120203125e+13"},
    {0x1.d08de26a3153dp+47, chars_format::scientific, 19, "2.5539139214352990625e+14"},
    {0x1.96bf8d1fe67eap+48, chars_format::scientific, 17, "4.47224427308670625e+14"},
    {0x1.095e52abc0566p+49, chars_format::scientific, 16, "5.8355139054814075e+14"},
    {0x1.d639785501ca7p+50, chars_format::scientific, 17, "2.06806918811012175e+15"},
    {0x1.7a69b71f7291ap+51, chars_format::scientific, 15, "3.328555513255053e+15"},
    {0x1.6f06d69bea925p+52, chars_format::scientific, 15, "6.456802203838757e+15"},
    {0x1.e477d245cfe2cp+53, chars_format::scientific, 16, "1.7045704215755864e+16"},
    {0x1.94b582e6fb874p+54, chars_format::scientific, 14, "2.84788661041812e+16"},
    {0x1.651121f05f90dp+55, chars_format::scientific, 16, "5.0252702075045992e+16"},
    {0x1.7b487047230f8p+56, chars_format::scientific, 17, "1.06758663240355712e+17"},
    {0x1.7784c1fbc471cp+57, chars_format::scientific, 17, "2.11398169908011904e+17"},
    {0x1.7ac4b78ae30e4p+58, chars_format::scientific, 16, "4.2645533513929344e+17"},
    {0x1.312f35afa81abp+59, chars_format::scientific, 16, "6.8721420418841536e+17"},
    {0x1.06017fddf665bp+60, chars_format::scientific, 18, "1.179969481513261824e+18"},
    {0x1.5637f72135e49p+61, chars_format::scientific, 18, "3.082431250837574144e+18"},
    {0x1.027e9b70ce1ccp+62, chars_format::scientific, 18, "4.656624004411895808e+18"},
    {0x1.60c83f40c3bc1p+63, chars_format::scientific, 19, "1.2710318822043551744e+19"},
    {0x1.2689a2af0f3ddp+64, chars_format::scientific, 19, "2.1223673591718858752e+19"},
    {0x1.6bd7cbc72e9cep+65, chars_format::scientific, 19, "5.2435295624203190272e+19"},
    {0x1.b4618e9b7fb90p+66, chars_format::scientific, 20, "1.25778283487165677568e+20"},
    {0x1.b700b394dae46p+67, chars_format::scientific, 20, "2.53067849876474363904e+20"},
    {0x1.69b9336bb3625p+68, chars_format::scientific, 20, "4.17038733696760610816e+20"},
    {0x1.2e73980401159p+69, chars_format::scientific, 20, "6.97405765271726194688e+20"},
    {0x1.9cd16da53fb63p+70, chars_format::scientific, 21, "1.903787364496945446912e+21"},
    {0x1.a5f63f3a815d1p+71, chars_format::scientific, 21, "3.891911610207935397888e+21"},
    {0x1.b0e3c4047b75cp+72, chars_format::scientific, 21, "7.985405687712874233856e+21"},
    {0x1.4d847c6eb42c0p+73, chars_format::scientific, 22, "1.2304624807151021326336e+22"},
    {0x1.85fc1437b1734p+74, chars_format::scientific, 22, "2.8775790596421559779328e+22"},
    {0x1.8a7019581e7fap+75, chars_format::scientific, 22, "5.8208757994689939898368e+22"},
    {0x1.c67cb0e7b2a1cp+76, chars_format::scientific, 23, "1.34140907927602311725056e+23"},
    {0x1.e9cf376a61382p+77, chars_format::scientific, 23, "2.89132459907178460872704e+23"},
    {0x1.f3020a5bb1e68p+78, chars_format::scientific, 23, "5.89124628706466797191168e+23"},
    {0x1.c5c96a4dd9bf3p+79, chars_format::scientific, 24, "1.071473736158360648024064e+24"},
    {0x1.9c2cc74cde703p+80, chars_format::scientific, 24, "1.946441008779422248992768e+24"},
    {0x1.aba488754df1ap+81, chars_format::scientific, 24, "4.038971174128976945741824e+24"},
    {0x1.fad8c14ba9d89p+82, chars_format::scientific, 24, "9.574063461859927634477056e+24"},
    {0x1.f2fda18bc958dp+83, chars_format::scientific, 25, "1.8851337402710215888994304e+25"},
    {0x1.9d8f6c51ed693p+84, chars_format::scientific, 24, "3.124772875373390690516992e+25"},
    {0x1.f8236511754b2p+85, chars_format::scientific, 25, "7.6183220036477407253757952e+25"},
    {0x1.a2d213294f709p+86, chars_format::scientific, 26, "1.26580760756294165874081792e+26"},
    {0x1.50d2867c287f9p+87, chars_format::scientific, 25, "2.0359662658108241074978816e+26"},
    {0x1.3bf963799b446p+88, chars_format::scientific, 26, "3.81989337423178708023246848e+26"},
    {0x1.a12dc41e72c86p+89, chars_format::scientific, 27, "1.008676382053808460168953856e+27"},
    {0x1.832bbfda4182fp+90, chars_format::scientific, 27, "1.872243572018953219752329216e+27"},
    {0x1.b22ef35aa515ep+91, chars_format::scientific, 27, "4.199164189291374906487865344e+27"},
    {0x1.24632dbcf4379p+92, chars_format::scientific, 27, "5.655595157253244734125637632e+27"},
    {0x1.5016423c09309p+93, chars_format::scientific, 27, "1.300173405645727077842812928e+28"},
    {0x1.bbf972700d65cp+94, chars_format::scientific, 28, "3.4350855574179920076494340096e+28"},
    {0x1.6e1f3e3e4245fp+95, chars_format::scientific, 28, "5.6654642115107953004184076288e+28"},
    {0x1.47d35248fe09dp+96, chars_format::scientific, 29, "1.01457070140041083705704316928e+29"},
    {0x1.d31a67ab2db51p+97, chars_format::scientific, 29, "2.89122842438625311850965762048e+29"},
    {0x1.ab1253de2af64p+98, chars_format::scientific, 29, "5.28689023652633609509229559808e+29"},
    {0x1.9cfdf3dc71391p+99, chars_format::scientific, 30, "1.022518671042034182622745198592e+30"},
    {0x1.96152f2254ee0p+100, chars_format::scientific, 29, "2.01082438422738923900836511744e+30"},
    {0x1.b4de90e5f0095p+101, chars_format::scientific, 28, "4.3265449624459285617283432448e+30"},
    {0x1.be778d0492e6ap+102, chars_format::scientific, 30, "8.843189919417627285369414221824e+30"},
    {0x1.ebc33e9f0f228p+103, chars_format::scientific, 31, "1.9480726537977613039106892234752e+31"},
    {0x1.7af455437cc9bp+104, chars_format::scientific, 30, "3.002386285018347878401204813824e+31"},
    {0x1.642a6e844551ep+105, chars_format::scientific, 31, "5.6436715663923718161576574844928e+31"},
    {0x1.41b8b3a301a15p+106, chars_format::scientific, 32, "1.01957610305533992485037451247616e+32"},
    {0x1.0155b96fbcde0p+107, chars_format::scientific, 32, "1.63105345367552336552353253556224e+32"},
    {0x1.17b500de21540p+108, chars_format::scientific, 32, "3.54570802835801091766892577685504e+32"},
    {0x1.fa3527f025531p+109, chars_format::scientific, 33, "1.283388839036855097115531068571648e+33"},
    {0x1.12991a738b877p+110, chars_format::scientific, 33, "1.392377581640218018121716183597056e+33"},
    {0x1.4bbcfb93f0ee4p+111, chars_format::scientific, 33, "3.364225166474354069710570596073472e+33"},
    {0x1.15926f3d7b071p+112, chars_format::scientific, 33, "5.629829199100141824040041065742336e+33"},
    {0x1.86dacf9db9927p+113, chars_format::scientific, 33, "1.585495147785397376655401049653248e+34"},
    {0x1.6aa8e880f9271p+114, chars_format::scientific, 34, "2.9422458257062697580352079193440256e+34"},
    {0x1.44db602f65a69p+115, chars_format::scientific, 34, "5.2711051576274024231085405965910016e+34"},
    {0x1.4aa98d059f6c7p+116, chars_format::scientific, 35, "1.07306053965661318564328070210125824e+35"},
    {0x1.ad41a77876ac0p+117, chars_format::scientific, 35, "2.78603372165060620709063210871816192e+35"},
    {0x1.66608302c1ae0p+118, chars_format::scientific, 35, "4.65199941604955653649793565669195776e+35"},
    {0x1.724a6060561d6p+119, chars_format::scientific, 35, "9.61329185843412549197741860528848896e+35"},
    {0x1.d6cd57f7afd91p+120, chars_format::scientific, 36, "2.444544386985640811823093072529457152e+36"},
    {0x1.ddc593d2d0608p+121, chars_format::scientific, 36, "4.961465895993372192136189659616116736e+36"},
    {0x1.cb5644ce1a91fp+122, chars_format::scientific, 35, "9.54005598637793663997028777762750464e+36"},
    {0x1.1bc54417de33cp+123, chars_format::scientific, 37, "1.1787368324472861665867817538046394368e+37"},
    {0x1.0b7025db14e7ap+124, chars_format::scientific, 37, "2.2217886245582567633425166223452143616e+37"},
    {0x1.c25ad8d3be06dp+125, chars_format::scientific, 37, "7.4828037824613418029633676794849656832e+37"},
    {0x1.6fa2ef34cd8cep+126, chars_format::scientific, 38, "1.22168169555880306340177489939782434816e+38"},
    {0x1.2154fd4e3bc1cp+127, chars_format::scientific, 38, "1.92294090682938928866121043260519481344e+38"},
    {0x1.2b3cd0ab51216p+128, chars_format::scientific, 38, "3.97754940865523918837358639143272316928e+38"},
    {0x1.088b103a41b0bp+129, chars_format::scientific, 38, "7.03276498569342686920339511489517846528e+38"},
    {0x1.e53444dfa15a7p+130, chars_format::scientific, 39, "2.579787897255990868798456303636608712704e+39"},
    {0x1.19ed8692b24fbp+131, chars_format::scientific, 39, "2.997970965091339190918492577226091921408e+39"},
    {0x1.d6393885ae144p+132, chars_format::scientific, 40, "1.0000548245536083788593238972941513785344e+40"},
    {0x1.6acc29897fd95p+133, chars_format::scientific, 40, "1.5431699376188799230066746785793442840576e+40"},
    {0x1.f2f9916765d68p+134, chars_format::scientific, 40, "4.2448087869444726132947292415438599749632e+40"},
    {0x1.a8bb1d24ff93dp+135, chars_format::scientific, 40, "7.2264220268357129106158415886080664403968e+40"},
    {0x1.c5c3e8df3f2cfp+136, chars_format::scientific, 39, "1.544083208152169859594847631211501715456e+41"},
    {0x1.1772e9d5da5a7p+137, chars_format::scientific, 41, "1.90183053010164648774242281749579802083328e+41"},
    {0x1.14f6d2645603fp+138, chars_format::scientific, 41, "3.76984063098152793892190666264816558014464e+41"},
    {0x1.24a5b6eb957c8p+139, chars_format::scientific, 40, "7.9666178829165263796362879580362262970368e+41"},
    {0x1.2ead0eb8af7cbp+140, chars_format::scientific, 42, "1.647924923062673765177664088659074522021888e+42"},
    {0x1.f516ab8dbd662p+141, chars_format::scientific, 42, "5.456371187228343385170833127692803019636736e+42"},
    {0x1.855d7376918a9p+142, chars_format::scientific, 42, "8.479619741110213809967927453284253992747008e+42"},
    {0x1.f44b558dbdfb5p+143, chars_format::scientific, 43, "2.1790888931872989461006813529845663969312768e+43"},
    {0x1.196a6ab9ee449p+144, chars_format::scientific, 43, "2.4514764141293366381415554359835359275122688e+43"},
    {0x1.c970123b86b86p+145, chars_format::scientific, 41, "7.96969010621829343736169074091377888854016e+43"},
    {0x1.23fe1017a3e0ap+146, chars_format::scientific, 44, "1.01744513270938959360968970914297622533505024e+44"},
    {0x1.547b58dbe0a82p+147, chars_format::scientific, 44, "2.37281200493303842948982975659978497995046912e+44"},
    {0x1.6b72d270d534dp+148, chars_format::scientific, 44, "5.06573307308778511819262316883115987825590272e+44"},
    {0x1.9bfa29a521e6cp+149, chars_format::scientific, 45, "1.148424814894339399771081143389126450042896384e+45"},
    {0x1.088e70fa79bf2p+150, chars_format::scientific, 45, "1.474951280394658237786084602544572869491294208e+45"},
    {0x1.1d97a9d8999d2p+151, chars_format::scientific, 45, "3.184462066193894206844138084970587550398808064e+45"},
    {0x1.1b7ddc6783fe8p+152, chars_format::scientific, 45, "6.322074926642195313905924879563454681421185024e+45"},
    {0x1.90f9b356e1fd1p+153, chars_format::scientific, 46, "1.7884100129279887107935363982167269062471581696e+46"},
    {0x1.04a659aa20643p+154, chars_format::scientific, 45, "2.325073960940094003234741315214732474508640256e+46"},
    {0x1.b45db51612c32p+155, chars_format::scientific, 46, "7.7850303756798823507242277549769146173862445056e+46"},
    {0x1.94f1118511db0p+156, chars_format::scientific, 47, "1.44488017324739167332291972816201226607422078976e+47"},
    {0x1.74288ae36661ep+157, chars_format::scientific, 46, "2.6558108692875685669156873835578158454916775936e+47"},
    {0x1.3253541731259p+158, chars_format::scientific, 47, "4.37202365761853212655650514880767316833467367424e+47"},
    {0x1.9d71f6b97eb99p+159, chars_format::scientific, 48, "1.180177332650351500186142018418327053943445651456e+48"},
    {0x1.9c2824d021211p+160, chars_format::scientific, 48, "2.352999434252425166009583916770268278726766624768e+48"},
    {0x1.2c37fa039529bp+161, chars_format::scientific, 48, "3.427891103047345015228894619797641792100916789248e+48"},
    {0x1.97f764d76e448p+162, chars_format::scientific, 46, "9.3163052493008502647057342776183447761954275328e+48"},
    {0x1.a28e124e01121p+163, chars_format::scientific, 49, "1.9116211540697205399927873627877011998254938718208e+49"},
    {0x1.500cfed695739p+164, chars_format::scientific, 49, "3.0696171319662410271698897460360354956718064533504e+49"},
    {0x1.2cd97b4ce81a2p+165, chars_format::scientific, 49, "5.4961511485964129240667100065476685812465949212672e+49"},
    {0x1.d24224f1cf2bcp+166, chars_format::scientific, 50, "1.70359345069614948406404727167574558656079671066624e+50"},
    {0x1.83b3da401d150p+167, chars_format::scientific, 50, "2.83313955071286289178391550929804608096590893154304e+50"},
    {0x1.a3b0d2f93d673p+168, chars_format::scientific, 50, "6.13378673285658591018762418018704374742768855023616e+50"},
    {0x1.6b5cc29017ae4p+169, chars_format::scientific, 51, "1.062109320797658708151958249612931353686624780156928e+51"},
    {0x1.e6bf9a05045a3p+170, chars_format::scientific, 51, "2.845534590927396736753751979474589830905163889508352e+51"},
    {0x1.cc9ed46d0d98ep+171, chars_format::scientific, 51, "5.385580087774829124578596551004441252780605203021824e+51"},
    {0x1.bc208d2b82a15p+172, chars_format::scientific, 52,
        "1.0385481005999034803544914290611356999601747138707456e+52"},
    {0x1.6c981eeb98863p+173, chars_format::scientific, 50, "1.70513616682002662806350067152462430298633943384064e+52"},
    {0x1.af5d7ade9c17ap+174, chars_format::scientific, 52,
        "4.0348216442512827178202027976145404001660863678251008e+52"},
    {0x1.ebfb63d8a468bp+175, chars_format::scientific, 52,
        "9.2036158369142271242411353737258443958178349337018368e+52"},
    {0x1.8165629784911p+176, chars_format::scientific, 53,
        "1.44193775900760462481135039693825192887594892339970048e+53"},
    {0x1.f561a2a30dd53p+177, chars_format::scientific, 53,
        "3.75178096298129453493805795896698130008167991753048064e+53"},
    {0x1.ce7c7938e0eb9p+178, chars_format::scientific, 53,
        "6.92146559638991570078851625625319303554674020637999104e+53"},
    {0x1.77bc8cddcf12ap+179, chars_format::scientific, 54,
        "1.124637789574368600447483337148668908930534274783772672e+54"},
    {0x1.3fc175c6f2438p+180, chars_format::scientific, 54,
        "1.914156990649081570063038235013271375259033985125187584e+54"},
    {0x1.914ec58ebe041p+181, chars_format::scientific, 54,
        "4.804705186047787763539909785825820848780520789991489536e+54"},
    {0x1.5114314b07626p+182, chars_format::scientific, 54,
        "8.071435564947532553915773674998525033942233843077480448e+54"},
    {0x1.e2f0276441399p+183, chars_format::scientific, 55,
        "2.3128140200050004179900419204722717138007627859971014656e+55"},
    {0x1.cf8d0a2eae505p+184, chars_format::scientific, 55,
        "4.4399358958425029747414170378892766455751677599478185984e+55"},
    {0x1.4dda59a8f20a2p+185, chars_format::scientific, 55,
        "6.3953515931602618386692877635154528630077627837316071424e+55"},
    {0x1.bab65f6c0e97cp+186, chars_format::scientific, 56,
        "1.69613692241034722191343016069607921350219320331459362816e+56"},
    {0x1.0db1e999e5dcep+187, chars_format::scientific, 55,
        "2.0665317001185353533780346936985121680840320873792536576e+56"},
    {0x1.16729f78118dbp+188, chars_format::scientific, 54,
        "4.267199288089498798008616016338101124507969437189537792e+56"},
    {0x1.84b2774cd6d15p+189, chars_format::scientific, 57,
        "1.191353245759245872712330749375395405217002847792663625728e+57"},
    {0x1.5e6b2eec1979ep+190, chars_format::scientific, 57,
        "2.148060287120407132486133792062303242882862510466574319616e+57"},
    {0x1.57ac5f28c5822p+191, chars_format::scientific, 57,
        "4.213422729321882403507151670457754635672165551067199700992e+57"},
    {0x1.2c1e6e57e9676p+192, chars_format::scientific, 57,
        "7.358893309664639936881070842796439426339053634941326721024e+57"},
    {0x1.f14d05585f439p+193, chars_format::scientific, 58,
        "2.4387563351268131955594715375272838644628307055389846798336e+58"},
    {0x1.18fdf7f764a16p+194, chars_format::scientific, 58,
        "2.7559621536224231764973310109769900471295096010340351082496e+58"},
    {0x1.8c82785d38820p+195, chars_format::scientific, 57,
        "7.777910645414688648548968750500929149508839351454403657728e+58"},
    {0x1.e664096512a4fp+196, chars_format::scientific, 59,
        "1.90820271006743062589068419007889919427368854321224868691968e+59"},
    {0x1.7ad7e8f87a31fp+197, chars_format::scientific, 59,
        "2.97254819348561348142059994275052781258332713659043726491648e+59"},
    {0x1.8fbcbd9143824p+198, chars_format::scientific, 59,
        "6.27297873989847920060186967507561121071724081221944431607808e+59"},
    {0x1.fffab418f559fp+199, chars_format::scientific, 60,
        "1.606873109429469790133884014121163665471467983941023660244992e+60"},
    {0x1.da1c6d063ff81p+200, chars_format::scientific, 60,
        "2.976043223039824053749757547207391812994613888441872405233664e+60"},
    {0x1.15fe8ce1e9504p+201, chars_format::scientific, 60,
        "3.489997472879308917395719419357749318529849683153472890863616e+60"},
    {0x1.a8f8f1d983703p+202, chars_format::scientific, 61,
        "1.0670380970822515728824154611513147539078615867965386421960704e+61"},
    {0x1.a7c5f2cb7fa9cp+203, chars_format::scientific, 61,
        "2.1280541721170621914318415811403250028099879746592336410312704e+61"},
    {0x1.9a069737b82f9p+204, chars_format::scientific, 61,
        "4.1180373037668160785451413693672802945556196669733887910346752e+61"},
    {0x1.d7fb39182d06bp+205, chars_format::scientific, 60,
        "9.480559641663616628696383637736174353513111344194678809427968e+61"},
    {0x1.8d79cca5204b4p+206, chars_format::scientific, 62,
        "1.59679737690547294653629880448829857591918862991885354225631232e+62"},
    {0x1.640c53e94baf0p+207, chars_format::scientific, 62,
        "2.86073663238193178122650589057504705307874404845642118712000512e+62"},
    {0x1.804d768153946p+208, chars_format::scientific, 61,
        "6.1755045156767433035176829824443396292828215618205373832364032e+62"},
    {0x1.d56e2fb92f94bp+209, chars_format::scientific, 63,
        "1.508691188244574982497059261858774337284894599380994275393142784e+63"},
    {0x1.9de8dda906a1ep+210, chars_format::scientific, 63,
        "2.660508539901083172029910702401831570415871079047501730937831424e+63"},
    {0x1.7625e5dbb3e9cp+211, chars_format::scientific, 63,
        "4.809861739392636763970911315108253399659550567331225058938978304e+63"},
    {0x1.c66583b372649p+212, chars_format::scientific, 64,
        "1.1682993418673641507770337381177220245747542216734811616358432768e+64"},
    {0x1.c7dbe2df944fcp+213, chars_format::scientific, 64,
        "2.3441185866765201891906590922363241098417108629756551288590434304e+64"},
    {0x1.52e75005b7ac3p+214, chars_format::scientific, 64,
        "3.4854210022549138065076113679839139392004906864670443177957654528e+64"},
    {0x1.61996d6b5a737p+215, chars_format::scientific, 64,
        "7.2731162770376529778347980921328038690888967732944646841598738432e+64"},
    {0x1.494416e47342cp+216, chars_format::scientific, 64,
        "1.3545216532450050573167471500475542752885489394641883762375262208e+65"},
    {0x1.d60ab6b85519cp+217, chars_format::scientific, 65,
        "3.86728003636036058641366871128252569918895873439564907057088823296e+65"},
    {0x1.33e03222aff77p+218, chars_format::scientific, 65,
        "5.06610974407740673840531052436472518619916156367111801266415599616e+65"},
    {0x1.c180013aacf42p+219, chars_format::scientific, 66,
        "1.479308658758350330944201788946768123438076335588933997743174582272e+66"},
    {0x1.a8c4ee725339fp+220, chars_format::scientific, 66,
        "2.795839034978863819877803502232039113629062617998185283225294733312e+66"},
    {0x1.e8aaf34741ab6p+221, chars_format::scientific, 66,
        "6.432840401396405792365580284144481229273342573010878029692370157568e+66"},
    {0x1.227ef7d830535p+222, chars_format::scientific, 65,
        "7.64819906204326131860049759731150371173136410489009919800981323776e+66"},
    {0x1.50d3b96e4614ap+223, chars_format::scientific, 67,
        "1.7736014170885828821631467083617455696667197990697308887351889494016e+67"},
    {0x1.8199aecb377d9p+224, chars_format::scientific, 67,
        "4.0608453724544028931786363107981702003718879833309714118046052777984e+67"},
    {0x1.19dbb35474ceep+225, chars_format::scientific, 67,
        "5.9366267010857000073898171317477288623551476762400866883285525987328e+67"},
    {0x1.dc33701787db2p+226, chars_format::scientific, 68,
        "2.00599244568418166158633240420166985299541370621581756051323713748992e+68"},
    {0x1.eff20ab8910b4p+227, chars_format::scientific, 68,
        "4.17833237036618955782462790270901274407866847161169503610707764051968e+68"},
    {0x1.bbe88a3d4104ep+228, chars_format::scientific, 68,
        "7.47984105847088632825661725590567003356199708795195209233577533243392e+68"},
    {0x1.46b387e75ac05p+229, chars_format::scientific, 69,
        "1.100981177656366596121887029311165116283765891574561058397569203306496e+69"},
    {0x1.e666f5cf254cap+230, chars_format::scientific, 69,
        "3.278344263502461615618708692041532796484309585052066932644501920940032e+69"},
    {0x1.e6e69845380cep+231, chars_format::scientific, 69,
        "6.563409273861357872055846937881366142433814631142651266800757371830272e+69"},
    {0x1.87fc0b17b39efp+232, chars_format::scientific, 70,
        "1.0567882407580982568830708317724752282141329118524865643643232472530944e+70"},
    {0x1.1d2094524e151p+233, chars_format::scientific, 70,
        "1.5374031618797994143345255818223153455446312412350835802141987662987264e+70"},
    {0x1.ef0acdf882c82p+234, chars_format::scientific, 69,
        "5.338524581842552093835408600140749961917285261972119383523602533974016e+70"},
    {0x1.fcbcd755571cbp+235, chars_format::scientific, 71,
        "1.09724321606021718480487121388084343129412917209137058037575549878009856e+71"},
    {0x1.5bc325b6842e6p+236, chars_format::scientific, 70,
        "1.5001044647337975163536052292888629019192953446259429967707981096157184e+71"},
    {0x1.4839844f3a28ep+237, chars_format::scientific, 71,
        "2.83165431565250843561226845873096957075695083997080472361101646654078976e+71"},
    {0x1.e268bea09d76dp+238, chars_format::scientific, 71,
        "8.32366412253767450473627272269736199394015241611420074982712040652537856e+71"},
    {0x1.9760fc3633170p+239, chars_format::scientific, 72,
        "1.405812739508858068375342755770185891515789882712544527098421327318482944e+72"},
    {0x1.f9780dce1dea1p+240, chars_format::scientific, 72,
        "3.488618552580639620123899659132615213727580900417550210713537290046537728e+72"},
    {0x1.06379cf942b94p+241, chars_format::scientific, 72,
        "3.619513742366401459360774923805574186193834456864238978452991001371869184e+72"},
    {0x1.54e3dfab69e89p+242, chars_format::scientific, 72,
        "9.410948883835140439259712749284374813211962760503227341524256159409635328e+72"},
    {0x1.31e863bfd9bd6p+243, chars_format::scientific, 73,
        "1.6890382785900103876754997077931661155681683793063575869750399994525908992e+73"},
    {0x1.97cf871c408f0p+244, chars_format::scientific, 73,
        "4.5033691214168135372365182321155169406467422866316271815207540483596222464e+73"},
    {0x1.1c444bdbdf9c3p+245, chars_format::scientific, 73,
        "6.2781991287502835294706934796700503444220891091676239343080273452105465856e+73"},
    {0x1.05d2dc08efe95p+246, chars_format::scientific, 74,
        "1.15650595692360812734551875859766266613142682216011370208563856535394975744e+74"},
    {0x1.ecc77551d4971p+247, chars_format::scientific, 74,
        "4.35332683162743291871502389653473442925183772482197555090046969989126160384e+74"},
    {0x1.d480cb6589e19p+248, chars_format::scientific, 74,
        "8.27773333411108944564788528429675414027959576520140010882381647552484212736e+74"},
    {0x1.8d8ef73cf87b1p+249, chars_format::scientific, 75,
        "1.404849996452092323181663448719164230590611915347499050189329189348495589376e+75"},
    {0x1.48a0c3b10a317p+250, chars_format::scientific, 75,
        "2.322541569987461897646236862872835979235153071147854369984513726383982116864e+75"},
    {0x1.4272a4c4fdd70p+251, chars_format::scientific, 75,
        "4.557727968952480904558449925323762902907761772892808327111565265849267781632e+75"},
    {0x1.ae03d804b061ep+252, chars_format::scientific, 74,
        "1.21563322709765501473251126237121602148703036382587288355792403577863929856e+76"},
    {0x1.0b5dd53c3113bp+253, chars_format::scientific, 76,
        "1.5116664880436697889619534522569417861107074808654256101389938332337600200704e+76"},
    {0x1.fdd951416069dp+254, chars_format::scientific, 76,
        "5.7652801636485908304981079853657826006611591736383711473146661351961829310464e+76"},
    {0x1.3f050c163f528p+255, chars_format::scientific, 76,
        "7.2148358177064735441715850462253186745656784598757713984413999990820116103168e+76"},
    {0x1.d281ec8a5d188p+256, chars_format::scientific, 77,
        "2.11007343253573153040916841042569198900237589785514419724926914360700078915584e+77"},
    {0x1.b1ee0f3407c41p+257, chars_format::scientific, 77,
        "3.92544155933803743324755229116691986569477877247338320380545265297625347784704e+77"},
    {0x1.6832d41e7dc1ap+258, chars_format::scientific, 76,
        "6.5168972734192971123386188207590235648755640305144385763849856436594125307904e+77"},
    {0x1.e64f563364bdep+259, chars_format::scientific, 76,
        "1.7597137621226992026876162475289352988150739628485525054187120773028919640064e+78"},
    {0x1.daa06c44fb425p+260, chars_format::scientific, 78,
        "3.434875728114804814685899568021643975684275456343249710170796956248388352868352e+78"},
    {0x1.36affe847782ap+261, chars_format::scientific, 77,
        "4.49689401318463171959207532471966088045183274122115864667263900282602867654656e+78"},
    {0x1.5a4251d5f8667p+262, chars_format::scientific, 79,
        "1.0023515028874743203760034918542228757355688414371945561530461637433189038292992e+79"},
    {0x1.61672219d801dp+263, chars_format::scientific, 77,
        "2.04606279876720469579937490350496538995031175031291773472748474159827481788416e+79"},
    {0x1.3d865b7eeb438p+264, chars_format::scientific, 79,
        "3.6766863868985022220367084943920216131061939418967080566277924324348988351315968e+79"},
    {0x1.2db506dfa8ce9p+265, chars_format::scientific, 79,
        "6.9870599261497189307442468175452786217368249333102065069521396329647863295377408e+79"},
    {0x1.8390d09306414p+266, chars_format::scientific, 80,
        "1.79508160415808704712141748605675659243941837354766083639370088277774910089068544e+80"},
    {0x1.9b58ceed26006p+267, chars_format::scientific, 80,
        "3.81045742515568238106089113337056938315639562315303996957679473250795050372169728e+80"},
    {0x1.2fbe163c69224p+268, chars_format::scientific, 80,
        "5.62735708283395761680999734220534079897036103282947406804850940523084358392741888e+80"},
    {0x1.ed623087df1bep+269, chars_format::scientific, 81,
        "1.828157196786173258110715724311801689865646019514059112947102608834558509445021696e+81"},
    {0x1.c4a8946c5378ap+270, chars_format::scientific, 81,
        "3.354513608629342758881183607515227358808179514909005943036597166005055102654611456e+81"},
    {0x1.15c4e12be427fp+271, chars_format::scientific, 81,
        "4.116922864713554962262731822113769463098264781458759029065788118035733765689442304e+81"},
    {0x1.6ad5bf3ce75d1p+272, chars_format::scientific, 82,
        "1.0755434708169830468646961963757742494547372019865450762930913468197267328525664256e+82"},
    {0x1.39e6cc7b696f2p+273, chars_format::scientific, 82,
        "1.8609826393606468152836428445460492052838500356054137125720357473673460037122523136e+82"},
    {0x1.492f9204fea8cp+274, chars_format::scientific, 81,
        "3.903192479447499033452350069520597800324534214682007651943346621675247621235539968e+82"},
    {0x1.10fdf067e1d3ap+275, chars_format::scientific, 82,
        "6.4737911159818786400194931508236873102720909642740513708334320479730693747677069312e+82"},
    {0x1.4475e6d3ffa4cp+276, chars_format::scientific, 83,
        "1.53886578090640196755690493218260429593835278923075770789252846079936296641204584448e+83"},
    {0x1.e690de58f29c9p+277, chars_format::scientific, 83,
        "4.61541222592303232645421887442495089995066619544195472117594256018529300800228818944e+83"},
    {0x1.12d15aa66324bp+278, chars_format::scientific, 82,
        "5.2136715880000982561259895823177793906237517288103170230159179545063743954880561152e+83"},
    {0x1.c6239933289ecp+279, chars_format::scientific, 84,
        "1.723128550002755437133951204996418910562653794534546195856270285892794521746348703744e+84"},
    {0x1.b6563b1fc7692p+280, chars_format::scientific, 82,
        "3.3263411825363985053471050648782104121530178846595344015068034571605091406795767808e+84"},
    {0x1.bc57fc9b4e281p+281, chars_format::scientific, 84,
        "6.743849062437124540067369460095704859176196480433913929539186007746583809206972841984e+84"},
    {0x1.f8df107311968p+282, chars_format::scientific, 85,
        "1.5324966500321058049592869611887769487534860026596133853595336640461446056900382687232e+85"},
    {0x1.de346966130bbp+283, chars_format::scientific, 85,
        "2.9031045606668695079086558896866507278227043543999063147023976978260396987770338279424e+85"},
    {0x1.4bcb7614590adp+284, chars_format::scientific, 85,
        "4.0285461203337303545331340422939720789741892918160941159647588152564951369732381999104e+85"},
    {0x1.0563f359dbcccp+285, chars_format::scientific, 85,
        "6.3474382619472774879674901098388887476421241832512569944968136076387350654165612232704e+85"},
    {0x1.31c3c51fb59f0p+286, chars_format::scientific, 86,
        "1.48499905686861542665053988630525851133259775675492961721942835140068121158861530857472e+86"},
    {0x1.43b14acd508e9p+287, chars_format::scientific, 84,
        "3.144137214709148273932932752798276942472276257047001734687113587664554987136445579264e+86"},
    {0x1.7a67288ca2338p+288, chars_format::scientific, 86,
        "7.35111663943683991924868091407140115848506284972761980234658243157821224316229105221632e+86"},
    {0x1.90ee051acce20p+289, chars_format::scientific, 87,
        "1.557747566386344816691965362482515856301711161509577196359183216260647622504160667107328e+87"},
    {0x1.2489551766274p+290, chars_format::scientific, 87,
        "2.273205881098212719172251019697290790177862652621182786611096562647157941278227203883008e+87"},
    {0x1.3e54bc6237b93p+291, chars_format::scientific, 87,
        "4.947293841380347003020105042807568353223605346291404893299918661932182932360249923862528e+87"},
    {0x1.ecf1cc571a5cdp+292, chars_format::scientific, 87,
        "1.532204788518055669527054408252775276561841237278791821067837641365410854525267664175104e+88"},
    {0x1.62c38c686058dp+293, chars_format::scientific, 87,
        "2.205403895176296498667172663255869787229707570210827621989553387899095272142052689707008e+88"},
    {0x1.1956cbeae3776p+294, chars_format::scientific, 88,
        "3.4979111598588176010555116390040342571373179418270620765845075298580332460285709028163584e+88"},
    {0x1.d245370a2c906p+295, chars_format::scientific, 89,
        "1.15943544996190933856633616414466811022505880808156492718239704433998219084021400875302912e+89"},
    {0x1.77a2ad5be5f22p+296, chars_format::scientific, 89,
        "1.86812241557541298892557723890372259123352337205389983867335838290407406167752042457595904e+89"},
    {0x1.5e27d63120bc6p+297, chars_format::scientific, 89,
        "3.48281044472571483629770428112359357931579367395984692863821844484753880315554503889780736e+89"},
    {0x1.6cd5ca4b6a049p+298, chars_format::scientific, 89,
        "7.25763926599453313576032544399461752503111043260623699604979165837300824089149573789908992e+89"},
    {0x1.21ef16216f087p+299, chars_format::scientific, 90,
        "1.153527049014772181210371929535324976526694483335493350780385752130773271127971750637207552e+90"},
    {0x1.39c791a4cdd30p+300, chars_format::scientific, 90,
        "2.496797909293860274452611679981864366431273655911171418054054946652601225349601977195036672e+90"},
    {0x1.b84f065ad9c40p+301, chars_format::scientific, 90,
        "7.007223778789100460674592112903687638288056977455315141802089640807060683661017463323099136e+90"},
    {0x1.5c980f061d930p+302, chars_format::scientific, 91,
        "1.1095288700912676850259655407944409623006326764511603357666977203703446579685558999924604928e+91"},
    {0x1.d11d295facde2p+303, chars_format::scientific, 91,
        "2.9607930405769014382601054795425097838217102889963775497642608889806414863145865310495571968e+91"},
    {0x1.bbf08598a98bbp+304, chars_format::scientific, 91,
        "5.6520050704947556744896535369107614707599849622347754280995272309160258719009203701942321152e+91"},
    {0x1.ba04cbb38e4d5p+305, chars_format::scientific, 92,
        "1.12551007727079359585097814946865173194633864244482778621517929765203808143927747684958470144e+92"},
    {0x1.54131d0e410eap+306, chars_format::scientific, 92,
        "1.73186080336662674773428302451694949383861654865608072294885374856902390005170129581872513024e+92"},
    {0x1.e30ce3214662bp+307, chars_format::scientific, 92,
        "4.91995461222250678150766955487414849320177453519696863021951432129138251603934668204877545472e+92"},
    {0x1.53b14d0307376p+308, chars_format::scientific, 92,
        "6.91966009118651520979803296576329218495201852892814426466356352573178600739540460494424899584e+92"},
    {0x1.0db459c95ae0ap+309, chars_format::scientific, 93,
        "1.098795518726438366609401980967157225074875139569724076317122730302418377716044842181188386816e+93"},
    {0x1.1c3939899abbap+310, chars_format::scientific, 93,
        "2.315894257968477114139855258593793035500513640711965686941821174621775820808713339985182326784e+93"},
    {0x1.373d598ccbedep+311, chars_format::scientific, 92,
        "5.07205087659469518714361132934952967180404131875257868675409772338932035589521892535594647552e+93"},
    {0x1.3df92e8f7f25cp+312, chars_format::scientific, 94,
        "1.0363570999985610218238902711693729605343613482930794977520814186252504820113148082355622117376e+94"},
    {0x1.e43040df434b2p+313, chars_format::scientific, 94,
        "3.1561899942152433381203488205922856539908726361744071551624952459304620181234055813806189182976e+94"},
    {0x1.bd56a038510a5p+314, chars_format::scientific, 94,
        "5.8058899603986402390979930533204289636439533662431550984437804920565671771960313337224984788992e+94"},
    {0x1.47a680f7df241p+315, chars_format::scientific, 94,
        "8.5431764922746352414815315662378944345996354389236714634151510172388323479866864189920524632064e+94"},
    {0x1.0a7083cf6add8p+316, chars_format::scientific, 95,
        "1.38943198710420748341660043617043022583822760533446236412979829417047860471831997112096984662016e+95"},
    {0x1.ca2d6c8c53bd5p+317, chars_format::scientific, 95,
        "4.77861849016998188114122579439270994768860615811890514883370859774317648442079613611698244550656e+95"},
    {0x1.e92db2529dbcfp+318, chars_format::scientific, 96,
        "1.020389588899609153532580957412143752366703719293632571694846387812362664420354081750298547716096e+96"},
    {0x1.7e9337e01fb65p+319, chars_format::scientific, 96,
        "1.596045688776375776841703068858618647181748707273854812785319263912136577406031736557627640905728e+96"},
    {0x1.856a9ca60259dp+320, chars_format::scientific, 96,
        "3.249173807353552076769227343856334408112864749547363816303721235276306516121646129315832634802176e+96"},
    {0x1.2954147067244p+321, chars_format::scientific, 96,
        "4.961638176380709527864130701814524798785240769392200382075051902521140868022699235320535724326912e+96"},
    {0x1.8a9948a3b5773p+322, chars_format::scientific, 96,
        "1.316965383848080426178721677102139575139428518210160435009232507801986304249723290592830277287936e+97"},
    {0x1.9d7f682a48e95p+323, chars_format::scientific, 97,
        "2.7600802833290057294863365648278498083682974322674559612258381363079661754043107711541518184480768e+97"},
    {0x1.1394946666649p+324, chars_format::scientific, 97,
        "3.6789758695100667984355585133798803034265640286914369787158051732884080762893646681521731009511424e+97"},
    {0x1.5cf3dcf0c210ap+325, chars_format::scientific, 97,
        "9.3169776057927388397860971692076748096813463829441115661384293210348344104809158613064035568975872e+97"},
    {0x1.edad497808d6ap+326, chars_format::scientific, 98,
        "2.63621865809578202632007715175239364465008642226141794355213814208815258090680462442156516792336384e+98"},
    {0x1.0da0103363c19p+327, chars_format::scientific, 98,
        "2.87958016292024262706195266242702522208665557458094458094772254523203474127145608787359761973641216e+98"},
    {0x1.e0e09ee6fbc77p+328, chars_format::scientific, 99,
        "1.027147944933023542626819355716472887371271886832370736047056582372410954517572846778976767599181824e+"
        "99"},
    {0x1.9678e5f1a7d71p+329, chars_format::scientific, 99,
        "1.736438949946239757715573812462668203854228021142457473943958788246613058128755016444052964993138688e+"
        "99"},
    {0x1.4b5b869a8b73ap+330, chars_format::scientific, 99,
        "2.831101490449813330351300092716022415336638150557587101281369589000119033315970171347397084924870656e+"
        "99"},
    {0x1.fe2c3d2523805p+331, chars_format::scientific, 98,
        "8.71778003173501782520294586670274195486325481663656287823621692798053380434188606701697032360296448e+99"},
    {0x1.7a8e2bf190c3ep+332, chars_format::scientific, 100,
        "1.2937429393963081102936715388735517174575449745661779868560549590564554071876819476341646368012500992e+"
        "100"},
    {0x1.c20e9fb7c28cfp+333, chars_format::scientific, 99,
        "3.076211787425003964373361588531553092466447952323893670684982577431400448345840350416908836231184384e+"
        "100"},
    {0x1.bc64bd3fbb063p+334, chars_format::scientific, 100,
        "6.0750002047707119351020146056748996020726847090111922770368870774035039300942105887039623283718750208e+"
        "100"},
    {0x1.6fa79bcec5d71p+335, chars_format::scientific, 101,
        "1.00519131923249665159539189045738250625445899193224853577560494867813212309547435281219657555073040384e+"
        "101"},
    {0x1.255820e7b40dbp+336, chars_format::scientific, 101,
        "1.60404356999704584039118751697581736942407721317265568405145483828932537524402503992838476799827509248e+"
        "101"},
    {0x1.24e8b96eea468p+337, chars_format::scientific, 101,
        "3.20332798201769959258478598390469858187503168380540831739211163523937048679598283011990104943469002752e+"
        "101"},
    {0x1.296421957b8fcp+338, chars_format::scientific, 101,
        "6.50468980931338189749732798197360744414144439025939112265821291401038872632313877281859844571396046848e+"
        "101"},
    {0x1.2b239b9bcb1b4p+339, chars_format::scientific, 102,
        "1.308584396599165566045730161590653878587049789341429936525191989129126795868599529420259141598822006784e+"
        "102"},
    {0x1.ea18f74afcc08p+340, chars_format::scientific, 102,
        "4.287864653000838387576078081500217988595704090069841900641074208176801061178027675635595638576924065792e+"
        "102"},
    {0x1.771193f9d6396p+341, chars_format::scientific, 101,
        "6.56295366062876882918926416107436715831157240075745311354357615353582042989302783876335181380573986816e+"
        "102"},
    {0x1.5da5e2bf67261p+342, chars_format::scientific, 103,
        "1."
        "2236285152807307624643628388698918410797745423679381645265829552143290625157094290629079953916645343232e+"
        "103"},
    {0x1.58fcd12ad7c3ep+343, chars_format::scientific, 103,
        "2."
        "4146377765621171182079586051573746443023029345082834585424128063094779334007517592308658607782004523008e+"
        "103"},
    {0x1.b981dd551031dp+344, chars_format::scientific, 103,
        "6."
        "1803976055027187805645727187356890583048090549637147591363651473300874743076219960394574930078255284224e+"
        "103"},
    {0x1.3fc3743a41034p+345, chars_format::scientific, 102,
        "8.952357506110560823804694357950163920534386086340839327084956631888740764686521452344790633972229996544e+"
        "103"},
    {0x1.dd8d36aaec71ap+346, chars_format::scientific, 104,
        "2."
        "67398429934638135811565547800662171127722207675507363429204836809480442600041268010451262282407276969984e+"
        "104"},
    {0x1.b602d12c2da7dp+347, chars_format::scientific, 104,
        "4."
        "90516421859048735586262432552927537804652667466774102274094051591440656755245550064055546651491847634944e+"
        "104"},
    {0x1.fc12bf0bef890p+348, chars_format::scientific, 105,
        "1."
        "137954340248294860423380000818100997225882123662443049443669733096271165751582178114456678003518298128384e"
        "+105"},
    {0x1.3b58efef7ec92p+349, chars_format::scientific, 104,
        "1."
        "41259541205595997693021666042884440773661567606819789980115193551404322394471748056362736136713555410944e+"
        "105"},
    {0x1.5b4c0eded4f79p+350, chars_format::scientific, 105,
        "3."
        "111427431860026306405776387343100771890312921613335110339967675955518358836576017275894982577915909111808e"
        "+105"},
    {0x1.e85ac6ef41497p+351, chars_format::scientific, 104,
        "8."
        "75031714552777887225807383376825846159238826560043847494035938723501665994908088640458130401929788915712e+"
        "105"},
    {0x1.3f23aec99600fp+352, chars_format::scientific, 106,
        "1."
        "1436652181690534377916969838950952681644685698247142823509585599288898244633450308347520694943066435354624"
        "e+106"},
    {0x1.dbfc913a56c60p+353, chars_format::scientific, 106,
        "3."
        "4114830865381290718001185426163995046141306436854142946803189625447986280993214823051741417052475697922048"
        "e+106"},
    {0x1.1c2ebe7ec1836p+354, chars_format::scientific, 106,
        "4."
        "0735774158992452259605808606588504989866811990087038965595192924870048908044819867508613381642465662992384"
        "e+106"},
    {0x1.938cd43ae03ccp+355, chars_format::scientific, 107,
        "1."
        "1569270331282534059969068327328876565308650356045145204600968251326236704641136451976395157408107677823795"
        "2e+107"},
    {0x1.3b62009235fd5p+356, chars_format::scientific, 106,
        "1."
        "8083251599082482702871408072496160530674776660225822272659505156433465172981994959191303658607609326338048"
        "e+107"},
    {0x1.4aa1b1e151343p+357, chars_format::scientific, 107,
        "3."
        "7915158199315730208700932089897195490537797203507832684798974061156166230255562088474361040176159786847436"
        "8e+107"},
    {0x1.9e1c89c676ae4p+358, chars_format::scientific, 107,
        "9."
        "4976410001520505339336923527708275328860082974903541021837498139408575557376218156577936301953315195007795"
        "2e+107"},
    {0x1.3c53f9e9b8734p+359, chars_format::scientific, 108,
        "1."
        "4509958077289753006583745539523455423321886826191606256195412037965739791079509759759293075504939731643269"
        "12e+108"},
    {0x1.e2406d2cc3bf2p+360, chars_format::scientific, 108,
        "4."
        "4241741129837741663461680635414788924903961539225781403536940590382123291201216260256233875042401766625771"
        "52e+108"},
    {0x1.965c4e0d723edp+361, chars_format::scientific, 108,
        "7."
        "4558991654731428914104079934452871426783695817576025114432418056082590624526774397193747962910439748728258"
        "56e+108"},
    {0x1.f33c9e28b3fdep+362, chars_format::scientific, 109,
        "1."
        "8319982128819878475874631798176252605838592272956747638693247379538573339418939590416398806892687983611215"
        "872e+109"},
    {0x1.9f22e896506fdp+363, chars_format::scientific, 107,
        "3."
        "0467669457405912680374116492410644952689237372714665865235539240041221305708088530307721560995413077105049"
        "6e+109"},
    {0x1.b237a63060f12p+364, chars_format::scientific, 109,
        "6."
        "3736125384602496542925846716945019597567502625082164758543137289627204851036875242571151015244816059499282"
        "432e+109"},
    {0x1.1dc76d7407d6dp+365, chars_format::scientific, 109,
        "8."
        "3895522918267103904361494200392714874087254625614035884417862680704246630517746609334588660429723489456357"
        "376e+109"},
    {0x1.e7fd5979d3140p+366, chars_format::scientific, 110,
        "2."
        "8651611621506035093444741868330375337353333541754848851992800934603776249499947751100608389065176163402802"
        "7904e+110"},
    {0x1.ff1435c531fe7p+367, chars_format::scientific, 110,
        "6."
        "0014533329722189329734118423159496255075495318058115363305083019617613945172917917423988971723427568413363"
        "4048e+110"},
    {0x1.5982e576be2d3p+368, chars_format::scientific, 109,
        "8."
        "1144803338413104318522071061957326245737083351442942911782670679984495024861321317439248085744036645749915"
        "648e+110"},
    {0x1.e0c0dbb472726p+369, chars_format::scientific, 110,
        "2."
        "2581394399876124280153365057814815764302068078753638901090175766989876139196030042285098363557295576667337"
        "5232e+111"},
    {0x1.4debd3de5d8eep+370, chars_format::scientific, 110,
        "3."
        "1369126450743351223644868042070675972090081159686147607453289681648331706776244444631548245507008496724973"
        "9776e+111"},
    {0x1.d1c493d286bdap+371, chars_format::scientific, 111,
        "8."
        "7510056100378395690784980624038829114601832136779682652828503892083478742480986973358649610777828405911675"
        "20768e+111"},
    {0x1.cd72d6d8a7970p+372, chars_format::scientific, 112,
        "1."
        "7339706643869121258726938974735603064835059619375884365102866734218900584708555459322587759993837647617461"
        "321728e+112"},
    {0x1.01627039cb9a4p+373, chars_format::scientific, 110,
        "1."
        "9343312542187018384535981752172379437374967713524355748898830982683829822839502209431730310975458370694991"
        "0528e+112"},
    {0x1.a01e0e84d9fcdp+374, chars_format::scientific, 112,
        "6."
        "2545245092335882126108305965771766597669444535111067555804870482886040056811988312399155986378436981153821"
        "884416e+112"},
    {0x1.37e20c15e4800p+375, chars_format::scientific, 112,
        "9."
        "3756223883151274037776724128790650140133888300427596011365023775012865413735920483562596969561373256776918"
        "499328e+112"},
    {0x1.92565f524e5acp+376, chars_format::scientific, 112,
        "2."
        "4189606341952683163954956898091435430652584365332337819227907179820798920177370025314491683238577112989546"
        "053632e+113"},
    {0x1.b27b47d7ee854p+377, chars_format::scientific, 113,
        "5."
        "2244400989180613708016642369319182679190202045827186553245087278546335559625166994733343152362652931456245"
        "5371776e+113"},
    {0x1.1a868033c3960p+378, chars_format::scientific, 111,
        "6."
        "7944746787200907808603242384755872832913064104675448489356275041550002402856992454666698062568933721142691"
        "10272e+113"},
    {0x1.a98ac07f11c9fp+379, chars_format::scientific, 113,
        "2."
        "0467783827424351314753295564603510293706201890375250515969705111536696782068891131403276581805836580797857"
        "7133568e+114"},
    {0x1.b41b1012636e1p+380, chars_format::scientific, 114,
        "4."
        "1951757921839292213759825458518138580350363545315758818513021797966832710089891213192425152837196142758511"
        "89747712e+114"},
    {0x1.999b23d856f1ep+381, chars_format::scientific, 114,
        "7."
        "8805169769477226984395501914952674333569036724903321387668001616095460959550982116058583249541808618961273"
        "74426112e+114"},
    {0x1.305a3f8fdcff6p+382, chars_format::scientific, 115,
        "1."
        "1711035514327281549569479949647964640917578793955961246965709191416705947065939295227543589878996722369308"
        "020178944e+115"},
    {0x1.2fd99084e7c85p+383, chars_format::scientific, 115,
        "2."
        "3383386959238677954878784167726164592108668182912101860698293836127081479738719391011173946982487947813847"
        "224549376e+115"},
    {0x1.5dec261193077p+384, chars_format::scientific, 115,
        "5."
        "3857995214454247079845670802965140023858333719204363366340740225260425158789455385343584022277219076052133"
        "007589376e+115"},
    {0x1.a60cf45de0593p+385, chars_format::scientific, 116,
        "1."
        "2991906643558943497776765144933401250407988823770730810837676141094927055248128228359441124695444705145614"
        "5233281024e+116"},
    {0x1.206f40c937d33p+386, chars_format::scientific, 116,
        "1."
        "7757658123869845357629737099847397447653687701530379687300816584667928918967996853131360707771162482916206"
        "3377989632e+116"},
    {0x1.f728c980c890fp+387, chars_format::scientific, 116,
        "6."
        "1954646341609976085673971120649779342699001513849840231358690997934347214984119446504411488896637852182451"
        "6257087488e+116"},
    {0x1.51e04772f1442p+388, chars_format::scientific, 116,
        "8."
        "3206223754149984905262009476365485915766118890208584807835460259921682480854584795055699327086777320143406"
        "8744404992e+116"},
    {0x1.0912df6441979p+389, chars_format::scientific, 117,
        "1."
        "3055545505825232086506744135488604281383304022944946031545563740443859815673730758680222956937027900408944"
        "93689905152e+117"},
    {0x1.857ce22ca5331p+390, chars_format::scientific, 116,
        "3."
        "8366504348199781380991738809085235392423352317101826308761234478383352326472236353090210178395092413399713"
        "5095922688e+117"},
    {0x1.bc467f73b801fp+391, chars_format::scientific, 117,
        "8."
        "7526706824277039804869639245253352271037282619434215254665000654758996864632114043366545497170167003892468"
        "19052290048e+117"},
    {0x1.5bfa6323e5cacp+392, chars_format::scientific, 118,
        "1."
        "3711034277595369451570589073470256687658486148188112798860899459323262624831806105873306826350434346072337"
        "605128617984e+118"},
    {0x1.82a929b1cf7e9p+393, chars_format::scientific, 117,
        "3."
        "0470421880719791602243842186576186831668322594660054521032291978571860787539774239209841117297370413955572"
        "37497266176e+118"},
    {0x1.e182eb353c038p+394, chars_format::scientific, 117,
        "7."
        "5890060900329810907778135069349980508477554859344923632527216513475121169687165679512398393358954773663216"
        "86314483712e+118"},
    {0x1.4c41f45ceb5f1p+395, chars_format::scientific, 119,
        "1."
        "0473293912342298987927246042991799310231168245309594826043341824105346363795733309621096687761084862433196"
        "1409430618112e+119"},
    {0x1.4ce2d62a959bap+396, chars_format::scientific, 119,
        "2."
        "0986207045386187035799822440645799479070868059612701038836836380807719120666384981860675905079915949244389"
        "9741222207488e+119"},
    {0x1.00a9e2d3e2ec1p+397, chars_format::scientific, 118,
        "3."
        "2361796613868836525379806150950870022180432502860960693384846782308777259801858316206937444651533852177335"
        "846776602624e+119"},
    {0x1.3c23db7779f4dp+398, chars_format::scientific, 119,
        "7."
        "9721938562445268040649779405182935693865706103206722247447720994088701755123003496336677691442819314314554"
        "4747212341248e+119"},
    {0x1.6ad531cf6c4f6p+399, chars_format::scientific, 120,
        "1."
        "8299315060253445306822233068116074307732330134667370038475622918226677729850029074390245769729323917420193"
        "04962257846272e+120"},
    {0x1.c98a8c0cc02abp+400, chars_format::scientific, 120,
        "4."
        "6151785414218586084275351425717484666160584024314001571165866826527327623500176415071801918580197955917500"
        "03286534520832e+120"},
    {0x1.2599b4edfd3a2p+401, chars_format::scientific, 120,
        "5."
        "9230440706966047717326163349200388918611422161526449532524396598065679686912294908338576147662067326812164"
        "89965037289472e+120"},
    {0x1.516e7c40f57a3p+402, chars_format::scientific, 120,
        "1."
        "3614572894634939353142377534464507149983196785530379090825385582763759726965237412732356418889923433893291"
        "96566586589184e+121"},
    {0x1.554ae9a6c9824p+403, chars_format::scientific, 121,
        "2."
        "7540713949104843243302627542794727706292756358581474088345811708780298515935733700113910390877013926695327"
        "834062687567872e+121"},
    {0x1.9f90524b6d626p+404, chars_format::scientific, 121,
        "6."
        "7068091096020020505776863609624159835496159279383022951686130797028480366726992103594952376070018327492179"
        "668721922473984e+121"},
    {0x1.f8c257fe070b8p+405, chars_format::scientific, 121,
        "1."
        "6292678335806154630688166360914362590126745415634992847446511649792612396156901611908157238175191592424439"
        "211776934936576e+122"},
    {0x1.5063a56cc31c9p+406, chars_format::scientific, 121,
        "2."
        "1716027038832320074453150446374026503717287483078072472301776792170195683193847483635855535294750821428190"
        "165824465534976e+122"},
    {0x1.bb50c0252104cp+407, chars_format::scientific, 122,
        "5."
        "7237560998963261164051475899051612535051551295856297249862290579139114947796469709121788745828899583108208"
        "8581314451079168e+122"},
    {0x1.0b03b69a2e2b0p+408, chars_format::scientific, 121,
        "6."
        "8949817308561794549773992006993513829524212638254346703503829281462167149828570295031646850093094407936155"
        "968718596210688e+122"},
    {0x1.9d8bbd0e57606p+409, chars_format::scientific, 123,
        "2."
        "1357574596497743245860643997782974152312583530928288914224621653851840906558437370562946768094258527345206"
        "20544272774463488e+123"},
    {0x1.1eafceb2b72f1p+410, chars_format::scientific, 123,
        "2."
        "9611872773222930848265894941833298594051480342864701926761084411127391592246266694592950694937066266564299"
        "36634490345488384e+123"},
    {0x1.b82d31fcfdc41p+411, chars_format::scientific, 123,
        "9."
        "0931666168547726710852599333169027626752891656307580547988405863720028970181687484382687622774816982835218"
        "76304509982998528e+123"},
    {0x1.29779ec1c6410p+412, chars_format::scientific, 122,
        "1."
        "2290156989602754537188673668770576138329717434120236431962501631025557907262224101324928918849724892961105"
        "9352012297601024e+124"},
    {0x1.8e05bee28280bp+413, chars_format::scientific, 124,
        "3."
        "2889389033303796449610654007165182953567964772463647692693215012898721719963971688537999284434771305893464"
        "950312791814701056e+124"},
    {0x1.cd14abd1e732dp+414, chars_format::scientific, 123,
        "7."
        "6200044935673398642622195088614903967300342277550390461020413082744224194474257008465422235137871949221256"
        "83888888047730688e+124"},
    {0x1.f2ef51feb4de6p+415, chars_format::scientific, 123,
        "1."
        "6491192862717743459504613539680569605439580112970832661186872894477331119766635885443857313224050612361945"
        "47001764989632512e+125"},
    {0x1.413ce3f0889cfp+416, chars_format::scientific, 124,
        "2."
        "1235620018124725762823525254067453590318834283041039191040578016476648938361158060769801016374834626942712"
        "350029888538804224e+125"},
    {0x1.80779e1506fc3p+417, chars_format::scientific, 125,
        "5."
        "0830874862362334487451129733251317057747109313328626544800449217083767630732412027666136584929422598750310"
        "3152602026665312256e+125"},
    {0x1.f4593e67fd929p+418, chars_format::scientific, 126,
        "1."
        "3230337364814056119849144104483197847048392528104234116224062666811174319203483085958637551302540391438025"
        "71352312329397075968e+126"},
    {0x1.5e1972e7208f0p+419, chars_format::scientific, 124,
        "1."
        "8514824347085014041034982349366075446352413910270634757929615930906113455566549359084851716055947436562390"
        "414624100043456512e+126"},
    {0x1.96497bf3d6e91p+420, chars_format::scientific, 126,
        "4."
        "2972556458892421007071921590288958039713385593786669880815207200398101594477491672457613092647411327609206"
        "31315371878690848768e+126"},
    {0x1.b393f1a1dd519p+421, chars_format::scientific, 125,
        "9."
        "2141239833535442307495264704767013470628707238636280750414584559225026149348200036806199690531376531707581"
        "0956198895278882816e+126"},
    {0x1.7a530210739cfp+422, chars_format::scientific, 126,
        "1."
        "6005984240937531553977123570777698478974555023476350130842071714976647285213117935899888129628035947633907"
        "59168408062720475136e+127"},
    {0x1.e3afa67c26cadp+423, chars_format::scientific, 127,
        "4."
        "0927181564650245664684010226800985508274931575889090496315744789588249190795251849188275548896093477913352"
        "511764494291847610368e+127"},
    {0x1.9c6025d074da1p+424, chars_format::scientific, 127,
        "6."
        "9786454159176674864700637406796740953505985859818133214098100802723756933031499786749130394936305869987683"
        "275467906968807538688e+127"},
    {0x1.065f9b19a0340p+425, chars_format::scientific, 127,
        "8."
        "8803093525901790594982236846498580271914853355874023243258275639983018618600818017364376548834290227200203"
        "210514836291613360128e+127"},
    {0x1.28065949e7553p+426, chars_format::scientific, 128,
        "2."
        "0038549597024574338594732478616631677568333105265167477289796063542021264807661101295192553137929339912243"
        "3770669620377086328832e+128"},
    {0x1.dbade2e06f07dp+427, chars_format::scientific, 128,
        "6."
        "4399483471848686999328022709529943105219847426826425963616573474166235421197828954939077104844009424956504"
        "2561286390284027953152e+128"},
    {0x1.67ec7d8c1da11p+428, chars_format::scientific, 128,
        "9."
        "7456033854245786907306605750937459421920460271523533041156858959899772921310171261122772021520178944401570"
        "3751438749985539096576e+128"},
    {0x1.36a68148c8217p+429, chars_format::scientific, 129,
        "1."
        "6822870661885090958385346032176857964800605455135588888859748256350036651024576361188290442850767472967245"
        "64008491547307408359424e+129"},
    {0x1.dc66b421571e7p+430, chars_format::scientific, 128,
        "5."
        "1597778549120001229289458271163044652451269262060879726520252526449648716471874100678026909960298060927595"
        "8445716698126369161216e+129"},
    {0x1.e15c9d78ea3edp+431, chars_format::scientific, 130,
        "1."
        "0427009479036797635591813366203348981474741136468047501540682552044326004263090661138730742715935642137479"
        "038773324522255424684032e+130"},
    {0x1.ae724dbf30ac9p+432, chars_format::scientific, 130,
        "1."
        "8648218159777694177481503600699806145043094305377350786229177843605334855672050247798038788160317453858732"
        "791008998841995499667456e+130"},
    {0x1.430c116f28682p+433, chars_format::scientific, 130,
        "2."
        "7990719302881792634700208092144765627066028833203628809049595452520597537685450205232172055768615049488552"
        "388925979796926720114688e+130"},
    {0x1.b320abff3a613p+434, chars_format::scientific, 130,
        "7."
        "5404073589427982521492145814481406113541244937512463581995784007627029840880320602509298790920487878388844"
        "654553206928916206321664e+130"},
    {0x1.18baac522a7acp+435, chars_format::scientific, 130,
        "9."
        "7296165332704723045704171191722918884493939736170883951246761040671035725057112924877995355372000233079961"
        "207242515380010313842688e+130"},
    {0x1.4fbbb115a5ca8p+436, chars_format::scientific, 130,
        "2."
        "3271929702892176037363768624801721835810256036604734587782097015027264419314374804953369595074041437169634"
        "435618542541666787524608e+131"},
    {0x1.5d9b4105ffe61p+437, chars_format::scientific, 130,
        "4."
        "8467161954318765570206772089452679519024878853690657983280010268378541784588648092071300919466243785467023"
        "587557836850971723956224e+131"},
    {0x1.382005bbee766p+438, chars_format::scientific, 131,
        "8."
        "6541977087367826921470113849963863869585467375989900445327495698166495057215393260668100684145346758054415"
        "8666736089780468257390592e+131"},
    {0x1.c059a164fbd82p+439, chars_format::scientific, 132,
        "2."
        "4862535742483091390191909586457946706024424055353263778438466175657794451813458472398193755926372662623451"
        "83038540336851637686501376e+132"},
    {0x1.979cf64e101fdp+440, chars_format::scientific, 132,
        "4."
        "5207063266727990659368929644998212413214149738920414291494058222664431815342298802512144646301868226085980"
        "50594119641896654588608512e+132"},
    {0x1.83251647fd9bfp+441, chars_format::scientific, 131,
        "8."
        "5873988136460143134983733826396094677529073230527739927893738680563947508807847000923691955914241843467770"
        "2372087294487581239017472e+132"},
    {0x1.955ba92aaabeep+442, chars_format::scientific, 133,
        "1."
        "7982783689310961422227501310791755104585871964598378773168639232069183211020640286592664999710754396217634"
        "910130253608134690434187264e+133"},
    {0x1.8bb4dd0dfbad4p+443, chars_format::scientific, 133,
        "3."
        "5109229274973699347864490677759997223881087663817023913545612763146947306489437899751559803448131425726260"
        "143262853014497255579713536e+133"},
    {0x1.f2ffa36c6b9eep+444, chars_format::scientific, 133,
        "8."
        "8547728683465430818848616424135997758540156493969637657019447732001527537631411528969363199598954727491766"
        "342717137006267941580177408e+133"},
    {0x1.632ab9a3bbcbap+445, chars_format::scientific, 132,
        "1."
        "2604934227155402813818790481090371090896480259008670745003764210449531315889057203384400641053527209665997"
        "31195389894188478482087936e+134"},
    {0x1.7d9bd6980a8cfp+446, chars_format::scientific, 134,
        "2."
        "7086719929942504183980874941517960977139696239895794732813024870408238539671003001155194987629524329723486"
        "9643886677394157405489594368e+134"},
    {0x1.a0ffc9a223266p+447, chars_format::scientific, 134,
        "5."
        "9197489271133585844975485777857856224444082386611780564812362396421052336042330739080175933534182879047767"
        "6111442443375110521989627904e+134"},
    {0x1.2f2d555f5fce4p+448, chars_format::scientific, 134,
        "8."
        "6078455047134678604434818618455571588162294805214457729391162123838507816170041687711921610823738459963116"
        "4804764816415732192769998848e+134"},
    {0x1.a65f9697c0d52p+449, chars_format::scientific, 134,
        "2."
        "3984166963813072130304254866815544719778779058112414594148507465903882624211291997549855045437187950977197"
        "1753138721689172308884717568e+135"},
    {0x1.1e2be5c1a5196p+450, chars_format::scientific, 135,
        "3."
        "2500079608629177786469594361062615885964978686442183195525824456070734494611472398735816156518917726424812"
        "39481297672424409886179196928e+135"},
    {0x1.47b6e3f5377a9p+451, chars_format::scientific, 135,
        "7."
        "4436102486817026391330384910904960377209366279201460342224886867177126680907304411140987558975509995313169"
        "63156312332013839122343919616e+135"},
    {0x1.aad9cc8c1c972p+452, chars_format::scientific, 136,
        "1."
        "9390729656615215196506812000617451479776711512449142787848459303341260609191028331093673283435440617925958"
        "437747265492354517993099624448e+136"},
    {0x1.8cc0ea5310fdep+453, chars_format::scientific, 136,
        "3."
        "6046982835224656412915754976920501824030544272349863266164621223344701329058249574603030560264745117993137"
        "684398776063481336351546146816e+136"},
    {0x1.e8e380e2826ccp+454, chars_format::scientific, 136,
        "8."
        "8835807100315059364957572853053758885118262053119958231473714438599572821951098669770374248448262038769401"
        "918432797048903756272554213376e+136"},
    {0x1.2033b9d066e11p+455, chars_format::scientific, 136,
        "1."
        "0473820665170048878755154408578719330325269921188949224604166784423321269440809970793883543719137433912200"
        "960322988368687585762606055424e+137"},
    {0x1.7564b97a79d61p+456, chars_format::scientific, 137,
        "2."
        "7139682262053297241988392724437792044208285211247000447865789047411414826976478691092595194217736809420582"
        "8453389512306293635710562861056e+137"},
    {0x1.2b82c2280c26fp+457, chars_format::scientific, 137,
        "4."
        "3539205936145104705820726228284843445060921065728394032721829835221039495244642053528782260776415870011292"
        "0667363070863633573415250558976e+137"},
    {0x1.bf1f7396a6e57p+458, chars_format::scientific, 137,
        "1."
        "2999448293666169914859805985488601512306519687598179446463228767237657957150042169876476045654460534381097"
        "3852347955449052461046878437376e+138"},
    {0x1.a657699d2c0dfp+459, chars_format::scientific, 138,
        "2."
        "4557929966471053199872649466981740356692231404103633543942219010330417450053674332463696723123550304578318"
        "75446589644026555749761133051904e+138"},
    {0x1.288594faed777p+460, chars_format::scientific, 136,
        "3."
        "4483764818218847425999970317030640238793097206477624197384500971308224538523438179692769564897834190472272"
        "984703422288615432778015571968e+138"},
    {0x1.2375adab19290p+461, chars_format::scientific, 138,
        "6."
        "7790138521807316420628038773287438668644664004594370167025452117781647057165800982402225795850370051610486"
        "65824473078182953740522326327296e+138"},
    {0x1.83324c05e70f4p+462, chars_format::scientific, 139,
        "1."
        "8011480968834750196365369192967420715415862985071604121776057399720459471533740960032406448817837519216226"
        "379536264641695755986389226749952e+139"},
    {0x1.97873666d985cp+463, chars_format::scientific, 138,
        "3."
        "7914529023902069557105004428400868367552071861042286022257178185224413635321720588745810122575048414255517"
        "01851829776853108766540296093696e+139"},
    {0x1.5bfa9fa8f352fp+464, chars_format::scientific, 139,
        "6."
        "4748700546465721232888949688272095534998009840175105196292202572473650907793490793699624888993654341347901"
        "931540117631355075040339017334784e+139"},
    {0x1.b42b6a79cf7afp+465, chars_format::scientific, 139,
        "1."
        "6231677484748647738284246889132703021787090536862881417070276086241812776564227608785040979834680452730627"
        "673951299390073462133082170589184e+140"},
    {0x1.da02be394de37p+466, chars_format::scientific, 140,
        "3."
        "5279804769813379877739625265790221988342974868955307215219678257545606581258685003954570507986505945443644"
        "9176466265315274091295259079213056e+140"},
    {0x1.3eeed2ed5a952p+467, chars_format::scientific, 140,
        "4."
        "7475258680916253745897531734514044938760808711217428348829658546005624616624979279156129711124921701243923"
        "0326495036221766234765211123843072e+140"},
    {0x1.3666a3d10b839p+468, chars_format::scientific, 139,
        "9."
        "2410438112435489734379685774435069421261232157650793824990530192357729924647916137217180562449829723923226"
        "838139416593417420331177274769408e+140"},
    {0x1.2570fb22b2de6p+469, chars_format::scientific, 141,
        "1."
        "7472268158903567970489376394874270060913393878056825078725374417255330239774644537653308699459602551618379"
        "02768182371165254880871258817298432e+141"},
    {0x1.b07e20dfa1d42p+470, chars_format::scientific, 141,
        "5."
        "1503502855445633918124843079814372660247218165154922786481877126700784289698976045903050168159110788693854"
        "75223702592482681568973998545436672e+141"},
    {0x1.c0fecaa34903bp+471, chars_format::scientific, 142,
        "1."
        "0693743613454128344229738507659554069041113104116305538551763636641133000749164190535494572802701842844775"
        "713873914174897214881753809553457152e+142"},
    {0x1.6a93c2fdb14e2p+472, chars_format::scientific, 142,
        "1."
        "7271039275900878702320064613161114211734760062020379022350617158951989967269777650968393695346424676919360"
        "350528737280818370651311134702829568e+142"},
    {0x1.ed356c6ec0f02p+473, chars_format::scientific, 142,
        "4."
        "6987106320234365309357865348526617076295430864840940367700909254686103875433346901774408206734975670041416"
        "172724241468670572852355997846470656e+142"},
    {0x1.fa2a9a922005bp+474, chars_format::scientific, 142,
        "9."
        "6443133006154375629544673773217995571737351906051889965372169517032873570684626710445723256193599631347074"
        "349343808996878649261861384554020864e+142"},
    {0x1.7779f5e06053dp+475, chars_format::scientific, 143,
        "1."
        "4308385405721830409588986842341221217630751607519642205768203476726949608471686240173850875709383849977420"
        "4490512832595931739164387055612461056e+143"},
    {0x1.2ae00f64ca014p+476, chars_format::scientific, 143,
        "2."
        "2778645782254102124024170465292525325953086411923614498725917672177361290237337288215777392459244097224025"
        "7516688035006692022253572705950367744e+143"},
    {0x1.14617f48912ccp+477, chars_format::scientific, 143,
        "4."
        "2128491843628015690123491447499183775579140689758554402383290954566150779370440635482704842123528539898814"
        "6300675184394950248081186488630378496e+143"},
    {0x1.0e36f018afe63p+478, chars_format::scientific, 143,
        "8."
        "2377152265461927468904475031209979234555951818796497236476191970051849571112509654722312234611809959811641"
        "4799396399785995085176935884420808704e+143"},
    {0x1.b52a83911a3c4p+479, chars_format::scientific, 143,
        "2."
        "6654737215359226174536865647606054602172499959987706988316732285249892439427281825776876900401158871819657"
        "3169689339585153422638164295314046976e+144"},
    {0x1.ed98b659547bdp+480, chars_format::scientific, 144,
        "6."
        "0190791388121617864043227714242098900748708658128288053595523523236653831506983860037384561642314883951698"
        "44387225601064643184790911958453846016e+144"},
    {0x1.fcce356c4ec85p+481, chars_format::scientific, 145,
        "1."
        "2409084690292541652527613045437775018048935473224778548554214581456588840011339733629203404858897924037517"
        "041939851403445857567862463857852153856e+145"},
    {0x1.3dc01483d63ddp+482, chars_format::scientific, 145,
        "1."
        "5499009048061588814641526995523600939707388795282617174767697160344249266869043729431751617061601018589761"
        "944702337982434466462060034234811154432e+145"},
    {0x1.4557a7b0057d8p+483, chars_format::scientific, 145,
        "3."
        "1738661663567816264285516822801972971728151651206469963506380696188890277837365396682106309758742282006353"
        "922475242220366972514288404986230472704e+145"},
    {0x1.669d69cbaf0ddp+484, chars_format::scientific, 145,
        "6."
        "9969095646663514806564458838233472693358039320736641847439538782518050931122329603176958512021576452086116"
        "368782676471010501175026121646448574464e+145"},
    {0x1.6a4308943f906p+485, chars_format::scientific, 146,
        "1."
        "4136130050003495275965580705190245360273003406456889860795577433714410287964689565247783341979195424013701"
        "3541670491478732029287175906702745665536e+146"},
    {0x1.7e7001ab289dap+486, chars_format::scientific, 146,
        "2."
        "9846844767329699730804823460088397797510887741980731170544140686250237048357484822927489181913790614021254"
        "7533066937938143958203611335491240067072e+146"},
    {0x1.44fa24aa8c90fp+487, chars_format::scientific, 146,
        "5."
        "0724842971646726557538500759842253464019052289835282388395679467419407983799647286830871888227794990888424"
        "5889023882897106195080463734761662185472e+146"},
    {0x1.25d657eccb0e9p+488, chars_format::scientific, 146,
        "9."
        "1728610014857275568630794658652531231738100002919045253200249494512141469153567046655808833763172390263394"
        "9642595917883820840553955755394812870656e+146"},
    {0x1.fdc48127436c0p+489, chars_format::scientific, 147,
        "3."
        "1827325058993567033331233752691212903377352608036310991356332821822901954914663377518977669960782647885876"
        "42034976623676783849309720668272859283456e+147"},
    {0x1.50cc21e5e879dp+490, chars_format::scientific, 147,
        "4."
        "2055870839470368973611151678893166078089637115801651589474584679020395433716298683315313593307964143156245"
        "28062235406626283210983955984299738529792e+147"},
    {0x1.5a4e10fb478ccp+491, chars_format::scientific, 147,
        "8."
        "6486157205772329602600102378606658784899216279777069711674137164731822935624882824299743209883343812966340"
        "69075898792649120978628662820343688200192e+147"},
    {0x1.e6b342df1851fp+492, chars_format::scientific, 148,
        "2."
        "4309692254959332536450538679079560253529415066541042380383420527274189578274453585054569384583992487731455"
        "483906898199659271966077737111144370274304e+148"},
    {0x1.bf189fba46a51p+493, chars_format::scientific, 148,
        "4."
        "4663099980821111700735062823707061081964579432094161222504349764876114111980602434939174729613231975280697"
        "191542952742623676348156107248907356995584e+148"},
    {0x1.7744c67ce2733p+494, chars_format::scientific, 148,
        "7."
        "4975640039478889368046232138806074105698824731102334281006775249643928390949836346608458092165052666069303"
        "519645320456702179748989546565091612164096e+148"},
    {0x1.dc39acc6db7a8p+495, chars_format::scientific, 149,
        "1."
        "9029191895593582513042254429613933892519819466440008181362475451661449874055230966283314835362517622544618"
        "4345874717099016754240440378652340420345856e+149"},
    {0x1.db93ed9dfa8dcp+496, chars_format::scientific, 149,
        "3."
        "8006641833677102492887824906118725961379661738962189610447881646688988112543794681781941996783845042196323"
        "6989721829537772787957124251662568730394624e+149"},
    {0x1.b0906aca51c5dp+497, chars_format::scientific, 147,
        "6."
        "9138249940821013776040341733524915351912661776644830548370675524262798977629271437574440357029271950983009"
        "12889719993286829251194606517019647934464e+149"},
    {0x1.108f1f5365715p+498, chars_format::scientific, 149,
        "8."
        "7128154838017157392572522860918668800672134186008534463400197915073924087965859797620971620007008411202092"
        "2177725097537079407027753889855794306875392e+149"},
    {0x1.73f5a2326daefp+499, chars_format::scientific, 150,
        "2."
        "3780639727460606718971338187316809987528213181384630599789933496032265252598793205389604654238668756538754"
        "31703645955198350097511963193717040609230848e+150"},
    {0x1.5d60e9bc96714p+500, chars_format::scientific, 150,
        "4."
        "4673926496387289708030095900258305973038660116707814882439878055497811702692322213460750885548964045810631"
        "90784109692968975073166801707596473568329728e+150"},
    {0x1.3b69dd2b0a7b8p+501, chars_format::scientific, 148,
        "8."
        "0661850781591161677122954721172068591732257201798966036585171037261748611696578597260945643403701202524424"
        "416735637962153511596447310123657955639296e+150"},
    {0x1.70986ba3519c3p+502, chars_format::scientific, 150,
        "1."
        "8852448369964825428928236009439861167135645949955343442728306696583016816237354048060006184106295445822087"
        "64698138596718695789572228160443206070173696e+151"},
    {0x1.5c9ead10d3adep+503, chars_format::scientific, 151,
        "3."
        "5661527237397952344670186371555605241594133611593918425171554010625322731432466488798805829069196773260339"
        "528369728020651143141594374865566386412847104e+151"},
    {0x1.2199c7c3b4ea1p+504, chars_format::scientific, 151,
        "5."
        "9248514116816446405034179271903794942228235937785654591274434436685914444005512695452376722135010343543480"
        "884465555148433997142511793829160779635490816e+151"},
    {0x1.7012b5d2cf305p+505, chars_format::scientific, 152,
        "1."
        "5060587321219466553012870351093686397249916401759472434092827544464856133318187035806973362924090662903749"
        "1671355128894869419427983062506453820908765184e+152"},
    {0x1.5d488913a6d62p+506, chars_format::scientific, 152,
        "2."
        "8583520249281916338866314327559210987065565190673533620469014785587813138788138839992315111228424039110187"
        "8885418173061097660244197201776411569329012736e+152"},
    {0x1.151c3720960e0p+507, chars_format::scientific, 152,
        "4."
        "5354498949077742169034443406216049299770028918272764456328676932798016382716888496031992258428716623824999"
        "2218941837638686010641196013298349788803104768e+152"},
    {0x1.3557fa79ed04ap+508, chars_format::scientific, 153,
        "1."
        "0126026499623770044576994423798637012002417501464985878117760782996493012648396817497758322250050492041349"
        "01434458455631896130313812311189422436650057728e+153"},
    {0x1.34632efda2f08p+509, chars_format::scientific, 153,
        "2."
        "0189450716998492213121147666474166009392711045094381728529008061117293669417942835283009277823392486547470"
        "13008590709252183660814342129605380010212851712e+153"},
    {0x1.d18dd31d25525p+510, chars_format::scientific, 152,
        "6."
        "0957603982087232982909513121211465815599741588204415820396298222851596266515550801404820224265065922278874"
        "3115865057982121845872416589866036396684214272e+153"},
    {0x1.9deef9f325dcdp+511, chars_format::scientific, 154,
        "1."
        "0839728287028179041104779394402998431149044866332968906003742365561718883404305927813627842460928319702403"
        "984206679307763828828827451150213226478513946624e+154"},
    {0x1.80ef70407b9d2p+512, chars_format::scientific, 154,
        "2."
        "0160697875193073281058350414245510320201644882796531994091425667271465650234996404676918103588204703802980"
        "632898021029981572024314647222500081978631520256e+154"},
    {0x1.b15f90e524369p+513, chars_format::scientific, 153,
        "4."
        "5395203367398852029035305208109368042694923882699028139843273249770514204350231474300282943704322434188173"
        "61739058201501829021491250719502352274386059264e+154"},
    {0x1.7d04016826a78p+514, chars_format::scientific, 154,
        "7."
        "9821634470750785005816307052453796709151400402439168637259226600219936117575503983393755774577473554235475"
        "350529315775591347087019497446187187442089459712e+154"},
    {0x1.09207e9aeb4cep+515, chars_format::scientific, 155,
        "1."
        "1108659309948223232073721981058486015639763921196063562755246502603396586456380455178355920137319345651353"
        "1979239601685059643816826533951965329199816769536e+155"},
    {0x1.5eb84ec7e3693p+516, chars_format::scientific, 155,
        "2."
        "9389910968456540497145308817665722993724686326666865780387846928243089920830213473101442296898483553295520"
        "8915016266000487049786013109396266423674162118656e+155"},
    {0x1.cd831a4414f7bp+517, chars_format::scientific, 155,
        "7."
        "7348323201078494069759154153148452216906433545612171796327606278267578531935859682519963528897995839751164"
        "7543570671668790057093880969098511595082212179968e+155"},
    {0x1.3c41b73edbcf8p+518, chars_format::scientific, 154,
        "1."
        "0600772804334341824498673238754643000590112296311638116693641098492271731881033950635386567714769641582038"
        "129703645750077658115580500414849678160462610432e+156"},
    {0x1.7de6915655786p+519, chars_format::scientific, 156,
        "2."
        "5602253164214019794228034929986330634069568667913627567267961346885683499448441433864914716779614560756659"
        "03377049407345319868363294328606411349469066952704e+156"},
    {0x1.e47a65469d029p+520, chars_format::scientific, 153,
        "6."
        "4957894162689224015531687169668567969940639978728659196460226175437163963971643262151792036582074933138652"
        "50447186614103438727429420216590467896398839808e+156"},
    {0x1.866eb1b2a52cdp+521, chars_format::scientific, 157,
        "1."
        "0469685229597165679242472867781707564232232115066593897597547823552733586500623731175655852654661036675944"
        "667470248283335770956666084386262948697191024164864e+157"},
    {0x1.508c027c49129p+522, chars_format::scientific, 157,
        "1."
        "8049425471684503811692336471805744340392676090966559914158167829693248936857451772455022819546651020419395"
        "086693907597563666097234994451590506212471517216768e+157"},
    {0x1.61ee1b28cecdep+523, chars_format::scientific, 157,
        "3."
        "7963414617308415787809596904160555114321348252647420762121034631479538120026400394885418700946009320148869"
        "300117380342424037408264379528162055292585638887424e+157"},
    {0x1.a7da0d015e36cp+524, chars_format::scientific, 156,
        "9."
        "0926768024467341820333176481577483392918662852566121383240080801535518391810171083632685627972390044164430"
        "68688466546996181994685113127876888475052825116672e+157"},
    {0x1.f343d287ffc8dp+525, chars_format::scientific, 158,
        "2."
        "1420954571874796181867803558173897390873628203612099816299639538188847181871424707442829555039446305144765"
        "1015663758672875883679550666916401541316002057289728e+158"},
    {0x1.9c9c3a3327bfep+526, chars_format::scientific, 158,
        "3."
        "5406074604903996493796486071626953502852438595335202338839222961489306095343149732156950905287112321360780"
        "8354960582121162245411977647195367953750953520267264e+158"},
    {0x1.610edb058ff32p+527, chars_format::scientific, 158,
        "6."
        "0591798371136819507430990360066620553732791972857074064150285578732374423137313166606132376705119733187389"
        "5394455715612868333780052349810329711384825746685952e+158"},
    {0x1.f30c74ca208cap+528, chars_format::scientific, 159,
        "1."
        "7129340266632834749953577858343993939516249529867835081849172692553781768247897374384734210875421524426627"
        "95936288492656745381512223241233513801086791472644096e+159"},
    {0x1.1c138fed7032dp+529, chars_format::scientific, 159,
        "1."
        "9501271083673802659787898406127054138324463280765738674858806150954364373930724252610104418333259637179348"
        "62664034468096428283397061878573723884854136941838336e+159"},
    {0x1.78c95f77c873ep+530, chars_format::scientific, 158,
        "5."
        "1731277182329399807450239014797118750746786034562901386123351160720955621307415583371062151381510556778868"
        "4863245902366518485000140068796841840045365854732288e+159"},
    {0x1.6459f93baec50p+531, chars_format::scientific, 159,
        "9."
        "7851226544599463771564921368556921827542040445585447659018246369324390402047706431276015403214773792169641"
        "53369345749073097713940190208348710065187772895854592e+159"},
    {0x1.7906aa9a30611p+532, chars_format::scientific, 160,
        "2."
        "0705659855195211460286170209038937641731272422289152825858212496294807163297965180604186403154243179767907"
        "958537137222057332190533942595916677783931001302417408e+160"},
    {0x1.fa515f09e2725p+533, chars_format::scientific, 160,
        "5."
        "5612314177003026122910357232767009218623136419014789426089817048220952364784685334500211032736310921113172"
        "928546161625907053067205424290791219411580020307525632e+160"},
    {0x1.54d8573fb9596p+534, chars_format::scientific, 160,
        "7."
        "4874640533241470730279851562518649602012685564108538483392983178670598698623549235703802716601073988953860"
        "606902557706179876262726589838088595804228576518078464e+160"},
    {0x1.87e0d2f66b2bfp+535, chars_format::scientific, 161,
        "1."
        "7217053958890400852304842901770937001126359565588473543908015592102961364884006330645313689960462043380825"
        "1320307524080356734627614383764502179134363483408171008e+161"},
    {0x1.60fc1327a06edp+536, chars_format::scientific, 160,
        "3."
        "1016554470379008022068644346655257519265668288613794968614902119460294276336894661044455582708231625230426"
        "882579521337832334896604900954598995797437634695921664e+161"},
    {0x1.992c8531ab31fp+537, chars_format::scientific, 160,
        "7."
        "1907739698299548544761759553441263855094547256115006468689749065750269245670602987652747097354199309800064"
        "670851825256317768108233601492032587469380109538951168e+161"},
    {0x1.cddee01e85f4ap+538, chars_format::scientific, 162,
        "1."
        "6233719112674834819250602540832248747933195166025444180503928859570585646532467134263435983989542489214476"
        "20240933830255782920769862417050715330898449264684302336e+162"},
    {0x1.99388c768c3b8p+539, chars_format::scientific, 161,
        "2."
        "8766398779168217186821712748845526998862701568704494700659767166699492968678738103971887270801356246232898"
        "4464635950443836780167505221033916869036529710130003968e+162"},
    {0x1.6c2ad6bba6ed8p+540, chars_format::scientific, 162,
        "5."
        "1198670788912167528683009615591842433917743580431308732145221701765414223358769100615506655778167511446878"
        "84279178798057513594382918680535607030620295902798020608e+162"},
    {0x1.8121da546cf38p+541, chars_format::scientific, 163,
        "1."
        "0829229605647497287491811471725340667019982382295287441998766070027220247968289288736829697687593326874916"
        "164752948106530119043799024142733614166064793545183592448e+163"},
    {0x1.cc5c0ae184fdep+542, chars_format::scientific, 163,
        "2."
        "5888973619862410055297953386823285447975896175369247744210466527341086214689620755203843473222529430068506"
        "678735966744366849758761825149394672284437121408260112384e+163"},
    {0x1.afe092d15aefbp+543, chars_format::scientific, 162,
        "4."
        "8574461844070456592452814669711010322733557031362825853413619938116374692585676530060249181278323860055817"
        "10108947627014752518519314486521054019823200748024365056e+163"},
    {0x1.5f1a1433b9174p+544, chars_format::scientific, 162,
        "7."
        "8978852482314809765725691489425494641108478398257497378847509387658904871074579765532782187266445909935288"
        "39354232570725767224692678438531015988394836852670988288e+163"},
    {0x1.8ab67f98bb5f2p+545, chars_format::scientific, 164,
        "1."
        "7757792408248608219840650290884562103331609396064383190252928684474923426996907505463604471391579602571928"
        "3383611834930550575178173514581572666518402542001715150848e+164"},
    {0x1.f62458acb73c6p+546, chars_format::scientific, 164,
        "4."
        "5181869438995584155942879986161607327235800888084626274207935286368186289977681849743093295766921622231766"
        "8812532970018869401576788745672335158605915636428814942208e+164"},
    {0x1.4fe1a6ba1c0e3p+547, chars_format::scientific, 164,
        "6."
        "0444067603790198680770375784082738739903558248297596449563137728373742577949182284564959980474547207384645"
        "3804398133039311346050607936591463621343012361379329867776e+164"},
    {0x1.063123904b927p+548, chars_format::scientific, 164,
        "9."
        "4366318060930614275042036245009185089291734679507684985639516919954063657248120231594112076454245476674772"
        "9956337135685250388333452322276527666526976611670460203008e+164"},
    {0x1.c3e4c9bc47a76p+549, chars_format::scientific, 165,
        "3."
        "2528493042703321141413309200996676555863097235776172037843793780326803925005135657769958248885096410603987"
        "58716325831107713950320367933304627208668064052102524043264e+165"},
    {0x1.594ccd81bd096p+550, chars_format::scientific, 165,
        "4."
        "9711199416816592464299002776950161898639000113245240977386824261505093729352843986582700405277078306324888"
        "68641461825918412782352354477687969196944687248446058397696e+165"},
    {0x1.0c6555b87dfb8p+551, chars_format::scientific, 165,
        "7."
        "7279343588562495407126280049885300491080229351189365823501345364553687726140552946628389981545368743987276"
        "85060343548384620139502630275174727089552646218700654903296e+165"},
    {0x1.b1efe87fe7322p+552, chars_format::scientific, 166,
        "2."
        "4988746130766798376827800199823813953256757708767876517238281997487181991551985565303552676809021792458092"
        "123757308008963935169221303180214415444334488294696842952704e+166"},
    {0x1.674a2eb4f0902p+553, chars_format::scientific, 165,
        "4."
        "1380191381421080895240587023700110588669580856565936068294303762090684154630617939500552507881452379030122"
        "57564369266702609329281301036802867992107269395537054400512e+166"},
    {0x1.4d10ab628902cp+554, chars_format::scientific, 166,
        "7."
        "6719679535199355279888354227234517257428645312697123534388363324410221239158316740528269628364865341052173"
        "890153833114361977767211690942890884469581914980429066141696e+166"},
    {0x1.348910101b05bp+555, chars_format::scientific, 166,
        "1."
        "4213879533988812988801489499892461314159660165902092759593012160198840631550914331540618549869245720943038"
        "591573264165447412080305585107256403832151644381045298561024e+167"},
    {0x1.f9213f77afaa5p+556, chars_format::scientific, 166,
        "4."
        "6541532390763673825077519098739600416173657505928203777805647482615365710172842479112509262117196395261215"
        "492125122729032007120120133249597715368097561405386982948864e+167"},
    {0x1.39148decde7a0p+557, chars_format::scientific, 167,
        "5."
        "7693029917278790835343693446228541151083246279328989491902151468261054433974865155786482743975400685885796"
        "8022384319234650521865502886831850045752670251564620807405568e+167"},
    {0x1.dbecf9a36abebp+558, chars_format::scientific, 167,
        "1."
        "7540289541978554536679278449080898961110674955967170960958625902039261628279839229960204922512068948500088"
        "8111062907960551667913609284846202035011913824495680054362112e+168"},
    {0x1.d4b8e3838c0c9p+559, chars_format::scientific, 168,
        "3."
        "4549610389534939614163292665079261900985718205569253011397072055313397970532490532749071748873309501615887"
        "68433100280033360041954344387894356034343704057173414445580288e+168"},
    {0x1.0a21e645d2c72p+560, chars_format::scientific, 168,
        "3."
        "9233349720899516225653006419073082111151059390156664403365001807815842714755260514950130149946827232025161"
        "76590662854806987645471308169316788500685330937565504795049984e+168"},
    {0x1.af01dfd28918fp+561, chars_format::scientific, 169,
        "1."
        "2707854970292210593587573885875803437251996278109312071923766373553351738675154455717211273888077203914132"
        "749180314815054893523728069064065041255302851675835296773046272e+169"},
    {0x1.92f36b46cac74p+562, chars_format::scientific, 169,
        "2."
        "3761271692350110891980215212946227422808590277003177300689353935734267394985067115490384266663644635321905"
        "607600207437156411377406544504086631781775691133562731288854528e+169"},
    {0x1.bfe04dfec51e0p+563, chars_format::scientific, 169,
        "5."
        "2820872264243582355340332232481921609272763546174111866258873749725898989610965360460037699636411260012718"
        "784674393928472275175596068580609021329456130597064239797501952e+169"},
    {0x1.94670a2ba70e6p+564, chars_format::scientific, 169,
        "9."
        "5387489718917882102948269594473215622857013680481211269007794315939403812083737122286688310471818933068612"
        "563309998840782226852329612567449648252694634073100841335652352e+169"},
    {0x1.bf6363fec4e21p+565, chars_format::scientific, 170,
        "2."
        "1105330303243356951146447438805265173253179909270544813724232524968355202014726255584317008254777069021908"
        "6744514884262890299095847660667744123821425839198582550323789824e+170"},
    {0x1.130ebe426a4a0p+566, chars_format::scientific, 169,
        "2."
        "5951425292354768078033905586616956725006215370952637745135245417861224604987531981214225200701240175108930"
        "840201983359378046439994040914451391630102167656335065688834048e+170"},
    {0x1.4846fccf0db5fp+567, chars_format::scientific, 170,
        "6."
        "1945308823207183058683537468760738258329716957097993465302851964798828559561781466290211511455975152392126"
        "1814494546071943712322858477374811036408749349113740468449968128e+170"},
    {0x1.cce40bc89d5a7p+568, chars_format::scientific, 171,
        "1."
        "7393845792769813157591485334728289421339191017476114033077639490417559171554638668857619030907317254081420"
        "81878718092529513244534671322128694195746568199203839343494955008e+171"},
    {0x1.4cbb8d52adc91p+569, chars_format::scientific, 171,
        "2."
        "5114408497872504889849608236610231700159606941723791669619088524835085024738028008402272439623076576729481"
        "04995738811198515357386384926071278483707177078191869448614313984e+171"},
    {0x1.cd56ecd7c5ed1p+570, chars_format::scientific, 171,
        "6."
        "9643125288033973128155017170856729588410994800848488875781660527415029309190846451750710704827305435019690"
        "67430731268878668278955626743849683963257233143847666633043607552e+171"},
    {0x1.974548f633393p+571, chars_format::scientific, 171,
        "1."
        "2296192874342279398035503660585874984268215640415692614185754893612306440618721946387877459034366883413609"
        "36918152006779286929596814740431079796422442812171122552998985728e+172"},
    {0x1.785df63f7e7e1p+572, chars_format::scientific, 172,
        "2."
        "2726320991720393806082142485686217558330202638077848150550875230011082976612969886981829508930227201207417"
        "730127845908876453052097589780463041422857268424951597133270614016e+172"},
    {0x1.fa98d2372e253p+573, chars_format::scientific, 172,
        "6."
        "1180092244552894479108133503846936836371359233960903288151843139474694399086289881596960660601999690274170"
        "051304615631465749824618705719721448275602824998439000878232895488e+172"},
    {0x1.44f76f3ef0c7ap+574, chars_format::scientific, 172,
        "7."
        "8490337018587336573333382241289679251882281880347544433206317733805938361518095340765276962431841975064047"
        "569375644124507699361497786620173012597660819648747164399097085952e+172"},
    {0x1.845aee96c611dp+575, chars_format::scientific, 173,
        "1."
        "8760165681953460413072829118958732692270564661286131167055983545979791077034420925197352908458387625197641"
        "2473853052506364697656419609232890365789316383760219161065634660352e+173"},
    {0x1.6abc94e260cffp+576, chars_format::scientific, 173,
        "3."
        "5045234562719050444563289817930312119606725049565642471521942232460177946069408153684540504194597258990573"
        "1168807151668054670532129843180363278721230005822552578189869187072e+173"},
    {0x1.77e7f7ab33101p+577, chars_format::scientific, 173,
        "7."
        "2635165849153785494563747540191483129521644872733745237579476633099320088983835423243815213775349593473393"
        "6104514254970171070110867729784675843986648873395065583346126946304e+173"},
    {0x1.ec2c8c72e6720p+578, chars_format::scientific, 174,
        "1."
        "9020249607206747490383578565711176171590073672334887637643049626295328537660038412541458277654513402022486"
        "56704594513309856716357813392938070159279476826318762074068165328896e+174"},
    {0x1.ffa5d013ee4f4p+579, chars_format::scientific, 174,
        "3."
        "9545635188621041668458681519635092022565038577625047050999641589933335359562218991630738088787131211935609"
        "93015277645286678140294132386511219265217225137785123722280327708672e+174"},
    {0x1.0e5c252b8b844p+580, chars_format::scientific, 174,
        "4."
        "1792645649574566918909157878760712130302228913462470260602194485414931164079583288497776163194723846747926"
        "67771126097789471772132138304456722148757124945602576369254706184192e+174"},
    {0x1.b285d8728f853p+581, chars_format::scientific, 175,
        "1."
        "3433838372088608392759541865783165685150864489372534049853049621196819773114326777373607298582831758073273"
        "139400905288866876199471807470183600176123459886516500946100328333312e+175"},
    {0x1.830d570659ed5p+582, chars_format::scientific, 175,
        "2."
        "3932438386350752398906060480134131184426749382780138750338631150127979246477473949125606039841210188441858"
        "566259800113585445368689288040865119179350881451516413561225814736896e+175"},
    {0x1.5b7cf521730bap+583, chars_format::scientific, 174,
        "4."
        "2972187544143624764586854064545662595041257012005724100970207585455769895698007795217153843862284368740788"
        "37417713457309033640069443709571991834451783158215011561194532110336e+175"},
    {0x1.5f8ba5e3fe8cdp+584, chars_format::scientific, 175,
        "8."
        "6947889660886424315517334917379237681473389004555025287147425576180688651377619113503080210808097080248303"
        "065713994383176911387666854498724374888010555657160403443732556283904e+175"},
    {0x1.3c656382359c3p+585, chars_format::scientific, 176,
        "1."
        "5650872395957953309347511865374635720208636296528844086575068893754566789157942879574612175260545187823033"
        "6009199988423048858224043380759941961868932909470130132231537427480576e+176"},
    {0x1.0cf69f601cbcbp+586, chars_format::scientific, 176,
        "2."
        "6609127251749555037344451329716993732732872523015958386211791209911418856092668804225952579441453946598216"
        "1018353954777170666779903498891261251335885914232419435941537077264384e+176"},
    {0x1.712601f59010fp+587, chars_format::scientific, 176,
        "7."
        "3041310915282277318283127156341286263678327106712574565671678562056257118035892836027777300336909382959943"
        "9489279348564634343854478223995096490083834564122961187316938125082624e+176"},
    {0x1.d9cb25c6870d5p+588, chars_format::scientific, 177,
        "1."
        "8749367638301195110882726444350992935900646090447817670758440898890197572172958410652798401071911495348057"
        "11539366541500871745028252870081743197260064203842403729644908114345984e+177"},
    {0x1.3f0bce2a16035p+589, chars_format::scientific, 177,
        "2."
        "5251137153536482125661277313165311760764103743192046445514228495477898656364587565420879026668975210962336"
        "21580712956165193248559493345236489976046311451102680851980278768336896e+177"},
    {0x1.4e046f64ace9fp+590, chars_format::scientific, 177,
        "5."
        "2872088975059578152905008327011014369021532127587373171513246370679335597730248232687171558021787964992854"
        "69008136051884913289117970821444349734733325693898128129470005715664896e+177"},
    {0x1.81c96c18da3b8p+591, chars_format::scientific, 178,
        "1."
        "2213351108095343900087303306426544285718316496416974886789244650584122979327515475219578337262395376593353"
        "901364495415734234777395486829707907374874417711021037161711853711130624e+178"},
    {0x1.4d6f7e4292164p+592, chars_format::scientific, 178,
        "2."
        "1111997723509844240784743048023317235372730114142490466670077948439063027728542870283482437925492280294038"
        "014573739362326768950393557886221693829978829496324438880160656306208768e+178"},
    {0x1.8c09c58dce2d5p+593, chars_format::scientific, 178,
        "5."
        "0151567233983766888518548233001321491315735325442193958423073461431568869675027140356293231317677337543096"
        "676819898009801602967325844127445604533459507481195933684935651668000768e+178"},
    {0x1.35c34702001c9p+594, chars_format::scientific, 178,
        "7."
        "8452488438025278621303101815654925040904759740554180738663377954039378219664965548160988021330044581544086"
        "790884596615125296396497742047656667223884572601517271224748933535236096e+178"},
    {0x1.29c65d36b40dep+595, chars_format::scientific, 179,
        "1."
        "5083269248992404848075529200220437643877343516690908500051239020473880544003670069908347719938640019293547"
        "9514139200504582847173176153264857561337534047601980885310892466243633152e+179"},
    {0x1.f096b560fea30p+596, chars_format::scientific, 178,
        "5."
        "0307679766475297900643310003785978353718376020933985994442740062831046797865169439521465673311238868838693"
        "647148360650272015676569826847440171961764782606079881578285720137629696e+179"},
    {0x1.2ebc1ebd45cb7p+597, chars_format::scientific, 179,
        "6."
        "1338034600015482533548856700137120559493090645959837325747342847008896961430122182715729832578195313705013"
        "4105978358652455249997921465483648671250142659113169108289945909053095936e+179"},
    {0x1.bb1e534cd7220p+598, chars_format::scientific, 180,
        "1."
        "7956317799329456455556916318367385720663341620756711043034998103313297163597767928062472500586846121139556"
        "14358367020579719652520207053724496150314508797330293943336699424736804864e+180"},
    {0x1.5a25ad40029b8p+599, chars_format::scientific, 178,
        "2."
        "8053575998151829095892405225520007274617104914173229276735386248671927242112453507121141969275457163272893"
        "568975905848289848712880545718807596992132248150509100180221916786720768e+180"},
    {0x1.920574253404cp+600, chars_format::scientific, 180,
        "6."
        "5163814759421788677873530796634949212285583652947416245608362680831586176277421534822610398383052946554843"
        "94073977159925482307630138907365278448422568005135582757883527066002915328e+180"},
    {0x1.4b2834aafe474p+601, chars_format::scientific, 181,
        "1."
        "0735479295792078221461462578241925997159828607487053072465046193583974474108661842779443009354436634868004"
        "476810418060601519121547906362418385449487160625577520457386019933969711104e+181"},
    {0x1.1a6d55bf92261p+602, chars_format::scientific, 181,
        "1."
        "8311493838142103542752617036118103707188503450539135538038071480595467067235490012901451567915485547679396"
        "737058601282328571489161236550988761960486022562870032145767653310556274688e+181"},
    {0x1.939b15b62b48fp+603, chars_format::scientific, 181,
        "5."
        "2336517217744578289301435473972599375000619053808222966759646632373279789584915010138199152881101065506532"
        "687557038424526575845468735889436101248308704643094047464453357888117669888e+181"},
    {0x1.3323559810654p+604, chars_format::scientific, 180,
        "7."
        "9654625984234070560843023786733559173357314848891567332176073939266324781282852488889033232328603190512864"
        "44191994975384433871139554376806544439859313015268722153010942162317082624e+181"},
    {0x1.333eb164f7174p+605, chars_format::scientific, 181,
        "1."
        "5936468405690222963015531213681703950991673640841216359315071491413902278799067753246551939525046278107613"
        "643503941029543247825376095531505645583899358762232671530237175811966763008e+182"},
    {0x1.d0f59fe9d68e5p+606, chars_format::scientific, 182,
        "4."
        "8233914130112407863285003710689803483456665401306521852174982975280526545361901381877410799671323400152340"
        "9728884313284382907823478860910903091121695170799862320491542129699840851968e+182"},
    {0x1.84e2b5e2c9a1ep+607, chars_format::scientific, 182,
        "8."
        "0684340066596766544572556506252731538802478458154108454504290436861404376208516321210832553563313969262818"
        "9202172627621495205007691501867201659515859130020754039123809607454929453056e+182"},
    {0x1.18d12c4dbc048p+608, chars_format::scientific, 182,
        "1."
        "1652548548873181294322533416118492440051287407763628764843419162381374460114342887075602927194584640147378"
        "9496291184726619357044089201921845860679578715643022102228246746338923905024e+183"},
    {0x1.7af5d345c6d23p+609, chars_format::scientific, 183,
        "3."
        "1450029563312949921705252567556012692518149027203291202593080093166670468850095010731506130052674674120157"
        "74348292634459749772960881227292173172198041386149418679539742007941742460928e+183"},
    {0x1.975ab947edb1dp+610, chars_format::scientific, 182,
        "6."
        "7612935278386641398204727194074041846069648507123655157571111694919617576544597129796919213184659654005698"
        "0488537620239095371500607042229531833011357071487127295321565416010266181632e+183"},
    {0x1.c1d0737b292d5p+611, chars_format::scientific, 184,
        "1."
        "4932090269565783294588036135586081051149351045134466442617688566006012001837540168458670172917118701768786"
        "867474604627194399095522425450416452953980195186577171892642417347609543835648e+184"},
    {0x1.aa02efe9f3794p+612, chars_format::scientific, 184,
        "2."
        "8283859855362886467396009253302481873061245217643500392666314561635040318327151542442172699585268930632622"
        "241589973221227709826283976490647011264056279643437090782685578260187550056448e+184"},
    {0x1.3d7dc9ffbee8cp+613, chars_format::scientific, 184,
        "4."
        "2157931387871262015926870950749405384817650455950174689016344420098137969750444915728016112509860277150060"
        "601492917876180907845520932017756677408045726864238056988978424999333691654144e+184"},
    {0x1.c6879a9f1b649p+614, chars_format::scientific, 185,
        "1."
        "2070899708662365098038931357762390307929244909436176101222504931129437932282921093676660906910327987840252"
        "7125214963888503868333527614117931372209142616050590653014235608250452260421632e+185"},
    {0x1.ab65674d500bdp+615, chars_format::scientific, 185,
        "2."
        "2700631068240273397489316576657874824412711298635064825657580646809427730859321650511948212330668025354305"
        "6092075426388221410551611143867357719504542651007243174106278126401989803769856e+185"},
    {0x1.7c53e1b833ab0p+616, chars_format::scientific, 185,
        "4."
        "0401294303115836967321430079576857543043077310822923673457308264270695997048570907605829914857916971516317"
        "3120245949614126178698831517102780044385664344470114797725850999704214300524544e+185"},
    {0x1.2e77c927411a0p+617, chars_format::scientific, 185,
        "6."
        "4260880103511173776965782050887475772203573881104807170026375206902625094758600314000230697855968658781415"
        "2496590594469715368836313131660803069753435961872139875035538111189185036550144e+185"},
    {0x1.91af529276bf6p+618, chars_format::scientific, 186,
        "1."
        "7068006955155920436381787742211206889900022505144975960971613468630206721351184202513546521873931642016016"
        "70059306842801510185352447629065196450702180793164841642105280807255981179273216e+186"},
    {0x1.e2ffeafa53641p+619, chars_format::scientific, 185,
        "4."
        "1046316824941888643699353613767678576433840888755738142654597510056334162946180327973010169901435079539597"
        "8893668127655560216486714958133476458975838842621122712984278755617826565783552e+186"},
    {0x1.5650db2b156bfp+620, chars_format::scientific, 186,
        "5."
        "8181424134557963372623500529012147039265491223350309547526266523128141272229618057337628218595609572301124"
        "71018315948488391977542573706585784859374641921502790939786006178741349999706112e+186"},
    {0x1.bf7ae95e29007p+621, chars_format::scientific, 187,
        "1."
        "5211116452704720220916932480545333836293750506976740282478412134006158837478732993126688286547314481305113"
        "926160400673257953300679831181284416307088159652747412468645675852976258440757248e+187"},
    {0x1.7f3b57b7768f3p+622, chars_format::scientific, 187,
        "2."
        "6054268526041418370124758261736181886009351044292952840979842879191012038670747908928720486777477687495442"
        "139696169653926332331688473761049756433252163195764050763466390084322743208116224e+187"},
    {0x1.2df5ab759d94ap+623, chars_format::scientific, 187,
        "4."
        "1057853719527927979235446097813905937787889019654170253288837621067841097808464938435949456711502629198845"
        "047066360505800379087691836395031068487812569438457407732512474227630214523912192e+187"},
    {0x1.f86e4bfeb9a95p+624, chars_format::scientific, 188,
        "1."
        "3717626247132139356031030212904093976490026571768063884666249174145828633729237056208500152497070476103697"
        "9181678894768420162515624483582843225609804010781295565639720290288781607684800512e+188"},
    {0x1.f40819bbe6e34p+625, chars_format::scientific, 188,
        "2."
        "7195986230515427628289312046628293937926660068197292410651314639082215733474435689052778088764971396921622"
        "0975232992872917430431261712729880546657888244648604349740292101232975795214876672e+188"},
    {0x1.bb810fa7ba591p+626, chars_format::scientific, 187,
        "4."
        "8243077416927025812147489698712574130435213134316928233651561721184336878749918494519101017806378515809278"
        "608335558400157584055536387755052350186843738994172820141734602267502813567254528e+188"},
    {0x1.b49cba268e605p+627, chars_format::scientific, 188,
        "9."
        "4986787120868551354856124828173860354847443999782529857627384188101971308874000269574276015142574067770537"
        "1858937491969553131423202713212361520698537802948066370938491409647594429525000192e+188"},
    {0x1.6794724f38a2dp+628, chars_format::scientific, 189,
        "1."
        "5645616537346161531395584770690175816359049861537004504171534275505852346677701254291437480648523612687972"
        "06642428914737885631574981113215615320879524124007390426980020724645404028254027776e+189"},
    {0x1.d885c64ec1963p+629, chars_format::scientific, 189,
        "4."
        "1119691994497879656531133766660971874902845844085983857408328096666520143100236614121035494123196391236682"
        "77588476017765557295002078594048079978501293546557091940850855608591393411787915264e+189"},
    {0x1.d4b6a8ce4e210p+630, chars_format::scientific, 188,
        "8."
        "1576445426427843228244475508275094424655570327245201459047094099930186877082150505147571440436295280323845"
        "3225443621893877167039809549667445315862497012784573780315757858692039887497986048e+189"},
    {0x1.0dfc30c10a8f6p+631, chars_format::scientific, 189,
        "9."
        "3978200740875525823346709967358851145517458783872627113059769085886366674405289187962996521127962302157367"
        "62416233629290695818905123073123846308612952343782071766983440677059709153069498368e+189"},
    {0x1.b0ee3365acf4bp+632, chars_format::scientific, 190,
        "3."
        "0139458754847524660871282757055906655014101750771082954413410089116657906300272279625269622507839996028131"
        "322069003748345377672125070777019272622112701902180304760314555069924255238207832064e+190"},
    {0x1.e8516d69c2517p+633, chars_format::scientific, 189,
        "6."
        "7990790502150547755817441151088834982046097343185039910037887278994580105885199523166160292480282346294010"
        "87279124575596835993625675652177630757887466880278880084355993616847248021962883072e+190"},
    {0x1.678bfe66c299ap+634, chars_format::scientific, 191,
        "1."
        "0012275116878428832695316266386275059577472848203452848888799575054312857576278375094172990255241396253407"
        "8869424254770151616712433286627933649089597511713238066169913296314718460937108455424e+191"},
    {0x1.04700a1049e6bp+635, chars_format::scientific, 191,
        "1."
        "4504776964779739227622461272137780904566626980139278483809734254823562877295798245295460035152617301251406"
        "7058098025582676058384729733566966350382985119197142132911172845321643870781582606336e+191"},
    {0x1.42ccf6b7f926ap+636, chars_format::scientific, 191,
        "3."
        "5956024160941395496724152481406517830405700080895194171603810345955158609958585945435113191220307312485239"
        "7179554337917085081215107409583937953090530652396114892869575308843675129211185528832e+191"},
    {0x1.62da3942f3ba2p+637, chars_format::scientific, 191,
        "7."
        "9052400799365436508456422997397376779163961087508758356552926026529470568515992308471246008516852855949960"
        "4255099654858809141476957078618577590864095604243342920714026320377441054472831762432e+191"},
    {0x1.6617ede33b7d7p+638, chars_format::scientific, 192,
        "1."
        "5954884853337538467930960161959379373574226963181525647757921151382491570533826044106708021096634523722806"
        "22563873071483865155214731195109515482575780647056162170021909878210640606642688753664e+192"},
    {0x1.5c71e4b115269p+639, chars_format::scientific, 192,
        "3."
        "1049983313309457947153108285698834046740671768845565652182843514446382696929913134966819032936095111895758"
        "08859645677809012205688992155876799240651615710401257329009039104082564451422481416192e+192"},
    {0x1.f38de0551cfd8p+640, chars_format::scientific, 192,
        "8."
        "9030718451768592943551952273335458583767299556603325749125904384894163964056658026424350130332560793911830"
        "97998040901449719178200967412709547407175233106220746691802662083191769493569324187648e+192"},
    {0x1.7d3104213fa96p+641, chars_format::scientific, 191,
        "1."
        "3587214394332287831636967409123474173198677781114610688477509240066767270036304396583002007338361488342434"
        "7018261468570862106382590370866270622706678119119636711532234507923360885265009737728e+193"},
    {0x1.05c12199a4ce0p+642, chars_format::scientific, 192,
        "1."
        "8659984263282701095961910661127105662619442340071089999966335247066716008995363420012904517869156065414943"
        "28827181417719388414731396372446871312890174002675142689682184688568477822869533884416e+193"},
    {0x1.e7c493c1e5eb2p+643, chars_format::scientific, 193,
        "6."
        "9544124557966781465283601740528161468657156016270358219352828875152455546920314538120334360214601895748468"
        "949215676482982196512810670940274921427074192952089823830554753893672379339452513779712e+193"},
    {0x1.7be4b24c3e84ap+644, chars_format::scientific, 193,
        "1."
        "0832755189816973686838400117394925117567150074253168671073010357437082908429802511685738145825384022747200"
        "287129426299695238571771855677246949457702575625558892201737640633820907147368494792704e+194"},
    {0x1.2de39fee556c2p+645, chars_format::scientific, 193,
        "1."
        "7216892018906268022068471537387743260557559590398031258749108351094204150589638814169822851978176186111763"
        "517875372144231247461814054561524289109891363206828212023676515423816653474344871133184e+194"},
    {0x1.064ef464f3256p+646, chars_format::scientific, 193,
        "2."
        "9919164363027123692749619660627210889271275295150022237744720119394566288350377104728121689125089876410120"
        "207077019582026591233089745125850338025814467578902594716196084232119044216662467280896e+194"},
    {0x1.53c83ee0f3068p+647, chars_format::scientific, 194,
        "7."
        "7511807677676666668993801298197495853096204934459746619627314359135066593918034347577125781457452161330722"
        "2499090718182469027512595486412104282224089391808118934952932553489010283810329970343936e+194"},
    {0x1.3d245fcdf38e0p+648, chars_format::scientific, 195,
        "1."
        "4469419386503595028127075501484846217979200970571120241086108986167836029091721153208882052204284176158696"
        "92393014844961294938705227221973480785926757243856237171772712052212742533379530998939648e+195"},
    {0x1.e08347f6d354fp+649, chars_format::scientific, 195,
        "4."
        "3846223856409726487843137745345240016233497677184702838745534071583111769816970967562226232827874998014451"
        "84284881420975108036710110563126305622808224088979432579122289231488107948520961449394176e+195"},
    {0x1.26dd41c959944p+650, chars_format::scientific, 195,
        "5."
        "3812031636068901652580768033108735321385002279585405149633570661783421571708940731919720466896227207390799"
        "61349180699018841380453909336296408176168776915809695465869463868037226981151032054120448e+195"},
    {0x1.32a46cf0469cdp+651, chars_format::scientific, 196,
        "1."
        "1192297812198031453672538904878583920546310057787196919680564602804006021635275052904716578393230705549792"
        "391736916811871536801023058717321491817885637178624494387092346840642879252645460150583296e+196"},
    {0x1.f735cacad6b34p+652, chars_format::scientific, 196,
        "3."
        "6733861060912076889136215696794553894081750048069183817920228793292867367172061721225671283257865149059762"
        "373032895575586250199621890834068293240362884267618309008853943697973367517798399718981632e+196"},
    {0x1.6f9e96b3a07d3p+653, chars_format::scientific, 196,
        "5."
        "3671746541827261011203354087624108922878597080912646222922380862668287491802597137523711347734694456137577"
        "512510066286097290894101024991650054347426329814100070532676175900514872055547324115451904e+196"},
    {0x1.9a7be8fdf7d97p+654, chars_format::scientific, 197,
        "1."
        "1985977495349634490908878417576139133664292427414882677483198175172572179357980016926770715944365796704257"
        "4692923571443314746208884004956936450441535729663397603260741070812981369093068197195677696e+197"},
    {0x1.da6e03fe5ee66p+655, chars_format::scientific, 197,
        "2."
        "7706336697369672079558112275729991989663502537476696645641921462599178276995772930464951641470258493038336"
        "9099948172126078628543391675565516869571467232515617030599512982766562717569725701405278208e+197"},
    {0x1.46bfd17446d76p+656, chars_format::scientific, 197,
        "3."
        "8163820324215302078655052581105169362206077889882490668181955965331335612783576990462419110014762802040842"
        "8932624183905960507058168406385765800174407011359638209862028651785169944480326048859291648e+197"},
    {0x1.4da5bdbbe28e6p+657, chars_format::scientific, 197,
        "7."
        "7939024383475144406401810111134781235714299871416468725265537823786477278170640693706900927390244735770402"
        "3377635205357481997520059613138340462342666890730126616251260546972142434062110654323490816e+197"},
    {0x1.794508278de11p+658, chars_format::scientific, 197,
        "1."
        "7625808904819878814252834571355017129723543975578058942872687731253785660005190276333451440607991123766321"
        "9689293395397374284887817353554283069192904339275976476169251134939185478796513753207668736e+198"},
    {0x1.eb532e6f9d7d9p+659, chars_format::scientific, 198,
        "4."
        "5908803682224108657912189982052113878795247700619664483730988082961059233697555687474423301586558704416284"
        "05972833885899442431367846953537758531668062429844500799658848386004026176785845424421339136e+198"},
    {0x1.de74ebce4a37fp+660, chars_format::scientific, 198,
        "8."
        "9412828663695769157133701994384037245199508662333984038697424700510180989698512292550728723512369532416908"
        "59581044027690123952861405038640439793801150984027335811429652593548499275325847981191593984e+198"},
    {0x1.f37efe81f6078p+661, chars_format::scientific, 199,
        "1."
        "8668922163822093102670212590302724412138160772937315443551988535235327269727004283188067685097993915779967"
        "857553550469160341100795009241978760744022819053953305820738316178892052108850291867761246208e+199"},
    {0x1.b9ac64ed3cc40p+662, chars_format::scientific, 199,
        "3."
        "3015541406240127652827901285317994654252259108292724627854632423431112225291832993714601701837092532228984"
        "666842289569788469418213910100041040541661269705317791388661975141778219886098547588248633344e+199"},
    {0x1.be00282b03f5ep+663, chars_format::scientific, 199,
        "6."
        "6678007786700799562127526307310207752308193470392815502671838863546949841784370697415483868452623924662465"
        "852932499279515268041523524885590999171088727718673563969761030301929187013508451729059872768e+199"},
    {0x1.1f0bfd13ebd68p+664, chars_format::scientific, 199,
        "8."
        "5828181572124633107524119616284657291987779794200781158316572344105215247476409691264332650248636862250587"
        "399330494835558065432909058158755560573757532140879843155127845886935663226690006104546476032e+199"},
    {0x1.214942705de21p+665, chars_format::scientific, 199,
        "1."
        "7299550663482325854298152774838811504666813994210021794440510040084666159982357767709979637162725720121837"
        "143146658029599367447831227389091111211511620184940759881374673800216802576052457772066799616e+200"},
    {0x1.09671a2b2cb1dp+666, chars_format::scientific, 200,
        "3."
        "1742604212395941520160807475694587693442023879310826245397503160636389502214271931668375341320279482228936"
        "5003537922894512928901216347580242808688118038808320342245310580635968754349465019243816812544e+200"},
    {0x1.ba3141cf23cb4p+667, chars_format::scientific, 200,
        "1."
        "0577387790503057845523967882965492655922506699517901184690541395251648923255536765968073123452432831189428"
        "3139610900523923729546826141802983594855809190686087313938155503860877149671068608237095878656e+201"},
    {0x1.86d43f758f915p+668, chars_format::scientific, 200,
        "1."
        "8697520727929860202205333481871092634806068636093040001347476582997186350991014749554566585582449517827852"
        "1742514396415318804969082463925672708648283454644927469172901217309139068598188157479893860352e+201"},
    {0x1.34d8186824c10p+669, chars_format::scientific, 201,
        "2."
        "9550611658398537729812084104233279581886197422995997439739248023584633751063077706969826068002328821902558"
        "35984668412855709756751449286828670454146045729913364117793350552523245031469165393183309299712e+201"},
    {0x1.e78ec2e502b07p+670, chars_format::scientific, 201,
        "9."
        "3300316023279546564429734710131486172165480903897679792851861579776405133194991445173294823171591618519733"
        "82886503720740495065769351149280072967849485120060333190450091919271255293415847165484888752128e+201"},
    {0x1.f9eb8df3b3791p+671, chars_format::scientific, 200,
        "1."
        "9362841443169071617725977338146969813068537694630772833789523535940605386959607587391035584155361991571477"
        "2188643495718476877510953230360136475999837927583418408929771467314748864760171734164102447104e+202"},
    {0x1.f3bf2b7fd9993p+672, chars_format::scientific, 202,
        "3."
        "8253141404124239087553445135078230149218171629835915005900468691055157253177028433475181721888031353474143"
        "805960645601659788841709440240831940652256561820866616777441445506068582195950276620332646268928e+202"},
    {0x1.7028723b0868bp+673, chars_format::scientific, 202,
        "5."
        "6361345240426447996243602793477311715051878330229375094900655201745476339178578234692042783203586674400814"
        "536523693629016758628762237700239395376218700185658748567853569033785027091761965807224097865728e+202"},
    {0x1.557c7c726b2c5p+674, chars_format::scientific, 203,
        "1."
        "0455633800468254373659208108812590394043317042707529535320591653457158166384116723919640391533814902130197"
        "3914820975343519675720107557611312716650944578510886085691231275003492219818521525260187846311936e+203"},
    {0x1.871a220cf573fp+675, chars_format::scientific, 203,
        "2."
        "3949543282776258275094826997800475448163929702581969665721781303410329417447832451577436710001122472324600"
        "4426134549707543279835675223903160643688382643597490008860447048746541065340198566551705264062464e+203"},
    {0x1.7ab1f57987853p+676, chars_format::scientific, 203,
        "4."
        "6379583986380873399377611822272310491249212463996866783107484973790663759579721670387297986704230593188127"
        "7246512300341294333647657347794641948475142092198438521343984711625050786905805143040315550072832e+203"},
    {0x1.5d3ddba3b5f62p+677, chars_format::scientific, 203,
        "8."
        "5544700286806899054573744398898783238737967644664671325775421780413312594622618697018203609322621774586335"
        "7936953692366755947421731246318689169626782187431645178224405902434053217838696105015610359939072e+203"},
    {0x1.ca1c22f39b22bp+678, chars_format::scientific, 204,
        "2."
        "2442269843101122827421442194256344003422365531162259447063619663210238536932202342459756070387395904494366"
        "08778953178834695527378455121099232622455529116651588866259062455701860787333589107721957541937152e+204"},
    {0x1.5571570a3d877p+679, chars_format::scientific, 204,
        "3."
        "3453762259499943095906115508134893420044494808114889576882963983309648533878483611515604738427366970549017"
        "54178011537224573858899467011609733043254823463231975478542474685169259633176067748962831236595712e+204"},
    {0x1.4094b51955758p+680, chars_format::scientific, 204,
        "6."
        "2819534546304202022756189930697394173859142240118070438830404805760551238633453033097751606807688513643796"
        "33566498059922977393145681190563895952411661162198926892429054001662376306285334661068344151506944e+204"},
    {0x1.9048c53155909p+681, chars_format::scientific, 205,
        "1."
        "5687567004414429430445580613907672440297999372236541850109777310656966630289380682512901660984243147818164"
        "720305606372514460855651668937589154968441803492390245562381549787491329484096179468977774843133952e+205"},
    {0x1.648fda1b8573dp+682, chars_format::scientific, 203,
        "2."
        "7948083967253507158270892062204304924669010291504288163313261458526456348819707571820654705254002837820095"
        "4036929834214012069157615233165507943405007539518079954737799050720625737596053702318674937905152e+205"},
    {0x1.43618fcb01bb4p+683, chars_format::scientific, 205,
        "5."
        "0694600816666434831915046957006568969768474107310483569746183545377953584217498572022390666824444206906802"
        "716110058524003006214659535848234793606862153660055012848214798236108687160590757085244967798964224e+205"},
    {0x1.e3c671ad8c424p+684, chars_format::scientific, 206,
        "1."
        "5167731946556582358338545363873641520855604073445893638689603884306082276318367477947295080031043819110440"
        "8642304100789891065969740635351032828526812314484068150876373570965277810326480540295924136407990272e+"
        "206"},
    {0x1.0083712d8f528p+685, chars_format::scientific, 206,
        "1."
        "6084856808214641304016171526904209487654525042104056698492786865015541204817201677687479571049677306897371"
        "9496544120901191625200109058676087802871541264829133196190867040924564024017823724146856414240833536e+"
        "206"},
    {0x1.1b815b8ce81ebp+686, chars_format::scientific, 206,
        "3."
        "5554800597042668911521270198442508184743882300104078763439099936805058397629458498314099957433687022418916"
        "3184788239468910565398744819870703830959835692636607007655630104135189425612387037272246775462232064e+"
        "206"},
    {0x1.3cb5cc09f23b0p+687, chars_format::scientific, 206,
        "7."
        "9438133343858630565423242979694274909564237766705840868790151212521658489271471983804739253095661366761029"
        "4102333273655557547426416548788317016668008395432111323108190919984834221381915705192746329317572608e+"
        "206"},
    {0x1.0eb891e353010p+688, chars_format::scientific, 205,
        "1."
        "3580600028505664375690662207424245293630538367773374329113241542710551072241261271590612227940725191575525"
        "142268316641921315280475966244961988464253867196651973305962369993832829015492388706895940085088256e+207"},
    {0x1.fe4392ee89698p+689, chars_format::scientific, 207,
        "5."
        "1194339355719443065155494183071752754181073170581919459310323849856827865354540376178837362522389907879317"
        "21861923842646425087948083052097162063136700891783482967154133027296156365640453753060081736636956672e+"
        "207"},
    {0x1.2dcb28f24e477p+690, chars_format::scientific, 207,
        "6."
        "0557377481791783775123253767073183006050784328448801194330172256192676385019587449505858703818171834796158"
        "88079777486184355096973374331860638106502031077122796354840154902424520732833513406609567524824547328e+"
        "207"},
    {0x1.7ef16a0343a29p+691, chars_format::scientific, 207,
        "1."
        "5368136201009418151075746612212978086078021684377175933956334114584860950199106026892088552308405826859681"
        "19867342497053313630101310880690361388894132852824665771671576281871878218340553013779839607256383488e+"
        "208"},
    {0x1.2a242729206abp+692, chars_format::scientific, 208,
        "2."
        "3929799628231874533559162595675700688225267190446002583051852996326657712936124491324505265077653846814113"
        "912468376263785578115495854111182179778355706863388202457043252998698055736229924100641739854177107968e+"
        "208"},
    {0x1.6fdb131897c76p+693, chars_format::scientific, 207,
        "5."
        "9050637526432229460046672429152018512276157466161011681361188012855653217247623948526824848762046607051117"
        "42291766960934780667277783068480199263888364083681949480234545468896885660308486627900438301487661056e+"
        "208"},
    {0x1.828b9edabf8bcp+694, chars_format::scientific, 209,
        "1."
        "2410164169914756986987721184858525130751854228863394397493695090758186348224795318834728620444604824617592"
        "6376358164303658206374976185443979610307101254760486194833808768397406617592883545020705987606790275072e+"
        "209"},
    {0x1.561155e6ffb7ap+695, chars_format::scientific, 209,
        "2."
        "1964388171812186376913149993916068915104358033266046539265645670705967141474979810589471961997724112800703"
        "8529115316543316991123904985184012949857407673490871091790599594254663632479001321411805904083076775936e+"
        "209"},
    {0x1.b770da1a7923bp+696, chars_format::scientific, 209,
        "5."
        "6433556541432481398269867824506950137257397824592518950158176095072875138674793491115526889401777780967879"
        "6605880934558431966021135949322020945206483833796818557605415476191440013445527768217391316223846776832e+"
        "209"},
    {0x1.f39e870744604p+697, chars_format::scientific, 210,
        "1."
        "2832349330194718344755964910746649476665600600204568207096392756190966107514967070128127995587125525057357"
        "87164435029468024484426208026189599769787674284875448040738059630647364948722154118121000407966494490624e+"
        "210"},
    {0x1.e0e0a24f508c7p+698, chars_format::scientific, 210,
        "2."
        "4701961710739764361583234915146397646495281382968205066282530980797542323891939027864029319111708327424737"
        "68191802838701448254783534537720497984389637555995723528330666991979915889480651222080857795966332305408e+"
        "210"},
    {0x1.8ac9f3659f1e2p+699, chars_format::scientific, 209,
        "4."
        "0559435735022988739506375950055455133208181539729336854703561923650777379009124468556720173111749862578532"
        "2257531748255933833911596322305908820799861570096445826119055025147325835330550150749374733298534711296e+"
        "210"},
    {0x1.c6c3610ba0783p+700, chars_format::scientific, 209,
        "9."
        "3442040337209647890991669685854348061912336916202770110402696196597648891199334466408278208881547182645564"
        "8106587676761185019235392954314227170622662103422697806457896662312360195041629483904435021403511586816e+"
        "210"},
    {0x1.7ab499967a977p+701, chars_format::scientific, 211,
        "1."
        "5562829932078268382920536644832525295632207422782065245582452948588014426345451647662593332343942693359043"
        "673038241481043843956079532596179836219776720544331309338107673956968832112826761500035796845304502812672e"
        "+211"},
    {0x1.f024a7d24b0d3p+702, chars_format::scientific, 210,
        "4."
        "0777821620060193266334318275592853491355664469989449372681167607339409531079735731049874447275001327926030"
        "16716647774810946339317774614675085229067529724067990247981819516824938089923609051324757764430419197952e+"
        "211"},
    {0x1.d17a4e72d8ab9p+703, chars_format::scientific, 210,
        "7."
        "6514883571278532762421327618640364228144540224715301472189205747128557339867683312189234312699991722304801"
        "87508384059736711183902958629060763487777480969265193074898840268978802200642734863912959964269495975936e+"
        "211"},
    {0x1.bdb5292735f65p+704, chars_format::scientific, 210,
        "1."
        "4653017873373998692763635837240196213052567229127080389032808605177662267440004448203826088699878670265716"
        "11989504059022347366241536256218557754548387791868248488507236771978085661342065341924858769713800413184e+"
        "212"},
    {0x1.d857daf79aa6dp+705, chars_format::scientific, 212,
        "3."
        "1057366810904797804142405560221570986848449184775478721300104610661909324364621635260801637633691297730614"
        "2606261334956001762657343815208008386132632164433439367427753003032269836143809760867436748508642739748864"
        "e+212"},
    {0x1.09c435c527cc1p+706, chars_format::scientific, 211,
        "3."
        "4949190530723091756757484452691047713061764919333405631459771571062584286466108807102940821362269244897933"
        "428086956552905322744082047362472421201551180358972335992195302859220811917676779815344923699394346221568e"
        "+212"},
    {0x1.9eeba5c11bf2dp+707, chars_format::scientific, 213,
        "1."
        "0912691038049117803356178427580267592987920737973863462643914057428289444459726293430782464645172800567106"
        "4614068269963034242382343536692249482905554535118294035276777785242668121575530849252887857652227101635379"
        "2e+213"},
    {0x1.711ce33669c35p+708, chars_format::scientific, 213,
        "1."
        "9415837118656972047462560151565189440197415599082992072290088348446257818753305865264569453441155760209275"
        "6420682215115366352429937129978148876672274612581009221511800214540957300015697763603036114999165026356428"
        "8e+213"},
    {0x1.e1545d8e4756cp+709, chars_format::scientific, 213,
        "5."
        "0637177196663439781619561019870795438871709899611245250407090659243999851279716213705961203818418561930515"
        "7538837474992269641194547319074000476778106214165601301321107197389998286966901034850873709850498110901452"
        "8e+213"},
    {0x1.87047e172162ep+710, chars_format::scientific, 213,
        "8."
        "2272217902289806712574994697052872917307680452424732799593585823465113857834013351649821539394746533212326"
        "2635474976739710004492416534995515409682723302715699955709445835135054280029223866567934693473678102469017"
        "6e+213"},
    {0x1.23af3f8b0f756p+711, chars_format::scientific, 214,
        "1."
        "2274403548516689934568399779688998694687353455201679256515032382815821350964662324319252582154195626101911"
        "1914744444851247443732162368380389190137963362909858689711281895410242314171242275664220904763668035618734"
        "08e+214"},
    {0x1.15ac6c4e78557p+712, chars_format::scientific, 214,
        "2."
        "3369607865235239602595370981188181022701331236283783740952780871356122483291807368512694950185999530278521"
        "8100126394977849717535313389040668586244128270959371681379343662763181550943073897157616708891762610006917"
        "12e+214"},
    {0x1.0c56bc2aeaa8dp+713, chars_format::scientific, 214,
        "4."
        "5167955247237233591793390194916065252734234001920207621805423206174532999832050143387049477371885758341774"
        "0490893500888204453060916632880059929997600758692057070711667533170230016542638615516838907173350677550202"
        "88e+214"},
    {0x1.1d43438f94121p+714, chars_format::scientific, 214,
        "9."
        "6033333170660723713494533665995506845145565126757011999790859821923401078678587263615504964380651064813268"
        "8455104405640138686956488690833735843738678692699173055317848403275010733688269013616014923336044532790722"
        "56e+214"},
    {0x1.22061a1f36b39p+715, chars_format::scientific, 213,
        "1."
        "9527229344211296204832748491391970313659298630157789538676930343069033760208197589599879702873928992499523"
        "6608990695697929287475783764523709178533697748688667795727026551385542208539829149904757164785331242375577"
        "6e+215"},
    {0x1.b4c6aa9857545p+716, chars_format::scientific, 215,
        "5."
        "8816034098212943144905329698612653757733245362298585094671457030843981001076903239943736481752491562668854"
        "3227615161426933453966662664614700683592817343221033633872435463082384646592207974116998811001000733528031"
        "232e+215"},
    {0x1.fc44623e54a39p+717, chars_format::scientific, 216,
        "1."
        "3688597232290091037311686146350196929925090931949605314752704983267092895217454050659460182543204061174764"
        "9483581360902654275978940750604387256349655240483869060528558314415186446869377979192991730046835020867724"
        "9024e+216"},
    {0x1.aa3773f76d3c6p+718, chars_format::scientific, 216,
        "2."
        "2957642846592151435765755376177922244530341123122404553904849253141951496886105258870876064851615036434469"
        "4876401229921882367852535894131740355268022752724962483511347088356991204389511796637049601111311107797234"
        "4832e+216"},
    {0x1.678f5a3aaf4abp+719, chars_format::scientific, 215,
        "3."
        "8734526664526530409778005021032912808303761236039323145190007542532559613671226628041536207090554119549294"
        "8061656426937652467936129275838297803985174029589992670722287010428685443582031439938587866795108684422709"
        "248e+216"},
    {0x1.75d7f7f1fed35p+720, chars_format::scientific, 216,
        "8."
        "0546540930957455718578031318299747350402171557957209729965273827492992431872786346244627211565631606648257"
        "0059867837651906784602547892574447433749380278807687112313000367428241145025552940533962926786779921134492"
        "0576e+216"},
    {0x1.ecd6547f3a750p+721, chars_format::scientific, 217,
        "2."
        "1236865355155595622735285863955058003135144833957450752980851351717987352331092233045600746747001260561937"
        "2911589467181738965692960395316048567332841520376860127492605292078243192501350963954953525169159449927630"
        "19264e+217"},
    {0x1.0a596dfac622cp+722, chars_format::scientific, 217,
        "2."
        "2954536079504795363105284856238370047575863823791914884578812032736986505844047299679977544958888864887442"
        "9510566699520717810527904738260292999530216887681158564123053793542338149495936402987037020460274422393832"
        "73472e+217"},
    {0x1.2787de7be85a1p+723, chars_format::scientific, 217,
        "5."
        "0938899596925395761826195681293982864054105837836524441779452341587353365337241463927684760423605672503136"
        "4648194990232587849895833426496657214318262747057343259849722485166677259967720461632129749176545382576989"
        "14304e+217"},
    {0x1.017035217c70ap+724, chars_format::scientific, 217,
        "8."
        "8746262567900002440763362220696400774677132584164637737173476368159373848157173276824865316031383654057511"
        "6917032676271566593822293172772155148908084084969174804166746324003981364028953399391198999657379974601464"
        "87296e+217"},
    {0x1.520d5af29b2e0p+725, chars_format::scientific, 218,
        "2."
        "3307227637493685583257214726151633279014217575879330885292007999084782247996596715050756662255030139058859"
        "6805856504093577362456677740310187436887298551656600563966070226993167637974428618236660886457382117786735"
        "607808e+218"},
    {0x1.07577e25bec05p+726, chars_format::scientific, 216,
        "3."
        "6312540549690454783945385341080739270186260535143481461780731546205459439009501621586362243663050889964457"
        "8717521317394394155770001048893530262964476221970496769199098222896949679062427442307345916471566141482441"
        "1136e+218"},
    {0x1.8e96d600a22cfp+727, chars_format::scientific, 219,
        "1."
        "0992397195630485393048029745193332487200099886126458682210102475632557765838176879102348740864174816753457"
        "4339747390248704045938396673455756529493017948310435328593259601916775929373246975163112018310484034276469"
        "1390464e+219"},
    {0x1.d58382d6bdbc0p+728, chars_format::scientific, 219,
        "2."
        "5896743857569934926023999906114602656980022031372964101642331196453139149010796064718269338584040985180989"
        "5930383540586547536756864433922834466516142024080331685331856698277183140964794565531695307462460862905731"
        "0949376e+219"},
    {0x1.dadcdbd4e3d3dp+729, chars_format::scientific, 219,
        "5."
        "2383553757590476797184448014939985757228795670010900864934417139896450486005364935750934931766668175207059"
        "8627645866228627698205946727047137855285251500317423726214002802575650572352763973306837696764851555496791"
        "0612992e+219"},
    {0x1.9368fd03b4a42p+730, chars_format::scientific, 219,
        "8."
        "9002795600414906199791927232216323476110578835375549513066389953710242169294374458723035137744671493186722"
        "2344623964801905532168998413337259450227971247100831382850577108376403193310208004637163414879706007669134"
        "9569536e+219"},
    {0x1.f845eb76e5443p+731, chars_format::scientific, 220,
        "2."
        "2251161587610877663633489139428920395198020363761713051397678295470620772059695788415149018775345563562555"
        "7627774951186652618328217813712607566387789838837146661464469054252780012796887062198095184322259987517487"
        "84652288e+220"},
    {0x1.2f3e996a88e6fp+732, chars_format::scientific, 219,
        "2."
        "6761461913428335040343012953219131824126168324500202272744678701909318477813814911852898730651873743175101"
        "4250819778000778777707356970388797186374553268449512982574137361618840218361257083422429020750694479963974"
        "5855488e+220"},
    {0x1.4a45683f62e2cp+733, chars_format::scientific, 220,
        "5."
        "8293141157683540715974834887298766485149159985000963569603230281649379368678672979104626030220017706653109"
        "7808656147432158208325750276074188178479042973760179434028275087758081085312960935039135142298997141271698"
        "72461824e+220"},
    {0x1.271f30e62182bp+734, chars_format::scientific, 221,
        "1."
        "0417852442068363814820825698485384800961524522909120908757655752739304052271730075835437967141175704897236"
        "2556410412871574621805445900358411362726064828184470316985190862842986536825941080903916401459795872989632"
        "111050752e+221"},
    {0x1.320dd43436bdcp+735, chars_format::scientific, 221,
        "2."
        "1607520560286884617436832975764987909020968782350630804332132448446669047539163848254962584133413017581187"
        "8995110154484414359156320577338034565894700334587682265129267139733146651731675519638135463201585312678518"
        "261284864e+221"},
    {0x1.d4492eadb2bbdp+736, chars_format::scientific, 221,
        "6."
        "6122291466551174411687116860944445324369100982280262642756357833303477524497604895010840854773188953050254"
        "9525240799150634144193389565746980986114542904894941248987392023302371786537801869556014854016254502551654"
        "684950528e+221"},
    {0x1.7244f0d2e016fp+737, chars_format::scientific, 222,
        "1."
        "0456456707732716372836616903450010002831154494297396647575080631941006542008515084980501674726954118373840"
        "9735521916163104123960166329964470337072588711874356885215999169285494689746624286548178297048743319157036"
        "0707842048e+222"},
    {0x1.79783032b55c8p+738, chars_format::scientific, 222,
        "2."
        "1319581917624134663539889420808770033902782634131428805803621274487985682111331673510171714173211779661091"
        "1039629829277554336401367654542736793095757758840646818278190119418471508961695567736328280225796749325291"
        "4289311744e+222"},
    {0x1.0b80e405b47b0p+739, chars_format::scientific, 222,
        "3."
        "0217342386813301969860860986751309707281313502487263088112402249089284054700529175250024750860114807369896"
        "6248431572910876790362634732708648184340418996248893299378516377325328005094981174420298805174626877720830"
        "1410582528e+222"},
    {0x1.8c7da56899335p+740, chars_format::scientific, 222,
        "8."
        "9575645467295136187005193467472727461077360558615067094573133419410373043926814649879385622594635237376400"
        "9489966183043631980224259182358063657298096645467156548473441179528400778016541967929795075170853359231309"
        "1309174784e+222"},
    {0x1.642033bd8f523p+741, chars_format::scientific, 223,
        "1."
        "6091267209523207841500022910819655037186962930388881490129343819406509425737191896112868244974277012096011"
        "1038467987996264830181742307740591777712020726286133123519809683141290064198294007482197011860262930053752"
        "28012920832e+223"},
    {0x1.9bc991377fc41p+742, chars_format::scientific, 223,
        "3."
        "7212585176976675247766032687923578065346254909866031007251748946253430087753480170571456754955495909624074"
        "9651478094351885683772686198754775408289071997059939634841840773532728510497337830251876570543429013738299"
        "94915037184e+223"},
    {0x1.84a5ddbd8f438p+743, chars_format::scientific, 223,
        "7."
        "0243016720094258380256629121268145953304708681155416711569265396443279458019573583115401564863133375895579"
        "6859096569951771745018753431225852318075313303115723130792925295433351462461646612188904437861868080430293"
        "85978052608e+223"},
    {0x1.812a1f8314ee5p+744, chars_format::scientific, 224,
        "1."
        "3922688598771825923497467733635356583331381499542930429409135947927645522102501156000547692907375069729725"
        "3424086286852391418475312237447199829780274705926539967622748047191727176699933588455209360496819723139752"
        "620522995712e+224"},
    {0x1.7c836a459d446p+745, chars_format::scientific, 224,
        "2."
        "7509119604975913078844457489452846297586538028776489989683293722626191306788427967352108424504310704212292"
        "1510358887509501308820023222099507333400854507964230709783428734264017318871243935903761542528456933532980"
        "757779185664e+224"},
    {0x1.c6fd7c21c37e9p+746, chars_format::scientific, 224,
        "6."
        "5786808641025772557077870195899834765281585648313448823239221916239976768108478547517814419358983494868812"
        "1961792138548213478053349624498031839007814676289536377130610928273664129421374065334016220842662500981104"
        "964844650496e+224"},
    {0x1.1910872193e4ap+747, chars_format::scientific, 223,
        "8."
        "1277977211993122424091609085648747668771481082427919683807484929612071497922264732986002271464649933855497"
        "5692723623437402191674871832522296720935189472508557921192974362413118660403885429515640962582691368617721"
        "56520890368e+224"},
    {0x1.e7a0dc9273731p+748, chars_format::scientific, 225,
        "2."
        "8202379495294703177628908917234915516770485003946069942560364371093102020788444507236665052677625643822941"
        "6169845844057611904319010796043241408830954687945583175717139104067419835881477508963222172390156601957893"
        "5599446360064e+225"},
    {0x1.2e360651c6029p+749, chars_format::scientific, 225,
        "3."
        "4957237382552114527444821786045279558301101694570507155653230518370750977939158690454197498146827073453937"
        "9357041460767046371899223744833323015008806175316949664357009319736636567971463779695812041226637688151746"
        "1737018753024e+225"},
    {0x1.228638d331517p+750, chars_format::scientific, 225,
        "6."
        "7210829125928928841973058964356798018780827825223815966852813461948177069149360555141393983156164735751723"
        "5823818387673642184234289003869236885546152556635441516644651051801943950188162055930855976973404579926200"
        "1243453652992e+225"},
    {0x1.daad7920d9184p+751, chars_format::scientific, 225,
        "2."
        "1962690587113569953311452822660049421250275405789941183600119604625335444037052147400073579549578682185130"
        "5152933370080751805332495292333508751983579807351914859852157598709561299138622150754860897482836680616912"
        "0536099028992e+226"},
    {0x1.fc367b64a56a0p+752, chars_format::scientific, 226,
        "4."
        "7028636831137251940639609734997478916542490894502589016068679868179283595091571311071666311276887443785237"
        "1869111339313056178387759693383276951003950803279301146070858225448179998833261120984944413090840062524150"
        "55825045815296e+226"},
    {0x1.f6e5591a0bc39p+753, chars_format::scientific, 226,
        "9."
        "3073245175425146975822441451765732106763977056834211888571665521455385715741928365989145250785190410896620"
        "8744529206415406616189034448656245464907780501706412364806538156020642668889309046124343486486605786818551"
        "08771838164992e+226"},
    {0x1.0816210e741d9p+754, chars_format::scientific, 226,
        "9."
        "7751374002327882454619792493289953471219690074481970634484616771549473550854791181283295264817782922352706"
        "0613265512877596875929151767224750454913626387325900591615071953953614788294221399314042063755887285735218"
        "07551598952448e+226"},
    {0x1.bf4ddbb28ff78p+755, chars_format::scientific, 227,
        "3."
        "3113849645859590322659629554085610294468426876665362529283613898266559089354337883713337939831576365351236"
        "0939528196193498528380921939458491007462238558163393032268756159540201736116486880617747362901481164602465"
        "147231123013632e+227"},
    {0x1.22340a9f27993p+756, chars_format::scientific, 227,
        "4."
        "2967400896826536936196852047787877842228795494777580547365027410425875181924576423119919483371532282787556"
        "2232455935151361784331881438598361263038663101257927399418034873919694038118043368561692189760672875642217"
        "165115690582016e+227"},
    {0x1.c854c0ff61dd4p+757, chars_format::scientific, 228,
        "1."
        "3512844888942568633431706707369991062805896299407273613528709190217372828138600035487313614110546506130175"
        "9796936623799549072454757775050349217072188653452631708762957644242007121213071284462310050544450739174836"
        "8719761509449728e+228"},
    {0x1.a7ae27d0d4485p+758, chars_format::scientific, 228,
        "2."
        "5091984687837548077310743346070326057115446256710579709952705124606433752646975200990447388088323383562163"
        "1791334030723843800987709897669729364377875079217964383322434056974132347179670171459221776205857678918119"
        "2769609255616512e+228"},
    {0x1.63661358f7264p+759, chars_format::scientific, 228,
        "4."
        "2096173288585500632051722258218722470145623127596758211743914667597744472316325964343315995556084458514941"
        "1748410894323120068197403508126028905912753730931116082740279064580499643254386503570744343955198820880052"
        "0321808449142784e+228"},
    {0x1.0300bf26fd68ep+760, chars_format::scientific, 228,
        "6."
        "1356615328552858693888999090215849979187700860450814688847091714791407873355306852037699120732258617281579"
        "9763661313927450726589049261192700026203286795204601573021551354084951812528474694748915250828796925349007"
        "9718987125489664e+228"},
    {0x1.838123317bff2p+761, chars_format::scientific, 228,
        "1."
        "8359608734240248755170094893268138007948817195962710840103000502154170370457597688022569251293279952823745"
        "1289290613961419291935917276298318231224132928876145371187143351232976843971969552091754284038251401659784"
        "6683942400294912e+229"},
    {0x1.e3927b4212b34p+762, chars_format::scientific, 229,
        "4."
        "5822423033700377725172658938850396114672469752451147750170962585518435834434687897863209300864827416894321"
        "6215347383783451339038810851986217331962212638964904591583480945245942892560066540573272482646939275681829"
        "07234209828438016e+229"},
    {0x1.08cedaf963229p+763, chars_format::scientific, 229,
        "5."
        "0185456014215323482120364143447038175745222379826156921731023733604628540256614889772841814066930008300327"
        "3602910676234466758021841379319937225524242500601759755633396331540614052726360755893861226672066982543099"
        "97744334718369792e+229"},
    {0x1.91fca0dbce025p+764, chars_format::scientific, 229,
        "1."
        "5236616837822261183594983552804621208103872014884446947072618527095687605227859507741200359812256479924153"
        "2689156481633910812569880086596174896168270019967462909809080424290632874693002515466863422011218075068746"
        "26551770689568768e+230"},
    {0x1.5297454425c1bp+765, chars_format::scientific, 230,
        "2."
        "5667407186328552576827203298721081448834674879829348839914553768737074771050151832434114399565319657282046"
        "5081841530375765042480824934041898171446714864392159245126640241641295485518295845301454553991993419235944"
        "180577661756637184e+230"},
    {0x1.b0f443954c717p+766, chars_format::scientific, 230,
        "6."
        "5641519599209613942307145023783310917380706370901865075235561351321476204433688375582146368946539399641323"
        "7573577183096836484536070806868174940599051696594494416938549052440323251272405635299695291423546052625569"
        "523937164155420672e+230"},
    {0x1.393f28adab23bp+767, chars_format::scientific, 230,
        "9."
        "4984607723057801580828156622001837886199969801689635785008855370806264451372807995278722828203588180680316"
        "2319437032081291932870713261870296357782603566084402478282838349746893860544685330407950273115161626125911"
        "382367174150586368e+230"},
    {0x1.6ccee9de5f09bp+768, chars_format::scientific, 230,
        "2."
        "2123883505536182924204250993128741492319926155984738095126263216900091278131730034956679001909437190714141"
        "7470461265484571124755535821405407453375268326715135026269092158112467360893312363210642700024821136157707"
        "781468541960585216e+231"},
    {0x1.aa7e5f5e5358cp+769, chars_format::scientific, 231,
        "5."
        "1729616918294319332482875790573450340137448584291350718627223414058673740038801795890236140282159619607098"
        "5515906823203449053186707426569450398359311206667015703761833975688951025632779587529078016359349709485099"
        "7541669026700197888e+231"},
    {0x1.cfc195e85b968p+770, chars_format::scientific, 232,
        "1."
        "1249841891755881470307288574633491096320821816061087251084879090444810632807379547386169351345276341424639"
        "9499235117872522039812782433931100318509086417351386739093630575176672353913163070368040519097536895401722"
        "98591886940406022144e+232"},
    {0x1.09d290fc51ebap+771, chars_format::scientific, 232,
        "1."
        "2896696221903865795055215082983141009246370690618565325493632504690915915499930832192286164683816102053362"
        "7949425734201881702075904632943241830210311449479218601195277680189168934407630942804219498765833001560982"
        "52472908447697862656e+232"},
    {0x1.ec76d7e7f32e2p+772, chars_format::scientific, 232,
        "4."
        "7784976871034017657828998291078668236623487242644644914264847523004671605405345205060382664131477986646772"
        "2581936925994293581013028451474231026238972770111773752319751131971234336498412185333726667594294627984138"
        "99670124201699704832e+232"},
    {0x1.d3759f7354154p+773, chars_format::scientific, 232,
        "9."
        "0717409462351582512879207312640879225431123157848376459340362691044319863360475833972671151727153309116995"
        "3613299761397581849446381550581035600067671862940836812139863996838391322873371913400669773299857668038200"
        "23594898696504868864e+232"},
    {0x1.60b6f9a6cb668p+774, chars_format::scientific, 233,
        "1."
        "3689900648819599419991078858656869356050765416475088609781162654859485781989429631408630164550721129967664"
        "6675163827600656199755269975930968054801793732987317632393636500462380441458195075095212933235225588518841"
        "565183013015978508288e+233"},
    {0x1.a3c77db35f695p+775, chars_format::scientific, 233,
        "3."
        "2585744935086660180085537685216732331026663391625900061588234651372494329208446661750343881062028179841303"
        "5000393796104926802636017982724900777294096366223520808626483957189965149721621399989255737668072734392114"
        "018704118688163823616e+233"},
    {0x1.eef5de3f62c58p+776, chars_format::scientific, 233,
        "7."
        "6843501087185603259794811375183224825835123024830390834443345796985216905971043462468467825065825145047912"
        "1257386904850155677148759667711046827420670638625636122992849194055661087738240939909807864958747679917006"
        "112904357735921876992e+233"},
    {0x1.51ba28979a120p+777, chars_format::scientific, 234,
        "1."
        "0486551202848853375181699262277440337923945323242630048499280070068758124711990691937553067092163306379919"
        "0422222904119665181775876352024680491963078704811585628707843147629411479151750523561295059610495989927852"
        "8033246763355767570432e+234"},
    {0x1.9fd38f9f73f2bp+778, chars_format::scientific, 234,
        "2."
        "5823121007464567046885104979832409380872880762161596664634031051456893788764672118543197766647423252524717"
        "0307633255407546495228163592433100635899361801211866063496903835777314254112040433160116491010111385123689"
        "1366615266610552766464e+234"},
    {0x1.2fd85095f4029p+779, chars_format::scientific, 234,
        "3."
        "7737986251795181095835920164939564313633089884412570875383489848740579279500977251032489962612862718014459"
        "5041934451207574079071891443012396619181365931939022192089253926699566323452121788658413861452700408983211"
        "6221541501954953314304e+234"},
    {0x1.53a0df58b1308p+780, chars_format::scientific, 234,
        "8."
        "4364679691797806256313772114875593122899646244438036914347789201255815561109009718495350779943521128881259"
        "8661124923431217585862647327109933253121360196158567686349248544337235420003592506010834170882608023751747"
        "7068626899846633095168e+234"},
    {0x1.7853413f16c1bp+781, chars_format::scientific, 235,
        "1."
        "8696054522844013509664557489900659356572827490676017450916178967106311547779856491307188349542101112658005"
        "3098413303218486048823934732760541446158555795168870076775230759271001968117088989630442719457652896597455"
        "96271845019699344572416e+235"},
    {0x1.290f64c0a0f5ep+782, chars_format::scientific, 235,
        "2."
        "9516238595214877391019012136241245927442169099813764219039877773719979680097489392174641389610352922713862"
        "8902868757290932493840034681749848237707039012241717603398087699376749157835378926747231022224572282910928"
        "54470262186353488822272e+235"},
    {0x1.20679eb9f303dp+783, chars_format::scientific, 235,
        "5."
        "7312462936233849305925187920881714268750677533351388440477657151051809265440304245372238020717328177593142"
        "9064721353299156284133767944100816062524710379859644110856014276632780205150657944504841760675017542719552"
        "22237400714209314996224e+235"},
    {0x1.0ae6422a72abbp+784, chars_format::scientific, 235,
        "1."
        "0607775243868115711926825104702485099576960722191170461588016074972416686189135822557494910590354927785656"
        "7083850395248216549451922015356056518653041712884366536987636471349052017628975047519627186995177400422200"
        "23553187720638060560384e+236"},
    {0x1.1fae68f6d3324p+785, chars_format::scientific, 236,
        "2."
        "2867476796644975342055548204548289275435560183835346401207452752101236086799245334489159236317267957184623"
        "4879581744011427460271415601344757392670319978490800104037484315382074503549454151575728513063134043673357"
        "388907554946695678656512e+236"},
    {0x1.82f324bb4860dp+786, chars_format::scientific, 236,
        "6."
        "1516444985886181727357453221116535473763949845453173834960261690368544010549543489487454308312467023024447"
        "0967757706399429039098458006133041212560333975577682232332306318262042874572315900263924809244346215012040"
        "747327614291824074555392e+236"},
    {0x1.e9086a4bb3d72p+787, chars_format::scientific, 237,
        "1."
        "5549079171535267166568033413417870991744231184791835809719299710986005512799425681538276698346509703305805"
        "4617203537691090821963960692442929762603678178038455360528641178678620670023850492270840173539406323710317"
        "8254440605458957894418432e+237"},
    {0x1.d652f229fd243p+788, chars_format::scientific, 237,
        "2."
        "9908440313383278368912373533975367049717676756972612940984767586749475466860589818042252470421233810163668"
        "3749783560695211165711422320509360631385450815428687040737896708577856392117557493106122006893865207379782"
        "6470503447254389439332352e+237"},
    {0x1.4c659adeeaf67p+789, chars_format::scientific, 237,
        "4."
        "2274995598601972032222337678751235842978225817536418737171989377903748469688843485647399209132115179868048"
        "9240050082237999694500369311211906203822141019030006735614618819688608441342428976843756087051623925917957"
        "8450042045898033696079872e+237"},
    {0x1.101c96a3868a6p+790, chars_format::scientific, 237,
        "6."
        "9215567271733196558872063527194708064680481237227097579729986091275194772991933509554387747175408105228081"
        "6233796919158801743026047613067889494775889443810654472404347304752284383575581614991240505067988050840315"
        "1299257176295521537490944e+237"},
    {0x1.2feaa8c33880fp+791, chars_format::scientific, 238,
        "1."
        "5461124618479105464453483545545961077350335978041066308476434140961798663738305852609528577253177541004264"
        "0674921875366981747217115434254049147564405886187748105641346990648763559992836126028859532577309470093173"
        "81536957859327362761490432e+238"},
    {0x1.1c3506245949bp+792, chars_format::scientific, 238,
        "2."
        "8916888598976405055845467699371144108721910078547909542725979622689182053188545464466646296396805653806317"
        "0836036200471157333970893400057175239052338998950252682537126124003318313408027335611478030392005373128576"
        "18649039581864838165430272e+238"},
    {0x1.a53b315cae3e6p+793, chars_format::scientific, 238,
        "8."
        "5717036974323367762593030056611124249261619721065331924115997871817897838109316309892238746944064174685523"
        "2984150458218061427298439892262170298880469338557863138712770368068789767923621713438853252396510913427465"
        "63574845645114888312324096e+238"},
    {0x1.745bcebb9e730p+794, chars_format::scientific, 239,
        "1."
        "5154374230926382629786617926068462189415932748214593100290129423498906597965529492278922108386430582250567"
        "9230720413708559249356818004688086218479660300094476630990188973104196131751327920959159056462338543462652"
        "696067619761155130246823936e+239"},
    {0x1.ea5c1c862f610p+795, chars_format::scientific, 239,
        "3."
        "9913651025539569774148436777915199443437437903111488693940333966405933913450275851962963503672699904713354"
        "5044278747331448497501833332967880884570497477720375620658674167625733285219550009450498956408406531707921"
        "573265195554001334403334144e+239"},
    {0x1.fe4e1de13002cp+796, chars_format::scientific, 239,
        "8."
        "3074269080682828035403659469788418623579020747406133262410756205289227611748578907682329529854919761832672"
        "8676047997399722106302513181726459927428568219275795529707364568555469545316952865939501666657645380373164"
        "457301122656345267900514304e+239"},
    {0x1.7cd4c04d040c6p+797, chars_format::scientific, 240,
        "1."
        "2399350584739398620370668363277739542438309813212305563315742903024940157069213691930769271579472323729116"
        "2131263255507441554972403061556545670837455397804297967092115183139920246349041107552795320281845170460877"
        "1159860186649204109959233536e+240"},
    {0x1.5f73b78bc87a6p+798, chars_format::scientific, 240,
        "2."
        "2885616582924816530784070073813311039250987450317110713303432962050972937344928770752692668293089194605529"
        "0608211137899351314019622136717256892539500984709059963064994229906613395884507758858205052191954459822151"
        "1781291374084313853894590464e+240"},
    {0x1.b69a2039b5067p+799, chars_format::scientific, 239,
        "5."
        "7121188043661456678328008872506093548138903663377281285041608520095637609485982476407075424240402729445877"
        "4339604678663923908333018208735883952749660808133865118239612527062177749104161441575379075297379081293147"
        "900960085778554829588660224e+240"},
    {0x1.c9318f56346cep+800, chars_format::scientific, 241,
        "1."
        "1908490153821644619283158093528109987426655170996365765458354656665026592260831211660273736320197228824006"
        "8807963045425342397876010784789085355187514744433409506006637286593902764710295855833163921908212729191008"
        "90475871653745707435922817024e+241"},
    {0x1.3401abd9cab1ap+801, chars_format::scientific, 241,
        "1."
        "6045249823083895881361713712860563391171156578164991575414289295334729737454938352044948456680926597969686"
        "3050925745120889688762125639047773240430867525918502288211250081770600066608865761538925445119403248848218"
        "31835718200815935339827822592e+241"},
    {0x1.9451509f4d594p+802, chars_format::scientific, 241,
        "4."
        "2124934926639872820698705164077561033150645322246951472983374360250084754509456140452771893891811650082700"
        "8476703202083427652946465999321227644609061896995232601668165659507537285142883393178871950813985101339523"
        "80834671272890871310960295936e+241"},
    {0x1.693311304ae2fp+803, chars_format::scientific, 241,
        "7."
        "5265104770080295332178367065129652045456275043609132847824336608669067826017952400204955940094293124054257"
        "4852475785253445301600099905150226104745436671874010092945098510190008435762604016218987540554515377647101"
        "33944076096837889877193261056e+241"},
    {0x1.df089519e462bp+804, chars_format::scientific, 242,
        "1."
        "9963765370119968481634926026034374951277940085239248593420718947575091589129383509024279171159858004359286"
        "3504688558306636678159262921707469490960871925725729662377046505733704375416744931077775146683786618929534"
        "332115383984329784377263259648e+242"},
    {0x1.ab89beb8aabe9p+805, chars_format::scientific, 242,
        "3."
        "5635374969254025430568585517027217792799444908420355818342861726178161794532723410749195781712690824031079"
        "4310017343869812907100148774183849097884081288715289464770501559880487864305271735159038213120854399040209"
        "060513455780040766296470585344e+242"},
    {0x1.46cc5273da02bp+806, chars_format::scientific, 242,
        "5."
        "4477366708058466566655134611672790509037546172460934890613623870129442401676517206783993128970039181958036"
        "2426384544674351131359326804752571414576642144329305895853634962921675886002767155811657977044320345585688"
        "095697352462571132700896264192e+242"},
    {0x1.4ea090983d564p+807, chars_format::scientific, 243,
        "1."
        "1156495207540661418253164809185472162272891713234991494380662613296616531540865244596484276497868309719437"
        "3617177643665645519840787000240301424692793361517832839191225386853868937776276743037203564445163231623308"
        "9241962428253771093052393259008e+243"},
    {0x1.629961b8658adp+808, chars_format::scientific, 242,
        "2."
        "3644722323729202530632376908724461464007109597368741902538920716759797234401817824648073587323994699955712"
        "5648264452732032858395869340884384877054134253129761707648394212187240812816821311542228673662308704897899"
        "583239538170340844922017415168e+243"},
    {0x1.6fa68b72c2677p+809, chars_format::scientific, 241,
        "4."
        "9029985515120054991219793866924216920750872251953397307190125386871656376547215435820610121121629918570469"
        "2932229965036512490045144581731082612773985577453660692576488506973338654493547303963526703015702844647889"
        "92102255616474420568439914496e+243"},
    {0x1.1d5ddcb816159p+810, chars_format::scientific, 243,
        "7."
        "6113157409388193238729532718952114744786351715842762343118286303360666708027503785066003043952596584492730"
        "8041709547073320956899512551777237915036724122719137575454507464793196061695217074073096327096395937968822"
        "3847143281208387082485955035136e+243"},
    {0x1.19fad786740bfp+811, chars_format::scientific, 244,
        "1."
        "5041965738192946200722212939761911313149957245913376893384443835763146165414530116096641460821289392931044"
        "0630078704558810797169674663860330303705781820921368183064402339199493404910007111083399854517304573251517"
        "69785159894859363338510334427136e+244"},
    {0x1.3ae2c0e08d1efp+812, chars_format::scientific, 244,
        "3."
        "3594604205776399571547735562723174528528296198287880206491449261321063694267756459118569069896694466315807"
        "9060394196735833929677656923702443863850476515869528665652443334766758399236901631693454061508781940650430"
        "83480115234578972233121652539392e+244"},
    {0x1.07a5540e2223ap+813, chars_format::scientific, 242,
        "5."
        "6255810937325722364168544190599919919944988115599126260371359454766948641453922395581588351836311443942717"
        "0074877286708288570679911572171655245727999618768162781235182605194711519538182992458325101322631274257458"
        "626935171995388819171019063296e+244"},
    {0x1.956e83e8c51e2p+814, chars_format::scientific, 245,
        "1."
        "7301916345499639352289638577061978996058784043095091824698294699979622683284037830111746691503650855841047"
        "6999939726846771500166314131694028889035553778607001781013613472061022354416879057893328192437062066419536"
        "392847325840865191718208676036608e+245"},
    {0x1.b8b498637dbdap+815, chars_format::scientific, 244,
        "3."
        "7614467878694320040847306920809823505948332555470424652166458420295692303534588660807141398391045858309584"
        "1413967874817042173260887173028178444373791701703929714447150030566240591625957163983380294595179856309594"
        "72307970883902414984099829645312e+245"},
    {0x1.f84238ea4240fp+816, chars_format::scientific, 244,
        "8."
        "6077546560347295614272909918464340647673924012472192336720324021049311703284577534957499927813020888938512"
        "8773917946855872595697344028186679078946097028129784645488986749964802103215644921535921267141777871369472"
        "69800165590575130107216339664896e+245"},
    {0x1.52ad71035d8cbp+817, chars_format::scientific, 246,
        "1."
        "1562529259815605130236730296100290106123624875586685093423585578874668718454767210057255513612992306754618"
        "7342013693230898318163998173292325928633817009622432686125928501176669069326632568840932966409440904636285"
        "6182501376346373114543815180419072e+246"},
    {0x1.48fec7d03fd3dp+818, chars_format::scientific, 246,
        "2."
        "2463948643754039805273266514856692451977272866202583855569230043159032686041759389714588747353194691583147"
        "4452902908475707849749179375503315481022788227755493105616171789512052603092214593918819436824445346786518"
        "3485659375409167115085108199030784e+246"},
    {0x1.cf3c351de21d2p+819, chars_format::scientific, 246,
        "6."
        "3259830327537269189044662519669296931261791172364221329361593637019414071398195080337671514053830368262017"
        "9485254074733712535986358581460970535047746807357544820196076947637608204117489620214881737780122049288515"
        "5229266752654874064585229395296256e+246"},
    {0x1.04cfee010a1b0p+820, chars_format::scientific, 246,
        "7."
        "1233523026483118129409774865992293632616547759253418297613685912737518499550086903830721434337398871647481"
        "6681062540280955271611695843215620922951427058580870118796718799201266852043478989988290818085278143313409"
        "0565968448841286218356104624078848e+246"},
    {0x1.16ff034ddceb6p+821, chars_format::scientific, 247,
        "1."
        "5239989788883321238503418080232313766405266685350202354474518823147319501930684180240795371555272910032577"
        "9049954354848675448536122534205586842891052665122265107971822539494506600965187819614128128697568579627352"
        "33879680013030703241961011578667008e+247"},
    {0x1.87edf8de5b8c5p+822, chars_format::scientific, 247,
        "4."
        "2817815958852792009690939837540692667657942500261648858225755618432069627819656317285479347915329201974236"
        "1774090371005988644354729115809575512603753519692608035351355704445179917631181514402455534288096929879543"
        "01004090162477967508729042667831296e+247"},
    {0x1.669c114e230f8p+823, chars_format::scientific, 247,
        "7."
        "8355308511237709530930810281471556447977784106662035440600564389370223232176896921185631429562490325760418"
        "4040678795337449978775441323897003748541667506968239033335149617631780016082197756792118648804974130157841"
        "59154833577142573195961256835547136e+247"},
    {0x1.58d031c626c98p+824, chars_format::scientific, 248,
        "1."
        "5068166821885369761241532108175293171326902216427944067512350661456054766473593312346835595474357273106155"
        "0443352975975022048534417756037602834654175485189498865510882476319162081279903462387165411735576127964682"
        "682475050190476626348021385449701376e+248"},
    {0x1.e34e95fb1fd7cp+825, chars_format::scientific, 248,
        "4."
        "2240545805625662788005553229538307210864857630306634011231079027836776827258668243309661298916332821350400"
        "9899722075244068756374649547572873002969477945909958513824369325732383525908290312550258447997151554563028"
        "850116547816966945718645194204643328e+248"},
    {0x1.63711d42e8969p+826, chars_format::scientific, 248,
        "6."
        "2130524104674504312709824639557523483551730337458850149335416915855240137673709836071529680319293067420338"
        "4312317758999145612684331260582769097598430580201878319065162034573403657954549033776399570698036990728014"
        "309370022216068485544971660370640896e+248"},
    {0x1.badc307c28bf7p+827, chars_format::scientific, 249,
        "1."
        "5482212253078290137323515076998672008506438386926224329269661187742030679492468266492921375476288647815377"
        "0979107822881541818928344505816759457570487597227978430112594020575530604815278455258654123939844316414811"
        "2432800361003761689682808487570046976e+249"},
    {0x1.0a9ffb84993f8p+828, chars_format::scientific, 249,
        "1."
        "8642201656825735032487045445737131264202090391740882730526180997719415020580181710931406700397570032582529"
        "1725810794370004636502368683142428033504081712262310941760777903706494337172156236906134798389170572882188"
        "1800728029892690586075143474451054592e+249"},
    {0x1.b4b37e4289e69p+829, chars_format::scientific, 249,
        "6."
        "1067588584012951929907635132587529022793422163084759285705466684191965135342417650787056752222825478137672"
        "2272607455634492474756781990175669040977221401874388780115943698876864915101026751851198210499562900472675"
        "3068810448767555137722058562680651776e+249"},
    {0x1.cb3dec22a459bp+830, chars_format::scientific, 250,
        "1."
        "2843929885114427205223509904897308175928651557268642545106012550730315214169113727124053496729076859906621"
        "7058048465589552560767724767960979474433908542662650232168843419395326916423547105760665888316678476707804"
        "15959665868837863306341265182751195136e+250"},
    {0x1.540046039353bp+831, chars_format::scientific, 250,
        "1."
        "9018081890692326060832549932962923793803050200930597137121291666343311907659231774649708656240141439885377"
        "2995852889168534092009700171523193933546858525442546217623145476647138397975513103720466511762535730409839"
        "44733060790144155006131906575106834432e+250"},
    {0x1.ba087c8abd72fp+832, chars_format::scientific, 248,
        "4."
        "9450566101263624434421552691226627188006160690582878226879528430254220763518819638978711170059796369024989"
        "9822324647556645340449063345238710759902438168656167462547098730749436504815208438476002132344287060560190"
        "686566675986547104771240121885261824e+250"},
    {0x1.c630424f784bfp+833, chars_format::scientific, 251,
        "1."
        "0162079024060941902752986278592898244854037810570970835536347253884184405811222585986918355510523699760710"
        "8720562738620020129036885402684555944864458354638982574226703061602498417867883983480388401527947236142554"
        "900694304483602071758702926508016533504e+251"},
    {0x1.85e91d57faa7fp+834, chars_format::scientific, 250,
        "1."
        "7447831757371135971868471755808753449591436173823296107480817640339909863589495003745228117499203382520206"
        "9539324151967771977343828509557409552448094340742113501911628551355358681804381630523888669439044433379659"
        "77036968476816664586097351991475830784e+251"},
    {0x1.dd2774ff825b7p+835, chars_format::scientific, 250,
        "4."
        "2703660170962130244303048163026444835147574558041973970175978956362702386703322527155179489291238033872231"
        "9202066539552047310868912136192587125219809728800730236760671881009425615956313883933879641516247520243538"
        "50540715761104916193393419547242921984e+251"},
    {0x1.7fb49456f0d6fp+836, chars_format::scientific, 251,
        "6."
        "8680635961010054778547732613484647985247018036381086963058134686484342338181759398735578464286990961512242"
        "3860524082353077746568202335565206880392172011863842924238725950600524821099164719063099983937577502742978"
        "451517889868589043980171636988524363776e+251"},
    {0x1.fd01873113f1bp+837, chars_format::scientific, 251,
        "1."
        "8221716304153650272213764159000693884485126489166324070442650059724346984915036736532717255211886200617045"
        "1559140970097704185891051060148919646916253880568664978507007421126009924560566886603966798872120047504227"
        "498682957727850164695377954464654688256e+252"},
    {0x1.16ae49bfdd770p+838, chars_format::scientific, 252,
        "1."
        "9952782556234112235618388114000024419696976918884012985196883706080092405613980858524205835778745894133321"
        "0868285436775919750725736172285506109646439824434030650330008589013231883176343982203914391073596652430291"
        "7790375371341763162002626475342277115904e+252"},
    {0x1.f3ef2c4210cacp+839, chars_format::scientific, 252,
        "7."
        "1587847487893079499698458355959164784160549019709356298631985163802186160082258587785870869537220428341295"
        "9154953762325391374645796181723015336842060030080570448235415608409317273087473499964688536725010673884928"
        "8705506701643342594415108812000139935744e+252"},
    {0x1.ad8a77a22e9ccp+840, chars_format::scientific, 253,
        "1."
        "2301580219420288258750710073967242803603244157181759807205724391294942735957066782958529919353781927634981"
        "0332178857663060811072852430571703413531625861496620272515219238779208406942710051992836031567349036998627"
        "60042508068641111106629716312501667233792e+253"},
    {0x1.ee0e5ceddd957p+841, chars_format::scientific, 253,
        "2."
        "8298450670726808039569020713611370769752247693265877738977218776671815871966890797048229309787176096732913"
        "1557575024724858315121232799546498374424641272691542726135168215216303393892641064985962692205494753902395"
        "25928386877340201687282618195535303016448e+253"},
    {0x1.5b0d6e76dda47p+842, chars_format::scientific, 252,
        "3."
        "9756809005620167673963500063290061375743826936924843916067298983960768988309298922372333125861749340072060"
        "3193814599385110267978592875000662237114376052227737122342324525293468477254761924145161645921032961639161"
        "0300989215056042850046033283650733211648e+253"},
    {0x1.7c22aee81fa83p+843, chars_format::scientific, 253,
        "8."
        "7093308214511152528107680123068762354482351630940844953037898917744938205727100690119337533031598012932830"
        "5899183516041902309269864529394908188602588257391769221874838167307939441021963369847794051919452848913192"
        "07064962654856171425270750844538014662656e+253"},
    {0x1.b84441e72b707p+844, chars_format::scientific, 254,
        "2."
        "0174005971626055001082205847662126781792713876424713491426107135200153377636963327796919425670606854013876"
        "9188228169130929018386056603499673065740489029850179269264269221606509548886182752766216275942511240393316"
        "495487843867292364651919029871904141869056e+254"},
    {0x1.0552b62c8e128p+845, chars_format::scientific, 254,
        "2."
        "3948822178489890559980219012723484849467341938240490533083040081270350965283979484566831974206206564200097"
        "7813391908034755444058999987765739175366039266476547129613207191807837450381143027634960650298481158853128"
        "823296817588537874887085684399549987160064e+254"},
    {0x1.81940cda93532p+846, chars_format::scientific, 253,
        "7."
        "0672259148746032781953096787839027889529056934666995406469164252062383501495468316183615878862193250089894"
        "2824729667688989026764849833220049830460614235982996258221917434939821706769386936014308325931527289971326"
        "51595911203444205265762564863624413708288e+254"},
    {0x1.feca14e0d5431p+847, chars_format::scientific, 255,
        "1."
        "8724413449264554000912479366013655429391738786825257650857219360436405508576111348384928174760062323641767"
        "8355963928202928363122166407384529802017781834605348048825483579470507214795788114765647102370549369679820"
        "3822670734824380038945947831900155722858496e+255"},
    {0x1.8827ec23206d4p+848, chars_format::scientific, 255,
        "2."
        "8751146201193473147511048914580957805762968774039920973219195905081640980452976049063596877710504384456337"
        "8942133482080646288612528269588423761555820470966805352165440971982693782996962226116197358314589774284203"
        "1555441896836579508527488730801254267092992e+255"},
    {0x1.b5f64571e8768p+849, chars_format::scientific, 255,
        "6."
        "4218887967767973147050111402854431025976259585437744180673244997762152424757771170884317557489625383493538"
        "8361393226475356050594915067079552993583324564851489103509456327285189214338400599281283635090488306320315"
        "4505532895528456078517711521452946616221696e+255"},
    {0x1.008a415b3183ap+850, chars_format::scientific, 254,
        "7."
        "5233547495587533813215041264189804683273644679977334152418586391745637517690648136494502205349178507544930"
        "4982226958672016967506014326702860578746451776174964112417893379382667476706170679989555178879302805753091"
        "108683336905960853244568321779433883041792e+255"},
    {0x1.80ce08985395dp+851, chars_format::scientific, 254,
        "2."
        "2569755092325086975203493724033279385000107408412293275710347345297410075316635764407052156717311305034067"
        "6514647322222782299508751884380960970986935005936264995993547014912920456411557793138937542233075945826841"
        "792852744388221269309269296056441948340224e+256"},
    {0x1.c93e2e3575dd3p+852, chars_format::scientific, 256,
        "5."
        "3636854859010334156927466175684003738394714128573400526327089603309985356772629772564613094187950836011490"
        "7981918758305409650123299920242433241170318463532135276196145928454218679932889499527926234187310919488675"
        "05567571032101385441229409672592337764614144e+256"},
    {0x1.3585fd503289fp+853, chars_format::scientific, 256,
        "7."
        "2617253380026673444035579620762527314882508741575498105068925220256457780553521247639040403375622083543231"
        "6486550264499628730776026761628843667046600384317735951023059613456072596871655802663640764044923285549142"
        "62493008301528885911022370188177304688001024e+256"},
    {0x1.9437b5f9e6b1dp+854, chars_format::scientific, 257,
        "1."
        "8966691176866934017770214207713233840154439494884324292130780115404111263157917885413943878915831820762225"
        "0583303348187654531921298414600764621002789059760464627013274391530347087973710882160208775617821106882488"
        "293831053109873906677004142654823373750665216e+257"},
    {0x1.da62d2c072d77p+855, chars_format::scientific, 256,
        "4."
        "4518263636702483965495053856865406170236863462890282079194516118432973996711016751060886266308495383903464"
        "2746150586093362335739021603552694829648595836492021186657012662450405162755427498833201023318739340117695"
        "42527011418624873181894562270229605954617344e+257"},
    {0x1.ed1dc3f094314p+856, chars_format::scientific, 257,
        "9."
        "2551967587286591706284322222810649405226651345273042856895913250378153451345197355495763043221473190696946"
        "0611860955463662896675534000088606972814085114676199268097264054120326412981252636237720041559537499349640"
        "773600892533856516647510713166368494906769408e+257"},
    {0x1.ef52edd00039ap+857, chars_format::scientific, 258,
        "1."
        "8593264122501495174403183867678233836361455504181472606197270931819321323497564161749153365807154991322567"
        "2390476030417331932845704484326216214934527954763403077000110171731127369920811460830859516485802752602017"
        "3336192319696495016121803920946730655041978368e+258"},
    {0x1.e3bb125744a76p+858, chars_format::scientific, 258,
        "3."
        "6316167357983087714844824037018917492844360826517442957456966973425494059948116922878230830137295968794133"
        "6015957431917607400275062474387002683489057752768415445554866083398760065152355237788926587402650325283626"
        "7137258982023926052809172133449146986873749504e+258"},
    {0x1.ca0a9344ec42dp+859, chars_format::scientific, 258,
        "6."
        "8775056809719936773562239947664051518174519882815181477860548157748963568061643541510085655252472888900274"
        "6169928864401679954432098644991193402932567830206563234050230289011829876954220287981867426303858627431151"
        "5637490526902098135179090001625391964633432064e+258"},
    {0x1.2411970d3d9abp+860, chars_format::scientific, 258,
        "8."
        "7708430554932495543370037977511351939308693383512112665323264941874463770609190130161570455198577258604133"
        "4636679907937258218577041989632331153050988708602551653751196950259687810167099278093778665549710623277951"
        "8706602377059819914819060153907843977606856704e+258"},
    {0x1.1ec5847492eb6p+861, chars_format::scientific, 259,
        "1."
        "7223538042831239341548853561863193983642495213487394348170048026198592090336204240078770738165496044637111"
        "2342217250321051024454736362963000514473798185873133075921137741486035081623276812829601351743319683570519"
        "09828327505871566528836256883770889417414148096e+259"},
    {0x1.1cea572360825p+862, chars_format::scientific, 259,
        "3."
        "4224113618416387660983968909127780621102150832355912954774258704013837006241377937016098367433894097044239"
        "9548559312156546552455940215868211600940072182151265581465924724472562938954641277540870592656137399445957"
        "77869883504853717504448659641688579757020545024e+259"},
    {0x1.24cde6b8208dep+863, chars_format::scientific, 259,
        "7."
        "0343463133020690622080363520915250368134172380431222412466942091558376798359445012434068235562476291266919"
        "2263483493964563327850244971569130974664971468010256534095152179979912990687755183256723803192619430204631"
        "97815031497056680470826442214372237094403702784e+259"},
    {0x1.b585d7749984ep+864, chars_format::scientific, 258,
        "2."
        "1022143522712642534927702470363833595361742788098251565939808660957882314655047911950792006855166244834767"
        "9742384528807478336575531155237574537062478111192313055661179917070288035713865139698150878247481139550834"
        "5057190337375468415342190739196099429459296256e+260"},
    {0x1.9d037445325cdp+865, chars_format::scientific, 260,
        "3."
        "9689033579839333586087273329545497202552025223101557954368170073685594346508353881665191789733101162600963"
        "3832666126630950368714500596474244775837396509928744970487499110108854614051229977132244291177899594800898"
        "868953265027415713662233602012993288552077852672e+260"},
    {0x1.164c006e21d01p+866, chars_format::scientific, 260,
        "5."
        "3486554156761041122966272313360276147722474552229895173187242042125351415357870740578477470191391604587784"
        "7544762046104950012172421985090219541563083951673230860935981090927118350656495882735065989904791768286592"
        "793842156241914783340450390835867251603190841344e+260"},
    {0x1.b1ad1c32ca51ep+867, chars_format::scientific, 261,
        "1."
        "6669857056073904295877757328423769453449385938496074603048454391418528215175463715315403787528483878921026"
        "9734985247684352986127262307989667303704374626967638897389849285583351959286670587460222313677004843462283"
        "3020129626133155057078829236175711168725220589568e+261"},
    {0x1.48aec4c5297d8p+868, chars_format::scientific, 261,
        "2."
        "5268130061515183896672541083193819962814958369017161861916462692004818230105550952960108454257383922547725"
        "9430047285044243142322797421645388825477485111128620457670266244438408508981040669938314329656372612659262"
        "6063461209454637519696384115499033283572944338944e+261"},
    {0x1.c82791a9d61b3p+869, chars_format::scientific, 261,
        "7."
        "0135563955506447327134376779608858242321794549199409417336758439247473329704075211614864504298236856709108"
        "9491580123853294665804589087607528139845738395671479742204503115659932020873035669822478208917777517363066"
        "9756457138689042468036550644721521533789925277696e+261"},
    {0x1.6aa8c3fa4676cp+870, chars_format::scientific, 261,
        "1."
        "1152057754767969643018536779865322527240533916315230067839324867956406896271582112257557870903391509215809"
        "1956327894126813093730344747664064030616933374758815912702205423104102393081857574217568447918712081463529"
        "1478507530630185498829253348514286180823709253632e+262"},
    {0x1.283c03e3922cap+871, chars_format::scientific, 262,
        "1."
        "8218885128879403050907701841700254353705385323409708627633550805724582437371113678359942756580855059619909"
        "5387096660000020113210681570207177994891885681937114934287699917995965873657954921553898263299260585869319"
        "43076794661977482279539782871784104567717178114048e+262"},
    {0x1.8cea9120f82c5p+872, chars_format::scientific, 262,
        "4."
        "8821954627592468297034144101052902316423641419746580555012088510975847917374634573939724055978958532505445"
        "8910824834864704440551871917541689058272749866358635949227602996538977376206298893196919077990415442432746"
        "80302980924347818100188562495929432829251712712704e+262"},
    {0x1.d973ddd6f5b77p+873, chars_format::scientific, 263,
        "1."
        "1647232869439797144128612526951735538946998095578708442740497215499916303005982058096215134648677496022778"
        "3588644046610606860532249494006024946027982640278803787353469535819812520682463463954423986471436740424759"
        "351730369993756319745282998559730184772104807776256e+263"},
    {0x1.f6b246aa65daap+874, chars_format::scientific, 263,
        "2."
        "4733296974221883796778661362827342887970759082625185925539120429912050329008686714438091418672145986492174"
        "7123831207566139995773072740794784173590930118904914778018952948323351202355867513511555638275356370863058"
        "697535795005475738555744173010248664718303031197696e+263"},
    {0x1.84c43fcdfd3c9p+875, chars_format::scientific, 263,
        "3."
        "8255614772231619409090663562751720549695664441740645381704259047208036365622208250797489037403777801687502"
        "1251820705911738604051395984150068267867571861969188371719006695794892970741841549480519926689507865382895"
        "043590951293226573743254266501415406206108651487232e+263"},
    {0x1.0d0cf61c34917p+876, chars_format::scientific, 263,
        "5."
        "2950522530435664148148531050362284907601275172048568844087760323458796487612851879945690043513677305823631"
        "1027963509478254881181136917908166870711973901108220565960964083875886854518680826821014422246633900470942"
        "204464313973177246167132074412483179319922517868544e+263"},
    {0x1.b7470f572ca34p+877, chars_format::scientific, 264,
        "1."
        "7290409059596491160392660629780224120987670924600492127521833122544559638181938355651161578571122937908200"
        "4736562726151156355066947256957893503527892947890490864878566555947580613942211204717040529195486299636201"
        "4302506768477688217193036724104566863122371314712576e+264"},
    {0x1.6f579373cf416p+878, chars_format::scientific, 264,
        "2."
        "8917911522817363012645491894345880877959140658748164626457215144933567697478848748246557694041140147148397"
        "3773154689131883953422212476453709028316632368941627329032791514854112432586368236522512126676854020608788"
        "8147820900177311817262558184006103887903947191484416e+264"},
    {0x1.53e61c25b3dd6p+879, chars_format::scientific, 263,
        "5."
        "3515050581631755036520580325118687673947236845337125650051164727089722015319573279603673205642180581633918"
        "2827247492806189852021233450786795459652269420367267283626129052088926393182523919980423037030122018430228"
        "265381645243737717520975191570311770107321052561408e+264"},
    {0x1.58f3a1aff6692p+880, chars_format::scientific, 265,
        "1."
        "0862117360156828711782018083715567701140855006689768849211310756691923390150596155361509757423012122662014"
        "7543606621525575325168914047694766792472765528962462244301048456879469093164518615503952892850670680855784"
        "38933939908261673483684160060573765056449123499114496e+265"},
    {0x1.6f410a840c9f6p+881, chars_format::scientific, 265,
        "2."
        "3128785488546931489272260574369394166074818677610901547355806177242180002180697086090725045491064466731356"
        "0127553031593838481376225630920940311878815089733830843845396846155751065465312595061542938566927311228508"
        "35008617650833500338712484495998333181450026401923072e+265"},
    {0x1.c55ec45991240p+882, chars_format::scientific, 265,
        "5."
        "7104346407744366879442524026328321873829311834849605463322151469516209295387639527101327649590792421651782"
        "9514315747910569800251356318437826344953522781497302877730755704197328949288706415489347212482536070831297"
        "69835264604896319470976595601519978424881761413496832e+265"},
    {0x1.c4390577e353fp+883, chars_format::scientific, 266,
        "1."
        "1391963969865947573314488432655043746990076042479005580857991691371729105469208930334011603031931765527660"
        "0917805873430073523272197714955603390704189230682334970513371435191967474393169903239028641874533354488266"
        "172291445223237400317190676258012429832003316365656064e+266"},
    {0x1.80024108442cep+884, chars_format::scientific, 265,
        "1."
        "9347167157285601303774915232697415595562286652874494078992920448925138324939113354855246958541500385382314"
        "1416650002056326762170466471434812679273445318398594637346034345659552218437003750926311120682080530960525"
        "91460233395247230558816996364387719414973408389103616e+266"},
    {0x1.d3b49d281769fp+885, chars_format::scientific, 266,
        "4."
        "7127965925819099014644056539795354030893985157309915619565784136091723470489083161162051111812262902453425"
        "2262801742043035998900246742774977786010211977964487997955922525106556091069988389010083332747065934945098"
        "638325018724512951515441851702692596765254267021819904e+266"},
    {0x1.e1d71a9ff3f96p+886, chars_format::scientific, 266,
        "9."
        "7104480347680526724388655440563722229957272133761493078196799014479854048146499410022289577832223787658711"
        "0622082427832522414467935051386635148225548368445563790964504191323587209199839274129077851038873657848234"
        "049424161572976854377951240964017540898697569732919296e+266"},
    {0x1.a7027ae520191p+887, chars_format::scientific, 267,
        "1."
        "7049690600947821370125168065492658748824492222019128137338447696856596238790064614116696201248482964846722"
        "5184628076677445407056663027092528425760141456580472815946048919674298043627948451671861971785724528256343"
        "9952765212043058091006226485989331945084763383877599232e+267"},
    {0x1.07cadff975a25p+888, chars_format::scientific, 267,
        "2."
        "1264667446960466843185764124801368452628993903514278513168587197748772998239803298839293111491786165979697"
        "6630982545509082578930304252710488146559865458098358329640035523049333552971483963136440119661263615817430"
        "8868271748374352726432722496121159510184514510133395456e+267"},
    {0x1.cae05e4bb900cp+889, chars_format::scientific, 267,
        "7."
        "3981296724233212368915462203134618633827781348288599081204473928605382035734896070754821747025697168204777"
        "5831164644939498894759068631892579557932411831268566497011835763566862033238415369736821458656129565314617"
        "8255710476500506024135400500117736967485460947838959616e+267"},
    {0x1.2eca1796b7a01p+890, chars_format::scientific, 267,
        "9."
        "7633054173860787578411930441342299812581938383096906442189245136120952178871210673264010432571176704977342"
        "5144875507166490525658553295176797506420287263697491032818297518673506315051096497540547092110494724301159"
        "8819166228787969713283529575588634229583035259655553024e+267"},
    {0x1.406a4282d1f80p+891, chars_format::scientific, 268,
        "2."
        "0663273080075777668338994648180231590952022821837453038885287279067698313592069654163912058841010723048508"
        "4956016466783712260016983074067762455585111313554422858547193254983943038061713540787691125397501471732455"
        "71337587193911747858038040870387038252781816931388751872e+268"},
    {0x1.c19ff8bce5676p+892, chars_format::scientific, 268,
        "5."
        "7991789555885803138323063424220372329352634074389977280603810320972219404232779295106348205917934689394522"
        "6968684544645340888018484272478339697145259214282893355358872397623678216624402157855548818728918426167134"
        "32471899850352776136551900415744006197797151659494735872e+268"},
    {0x1.1fe38d5e73e29p+893, chars_format::scientific, 268,
        "7."
        "4262753269739863071097258410894263038106306114820869566206729774587639804770146725844918946518744734031143"
        "0212086497566770910828541707679614353259556721899264745050804359726236597577003220048795740807701689255561"
        "62933649281172853594080068740031755532479512733798105088e+268"},
    {0x1.9c33b1b47ba39p+894, chars_format::scientific, 268,
        "2."
        "1266018116022865411879381930967069790650798465621914648129213144859095777763598456618525330801709641460962"
        "0283984888529353757272520111093436834836026317167197256918208615548851093068000261067283457692229986020108"
        "92382509460090260457040044765667150887352245110542696448e+269"},
    {0x1.a26d55f602cabp+895, chars_format::scientific, 269,
        "4."
        "3174364231170401202551735299747722543232356757700271552533167886073035283977844894207602162776571084158010"
        "6637487827981321272123315762352293798979542062159013795203284222229869402422626555139587775055186134834731"
        "324943467913151240603384480045011193118883243399917338624e+269"},
    {0x1.9dbb95083d899p+896, chars_format::scientific, 269,
        "8."
        "5379978661479379320868346870429258696342415203889512925623464380466473704249833165653284702162353335262430"
        "2307718738124555968647710529467983770429635871301993423689601725064452486406011335898739997113633529929962"
        "577600432036682866890623144100588419524680589002758160384e+269"},
    {0x1.6af76358f5a1dp+897, chars_format::scientific, 268,
        "1."
        "4980714281344640077800324391631747631672023321820143802880940360267132634221480283784766939394893412549743"
        "3151756991181766902713336944094229312003649709735112045122838057934124138596703039110082058592770254239274"
        "54742902981302864610102076457909707158804960722041176064e+270"},
    {0x1.158ee8ababa48p+898, chars_format::scientific, 269,
        "2."
        "2911327982233443224255282606251683954818178224101142096814170593799078226053624816860825230410849307401794"
        "9387270640396091306344102882935763609967168275344632506117759911529139873832889312080415806425530984667493"
        "141882202135810556985477247500496099082247955662411661312e+270"},
    {0x1.e6e6e63b2d752p+899, chars_format::scientific, 270,
        "8."
        "0383636773183965563279950292424708434270709791957562856743978678069397060540636573407544654392197003659831"
        "0384498916233030138783388753183256314274108920183065336069113265406239709403032217045311711966041684929643"
        "7886880687688620940240142624597135728868058798902940270592e+270"},
    {0x1.efb1c88f1b917p+900, chars_format::scientific, 271,
        "1."
        "6367042236629718729268402905374296656046770255365947397612805585584577853260684216085805613577865939803054"
        "0017828458853352846712273689458592461038336716933341640440422893827137366319492868172331188522757035612448"
        "66825763146062984617418588471703105453076171109553535975424e+271"},
    {0x1.09f8f19708f4bp+901, chars_format::scientific, 271,
        "1."
        "7563972945923824150525176891612462671316782210660684679553841323870503209610405498092263311262830620848698"
        "1665909632003524215493513538752535250736701221979553770233146160642843021918667772131483618387627906645341"
        "51448437648021580687531829596950159719152557277080794955776e+271"},
    {0x1.4baeba8c6048ap+902, chars_format::scientific, 271,
        "4."
        "3806517196597018427536671187880965481198827304651513198477564882433011473589151224194298825916010573320122"
        "5609468413588284017169338273312525874904100588433697308517750041713396596008724468325763195854907398850846"
        "27694863349688275377814547997028444578550781519051836358656e+271"},
    {0x1.8cd2d20b35045p+903, chars_format::scientific, 272,
        "1."
        "0481984706425230890135303927487114643980806409793254758292517423408650454004004690410386164020024921406758"
        "0233261931631992081782639072972543258522686672291340682053372574758989506104340886674614134885461225788767"
        "794959454342911064675144442738585353876408558614225881137152e+272"},
    {0x1.8d927eecfed2cp+904, chars_format::scientific, 272,
        "2."
        "1003524500133662840062505751219054791731938233584420309293263329740744737213481017895065823059205657074688"
        "0495003915982871650202221554392121175674180533011917736497246381453282842769636604896153823898456077059993"
        "174472058950185123299125702872712090700453722243307694718976e+272"},
    {0x1.de6575ee0f842p+905, chars_format::scientific, 272,
        "5."
        "0546833046720616928644353045604638530577598414714986252992662226709325284346824803889505568642104307349610"
        "7456864923351748471226817911054373931071993953305772937720049829944021694539009473977809362995695360293075"
        "326737012260339556128535967312245217254998376141704004632576e+272"},
    {0x1.02c1c5af5c860p+906, chars_format::scientific, 272,
        "5."
        "4679946858938374499976093477651454227758162651854337179090133937645556976337514121554834083379163511523367"
        "8815555279040921759101244136392626043168966853295239988637028313028438110232397895920842852413186318437631"
        "699837025581837989426185144833604274121548536678718694752256e+272"},
    {0x1.2768e4c0016e5p+907, chars_format::scientific, 272,
        "1."
        "2485068025844775960002963813255958238990842988066318183410805756654220701045964459693999153819613426900795"
        "3835901620646121933168654246197946439033027346268505733120081821047015798725629926657488742079842818172233"
        "730531858978327745494162155720720998081562069703878674219008e+273"},
    {0x1.4e3237606f16cp+908, chars_format::scientific, 272,
        "2."
        "8248640371828672657868329395057769266301903582528250762504229181498738699765492883442629604378488105536677"
        "3049664084859301174542831369333256493187132550588644734495208565407517304624328179771024064881746101714668"
        "858926752177144909757882154154206792562438451054311169327104e+273"},
    {0x1.f05eff930a17ep+909, chars_format::scientific, 273,
        "8."
        "3913641859492810787304674784341053014693270446678981564276345206432838412584894683772323627106734331361054"
        "1416581936570159334220486914190086840257940612625606332369702794070260260363486788238523036201758835057677"
        "5298560150181764281568949818405610899480408885000428278775808e+273"},
    {0x1.a23308e004343p+910, chars_format::scientific, 273,
        "1."
        "4139675630970964068757427171450653642480984699223731129945891669323413302498586940624987482328347106006806"
        "4846263217980807891598990769975307425626751189318159967805770045501337306828952847948820905736086031581277"
        "8238270061183253086797412098465350022320714292528734678286336e+274"},
    {0x1.adec4218e0233p+911, chars_format::scientific, 274,
        "2."
        "9072116249125091042939641046412524813869995898197412985742610942841277694000191408581191975005336470406860"
        "8670999527092918316192574758132203457803702842095218262638389308959004912152377412018312352260096133426289"
        "29616172359221046711196391821853929650939211266126599721844736e+274"},
    {0x1.43575d8295151p+912, chars_format::scientific, 274,
        "4."
        "3729772786894278772365021639725627716998749940973044545992005554096377244645619407904548756693601776261605"
        "6152952004922597898719595364079241320185751107634778684879091923536788821539360129388400052441674499939002"
        "25872455306119622800921723936421051368987504900833416633647104e+274"},
    {0x1.be237fd05844bp+913, chars_format::scientific, 275,
        "1."
        "2067462091729204821705996332843518364549184819962054996414528185176897061805656617790934688110747687253529"
        "5544306710936939451090047765146059368821612654865459656462252966998392455236514266859434922735356209088047"
        "813317803540270554003913049746492043246213723402668101888638976e+275"},
    {0x1.9b2ed63fe7c22p+914, chars_format::scientific, 275,
        "2."
        "2243912429104520893942654928612862245652916790922677520426543135574633357874274265454057414544428592629568"
        "3796964658643810060103302362801047962335174283932176205460605605005617307935818958118860615338703168794392"
        "925077735391135331507600083390485205139796785562476991788089344e+275"},
    {0x1.8f0f2f60d3781p+915, chars_format::scientific, 275,
        "4."
        "3176111022712280167867660225316851001302201103025801779751953430446989655794342643320229462126147375696598"
        "6057754614071827730076422192135164453903891238489923349099709102388438790681497597224304990926662001012579"
        "367979653974531063520144552196830827397549438193507868325445632e+275"},
    {0x1.0f15d62fc5633p+916, chars_format::scientific, 275,
        "5."
        "8659996133632342527001688155338604828401105070265177949168444721384708318888625799190903763436682845675922"
        "7306284715963508222892046333736999261786975277280777429050552743479409111642363144164702524788373433324848"
        "215428458862120335468197775176023691718933345373884546130378752e+275"},
    {0x1.a13ca388420aep+917, chars_format::scientific, 276,
        "1."
        "8057130538588834061048515934756534390995822489129192711153743070686906337113213930488158590783023451845083"
        "4651614746589574435978102564052687814920235501288032606984645988911873437050795965137276804729122742273770"
        "9200512048695849494656431906847973487558358759169627465021652992e+276"},
    {0x1.362f096e14122p+918, chars_format::scientific, 276,
        "2."
        "6848194108224777937082562383506307368133432936919747599586612304240456657094417970576945341505202731025352"
        "0632752982342719728088743709847151084657234962263380932275542718077487586432626777649283951018672398397489"
        "3363047437618046657896564635520646493576084143889699133523492864e+276"},
    {0x1.8fa644035b86cp+919, chars_format::scientific, 276,
        "6."
        "9183940909811462267856874429532960053214473707563125892325174523868752693267436284447579323441695765517285"
        "6461752013313380421614617466134738839127312838144728166026552309098455007679065231380711981036221944925591"
        "6170496306109571246026337759461802379014512053313539039259787264e+276"},
    {0x1.15b58f82ad041p+920, chars_format::scientific, 276,
        "9."
        "6149348499063526743580344354791228259201017811104329003387392966700402965231618105168720685759553521422977"
        "2969122421092284303078177102786518853954107198000838782620800583313899806099610317077183204555144851614542"
        "1691615264016637411219377961498887240480935611881565575031291904e+276"},
    {0x1.f7e12b4722058p+921, chars_format::scientific, 277,
        "3."
        "4890949511765381917564489227625018979093213131187560258974574296412643868128154485421838312923799775150875"
        "9003316961232195921638521029189519961907126691803128371022641904028323108603719958360190246770869300997950"
        "38164349707939106070027734238634052910612717651260495359532597248e+277"},
    {0x1.b833396267bb9p+922, chars_format::scientific, 276,
        "6."
        "0962977207855186085746743770786866262858276275147849851959864674542242692534585216614320573201966495522684"
        "4025068473917567647785710745382815112116621538896778982052242681474360748602092434215393751764209878376730"
        "6117947376901223073177337953389454932670330342413819437144604672e+277"},
    {0x1.14ff9cd90c1c8p+923, chars_format::scientific, 277,
        "7."
        "6722620777448847130061796967153409035280000143520385310098455611892015953736303672977253557984136122161764"
        "1855280039261746154536109173275027345666993959003781623111625182923681709420935853242720927515701234022138"
        "97816199751137235767500308035447734094150706669707498282849140736e+277"},
    {0x1.3b1721167a5c2p+924, chars_format::scientific, 278,
        "1."
        "7454649363112346458114019774333177916866258109488378818436939429302078045906152707336731339732354531371694"
        "1228055475050043477580785364864935817555122130690642448975527407028574117711690510070820468159098253463861"
        "923710066771866278518787343952413380888028548678629320352600162304e+278"},
    {0x1.8a85c622c377ep+925, chars_format::scientific, 278,
        "4."
        "3709703490882645460547143745214997008005362476756005415933050867512306390155350060744401126622118183385628"
        "8935916341301053038413513553972091488238540498015095359572244498057448525080787377489166010463475091450891"
        "077867871890421144700651238367267845567414870002937756298860560384e+278"},
    {0x1.e4116b8770eb9p+926, chars_format::scientific, 279,
        "1."
        "0726114671866102551956995063181805410834259689461649311344404290995629835609285447093274145176968382209577"
        "6917302675169618383427699560030805008762564142832457663950285524391007167921681697164854346295152420849109"
        "2988143024833061601691689500187256255660717629109506653574802702336e+279"},
    {0x1.2a7f9aaaa274cp+927, chars_format::scientific, 279,
        "1."
        "3228423831361687349286227308475220689391231854842087295811247105913948608236089430096611789280877039362419"
        "3685744676257728697617300128153225560718497346830092449123962427997239392877784320723478193203713049316253"
        "3391015168714982268831422978156810759831148502703022726522467254272e+279"},
    {0x1.a112cefbcbd73p+928, chars_format::scientific, 279,
        "3."
        "6966520737709448562733517100815008461375735122478974319844006900499629823014306882648742396218913673903183"
        "5461596068574474985809396613938975088998218789612590775661930938869393235058776456670475387448381842545651"
        "4513165432860037804808051299109674905178839116525770357448709767168e+279"},
    {0x1.36a61081043f2p+929, chars_format::scientific, 278,
        "5."
        "5067521766553316365405027111879142061254413625271933177107069898070693174397408489738092892207866286482884"
        "5554683734104354555516180291558086314950736248180147530492954485185572182609677010072096843339571865071862"
        "178828666956936942499956139255069398138943922537089722379860443136e+279"},
    {0x1.98a5de28ff8fbp+930, chars_format::scientific, 280,
        "1."
        "4487895211141177065279488132777108116369718048416908124269709876510583237549918320826970379166384928483716"
        "1019967289695505122642072428382029305751309173352444213166148718207712764857116771438695299098448134310869"
        "65217307420056734039126102817769912404692662944189803753694493147136e+280"},
    {0x1.a53cb3ab922ddp+931, chars_format::scientific, 279,
        "2."
        "9868446101560017108642363680724015778812195311497478659672452525980171949720889266701711072171369061987837"
        "0719397873902392998888281790588552992933134932269907085753375411494921811461160297454476748326154204304000"
        "2632972792550636638956325947677509230573449759918627641766761725952e+280"},
    {0x1.6b6f105002edfp+932, chars_format::scientific, 280,
        "5."
        "1539637484359395145169998086608752414201287314052389550098572221666968199721428219163097111568025636009928"
        "9868974947747462738997782687742154327301151940704590687700939863040862556558535022961081423132129579761964"
        "34291429763959675488362249598031403354267911828901663515648043515904e+280"},
    {0x1.e1d1de4ed51d6p+933, chars_format::scientific, 281,
        "1."
        "3665660611345062300699415815156476698279049368362851304007368637846199054342285443988800802553372187636752"
        "3248917337453828432049841686697470139687419077855970402061884421298998636269755090181183266935109407044815"
        "321573786764986943900426058733725257337715070032077314544904538423296e+281"},
    {0x1.e13c425396dcfp+934, chars_format::scientific, 280,
        "2."
        "7298170376572543250595176058691059999798358983466020300175306241793194709984671670486033298460259585304738"
        "5017283331124297567037148310322911306994303912107766046694422982692238154811689038581436612976816696375957"
        "55239772226573822083165523805843885336942248086072157383512333221888e+281"},
    {0x1.68969e0aaf976p+935, chars_format::scientific, 280,
        "4."
        "0908887634365658052312311982281239969243017093157788635282062623784275846881594265651752794514038606902310"
        "6800674077822316855396294054170407702247910519199947866095197666860418768314483510897116866758790077807822"
        "28895035770669972426241339275644547073552005426085299679806831460352e+281"},
    {0x1.3b22da0fe1911p+936, chars_format::scientific, 281,
        "7."
        "1504633857438940571491623978721892914354286180332274833165835417359788838288174535897662032205925659473829"
        "1254467838197118759246342696315600723602737684766259628091374865649497230897798288966582459879507593177766"
        "553940950035435273202528651698676033968867504991057070045076471676928e+281"},
    {0x1.4e66e432f39f8p+937, chars_format::scientific, 282,
        "1."
        "5175210833272951397317171771093120533028700691071470081130010387044118657798964008191234121591053953108259"
        "6955862088695509774556450307706532410525408486178691764933071097832767619332513618102282556325062955506942"
        "7362782422201363564357317874795808595718985906746009234596759127195648e+282"},
    {0x1.cd42a1d8134ddp+938, chars_format::scientific, 282,
        "4."
        "1864125891654217678987160154326130560240863001735941095698054511092958063809530574780247432322632198663136"
        "5418302622171023894401032790833087273703184694721039596481868281280184720918524292021207074674806905103125"
        "4669662460887222261960281257747458512455969074216563763504450258337792e+282"},
    {0x1.5f2cf251a2c3cp+939, chars_format::scientific, 282,
        "6."
        "3745607194970414607011473297486321194408851855271826405209841375673158509178230157700838425649741315965153"
        "1787490773156272736941819746003947498415541918165918216258592523898070563734402123829915274799568966211125"
        "1632663075464418798824836792784408317689148157466121016089825903640576e+282"},
    {0x1.adc9e02b49a66p+940, chars_format::scientific, 283,
        "1."
        "5603097675062574896758887904284580014666588747292929902329386364783921519940435619097399070201464392502002"
        "5028890715059060477997149439060211939278134179325873422500374642911646757317084990080920453639258554845618"
        "13254903791863073045978225400887637841137225271718710407150443264212992e+283"},
    {0x1.3d3363cbf2d84p+941, chars_format::scientific, 283,
        "2."
        "3031389942941909352268527198234496379577068396336203317744876815161576479976171983520659455831024723099078"
        "3953912653441338360925646235294520011231816869933421886686303955035200196869516409069207975791230779110053"
        "11195074484622555449838749756095271033619639701182005144598929173643264e+283"},
    {0x1.d766f62bf7f84p+942, chars_format::scientific, 283,
        "6."
        "8455374301622028192436355472823846238656305230521706558129242344936800002020518868868064296400530352191789"
        "1034466226790547106518246010636997952128991451178947162684434339703836656537748396801799020313050219717687"
        "76346231778021269958063780588872346431583200394283187585456728088510464e+283"},
    {0x1.184991c55d18cp+943, chars_format::scientific, 283,
        "8."
        "1404701971339317344287383067486540221247016756955967093290383812811465088446107352280408680080482428195443"
        "2859846301022972599343792584032105393017442786371538959565030349794777528390097804778412027245663634510470"
        "78458089708094639868097495758509389693820290367400727907449779154583552e+283"},
    {0x1.e8b3dcebeba57p+944, chars_format::scientific, 284,
        "2."
        "8387070865957636043552264602157883541550621494567563701536179579776139163837320944226018566214448421682813"
        "9146714994229625209180111000906234680917576834864249534875261446994701128847388085608386018003065108691566"
        "848732851954616351985795075190456971406831718621827217641148650350444544e+284"},
    {0x1.967cd81cba730p+945, chars_format::scientific, 283,
        "4."
        "7222972051563224519350338009022716573803303881667812490788444725311840770556623092940989186835112772635211"
        "2743224783831438285150919074036999996137779134053001098115781992438186495543489249860281381207407832543648"
        "17662303876106820974135357911697797680185476906504157324030340042326016e+284"},
    {0x1.4cf2067674a05p+946, chars_format::scientific, 284,
        "7."
        "7358664988354629632820980491003531438355880596056791221819587355464733593010437851133428000986535843768202"
        "8813397315792428439760217722967556525317392550436423184707427411650596408077787470781836258444845657566221"
        "704456125209427655591152156570845479024339183607328000005037882486030336e+284"},
    {0x1.396e85b33c0bdp+947, chars_format::scientific, 285,
        "1."
        "4564946206181580844592084594207704222149275365767779002797711189323700501615565216897882479344696601965798"
        "7214001805314729196086011578252425814811977188275322843971098040849936431617543662738225046601518261128113"
        "2374308583508656325781250344038137418380156687680087240907535210346708992e+285"},
    {0x1.95206484ce576p+948, chars_format::scientific, 285,
        "3."
        "7651875364112937676079826373638285134656210548344094794627244719878759497617868910191518550757132648757165"
        "9033638473170496163259718929694674503055426759572449412069792075432533362901496572181167769653683164853916"
        "6571141383041739341196077037239708754641370459694088122009910159310061568e+285"},
    {0x1.22e9ba39c791ap+949, chars_format::scientific, 284,
        "5."
        "4074068333403965226750981237644983456668479689930940152267176801225028318769667357940376329074605916431061"
        "4179228438454115201658468909272669836435242142312208547792943910580280672735394813258979591343794568202162"
        "709802027713568619488866942294475102931728455399763827049938587391885312e+285"},
    {0x1.c10015e885bf5p+950, chars_format::scientific, 286,
        "1."
        "6691777225183442734155493695184638662590904633258100472470488533590977930515304351989064823049973327477126"
        "1895692018476435316799054399140695210497503507401916469005762783991428636380155890236982018335960721659795"
        "82528813031375076284990869886696245331704707225600453047248955585985511424e+286"},
    {0x1.7e47eb8f41b03p+951, chars_format::scientific, 285,
        "2."
        "8422910937483828159205881733190611988529916891665780536131260943457118685939406072581634351428299546320576"
        "0396749473544096221941676146479809429276884413946649887699651566840160395628585821920358023898327822565882"
        "8951550681268637687054413812030526818138559282485013293056231248488300544e+286"},
    {0x1.09d0d2a526197p+952, chars_format::scientific, 286,
        "3."
        "9527246153864665566951087294778578304623889883636970224893978854523038111797720316090827413947493083212896"
        "7844722249273717902614128985252239037734888348980268366864611317692974660014186053407372696445748574503415"
        "78296133621137927482641494123749218905855394522144524531019546018141175808e+286"},
    {0x1.329393888f7bep+953, chars_format::scientific, 286,
        "9."
        "1176878905953285118279701136005401786587902760102270865436829998885338329626092321640853120778010712669451"
        "0373698460188081841557295489700487987719867168096915145773718173158124223634025462177100914945077372091161"
        "00467436142545614804211132806327613747648211271222880398152942507767365632e+286"},
    {0x1.bbe7721540300p+954, chars_format::scientific, 287,
        "2."
        "6403715176860095022699449053141968576100424161884093294931549571262319776369831347356407500008594345868578"
        "3886670603935896834566016848681232358712602776606616349498486554151807746433631049948801957261905070980866"
        "218863512709255609194971921954793897583681193907186498977864992248177885184e+287"},
    {0x1.88cbea96e97dbp+955, chars_format::scientific, 287,
        "4."
        "6727608713307191811731595008960375298221325983796687233226799622196366586451734089583832057742414188524729"
        "9790823561171069651344832529105954322176333404979396460587010550966330585217753352905079690163268052230294"
        "873047744394947965285062467179754729677808277337626448692513961219618504704e+287"},
    {0x1.92de904946e55p+956, chars_format::scientific, 285,
        "9."
        "5851774967886283871424703550157422124862389173600706586104269250302149909771530581521764503566496817903367"
        "9520425155234935074360538133315694704204458222491239262475671332493078637032333046742899762907560886122978"
        "5621372421990248839692190711668885475704463446705424081679053506515828736e+287"},
    {0x1.7f42451f5dfadp+957, chars_format::scientific, 287,
        "1."
        "8237197308454679352521332889696823507212561832000261520249663849022474903193953062064507777750007282782305"
        "5844688987995889659167464398927070015579969304644214140035552340033653858384364990460291650066492163131472"
        "465999824312979406250066151215209790239504641334422284329371377930367664128e+288"},
    {0x1.5bcb0fe12ff45p+958, chars_format::scientific, 288,
        "3."
        "3099160671433535093084224672514360647394401123276052039350234673929255835025285679433814704400572813252037"
        "6316165403379745915463564399008817557713505803494239077292826673093202008184035941299826077797306915047648"
        "4721278024806918523029143876241835657869581941341018295520569998556732063744e+288"},
    {0x1.b90465a9c592cp+959, chars_format::scientific, 287,
        "8."
        "3942399746957991372869078281942404020217477793793748903487486836539875121518532182385048730991315535450129"
        "6066292673473655572134735382616456106780997318254265930532381881591026489637996542676756178814917207512248"
        "505680859658549636395147348969378726384175323964145648049041264030901075968e+288"},
    {0x1.69983d358fd5ep+960, chars_format::scientific, 289,
        "1."
        "3765053672754182859184546827995562817441803667851159142923805357904082337163005923613594490300620268879646"
        "4427657272680934322903126085125682986499564607354990434217242316960377563197108819664566707746439333948168"
        "39437145361195475585915790038086938448416859756069308137927266057545163210752e+289"},
    {0x1.de946c1935bebp+961, chars_format::scientific, 289,
        "3."
        "6436798293267568549903218347518137574726651717741644105751763536191250266712661451258775255635605998228834"
        "2012901246006434091445910044776272477500560046621628838893089250628068867605857325914011568299359415141634"
        "37151042307371112230166232390702102964620484295971653304142427375365317984256e+289"},
    {0x1.b5842f82a9de7p+962, chars_format::scientific, 289,
        "6."
        "6620847115568887370739473756442065065681196769911331682611092496715336718715155596977883617162878523841449"
        "1195244228805399554716468352898840685630426142198562600629075173101466368672042990656845441262776494523381"
        "27010045221858188132828582061277352981469985490408290156135533130942236327936e+289"},
    {0x1.e8b22ed3af96bp+963, chars_format::scientific, 290,
        "1."
        "4882800748283324399977058469272645928472632851629916206349194579268135708884744967243751899545815918258106"
        "3564764212811724201905328910445324121906120166169993601247788259189151502783772871311029419856354319292938"
        "359404923519710627910962261670847242925348963282404187971202996261023196905472e+290"},
    {0x1.29a2da729cdddp+964, chars_format::scientific, 290,
        "1."
        "8128485634074353186651032710851418799765830191648044920796289939797839866554628583160057708287641508147835"
        "3416991660757155282539462744077357077960029596847454004479999761152595114534845500036614198015631414265590"
        "188431157433539282197161887547513163560678186514777300223161756952567350296576e+290"},
    {0x1.276a30d060d86p+965, chars_format::scientific, 289,
        "3."
        "5986375764585901118401173857435431665393344228134043195993090267211557335482517408403998911271835938466563"
        "4578973486033515015557618769168149115430241202530067649619624893103124735795226961094794333422439468435787"
        "86100004426152086227134028234892112366944314773819711221653221244284711206912e+290"},
    {0x1.d01246917497dp+966, chars_format::scientific, 291,
        "1."
        "1306303530723757551379347540230283878801067046195789878544591357589053690252198317196318305608292471048042"
        "6573510425649333447216391174783435354024431883709870993191165042801828493609577800703214958208640517708896"
        "5595898416550699038646583977157339794314844188021211564490649717795032156602368e+291"},
    {0x1.980e6a27628afp+967, chars_format::scientific, 291,
        "1."
        "9883184243838976730410932296903215043773257347722139793282731020043769627897711427696892214094944056155874"
        "5773532880255610721204868508010113425199198024425077564874975290911000083831287880616319091923858196094459"
        "8491001794144386958052292241630342045252697101128134565354695877741983337283584e+291"},
    {0x1.437c0e85d91f7p+968, chars_format::scientific, 291,
        "3."
        "1524589717279720882715225845768415950174764083504840242130204263516013060098749586913055034958731403449344"
        "1208372093650396142197066540459113834187404379707141906158973632298825086025212231018442536491262443437671"
        "2560730512038580641775599869341924017562703624377521765695489143064395748737024e+291"},
    {0x1.1ceddebc11368p+969, chars_format::scientific, 289,
        "5."
        "5534486584838894985815395255332155554599222908321054704554473957783188087561644658289781622997765571377498"
        "0254860361303679922893002057120030214741484590883308892758826467544136194783289890892705217436463378669760"
        "85508090123985182923026778461906662147231685595323631215481030751756287475712e+291"},
    {0x1.f13408b3aaf95p+970, chars_format::scientific, 291,
        "1."
        "9381607498203373586175696557817944812659064403065108683262190633961372055872685840153949035085668045580572"
        "7271684831698888135449531590096565801574266515822704900761718432653313668573988087518548683433349503352718"
        "6285257259315270330716435545570478575822448445079861238076872636591806374477824e+292"},
    {0x1.af9922dbfa336p+971, chars_format::scientific, 292,
        "3."
        "3648478963002968698620423749283072504492485899019735249110361788561863970431143842896181333838683458814612"
        "4598595569278258609624938998649618367547993361532806816462567203005806179903282570174127495161186670335196"
        "17412877924128534588246437115544693678681843960583893836646823695670362570227712e+292"},
    {0x1.b6d988f35196fp+972, chars_format::scientific, 291,
        "6."
        "8427657249419059479161154927363270143292784372199950777274871522771499071305503708562954470769408862138873"
        "1474802374325885362173627703481269107443722893324474773474281616910266293515997961386896447706754207733557"
        "5352545540331475643945411254688238428244331792556297094231236390216163573891072e+292"},
    {0x1.90c721972c4a2p+973, chars_format::scientific, 293,
        "1."
        "2498259387089929987544604729229201047461183081001696695911791985667564169201445962180218662664297173257224"
        "0783416001704506170068124680312031816753145674679063100504319414514800555672293921190439313027282851410416"
        "527131226964653068028871701489323868875661390179301613620908627438519900539191296e+293"},
    {0x1.7fa5032ebc8e7p+974, chars_format::scientific, 293,
        "2."
        "3927916153858261394393006439111464375589591262939067880984703699387029997954416886187764975960375716663774"
        "7324929334133616973952797666607621630538557419287541059322652029872252214901040277415927729164527443341573"
        "258308076333446631106547639938187560726465677882789688970890598968747947810881536e+293"},
    {0x1.4ce903c008152p+975, chars_format::scientific, 293,
        "4."
        "1527226468994149805883120008216062805649376308762924758560595432241225459535095755829722726323538761681810"
        "0109244911505753906925022700052492277437591209390165152181173369747026248798037383291310666381029548454305"
        "977457986611411122735356736460608954225433970661515041585228932440487179403132928e+293"},
    {0x1.1033cfd825bfep+976, chars_format::scientific, 293,
        "6."
        "7909062839788017161866710428443273408843243572583256912137828809643937252536360566057575321962392476516410"
        "9295373824489237150025478824159009080880441253418086991920551877762452038557858218260332182171547242362745"
        "152998922247516579175346880356048429165046724254554702021353471037187691525439488e+293"},
    {0x1.0fcd0f994c6c3p+977, chars_format::scientific, 294,
        "1."
        "3561785760749323678669787265688365565689640949708619714054160129767110601805174279033805933291173229630234"
        "9694534389824422263920901953135120658800068583587102352433525536899095571443676695780068738425864348615998"
        "0898573992763548701523679724999841102526974236295406990913753746951524692055293952e+294"},
    {0x1.4ecd6004d6052p+978, chars_format::scientific, 293,
        "3."
        "3410590952598420317059089548905939025834628916093972522457623516814235244321423895949768406189130633668431"
        "7368760484815919204021605264468860090297189981381875925188997129387661959794324528266148926422168602715973"
        "167909073172803760343055337031341509508280546224566941805289330430780015789473792e+294"},
    {0x1.f3efb39a62b6fp+979, chars_format::scientific, 294,
        "9."
        "9779308814775026726545238938108225391742620151815475280043733999141726516502805101140500365178512807293103"
        "4832702879081724884796354724298523912059135271846012848441298235332887232423280512468585693898553460251806"
        "5129004909212362943512437101234020643757629011735714458250584381888822081044348928e+294"},
    {0x1.7b90e1f7acd5fp+980, chars_format::scientific, 294,
        "1."
        "5151060382509119303230072696616085397824006138244852698231578717068386499638092085604311976614167334172105"
        "9067485352359019807084574101981846207880933834777632827789527523390586536598629711121476163740733404587356"
        "2403590243000174027968021709791613049945818271254046076631622631725402432573800448e+295"},
    {0x1.780e24e541603p+981, chars_format::scientific, 295,
        "3."
        "0021849100893520243358225574670889620815156554449574573250051912654326113987284835353145201676673525718887"
        "5042697881806641218419106412453534354493043518552141426433358045973160321134894604670081881182357987680597"
        "51952649200503215287587191207086694028505970883124170608147640357927402985570172928e+295"},
    {0x1.700d3d3809014p+982, chars_format::scientific, 295,
        "5."
        "8765795963279930227848103637865601003943787056531376360036302905273752521105567528286745985028255384875457"
        "1490356367965241471404199068974466219719536013881180506072840356357417288376476202174117730455929024377704"
        "51522858269571663877746249378744932425279354599869012839882446798078904889967116288e+295"},
    {0x1.b688d558b5f6cp+983, chars_format::scientific, 296,
        "1."
        "4003917488295084275613719898286286543900946543796852786205748340103098176869027454271933921365124713506242"
        "4840043468664495636032046706208223098253951876889452581163756835639997767859551976134817039860523484461440"
        "124895585825179963559084955205686769325898379507940166327523415178499971301572083712e+296"},
    {0x1.f01912b454894p+984, chars_format::scientific, 296,
        "3."
        "1684232621942047385277264101507039556067440169362731047612881416017992423437710611846555322044158342722398"
        "8915277579013362002270444501078942736494131042992360048146233701817979552518486745549641868940508520247278"
        "182505289084695487280862714932759338066051522762627957622658669625057321641956081664e+296"},
    {0x1.1006d98e085bcp+985, chars_format::scientific, 296,
        "3."
        "4747005896842154056766241710224939253278957494279764707850526147334614495212661112229513392271233912156854"
        "4761851073506353853083647800598515099405732155724640228045952982796489208783132715430406627983166405192131"
        "258940257292542957476413248506076428650670534137201954640611227376407648222278844416e+296"},
    {0x1.2c3916e2ff373p+986, chars_format::scientific, 296,
        "7."
        "6697238550212685960832609911276146098915770657253390727731460462378114517962252738218713388984402744753410"
        "0644055244350474871367482438375619745138608308231095636232712461705478444271712793592166311581253206635330"
        "061153560207434566610596179623433497342212224379877437918600098792472693553791762432e+296"},
    {0x1.0a7487f857db1p+987, chars_format::scientific, 297,
        "1."
        "3614131925096533227358277304297327605620010964674273390519175146101981086716462390034963821779924748785739"
        "5620080532481805188047066315188930747903484713798353770585361867802872024778497522376969002439422146205889"
        "8780565314051488693571227506727823926105057168671455333801700670110926825836349751296e+297"},
    {0x1.3857c488fe8b8p+988, chars_format::scientific, 297,
        "3."
        "1917385509472622401741963902741798316020842891467372871639114279968501540720074385793183473550289230847540"
        "6531346952631945194501572201677681050736517236364445893621440519858256212122392536962698668571902046039673"
        "8617495507842843305566526087166039077960918279884459165757255575108034221542182223872e+297"},
    {0x1.b2e84c3dce473p+989, chars_format::scientific, 297,
        "8."
        "8883788439875624185164207745360558758802155875037125198532849056736078250163752904409270711399254253418185"
        "9444469734700030661866983137618978336282843998992322962605942456269502254865698961974528361768428078473937"
        "6094743421421524562002257540912448826271782010926639892392033944710549976982451388416e+297"},
    {0x1.71b76b7215201p+990, chars_format::scientific, 298,
        "1."
        "5112090835975456482691048470324136676461824411038137830875000839223319169242464768082370414035660254169158"
        "8669702780170871475227529225060662017601645192869668212722869526766762356560983217401072411526986055426607"
        "99442146505061129659657887076900042124590387275392937317008374397153245502302047961088e+298"},
    {0x1.21b184ed36242p+991, chars_format::scientific, 298,
        "2."
        "3682327923940455929074855404731835885200530396635967368041051592757206624858645698626710713225571745269233"
        "5729523644634975306222812534323302164949695407936710130084944345102224029476194227517181154705890457539653"
        "96355529469848408434057376579487220386627111660172302509770187382123275691926545760256e+298"},
    {0x1.37ea2520488ccp+992, chars_format::scientific, 298,
        "5."
        "0997804211457324301727969780021784932196577737124651974461574335281416292911140537078513800349516058166230"
        "6651023989265093968050976665439213325512154024914749918341591104687603878557877081517277860278457895962747"
        "15728449794070641109346128933556201664107191668445099152331696871514428213048815648768e+298"},
    {0x1.4664dbcd00eb0p+993, chars_format::scientific, 298,
        "1."
        "0673033377644725582076128279562256890020762752598912707261862612904605628388963403061314485035461507019337"
        "4438490926195154270158138687327359040657179392440930707711924166182794806470598924879805421312001727703958"
        "91921169134687535785461810688709659897643411981471381983104303837230721690128649027584e+299"},
    {0x1.6b9cbc489e09ap+994, chars_format::scientific, 299,
        "2."
        "3780130211770008635428798028054955143428405559792922085924082125222001207510564662620683226057796019174145"
        "2640417453863555219098122994555479241353169993047264294675297170597532090280617800437689617268886207229285"
        "482891877778657703920272278134074512640642342772726595535234502682602103798938923433984e+299"},
    {0x1.f513bbd25d6dep+995, chars_format::scientific, 299,
        "6."
        "5540577282820882734089899386704195345627846540047499645059907995983845109119849454543083195868777805712470"
        "7092461551987548003257290398700713345661594829621158366035617643372206998716563232961936757003882276959122"
        "708936001833829616557908400458109782703568488107962693518959628276723172599697604870144e+299"},
    {0x1.3e00e64a007e5p+996, chars_format::scientific, 299,
        "8."
        "3189331614742082391382447830313932954296861496924533518176874062021378195713696724616314709052435687480452"
        "3449453858407989081548890726447004714405286583963998060346441841261849601799117052047643487147092979557556"
        "891805175387244452772540164096096030738843539931931830599736589422869440330138761822208e+299"},
    {0x1.04358f2000393p+997, chars_format::scientific, 300,
        "1."
        "3614082701057758282991605516975489579288117474695742577033267689441829157997449528962630396276072567771846"
        "6563277978974992105381629734827673730338773434105077041481826605239116869440810337790164272971883723549343"
        "4622743766811503326558480996563151364510469225186261976905322157612487935439550111809536e+300"},
    {0x1.ff5ca45dac07fp+998, chars_format::scientific, 300,
        "5."
        "3508658110149902849421928428493905625870487322421898497682154406090765637213244572176099715326655431494367"
        "6929591673829631099980279628704586394230462593528555533852816968992662893077336730158326155001020626526239"
        "8738807874995959199986290114910339936114860975870138690918797206511003398780232983904256e+300"},
    {0x1.95dfb7963208bp+999, chars_format::scientific, 299,
        "8."
        "4940892966758526585494849182126227433166616658121716121221756680064677734611539033378080479693086528432595"
        "4264187555897655767726624817103774897165687722073995863869146194224654264271815412764432183860307112674231"
        "109279315205969947330246145602344386623802171762035716381797595664546003263242377363456e+300"},
    {0x1.042ea27af2ccfp+1000, chars_format::scientific, 301,
        "1."
        "0890134027784214313930348009402099228804786388308427577549589000490524838171536880083316594376503360923820"
        "3927956167113377874488765241234494902547691411017945498443986695825206736398283043101155534160891992194911"
        "53554556979108530787196381372092387340130982723560970359575450657479047437786029202866176e+301"},
    {0x1.19cacda6d507cp+1001, chars_format::scientific, 301,
        "2."
        "3589278771025920045285827982461236796817036300877185977488554279335842158782244191985990632926121503077907"
        "6520003666559211241592367336689930498536187798295766946194279734738125370727052729831736723306360154337779"
        "50412177760641174727204088780046261172088405036986621286405986734378144157024874903109632e+301"},
    {0x1.e4dc48c30aebdp+1002, chars_format::scientific, 301,
        "8."
        "1176903631052648655337080884157138757428798522929058319900963020890052053982712181300446346333787829121700"
        "3535527368462203251795552837011494935291596633256317483032620863293740739496732466044546947952666250308674"
        "72373502272570181905030453820398128968285453872513665526905113335684193781314404248190976e+301"},
    {0x1.16fa9da90f9d8p+1003, chars_format::scientific, 301,
        "9."
        "3415114267945876208367248131098341912085530505203943017270044503863132197893962771450745275333290347854810"
        "9960600140509742566153709652479468336022888542206366778998821244811822003682844389359377244112197477553800"
        "16760116417262780962600310403215068957481809727018548258602677622354836648271052026150912e+301"},
    {0x1.8a86318c46281p+1004, chars_format::scientific, 302,
        "2."
        "6421004320193599222220643359148420883281556097189074913758318124048616315511138834598140417187849490396791"
        "2440800658786078681336731143970379155380439690121456355674188789241410064996533294508126717933561959185778"
        "192754757376080092862115085847862393689963492786526884623762776875632820851286300067627008e+302"},
    {0x1.ff462fd806bd7p+1005, chars_format::scientific, 302,
        "6."
        "8479333893788643349951954373428706271337676580677545656111124234548678899530140198122640316703808141324695"
        "4111790004996031828015000205150715078148983240637243871500082888421342977620123039374551681737977878655788"
        "295179567168650606205377274978890097754212420262333936960341237630114805596678852383342592e+302"},
    {0x1.9abb3e1c6258dp+1006, chars_format::scientific, 303,
        "1."
        "1002556200184007023081438741792890947080762576000821563629014332834749679952244487757753483300298253507845"
        "5879206419534204227221954043005542510983229083842379647414279802190829035747238306982534802408454663553709"
        "1282385282353501007663737911321641626869306594390707034645320031413007213532753781288075264e+303"},
    {0x1.de0bd3c1f52abp+1007, chars_format::scientific, 303,
        "2."
        "5611530892094994514501088831871358384319448903452892325625676707904740327849930775175514338249741969657883"
        "8592308971003886423987684696984845619865591327523895036972469545643509680781096997879244741733146429164959"
        "3820790500115221658520513179659203340914713114632244088248136782610390183342216645609259008e+303"},
    {0x1.d9c1bbc9b76a1p+1008, chars_format::scientific, 303,
        "5."
        "0763445855374758137611513292718315449629948838655962307071284681337573494863787181114031880088015506956421"
        "0919814812869947242304860161660008686121237187656925137779489232921913748608997417433611598970782898218677"
        "0681263550628277966122021347502889218558140981978778760709565257654468755221733041969823744e+303"},
    {0x1.838389973dca2p+1009, chars_format::scientific, 303,
        "8."
        "3044878325009487636657872605880027931451341062254646176493301760411427870881245765778811788634335139822887"
        "7791768181558515981788246801785667173521110223595293418389986293158864840334067858751178794788759593463864"
        "3446637560952598376682571125723765484978607914917947356221830413431528356893552064082214912e+303"},
    {0x1.060853e168c00p+1010, chars_format::scientific, 304,
        "1."
        "1230804446665463017778789639347990996643965714634023343815009161240780246270947713147897725931947017335623"
        "7630191092159383150643994991146787024266771551963955625126256769736294908917256990486304395382712939541329"
        "44471985636790260821195763195960709126795406948190820263635402442656971341237103098326941696e+304"},
    {0x1.f308c45ea73d7p+1011, chars_format::scientific, 304,
        "4."
        "2777559220816042653857310038704146366752118155285251665154411932831735245152145261165776711742388354156016"
        "9871993219430699069531917092009858059914736544226777968630260462041311221406320891386198960782539433597799"
        "67819804460846041770466218522657499957662378458077745646242495542457900501384540282123452416e+304"},
    {0x1.6e7f0598d9a7ap+1012, chars_format::scientific, 304,
        "6."
        "2832609674393123217939414786004721368347810148169532603823847060388742916702683157570030369865385378061695"
        "0423422570163256408545609818970072287306016643092924903391807737646611595942820189227413388395855318648545"
        "96993614806461429966237140466546002145002610631737886461529165004165330118612673778600116224e+304"},
    {0x1.90ee34c61a4e4p+1013, chars_format::scientific, 305,
        "1."
        "3747215164191864557360328902417183080909502773980053305016024875594667249734748345961089521445251491076760"
        "1613710309461048505454382577543819736591536450997080647994948699299372710947086154466989750285286987223010"
        "010358709717485396216234719231061846048602963736424188145247774330747094015196695990582116352e+305"},
    {0x1.e2a0a3d09f949p+1014, chars_format::scientific, 305,
        "3."
        "3096929273918683614869679916049042345119516535338947195012264325212922683474532459406639062854253866258135"
        "7719151111687362183898117765879272408632912053460554027589018196032181403643752217046446854545876459118270"
        "311328170300273241053563917737426045554632200608705001740820709150305846610578306477689143296e+305"},
    {0x1.c1f1e31fb56a1p+1015, chars_format::scientific, 305,
        "6."
        "1711334781978492823905176274313064600948013598950259705624044810976578137635336099364396791518714662842370"
        "9280516241948225398658063408258944026475600604367395551060529895388440736389998513454247897588963927412199"
        "886596463797584431228714343905526280539044788020033342657437500226579170692177128139530436608e+305"},
    {0x1.c021a05af3889p+1016, chars_format::scientific, 306,
        "1."
        "2292521010494213202208392120910347371974932861996362652215354683626354286778450977056457988823406607851862"
        "6637132565769582888977482809648230361989943269158655634268614343814815368836427061857244021348551127969781"
        "1055580445126773330393578734970725834547100511308555559785816417647601996123490828625750523904e+306"},
    {0x1.a0ba4fb02d02bp+1017, chars_format::scientific, 305,
        "2."
        "2862202954633178261723536509649685641707279850300290869803982420258862461647313576454922281065116456219182"
        "9590977426811173756270658087196535714508685519454569812805651039956703238427854607968636622055258647292634"
        "684121390540222150085347564627967335399432454801846311963425999483985877313898405284846501888e+306"},
    {0x1.3f966b0ddcfd7p+1018, chars_format::scientific, 306,
        "3."
        "5065941308845354984753464542431391007674227604335612148522065748017825104538844307057550895580408416179424"
        "7118416307944385786855208364451666760483209546178608196510513690039018180918045791524606584522427293544334"
        "6243739881419482228334516326372503115386643937845878401903583322133727281304761523559911653376e+306"},
    {0x1.f28cb9c6710a9p+1019, chars_format::scientific, 307,
        "1."
        "0940422247589227743316285257523446771149121608626559253104638931006152289125664762418837487890517285868544"
        "1970842686935351143015218862511720392429343778632449186329279729720913087020406559756094832031600186601946"
        "42090669215782471906632775672148557149263319590356475272060941885997193903260433671483161575424e+307"},
    {0x1.c941430ebe2afp+1020, chars_format::scientific, 306,
        "2."
        "0068458193014485659233690965046541577150222922448876802079698749594927659484925364079051863693079922549962"
        "3702340752679075101040300153750541846589137823389048924711303393882024589282733583930812172225616249563429"
        "7868168967936674133963531031634950024920744675243356304584274649234115658663895314346773839872e+307"},
    {0x1.3e04900b4e89ep+1021, chars_format::scientific, 307,
        "2."
        "7914963723745636433327098668092909811147302243780506069948228182283265947810001627803239111045172778906393"
        "0987072447572980908861942482392189431390905934840154072184967491283583766051866632563025027572585713651756"
        "30215388510334525743239925811352693280111872637884811742138711874263709333351600610928924557312e+307"},
    {0x1.5cd1470a36d2ep+1022, chars_format::scientific, 307,
        "6."
        "1236992921041949817714041891928528839786938336942322084137095186042961819813936048028926723548660468971278"
        "4969654586939917432251493887838173965737887781285740992515883352944011799461643423393002121460091055587179"
        "85452576260185887979241983673503558946414035103004649802078842226017422195444929429676453003264e+307"},
    {0x1.e4ed787bb244bp+1023, chars_format::scientific, 308,
        "1."
        "7026387749989901049352803345551957967504365590849171315485933257848664869760810216798351071186594668551262"
        "9849272947937037080011581203332426168619415862460756069100292337181478478510557557506918137532825769631310"
        "693972479511748662180221113394836543075210717029725044946195117678217681054268005181200990732288e+308"},
};

#endif // DOUBLE_SCIENTIFIC_PRECISION_TO_CHARS_TEST_CASES_3_HPP
