; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=instcombine < %s | FileCheck %s
target triple = "aarch64-unknown-linux-gnu"

define <vscale x 16 x i8> @test_ld1(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 16 x i8> @test_ld1(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 16 x i8> zeroinitializer
;
entry:
  %res = call <vscale x 16 x i8> @llvm.aarch64.sve.ld1.nxv16i8(<vscale x 16 x i1> zeroinitializer, ptr %a)
  ret <vscale x 16 x i8> %res
}

define <vscale x 4 x i32> @test_ld1_gather(ptr %a, <vscale x 4 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ld1_gather(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 4 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ld1.gather.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %a, <vscale x 4 x i64> %b)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_ld1_gather_index(ptr %a, <vscale x 2 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 2 x i64> @test_ld1_gather_index(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 2 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 2 x i64> zeroinitializer
;
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.ld1.gather.index.nxv2i64(<vscale x 2 x i1> zeroinitializer, ptr %a, <vscale x 2 x i64> %b)
  ret <vscale x 2 x i64> %0
}

define <vscale x 4 x i32> @test_ld1_gather_scalar_offset(<vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ld1_gather_scalar_offset(
; CHECK-SAME: <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ld1.gather.scalar.offset.nxv4i32.nxv4i32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %a, i64 0)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ld1_gather_sxtw(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ld1_gather_sxtw(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ld1.gather.sxtw.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ld1_gather_sxtw_index(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ld1_gather_sxtw_index(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ld1.gather.sxtw.index.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ld1_gather_uxtw(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ld1_gather_uxtw(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ld1.gather.uxtw.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ld1_gather_uxtw_index(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ld1_gather_uxtw_index(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ld1.gather.uxtw.index.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}


define <vscale x 2 x i64> @test_ld1q_gather_index(ptr %a, <vscale x 2 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 2 x i64> @test_ld1q_gather_index(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 2 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 2 x i64> zeroinitializer
;
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.ld1q.gather.index.nxv2i64(<vscale x 1 x i1> zeroinitializer, ptr %a, <vscale x 2 x i64> %b)
  ret <vscale x 2 x i64> %0
}

define <vscale x 8 x i16> @test_ld1q_gather_scalar_offset(<vscale x 2 x i64> %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ld1q_gather_scalar_offset(
; CHECK-SAME: <vscale x 2 x i64> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.ld1q.gather.scalar.offset.nxv8i16.nxv2i64(<vscale x 1 x i1> zeroinitializer, <vscale x 2 x i64> %a, i64 0)
  ret <vscale x 8 x i16> %0
}

define <vscale x 16 x i8> @test_ld1q_gather_vector_offset(ptr %a, <vscale x 2 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 16 x i8> @test_ld1q_gather_vector_offset(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 2 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 16 x i8> zeroinitializer
;
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.ld1q.gather.vector.offset.nxv16i8(<vscale x 1 x i1> zeroinitializer, ptr %a, <vscale x 2 x i64> %b)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_ld1ro(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 16 x i8> @test_ld1ro(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 16 x i8> zeroinitializer
;
entry:
  %res = call <vscale x 16 x i8> @llvm.aarch64.sve.ld1ro.nxv16i8(<vscale x 16 x i1> zeroinitializer, ptr %a)
  ret <vscale x 16 x i8> %res
}

define <vscale x 16 x i8> @test_ld1rq(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 16 x i8> @test_ld1rq(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 16 x i8> zeroinitializer
;
entry:
  %res = call <vscale x 16 x i8> @llvm.aarch64.sve.ld1rq.nxv16i8(<vscale x 16 x i1> zeroinitializer, ptr %a)
  ret <vscale x 16 x i8> %res
}

define <vscale x 2 x i64> @test_ld1udq(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 2 x i64> @test_ld1udq(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 2 x i64> zeroinitializer
;
entry:
  %res = call <vscale x 2 x i64> @llvm.aarch64.sve.ld1udq.nxv2i64(<vscale x 1 x i1> zeroinitializer, ptr %a)
  ret <vscale x 2 x i64> %res
}

define <vscale x 4 x i32> @test_ld1uwq(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ld1uwq(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %res = call <vscale x 4 x i32> @llvm.aarch64.sve.ld1uwq.nxv4i32(<vscale x 1 x i1> zeroinitializer, ptr %a)
  ret <vscale x 4 x i32> %res
}

define <vscale x 8 x i16> @test_ld2_sret(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ld2_sret(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld2.sret.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  %1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %0, 0
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_ld2q_sret(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ld2q_sret(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld2q.sret.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  %1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %0, 0
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_ld3(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ld3(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld3.sret.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  %1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %0, 0
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_ld3q(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ld3q(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld3q.sret.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  %1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %0, 0
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_ld4(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ld4(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld4.sret.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  %1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %0, 0
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_ld4q(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ld4q(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.aarch64.sve.ld4q.sret.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  %1 = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16> } %0, 0
  ret <vscale x 8 x i16> %1
}

define <vscale x 8 x i16> @test_ldff1(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ldff1(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.ldff1.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_ldff1_gather(ptr %a, <vscale x 4 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldff1_gather(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 4 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldff1.gather.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %a, <vscale x 4 x i64> %b)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_ldff1_gather_index(ptr %a, <vscale x 2 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 2 x i64> @test_ldff1_gather_index(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 2 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 2 x i64> zeroinitializer
;
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.ldff1.gather.index.nxv2i64(<vscale x 2 x i1> zeroinitializer, ptr %a, <vscale x 2 x i64> %b)
  ret <vscale x 2 x i64> %0
}

define <vscale x 4 x i32> @test_ldff1_gather_scalar_offset(<vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldff1_gather_scalar_offset(
; CHECK-SAME: <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldff1.gather.scalar.offset.nxv4i32.nxv4i32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %a, i64 0)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ldff1_gather_sxtw(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldff1_gather_sxtw(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldff1.gather.sxtw.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ldff1_gather_sxtw_index(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldff1_gather_sxtw_index(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldff1.gather.sxtw.index.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ldff1_gather_uxtw(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldff1_gather_uxtw(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldff1.gather.uxtw.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ldff1_gather_uxtw_index(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldff1_gather_uxtw_index(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldff1.gather.uxtw.index.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}

define <vscale x 16 x i8> @test_ldnf1(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 16 x i8> @test_ldnf1(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 16 x i8> zeroinitializer
;
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.ldnf1.nxv16i8(<vscale x 16 x i1> zeroinitializer, ptr %a)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_ldnt1(ptr %a)  #0 {
; CHECK-LABEL: define <vscale x 8 x i16> @test_ldnt1(
; CHECK-SAME: ptr [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 8 x i16> zeroinitializer
;
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.ldnt1.nxv8i16(<vscale x 8 x i1> zeroinitializer, ptr %a)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_ldnt1_gather(ptr %a, <vscale x 4 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldnt1_gather(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 4 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldnt1.gather.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %a, <vscale x 4 x i64> %b)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_ldnt1_gather_index(ptr %a, <vscale x 2 x i64> %b)  #0 {
; CHECK-LABEL: define <vscale x 2 x i64> @test_ldnt1_gather_index(
; CHECK-SAME: ptr [[A:%.*]], <vscale x 2 x i64> [[B:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 2 x i64> zeroinitializer
;
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.ldnt1.gather.index.nxv2i64(<vscale x 2 x i1> zeroinitializer, ptr %a, <vscale x 2 x i64> %b)
  ret <vscale x 2 x i64> %0
}

define <vscale x 4 x i32> @test_ldnt1_gather_scalar_offset(<vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldnt1_gather_scalar_offset(
; CHECK-SAME: <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldnt1.gather.scalar.offset.nxv4i32.nxv4i32(<vscale x 4 x i1> zeroinitializer, <vscale x 4 x i32> %a, i64 0)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_ldnt1_gather_uxtw(ptr %b, <vscale x 4 x i32> %a)  #0 {
; CHECK-LABEL: define <vscale x 4 x i32> @test_ldnt1_gather_uxtw(
; CHECK-SAME: ptr [[B:%.*]], <vscale x 4 x i32> [[A:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    ret <vscale x 4 x i32> zeroinitializer
;
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ldnt1.gather.uxtw.nxv4i32(<vscale x 4 x i1> zeroinitializer, ptr %b, <vscale x 4 x i32> %a)
  ret <vscale x 4 x i32> %0
}
