; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;
; RUN: opt < %s -mtriple=avr-freebsd -passes=instcombine -S | FileCheck %s --check-prefix=AVR
; RUN: opt < %s -mtriple=msp430-linux -passes=instcombine -S | FileCheck %s --check-prefix=MSP430
; REQUIRES: avr-registered-target,msp430-registered-target
;
; Verify that the puts to putchar transformation works correctly even for
; targets with 16-bit int.

declare i16 @putchar(i16)
declare i16 @puts(ptr)

@s1 = constant [2 x i8] c"\01\00"
@s7f = constant [2 x i8] c"\7f\00"
@s80 = constant [2 x i8] c"\80\00"
@sff = constant [2 x i8] c"\ff\00"

@pcnt_c = constant [3 x i8] c"%c\00"
@pcnt_s = constant [3 x i8] c"%s\00"

declare i16 @printf(ptr, ...)

; Verfify that the three printf to putchar transformations all result
; in the same output for calls with equivalent arguments.

define void @xform_printf(i8 %c8, i16 %c16) {
; AVR-LABEL: @xform_printf(
; AVR-NEXT:    [[PUTCHAR:%.*]] = call addrspace(1) i16 @putchar(i16 1)
; AVR-NEXT:    [[PUTCHAR1:%.*]] = call addrspace(1) i16 @putchar(i16 1)
; AVR-NEXT:    [[PUTCHAR2:%.*]] = call addrspace(1) i16 @putchar(i16 1)
; AVR-NEXT:    [[PUTCHAR3:%.*]] = call addrspace(1) i16 @putchar(i16 127)
; AVR-NEXT:    [[PUTCHAR4:%.*]] = call addrspace(1) i16 @putchar(i16 127)
; AVR-NEXT:    [[PUTCHAR5:%.*]] = call addrspace(1) i16 @putchar(i16 127)
; AVR-NEXT:    [[PUTCHAR6:%.*]] = call addrspace(1) i16 @putchar(i16 128)
; AVR-NEXT:    [[PUTCHAR7:%.*]] = call addrspace(1) i16 @putchar(i16 128)
; AVR-NEXT:    [[PUTCHAR8:%.*]] = call addrspace(1) i16 @putchar(i16 128)
; AVR-NEXT:    [[PUTCHAR9:%.*]] = call addrspace(1) i16 @putchar(i16 255)
; AVR-NEXT:    [[PUTCHAR10:%.*]] = call addrspace(1) i16 @putchar(i16 255)
; AVR-NEXT:    [[PUTCHAR11:%.*]] = call addrspace(1) i16 @putchar(i16 255)
; AVR-NEXT:    [[TMP1:%.*]] = zext i8 [[C8:%.*]] to i16
; AVR-NEXT:    [[PUTCHAR12:%.*]] = call addrspace(1) i16 @putchar(i16 [[TMP1]])
; AVR-NEXT:    [[PUTCHAR13:%.*]] = call addrspace(1) i16 @putchar(i16 [[C16:%.*]])
; AVR-NEXT:    ret void
;
; MSP430-LABEL: @xform_printf(
; MSP430-NEXT:    [[PUTCHAR:%.*]] = call i16 @putchar(i16 1)
; MSP430-NEXT:    [[PUTCHAR1:%.*]] = call i16 @putchar(i16 1)
; MSP430-NEXT:    [[PUTCHAR2:%.*]] = call i16 @putchar(i16 1)
; MSP430-NEXT:    [[PUTCHAR3:%.*]] = call i16 @putchar(i16 127)
; MSP430-NEXT:    [[PUTCHAR4:%.*]] = call i16 @putchar(i16 127)
; MSP430-NEXT:    [[PUTCHAR5:%.*]] = call i16 @putchar(i16 127)
; MSP430-NEXT:    [[PUTCHAR6:%.*]] = call i16 @putchar(i16 128)
; MSP430-NEXT:    [[PUTCHAR7:%.*]] = call i16 @putchar(i16 128)
; MSP430-NEXT:    [[PUTCHAR8:%.*]] = call i16 @putchar(i16 128)
; MSP430-NEXT:    [[PUTCHAR9:%.*]] = call i16 @putchar(i16 255)
; MSP430-NEXT:    [[PUTCHAR10:%.*]] = call i16 @putchar(i16 255)
; MSP430-NEXT:    [[PUTCHAR11:%.*]] = call i16 @putchar(i16 255)
; MSP430-NEXT:    [[TMP1:%.*]] = zext i8 [[C8:%.*]] to i16
; MSP430-NEXT:    [[PUTCHAR12:%.*]] = call i16 @putchar(i16 [[TMP1]])
; MSP430-NEXT:    [[PUTCHAR13:%.*]] = call i16 @putchar(i16 [[C16:%.*]])
; MSP430-NEXT:    ret void
;
  call i16 (ptr, ...) @printf(ptr @s1)
  call i16 (ptr, ...) @printf(ptr @pcnt_c, i16 1)
  call i16 (ptr, ...) @printf(ptr @pcnt_s, ptr @s1)

  call i16 (ptr, ...) @printf(ptr @s7f)
  call i16 (ptr, ...) @printf(ptr @pcnt_c, i16 127)
  call i16 (ptr, ...) @printf(ptr @pcnt_s, ptr @s7f)

  call i16 (ptr, ...) @printf(ptr @s80)
  call i16 (ptr, ...) @printf(ptr @pcnt_c, i16 128)
  call i16 (ptr, ...) @printf(ptr @pcnt_s, ptr @s80)

  call i16 (ptr, ...) @printf(ptr @sff)
  call i16 (ptr, ...) @printf(ptr @pcnt_c, i16 255)
  call i16 (ptr, ...) @printf(ptr @pcnt_s, ptr @sff)

; The i8 argument to printf can be either zero-extended or sign-extended
; when passed to putchar which then converts it to unsigned char.
  call i16 (ptr, ...) @printf(ptr @pcnt_c, i8 %c8)
  call i16 (ptr, ...) @printf(ptr @pcnt_c, i16 %c16)
  ret void
}
