; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes=instcombine -S %s | FileCheck %s

define i1 @umulov_square_i32(i32 %x) {
; CHECK-LABEL: define i1 @umulov_square_i32(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[RES:%.*]] = icmp ugt i32 [[X]], 65535
; CHECK-NEXT:    ret i1 [[RES]]
;
  %ret = call {i32, i1} @llvm.umul.with.overflow.i32(i32 %x, i32 %x)
  %res = extractvalue {i32, i1} %ret, 1
  ret i1 %res
}

define i1 @umulov_square_i16(i16 %x) {
; CHECK-LABEL: define i1 @umulov_square_i16(
; CHECK-SAME: i16 [[X:%.*]]) {
; CHECK-NEXT:    [[RES:%.*]] = icmp ugt i16 [[X]], 255
; CHECK-NEXT:    ret i1 [[RES]]
;
  %ret = call {i16, i1} @llvm.umul.with.overflow.i16(i16 %x, i16 %x)
  %res = extractvalue {i16, i1} %ret, 1
  ret i1 %res
}

; Negative tests

define i1 @umulov_square_i13(i13 %x) {
; CHECK-LABEL: define i1 @umulov_square_i13(
; CHECK-SAME: i13 [[X:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call { i13, i1 } @llvm.umul.with.overflow.i13(i13 [[X]], i13 [[X]])
; CHECK-NEXT:    [[RES:%.*]] = extractvalue { i13, i1 } [[RET]], 1
; CHECK-NEXT:    ret i1 [[RES]]
;
  %ret = call {i13, i1} @llvm.umul.with.overflow.i13(i13 %x, i13 %x)
  %res = extractvalue {i13, i1} %ret, 1
  ret i1 %res
}

define i1 @umulov_square_i32_multiuse(i32 %x) {
; CHECK-LABEL: define i1 @umulov_square_i32_multiuse(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X]], i32 [[X]])
; CHECK-NEXT:    [[RES:%.*]] = extractvalue { i32, i1 } [[RET]], 1
; CHECK-NEXT:    [[VAL:%.*]] = extractvalue { i32, i1 } [[RET]], 0
; CHECK-NEXT:    call void @use(i32 [[VAL]])
; CHECK-NEXT:    ret i1 [[RES]]
;
  %ret = call {i32, i1} @llvm.umul.with.overflow.i32(i32 %x, i32 %x)
  %res = extractvalue {i32, i1} %ret, 1
  %val = extractvalue {i32, i1} %ret, 0
  call void @use(i32 %val)
  ret i1 %res
}

define i1 @smulov_square_i32(i32 %x) {
; CHECK-LABEL: define i1 @smulov_square_i32(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:    [[RET:%.*]] = call { i32, i1 } @llvm.smul.with.overflow.i32(i32 [[X]], i32 [[X]])
; CHECK-NEXT:    [[RES:%.*]] = extractvalue { i32, i1 } [[RET]], 1
; CHECK-NEXT:    ret i1 [[RES]]
;
  %ret = call {i32, i1} @llvm.smul.with.overflow.i32(i32 %x, i32 %x)
  %res = extractvalue {i32, i1} %ret, 1
  ret i1 %res
}

declare {i32, i1} @llvm.umul.with.overflow.i32(i32, i32)
declare {i32, i1} @llvm.smul.with.overflow.i32(i32, i32)
declare {i16, i1} @llvm.umul.with.overflow.i16(i16, i16)
declare {i13, i1} @llvm.umul.with.overflow.i13(i13, i13)
declare void @use(i32)
