; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

; --------------------------------------------------------------------
; llvm.amdgcn.wave.reduce.umin.i32
; --------------------------------------------------------------------

declare i32 @llvm.amdgcn.wave.reduce.umin.i32(i32, i32 immarg)

define amdgpu_kernel void @test_constant_fold_wave_reduce_umin_poison(ptr addrspace(1) %out, i32 %in) {
; CHECK-LABEL: @test_constant_fold_wave_reduce_umin_poison(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 poison, ptr addrspace(1) [[OUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.umin.i32(i32 poison, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_constant_fold_wave_reduce_umin_const(ptr addrspace(1) %out) {
; CHECK-LABEL: @test_constant_fold_wave_reduce_umin_const(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 123, ptr addrspace(1) [[OUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.umin.i32(i32 123, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

; --------------------------------------------------------------------
; llvm.amdgcn.wave.reduce.umin.i32
; --------------------------------------------------------------------

declare i32 @llvm.amdgcn.wave.reduce.umax.i32(i32, i32 immarg)

define amdgpu_kernel void @test_constant_fold_wave_reduce_umax_poison(ptr addrspace(1) %out, i32 %in) {
; CHECK-LABEL: @test_constant_fold_wave_reduce_umax_poison(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 poison, ptr addrspace(1) [[OUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.umax.i32(i32 poison, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @test_constant_fold_wave_reduce_umax_const(ptr addrspace(1) %out) {
; CHECK-LABEL: @test_constant_fold_wave_reduce_umax_const(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 123, ptr addrspace(1) [[OUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.umax.i32(i32 123, i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}

@gv = constant i32 0
define amdgpu_kernel void @test_constant_fold_wave_reduce_umax_gv(ptr addrspace(1) %out) {
; CHECK-LABEL: @test_constant_fold_wave_reduce_umax_gv(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RESULT:%.*]] = call i32 @llvm.amdgcn.wave.reduce.umax.i32(i32 ptrtoint (ptr @gv to i32), i32 1)
; CHECK-NEXT:    store i32 [[RESULT]], ptr addrspace(1) [[OUT:%.*]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %result = call i32 @llvm.amdgcn.wave.reduce.umax.i32(i32 ptrtoint (ptr @gv to i32), i32 1)
  store i32 %result, ptr addrspace(1) %out
  ret void
}
