; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define i64 @test0(i64 %x) {
; CHECK-LABEL: @test0(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[A:%.*]] = icmp eq i64 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[A]], label [[EXIT:%.*]], label [[NON_ZERO:%.*]]
; CHECK:       non_zero:
; CHECK-NEXT:    br i1 false, label [[UNREACHABLE:%.*]], label [[EXIT]]
; CHECK:       unreachable:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[C:%.*]] = phi i64 [ 0, [[START:%.*]] ], [ 1, [[NON_ZERO]] ], [ 2, [[UNREACHABLE]] ]
; CHECK-NEXT:    ret i64 [[C]]
;
start:
  %a = icmp eq i64 %x, 0
  br i1 %a, label %exit, label %non_zero

non_zero:
  %b = icmp eq i64 %x, 0
  br i1 %b, label %unreachable, label %exit

unreachable:
  br label %exit

exit:
  %c = phi i64 [ 0, %start ], [ 1, %non_zero ], [ 2, %unreachable ]
  ret i64 %c
}

define i64 @test1(i64 %x) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[A:%.*]] = icmp eq i64 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[A]], label [[EXIT:%.*]], label [[NON_ZERO:%.*]]
; CHECK:       non_zero:
; CHECK-NEXT:    br i1 true, label [[EXIT]], label [[UNREACHABLE:%.*]]
; CHECK:       unreachable:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[C:%.*]] = phi i64 [ 0, [[START:%.*]] ], [ [[X]], [[NON_ZERO]] ], [ 0, [[UNREACHABLE]] ]
; CHECK-NEXT:    ret i64 [[C]]
;
start:
  %a = icmp eq i64 %x, 0
  br i1 %a, label %exit, label %non_zero

non_zero:
  %b = icmp ugt i64 %x, 0
  br i1 %b, label %exit, label %unreachable

unreachable:
  br label %exit

exit:
  %c = phi i64 [ 0, %start ], [ %x, %non_zero ], [ 0, %unreachable ]
  ret i64 %c
}

define i1 @test2(i64 %x, i1 %y) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  start:
; CHECK-NEXT:    [[A:%.*]] = icmp eq i64 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[A]], label [[EXIT:%.*]], label [[NON_ZERO:%.*]]
; CHECK:       non_zero:
; CHECK-NEXT:    br i1 [[Y:%.*]], label [[ONE:%.*]], label [[TWO:%.*]]
; CHECK:       one:
; CHECK-NEXT:    br label [[MAINBLOCK:%.*]]
; CHECK:       two:
; CHECK-NEXT:    br label [[MAINBLOCK]]
; CHECK:       mainblock:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[RES:%.*]] = phi i1 [ false, [[MAINBLOCK]] ], [ true, [[START:%.*]] ]
; CHECK-NEXT:    ret i1 [[RES]]
;
start:
  %a = icmp eq i64 %x, 0
  br i1 %a, label %exit, label %non_zero

non_zero:
  br i1 %y, label %one, label %two

one:
  br label %mainblock

two:
  br label %mainblock

mainblock:
  %p = phi i64 [ %x, %one ], [ 42, %two ]
  %cmp = icmp eq i64 %p, 0
  br label %exit

exit:
  %res = phi i1 [ %cmp, %mainblock ], [ 1, %start ]
  ret i1 %res
}


; The code below exposed a bug similar to the one exposed by D60846, see the commit 6ea477590085.
; In a nutshell, we should not replace %result.0 with 0 here.

define zeroext i8 @update_phi_query_loc_in_recursive_call(ptr nocapture readonly %p){
; CHECK-LABEL: @update_phi_query_loc_in_recursive_call(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[RESULT_0:%.*]] = phi i8 [ 0, [[ENTRY:%.*]] ], [ [[CONV2:%.*]], [[FOR_BODY:%.*]] ]
; CHECK-NEXT:    [[SHIFT_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ 1, [[FOR_BODY]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[SHIFT_0]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_COND_CLEANUP:%.*]]
; CHECK:       for.cond.cleanup:
; CHECK-NEXT:    ret i8 [[RESULT_0]]
; CHECK:       for.body:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[P:%.*]], align 1
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TMP0]] to i32
; CHECK-NEXT:    [[MUL:%.*]] = shl nuw nsw i32 [[SHIFT_0]], 3
; CHECK-NEXT:    [[SHL:%.*]] = shl nuw nsw i32 [[CONV]], [[MUL]]
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[SHL]] to i8
; CHECK-NEXT:    [[CONV2]] = or i8 [[RESULT_0]], [[TMP1]]
; CHECK-NEXT:    br label [[FOR_COND]]
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.body, %entry
  %result.0 = phi i8 [ 0, %entry ], [ %conv2, %for.body ]
  %shift.0 = phi i32 [ 0, %entry ], [ 1, %for.body ]
  %cmp = icmp eq i32 %shift.0, 0
  br i1 %cmp, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  ret i8 %result.0

for.body:                                         ; preds = %for.cond
  %0 = load i8, ptr %p, align 1
  %conv = zext i8 %0 to i32
  %mul = shl nuw nsw i32 %shift.0, 3
  %shl = shl nuw nsw i32 %conv, %mul
  %1 = trunc i32 %shl to i8
  %conv2 = or i8 %result.0, %1
  %inc = add nuw nsw i32 %shift.0, 1
  br label %for.cond
}

define i1 @freeze_nonzero(i8 %x, i8 %mask) {
; CHECK-LABEL: @freeze_nonzero(
; CHECK-NEXT:    [[Y:%.*]] = or i8 [[X:%.*]], [[MASK:%.*]]
; CHECK-NEXT:    [[C:%.*]] = icmp ne i8 [[Y]], 0
; CHECK-NEXT:    br i1 [[C]], label [[A:%.*]], label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    ret i1 false
; CHECK:       B:
; CHECK-NEXT:    ret i1 false
;
  %y = or i8 %x, %mask
  %c = icmp ne i8 %y, 0
  br i1 %c, label %A, label %B
A:
  %fr = freeze i8 %y
  %c2 = icmp eq i8 %fr, 0
  ret i1 %c2
B:
  ret i1 0
}

define i1 @smax_non_zero(i8 %xx, i8 %y) {
; CHECK-LABEL: @smax_non_zero(
; CHECK-NEXT:    ret i1 false
;
  %x0 = and i8 %xx, 63
  %x = add i8 %x0, 1
  %v = call i8 @llvm.smax.i8(i8 %x, i8 %y)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define <4 x i1> @shuf_nonzero_both(<4 x i8> %xx, <4 x i8> %yy) {
; CHECK-LABEL: @shuf_nonzero_both(
; CHECK-NEXT:    ret <4 x i1> zeroinitializer
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %y = add nuw <4 x i8> %yy, <i8 1, i8 1, i8 1, i8 1>

  %shuf = shufflevector <4 x i8> %x, <4 x i8> %y, <4 x i32> <i32 0, i32 4, i32 7, i32 2>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_both_fail(<4 x i8> %xx, <4 x i8> %yy) {
; CHECK-LABEL: @shuf_nonzero_both_fail(
; CHECK-NEXT:    [[X:%.*]] = add nuw <4 x i8> [[XX:%.*]], <i8 1, i8 1, i8 1, i8 1>
; CHECK-NEXT:    [[Y:%.*]] = add nuw <4 x i8> [[YY:%.*]], <i8 1, i8 1, i8 1, i8 0>
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i8> [[X]], <4 x i8> [[Y]], <4 x i32> <i32 0, i32 4, i32 7, i32 2>
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i8> [[SHUF]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %y = add nuw <4 x i8> %yy, <i8 1, i8 1, i8 1, i8 0>

  %shuf = shufflevector <4 x i8> %x, <4 x i8> %y, <4 x i32> <i32 0, i32 4, i32 7, i32 2>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_both_fail2(<4 x i8> %xx, <4 x i8> %yy) {
; CHECK-LABEL: @shuf_nonzero_both_fail2(
; CHECK-NEXT:    [[X:%.*]] = add nuw <4 x i8> [[XX:%.*]], <i8 1, i8 1, i8 1, i8 1>
; CHECK-NEXT:    [[Y:%.*]] = add <4 x i8> [[YY:%.*]], <i8 1, i8 1, i8 1, i8 1>
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i8> [[X]], <4 x i8> [[Y]], <4 x i32> <i32 0, i32 4, i32 7, i32 2>
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i8> [[SHUF]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>
  %y = add <4 x i8> %yy, <i8 1, i8 1, i8 1, i8 1>

  %shuf = shufflevector <4 x i8> %x, <4 x i8> %y, <4 x i32> <i32 0, i32 4, i32 7, i32 2>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_lhs(<4 x i8> %xx) {
; CHECK-LABEL: @shuf_nonzero_lhs(
; CHECK-NEXT:    ret <4 x i1> zeroinitializer
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>

  %shuf = shufflevector <4 x i8> %x, <4 x i8> poison, <4 x i32> <i32 2, i32 2, i32 0, i32 1>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_lhs2(<4 x i8> %xx) {
; CHECK-LABEL: @shuf_nonzero_lhs2(
; CHECK-NEXT:    ret <4 x i1> zeroinitializer
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 0>

  %shuf = shufflevector <4 x i8> %x, <4 x i8> poison, <4 x i32> <i32 2, i32 0, i32 1, i32 1>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_lhs2_fail(<4 x i8> %xx) {
; CHECK-LABEL: @shuf_nonzero_lhs2_fail(
; CHECK-NEXT:    [[X:%.*]] = add nuw <4 x i8> [[XX:%.*]], <i8 1, i8 1, i8 1, i8 0>
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i8> [[X]], <4 x i8> poison, <4 x i32> <i32 2, i32 0, i32 3, i32 1>
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i8> [[SHUF]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 0>

  %shuf = shufflevector <4 x i8> %x, <4 x i8> poison, <4 x i32> <i32 2, i32 0, i32 3, i32 1>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_rhs(<4 x i8> %xx) {
; CHECK-LABEL: @shuf_nonzero_rhs(
; CHECK-NEXT:    ret <4 x i1> zeroinitializer
;
  %x = add nuw <4 x i8> %xx, <i8 1, i8 1, i8 1, i8 1>

  %shuf = shufflevector <4 x i8> poison, <4 x i8> %x, <4 x i32> <i32 6, i32 7, i32 5, i32 4>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_rhs2(<4 x i8> %xx) {
; CHECK-LABEL: @shuf_nonzero_rhs2(
; CHECK-NEXT:    ret <4 x i1> zeroinitializer
;
  %x = add nuw <4 x i8> %xx, <i8 0, i8 0, i8 1, i8 1>

  %shuf = shufflevector <4 x i8> poison, <4 x i8> %x, <4 x i32> <i32 6, i32 7, i32 7, i32 6>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <4 x i1> @shuf_nonzero_rhs2_fail(<4 x i8> %xx) {
; CHECK-LABEL: @shuf_nonzero_rhs2_fail(
; CHECK-NEXT:    [[X:%.*]] = add nuw <4 x i8> [[XX:%.*]], <i8 0, i8 0, i8 1, i8 1>
; CHECK-NEXT:    [[SHUF:%.*]] = shufflevector <4 x i8> poison, <4 x i8> [[X]], <4 x i32> <i32 6, i32 7, i32 5, i32 6>
; CHECK-NEXT:    [[R:%.*]] = icmp eq <4 x i8> [[SHUF]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[R]]
;
  %x = add nuw <4 x i8> %xx, <i8 0, i8 0, i8 1, i8 1>

  %shuf = shufflevector <4 x i8> poison, <4 x i8> %x, <4 x i32> <i32 6, i32 7, i32 5, i32 6>
  %r = icmp eq <4 x i8> %shuf, zeroinitializer
  ret <4 x i1> %r
}

define <2 x i1> @insert_nonzero0(<2 x i8> %xx, i8 %yy) {
; CHECK-LABEL: @insert_nonzero0(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %x = add nuw <2 x i8> %xx, <i8 1, i8 0>
  %y = add nuw i8 %yy, 1

  %ins = insertelement <2 x i8> %x, i8 %y, i32 1
  %r = icmp eq <2 x i8> %ins, zeroinitializer
  ret <2 x i1> %r
}

define <2 x i1> @insert_nonzero1(<2 x i8> %xx, i8 %yy) {
; CHECK-LABEL: @insert_nonzero1(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %x = add nuw <2 x i8> %xx, <i8 0, i8 1>
  %y = add nuw i8 %yy, 1

  %ins = insertelement <2 x i8> %x, i8 %y, i32 0
  %r = icmp eq <2 x i8> %ins, zeroinitializer
  ret <2 x i1> %r
}

define <2 x i1> @insert_nonzero_fail(<2 x i8> %xx, i8 %yy) {
; CHECK-LABEL: @insert_nonzero_fail(
; CHECK-NEXT:    [[X:%.*]] = add nuw <2 x i8> [[XX:%.*]], <i8 1, i8 0>
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[INS:%.*]] = insertelement <2 x i8> [[X]], i8 [[Y]], i32 0
; CHECK-NEXT:    [[R:%.*]] = icmp eq <2 x i8> [[INS]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %x = add nuw <2 x i8> %xx, <i8 1, i8 0>
  %y = add nuw i8 %yy, 1

  %ins = insertelement <2 x i8> %x, i8 %y, i32 0
  %r = icmp eq <2 x i8> %ins, zeroinitializer
  ret <2 x i1> %r
}

define <2 x i1> @insert_nonzero_fail2(<2 x i8> %xx, i8 %yy) {
; CHECK-LABEL: @insert_nonzero_fail2(
; CHECK-NEXT:    [[X:%.*]] = add nuw <2 x i8> [[XX:%.*]], <i8 0, i8 1>
; CHECK-NEXT:    [[Y:%.*]] = add i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[INS:%.*]] = insertelement <2 x i8> [[X]], i8 [[Y]], i32 0
; CHECK-NEXT:    [[R:%.*]] = icmp eq <2 x i8> [[INS]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %x = add nuw <2 x i8> %xx, <i8 0, i8 1>
  %y = add i8 %yy, 1

  %ins = insertelement <2 x i8> %x, i8 %y, i32 0
  %r = icmp eq <2 x i8> %ins, zeroinitializer
  ret <2 x i1> %r
}

define <2 x i1> @insert_nonzero_any_idx(<2 x i8> %xx, i8 %yy, i32 %idx) {
; CHECK-LABEL: @insert_nonzero_any_idx(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %x = add nuw <2 x i8> %xx, <i8 1, i8 1>
  %y = add nuw i8 %yy, 1

  %ins = insertelement <2 x i8> %x, i8 %y, i32 %idx
  %r = icmp eq <2 x i8> %ins, zeroinitializer
  ret <2 x i1> %r
}

define <2 x i1> @insert_nonzero_any_idx_fail(<2 x i8> %xx, i8 %yy, i32 %idx) {
; CHECK-LABEL: @insert_nonzero_any_idx_fail(
; CHECK-NEXT:    [[X:%.*]] = add nuw <2 x i8> [[XX:%.*]], <i8 1, i8 0>
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[INS:%.*]] = insertelement <2 x i8> [[X]], i8 [[Y]], i32 [[IDX:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq <2 x i8> [[INS]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[R]]
;
  %x = add nuw <2 x i8> %xx, <i8 1, i8 0>
  %y = add nuw i8 %yy, 1

  %ins = insertelement <2 x i8> %x, i8 %y, i32 %idx
  %r = icmp eq <2 x i8> %ins, zeroinitializer
  ret <2 x i1> %r
}

define i1 @nonzero_reduce_or(<2 x i8> %xx) {
; CHECK-LABEL: @nonzero_reduce_or(
; CHECK-NEXT:    ret i1 false
;
  %x = add nuw <2 x i8> %xx, <i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.or(<2 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @nonzero_reduce_or_fail(<2 x i8> %xx) {
; CHECK-LABEL: @nonzero_reduce_or_fail(
; CHECK-NEXT:    [[X:%.*]] = add nsw <2 x i8> [[XX:%.*]], <i8 1, i8 1>
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.vector.reduce.or.v2i8(<2 x i8> [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x = add nsw <2 x i8> %xx, <i8 1, i8 1>
  %v = call i8 @llvm.vector.reduce.or(<2 x i8> %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_add_x_eq_0(i8 %x) {
; CHECK-LABEL: @src_x_add_x_eq_0(
; CHECK-NEXT:    ret i1 false
;
  %x_eq_0 = icmp eq i8 %x, 0
  %y = zext i1 %x_eq_0 to i8
  %v = add i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_add_x_eq_1_fail(i8 %x) {
; CHECK-LABEL: @src_x_add_x_eq_1_fail(
; CHECK-NEXT:    [[X_EQ_1:%.*]] = icmp eq i8 [[X:%.*]], 1
; CHECK-NEXT:    [[Y:%.*]] = zext i1 [[X_EQ_1]] to i8
; CHECK-NEXT:    [[V:%.*]] = add i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_eq_1 = icmp eq i8 %x, 1
  %y = zext i1 %x_eq_1 to i8
  %v = add i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_or_x_eq_0(i8 %x) {
; CHECK-LABEL: @src_x_or_x_eq_0(
; CHECK-NEXT:    ret i1 false
;
  %x_eq_0 = icmp eq i8 %x, 0
  %y = sext i1 %x_eq_0 to i8
  %v = or i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_or_x_sle_0_fail(i8 %x) {
; CHECK-LABEL: @src_x_or_x_sle_0_fail(
; CHECK-NEXT:    [[X_EQ_0:%.*]] = icmp sle i8 [[X:%.*]], 0
; CHECK-NEXT:    [[Y:%.*]] = sext i1 [[X_EQ_0]] to i8
; CHECK-NEXT:    [[V:%.*]] = or i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_eq_0 = icmp sle i8 %x, 0
  %y = sext i1 %x_eq_0 to i8
  %v = or i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_xor_x_eq_0(i8 %x) {
; CHECK-LABEL: @src_x_xor_x_eq_0(
; CHECK-NEXT:    ret i1 false
;
  %x_eq_0 = icmp eq i8 %x, 0
  %y = zext i1 %x_eq_0 to i8
  %v = xor i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_xor_x_ne_0_fail(i8 %x) {
; CHECK-LABEL: @src_x_xor_x_ne_0_fail(
; CHECK-NEXT:    [[X_NE_0:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    [[Y:%.*]] = zext i1 [[X_NE_0]] to i8
; CHECK-NEXT:    [[V:%.*]] = xor i8 [[X]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_ne_0 = icmp ne i8 %x, 0
  %y = zext i1 %x_ne_0 to i8
  %v = xor i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_sub0_x_eq_0(i8 %x) {
; CHECK-LABEL: @src_x_sub0_x_eq_0(
; CHECK-NEXT:    ret i1 false
;
  %x_eq_0 = icmp eq i8 %x, 0
  %y = sext i1 %x_eq_0 to i8
  %v = sub i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_sub0_z_eq_0_fail(i8 %x, i8 %z) {
; CHECK-LABEL: @src_x_sub0_z_eq_0_fail(
; CHECK-NEXT:    [[Z_EQ_0:%.*]] = icmp eq i8 [[Z:%.*]], 0
; CHECK-NEXT:    [[Y:%.*]] = sext i1 [[Z_EQ_0]] to i8
; CHECK-NEXT:    [[V:%.*]] = sub i8 [[X:%.*]], [[Y]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %z_eq_0 = icmp eq i8 %z, 0
  %y = sext i1 %z_eq_0 to i8
  %v = sub i8 %x, %y
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_sub1_x_eq_0(i8 %x) {
; CHECK-LABEL: @src_x_sub1_x_eq_0(
; CHECK-NEXT:    ret i1 false
;
  %x_eq_0 = icmp eq i8 %x, 0
  %y = zext i1 %x_eq_0 to i8
  %v = sub i8 %y, %x
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_sub1_x_eq_0_or_fail(i8 %x, i1 %c1) {
; CHECK-LABEL: @src_x_sub1_x_eq_0_or_fail(
; CHECK-NEXT:    [[X_EQ_0:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    [[X_EQ_0_OR:%.*]] = or i1 [[X_EQ_0]], [[C1:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = zext i1 [[X_EQ_0_OR]] to i8
; CHECK-NEXT:    [[V:%.*]] = sub i8 [[Y]], [[X]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_eq_0 = icmp eq i8 %x, 0
  %x_eq_0_or = or i1 %x_eq_0, %c1
  %y = zext i1 %x_eq_0_or to i8
  %v = sub i8 %y, %x
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_umax_x_eq_0(i8 %x) {
; CHECK-LABEL: @src_x_umax_x_eq_0(
; CHECK-NEXT:    ret i1 false
;
  %x_eq_0 = icmp eq i8 %x, 0
  %y = sext i1 %x_eq_0 to i8
  %v = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_umax_x_ugt_10_fail(i8 %x) {
; CHECK-LABEL: @src_x_umax_x_ugt_10_fail(
; CHECK-NEXT:    [[X_UGT_10:%.*]] = icmp ugt i8 [[X:%.*]], 10
; CHECK-NEXT:    [[Y:%.*]] = sext i1 [[X_UGT_10]] to i8
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.umax.i8(i8 [[Y]], i8 [[X]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %x_ugt_10 = icmp ugt i8 %x, 10
  %y = sext i1 %x_ugt_10 to i8
  %v = call i8 @llvm.umax.i8(i8 %y, i8 %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_uadd.sat_x_eq_0(i8 %x) {
; CHECK-LABEL: @src_x_uadd.sat_x_eq_0(
; CHECK-NEXT:    ret i1 false
;
  %x_eq_0 = icmp eq i8 %x, 0
  %y = zext i1 %x_eq_0 to i8
  %v = call i8 @llvm.uadd.sat.i8(i8 %y, i8 %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

define i1 @src_x_uadd.sat_c1_fail(i8 %x, i1 %c1) {
; CHECK-LABEL: @src_x_uadd.sat_c1_fail(
; CHECK-NEXT:    [[Y:%.*]] = zext i1 [[C1:%.*]] to i8
; CHECK-NEXT:    [[V:%.*]] = call i8 @llvm.uadd.sat.i8(i8 [[Y]], i8 [[X:%.*]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[V]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = zext i1 %c1 to i8
  %v = call i8 @llvm.uadd.sat.i8(i8 %y, i8 %x)
  %r = icmp eq i8 %v, 0
  ret i1 %r
}

