; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-vectorize -S %s | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx"

define i32 @ephemeral_load_and_compare_iv_used_outside(ptr %start, ptr %end) #0 {
; CHECK-LABEL: define i32 @ephemeral_load_and_compare_iv_used_outside(
; CHECK-SAME: ptr [[START:%.*]], ptr [[END:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IV:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[IV_NEXT]] = getelementptr nusw i8, ptr [[IV]], i64 -8
; CHECK-NEXT:    [[L1:%.*]] = load i32, ptr [[IV]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[L1]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq ptr [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_NOT]], label %[[EXIT:.*]], label %[[LOOP]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[IV_LCSSA:%.*]] = phi ptr [ [[IV]], %[[LOOP]] ]
; CHECK-NEXT:    [[FINAL_LOAD:%.*]] = load i32, ptr [[IV_LCSSA]], align 4
; CHECK-NEXT:    ret i32 [[FINAL_LOAD]]
;
entry:
  br label %loop

loop:
  %iv = phi ptr [ %start, %entry ],[ %iv.next, %loop ]
  %iv.next = getelementptr nusw i8, ptr %iv, i64 -8
  %l1 = load i32, ptr %iv, align 4
  %cmp = icmp ne i32 %l1, 0
  call void @llvm.assume(i1 %cmp)
  %cmp.not = icmp eq ptr %iv, %end
  br i1 %cmp.not, label %exit, label %loop

exit:
  %final.load = load i32, ptr %iv, align 4
  ret i32 %final.load
}

define i32 @ephemeral_load_and_compare_another_load_used_outside(ptr %start, ptr %end) #0 {
; CHECK-LABEL: define i32 @ephemeral_load_and_compare_another_load_used_outside(
; CHECK-SAME: ptr [[START:%.*]], ptr [[END:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IV:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[IV_NEXT2:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[IV_NEXT2]] = getelementptr nusw i8, ptr [[IV]], i64 -8
; CHECK-NEXT:    [[L1:%.*]] = load ptr, ptr [[END]], align 8
; CHECK-NEXT:    [[L2:%.*]] = load i32, ptr [[L1]], align 4
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i32 [[L2]], 0
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP]])
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq ptr [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_NOT]], label %[[EXIT:.*]], label %[[LOOP]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[L1_LCSSA:%.*]] = phi ptr [ [[L1]], %[[LOOP]] ]
; CHECK-NEXT:    [[FINAL_LOAD:%.*]] = load i32, ptr [[L1_LCSSA]], align 4
; CHECK-NEXT:    ret i32 [[FINAL_LOAD]]
;
entry:
  br label %loop

loop:
  %iv = phi ptr [ %start, %entry ], [ %iv.next2, %loop ]
  %iv.next2 = getelementptr nusw i8, ptr %iv, i64 -8
  %l1 = load ptr, ptr %end, align 8
  %l2 = load i32, ptr %l1, align 4
  %cmp = icmp ne i32 %l2, 0
  call void @llvm.assume(i1 %cmp)
  %cmp.not = icmp eq ptr %iv, %end
  br i1 %cmp.not, label %exit, label %loop

exit:
  %final.load = load i32, ptr %l1, align 4
  ret i32 %final.load
}

declare void @llvm.assume(i1 noundef)

attributes #0 = { "target-cpu"="skylake-avx512" }
