# Check that "assembled_snippet" is fetched correctly from object file.
# Feel free to update the snippet in this test if the code generated by the
# snippet repetitor was changed intentionally and it is still fetched correctly.

# RUN: llvm-exegesis --mtriple=mips-linux-gnu --mcpu=generic --benchmark-phase=prepare-and-assemble-snippet \
# RUN:               --snippets-file=%s --mode=latency --repetition-mode=duplicate \
# RUN: | FileCheck %s --check-prefix=CHECK-LINUX

# RUN: llvm-exegesis --mtriple=mips64-linux-gnu --mcpu=generic --benchmark-phase=prepare-and-assemble-snippet \
# RUN:               --snippets-file=%s --mode=latency --repetition-mode=duplicate \
# RUN: | FileCheck %s --check-prefix=CHECK-LINUX-64

# LLVM-EXEGESIS-DEFREG A0 0
# LLVM-EXEGESIS-DEFREG A1 0
add $2, $5, $4

# CHECK-LINUX: cpu_name:             generic
# CHECK-LINUX: llvm_triple:          mips-unknown-linux-gnu
# CHECK-LINUX: assembled_snippet:    340400003405000000A4102000A4102000A4102000A4102003E00008{{$}}

# CHECK-LINUX-64: cpu_name:           generic
# CHECK-LINUX-64: llvm_triple:        mips64-unknown-linux-gnu
# CHECK-LINUX-64: assembled_snippet:  340400003405000000A4102000A4102000A4102000A4102003E00008{{$}}
