# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=aarch64 -mcpu=cortex-a53 --timeline --iterations=1 < %s | FileCheck %s

ldp  w3, w5, [x10], #4 // 2uop + 1uop carry over
add  w10, w11, w12
add  w13, w14, w15
ldp  w7, w8, [x11] // 2uop, no carry over
add  w16, w17, w18
add  w19, w20, w21

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      6
# CHECK-NEXT: Total Cycles:      8
# CHECK-NEXT: Total uOps:        9

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    1.13
# CHECK-NEXT: IPC:               0.75
# CHECK-NEXT: Block RThroughput: 4.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  3      4     2.00    *                   ldp	w3, w5, [x10], #4
# CHECK-NEXT:  1      3     0.50                        add	w10, w11, w12
# CHECK-NEXT:  1      3     0.50                        add	w13, w14, w15
# CHECK-NEXT:  2      4     2.00    *                   ldp	w7, w8, [x11]
# CHECK-NEXT:  1      3     0.50                        add	w16, w17, w18
# CHECK-NEXT:  1      3     0.50                        add	w19, w20, w21

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - A53UnitALU
# CHECK-NEXT: [0.1] - A53UnitALU
# CHECK-NEXT: [1]   - A53UnitB
# CHECK-NEXT: [2]   - A53UnitDiv
# CHECK-NEXT: [3]   - A53UnitFPALU
# CHECK-NEXT: [4]   - A53UnitFPMDS
# CHECK-NEXT: [5]   - A53UnitLdSt
# CHECK-NEXT: [6]   - A53UnitMAC

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]
# CHECK-NEXT: 2.00   2.00    -      -      -      -     4.00    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -     2.00    -     ldp	w3, w5, [x10], #4
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     add	w10, w11, w12
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     add	w13, w14, w15
# CHECK-NEXT:  -      -      -      -      -      -     2.00    -     ldp	w7, w8, [x11]
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -     add	w16, w17, w18
# CHECK-NEXT: 1.00    -      -      -      -      -      -      -     add	w19, w20, w21

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234567

# CHECK:      [0,0]     DeeeE. .   ldp	w3, w5, [x10], #4
# CHECK-NEXT: [0,1]     .DeeE. .   add	w10, w11, w12
# CHECK-NEXT: [0,2]     . DeeE .   add	w13, w14, w15
# CHECK-NEXT: [0,3]     .  DeeeE   ldp	w7, w8, [x11]
# CHECK-NEXT: [0,4]     .   DeeE   add	w16, w17, w18
# CHECK-NEXT: [0,5]     .   DeeE   add	w19, w20, w21

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       ldp	w3, w5, [x10], #4
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       add	w10, w11, w12
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       add	w13, w14, w15
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       ldp	w7, w8, [x11]
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       add	w16, w17, w18
# CHECK-NEXT: 5.     1     0.0    0.0    0.0       add	w19, w20, w21
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
