# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -instruction-tables < %s | FileCheck %s

kaddd             %k0, %k1, %k2
kaddq             %k0, %k1, %k2

kandd             %k0, %k1, %k2
kandq             %k0, %k1, %k2

kandnd            %k0, %k1, %k2
kandnq            %k0, %k1, %k2

kmovd             %k0, %k2
kmovd             (%rax), %k2
kmovd             %k0, (%rax)
kmovd             %eax, %k2
kmovd             %k0, %eax

kmovq             %k0, %k2
kmovq             (%rax), %k2
kmovq             %k0, (%rax)
kmovq             %rax, %k2
kmovq             %k0, %rax

knotd             %k0, %k2
knotq             %k0, %k2

kord              %k0, %k1, %k2
korq              %k0, %k1, %k2

kortestd          %k0, %k2
kortestq          %k0, %k2

kshiftld          $2, %k1, %k2
kshiftlq          $2, %k1, %k2

kshiftrd          $2, %k1, %k2
kshiftrq          $2, %k1, %k2

ktestd            %k0, %k2
ktestq            %k0, %k2

kunpckdq          %k0, %k1, %k2
kunpckwd          %k0, %k1, %k2

kxnord            %k0, %k1, %k2
kxnorq            %k0, %k1, %k2

kxord             %k0, %k1, %k2
kxorq             %k0, %k1, %k2

vdbpsadbw         $0, %zmm16, %zmm17, %zmm19
vdbpsadbw         $0, (%rax), %zmm17, %zmm19
vdbpsadbw         $0, %zmm16, %zmm17, %zmm19 {k1}
vdbpsadbw         $0, (%rax), %zmm17, %zmm19 {k1}
vdbpsadbw         $0, %zmm16, %zmm17, %zmm19 {z}{k1}
vdbpsadbw         $0, (%rax), %zmm17, %zmm19 {z}{k1}

vmovdqu8          %zmm16, %zmm19
vmovdqu8          (%rax), %zmm19
vmovdqu8          %zmm16, (%rax)
vmovdqu8          %zmm16, %zmm19 {k1}
vmovdqu8          (%rax), %zmm19 {k1}
vmovdqu8          %zmm16, (%rax) {k1}
vmovdqu8          %zmm16, %zmm19 {z}{k1}
vmovdqu8          (%rax), %zmm19 {z}{k1}

vmovdqu16         %zmm16, %zmm19
vmovdqu16         (%rax), %zmm19
vmovdqu16         %zmm16, (%rax)
vmovdqu16         %zmm16, %zmm19 {k1}
vmovdqu16         (%rax), %zmm19 {k1}
vmovdqu16         %zmm16, (%rax) {k1}
vmovdqu16         %zmm16, %zmm19 {z}{k1}
vmovdqu16         (%rax), %zmm19 {z}{k1}

vpabsb            %zmm16, %zmm19
vpabsb            (%rax), %zmm19
vpabsb            %zmm16, %zmm19 {k1}
vpabsb            (%rax), %zmm19 {k1}
vpabsb            %zmm16, %zmm19 {z}{k1}
vpabsb            (%rax), %zmm19 {z}{k1}

vpabsw            %zmm16, %zmm19
vpabsw            (%rax), %zmm19
vpabsw            %zmm16, %zmm19 {k1}
vpabsw            (%rax), %zmm19 {k1}
vpabsw            %zmm16, %zmm19 {z}{k1}
vpabsw            (%rax), %zmm19 {z}{k1}

vpackssdw         %zmm16, %zmm17, %zmm19
vpackssdw         (%rax), %zmm17, %zmm19
vpackssdw         %zmm16, %zmm17, %zmm19 {k1}
vpackssdw         (%rax), %zmm17, %zmm19 {k1}
vpackssdw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpackssdw         (%rax), %zmm17, %zmm19 {z}{k1}

vpacksswb         %zmm16, %zmm17, %zmm19
vpacksswb         (%rax), %zmm17, %zmm19
vpacksswb         %zmm16, %zmm17, %zmm19 {k1}
vpacksswb         (%rax), %zmm17, %zmm19 {k1}
vpacksswb         %zmm16, %zmm17, %zmm19 {z}{k1}
vpacksswb         (%rax), %zmm17, %zmm19 {z}{k1}

vpackusdw         %zmm16, %zmm17, %zmm19
vpackusdw         (%rax), %zmm17, %zmm19
vpackusdw         %zmm16, %zmm17, %zmm19 {k1}
vpackusdw         (%rax), %zmm17, %zmm19 {k1}
vpackusdw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpackusdw         (%rax), %zmm17, %zmm19 {z}{k1}

vpackuswb         %zmm16, %zmm17, %zmm19
vpackuswb         (%rax), %zmm17, %zmm19
vpackuswb         %zmm16, %zmm17, %zmm19 {k1}
vpackuswb         (%rax), %zmm17, %zmm19 {k1}
vpackuswb         %zmm16, %zmm17, %zmm19 {z}{k1}
vpackuswb         (%rax), %zmm17, %zmm19 {z}{k1}

vpaddb            %zmm16, %zmm17, %zmm19
vpaddb            (%rax), %zmm17, %zmm19
vpaddb            %zmm16, %zmm17, %zmm19 {k1}
vpaddb            (%rax), %zmm17, %zmm19 {k1}
vpaddb            %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddb            (%rax), %zmm17, %zmm19 {z}{k1}

vpaddsb           %zmm16, %zmm17, %zmm19
vpaddsb           (%rax), %zmm17, %zmm19
vpaddsb           %zmm16, %zmm17, %zmm19 {k1}
vpaddsb           (%rax), %zmm17, %zmm19 {k1}
vpaddsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpaddsw           %zmm16, %zmm17, %zmm19
vpaddsw           (%rax), %zmm17, %zmm19
vpaddsw           %zmm16, %zmm17, %zmm19 {k1}
vpaddsw           (%rax), %zmm17, %zmm19 {k1}
vpaddsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpaddusb          %zmm16, %zmm17, %zmm19
vpaddusb          (%rax), %zmm17, %zmm19
vpaddusb          %zmm16, %zmm17, %zmm19 {k1}
vpaddusb          (%rax), %zmm17, %zmm19 {k1}
vpaddusb          %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddusb          (%rax), %zmm17, %zmm19 {z}{k1}

vpaddusw          %zmm16, %zmm17, %zmm19
vpaddusw          (%rax), %zmm17, %zmm19
vpaddusw          %zmm16, %zmm17, %zmm19 {k1}
vpaddusw          (%rax), %zmm17, %zmm19 {k1}
vpaddusw          %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddusw          (%rax), %zmm17, %zmm19 {z}{k1}

vpaddw            %zmm16, %zmm17, %zmm19
vpaddw            (%rax), %zmm17, %zmm19
vpaddw            %zmm16, %zmm17, %zmm19 {k1}
vpaddw            (%rax), %zmm17, %zmm19 {k1}
vpaddw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpaddw            (%rax), %zmm17, %zmm19 {z}{k1}

vpalignr          $1, %zmm16, %zmm17, %zmm19
vpalignr          $1, (%rax), %zmm17, %zmm19
vpalignr          $1, %zmm16, %zmm17, %zmm19 {k1}
vpalignr          $1, (%rax), %zmm17, %zmm19 {k1}
vpalignr          $1, %zmm16, %zmm17, %zmm19 {z}{k1}
vpalignr          $1, (%rax), %zmm17, %zmm19 {z}{k1}

vpavgb            %zmm16, %zmm17, %zmm19
vpavgb            (%rax), %zmm17, %zmm19
vpavgb            %zmm16, %zmm17, %zmm19 {k1}
vpavgb            (%rax), %zmm17, %zmm19 {k1}
vpavgb            %zmm16, %zmm17, %zmm19 {z}{k1}
vpavgb            (%rax), %zmm17, %zmm19 {z}{k1}

vpavgw            %zmm16, %zmm17, %zmm19
vpavgw            (%rax), %zmm17, %zmm19
vpavgw            %zmm16, %zmm17, %zmm19 {k1}
vpavgw            (%rax), %zmm17, %zmm19 {k1}
vpavgw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpavgw            (%rax), %zmm17, %zmm19 {z}{k1}

vpblendmb         %zmm16, %zmm17, %zmm19
vpblendmb         (%rax), %zmm17, %zmm19
vpblendmb         %zmm16, %zmm17, %zmm19 {k1}
vpblendmb         (%rax), %zmm17, %zmm19 {k1}
vpblendmb         %zmm16, %zmm17, %zmm19 {z}{k1}
vpblendmb         (%rax), %zmm17, %zmm19 {z}{k1}

vpblendmw         %zmm16, %zmm17, %zmm19
vpblendmw         (%rax), %zmm17, %zmm19
vpblendmw         %zmm16, %zmm17, %zmm19 {k1}
vpblendmw         (%rax), %zmm17, %zmm19 {k1}
vpblendmw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpblendmw         (%rax), %zmm17, %zmm19 {z}{k1}

vpbroadcastb      %xmm16, %zmm19
vpbroadcastb      (%rax), %zmm19
vpbroadcastb      %eax, %zmm19
vpbroadcastb      %xmm16, %zmm19 {k1}
vpbroadcastb      (%rax), %zmm19 {k1}
vpbroadcastb      %eax, %zmm19 {k1}
vpbroadcastb      %xmm16, %zmm19 {z}{k1}
vpbroadcastb      (%rax), %zmm19 {z}{k1}
vpbroadcastb      %eax, %zmm19 {z}{k1}

vpbroadcastw      %xmm16, %zmm19
vpbroadcastw      (%rax), %zmm19
vpbroadcastw      %eax, %zmm19
vpbroadcastw      %xmm16, %zmm19 {k1}
vpbroadcastw      (%rax), %zmm19 {k1}
vpbroadcastw      %eax, %zmm19 {k1}
vpbroadcastw      %xmm16, %zmm19 {z}{k1}
vpbroadcastw      (%rax), %zmm19 {z}{k1}
vpbroadcastw      %eax, %zmm19 {z}{k1}

vpcmpb            $0, %zmm0, %zmm1, %k2
vpcmpb            $0, (%rax), %zmm1, %k2
vpcmpb            $0, %zmm0, %zmm1, %k2 {k3}
vpcmpb            $0, (%rax), %zmm1, %k2 {k3}

vpcmpeqb          %zmm0, %zmm1, %k2
vpcmpeqb          (%rax), %zmm1, %k2
vpcmpeqb          %zmm0, %zmm1, %k2 {k3}
vpcmpeqb          (%rax), %zmm1, %k2 {k3}

vpcmpeqw          %zmm0, %zmm1, %k2
vpcmpeqw          (%rax), %zmm1, %k2
vpcmpeqw          %zmm0, %zmm1, %k2 {k3}
vpcmpeqw          (%rax), %zmm1, %k2 {k3}

vpcmpgtb          %zmm0, %zmm1, %k2
vpcmpgtb          (%rax), %zmm1, %k2
vpcmpgtb          %zmm0, %zmm1, %k2 {k3}
vpcmpgtb          (%rax), %zmm1, %k2 {k3}

vpcmpgtw          %zmm0, %zmm1, %k2
vpcmpgtw          (%rax), %zmm1, %k2
vpcmpgtw          %zmm0, %zmm1, %k2 {k3}
vpcmpgtw          (%rax), %zmm1, %k2 {k3}

vpcmpub           $0, %zmm0, %zmm1, %k2
vpcmpub           $0, (%rax), %zmm1, %k2
vpcmpub           $0, %zmm0, %zmm1, %k2 {k3}
vpcmpub           $0, (%rax), %zmm1, %k2 {k3}

vpcmpuw           $0, %zmm0, %zmm1, %k2
vpcmpuw           $0, (%rax), %zmm1, %k2
vpcmpuw           $0, %zmm0, %zmm1, %k2 {k3}
vpcmpuw           $0, (%rax), %zmm1, %k2 {k3}

vpcmpw            $0, %zmm0, %zmm1, %k2
vpcmpw            $0, (%rax), %zmm1, %k2
vpcmpw            $0, %zmm0, %zmm1, %k2 {k3}
vpcmpw            $0, (%rax), %zmm1, %k2 {k3}

vpextrb           $0, %xmm16, %rax
vpextrb           $0, %xmm16, (%rax)

vpextrw           $0, %xmm16, %rax
vpextrw           $0, %xmm16, (%rax)

vpinsrb           $0, %rax, %xmm16, %xmm19
vpinsrb           $0, (%rax), %xmm16, %xmm19

vpinsrw           $0, %rax, %xmm16, %xmm19
vpinsrw           $0, (%rax), %xmm16, %xmm19

vpermw            %zmm16, %zmm17, %zmm19
vpermw            (%rax), %zmm17, %zmm19
vpermw            %zmm16, %zmm17, %zmm19 {k1}
vpermw            (%rax), %zmm17, %zmm19 {k1}
vpermw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpermw            (%rax), %zmm17, %zmm19 {z}{k1}

vpermi2w          %zmm16, %zmm17, %zmm19
vpermi2w          (%rax), %zmm17, %zmm19
vpermi2w          %zmm16, %zmm17, %zmm19 {k1}
vpermi2w          (%rax), %zmm17, %zmm19 {k1}
vpermi2w          %zmm16, %zmm17, %zmm19 {z}{k1}
vpermi2w          (%rax), %zmm17, %zmm19 {z}{k1}

vpermt2w          %zmm16, %zmm17, %zmm19
vpermt2w          (%rax), %zmm17, %zmm19
vpermt2w          %zmm16, %zmm17, %zmm19 {k1}
vpermt2w          (%rax), %zmm17, %zmm19 {k1}
vpermt2w          %zmm16, %zmm17, %zmm19 {z}{k1}
vpermt2w          (%rax), %zmm17, %zmm19 {z}{k1}

vpmaddubsw        %zmm16, %zmm17, %zmm19
vpmaddubsw        (%rax), %zmm17, %zmm19
vpmaddubsw        %zmm16, %zmm17, %zmm19 {k1}
vpmaddubsw        (%rax), %zmm17, %zmm19 {k1}
vpmaddubsw        %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaddubsw        (%rax), %zmm17, %zmm19 {z}{k1}

vpmaddwd          %zmm16, %zmm17, %zmm19
vpmaddwd          (%rax), %zmm17, %zmm19
vpmaddwd          %zmm16, %zmm17, %zmm19 {k1}
vpmaddwd          (%rax), %zmm17, %zmm19 {k1}
vpmaddwd          %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaddwd          (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxsb           %zmm16, %zmm17, %zmm19
vpmaxsb           (%rax), %zmm17, %zmm19
vpmaxsb           %zmm16, %zmm17, %zmm19 {k1}
vpmaxsb           (%rax), %zmm17, %zmm19 {k1}
vpmaxsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxsw           %zmm16, %zmm17, %zmm19
vpmaxsw           (%rax), %zmm17, %zmm19
vpmaxsw           %zmm16, %zmm17, %zmm19 {k1}
vpmaxsw           (%rax), %zmm17, %zmm19 {k1}
vpmaxsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxub           %zmm16, %zmm17, %zmm19
vpmaxub           (%rax), %zmm17, %zmm19
vpmaxub           %zmm16, %zmm17, %zmm19 {k1}
vpmaxub           (%rax), %zmm17, %zmm19 {k1}
vpmaxub           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxub           (%rax), %zmm17, %zmm19 {z}{k1}

vpmaxuw           %zmm16, %zmm17, %zmm19
vpmaxuw           (%rax), %zmm17, %zmm19
vpmaxuw           %zmm16, %zmm17, %zmm19 {k1}
vpmaxuw           (%rax), %zmm17, %zmm19 {k1}
vpmaxuw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmaxuw           (%rax), %zmm17, %zmm19 {z}{k1}

vpminsb           %zmm16, %zmm17, %zmm19
vpminsb           (%rax), %zmm17, %zmm19
vpminsb           %zmm16, %zmm17, %zmm19 {k1}
vpminsb           (%rax), %zmm17, %zmm19 {k1}
vpminsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpminsw           %zmm16, %zmm17, %zmm19
vpminsw           (%rax), %zmm17, %zmm19
vpminsw           %zmm16, %zmm17, %zmm19 {k1}
vpminsw           (%rax), %zmm17, %zmm19 {k1}
vpminsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpminub           %zmm16, %zmm17, %zmm19
vpminub           (%rax), %zmm17, %zmm19
vpminub           %zmm16, %zmm17, %zmm19 {k1}
vpminub           (%rax), %zmm17, %zmm19 {k1}
vpminub           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminub           (%rax), %zmm17, %zmm19 {z}{k1}

vpminuw           %zmm16, %zmm17, %zmm19
vpminuw           (%rax), %zmm17, %zmm19
vpminuw           %zmm16, %zmm17, %zmm19 {k1}
vpminuw           (%rax), %zmm17, %zmm19 {k1}
vpminuw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpminuw           (%rax), %zmm17, %zmm19 {z}{k1}

vpmovb2m          %zmm0, %k0
vpmovw2m          %zmm0, %k0

vpmovm2b          %k0, %zmm0
vpmovm2w          %k0, %zmm0

vpmovsxbw         %ymm16, %zmm19
vpmovsxbw         (%rax), %zmm19
vpmovsxbw         %ymm16, %zmm19 {k1}
vpmovsxbw         (%rax), %zmm19 {k1}
vpmovsxbw         %ymm16, %zmm19 {z}{k1}
vpmovsxbw         (%rax), %zmm19 {z}{k1}

vpmovswb          %zmm16, %ymm19
vpmovswb          %zmm16, (%rax)
vpmovswb          %zmm16, %ymm19 {k1}
vpmovswb          %zmm16, (%rax) {k1}

vpmovuswb         %zmm16, %ymm19
vpmovuswb         %zmm16, (%rax)
vpmovuswb         %zmm16, %ymm19 {k1}
vpmovuswb         %zmm16, (%rax) {k1}

vpmovwb           %zmm16, %ymm19
vpmovwb           %zmm16, (%rax)
vpmovwb           %zmm16, %ymm19 {k1}
vpmovwb           %zmm16, (%rax) {k1}

vpmovzxbw         %ymm16, %zmm19
vpmovzxbw         (%rax), %zmm19
vpmovzxbw         %ymm16, %zmm19 {k1}
vpmovzxbw         (%rax), %zmm19 {k1}
vpmovzxbw         %ymm16, %zmm19 {z}{k1}
vpmovzxbw         (%rax), %zmm19 {z}{k1}

vpmulhrsw         %zmm16, %zmm17, %zmm19
vpmulhrsw         (%rax), %zmm17, %zmm19
vpmulhrsw         %zmm16, %zmm17, %zmm19 {k1}
vpmulhrsw         (%rax), %zmm17, %zmm19 {k1}
vpmulhrsw         %zmm16, %zmm17, %zmm19 {z}{k1}
vpmulhrsw         (%rax), %zmm17, %zmm19 {z}{k1}

vpmulhuw          %zmm16, %zmm17, %zmm19
vpmulhuw          (%rax), %zmm17, %zmm19
vpmulhuw          %zmm16, %zmm17, %zmm19 {k1}
vpmulhuw          (%rax), %zmm17, %zmm19 {k1}
vpmulhuw          %zmm16, %zmm17, %zmm19 {z}{k1}
vpmulhuw          (%rax), %zmm17, %zmm19 {z}{k1}

vpmulhw           %zmm16, %zmm17, %zmm19
vpmulhw           (%rax), %zmm17, %zmm19
vpmulhw           %zmm16, %zmm17, %zmm19 {k1}
vpmulhw           (%rax), %zmm17, %zmm19 {k1}
vpmulhw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmulhw           (%rax), %zmm17, %zmm19 {z}{k1}

vpmullw           %zmm16, %zmm17, %zmm19
vpmullw           (%rax), %zmm17, %zmm19
vpmullw           %zmm16, %zmm17, %zmm19 {k1}
vpmullw           (%rax), %zmm17, %zmm19 {k1}
vpmullw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpmullw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsadbw           %zmm16, %zmm17, %zmm19
vpsadbw           (%rax), %zmm17, %zmm19

vpshufb           %zmm16, %zmm17, %zmm19
vpshufb           (%rax), %zmm17, %zmm19
vpshufb           %zmm16, %zmm17, %zmm19 {k1}
vpshufb           (%rax), %zmm17, %zmm19 {k1}
vpshufb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpshufb           (%rax), %zmm17, %zmm19 {z}{k1}

vpshufhw          $0, %zmm16, %zmm19
vpshufhw          $0, (%rax), %zmm19
vpshufhw          $0, %zmm16, %zmm19 {k1}
vpshufhw          $0, (%rax), %zmm19 {k1}
vpshufhw          $0, %zmm16, %zmm19 {z}{k1}
vpshufhw          $0, (%rax), %zmm19 {z}{k1}

vpshuflw          $0, %zmm16, %zmm19
vpshuflw          $0, (%rax), %zmm19
vpshuflw          $0, %zmm16, %zmm19 {k1}
vpshuflw          $0, (%rax), %zmm19 {k1}
vpshuflw          $0, %zmm16, %zmm19 {z}{k1}
vpshuflw          $0, (%rax), %zmm19 {z}{k1}

vpslldq           $1, %zmm16, %zmm19
vpslldq           $1, (%rax), %zmm19

vpsllvw           %zmm16, %zmm17, %zmm19
vpsllvw           (%rax), %zmm17, %zmm19
vpsllvw           %zmm16, %zmm17, %zmm19 {k1}
vpsllvw           (%rax), %zmm17, %zmm19 {k1}
vpsllvw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsllvw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsllw            $0, %zmm16, %zmm19
vpsllw            $0, (%rax), %zmm19
vpsllw            $0, %zmm16, %zmm19 {k1}
vpsllw            $0, (%rax), %zmm19 {k1}
vpsllw            $0, %zmm16, %zmm19 {z}{k1}
vpsllw            $0, (%rax), %zmm19 {z}{k1}

vpsllw            %xmm16, %zmm17, %zmm19
vpsllw            (%rax), %zmm17, %zmm19
vpsllw            %xmm16, %zmm17, %zmm19 {k1}
vpsllw            (%rax), %zmm17, %zmm19 {k1}
vpsllw            %xmm16, %zmm17, %zmm19 {z}{k1}
vpsllw            (%rax), %zmm17, %zmm19 {z}{k1}

vpsravw           %zmm16, %zmm17, %zmm19
vpsravw           (%rax), %zmm17, %zmm19
vpsravw           %zmm16, %zmm17, %zmm19 {k1}
vpsravw           (%rax), %zmm17, %zmm19 {k1}
vpsravw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsravw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsraw            $0, %zmm16, %zmm19
vpsraw            $0, (%rax), %zmm19
vpsraw            $0, %zmm16, %zmm19 {k1}
vpsraw            $0, (%rax), %zmm19 {k1}
vpsraw            $0, %zmm16, %zmm19 {z}{k1}
vpsraw            $0, (%rax), %zmm19 {z}{k1}

vpsraw            %xmm16, %zmm17, %zmm19
vpsraw            (%rax), %zmm17, %zmm19
vpsraw            %xmm16, %zmm17, %zmm19 {k1}
vpsraw            (%rax), %zmm17, %zmm19 {k1}
vpsraw            %xmm16, %zmm17, %zmm19 {z}{k1}
vpsraw            (%rax), %zmm17, %zmm19 {z}{k1}

vpsrldq           $1, %zmm16, %zmm19
vpsrldq           $1, (%rax), %zmm19

vpsrlvw           %zmm16, %zmm17, %zmm19
vpsrlvw           (%rax), %zmm17, %zmm19
vpsrlvw           %zmm16, %zmm17, %zmm19 {k1}
vpsrlvw           (%rax), %zmm17, %zmm19 {k1}
vpsrlvw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsrlvw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsrlw            $0, %zmm16, %zmm19
vpsrlw            $0, (%rax), %zmm19
vpsrlw            $0, %zmm16, %zmm19 {k1}
vpsrlw            $0, (%rax), %zmm19 {k1}
vpsrlw            $0, %zmm16, %zmm19 {z}{k1}
vpsrlw            $0, (%rax), %zmm19 {z}{k1}

vpsrlw            %xmm16, %zmm17, %zmm19
vpsrlw            (%rax), %zmm17, %zmm19
vpsrlw            %xmm16, %zmm17, %zmm19 {k1}
vpsrlw            (%rax), %zmm17, %zmm19 {k1}
vpsrlw            %xmm16, %zmm17, %zmm19 {z}{k1}
vpsrlw            (%rax), %zmm17, %zmm19 {z}{k1}

vpsubb            %zmm16, %zmm17, %zmm19
vpsubb            (%rax), %zmm17, %zmm19
vpsubb            %zmm16, %zmm17, %zmm19 {k1}
vpsubb            (%rax), %zmm17, %zmm19 {k1}
vpsubb            %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubb            (%rax), %zmm17, %zmm19 {z}{k1}

vpsubsb           %zmm16, %zmm17, %zmm19
vpsubsb           (%rax), %zmm17, %zmm19
vpsubsb           %zmm16, %zmm17, %zmm19 {k1}
vpsubsb           (%rax), %zmm17, %zmm19 {k1}
vpsubsb           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubsb           (%rax), %zmm17, %zmm19 {z}{k1}

vpsubsw           %zmm16, %zmm17, %zmm19
vpsubsw           (%rax), %zmm17, %zmm19
vpsubsw           %zmm16, %zmm17, %zmm19 {k1}
vpsubsw           (%rax), %zmm17, %zmm19 {k1}
vpsubsw           %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubsw           (%rax), %zmm17, %zmm19 {z}{k1}

vpsubusb          %zmm16, %zmm17, %zmm19
vpsubusb          (%rax), %zmm17, %zmm19
vpsubusb          %zmm16, %zmm17, %zmm19 {k1}
vpsubusb          (%rax), %zmm17, %zmm19 {k1}
vpsubusb          %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubusb          (%rax), %zmm17, %zmm19 {z}{k1}

vpsubusw          %zmm16, %zmm17, %zmm19
vpsubusw          (%rax), %zmm17, %zmm19
vpsubusw          %zmm16, %zmm17, %zmm19 {k1}
vpsubusw          (%rax), %zmm17, %zmm19 {k1}
vpsubusw          %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubusw          (%rax), %zmm17, %zmm19 {z}{k1}

vpsubw            %zmm16, %zmm17, %zmm19
vpsubw            (%rax), %zmm17, %zmm19
vpsubw            %zmm16, %zmm17, %zmm19 {k1}
vpsubw            (%rax), %zmm17, %zmm19 {k1}
vpsubw            %zmm16, %zmm17, %zmm19 {z}{k1}
vpsubw            (%rax), %zmm17, %zmm19 {z}{k1}

vptestmb          %zmm0, %zmm1, %k2
vptestmb          (%rax), %zmm1, %k2
vptestmb          %zmm0, %zmm1, %k2 {k3}
vptestmb          (%rax), %zmm1, %k2 {k3}

vptestmw          %zmm0, %zmm1, %k2
vptestmw          (%rax), %zmm1, %k2
vptestmw          %zmm0, %zmm1, %k2 {k3}
vptestmw          (%rax), %zmm1, %k2 {k3}

vptestnmb         %zmm0, %zmm1, %k2
vptestnmb         (%rax), %zmm1, %k2
vptestnmb         %zmm0, %zmm1, %k2 {k3}
vptestnmb         (%rax), %zmm1, %k2 {k3}

vptestnmw         %zmm0, %zmm1, %k2
vptestnmw         (%rax), %zmm1, %k2
vptestnmw         %zmm0, %zmm1, %k2 {k3}
vptestnmw         (%rax), %zmm1, %k2 {k3}

vpunpckhbw        %zmm16, %zmm17, %zmm19
vpunpckhbw        (%rax), %zmm17, %zmm19
vpunpckhbw        %zmm16, %zmm17, %zmm19 {k1}
vpunpckhbw        (%rax), %zmm17, %zmm19 {k1}
vpunpckhbw        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpckhbw        (%rax), %zmm17, %zmm19 {z}{k1}

vpunpckhwd        %zmm16, %zmm17, %zmm19
vpunpckhwd        (%rax), %zmm17, %zmm19
vpunpckhwd        %zmm16, %zmm17, %zmm19 {k1}
vpunpckhwd        (%rax), %zmm17, %zmm19 {k1}
vpunpckhwd        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpckhwd        (%rax), %zmm17, %zmm19 {z}{k1}

vpunpcklbw        %zmm16, %zmm17, %zmm19
vpunpcklbw        (%rax), %zmm17, %zmm19
vpunpcklbw        %zmm16, %zmm17, %zmm19 {k1}
vpunpcklbw        (%rax), %zmm17, %zmm19 {k1}
vpunpcklbw        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpcklbw        (%rax), %zmm17, %zmm19 {z}{k1}

vpunpcklwd        %zmm16, %zmm17, %zmm19
vpunpcklwd        (%rax), %zmm17, %zmm19
vpunpcklwd        %zmm16, %zmm17, %zmm19 {k1}
vpunpcklwd        (%rax), %zmm17, %zmm19 {k1}
vpunpcklwd        %zmm16, %zmm17, %zmm19 {z}{k1}
vpunpcklwd        (%rax), %zmm17, %zmm19 {z}{k1}

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.33                        kaddd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kaddq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kandd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kandq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kandnd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kandnq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kmovd	%k0, %k2
# CHECK-NEXT:  1      5     0.50    *                   kmovd	(%rax), %k2
# CHECK-NEXT:  1      1     1.00           *            kmovd	%k0, (%rax)
# CHECK-NEXT:  1      1     0.33                        kmovd	%eax, %k2
# CHECK-NEXT:  1      1     0.33                        kmovd	%k0, %eax
# CHECK-NEXT:  1      1     0.33                        kmovq	%k0, %k2
# CHECK-NEXT:  1      5     0.50    *                   kmovq	(%rax), %k2
# CHECK-NEXT:  1      1     1.00           *            kmovq	%k0, (%rax)
# CHECK-NEXT:  1      1     0.33                        kmovq	%rax, %k2
# CHECK-NEXT:  1      1     0.33                        kmovq	%k0, %rax
# CHECK-NEXT:  1      1     0.33                        knotd	%k0, %k2
# CHECK-NEXT:  1      1     0.33                        knotq	%k0, %k2
# CHECK-NEXT:  1      1     0.33                        kord	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        korq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kortestd	%k0, %k2
# CHECK-NEXT:  1      1     0.33                        kortestq	%k0, %k2
# CHECK-NEXT:  1      1     1.00                        kshiftld	$2, %k1, %k2
# CHECK-NEXT:  1      1     1.00                        kshiftlq	$2, %k1, %k2
# CHECK-NEXT:  1      1     1.00                        kshiftrd	$2, %k1, %k2
# CHECK-NEXT:  1      1     1.00                        kshiftrq	$2, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        ktestd	%k0, %k2
# CHECK-NEXT:  1      1     0.33                        ktestq	%k0, %k2
# CHECK-NEXT:  1      1     1.00                        kunpckdq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     1.00                        kunpckwd	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kxnord	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kxnorq	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kxord	%k0, %k1, %k2
# CHECK-NEXT:  1      1     0.33                        kxorq	%k0, %k1, %k2
# CHECK-NEXT:  1      5     1.00                        vdbpsadbw	$0, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vdbpsadbw	$0, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    1.00    *                   vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    1.00    *                   vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vmovdqu8	%zmm16, %zmm19
# CHECK-NEXT:  1      7     0.50    *                   vmovdqu8	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00           *            vmovdqu8	%zmm16, (%rax)
# CHECK-NEXT:  1      1     0.50                        vmovdqu8	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      7     0.50    *                   vmovdqu8	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00           *            vmovdqu8	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      1     0.50                        vmovdqu8	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      7     0.50    *                   vmovdqu8	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vmovdqu16	%zmm16, %zmm19
# CHECK-NEXT:  1      7     0.50    *                   vmovdqu16	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00           *            vmovdqu16	%zmm16, (%rax)
# CHECK-NEXT:  1      1     0.50                        vmovdqu16	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  1      7     0.50    *                   vmovdqu16	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00           *            vmovdqu16	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      1     0.50                        vmovdqu16	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      7     0.50    *                   vmovdqu16	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpabsb	%zmm16, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpabsb	(%rax), %zmm19
# CHECK-NEXT:  1      1     0.50                        vpabsb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpabsb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpabsb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpabsb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpabsw	%zmm16, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpabsw	(%rax), %zmm19
# CHECK-NEXT:  1      1     0.50                        vpabsw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpabsw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpabsw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpabsw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpackssdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpackssdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpackssdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpackssdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpackssdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpackssdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpacksswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpacksswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpacksswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpacksswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpacksswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpacksswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpackusdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpackusdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpackusdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpackusdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpackusdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpackusdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpackuswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpackuswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpackuswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpackuswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpackuswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpackuswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpaddb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpaddb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpaddb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpaddsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpaddsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpaddsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpaddsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpaddsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpaddsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpaddusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpaddusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpaddusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpaddusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpaddusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpaddusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpaddw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpaddw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpaddw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpaddw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpaddw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpaddw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpalignr	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpalignr	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpavgb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpavgb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpavgb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpavgb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpavgb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpavgb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpavgw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpavgw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpavgw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpavgw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpavgw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpavgw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      2     1.00                        vpblendmb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      9     1.00    *                   vpblendmb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      2     1.00                        vpblendmb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  3      9     1.00    *                   vpblendmb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      2     1.00                        vpblendmb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  3      9     1.00    *                   vpblendmb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      2     1.00                        vpblendmw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      9     1.00    *                   vpblendmw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      2     1.00                        vpblendmw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  3      9     1.00    *                   vpblendmw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      2     1.00                        vpblendmw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  3      9     1.00    *                   vpblendmw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%xmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpbroadcastb	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%eax, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpbroadcastb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%eax, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpbroadcastb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastb	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%xmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpbroadcastw	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%eax, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpbroadcastw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%eax, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpbroadcastw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpbroadcastw	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpgtb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpgtb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpgtb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpgtb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpgtw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpgtw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpgtw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpgtw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpequb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpequb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpequb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpequb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpequw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpequw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpequw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpequw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.50                        vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      3     1.00                        vpextrb	$0, %xmm16, %eax
# CHECK-NEXT:  3      5     1.00           *            vpextrb	$0, %xmm16, (%rax)
# CHECK-NEXT:  2      3     1.00                        vpextrw	$0, %xmm16, %eax
# CHECK-NEXT:  3      5     1.00           *            vpextrw	$0, %xmm16, (%rax)
# CHECK-NEXT:  2      2     1.00                        vpinsrb	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vpinsrb	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  2      2     1.00                        vpinsrw	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  2      7     0.50    *                   vpinsrw	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  1      1     1.00                        vpermw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpermw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpermw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpermw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpermw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpermw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpermi2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpermi2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpermi2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpermi2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpermi2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpermi2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpermt2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpermt2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpermt2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpermt2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpermt2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpermt2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmaddubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vpmaddubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    1.00    *                   vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    1.00    *                   vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmaddwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vpmaddwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    1.00    *                   vpmaddwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    1.00    *                   vpmaddwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpmaxsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpmaxsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpmaxub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpmaxuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpmaxuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpmaxuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpminsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpminsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpminsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpminsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpminsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpminsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpminub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpminub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpminub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpminuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpminuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpminuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpminuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpminuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpminuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vpmovb2m	%zmm0, %k0
# CHECK-NEXT:  1      1     0.33                        vpmovw2m	%zmm0, %k0
# CHECK-NEXT:  1      1     0.50                        vpmovm2b	%k0, %zmm0
# CHECK-NEXT:  1      1     0.50                        vpmovm2w	%k0, %zmm0
# CHECK-NEXT:  1      1     1.00                        vpmovsxbw	%ymm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpmovsxbw	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpmovsxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpmovsxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpmovsxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpmovsxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpmovswb	%zmm16, %ymm19
# CHECK-NEXT:  2      8     1.00           *            vpmovswb	%zmm16, (%rax)
# CHECK-NEXT:  1      1     1.00                        vpmovswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      8     1.00           *            vpmovswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      1     1.00                        vpmovuswb	%zmm16, %ymm19
# CHECK-NEXT:  2      8     1.00           *            vpmovuswb	%zmm16, (%rax)
# CHECK-NEXT:  1      1     1.00                        vpmovuswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      8     1.00           *            vpmovuswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      1     1.00                        vpmovwb	%zmm16, %ymm19
# CHECK-NEXT:  2      8     1.00           *            vpmovwb	%zmm16, (%rax)
# CHECK-NEXT:  1      1     1.00                        vpmovwb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  2      8     1.00           *            vpmovwb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      1     1.00                        vpmovzxbw	%ymm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpmovzxbw	(%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpmovzxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpmovzxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpmovzxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpmovzxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmulhrsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vpmulhrsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    1.00    *                   vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    1.00    *                   vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmulhuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vpmulhuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    1.00    *                   vpmulhuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    1.00    *                   vpmulhuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmulhw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vpmulhw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpmulhw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    1.00    *                   vpmulhw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmulhw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    1.00    *                   vpmulhw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpmullw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vpmullw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     1.00                        vpmullw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    1.00    *                   vpmullw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     1.00                        vpmullw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    1.00    *                   vpmullw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     1.00                        vpsadbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    1.00    *                   vpsadbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpshufb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpshufb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpshufb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpshufb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpshufb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpshufb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpshufhw	$0, %zmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpshufhw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpshufhw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpshufhw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpshufhw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpshufhw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpshuflw	$0, %zmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpshuflw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpshuflw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpshuflw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpshuflw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpshuflw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpslldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpslldq	$1, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsllvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsllvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsllvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsllvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpsllvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsllvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpsllw	$0, %zmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsllw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsllw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsllw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpsllw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsllw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  2      4     1.00                        vpsllw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      11    1.00    *                   vpsllw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      4     1.00                        vpsllw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  3      11    1.00    *                   vpsllw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      4     1.00                        vpsllw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  3      11    1.00    *                   vpsllw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpsravw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsravw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsravw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsravw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpsravw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsravw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpsraw	$0, %zmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsraw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsraw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsraw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpsraw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsraw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  2      4     1.00                        vpsraw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      11    1.00    *                   vpsraw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      4     1.00                        vpsraw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  3      11    1.00    *                   vpsraw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      4     1.00                        vpsraw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  3      11    1.00    *                   vpsraw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpsrldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsrldq	$1, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsrlvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsrlvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsrlvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsrlvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpsrlw	$0, %zmm16, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpsrlw	$0, (%rax), %zmm19
# CHECK-NEXT:  1      1     1.00                        vpsrlw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpsrlw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpsrlw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpsrlw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  2      4     1.00                        vpsrlw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  3      11    1.00    *                   vpsrlw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      4     1.00                        vpsrlw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  3      11    1.00    *                   vpsrlw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      4     1.00                        vpsrlw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  3      11    1.00    *                   vpsrlw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpsubb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpsubb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpsubb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpsubsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpsubsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpsubsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpsubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpsubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpsubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpsubusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpsubusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpsubusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpsubusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpsubusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpsubusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.50                        vpsubw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     0.50    *                   vpsubw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     0.50                        vpsubw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     0.50    *                   vpsubw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     0.50                        vpsubw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     0.50    *                   vpsubw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     0.33                        vptestmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vptestmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.33                        vptestmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vptestmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.33                        vptestmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vptestmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.33                        vptestmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vptestmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.33                        vptestnmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vptestnmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.33                        vptestnmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vptestnmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     0.33                        vptestnmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  2      8     0.50    *                   vptestnmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  1      1     0.33                        vptestnmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  2      8     0.50    *                   vptestnmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  1      1     1.00                        vpunpckhbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpunpckhbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpunpckhwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpunpckhwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpunpcklbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpunpcklbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      1     1.00                        vpunpcklwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      8     1.00    *                   vpunpcklwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      1     1.00                        vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      8     1.00    *                   vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      1     1.00                        vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      8     1.00    *                   vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1} {z}

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SBDivider
# CHECK-NEXT: [1]   - SBFPDivider
# CHECK-NEXT: [2]   - SBPort0
# CHECK-NEXT: [3]   - SBPort1
# CHECK-NEXT: [4]   - SBPort4
# CHECK-NEXT: [5]   - SBPort5
# CHECK-NEXT: [6.0] - SBPort23
# CHECK-NEXT: [6.1] - SBPort23

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]
# CHECK-NEXT:  -      -     118.00 130.00 8.00   272.00 117.00 117.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6.0]  [6.1]  Instructions:
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kaddd	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kaddq	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kandd	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kandq	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kandnd	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kandnq	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kmovd	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   kmovd	(%rax), %k2
# CHECK-NEXT:  -      -      -      -     1.00    -     0.50   0.50   kmovd	%k0, (%rax)
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kmovd	%eax, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kmovd	%k0, %eax
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kmovq	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   kmovq	(%rax), %k2
# CHECK-NEXT:  -      -      -      -     1.00    -     0.50   0.50   kmovq	%k0, (%rax)
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kmovq	%rax, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kmovq	%k0, %rax
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     knotd	%k0, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     knotq	%k0, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kord	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     korq	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kortestd	%k0, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kortestq	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     kshiftld	$2, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     kshiftlq	$2, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     kshiftrd	$2, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     kshiftrq	$2, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     ktestd	%k0, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     ktestq	%k0, %k2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     kunpckdq	%k0, %k1, %k2
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     kunpckwd	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kxnord	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kxnorq	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kxord	%k0, %k1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     kxorq	%k0, %k1, %k2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vdbpsadbw	$0, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vdbpsadbw	$0, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vdbpsadbw	$0, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vdbpsadbw	$0, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vmovdqu8	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   vmovdqu8	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -     1.00    -     0.50   0.50   vmovdqu8	%zmm16, (%rax)
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vmovdqu8	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   vmovdqu8	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     1.00    -     0.50   0.50   vmovdqu8	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vmovdqu8	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   vmovdqu8	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vmovdqu16	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   vmovdqu16	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -     1.00    -     0.50   0.50   vmovdqu16	%zmm16, (%rax)
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vmovdqu16	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   vmovdqu16	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     1.00    -     0.50   0.50   vmovdqu16	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vmovdqu16	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -     0.50   0.50   vmovdqu16	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpabsb	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpabsb	(%rax), %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpabsb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpabsb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpabsb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpabsb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpabsw	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpabsw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpabsw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpabsw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpabsw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpabsw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackssdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackssdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackssdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackssdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackssdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackssdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpacksswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpacksswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpacksswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpacksswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpacksswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpacksswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackusdw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackusdw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackusdw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackusdw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackusdw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackusdw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackuswb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackuswb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackuswb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackuswb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpackuswb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpackuswb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpaddw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpaddw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpalignr	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpalignr	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpalignr	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpalignr	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpavgb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpavgb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpavgb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpavgb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpavgb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpavgb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpavgw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpavgw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpavgw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpavgw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpavgw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpavgw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -      -     vpblendmb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     1.00    -     1.00   0.50   0.50   vpblendmb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -      -     vpblendmb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     1.00    -     1.00   0.50   0.50   vpblendmb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -      -     vpblendmb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     1.00    -     1.00   0.50   0.50   vpblendmb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -      -     vpblendmw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     1.00    -     1.00   0.50   0.50   vpblendmw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -      -     vpblendmw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     1.00    -     1.00   0.50   0.50   vpblendmw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     1.00    -     1.00    -      -     vpblendmw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     1.00    -     1.00   0.50   0.50   vpblendmw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastb	%xmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpbroadcastb	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastb	%eax, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastb	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpbroadcastb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastb	%eax, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastb	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpbroadcastb	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastb	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastw	%xmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpbroadcastw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastw	%eax, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastw	%xmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpbroadcastw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastw	%eax, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastw	%xmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpbroadcastw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpbroadcastw	%eax, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpgtb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpgtb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpgtb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpgtb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpgtw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpgtw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpgtw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpgtw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpequb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpequb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpequb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpequb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpequw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpequw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpequw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpequw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpcmpeqw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpcmpeqw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpextrb	$0, %xmm16, %eax
# CHECK-NEXT:  -      -      -     0.50   1.00   0.50   0.50   0.50   vpextrb	$0, %xmm16, (%rax)
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpextrw	$0, %xmm16, %eax
# CHECK-NEXT:  -      -      -     0.50   1.00   0.50   0.50   0.50   vpextrw	$0, %xmm16, (%rax)
# CHECK-NEXT:  -      -      -     0.50    -     1.50    -      -     vpinsrb	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpinsrb	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  -      -      -     0.50    -     1.50    -      -     vpinsrw	$0, %eax, %xmm16, %xmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpinsrw	$0, (%rax), %xmm16, %xmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermi2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermi2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermi2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermi2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermi2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermi2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermt2w	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermt2w	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermt2w	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermt2w	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpermt2w	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpermt2w	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmaddubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmaddubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmaddubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmaddubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmaddwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmaddwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmaddwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmaddwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmaddwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpmaxuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpmaxuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminub	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminub	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminub	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminub	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminub	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminub	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpminuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpminuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vpmovb2m	%zmm0, %k0
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vpmovw2m	%zmm0, %k0
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vpmovm2b	%k0, %zmm0
# CHECK-NEXT:  -      -     0.50    -      -     0.50    -      -     vpmovm2w	%k0, %zmm0
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovsxbw	%ymm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovsxbw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovsxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovsxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovsxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovsxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovswb	%zmm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovswb	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovuswb	%zmm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovuswb	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovuswb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovuswb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovwb	%zmm16, %ymm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovwb	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovwb	%zmm16, %ymm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovwb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovzxbw	%ymm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovzxbw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovzxbw	%ymm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovzxbw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpmovzxbw	%ymm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpmovzxbw	(%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhrsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhrsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhrsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhrsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhuw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhuw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhuw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhuw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhuw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmulhw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmulhw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmullw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmullw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmullw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmullw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpmullw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpmullw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsadbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsadbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpshufb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpshufb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpshufb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpshufb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpshufb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpshufb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpshufhw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpshufhw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpshufhw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpshufhw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpshufhw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpshufhw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpshuflw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpshuflw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpshuflw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpshuflw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpshuflw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpshuflw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpslldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpslldq	$1, (%rax), %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsllvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsllvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsllvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsllvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsllvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsllvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsllw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsllw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsllw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsllw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsllw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsllw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsllw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsllw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsllw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsllw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsllw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsllw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsravw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsravw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsravw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsravw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsravw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsravw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsraw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsraw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsraw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsraw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsraw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsraw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsraw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsraw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsraw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsraw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsraw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsraw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpsrldq	$1, %zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpsrldq	$1, (%rax), %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsrlvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsrlvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsrlvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsrlvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsrlvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsrlw	$0, %zmm16, %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsrlw	$0, (%rax), %zmm19
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsrlw	$0, %zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsrlw	$0, (%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vpsrlw	$0, %zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00    -      -      -     0.50   0.50   vpsrlw	$0, (%rax), %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsrlw	%xmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsrlw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsrlw	%xmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsrlw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50    -      -     vpsrlw	%xmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     1.00   0.50    -     0.50   0.50   0.50   vpsrlw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubsb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubsb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubsb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubsb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubsb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubsb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubsw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubsw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubsw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubsw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubsw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubsw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubusb	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubusb	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubusb	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubusb	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubusb	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubusb	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubusw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubusw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubusw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubusw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubusw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubusw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -     0.50    -     0.50    -      -     vpsubw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -     0.50    -     0.50   0.50   0.50   vpsubw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestnmb	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestnmb	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestnmb	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestnmb	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestnmw	%zmm0, %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestnmw	(%rax), %zmm1, %k2
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33    -      -     vptestnmw	%zmm0, %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -     0.33   0.33    -     0.33   0.50   0.50   vptestnmw	(%rax), %zmm1, %k2 {%k3}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpckhbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpckhbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpckhbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpckhbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpckhwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpckhwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpckhwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpckhwd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpcklbw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpcklbw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpcklbw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpcklbw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpcklwd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpcklwd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     vpunpcklwd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -     1.00   0.50   0.50   vpunpcklwd	(%rax), %zmm17, %zmm19 {%k1} {z}
