/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.apache.turbine.util.Log;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.generic.GenericCalendarService;
import org.chefproject.util.Sql;
import org.chefproject.util.SqlReader;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Validator;
import org.chefproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CalendarContextConverter
implements Runnable {
    private String m_calendarTableName = null;
    private String m_eventTableName = null;
    private GenericCalendarService m_service = null;

    public CalendarContextConverter(String calendarTableName, String eventTableName, GenericCalendarService service) {
        this.m_calendarTableName = calendarTableName;
        this.m_eventTableName = eventTableName;
        this.m_service = service;
    }

    private void convertCalendars() {
        String sql = "select XML from " + this.m_calendarTableName;
        List records = Sql.dbRead(sql);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String oldId = null;
            String context = null;
            String id = null;
            try {
                String xml = (String)it.next();
                Document doc = Xml.readDocumentFromString(xml);
                Element root = doc.getDocumentElement();
                oldId = StringUtil.trimToNull(root.getAttribute("id"));
                context = StringUtil.trimToNull(root.getAttribute("context"));
                if (context != null) continue;
                String[] parts = StringUtil.splitFirst(oldId, "-");
                if (parts.length == 2) {
                    if ("group".equals(parts[0])) {
                        context = parts[1];
                        id = "main";
                    } else if ("user".equals(parts[0])) {
                        context = "~" + parts[1];
                        id = "main";
                    } else {
                        context = "!" + parts[0];
                        id = parts[1];
                    }
                } else {
                    context = "!site";
                    id = oldId;
                }
                Log.info("chef", " ** calendar: old id: " + oldId + " new context: " + context + " new id: " + id);
                root.setAttribute("id", id);
                root.setAttribute("context", context);
                xml = Xml.writeDocumentToString(doc);
                String ref = this.m_service.calendarReference(context, id);
                String statement = "update " + this.m_calendarTableName + " set" + " CALENDAR_ID = '" + Validator.escapeSql(ref) + "'," + " XML = ?" + " where ( CALENDAR_ID = '" + Validator.escapeSql(oldId) + "' )";
                boolean ok = Sql.dbWrite(statement, xml);
                if (ok) {
                    Log.info("chef", " ** calendar: " + ref + " record updated.");
                    continue;
                }
                Log.info("chef", " ** calendar: " + ref + " ERROR updating record.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting: " + oldId + " : " + e);
            }
        }
    }

    private void convertEvents() {
        String sql = "select CALENDAR_ID, EVENT_ID from " + this.m_eventTableName;
        List records = Sql.dbRead(sql, null, new SqlReader(){

            public Object readSqlResultRecord(ResultSet result) {
                try {
                    String cal = result.getString(1);
                    String ev = result.getString(2);
                    return new EventId(cal, ev);
                }
                catch (SQLException ignore) {
                    return null;
                }
            }
        });
        Iterator it = records.iterator();
        while (it.hasNext()) {
            String id = null;
            String context = null;
            EventId eid = (EventId)it.next();
            if (eid == null || eid.calendarId.startsWith("/")) continue;
            try {
                String[] parts = StringUtil.splitFirst(eid.calendarId, "-");
                if (parts.length == 2) {
                    if ("group".equals(parts[0])) {
                        context = parts[1];
                        id = "main";
                    } else if ("user".equals(parts[0])) {
                        context = "~" + parts[1];
                        id = "main";
                    } else {
                        context = "!" + parts[0];
                        id = parts[1];
                    }
                } else {
                    context = "!site";
                    id = eid.calendarId;
                }
                Log.info("chef", " ** message: old calendar id: " + eid.calendarId + " new context: " + context + " new id: " + id);
                String ref = this.m_service.calendarReference(context, id);
                String statement = "update " + this.m_eventTableName + " set" + " CALENDAR_ID = '" + Validator.escapeSql(ref) + "'" + " where ( CALENDAR_ID = '" + Validator.escapeSql(eid.calendarId) + "'" + " and EVENT_ID = '" + Validator.escapeSql(eid.eventId) + "' )";
                boolean ok = Sql.dbWrite(statement);
                if (ok) {
                    Log.info("chef", " ** message: " + eid.eventId + " calendar: " + ref + " record updated.");
                    continue;
                }
                Log.info("chef", " ** message: " + eid.eventId + " calendar: " + ref + " ERROR updating record.");
            }
            catch (Exception e) {
                Log.warn("chef", " ** exception while converting message: " + eid.calendarId + " : " + eid.eventId + " : " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.info("chef", " ** Converting calendars for context **");
        UsageSessionService.loginThreadUser("admin");
        try {
            this.convertCalendars();
            this.convertEvents();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            UsageSessionService.logoutThreadUser();
            throw throwable;
        }
        UsageSessionService.logoutThreadUser();
    }

    public static void convert(String calendarTableName, String eventTableName, GenericCalendarService service) {
        CalendarContextConverter converter = new CalendarContextConverter(calendarTableName, eventTableName, service);
        Thread thread = new Thread((Runnable)converter, "CalendarContextConverter");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
    }

    private class EventId {
        public String calendarId;
        public String eventId;

        public EventId(String cal, String ev) {
            this.calendarId = cal;
            this.eventId = ev;
        }
    }
}

