dnl Copyright 2025-2026 Free Software Foundation, Inc.
dnl This file is free software; the Free Software Foundation
dnl gives unlimited permission to copy and/or distribute it,
dnl with or without modifications, as long as this notice is preserved.
dnl This file is offered as-is, without any warranty.

# Check if it is possible to embed a Perl interpreter.  Set embedded_perl
# to "yes" or "no".

AC_DEFUN([txi_EMBEDDED_PERL],
[
  AC_MSG_CHECKING(for embedded Perl)
  saved_CPPFLAGS=$CPPFLAGS
  saved_CFLAGS=$CFLAGS
  saved_LDFLAGS=$LDFLAGS
  old_LIBS=$LIBS

  # corresponds to the ExtUtils::Embed ldopts corresponding to LIBS
  LIBS="$perl_conf_LIBS"

  # NOTE perl_conf_CPPFLAGS associated to perl_conf_CFLAGS
  # corresponds to the ExtUtils::Embed ccopts that contains
  # both preprocessor suited for CPPFLAGS and compiler flags, suited for CFLAGS.
  # We use the PERL_EXT_var user variables for Perl XS extensions to match
  # compilation rules.
  CPPFLAGS="$PERL_EXT_CPPFLAGS $perl_conf_CPPFLAGS"
  CFLAGS="$PERL_EXT_CFLAGS $perl_conf_CFLAGS"
  # contains ExtUtils::Embed ldopts corresponding to LDFLAGS.
  LDFLAGS="$PERL_EXT_LDFLAGS $perl_conf_LDFLAGS"

  # NOTE The tested code is a simplified version of
  # tta/C/convert/call_embed_perl.c
  # NOTE Code requiring ppport.h for pTHX_ and PERL_UNUSED_CONTEXT is
  # commented out.
  # We need to avoid Autoconf and Gnulib defines, as they clash with Perl
  # defines on some platforme.
  # Therefore AC_LINK_IFELSE cannot be used, as there is no way to avoid that
  # the source file also contains the results of all of the AC_DEFINE
  # performed so far.
  # https://lists.gnu.org/archive/html/autoconf/2025-01/msg00008.html
  # The shell code used is almost the same as the code generated by
  # by Autoconf 2.72 AC_LINK_IFELSE.  It relies on $ac_ext and
  # ac_fn_c_try_link Autoconf internal variable and function.
  dnl AC_LINK_IFELSE([[
  dnl use a single bracket to protect code, to protect brackets in code and
  dnl also do not get spurious brackets
  cat <<_ACEOF >conftest.$ac_ext
[
#define context perl_context

#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#undef context

static PerlInterpreter *my_perl;

EXTERN_C void xs_init (pTHX);

/*
EXTERN_C void boot_DynaLoader (pTHX_ CV* cv);
 */

EXTERN_C void
xs_init(pTHX)
{
    /*
    static const char file[] = __FILE__;
     */
    dXSUB_SYS;
    /*
    PERL_UNUSED_CONTEXT;

    newXS("DynaLoader::boot_DynaLoader", boot_DynaLoader, file);
     */
}

int
call_init_perl (int *argc_ref, char ***argv_ref, char ***env_ref)
{
  int parse_status, run_status;
  char *embedding[] = { "", NULL };
  PERL_SYS_INIT3 (argc_ref, argv_ref, env_ref);
  my_perl = perl_alloc();
  perl_construct(my_perl);
  PL_exit_flags |= PERL_EXIT_DESTRUCT_END;
  parse_status = perl_parse(my_perl, xs_init, 1, embedding, (char **)NULL);
  if (parse_status)
    return parse_status;
  run_status = perl_run(my_perl);
  if (run_status)
    return run_status;
  return 0;
}

void
call_finish_perl (void)
{
  perl_destruct(my_perl);
  perl_free(my_perl);
  PERL_SYS_TERM();
}

int
main (void)
{
 call_init_perl (0, 0, 0);
 call_finish_perl ();
 return 0;
}
]
_ACEOF

  if ac_fn_c_try_link "$LINENO"
  then
    embedded_perl=yes
  else
    embedded_perl=no
  fi

  rm -f core conftest.err conftest.$ac_objext conftest.beam \
    conftest$ac_exeext conftest.$ac_ext

dnl ]], [embedded_perl=yes], [embedded_perl=no])

  AC_MSG_RESULT($embedded_perl)
  LIBS=$old_LIBS
  CPPFLAGS=$saved_CPPFLAGS
  CFLAGS=$saved_CFLAGS
  LDFLAGS=$saved_LDFLAGS
])

