#!/usr/bin/env python

import os
from jupyterlab_server import LabServerApp

header = """\
.. _api-full-config:


Config file and command line options
====================================

The JupyterLab Server can be run with a variety of command line arguments.
A list of available options can be found below in the :ref:`options section
<options>`.

Defaults for these options can also be set by creating a file named
``jupyter_jupyterlab_server_config.py`` in your Jupyter folder. The Jupyter
folder is in your home directory, ``~/.jupyter``.

To create a ``jupyter_jupyterlab_server_config.py`` file, with all the defaults
commented out, you can use the following command line::

  $ python -m jupyterlab_server --generate-config


.. _options:

Options
-------

This list of options can be generated by running the following and hitting
enter::

  $ python -m jupyterlab_server --help-all

"""
# Handle local and RTD locations
cwd = os.getcwd()
if os.path.basename(cwd) == 'source':
    destination = os.path.join(cwd, 'api/app-config.rst')
else:
    destination = os.path.join(cwd, 'source/api/app-config.rst')

with open(destination, 'w') as f:
    f.write(header)
    f.write(LabServerApp().document_config_options())
