PROGRAM gen_fields
!
!****	gen_fields
!
!	Purpose:
!	--------
!	This program creates Oasis restart files
!       for the grids orca2, AT42REGU, BT42REDU and LMDZ
!       
!***	History:
!       -------
!       Version   Programmer      Date        Description
!       -------   ----------      ----        -----------
!         1.0   Sophie Valcke      ?           creation
!         2.0   Damien Declat  2002/07/02     SCRIP test
!         2.1   Sophie Valcke  2002/09/10     Added LMDZ
!*----------------------------------------------------------------
!
!** + Declarations
!
!
!** ++ modules and includes
!
!
  IMPLICIT NONE
  INCLUDE 'netcdf.inc'
!
!** ++ Variables
!
!** +++ 
!
  REAL(kind=8), PARAMETER    :: dp_4pir2=12.566371*6371229.**2 
  REAL(kind=8), PARAMETER    :: pi=3.14159265359
  REAL(kind=8), PARAMETER    :: pi2=2.0*pi
  REAL(kind=8), PARAMETER    :: dp_mis=9.99999932079947e+19
! degre -> radian conversion factor 
  REAL(kind=8), PARAMETER :: dp_conv = pi/180

  REAL(kind=8), PARAMETER   :: one = 1.
  REAL(kind=8), PARAMETER   :: two = 2.

!
!** +++ For Auxilary files
!
  CHARACTER(len=8)     :: cl_fldnam
  CHARACTER(len=14)    :: cl_NamFileIn
  CHARACTER(len=8)     :: cl_lonnam, cl_latnam

  INTEGER, PARAMETER   :: jpfld=5

  INTEGER, DIMENSION(jpfld) :: itorcid
  INTEGER, DIMENSION(jpfld) :: iat42id
  INTEGER, DIMENSION(jpfld) :: ibt42id
  INTEGER, DIMENSION(jpfld) :: ilmdzid

  INTEGER, DIMENSION(2)  :: ivardim
  INTEGER, DIMENSION(3)  :: il_Field_start
  INTEGER, DIMENSION(3)  :: il_Field_count
  INTEGER, DIMENSION(3)  :: il_Fieldo_start
  INTEGER, DIMENSION(3)  :: il_Fieldo_count
  INTEGER, DIMENSION(2)  :: il_start
  INTEGER, DIMENSION(2)  :: il_count

  INTEGER              :: ificid1,ificid2,ificid3
  INTEGER              :: il_isoncid, il_maskid
  INTEGER              :: length, toto
  INTEGER              :: il_Varid, ibou, ibou1, ibou2

!
!** +++ For the ORCA grid
!
  INTEGER, PARAMETER   :: jpio=182, jpjo=149, jptoto=jpio*jpjo

  REAL(kind=4), DIMENSION(jpio,jpjo,1)  :: rla_lonino, rla_latino
  REAL(kind=8), DIMENSION(jpio,jpjo)    :: rla_fieldo1, rla_fieldo2
  REAL(kind=8), DIMENSION(jpio,jpjo)    :: rla_fieldo3  
  REAL(kind=8), DIMENSION(jpio,jpjo)    :: rla_fieldo_tmp
  REAL(kind=8), DIMENSION(jpio,jpjo)    :: rla_lono, rla_lato

  INTEGER, DIMENSION(jpio,jpjo)      :: imaskt

  INTEGER              :: ijpiodimid, ijpjodimid
!
!** +++ For the AT42 grid
!
  INTEGER, PARAMETER   :: jpia=128, jpja=64, jptata=jpia*jpja

  REAL(kind=4), DIMENSION(jpia,jpja,1)  :: rla_lonina, rla_latina
  REAL(kind=8), DIMENSION(jpia,jpja)    :: rla_fielda1, rla_fielda2
  REAL(kind=8), DIMENSION(jpia,jpja)    :: rla_fielda3 
  REAL(kind=8), DIMENSION(jpia,jpja)    :: rla_fielda_tmp
  REAL(kind=8), DIMENSION(jpia,jpja)    :: rla_lona, rla_lata

!  INTEGER, DIMENSION(jpia,jpja)      :: imaska

  INTEGER              :: ijpiadimid, ijpjadimid
!
!** +++ For the BT42REDU grid
!
  INTEGER, PARAMETER :: jpib=6232, jpjb=1, jptotb=jpib*jpjb

  REAL(kind=4), DIMENSION(jpib,jpjb,1)  :: rla_loninb, rla_latinb
  REAL(kind=8), DIMENSION(jpib,jpjb)    :: rla_fieldb1, rla_fieldb2
  REAL(kind=8), DIMENSION(jpib,jpjb)    :: rla_fieldb3 
  REAL(kind=8), DIMENSION(jpib,jpjb)    :: rla_fieldb_tmp
  REAL(kind=8), DIMENSION(jpib,jpjb)    :: rla_lonb, rla_latb

  REAL(kind=8), DIMENSION(jpib, jpjb) :: zfld_b

  REAL(kind=8) :: dl_surface
  REAL(kind=8) :: zbid

!  INTEGER, DIMENSION (jpib, jpjb) :: imaskb

  INTEGER, DIMENSION (jpja) :: ninip

  INTEGER              :: ijpibdimid, ijpjbdimid

! Number of point for the jpja latitude circles for reduced atm
  DATA ninip /20,30,40,48,48,54,54,64,72,80,80,90,96,100,&
                  108,108,120,120,120,128,128,128,128,128,&
                  128,128,128,128,128,128,128,128,&
                  128,128,128,128,128,128,128,128,&
                  128,128,128,128,128,120,120,120,108,108,&
                  100,96,90,80,80,72,64,54,54,48,48,40,30,20/ 
!
!
!** +++ For the LMDZ grid
!
  INTEGER, PARAMETER :: jpiz=96, jpjz=72, jptotz=jpiz*jpjz

  REAL(kind=4), DIMENSION(jpiz,jpjz,1)  :: rla_loninz, rla_latinz
  REAL(kind=8), DIMENSION(jpiz,jpjz)    :: rla_fieldz1, rla_fieldz2
  REAL(kind=8), DIMENSION(jpiz,jpjz)    :: rla_fieldz3 
  REAL(kind=8), DIMENSION(jpiz,jpjz)    :: rla_fieldz_tmp
  REAL(kind=8), DIMENSION(jpiz,jpjz)    :: rla_lonz, rla_latz
  REAL(kind=8), DIMENSION(jpiz, jpjz) :: zfld_z
!  INTEGER, DIMENSION (jpiz, jpjz) :: imaskz
  INTEGER              :: ijpizdimid, ijpjzdimid
!
!*----------------------------------------------------------------
!
!
!
!*----------------------------------------------------------------
!
!** + Creation and initialisation of the "fieldaX.nc" auxilary files
!
!** ++ Create the file
!
  CALL hdlerr(NF_CREATE('flda1.nc', 0, ificid1))
!  PRINT *, '3.0 ificid1=', ificid1

!
!** ++ Create dimensions of the field
!
  CALL hdlerr(NF_DEF_DIM(ificid1, 'jpia', jpia, ijpiadimid))
!  PRINT *, '3.1 ijpiadimid=', ijpiadimid
  CALL hdlerr(NF_DEF_DIM(ificid1, 'jpja', jpja, ijpjadimid))
!  PRINT *, '3.2 ijpjadimid=', ijpjadimid

!
!** ++ Create the file
!
  CALL hdlerr(NF_CREATE('flda2.nc', 0, ificid2))
!  PRINT *, '3.3 ificid2=', ificid2

!
!** ++ Create dimensions of the field
!
  CALL hdlerr(NF_DEF_DIM(ificid2, 'jpia', jpia, ijpiadimid))
!  PRINT *, '3.4 ijpiadimid=', ijpiadimid
  CALL hdlerr(NF_DEF_DIM(ificid2, 'jpja', jpja, ijpjadimid))
!  PRINT *, '3.5 ijpjadimid=', ijpjadimid

!
!** ++ Create the file
!
  CALL hdlerr(NF_CREATE('flda3.nc', 0, ificid3))
!  PRINT *, '3.6 ificid3=', ificid3

!
!** ++ Create dimensions of the field
!
  CALL hdlerr(NF_DEF_DIM(ificid3, 'jpia', jpia, ijpiadimid))
!  PRINT *, '3.7 ijpiadimid=', ijpiadimid
  CALL hdlerr(NF_DEF_DIM(ificid3, 'jpja', jpja, ijpjadimid))
!  PRINT *, '3.8 ijpjadimid=', ijpjadimid

!
!** ++ Create the three fields
!
  ivardim(1)=ijpiadimid
  ivardim(2)=ijpjadimid

  CALL hdlerr(NF_DEF_VAR (ificid1, 'fielda_1', NF_DOUBLE, 2, ivardim, &
     iat42id(1)))
!  PRINT *, '3.9 iat42id(1)=', iat42id(1)
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid1,iat42id(1),'units',1,'C'))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid1,iat42id(1),'title',23, &
     'Sea Surface Temperature'))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid1,iat42id(1),'associate',9,'jpja jpia'))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid1,iat42id(1),'grid_type',1,'P'))
  CALL hdlerr(NF_PUT_ATT_INT (ificid1,iat42id(1),'overlap',NF_INT, 1,0))

  CALL hdlerr(NF_DEF_VAR (ificid2, 'fielda_2', NF_DOUBLE, 2, ivardim, &
     iat42id(2)))
!  PRINT *, '3.10 iat42id(2)=', iat42id(2)
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid2,iat42id(2),'units',1,' '))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid2,iat42id(2),'title',14, &
     'Sea-Ice Extent'))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid2,iat42id(2),'associate',9,'jpja jpia'))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid2,iat42id(2),'grid_type',1,'P'))
  CALL hdlerr(NF_PUT_ATT_INT (ificid2,iat42id(2),'overlap',NF_INT, 1,0))

  CALL hdlerr(NF_DEF_VAR (ificid3, 'fielda_3', NF_DOUBLE, 2, ivardim, &
     iat42id(3)))
!  PRINT *, '3.11 iat42id(3)=', iat42id(3)
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid3,iat42id(3),'units',1,' '))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid3,iat42id(3),'title',14, &
     'Surface Albedo'))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid3,iat42id(3),'associate',9,'jpja jpia'))
  CALL hdlerr(NF_PUT_ATT_TEXT (ificid3,iat42id(3),'grid_type',1,'P'))
  CALL hdlerr(NF_PUT_ATT_INT (ificid3,iat42id(3),'overlap',NF_INT, 1,0))

  CALL hdlerr(NF_DEF_VAR (ificid1, 'at42.lon', NF_DOUBLE, 2, ivardim, &
     iat42id(4)))
  CALL hdlerr(NF_DEF_VAR (ificid1, 'at42.lat', NF_DOUBLE, 2, ivardim, &
     iat42id(5)))
  CALL hdlerr(NF_DEF_VAR (ificid2, 'at42.lon', NF_DOUBLE, 2, ivardim, &
     iat42id(4)))
  CALL hdlerr(NF_DEF_VAR (ificid2, 'at42.lat', NF_DOUBLE, 2, ivardim, &
     iat42id(5)))
  CALL hdlerr(NF_DEF_VAR (ificid3, 'at42.lon', NF_DOUBLE, 2, ivardim, &
     iat42id(4)))
  CALL hdlerr(NF_DEF_VAR (ificid3, 'at42.lat', NF_DOUBLE, 2, ivardim, &
     iat42id(5)))
!
!** ++ Leave DEFINE mode for fieldo_x.nc netCDF Dataset
!
  call hdlerr(NF_ENDDEF(ificid2))
  call hdlerr(NF_ENDDEF(ificid1))
  call hdlerr(NF_ENDDEF(ificid3))

! 
!
!*----------------------------------------------------------------
!
!** + AT42 grid
!
!** ++ Read masks.nc to insure coherence
!
!  call hdlerr(NF_OPEN('masks.nc', NF_NOWRITE, il_maskid))
!  write(*,*) '4.0 il_maskid', il_maskid

!  il_start(1)=1
!  il_start(2)=1

!  il_count(1)=jpia
!  il_count(2)=jpja
!  CALL hdlerr(NF_INQ_VARID(il_maskid, 'at42_msk',il_Varid))
!  CALL hdlerr(NF_GET_VAR_INT (il_maskid, il_Varid, imaska))

!
!** + Define the longitude and the latitude of the at42 grid
!
  cl_NamFileIn="grids.nc"
  call hdlerr(NF_OPEN(cl_NamFileIn, NF_NOWRITE, il_isoncid))
!  write(*,*) '4.1 il_isoncid', il_isoncid
!  
  il_Field_start(1)=1
  il_Field_start(2)=1
  il_Field_start(3)=1
  il_Field_count(1)=jpia
  il_Field_count(2)=jpja
  il_Field_count(3)=1
!
  cl_lonnam="at42.lon" 
  write(*,*) '4.2 cl_lonnam ', cl_lonnam
  call hdlerr(NF_INQ_VARID(il_isoncid, cl_lonnam,il_Varid))
  write(*,*) '4.3 il_Varid', il_Varid
  call hdlerr(NF_GET_VAR_DOUBLE (il_isoncid, il_Varid, rla_lona))

!  rla_lona(:,:) = rla_lonina(:,:,1)

  cl_latnam="at42.lat" 
  write(*,*) '4.4 cl_latnam ', cl_latnam
  call hdlerr(NF_INQ_VARID(il_isoncid, cl_latnam,il_Varid))
  write(*,*) '4.5 il_Varid', il_Varid
  call hdlerr(NF_GET_VAR_DOUBLE (il_isoncid, il_Varid, rla_lata))

!  rla_lata(:,:) = rla_latina(:,:,1)

  call hdlerr(NF_CLOSE(il_isoncid)) 

!
!** + Generation of the fields
!
  rla_lata = rla_lata * dp_conv
  rla_lona = rla_lona * dp_conv
!
  length = 0.6*pi2
!
!** ++ Generation of fielda_1
!
  rla_fielda1 = COS(rla_lata)*COS(rla_lona)

  rla_fielda_tmp = ACOS(-rla_fielda1)/length

!  WHERE (rla_fielda_tmp .le. 1.d0)
      rla_fielda1(:,1:32) = two + COS(pi*rla_fielda_tmp(:,1:32))
      rla_fielda1(:,33:68) = 1.0 + COS(pi*rla_fielda_tmp(:,33:68))
!  ELSEWHERE
!      rla_fielda1 = 0.d0
!  END WHERE

!
!** ++ Generation of fielda_2
!
  rla_fielda2 = two + COS(rla_lata)**2*   &
     COS(two*rla_lona)

!
!** ++ Generation of fielda_3
!
  rla_fielda3 = two + SIN(two*rla_lata)**16*   &
     COS(16.*rla_lona)

!
!** ++ Apply the masks on the fields
!      
!  boutest3: DO ibou1=1,jpia
!    boutest4: DO ibou2=1, jpja
!      IF (imaska(ibou1,ibou2) .EQ. 1) THEN
!	  rla_fielda1(ibou1,ibou2) = 0.
!	  rla_fielda2(ibou1,ibou2) = 0.
!	  rla_fielda3(ibou1,ibou2) = 0.
!      ENDIF
!    ENDDO boutest4
!  ENDDO boutest3
  
!
!** + Write the fields
!
  PRINT *, '4.5 fielda_1'
  call hdlerr(NF_PUT_VAR_DOUBLE (ificid1, iat42id(1), rla_fielda1))
  PRINT *, '4.6 fielda_2'
  call hdlerr(NF_PUT_VAR_DOUBLE (ificid2, iat42id(1), rla_fielda2))
  PRINT *, '4.7 fielda_3'
  call hdlerr(NF_PUT_VAR_DOUBLE (ificid3, iat42id(1), rla_fielda3))

  rla_lata = rla_lata /dp_conv
  rla_lona = rla_lona /dp_conv
  call hdlerr(NF_PUT_VAR_DOUBLE (ificid1, iat42id(4), rla_lona))
  call hdlerr(NF_PUT_VAR_DOUBLE (ificid1, iat42id(5), rla_lata))

  call hdlerr(NF_PUT_VAR_DOUBLE (ificid2, iat42id(4), rla_lona))
  call hdlerr(NF_PUT_VAR_DOUBLE (ificid2, iat42id(5), rla_lata))

  call hdlerr(NF_PUT_VAR_DOUBLE (ificid3, iat42id(4), rla_lona))
  call hdlerr(NF_PUT_VAR_DOUBLE (ificid3, iat42id(5), rla_lata))
!
!** + Close netCDF Dataset
!
  call hdlerr(NF_CLOSE(ificid1)) 
  call hdlerr(NF_CLOSE(ificid2)) 
  call hdlerr(NF_CLOSE(ificid3)) 

!
!
!*----------------------------------------------------------------
!

  stop
  end
!
! 
!*----------------------------------------------------------------
!*----------------------------------------------------------------
!
!
  subroutine hdlerr(istatus)
  integer                 :: istatus
  include 'netcdf.inc'
  if (istatus .ne. NF_NOERR) then
      print *, NF_STRERROR(istatus)
      stop 'stopped'
  endif
  return
  end


