open StdLabels

module Ocaml_version : sig
  type t

  val v407 : t
  val current : t
  val compare : t -> t -> int
end = struct
  type t = int * int

  let parse s =
    try
      let d1 = String.index_from s 0 '.' in
      let d2 =
        try String.index_from s (d1 + 1) '.' with
        | Not_found -> String.length s
      in
      let p1 = int_of_string (String.sub s ~pos:0 ~len:d1) in
      let p2 = int_of_string (String.sub s ~pos:(d1 + 1) ~len:(d2 - d1 - 1)) in
      p1, p2
    with
    | _ -> failwith (Printf.sprintf "Invalid ocaml version %S" s)
  ;;

  let v407 = parse "4.07"
  let current = parse Sys.ocaml_version

  let compare ((a1, b1) : t) ((a2, b2) : t) =
    match compare a1 a2 with
    | 0 -> compare b1 b2
    | c -> c
  ;;
end

let () =
  let oc = stdout in
  let pr str = Printf.fprintf oc "%s\n" str in
  pr "(* This file is automatically generated *)";
  pr "";
  if Ocaml_version.compare Ocaml_version.current Ocaml_version.v407 < 0
  then (
    pr {|external get16 : bytes -> pos:int -> int = "%caml_string_get16"|};
    pr {|external set16 : bytes -> pos:int -> int -> unit = "%caml_string_set16"|})
  else (
    pr {|external get16 : bytes -> pos:int -> int = "%caml_bytes_get16"|};
    pr {|external set16 : bytes -> pos:int -> int -> unit = "%caml_bytes_set16"|})
;;
