// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomConvert_ApproxSurface_HeaderFile
#define _GeomConvert_ApproxSurface_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Geom_Surface.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Geom_BSplineSurface.hxx>
#include <Standard_Real.hxx>
#include <GeomAbs_Shape.hxx>
#include <Standard_Integer.hxx>
#include <Standard_OStream.hxx>
class Geom_Surface;
class Geom_BSplineSurface;
class Standard_OutOfRange;


//! A framework to convert a surface to a BSpline
//! surface. This is done by approximation to a BSpline
//! surface within a given tolerance.
class GeomConvert_ApproxSurface 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs a surface approximation framework defined by
  //! -   the conic Surf
  //! -   the tolerance value Tol3d
  //! -   the degree of continuity UContinuity, VContinuity
  //! in the directions of the U and V parameters
  //! -   the highest degree MaxDegU, MaxDegV which
  //! the polynomial defining the BSpline curve may
  //! have in the directions of the U and V parameters
  //! -   the maximum number of segments MaxSegments
  //! allowed in the resulting BSpline curve
  //! -   the index of precision PrecisCode.
  Standard_EXPORT GeomConvert_ApproxSurface(const Handle(Geom_Surface)& Surf, const Standard_Real Tol3d, const GeomAbs_Shape UContinuity, const GeomAbs_Shape VContinuity, const Standard_Integer MaxDegU, const Standard_Integer MaxDegV, const Standard_Integer MaxSegments, const Standard_Integer PrecisCode);
  
  //! Returns the BSpline surface resulting from the approximation algorithm.
  Standard_EXPORT   Handle(Geom_BSplineSurface) Surface()  const;
  
  //! Returns Standard_True if the approximation has be done
  Standard_EXPORT   Standard_Boolean IsDone()  const;
  
  //! Returns true if the approximation did come out with a result that
  //! is not NECESSARILY within the required tolerance or a result
  //! that is not recognized with the wished continuities.
  Standard_EXPORT   Standard_Boolean HasResult()  const;
  
  //! Returns the greatest distance between a point on the
  //! source conic surface and the BSpline surface
  //! resulting from the approximation (>0 when an approximation
  //! has been done, 0 if no  approximation )
  Standard_EXPORT   Standard_Real MaxError()  const;
  
  //! Prints on the stream o informations on the current state of the object.
  Standard_EXPORT   void Dump (Standard_OStream& o)  const;




protected:





private:



  Handle(Geom_Surface) mySurf;
  Standard_Boolean myIsDone;
  Standard_Boolean myHasResult;
  Handle(Geom_BSplineSurface) myBSplSurf;
  Standard_Real myMaxError;


};







#endif // _GeomConvert_ApproxSurface_HeaderFile
