/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_PowerSupplyAccess.h"

const string systemCreationClassName = "OpenDRIM_ComputerSystem";
const string creationClassName = "OpenDRIM_PowerSupply";
string systemName;

vector<system_power_supply> power;
vector< vector<string> > dmi_strings;

int PowerSupply_OpenDRIM_PowerSupply_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(systemName, errorMessage));
	CF_assert(SMBIOS_getPowerSupplyInformation(power, dmi_strings, errorMessage));
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_PowerSupply_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_PowerSupply_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_PowerSupply>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	for(unsigned int i=0;i<power.size();i++)
	{
		//Initialize an instance
		OpenDRIM_PowerSupply instance;
		instance.setSystemCreationClassName(systemCreationClassName);
		instance.setSystemName(systemName);
		instance.setCreationClassName(creationClassName);
		instance.setDeviceID(dmi_strings[i][power[i].device_name]);
	
		if(discriminant=="ei")
			CF_assert(PowerSupply_OpenDRIM_PowerSupply_populate(instance, i, errorMessage));
	
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int PowerSupply_OpenDRIM_PowerSupply_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_PowerSupply& instance, const char** properties, string& errorMessage) {
	_E_;
	for(unsigned int i=0;i<power.size();i++)
	{
		if (instance.SystemCreationClassName == systemCreationClassName &&
				instance.CreationClassName == creationClassName &&
				instance.SystemName == systemName &&
				instance.DeviceID == dmi_strings[i][power[i].device_name])
		{
			CF_assert(PowerSupply_OpenDRIM_PowerSupply_populate(instance, i, errorMessage));
			return OK;
		}
	
	}
	
	errorMessage = "Invalid path";
	_L_;
	return NOT_FOUND;
}

int PowerSupply_OpenDRIM_PowerSupply_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& newInstance, const OpenDRIM_PowerSupply& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_RequestStateChange_In& in, OpenDRIM_PowerSupply_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_SetPowerState_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_Reset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_EnableDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_EnableDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_OnlineDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_OnlineDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_QuiesceDevice(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, const OpenDRIM_PowerSupply_QuiesceDevice_In& in, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_SaveProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_RestoreProperties(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_PowerSupply& instance, unsigned int& returnValue, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int PowerSupply_OpenDRIM_PowerSupply_populate(OpenDRIM_PowerSupply& instance, int num, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] SystemCreationClassName  [KEY]
	 * [X] SystemName               [KEY]
	 * [X] CreationClassName        [KEY]
	 * [X] DeviceID                 [KEY]
	 * [X] TotalOutputPower
	 * [X] ElementName
	 * [X] OperationalStatus
	 * [X] HealthState
	 * [X] EnabledState
	 * [X] RequestedState
	 */
	
	stringstream elementName(stringstream::in | stringstream::out);
	vector<unsigned short> operationalStatus;
	u8 healthState=((power[num].power_supply_characteristics&0x380)>>7);
	
	if(!dmi_strings[num][power[num].manufacturer].empty())
		elementName << dmi_strings[num][power[num].manufacturer] << " ";
	
	elementName << instance.DeviceID;
	
	if(!dmi_strings[num][power[num].location].empty())
		elementName << " " << dmi_strings[num][power[num].location];
	
	instance.setElementName(elementName.str());
	
	if(power[num].max_power_capacity==0x8000)
		instance.setTotalOutputPower(0); // 0 - couln't find
	else
		instance.setTotalOutputPower(power[num].max_power_capacity);
	
	switch(healthState)
	{
		case 3: // 011b - OK
			instance.setHealthState(5);       // OK
			operationalStatus.push_back(2);   // OK
			break;
		case 4: // 100b - Non-critical
			instance.setHealthState(10);      // Degraded/Warning
			operationalStatus.push_back(3);   // Degraded
			break;
		case 5: // 101b - Critical, power supply has failed and has been taken off-line
			instance.setHealthState(25);      // Critical failure
			operationalStatus.push_back(5);   // Predictive Failure
			break;
		case 1: // 001b - Other
			operationalStatus.push_back(1);   // Other
		case 2: // 010b - Unknown
			operationalStatus.push_back(0);   // Unknown
		default:
			instance.setHealthState(0);       // Unknown
			if(operationalStatus.empty())
				operationalStatus.push_back(0); // Unknown
			break;
	}
	
	instance.setOperationalStatus(operationalStatus);
	
	//we don't support state Management
	instance.setEnabledState(5);    // Not applicable
	instance.setRequestedState(12); // Not applicable
	_L_;
	return OK;
}

