#ifndef PROXYSETTING_HH
#define PROXYSETTING_HH

#include "Setting.hh"

namespace openmsx {

class Reactor;

class ProxySetting final : public BaseSetting
{
public:
	ProxySetting(Reactor& reactor, string_ref name);

	void setValue(const TclObject& value) override;
	string_ref getTypeString() const override;
	string_ref getDescription() const override;
	const TclObject& getValue() const override;
	TclObject getDefaultValue() const override;
	TclObject getRestoreValue() const override;
	void setValueDirect(const TclObject& value) override;
	void tabCompletion(std::vector<std::string>& tokens) const override;
	bool needLoadSave() const override;
	bool needTransfer() const override;
	void setDontSaveValue(const TclObject& dontSaveValue) override;
	void additionalInfo(TclObject& result) const override;

private:
	BaseSetting* getSetting();
	const BaseSetting* getSetting() const;

	Reactor& reactor;
};

} // namespace openmsx

#endif
