//                                               -*- C++ -*-
/**
 *  @file  OT.hxx
 *  @brief The external header file of Open TURNS
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012)
 */

#ifndef OPENTURNS_OT_HXX
#define OPENTURNS_OT_HXX

/*
 * This include defines the configuration flags.
 */
#include "OTconfig.hxx"


/*
 * This include defines the debug level in all source code.
 */
#include "OTdebug.h"

/*
 * The OTtypes.hxx header file contains all type declarations used by
 * the Open TURNS platform.
 */
#include "OTtypes.hxx"

/*
 * The OTmemory.hxx header file declares some debugging memory functions
 */
#include "OTmemory.hxx"

/**
 * Here is the list of all classes belonging to the external API of Open TURNS
 * @todo List the classes belonging to the external API of Open TURNS
 */
#include "OTBase.hxx"
#include "OTUncertainty.hxx"

#endif /* OPENTURNS_OT_HXX */
