/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright (C) 2015-2016 Marvell International Ltd.
 */

#ifndef _COMPHY_DATA_H_
#define _COMPHY_DATA_H_

#define COMPHY_SPEED_1_25G		0
#define COMPHY_SPEED_2_5G		1
#define COMPHY_SPEED_3_125G		2
#define COMPHY_SPEED_5G			3
#define COMPHY_SPEED_5_15625G		4
#define COMPHY_SPEED_6G			5
#define COMPHY_SPEED_10_3125G		6
#define COMPHY_SPEED_MAX		7
#define COMPHY_SPEED_INVALID		0xff

#define COMPHY_TYPE_UNCONNECTED		0
#define COMPHY_TYPE_PEX0		1
#define COMPHY_TYPE_PEX1		2
#define COMPHY_TYPE_PEX2		3
#define COMPHY_TYPE_PEX3		4
#define COMPHY_TYPE_SATA0		5
#define COMPHY_TYPE_SATA1		6
#define COMPHY_TYPE_SGMII0		7
#define COMPHY_TYPE_SGMII1		8
#define COMPHY_TYPE_SGMII2		9
#define COMPHY_TYPE_USB3		10
#define COMPHY_TYPE_USB3_HOST0		11
#define COMPHY_TYPE_USB3_HOST1		12
#define COMPHY_TYPE_USB3_DEVICE		13
#define COMPHY_TYPE_RXAUI0		14
#define COMPHY_TYPE_RXAUI1		15
#define COMPHY_TYPE_SFI0		16
#define COMPHY_TYPE_SFI1		17
#define COMPHY_TYPE_AP			18
#define COMPHY_TYPE_IGNORE		19
#define COMPHY_TYPE_MAX			20
#define COMPHY_TYPE_INVALID		0xff

#define COMPHY_POLARITY_NO_INVERT	0
#define COMPHY_POLARITY_TXD_INVERT	1
#define COMPHY_POLARITY_RXD_INVERT	2
#define COMPHY_POLARITY_ALL_INVERT	\
	(COMPHY_POLARITY_TXD_INVERT | COMPHY_POLARITY_RXD_INVERT)

#define UTMI_PHY_TO_USB3_HOST0		0
#define UTMI_PHY_TO_USB3_HOST1		1
#define UTMI_PHY_TO_USB3_DEVICE0	2
#define UTMI_PHY_INVALID		0xff

#endif /* _COMPHY_DATA_H_ */
