/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

// Define an Interface Guid for HECI device class.
// This GUID is used to register (IoRegisterDeviceInterface)
// an instance of an interface so that user application
// can control the HECI device.
//

// GUID definition are required to be outside of header inclusion pragma to avoid
// error during precompiled headers.
//


#ifndef __INTRFACE_H__
#define __INTRFACE_H__

//#if (_WIN32_WINNT == 0x0500)
    typedef unsigned char   UINT8, *PUINT8;
    typedef char            INT8, *PINT8;
    typedef UINT8 UCHAR;
    typedef unsigned short  UINT16, *PUINT16;
//#endif
typedef enum _HECI_STATUS{

	HECI_STATUS_OK		= 0x0,
	HECI_STATUS_GENERAL_ERROR	= 0x2000,
    HECI_STATUS_LOCATE_DEVICE_ERROR,
	HECI_STATUS_MEMORY_ACCESS_ERROR,
	HECI_STATUS_WRITE_REGISTER_ERROR,
    HECI_STATUS_MEMORY_ALLOCATION_ERROR,
    HECI_STATUS_BUFFER_OVEREFLOW_ERROR,
    HECI_STATUS_NOT_ENOUGH_MEMORY,
    HECI_STATUS_MSG_TRANSMISSION_ERROR,
    HECI_STATUS_VERSION_MISMATCH,
    HECI_STATUS_UNEXPECTED_INTERRUPT_REASON,
    HECI_STATUS_TIMEOUT_ERROR,
    HECI_STATUS_UNEXPECTED_RESPONSE,
    HECI_STATUS_UNKNOWN_MESSAGE,
    HECI_STATUS_CANNOT_FOUND_HOST_CLIENT,
    HECI_STATUS_CANNOT_FOUND_ME_CLIENT,
    HECI_STATUS_CLIENT_ALREADY_CONNECTED,
    HECI_STATUS_NO_FREE_CONNECTION,
    HECI_STATUS_ILLEGAL_PARAMETER,
    HECI_STATUS_FLOW_CONTROL_ERROR,
    HECI_STATUS_NO_MESSAGE,
    HECI_STATUS_BUFFER_TOO_LARGE,
    HECI_STATUS_BUFFER_TOO_SMALL,
    HECI_STATUS_BUFFER_NOT_EMPTY,
    NUM_OF_HECI_STATUSES
}HECI_STATUS;

//  {E2D1FF34-3458-49A9-88DA-8E6915CE9BE5}
//DEFINE_GUID(GUID_DEVINTERFACE_HECI, 0xE2D1FF34, 0x3458, 0x49A9,0x88, 0xDA, 0x8E, 0x69, 0x15, 0xCE, 0x9B, 0xE5);
//DEFINE_GUID(HECI_PTHI,0x12F80028,0xB4B7,0x4b2d,0xAC,0xA8,0x46,0xE0,0xFF,0x65,0x81,0x4c);
//DEFINE_GUID(FW_UPDATE_GUID,0x309dcde8, 0xccb1, 0x4062,0x8f, 0x78, 0x60, 0x1, 0x15, 0xa3, 0x43, 0x27);


const GUID	HECI_PTHI 	= {0x12f80028, 0xb4b7, 0x4b2d, {0xac, 0xa8, 0x46, 0xe0, 0xff, 0x65, 0x81, 0x4c}};

//const GUID	HECI_PTHI 	= {0x309dcde8, 0xccb1, 0x4062,{0x8f, 0x78, 0x60, 0x1, 0x15, 0xa3, 0x43, 0x27}};//0x12f80028, 0xb4b7, 0x4b2d, {0xac, 0xa8, 0x46, 0xe0, 0xff, 0x65, 0x81, 0x4c}};

#define FILE_DEVICE_HECI  0x8000

// Define Interface reference/dereference routines for
// Interfaces exported by IRP_MN_QUERY_INTERFACE

#define HECI_IOCTL(index) \
    CTL_CODE(FILE_DEVICE_HECI, index, METHOD_BUFFERED, FILE_READ_DATA)

#define IOCTL_HECI_GET_VERSION \
    CTL_CODE(FILE_DEVICE_HECI, 0x800, METHOD_BUFFERED, FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_HECI_CONNECT_CLIENT \
    CTL_CODE(FILE_DEVICE_HECI, 0x801, METHOD_BUFFERED, FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_HECI_WD \
    CTL_CODE(FILE_DEVICE_HECI, 0x802, METHOD_BUFFERED, FILE_READ_ACCESS|FILE_WRITE_ACCESS)

#pragma pack(1)
typedef struct _HECI_VERSION
{
    UINT8 major;
    UINT8 minor;
    UINT8 hotfix;
    UINT16 build;
} HECI_VERSION;

typedef struct _HECI_CLIENT
{
    unsigned int            MaxMessageLength;
    UINT8                   ProtocolVersion;
} HECI_CLIENT;


#pragma pack( )


#endif // __INTRFACE_H__
