/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.utils;

import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class ResourcesManager
implements Serializable {
    private ResourceBundle resources;

    public ResourcesManager(String string) {
        try {
            this.resources = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(string + ".properties not found");
            System.exit(1);
        }
    }

    public String getResourceString(String string) {
        String string2;
        try {
            string2 = this.resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = null;
        }
        return string2;
    }

    public String[] getResourceStrings(String string) {
        return this.tokenize(this.getResourceString(string));
    }

    private String[] tokenize(String string) {
        if (string != null) {
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            String[] stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
            return stringArray;
        }
        return new String[0];
    }
}

